<?php
/**
 * 仓库接口
 *
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Repository\Interfaces;

use Closure;

interface WareHouseInterface
{
    /**
     * 获取仓库列表
     * @param array $params
     * @return array|mixed
     */
    public function getWareHouses($params);

    /**
     * 获取仓库详细内容
     * @param integer $Id 订单数据
     * @return array|mixed
     */
    public function getByID($Id);

    /**
     * 根据订单编号获取订单详细内容
     * @param integer $Id 订单NO
     * @param array $para 条件
     * @return array|false
     */
    public function getGoods($Id, $para);

    /**
     * 创建新订单
     * @param mixed $data 仓库数据
     * @param Closure $callBack 钩子函数
     *
     * @return mixed 仓库id或者生成失败false
     */
    public function create($data, Closure $callBack);

    /**
     * 更新仓库详细内容
     * @param integer $ID 仓库id
     * @param array $data 仓库数据
     * @param Closure $callBack 仓库生成后续操作
     * @return bool
     */
    public function update($ID, $data, Closure $callBack);

    /**
     * 对仓库进行操作动作
     * @param string $event 进行的操作
     * @param integer $ID 操作仓库id
     * @param array $data 仓库数据
     * @param Closure $callBack 订单生成后续操作
     * @return bool
     */
    public function event($event, $ID, $data, Closure $callBack);

    /**
     * 获取仓库详细内容
     * @param integer $ID 仓库id
     * @param Closure $callBack 仓库生成后续操作
     * @return bool
     */
    public function delete($ID, Closure $callBack);
}
