<?php

namespace App\Models;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class OrderList extends Model
{
    //指定表名
    protected $table ='order_list';
    // 拒绝添加的字段
    protected $guarded = [];
    public $timestamps=false;
    public function user(){
        return $this->hasOne(User::class,'id','customer_id');//->select('id','shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress','car_make','car_line','car_model');
    }
    public function ordermsg(){
        return $this->hasOne(OrderMsg::class,'id','order_goods_id')->select('id','goods_name','goods_num','goods_price','goods_brand','goods_number');
    }
    public function pt(){
        return $this->hasOne(Pt::class,'id','p_id')->select('id','pt_name');
    }
    public function admin(){
        return $this->hasOne(Admin::class,'id','ser_id')->select('id','company_name');
    }
}
