<?php

namespace App\Http\Controllers\User;

use Illuminate\Http\Request;
use DB;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Controllers\BaseController;

/**
 * Class MyInfoController 个人资料修改
 * @package App\Http\Controllers\Admin
 */
class MyInfoController extends BaseController
{
    /**
     * @name 修改个人资料
     * @param type 1:获取展示信息 2：执行修改
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/10
     */
    public function personal(Request $request){
        if(!$request->filled('type')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $type = (int)$request->input('type',1);
        if($type==1){
            //获取用户登录名 和用户名   电话  QQ
            $id = $request->get('session_token')['id'];  //根据 登录人的id 获取电话  QQ
            $user = Db::table('admin_infor')->where('admin_id',$id)->select('phone','qq')->first();
            $admin = DB::table('admin')->where('id',$id)->select('admin_acc','admin_name')->first();
            $user['admin_acc'] = $admin['admin_acc'];
            $user['admin_name'] = $admin['admin_name'];
            return $this->success('获取成功',$user);
        }elseif($type==2){
            Db::beginTransaction();
            $res = false;
            $res1 = false;
            $res2 = false;
            $admin_id = $request->get('session_token')['id'];
            //密码是否重复
            $old_pwd = $request->input('old_pwd'); //原密码
            $pwd    =$request->input('pwd');     //新密码
            $pwded  =$request->input('pwded');   //重复新密码
            $name   =$request->input('admin_name');    //姓名
            $phone  =$request->input('phone');   //电话
            $qq     =$request->input('qq');      //QQ

            //校验密码格式
            if($request->filled('old_pwd') || $request->filled('pwd') || $request->filled('pwded')){

                $session_pwd = $request->get('session_token')['admin_password'];
                if($session_pwd != md5($old_pwd)){
                    return $this->error('原密码与旧密码不一致', ErrorInc::MYSQL_FAILED);exit;
                }
                if(!preg_match('/^(\w*(?=\w*\d)(?=\w*[A-Za-z])\w*){6,16}$/',$pwd)){
                    return $this->error('新密码由6-16位字符（英文/数字/符号）至少两种或下划线组合', ErrorInc::MYSQL_FAILED);exit;
                }
                if($pwd != $pwded){
                    return $this->error('两次输入的新密码不一致', ErrorInc::MYSQL_FAILED);exit;
                }
                $res = Db::table('admin')->where('id',$admin_id)->update(['admin_password'=>md5($pwd)]);
            }else{
                $res = true;
            }
            $yname = DB::table('admin')->where('id',$admin_id)->value('admin_name');
            if ($yname != $name){
                $res2 = DB::table('admin')->where('id',$admin_id)->update(['admin_name'=>$name]);
            }else{
                $res2 = true;
            }
            //更改 手机 或qq 信息
            $user = Db::table('admin_infor')->where('admin_id',$admin_id)->select('phone','qq')->first();
            if($user['phone'] != $phone || $user['qq'] != $qq){
                $res1 = Db::table('admin_infor')->where('admin_id',$admin_id)->update(['phone'=>$phone,'qq'=>$qq]);
            }else{
                $res1 = true;
            }
            if($res && $res1 && $res2){
                Db::commit();
                return $this->success('操作成功');exit;
            }else{
                Db::rollBack();
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
    }


}
