<?php
/*
|--------------------------------------------------------------------------
| 奖惩标签及奖惩金额管理(原 “基础数据/奖惩金额管理” ，对服务商需要做出处罚奖赏的标签依据及金额)
|--------------------------------------------------------------------------
|  增删改查
|  @author liXiaoLin
|  @Date: 2021/7/27
|  @Time: 10:07
|  @Email: lixiaolin@bluearp.com
|  @version 1.0
|  @copyright BlueCity
*/

namespace App\Http\Controllers\Service;

use App\Http\Controllers\BaseController;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Traits\CurdControllerMethod;
use Illuminate\Http\Request;
use App\Services\MoneyTypesService;
use Illuminate\Support\Facades\DB;

class SetMoneyTypeController extends BaseController
{
    public $dataService = null;  // CurdControllerMethod 必备参数
    public $dataFields = ['sety_name', 'sety_price'];  // 保存和修改时的 fields 参数
    protected $validateRules = [
        'rules' => [
            'sety_name' => 'required|max:50',
            'sety_price' => 'required'
        ],
        'messages' => [

        ],
        'attributes' => [
            'sety_name' => '奖惩金名称',
            'sety_price' => '奖惩金额'
        ]
    ];

    public function __construct()
    {
        $service = new MoneyTypesService();
        $this->bootWithService($service);
    }

    use CurdControllerMethod;

    /**
     * @api {post} /api/service/setMoneyType 列表页
     * @apiGroup 奖惩金额
     * @apiName 列表页
     * @apiVersion 1.0.0
     *
     * @apiDescription 接口描述
     *
     * @apiParam {String} type_name 类别名称
     * @apiParam {int} page_size  页大小
     * @apiParam {int} page  页码
     * @apiParam {string} token token
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {
        "ErrorCode": 1,
        "ErrorMessage": "成功",
        "data": {
        "page": {//页码数据
        "page": 1,    //当前页码
        "page_size": 20,//每页显示条数
        "count": 479     //总条数
        },
        "list": [ //数据
        {
        "sety_id": 19,           //id
        "sety_name": "结算补贴",  //类别名称
        "sety_price": "1"        //价格
        }
        ]
        }
        }
     *
     *
     */

    /**
     * @api {post} /api/service/setMoneyType/store 添加奖惩金额
     * @apiGroup 奖惩金额
     * @apiName 添加奖惩金额
     * @apiVersion 1.0.0
     *
     * @apiDescription 新增
     *
     * @apiParam {string}sety_name  类别名称
     * @apiParam sety_price 奖惩金额
     * @apiParam {string} token token
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {
        "ErrorCode": 1,
        "ErrorMessage": "添加成功",
        "data":''
        }
     *
     */

    private function _beforeStore($request) {
        $input = $request->only('sety_name', 'sety_price');

        if ($this->validateRules) {
            $validate = validator()->make($input, $this->validateRules['rules'], $this->validateRules['messages'], $this->validateRules['attributes']);
            if ($validate->fails()) {
                $error = CommonService::validatorToString($validate);
                return $this->error($error, ErrorInc::INVALID_PARAM);
            }
        }
        $where[] = ['sety_name', '=', $request->get('sety_name')];
        if (MoneyTypesService::checkExist($where)) {
            return $this->error('数据已经存在', ErrorInc::DATA_EXIST);
        }

        return false;
    }

    private function _setStore($input) {
        $ins = [];
        $ins['sety_name'] = $input['sety_name'];
        $ins['sety_price'] = $input['sety_price'];
        $ins['sety_type'] = 1;
        $ins['sety_creacter']=Request()->get('session_token')['admin_acc'];

        return $ins;
    }

    private function _afterStore($entity) {
        $ip = Request()->ip();
        $creatorID = Request()->get('session_token')['admin_acc'];
        $content = '添加奖惩类别,类别名称：'.$entity['sety_name'].'，补贴金额：'.$entity['sety_price'];
        $this->insertingLog('添加', '', $content, '奖惩金额管理', $ip, $creatorID);
    }

    /**
     * @api {post} /api/service/setMoneyType/update 编辑奖惩金额
     * @apiGroup 奖惩金额
     * @apiName 编辑奖惩金额
     * @apiVersion 1.0.0
     *
     * @apiDescription 新增
     *
     * @apiParam {int} id  数据ID
     * @apiParam {string} sety_name  类别名称
     * @apiParam sety_price 奖惩金额
     * @apiParam {string} token token
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {
        "ErrorCode": 1,
        "ErrorMessage": "添加成功",
        "data":''
        }
     *
     */

    private function _beforeUpdate($request, $id) {
        $where[] = ['sety_id', '!=', $id];
        $where[] = ['sety_name', '=', $request->get('sety_name')];
        if (MoneyTypesService::checkExist($where)) {
            return $this->error('数据已经存在', ErrorInc::DATA_EXIST);
        }

        return false;
    }

    private function _setUpdate($input) {
        $ins = [];
        $ins['sety_name'] = $input['sety_name'];
        $ins['sety_price'] = $input['sety_price'];

        return $ins;
    }


    private function _afterUpdate($entity, $beforeData = []) {
        $ip = Request()->ip();
        $creatorID = Request()->get('session_token')['admin_acc'];
        $content = '编辑奖惩类别；类别名称：'.$beforeData['sety_name'].'，补贴金额：'.$beforeData['sety_price'].'->类别名称：'.$entity['sety_name'].'-补贴金额：'.$entity['sety_price'];
        $this->insertingLog('编辑，', '', $content, '奖惩金额管理', $ip, $creatorID);
    }

    /**
     * @api {post} /api/service/setMoneyType/delete 删除奖惩金额
     * @apiGroup 奖惩金额
     * @apiName 删除奖惩金额
     * @apiVersion 1.0.0
     *
     * @apiDescription 删除奖惩金额
     *
     * @apiParam {int} id  数据ID
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {
        "ErrorCode": 1,
        "ErrorMessage": "删除成功",
        "data":''
        }
     *
     */

}
