<?php
/*
|--------------------------------------------------------------------------
| 签约合同及服务管理
|--------------------------------------------------------------------------
|
| 签约合同查寻、审核、驳回、续签、终止
|
*/

namespace App\Http\Controllers\Service;

use App\Services\ContractsService;
use BlueCity\Core\Traits\CurdControllerMethod;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\CoreController as Controller;

class ContractsController extends Controller
{
    public $dataService = null;  // CurdControllerMethod 必备参数
    public $dataFields = ['pt_name', 'sord', 'pt_other','pt_zt', 'model_id', 'p_oname', 'p_paytype', 'three_pd', 'bus_type'];  // 保存和修改时的 fields 参数
    protected $validateRules = [
        'rules'=>[
            'pt_name'=>'required|max:50',
            'sord'=>'required|alpha',
            'pt_zt'=>'required|in:1,2',
            'bus_type'=>'required|in:1,2',
        ],
        'messages'=>[
            'in'=>':attribute 选择错误'
        ],
        'attributes'=>[
            'pt_name'=>'平台名称',
            'sord'=>'首字母',
            'pt_zt'=>'状态',
            'bus_type'=>'业务类型',
        ]
    ];

    public function __construct()
    {
        $service = new ContractsService();
        $this->bootWithService($service);
    }

    use CurdControllerMethod;
    /**
     * @api {get} /api/service/contracts 签约管理
     * @apiGroup contracts
     * @apiName 服务商签约
     * @apiVersion 1.0.0
     *
     * @apiDescription 管理服务商与平台的签约流程，根据条件查询
     *
     * @apiParam {String} keyword  公司名称
     * @apiParam {int} serviceType  含服务类型
     * @apiParam {array} serviceItem  含服务项目
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":["file_id":1]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"ErrorCode":5001,"ErrorMessage":"接口异常","Data":[]}
     *
     */



    private function _setStore($data) {
        return $this->_setData($data);
    }

    private function _setUpdate($data) {
        return $this->_setData($data);
    }

    private function _setData($data) {


        return $data;
    }


    /**
     * @api {get} /api/service/contracts/{id}/approved 签约审核
     * @apiGroup contracts
     * @apiName 服务商签约
     * @apiVersion 1.0.0
     *
     * @apiDescription 接口描述
     *
     * @apiParam {int} id  合同ID
     * @apiParam {String} comment 审核描述
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":["file_id":1]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"ErrorCode":5001,"ErrorMessage":"接口异常","Data":[]}
     *
     */
    public function approved(int $id) {

    }

    /**
     * @api {get} /api/service/contracts/{id}/reject 签约驳回
     * @apiGroup contracts
     * @apiName 服务商签约
     * @apiVersion 1.0.0
     *
     * @apiDescription 签约内容或时间有误，管理员驳回
     *
     * @apiParam {int} id  合同ID
     * @apiParam {String} comment  驳回原因
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":["file_id":1]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"ErrorCode":5001,"ErrorMessage":"接口异常","Data":[]}
     *
     */
    public function reject (int $id){

    }

    /**
     * @api {get} /api/service/contracts/{id}/renewal 合同续约
     * @apiGroup contracts
     * @apiName 服务商签约
     * @apiVersion 1.0.0
     *
     * @apiDescription 平台与服务商继续延长合同期限
     *
     * @apiParam {int} id  合同ID
     * @apiParam {String} comment 续约描述原因
     * @apiParam {String} expires 续约时间
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":["file_id":1]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"ErrorCode":5001,"ErrorMessage":"接口异常","Data":[]}
     *
     */
    public function renewal (int $id) {
        //续约的流程
    }

    /**
     * @api {get} /api/service/contracts/{id}/discharge 解除合同
     * @apiGroup contracts
     * @apiName 服务商签约
     * @apiVersion 1.0.0
     *
     * @apiDescription 平台与服务方解除合同的操作
     *
     * @apiParam {int} id  合同ID
     * @apiParam {String} comment  解除原因
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":["file_id":1]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"ErrorCode":5001,"ErrorMessage":"接口异常","Data":[]}
     *
     */
    public function discharge  (int $id) {
        //解除合同流程
    }
}
