<?php

namespace App\Http\Controllers\orders;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Common\CommonController;
use App\Models\AdminInfor;
use App\Models\GoodCode;
use App\Models\PjGoods;
use App\Models\User;
use App\Services\GoodsService;
use App\Services\OrderaddService;
use App\Services\OrderService;
use App\Services\PlatformService;
use App\Services\UserService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Excel;

use App\Models\Admin;
use App\Services\SendGoodsService;
use App\Models\SendGoods;
use App\Services\CommonService;
use App\Models\OrderMsg;
use BlueCity\Data\Service\ZhiPei\OrderService as zhiPeiOrder;

class SendGoodsController extends BaseController
{
	/**
	 * @name  发货列表
     * @param order_num       平台单号
     * @param name          商品名称
     * @param stores        收货门店名称
     * @param goods_id   商品id
	 * @param Request $request
	 * @return \BlueCity\Core\Controllers\mixed
	 * @author du 2021年8月14日下午2:28:12
	 */
     public function index (Request $request)
    {
    	$input = $request->all();
    	$session_token = $request->get('session_token');
    	$list = SendGoodsService::getList($input,$session_token);
        //导出 start
        if ($input['is_excel'] == 1) {
            $sqls = $list['sqls'];
            $excel = new CommonController();
            return $excel->getExcelOut($input['Pri_id'], $sqls, $session_token);
        }
        unset($list['sqls']);
        //导出 end
    	if($list['list']){
    		return $this->success('获取成功', $list); exit;
    	}else{
    		return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
    	}
    }

    /**
     * @name  处理发货
     * @param id 数据ID
     * @param order_num       平台单号
     * @param name          商品名称
     * @param stores        门店名称
     * @param send_type        发货类型1自有门店发货2库房发货
     * @param goods_id   商品id
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du 2021年8月14日下午3:49:10
     */
    public function sendGoodsDo(Request $request){
    	$input = $request->only('id','order_num','store_id','send_num','msg_id');
        $checkKey = CommonService::checkKey(['id','order_num','store_id','send_num','msg_id'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }

        $id = intval($request->input('id'));
        $order_num = $request->input('order_num');
        $store_id = intval($request->input('store_id'));
        $send_num = $request->input('send_num');
        $msg_id = $request->input('msg_id');
        $where['msg_id'] = $msg_id;
        $where['send_num'] = $send_num;
        DB::beginTransaction(); //开启事务
        $data['send_time'] = date('Y-m-d H:i:s');
        $arr['type'] = 2;
        if($request->filled('send_type')){
            $arr['send_type'] = $request->input('send_type');
        }
        $arr['store_id'] = $store_id;
        $res = Db::table('send_goods')->where($where)->update($arr);
        $type = Db::table('send_goods')->where('send_num',$send_num)->pluck('type')->toArray();
        $data['stores'] = $store_id;
        $data['type'] = 2;
       if(in_array('1',$type) && !in_array('2',$type)){
            $data['type'] = 1;
           //$ret = SendGoods::where('send_num',$send_num)->update($data);//type 处理状态  1待处理 2处理中 3已完成
        }elseif(!in_array('1',$type) && in_array('2',$type)){
            $data['type'] = 3;
           //$ret = SendGoods::where('send_num',$send_num)->update($data);//type 处理状态  1待处理 2处理中 3已完成
        }
        $ret = SendGoods::where('send_num',$send_num)->update($data);

        if($res && $ret){
        	DB::commit(); //提交
          $this->insertingLog("发货列表" ,$order_num, "发货"."(".$send_num.")","发货列表",$request->ip(),$request->get('session_token')['admin_acc']);
          return $this->success('操作成功');exit;
        }else{
        	DB::rollback();//回滚
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  查看图片
     * @param id       数据ID
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月14日下午4:14:10
     */
    public function seePicture(Request $request){
    	if(!$request->filled('id')){
    		return $this->error('参数错误无ID', ErrorInc::FAILED_PARAM, []);exit;
    	}
        $id = intval($request->input('id'));
        $res = SendGoods::where('id',$id)->value('photo');
        $res = explode(",", $res);
        if($res){
        	return $this->success('获取成功',$res);exit;
        }else{
        	return $this->error('暂无数据',ErrorInc::DATA_EMPTY);exit;
        }
    }

   /**
    * @name  上传图片
    * @param id       数据ID
    * @param image    图片数组
    * @param send_num　发货单号
    * @param order_num 平台单号
    * @param request $request
    * @return \BlueCity\Core\Controllers\mixed
    * @author du 2021年8月14日下午4:50:57
    */
    public function addPhoto(request $request){
    	if(!$request->filled('id')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
        $id = intval($request->input('id'));
        $send_num = $request->input('send_num');
        $order_num = $request->input('order_num');
        $pic[] = $request->input('image');
        $picStr = implode(',',$pic);
        $res = SendGoods::where('id',$id)->update(['photo'=>$picStr]);
        if($res){
         $this->insertingLog("上传图片" ,$order_num, "发货单号"."(".$send_num.")","发货列表",$request->ip(),$request->get('session_token')['admin_acc']);
            return $this->success('操作成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  筛选发货商品
     * @param id       数据ID
     * @param order_num       平台单号
     * @param sys_num       系统单号
     * @param type          未发货状态
     * @param request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月16日上午10:11:59
     */
 /*    public function selectGoods(request $request){
    	if(!$request->filled('id')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$id = intval($request->input('id'));
    	$sys_num = $request->input('sys_num');
    	$db = new OrderMsg();
    	$msg = CommonService::getMysqlData($db, ['sys_num'=>$sys_num],['goods_name','goods_id','id']);
        $send_goods = Db::table('send_goods')->where('pid',$id)->where('type',"!=",'5')->select('goods_name','goods_id','msg_id')->get()->toArray();
        $data['msg_goods'] = $msg;
        $data['send_goods'] = $send_goods;
    	if($data){
        	return $this->success('获取成功',$data);exit;
        }else{
        	return $this->error('暂无数据',ErrorInc::DATA_EMPTY);exit;
        }
    }
      */
    /**
     * @name  驳回操作
     * @param id       商品数据id
     * @param pid  发货单ID
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月14日下午5:05:28
     */
    public function reject(Request $request){
        if(!$request->filled('id')||!$request->filled('send_num')||!$request->filled('order_num')||!$request->filled('send_type')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
        $id = intval($request->input('id'));
        $send_num = $request->input('send_num');
        $order_num = $request->input('order_num');
        $goods_name = $request->input('goods_name');
        $pid = intval($request->input('pid'));
        $send_type = intval($request->input('send_type'));
        DB::beginTransaction();
        $data = SendGoodsService::reject($id, $send_num, $order_num, $goods_name, $pid, $send_type, $request->get('session_token'), $request->ip());
        if($data['ErrorCode'] != 1){
            DB::rollback();
        }else{
            DB::commit();
        }
        return $this->error($data['ErrorMessage'], $data['ErrorCode']);exit;
//        if($send_type==1){
//            $ret = Db::table('send_goods')->where('id',$id)->update(['reject'=>5,'type'=>5]);
//            $res = Db::table('send_goods')->where('pid',$pid)->where('reject',1)->select('id')->get();
//            if(count($res)==0){
//                $re = SendGoods::where('id',$pid)->update(['reject'=>5,'type'=>5]);
//            }
//        }elseif($send_type==2){
//            $res =  SendGoods::where('id',$pid)->update(['reject'=>5,'type'=>5]);
//            $ret =  Db::table('send_goods')->where('pid',$pid)->update(['reject'=>5,'type'=>5]);
//        //同步智配 start
//            if($ret) {
//                $warehouse_num = SendGoods::where('id',$pid)->value('warehouse_num');
//                $zhipeinum = $warehouse_num;//库房同步单号
//                $zres = zhiPeiOrder::cancelShipping($zhipeinum);//发货取消
//                //dump($zres);
//                if ($zres['code'] != '200') {
//                    DB::rollback();
//                    return $this->error('同步失败:' . $zres['msg'], ErrorInc::MYSQL_FAILED);
//                    exit;
//                }
//            }
//        }else{
//            return $this->error('$msg', ErrorInc::FAILED_PARAM);exit;
//        }
//        if($ret){
//          	$this->insertingLog("驳回", $order_num, "驳回" . $send_num, "发货列表".$goods_name, $request->ip(), $request->get('session_token')['admin_acc']);//日志
//
//            //同步结束 end
//            DB::commit();
//        	return $this->success('操作成功');exit;
//        }else{
//            DB::rollback();
//            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
//        }
    }

   /**
    * 获取可驳回的商品
    * @param Request $request
    * @return \BlueCity\Core\Controllers\mixed
    * @author du 2021年8月17日上午11:17:36
    */
    public function getRejectGoods(Request $request){
    	if(!$request->filled('id')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$id = intval($request->input('id'));
    	$db = Db::table('send_goods');
    	$select = ['id','pid','goods_id','goods_name','send_num','order_num'];
    	$list = CommonService::getMysqlData($db, ['pid'=>$id,'type'=>1,'reject'=>1,'recover'=>0],$select);
    	if($list){
    		return $this->success('获取成功',$list);exit;
    	}else{
    		return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
    	}
    }

    /**
     * @name 获取地址
     * @param id       数据id
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed
     * @author du 2021年8月16日下午2:51:42
     */
    public function editAdress(Request $request){
    	if(!$request->filled('id')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$id = intval($request->input('id'));
        $res = SendGoodsService::getInfoBy('id', $id);
        if($res){
        	return $this->success('获取成功',$res);exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  编辑收货信息提交
     * @param id       数据ID
     * @param order_num       平台单号
     * @param name          商品名称
     * @param stores        门店名称
     * @param goods_id   商品id
     * @param Request $request
     * @return \BlueCity\Core\Controllers\mixed|\Illuminate\Http\JsonResponse
     * @author du 2021年8月14日下午5:43:57
     */
    public function editAdressDo(Request $request){
    	if(!$request->filled('id')||!$request->filled('data')){
    		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
    	}
    	$id = intval($request->input('id'));
        $send_num = $request->input('send_num');
        $order_num = $request->input('order_num');
        $data = $request->input('data');
        $res = SendGoods::where('id',$id)->update($data);
        if($res){
           $this->insertingLog("编辑收货信息",$order_num, "编辑收货信息" . $send_num, "发货列表", $request->ip(), $request->get('session_token')['admin_acc']);//日志
        	return $this->success('操作成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * @name  获取可追回商品
     * @param send_num       发货单号
     * @param id       数据ID
     * @param recover 0可追回商品,1待追回
     * @param request $request
     * @return \Illuminate\Http\JsonResponse
     * @author du 2021年8月14日下午5:47:51
     */
      public function recoverGoods(request $request){
      	if(!$request->filled('id')||!$request->filled('recover')){
      		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
      	}
      	$id = $request->input('id');
      	$recover = intval($request->input('recover'));
      	$db = Db::table('send_goods');
      	$data = CommonService::getMysqlData($db,['pid'=>$id,'recover'=>$recover,'type'=>2],['goods_id','send_num','type','recover','sys_num','goods_name']);
      if($data){
      		return $this->success('操作成功',$data);exit;
        }else{
            return $this->error('无数据', ErrorInc::MYSQL_FAILED);exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name  获取可处理结果商品
     * @param send_num       发货单号
     * @return \Illuminate\Http\JsonResponse
     *  <2020>
     * |---------------------------------------------------------------------------------
     */
//       public function recoverGoodsResults(request $request){
//       $data = Db::table('send_goods')->where('send_num',$request->input('send_num'))->where('recover','=','1')->select('goods_id','send_num','type','sys_num','goods_name')->get();
//       if($data){
//           return response()->json(['ErrorCode'=>1,'ErrorMessage'=>"操作成功",'Data'=>$data]);exit;
//       }else{
//           return response()->json(['ErrorCode'=>2,'ErrorMessage'=>"无可处理追回商品",'Data'=>'']);exit;
//       }
//     }


    /**
     * @name  追回处理
     * @param id       数据ID
     * @param send_num       发货单号
     * @param goods_id   商品id
     * @param money   邮费
     * @param request $request
     * @return \BlueCity\Core\Controllers\mixed|\Illuminate\Http\JsonResponse
     * @author du 2021年8月16日上午9:49:59
     */
      public function recoverDo(request $request){
      	if(!$request->filled('id')){
      		return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
      	}
      	$id = intval($request->input('id'));
	    $update['recover'] = intval($request->input('recover'));
	    $money = $request->input('money');
	    $goods = $request->input('goods');
      	foreach ($goods as $key => $value) {
      	    $data = Db::table('send_goods')->where('pid',$id)->where('goods_id',$value['goods_id'])->update($update);
            CommonService::accMe($request->input('sys_num'), "发货列表" , "追回原因：".$request->input('note')."商品名称：".$value['goods_name']."邮费：".$money, '', '', $request->get('session_token')['admin_groupnew'], $request->get('session_token')['admin_acc'], $request->get('session_token')['id']);
     	 }
      $type = Db::table('send_goods')->where('pid',$id)->pluck('recover')->toArray();

      if(in_array('1',$type)){
            $recover['recover'] = '1';
          $res = SendGoods::where('id',$id)->update($recover);
        }elseif(in_array('2',$type) && in_array('3',$type) && !in_array('1',$type)){
            $recover['recover'] = '2';
          $res = SendGoods::where('id',$id)->update($recover);
        }elseif(in_array('2',$type) && !in_array('1',$type) && !in_array('3',$type)){
            $recover['recover'] = '2';
          $res = SendGoods::where('id',$id)->update($recover);
        }elseif(in_array('3',$type) && !in_array('1',$type) && !in_array('2',$type)){
            $recover['recover'] = '3';
          $res = SendGoods::where('id',$id)->update($recover);
        }
      if($data){
      		return $this->success('操作成功',$data);exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加订单
     * @name 添加订单
     * @param sys_bh 系统单号
     * @param skb_bh 平台单号
     * @param pt_id  平台id
     * @param ser_type  服务类型 1：上门安装；2：到店服务
     * @param shr_name 客户姓名
     * @param shr_phone 客户电话
     * @param shr_sheng 省
     * @param shr_shi 市
     * @param shr_xian 县
     * @param shr_adress 详细地址
     * @param shr_other  客户留言
     * @param car_audit  已可派单 1：否(默认) 2：是
     * @param order_type  1：正常；10：夜间；15:40分钟；20：60分钟；25:90分钟；30：两小时
     * @param goods (array)
     * @param goods_id 商品id(goods)
     * @param goods_name 商品品牌(goods)
     * @param goods_price 商品价格(goods)
     * @param goods_num 商品数量(goods)
     * @param goods_number 	 商品编号(goods)
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2021/11/21 13:40
     * |---------------------------------------------------------------------------------
    */
    public function addOrder (Request $request){
        $input = $request->only('sys_bh','skb_bh','pt_id','ser_type','shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress','shr_other','car_audit','order_type','goods','order_time','pay_type','shr_other','id');//指定需获取字段

        $checkKey = CommonService::checkKey(['sys_bh','skb_bh','id','pt_id','goods'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }

        $sendInfo = SendGoodsService::getInfoBy('id',$input['id'],['add_order']);
        if($sendInfo==1){
            return $this->error('数据已添加', ErrorInc::MYSQL_FAILED);exit;
        }

        $input['skb_bh'] = CommonService::restrict($input['skb_bh']);//过滤平台单号在复制时产生的回车、制表符等被忽略的特殊符号

        $session = $request->get('session_token');//获取操作人信息
        $return = OrderaddService::addOrder($input, $session, $request->ip());
        if($return['ErrorCode']==1){
            SendGoods::where('id',$input['id'])->update(['add_order'=>1]);
        }
        $this->insertingLog("发货添加订单，",$input['sys_bh'],"发货添加订单","发货列表", $request->ip(),$session['admin_acc']);
        return $this->error($return['ErrorMessage'], $return['ErrorCode']);

    }

    /**
     * @编辑快递信息
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/12
     */
    public function editCourier(Request $request){
        if(!$request->filled('courier_number')||!$request->filled('courier_company')||!$request->filled('id')){
            return $this->error('参数错误请填写快递单号或快递公司', ErrorInc::FAILED_PARAM, []);exit;
        }
        $courier_number = $request->input('courier_number');
        $courier_company = $request->input('courier_company');
        $id = intval($request->input('id'));
        $r = DB::table('send_goods')->where('id',$id)->where('type',2)->value('order_num');
        if(!$r){
            return $this->error('不存在已发货商品订单', ErrorInc::FAILED_PARAM, []);exit;
        }
        $ret = DB::table('send_goods')->where('id',$id)->where('courier_number',$courier_number)->where('courier_company',$courier_company)->value('id');
        if($ret){
            return $this->error('已存在', ErrorInc::FAILED_PARAM, []);exit;
        }

        $res = DB::table('send_goods')->where('id',$id)->update(['courier_number'=>$courier_number,'courier_company'=>$courier_company]);
        if($res){
            $this->insertingLog("编辑快递信息",$r, "编辑快递信息：" .$courier_company."-". $courier_number, "发货列表", $request->ip(), $request->get('session_token')['admin_acc']);//日志
            return $this->success('操作成功',$res);exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }

    /**
     * ser_type:服务类型 1：上门安装；2：到店服务
     * collect_type:收货类型 门店发货 1 客户收货2
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/25
     */
    public function getOrderSendInfo(Request $request){
        if(!$request->filled('id')){
            return $this->error('参数错误ID不能为空', ErrorInc::FAILED_PARAM, []);exit;
        }
        $id = intval($request->input('id'));
        $sendInfo = SendGoodsService::getInfoBy('id',$id,['id','category','order_num','collect_type','name','telephone','address','warehouse_num','add_order']);
        if(empty($sendInfo)){
            return $this->error('无数据', ErrorInc::MYSQL_FAILED);exit;
        }
        if(empty($sendInfo['warehouse_num'])){
            return $this->error('数据异常', ErrorInc::MYSQL_FAILED);exit;
        }
        if($sendInfo['add_order']==1){
            return $this->error('数据已添加', ErrorInc::MYSQL_FAILED);exit;
        }
        if($sendInfo['category']!=3){
            return $this->error('订单类型不正确', ErrorInc::MYSQL_FAILED);exit;
        }
        $orderInfo = OrderService::getOrderBy('order_num', $sendInfo['order_num'],['p_id','ser_type','new_customer_id','pay_type']);
        $orderInfo['sys_bh'] = 'L'.date("YmdHis").str_pad(rand(0,999),3,'0',STR_PAD_LEFT);
        $sendInfo['OrdeInfo'] = $orderInfo;

        if($sendInfo['collect_type']==1){
            $userInfo = UserService::getUserBy('id', $orderInfo['new_customer_id'],['shr_name','shr_phone','shr_sheng','shr_shi','shr_xian','shr_adress']);
            $sendInfo['name'] = $userInfo['shr_name'];
            $sendInfo['telephone'] = $userInfo['shr_phone'];
            $sendInfo['address'] = $userInfo['shr_sheng'].$userInfo['shr_shi'].$userInfo['shr_xian'].$userInfo['shr_adress'];
        }

        $res = DB::table('send_goods')->where('pid',$id)->select('goods_id','goods_num','goods_name')->get()->toarray();
        $pg_ids = array_unique(array_column($res, 'goods_id'));

        $goodsInfo = GoodsService::getGoodsByKey('pg_id',$pg_ids);
        foreach ($goodsInfo as $k =>$v){
            $goodsInfo[$k]['goods_brand'] = $v['brand_name'];
            $goodsInfo[$k]['goods_name'] = $v['good_name'];

        }
        $sendInfo['goods'] = $goodsInfo;
        foreach ($res as $k =>$v){
            $sendInfo['goods'][$k]['goods_num'] = $v['goods_num'];
            $sendInfo['goods'][$k]['goods_price'] = 0;
            $sendInfo['goods'][$k]['goods_id'] = $v['goods_id'];

        }
        if(empty($sendInfo['goods'])){
            return $this->error('无商品', ErrorInc::MYSQL_FAILED);exit;
        }
        unset($sendInfo['order_num']);
        unset($sendInfo['category']);
        unset($sendInfo['OrdeInfo']['new_customer_id']);

        $session_token = $request->get('session_token');
        $sendInfo['ser_type'] = OrderService::showSerType($session_token['admin_groupnew']);
        $sendInfo['pay_type'] = OrderService::showPayType($session_token['admin_groupnew']);
        $sendInfo['order_type'] = OrderService::showOrderType($session_token['admin_groupnew']);
        $sendInfo['default'] = OrderService::getOldpt($session_token['id']);

        return $this->success('获取成功',$sendInfo);
    }


    /**
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/1/26
     */
    public function mate (Request $request)
    {
        if (!$request->filled('goods_id') || !$request->filled('brand_name') || !$request->filled('goods_number') || !$request->filled('cd_id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);
        }
        $goods_number = $request->input('goods_number');
        $db = new OrderMsg();
        $goods_price = CommonService::getMysqlData($db,['goods_id'=>$request->input('goods_id')],['goods_price'],['creator_time'=>'DESC'],'value');
        $caps['goods_id'] = $request->input('goods_id');
        $caps['goods_brand'] = $request->input('brand_name');
        $caps['goods_number'] = substr($goods_number,strpos($goods_number,"-")+1);
        //$caps['goods_number'] = ltrim($request->input('goods_number'),$caps['goods_brand'].'-');
        $caps['goods_name'] = $request->input('goods_number');
        $caps['goods_num'] = 1;
        $caps['cd_id'] = $request->input('cd_id');

        if($goods_price){
            $caps['goods_price'] = $goods_price;
        }else{
            $caps['goods_price'] = 0;
        }
        $caps = mb_convert_encoding($caps, 'UTF-8', 'UTF-8');
        return $this->success('成功', $caps);
    }

    /**|---------------------------------------------------------------------------------
     * @name 发货单审核
     * @param int id 数据id
     * @param string content 审核备注
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2022/3/4 16:42
     * |---------------------------------------------------------------------------------
    */
    public function auditSend ( Request $request ){
        if($request->filled('id')){
            $id = $request->input('id');
            $db = new SendGoods();
            $sendorder = CommonService::getMysqlData($db, ['id'=>$id],[],[],'first');
            if($sendorder) {
                if ($sendorder['type'] == 4) {
                    DB::beginTransaction();
                    if($request->filled('content')) {
                        CommonService::accMe($sendorder['sys_num'], "发货列表", "审核发货：" . $request->input('content'), '', '', $request->get('session_token')['admin_groupnew'], $request->get('session_token')['admin_acc'], $request->get('session_token')['id']);
                    }
                    $res = SendGoods::where('id',$id)->update(['type'=>1]);
                    if($res) {
                        $goodb = DB::table('send_goods');
                        $sendgood = CommonService::getMysqlData($goodb, ['pid' => $id]);
                        $zhipeinum = $sendorder['warehouse_num'];
                        /*---------------------------------------------获取平台信息开始--------------------------------------*/
                        $order = OrderService::getOrderBy('order_num', $sendorder['order_num'], ['p_id','new_customer_id']);
                        $p_id = PlatformService::getPtBy('id', $order['p_id'], ['zp_id']);
                        if (!$p_id) {
                            return ['Data' => '', 'ErrorMessage' => '未匹配平台编号', 'ErrorCode' => ErrorInc::TRANSFER_FAILED];
                        }
                        /*---------------------------------------------获取平台信息结束--------------------------------------*/
                        $zdata = ['p_id' => $p_id, 'company_id' => 1, 'ware_id' => 4, 'shr_other' => $sendorder['send_note'], 'new_money' => '0'];
                        /*--------------------------------------------获取商品信息开始-------------------------------------*/
                        foreach ($sendgood as $k => $v) {
                            $goods[$k]['goods_num'] = $v['goods_num'];
                            $goods[$k]['goods_id'] = GoodCode::where('pgc_pgid', $v['goods_id'])->value('pgc_code');//'wj0001';
                            $msg_goods_price = OrderMsg::where('sys_num', $sendorder['sys_num'])->where('goods_id', $v['goods_id'])->value('goods_price');
                            $goods[$k]['goods_price'] = $msg_goods_price ?? '0';//
                            $goods[$k]['goods_remarks'] = $sendorder['send_note'];
                        }

                        if($sendorder['collect_type']==1){
                            $adminInfo = AdminInfor::where('admin_id',$sendorder['store_id'])->select('service_name','phone','admin_province','admin_city','admin_county','admin_dressi')->first();
                            $company_name = Admin::where('id',$sendorder['store_id'])->value('company_name');
                            // dump($adminInfo);
                            $shr_name = $company_name??'无';
                            $shr_phone = $adminInfo['phone'];
                            if(!$adminInfo['phone']||!$adminInfo['admin_province']||!$adminInfo['admin_city']||!$adminInfo['admin_county']||!$adminInfo['admin_dressi']){
                                return  ['Data' => '','ErrorMessage'=>'门店信息不完善','ErrorCode'=>ErrorInc::FAILED_PARAM];
                            }
                            $shr_sheng = $adminInfo['admin_province'];
                            $shr_shi = $adminInfo['admin_city'];
                            $shr_xian = $adminInfo['admin_county'];
                            $shr_adress = $adminInfo['admin_dressi']??'无';
                        }elseif ($sendorder['collect_type']==2){
                            if($sendorder['shr_sheng'] =='' && $sendorder['shr_shi'] =='' && $sendorder['shr_xian'] ==''){
                                $usr = [];
                                $usr['shr_sheng'] = $sendorder['sheng'];
                                $usr['shr_shi'] = $sendorder['shi'];
                                $usr['shr_xian'] = $sendorder['xian'];
                            }else {
                                $usr = User::where('id', $order['new_customer_id'])->select('shr_sheng', 'shr_shi', 'shr_xian')->first();
                            }
                            $shr_name = $sendorder['name'];
                            $shr_phone = $sendorder['telephone'];
                            $shr_sheng = $usr['shr_sheng'];
                            $shr_shi = $usr['shr_shi'];
                            $shr_xian = $usr['shr_xian'];
                            $shr_adress = $sendorder['address'];
                        }else{
                            DB::rollback();//回滚
                            return $this->error('collect_type参数错误', ErrorInc::FAILED_PARAM);exit;
                        }
                        $userInfo = ['shr_name' => $shr_name, 'shr_phone' => $shr_phone, 'shr_sheng' => $shr_sheng, 'shr_shi' => $shr_shi, 'shr_xian' => $shr_xian, 'shr_adress' => $shr_adress];
                        $res = zhiPeiOrder::orderPut($zhipeinum, $zdata, $goods, $userInfo);
//                        $res = [];
//                        $res['code'] = 200;
                        $logdata = json_encode($zdata) . '-' . json_encode($goods) . '-' . json_encode($userInfo) . '-' . json_encode($res);
                        CommonService::addLog('同步发货单', $logdata, $zhipeinum, 'SendGoods');
                        if ($res['code'] != '200') {
                            DB::rollback();//回滚
                            return $this->error('同步失败:' . $res['msg'] . $res['data'], ErrorInc::MYSQL_FAILED);exit;
                        }
                        DB::commit(); //提交
                        return  $this->success('操作成功');exit;
                    }else{
                        DB::rollback();//回滚
                        return $this->error('数据不存在', ErrorInc::MYSQL_STEP_FAILED);exit;
                    }
                } else {
                    return $this->error('发货单状态错误', ErrorInc::REPEAT_SUBMIT);
                    exit;
                }
            }else{
                return $this->error('数据不存在', ErrorInc::DATA_EMPTY);exit;
            }

        }else{
            return $this->error('缺少参数id', ErrorInc::FAILED_PARAM);exit;
        }
    }
}
