<?php
namespace App\Http\Controllers\ExcelInfo;
use App\Exports\BasicExport;
use App\Http\Controllers\BaseController;
use App\Models\Admin;
use App\Models\AdminKhacclist;
use App\Models\AdminKhaccount;
use App\Models\CategoryName;
use App\Models\Disareanew;
use App\Models\Pt;
use App\Models\Refund;
use App\Models\SetmoneyType;
use App\Models\SettlementList;
use App\Services\AdminService;
use App\Services\CategoryService;
use App\Services\CommonService;
use App\Services\EventGiftService;
use App\Services\ExceloutService;
use App\Services\F6StoreOrderService;
use App\Services\GoodsBrandsService;
use App\Services\OrderListService;
use App\Services\OrderService;
use App\Services\PjBrandsService;
use App\Services\RecycleOrderService;
use App\Services\RefundService;
use App\Services\ServiceProviderService;
use App\Services\SettlementThreeService;
use App\Services\SubmitPleaseService;
use Illuminate\Http\Request;
use DB;
use Chumper\Zipper\Zipper;
use Excel;
use BlueCity\Core\Inc\ErrorInc;

/**
 * @name excel导出管理
 * Class ExceloutController
 * @package App\Http\Controllers\Excelout
 */
class ExceloutController extends BaseController
{

    private $excelOut ;
    public function __construct(){
        $this->excelOut = new ExceloutService();
    }
    /**
     * @name 执行数据
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     * @author du
     * @date 2021/8/25
     */
	public function execExcelOut(Request $request){
		if(!$request->filled('el_id')){
		    return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
		}
		$id = intval($request->input('el_id'));
		$res = DB::table("excel_list")
				->where('el_id',$id)
				->where('el_state','1')
				->select("el_action","el_id","el_sql","el_path","el_item","el_adminid","company_id")
				->orderBy('el_id','ASC')->first();

		if($res){
			if (!file_exists($res['el_path'])) {
				// 创建文件夹
				mkdir($res['el_path'],0775,true);
				chmod($res['el_path'],0775);
			}
			$api_name = "perform".$res['el_action'];
			$api_name = (string)$api_name;
			return $this->$api_name($res);
		}else{
		   	$path = DB::table('excel_list')->where('el_id',$id)->value('el_path');
		   	$zipper = new Zipper();
		   	$arr = glob(public_path($path));   //$public_path  被压缩的文件名
		   	$reduce_path = $path.'.zip';
		   	$zipper->make(public_path($reduce_path))->add($arr)->close();  //public_path($reduce_path)  压缩之后 */
		   	$zip = new \ZipArchive();
		   	$zipStatus = $zip->open($reduce_path);
		   	if ($zipStatus !== true) {
		   	    return $this->error('压缩失败', ErrorInc::FAILED_PARAM);exit;
		   	}
		   	DB::table("excel_list")->where('el_id',$id)->update(['el_state'=>2]);
            //	 = $this->baseurl().$reduce_path;
            return response()->json(['Data' =>'', 'ErrorMessage' => '执行完毕', 'ErrorCode' => 222]);exit;
		   	//return $this->success('执行完毕',$reduce_path);exit;
		}
	}

    /**
     * @工单导出
     * @param $res
     * @param string $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/26
     */
	public function performOrderList($res,$con='Orderlist'){
		$detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
		if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
			if($db){
				$num1 = count($db);
                if(!empty(array_intersect(['stauas_name'], $group))){
                    $orderStau = OrderService::getOrderStatusName();//获取订单状态名
                }
				//list_id
                $list_ids = array_column($db, 'serial_number');
                $all_prices = SettlementList::whereIn('list_id',$list_ids)->pluck('all_price','list_id');
                $brandServersNames = ServiceProviderService::getBrandService(true);
				foreach( $db as $k => $v ){                    //ordermsg表
                    $msgArr = OrderService::getOrderMsg('', [],$v['order_goods_id']);

                    $cinfo = OrderListService::getUserHeadPhoneById($v['ser_id']);//获取门店信息
                   /* if(in_array('com_good', $group)){
                        $com_name = DB::table('company_good')->pluck('fg_cname','fg_gid');
                    }*/
					foreach( $group as $kg => $vg ){
						$num = array_search($vg,$group);
							if ( $vg=='pt_name'){
							    if($v['p_id']){
                                    $pt_name = Pt::where('id',$v['p_id'])->value('pt_name');
                                    $rs[$k][strtolower(chr(65+$num))] = $pt_name;
                                }else{
                                    $rs[$k][strtolower(chr(65+$num))] = '';
                                }
							}elseif($vg=='all_price'){
                                $rs[$k][strtolower(chr(65+$num))] = $all_prices[$v['serial_number']];
                            }
							elseif($vg=='goods_num'){
                                $rs[$k][strtolower(chr(65+$num))] = $msgArr['goods_num'];
                            }elseif($vg=='goods_name'){
                                $rs[$k][strtolower(chr(65+$num))] = $msgArr['goods_name'];
                            }elseif($vg=='goods_price'){
                                $rs[$k][strtolower(chr(65+$num))] = $msgArr['goods_price'];
                            }elseif($vg=='goods_number'){
                                $rs[$k][strtolower(chr(65+$num))] = $msgArr['goods_number'];
                            }elseif ($vg == 'order_num'){
                                $rs[$k][strtolower(chr(65+$num))]  = '`'.$v['order_num'];
                            }elseif($vg == 'shr_car'){
                                $rs[$k][strtolower(chr(65+$num))]  = $v['car_make'].$v['car_line'].$v['car_model'];
                            }elseif ($vg == 'admin_principal'){
                                $rs[$k][strtolower(chr(65+$num))]  = Admin::where('id',$v['ser_id'])->value('admin_name');
                            }elseif ($vg == 'stauas_name'){
                                $rs[$k][strtolower(chr(65+$num))]  = $orderStau[$v['stauas']]??'未定义';
                            }elseif ($vg == 'head_phone'){
                                $phone = isset($cinfo['phone'])??'';
                                $rs[$k][strtolower(chr(65+$num))]  = '`'.$phone;
                            }/*elseif ($vg == 'com_good'){
                                $rs[$k][strtolower(chr(65+$num))]  = $com_name[$msgArr['goods_id']];
                            }*/elseif ($vg == 'admin_province'){
                                if($v['category']==3){
                                    $admin_province = isset($cinfo['admin_province'])??'';
                                    $rs[$k][strtolower(chr(65+$num))]  = $admin_province;
                                }else{
                                    $rs[$k][strtolower(chr(65+$num))]  = '';
                                }
                            }elseif ($vg == 'admin_city'){
                                if($v['category']==3){
                                    $admin_city = isset($cinfo['admin_city'])??'';
                                    $rs[$k][strtolower(chr(65+$num))]  = $admin_city;
                                }else{
                                    $rs[$k][strtolower(chr(65+$num))]  = '';
                                }

                            }elseif ($vg == 'admin_county'){
                                if($v['category']==3){
                                    $admin_county = isset($cinfo['admin_county'])??'';
                                    $rs[$k][strtolower(chr(65+$num))]  = $admin_county;
                                }else{
                                    $rs[$k][strtolower(chr(65+$num))]  = '';
                                }
                            }elseif ($vg == 'admin_dressi'){
                                if($v['category']==3){
                                    $admin_dressi = isset($cinfo['admin_dressi'])??'';
                                    $rs[$k][strtolower(chr(65+$num))]  = $admin_dressi;
                                }else{
                                    $rs[$k][strtolower(chr(65+$num))]  = '';
                                }
                            }elseif($vg == 'brand_service'){
                                $rs[$k][strtolower(chr(65+$num))]  = $brandServersNames[$v['brand_service']]??'未设定';
                            }
							else{
							$rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
						}
					}
					$datas = $rs[$k];
					$datas = $this->excelOut->replaceData($datas);
					$strexport = implode("\t",$datas)."\r";
					$strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
					file_put_contents($file, $strexport, FILE_APPEND);
					unset($strexport);
					unset($db[$k]);
					unset($rs[$k]);
				}
				$el_item = $res['el_item'] + $num1;
				DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
				DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
				return $this->success('操作成功1');
			}else{
				DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
			}
		}else{
			DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
		}
	}
    /**
     * @name 执行技师导出数据
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performInstallPerson($res,$con='InstallPerson'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='company_name'){
                            if($v['company_id']){
                                $service_name = DB::table('admin')->where('id',$v['company_id'])->value('company_name');
                                $rs[$k][strtolower(chr(65+$num))] = $service_name;
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = '';
                            }
                        }else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    //$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * 商品导出
     * @param $res
     * @param string $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/26
     */
    public function performGoods($res,$con='Goods'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='company_name'){
                            if($v['company_id']){
                                $service_name = DB::table('admin')->where('id',$v['company_id'])->value('company_name');
                                $rs[$k][strtolower(chr(65+$num))] = $service_name;
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = '';
                            }
                        }else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }

    }

    /**
     * @平台评价导出
     * @param $res
     * @param string $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/26
     */
    public function performEvaluationForm($res,$con='EvaluationForm'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                if(in_array('brand_service', $group)) {
                    $ser_ids = array_column($db, 'ser_id');
                    $admin = Admin::whereIn('id',$ser_ids)->select('id','brand_service')->get()->toarray();
                    $admin = CommonService::jointArrayKey($admin,'id');
                }
                $pids = array_unique(array_column($db, 'p_id'));
                $pnames = Pt::whereIn('id',$pids)->pluck('pt_name','id')->toarray();
                $num1 = count($db);
                $brandServersNames = ServiceProviderService::getBrandService(true);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='eval_type'){
                            $rs[$k][strtolower(chr(65+$num))] = $pnames[$v['p_id']];
                            /*if($v['eval_type']==1){
                                $rs[$k][strtolower(chr(65+$num))] = '天猫';
                            }elseif($v['eval_type']==2){
                                $rs[$k][strtolower(chr(65+$num))] = '京东';
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] =  '无';
                            }*/
                        }elseif($vg=='plat_number'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['plat_number'];

                        }elseif($vg == 'brand_service'){
                            $brand_service = $admin[$v['ser_id']]['brand_service']??'';
                            if($brand_service == ''){
                                $rs[$k][strtolower(chr(65+$num))]  = '';
                            }else{
                                $rs[$k][strtolower(chr(65+$num))]  = $brandServersNames[$brand_service]??'未设定';
                            }
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * @name 发货列表导出
     * @param $res
     * @param string $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/26
     */
public function performSendGoods($res,$con='SendGoods'){
    $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
    if($detail){
        $data = $this->excelOut->getDatas($con, $res, $detail);
        $db = $data['db'];
        $group = $data['group'];
        $file = $data['file'];
        if($db){
            $num1 = count($db);

            $ptids = array_unique(array_column($db, 'p_id'));
            $pts = Pt::where('id',$ptids)->pluck('pt_name','id')->toArray();

            $wstoreids = array_unique(array_column($db, 'stores'));
            $wstoreNames = DB::table('warehouse')->whereIn('id',$wstoreids)->pluck('shck_ckmc','id');

            foreach( $db as $k => $v ){
                foreach( $group as $kg => $vg ){
                    $num = array_search($vg,$group);
                    if ( $vg=='stores'){
                        if($v['stores']){
                            if($v['send_type']==2)
                            {
                                $service_name = $wstoreNames[$v['stores']]??'';
                            }else{
                                $service_name = DB::table('admin')->where('id',$v['stores'])->value('company_name');
                            }
                            $rs[$k][strtolower(chr(65+$num))] = $service_name;
                        }else{
                            $rs[$k][strtolower(chr(65+$num))] = '';
                        }
                    }elseif($vg=='receiving_store') {
                        if($v['receiving_store']){
                            $name = DB::table('admin')->where('id',$v['receiving_store'])->value('company_name');
                            $rs[$k][strtolower(chr(65+$num))] = $name;
                        }else{
                            $rs[$k][strtolower(chr(65+$num))] = '';
                        }
                    }elseif($vg=='collect_type'){
                        if($v['collect_type']==1){
                            $rs[$k][strtolower(chr(65+$num))] = '门店发货';
                        }elseif($v['collect_type']==2){
                            $rs[$k][strtolower(chr(65+$num))] = '客户收货';
                        }
                    }elseif ($vg == 'order_num'){
                        $rs[$k][strtolower(chr(65+$num))] = '`'.$v['order_num'];
                    }elseif($vg == 'pt_name'){
                        if (isset($pts[$v['p_id']])) {
                            $rs[$k][strtolower(chr(65 + $num))] = $pts[$v['p_id']];
                        }else{
                            $rs[$k][strtolower(chr(65 + $num))] = '暂无';
                        }
                    }
                    else{
                        $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                    }
                }
                $datas = $rs[$k];
                $datas = $this->excelOut->replaceData($datas);
                $strexport = implode("\t",$datas)."\r";
                $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                file_put_contents($file, $strexport, FILE_APPEND);
                unset($strexport);
                unset($db[$k]);
                unset($rs[$k]);
            }
            $el_item = $res['el_item']+$num1;
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
            DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
            return $this->success('操作成功1');
        }else{
            DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
            return $this->success('操作成功2');
        }
    }else{
        DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
        return $this->success('操作成功3');
    }
}

    /**
     * @name 绑定服务商
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/6
     */
public function performBserviss($res,$con='Bserviss'){
    $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
    if($detail){
        $data = $this->excelOut->getDatas($con, $res, $detail);
        $db = $data['db'];
        $group = $data['group'];
        $file = $data['file'];
        if($db){
            $num1 = count($db);
            $brand = DB::table('goods_brand')->pluck('brand_name','id')->toArray();
            foreach( $db as $k => $v ){
                $eng = Disareanew::whereIn('are_id',explode(',',$v['bs_areid']))->select('are_id','are_sheng','are_shi','are_xian')->get()->toArray();
                $area = array_column($eng, 'are_xian');
                foreach( $group as $kg => $vg ){
                    $num = array_search($vg,$group);
                    if ( $vg=='brand_name'){
                        if(isset($brand[$v['bs_branid']])){
                            $rs[$k][strtolower(chr(65+$num))] = $brand[$v['bs_branid']];;
                        }else{
                            $rs[$k][strtolower(chr(65+$num))] = '';
                        }
                    }elseif($vg=='are_sheng') {
                        $rs[$k][strtolower(chr(65+$num))] = $eng[0]['are_sheng'];
                    }elseif($vg=='are_shi'){
                        $rs[$k][strtolower(chr(65+$num))] = $eng[0]['are_shi'];//
                    }elseif($vg=='are_xian'){
                        $rs[$k][strtolower(chr(65+$num))] = implode("、",$area);
                    }elseif($vg=='bs_status'){
                        if($v['bs_status']==1){
                            $rs[$k][strtolower(chr(65+$num))] = '开启';
                        }else{
                            $rs[$k][strtolower(chr(65+$num))] = '关闭';
                        }
                    }
                    else{
                        $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                    }
                }
                $datas = $rs[$k];
                $datas = $this->excelOut->replaceData($datas);
                $strexport = implode("\t",$datas)."\r";
                $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                file_put_contents($file, $strexport, FILE_APPEND);
                unset($strexport);
                unset($db[$k]);
                unset($rs[$k]);
            }
            $el_item = $res['el_item']+$num1;
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
            DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
            return $this->success('操作成功1');
        }else{
            DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
            return $this->success('操作成功2');
        }
    }else{
        DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
        return $this->success('操作成功3');
    }
}

    /**
     * @name 绑定门店地址导出     *
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/7
     */
public function performBserviStore($res,$con='BserviStore'){
    $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
    if($detail){
        $data = $this->excelOut->getDatas($con, $res, $detail);
        $db = $data['db'];
        $group = $data['group'];
        $file = $data['file'];
        if($db){
            $num1 = count($db);
            foreach( $db as $k => $v ){
                foreach( $group as $kg => $vg ){
                    $num = array_search($vg,$group);
                    $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                }
                $datas = $rs[$k];
                $datas = $this->excelOut->replaceData($datas);
                $strexport = implode("\t",$datas)."\r";
                $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                file_put_contents($file, $strexport, FILE_APPEND);
                unset($strexport);
                unset($db[$k]);
                unset($rs[$k]);
            }
            $el_item = $res['el_item']+$num1;
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
            DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
            return $this->success('操作成功1');
        }else{
            DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
            return $this->success('操作成功2');
        }
    }else{
        DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
        return $this->success('操作成功3');
    }

}

    /**
     * @name 订单导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/7
     */
    public function performOrders($res,$con='Orders'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                $statu_name = OrderService::getOrderStatusName();
                $goods_service_name = OrderService::getGoodsServiceName();
                if(in_array('ser_name', $group) || in_array('shop_alias', $group)) {
                    $ser_ids = array_column($db, 'ser_id');
                    $admin = Admin::whereIn('id',$ser_ids)->select('id','company_name','ad_alias','brand_service')->get()->toarray();
                    $admin = CommonService::jointArrayKey($admin,'id');
                }
                if(in_array('wam', $group) || in_array('feed_time', $group)){
                    $order_num = array_column($db, 'order_num');
                    $sql = "SELECT feeds_time,wat_num,a.order_num FROM gone_order_list as a LEFT JOIN gone_settlement_list as b on a.serial_number = b.list_id where a.order_num in ('".implode("','", $order_num)."')";
                    $settment = DB::select($sql);
                    $settment = CommonService::dataToArray($settment);
                    $settment = CommonService::jointArrayKey($settment, 'order_num');
                }
                $brandServersNames = ServiceProviderService::getBrandService(true);
                foreach( $db as $k => $v ){

                    $msgArr = OrderService::getOrderMsg($v['sys_num']);
                    $msgArr = $msgArr['orderMsgArr'];
                    $time = explode(" ",$v['create_time']);
                    $year = explode("-",$time[0])[0];
                    $mouth = explode("-",$time[0])[1];
                    $day = explode("-",$time[0])[2];
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                       if($vg=='goods_num'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_num'];
                        }elseif($vg=='goods_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_name'];
                        }elseif($vg=='goods_price'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_price'];
                        }elseif($vg=='goods_number'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_number'];
                        }elseif($vg=='goods_service'){
                           $rs[$k][strtolower(chr(65+$num))] = $goods_service_name[$msgArr[0]['goods_service']];
                       }elseif ($vg=='order_status'){
                           $rs[$k][strtolower(chr(65+$num))] = $statu_name[$v['order_status']];
                       }elseif ($vg == 'order_num'){
                           $rs[$k][strtolower(chr(65+$num))]  = '`'.$v['order_num'];
                       }elseif ($vg == 'ser_name'){
                           $rs[$k][strtolower(chr(65+$num))]  = $admin[$v['ser_id']]['company_name'];
                       }elseif ($vg == 'shop_alias'){
                           $rs[$k][strtolower(chr(65+$num))]  = $admin[$v['ser_id']]['ad_alias'];
                       }elseif($vg == 'wam'){
                           $rs[$k][strtolower(chr(65+$num))]  = $settment[$v['order_num']]['wat_num'];
                       }elseif($vg == 'feed_time'){
                           $rs[$k][strtolower(chr(65+$num))]  = $settment[$v['order_num']]['feeds_time'];
                       }elseif($vg == 'creact_year'){
                           $rs[$k][strtolower(chr(65+$num))]  = $year;
                       }elseif($vg == 'creact_mouth'){
                           $rs[$k][strtolower(chr(65+$num))]  = $mouth;
                       }elseif($vg == 'creact_day'){
                           $rs[$k][strtolower(chr(65+$num))]  = $day;
                       }elseif($vg == 'brand_service'){
                           $brand_service = $admin[$v['ser_id']]['brand_service']??'';
                           if($brand_service == ''){
                               $rs[$k][strtolower(chr(65+$num))]  = '';
                           }else{
                               $rs[$k][strtolower(chr(65+$num))]  = $brandServersNames[$brand_service]??'未设定';
                           }
                       }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * @name 售后列表导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/14
     */
    public function performAftersaleOrder($res,$con='AftersaleOrder'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];

            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $ser_id = array_column($db, 'ser_id');
                $ser_id = array_unique($ser_id);
                $msg_id = array_column($db, 'msg_id');
                $order_num = array_column($db, 'order_num');
                $msg = DB::table("order_msg")->whereIn('id',$msg_id)->pluck('goods_id','id');
                $admin = Admin::whereIn('id',$ser_id)->select('id','company_name','ad_alias','brand_service')->get()->toarray();
                $admin = CommonService::jointArrayKey($admin,'id');
                $admin_infor = DB::table("admin_infor")->whereIn('admin_id',$ser_id)->whereRaw("admin_dressi!=''")->select('admin_id','admin_province','admin_dressi')->get()->toarray();
                $admin_infor = CommonService::jointArrayKey($admin_infor,'admin_id');

                $setmoney_type = DB::table("setmoney_type")->whereIn('lt_parent_id',[167,173,208])->pluck('sety_name','sety_id')->toarray();

                $sety_name = DB::table("aftersale")->whereIn('afs_order',$order_num)->whereIn('afs_paid',[167,173,208])->select('afs_order','afs_type','afs_serid')->get()->toarray();//标签
                $sety_name = CommonService::jointArrayKey($sety_name,'afs_order');

                $order_status = OrderService::getOrderStatusName(true);

                foreach( $sety_name as $kk => $vv ){
                    $sety_name[$kk]['afs_name'] = $setmoney_type[$vv['afs_type']];
                }
                $brandServersNames = ServiceProviderService::getBrandService(true);
                unset($setmoney_type);
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    unset($msg[$v['msg_id']]);
                    $time = explode(" ",$v['create_time']);
                    $time = explode("-",$time[0]);
                    $order_time = explode(' ',$v['order_time'])[0];
                    $order_time = explode("-",$order_time);
                    $area = $this->check_dress($v['shr_sheng'], $v['shr_shi'], $v['shr_xian']);
                    $note = DB::table('note')->whereRaw("orders_id='".$v['sys_num']."' and note_content like '【售后】%'")->select('note_name','note_content','note_time')->orderBy('id','DESC')->first();
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='pt_name'){
                            if($v['p_id']){
                                $pt_name = Pt::where('id',$v['p_id'])->value('pt_name');
                                $rs[$k][strtolower(chr(65+$num))] = $pt_name;
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = '';
                            }
                        }elseif($vg=='shr_sheng'){
                            $rs[$k][strtolower(chr(65+$num))] = $area[0];
                        }elseif($vg=='shr_shi'){
                            $rs[$k][strtolower(chr(65+$num))] = $area[1];
                        }elseif($vg=='shr_xian'){
                            $rs[$k][strtolower(chr(65+$num))] = $area[2];
                        }elseif($vg=='order_status_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $order_status[$v['order_status']];
                        }
                        elseif($vg=='pg_series'){
                            $rs[$k][strtolower(chr(65+$num))] =  DB::table('pj_goods')->where('pg_id',$msg[$v['msg_id']])->value('pg_series');//商品系列
                        }elseif($vg=='shop_name'){
                            $rs[$k][strtolower(chr(65+$num))] =  $admin[$v['ser_id']]['company_name'];//门店名称
                        }elseif($vg=='shop_alias'){
                            $rs[$k][strtolower(chr(65+$num))] =  $admin[$v['ser_id']]['ad_alias'];//门店别名
                        }elseif($vg=='time_span'){
                            $period = ceil(strtotime($v['create_time'])-strtotime($v['order_time']));
                            $a = floor($period/86400/30); //月数
                            $b = floor($period/86400)-$a*30;//天数
                            $rs[$k][strtolower(chr(65+$num))] = $a.'月'.$b.'天';
                        }elseif ($vg=='shr_address'){
                            $rs[$k][strtolower(chr(65+$num))] = $admin_infor[$v['ser_id']]['admin_province'].$admin_infor[$v['ser_id']]['admin_dressi'];//门店地址
                        }elseif($vg=='label'){
                            $rs[$k][strtolower(chr(65+$num))] = $sety_name[$v['order_num']]['afs_name'];
                        }elseif($vg=='note'){
                            $rs[$k][strtolower(chr(65+$num))] = $note['note_name'].":".$note['note_content'];
                        }elseif($vg=='feek_time'){
                            $rs[$k][strtolower(chr(65+$num))] = $note['note_time'];
                        }
                        elseif ($vg == 'order_num'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['order_num'];
                        }
                        elseif($vg=='Y'){
                            $rs[$k][strtolower(chr(65+$num))] = $time[0];//年
                        }elseif($vg=='M'){
                            $rs[$k][strtolower(chr(65+$num))] = $time[1];//月
                        }elseif($vg=='D'){
                            $rs[$k][strtolower(chr(65+$num))] = $time[2];//日
                        }elseif($vg=='oY'){
                            $rs[$k][strtolower(chr(65+$num))] = $order_time[0];//年
                        }elseif($vg=='oM'){
                            $rs[$k][strtolower(chr(65+$num))] = $order_time[1];//月
                        }elseif($vg=='oD'){
                            $rs[$k][strtolower(chr(65+$num))] = $order_time[2];//日
                        }elseif ($vg=='finish_times'){
                            if($v['deal_sertime']!=''){
                                if($v['get_time']!=''){
                                    $rs[$k][$kg] = $this->computeTime($v['get_time'],$v['deal_sertime']);
                                }else{
                                    $rs[$k][$kg] = $this->computeTime($v['create_time'],$v['deal_sertime']);
                                }//耗时
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }elseif($vg=='deal_with_times'){
                            if($v['get_time']!=''){
                                $rs[$k][$kg] = $this->computeTime($v['create_time'],$v['get_time']);
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }elseif($vg == 'brand_service'){
                            $brand_service = $admin[$v['ser_id']]['brand_service']??'';
                            if($brand_service == ''){
                                $rs[$k][strtolower(chr(65+$num))]  = '';
                            }else{
                                $rs[$k][strtolower(chr(65+$num))]  = $brandServersNames[$brand_service]??'未设定';
                            }
                        }

                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    //校验地址
    public function check_dress ( $sheng,$shi,$xian ){
        if($sheng == '北京' || $sheng == '北京市'){
            $sheng="北京";
            $shi="北京市";
        }elseif($sheng == '天津' || $sheng == '天津市'){
            $sheng="天津";
            $shi="天津市";
        }elseif($sheng == '上海' || $sheng == '上海市'){
            $sheng="上海";
            $shi="上海市";
        }elseif($sheng == '重庆' || $sheng == '重庆市'){
            $sheng="重庆";
            $shi="重庆市";
        }elseif($sheng == '河北' || $sheng == '河北省'){
            $sheng="河北";
        }elseif($sheng == '山西' || $sheng == '山西省'){
            $sheng="山西";
        }elseif($sheng == '辽宁' || $sheng == '辽宁省'){
            $sheng="辽宁";
        }elseif($sheng == '吉林' || $sheng == '吉林省'){
            $sheng="吉林";
        }elseif($sheng == '黑龙江' || $sheng == '黑龙江省'){
            $sheng="黑龙江";
        }elseif($sheng == '江苏' || $sheng == '江苏省'){
            $sheng="江苏";
        }elseif($sheng == '浙江' || $sheng == '浙江省'){
            $sheng="浙江";
        }elseif($sheng == '安徽' || $sheng == '安徽省'){
            $sheng="安徽";
        }elseif($sheng == '福建' || $sheng == '福建省'){
            $sheng="福建";
        }elseif($sheng == '江西' || $sheng == '江西省'){
            $sheng="江西";
        }elseif($sheng == '山东' || $sheng == '山东省'){
            $sheng="山东";
        }elseif($sheng == '河南' || $sheng == '河南省'){
            $sheng="河南";
        }elseif($sheng == '湖北' || $sheng == '湖北省'){
            $sheng="湖北";
        }elseif($sheng == '湖南' || $sheng == '湖南省'){
            $sheng="湖南";
        }elseif($sheng == '广东' || $sheng == '广东省'){
            $sheng="广东";
        }elseif($sheng == '海南' || $sheng == '海南省'){
            $sheng="海南";
        }elseif($sheng == '四川' || $sheng == '四川省'){
            $sheng="四川";
        }elseif($sheng == '贵州' || $sheng == '贵州省'){
            $sheng="贵州";
        }elseif($sheng == '云南' || $sheng == '云南省'){
            $sheng="云南";
        }elseif($sheng == '陕西' || $sheng == '陕西省'){
            $sheng="陕西";
        }elseif($sheng == '甘肃' || $sheng == '甘肃省'){
            $sheng="甘肃";
        }elseif($sheng == '青海' || $sheng == '青海省'){
            $sheng="青海";
        }elseif($sheng == '台湾' || $sheng == '台湾省'){
            $sheng="台湾";
        }elseif($sheng == '内蒙古' || $sheng == '内蒙古自治区'){
            $sheng="内蒙古";
        }elseif($sheng == '广西' || $sheng == '广西壮族自治区'){
            $sheng="广西";
        }elseif($sheng == '西藏' || $sheng == '西藏自治区'){
            $sheng="西藏";
        }elseif($sheng == '宁夏' || $sheng == '宁夏回族自治区'){
            $sheng="宁夏";
        }elseif($sheng == '新疆' || $sheng == '新疆维吾尔自治区'){
            $sheng="新疆";
        }elseif($sheng == '香港' || $sheng == '香港特别行政区'){
            $sheng="香港";
        }elseif($sheng == '澳门' || $sheng == '澳门特别行政区'){
            $sheng="澳门";
        }
        if(mb_strlen($xian,'utf-8')>10 || $xian=='' || $xian=='市、县级市'){
            $xian = $shi;
        }
        $data[0] = $sheng;
        $data[1] = $shi;
        $data[2] = $xian;
        return $data;
    }

    /**
     * @name 月结周结状态下的导出 mouth_pay＝1 和 ＝3时
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/14
     */
    public function performStatementsList($res,$con='StatementsList'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);

                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='number'){
                            if ($v['stl_ids'] == "") {
                                $rs[$k][strtolower(chr(65+$num))] = 0;
                            } else {
                                $rs[$k][strtolower(chr(65+$num))] = count(explode(",", $v['stl_ids']));
                            }
                        }elseif($vg=='ser_yycode'){
                            //stl_serid
                            $yy_code = DB::table('certification')->where('ser_id',$v['stl_serid'])->value('ser_yycode');
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$yy_code;
                        }
                        elseif($vg=='stl_type'){
                            switch ($v['stl_type']) {
                                case 4;
                                    $rs[$k][strtolower(chr(65+$num))] = "未处理";
                                    break;
                                case 1;
                                    $rs[$k][strtolower(chr(65+$num))] = "商家确认中";
                                    break;
                                case 2;
                                    $rs[$k][strtolower(chr(65+$num))] = "财务结算中";
                                    break;
                                case 3;
                                    $rs[$k][strtolower(chr(65+$num))]= "已完成";
                                    break;
                            }
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }

    }

    /**
     * 导出月账单详情
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/15
     */
    public function performSettlementMouth($res,$con='SettlementMouth'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];

            if($db){
                $statu_name = OrderService::getOrderStatusName();
//                dump($db);
                $wats = array_column($db,'wat_num');
                $wats = array_unique($wats);

                $pids = array_column($db,'p_id');
                $pids = array_unique($pids);

                $pname = DB::table('pt')->whereIn('id',$pids)->pluck('pt_name','id');
                $msg_ids = array_column($db,'msg_id');

                $goodsnames = collect(DB::table('order_msg')->whereIn('id',$msg_ids)->select('goods_name','goods_brand','goods_num','goods_price','creator_time','id')->get())->keyBy('id')->toArray();;
                //dump($goodsnames);

                //派单时间
                $list_ids = array_column($db,'list_id');

                $order_lists = DB::table('order_list')->whereIn('serial_number',$list_ids)->select('create_time','customer_id','serial_number')->get()->toarray();
                $order_listtimes = CommonService::jointArrayKey($order_lists, 'serial_number');
                $customer_ids = array_column($order_lists,'customer_id');
                $customer = collect(DB::table('user')->whereIn('id',$customer_ids)->select('shr_name','shr_sheng','shr_shi','shr_xian','shr_adress','id')->get())->keyBy('id')->toArray();

                $servceInfo = collect(DB::table('service_center')->whereIn('wat_num',$wats)->select('apply_for_time','apply_pay_time','whether_inv','wat_num')->get())->keyBy('wat_num')->toArray();
              // dump($servceInfo);

                //第三方
                $wat_three = array_unique(array_column($db,'wat_three'));
                $three_time = DB::table('pt_three')->whereIn('wat_num',$wat_three)->select('wat_num','apply_for_time','apply_pay_time')->get()->toArray();
                $three_time = CommonService::jointArrayKey($three_time,'wat_num');


                $adminids = array_column($db,'ser_id');
                $adminids = array_unique($adminids);
//                $sever_names = DB::table('admin')->whereIn('id',$adminids)->pluck('company_name','id');
                $sever_names = AdminService::getAdmins(['id_searchin'=>$adminids],['company_name','id','mouth_pay']);
                $sever_names = CommonService::jointArrayKey($sever_names, 'id');
                //结算方式
                $getMouthPay = ServiceProviderService::getMouthPay(true);
                //用友编号
                $certification = DB::table("certification")->whereIn('ser_id',$adminids)->pluck('ser_yycode','ser_id');

                //供货价格
                $sids = array_unique(array_column($db,'id'));

                //dump($sids);
                $sem_types = DB::table('settlement_money')->whereIn('sem_slid',$sids)->select('sem_type','sem_price','sem_slid')->get()->toArray();
                $smoneysids = array_unique(array_column($sem_types, 'sem_type'));
                //dump($smoneysids);

                foreach ($sem_types as $k =>$v){
                    $money[$v['sem_slid']][$v['sem_type']] = $v['sem_price'];
                }
               // dd($money);
                $sidnames = DB::table('setmoney_type')->whereIn('sety_id',$smoneysids)->pluck('sety_name','sety_id');
                //dd($sidnames);

                $ExceloutService = new ExceloutService();

                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ) {
                        $validation = $ExceloutService->validationKey($vg);
                        if ($validation['code']) {
                            if($validation['code'] = 'SetmoneyType'){
                                $rs[$k][$kg] =  $money[$v['id']][$validation['data']]??'';
                            }
                        } else {
                            if ($vg == 'pt_name') {
                                $rs[$k][$kg] = $pname[$v['p_id']];

                            }elseif($vg == 'p_time'){
                                $rs[$k][$kg] = $order_listtimes[$v['list_id']]['create_time'];

                            }elseif ($vg == 'order_num'){
                                $rs[$k][$vg] = '`'.$v['order_num'];
                            } elseif ($vg == 'supply_price') {
                                $watmone = $money[$v['id']] ?? '';
                                if ($watmone) {
                                    //供货价
                                    $rs[$k][$kg] = $watmone[1] ?? 0;
                                } else {
                                    $rs[$k][$kg] = 0;
                                }
                            } elseif ($vg == 'price_detail') {
                                $watmone = $money[$v['id']] ?? '';
                                $moneys = '';
                                if ($watmone) {
                                    foreach ($watmone as $k1 => $v1) {
                                        $moneys .= $sidnames[$k1] . ":" . $v1 . ';';
                                    }
                                    $rs[$k][$kg] = $moneys;
                                } else {

                                    $rs[$k][$kg] = '';
                                }

                            } elseif ($vg == 'goods_brand') {
                                $rs[$k][$kg] = $goodsnames[$v['msg_id']]['goods_brand'];
                            }elseif($vg == 'goods_number'){
                                $rs[$k][$kg] = $goodsnames[$v['msg_id']]['goods_name'];//mb_ereg_replace($v['goods_brand']."-",'',$goodsnames[$v['msg_id']]['goods_name']);
                            }
                            elseif ($vg == 'goods_num') {
                                $rs[$k][$kg] = $goodsnames[$v['msg_id']]['goods_num'];
                            } elseif ($vg == 'order_msg_time') {
                                $rs[$k][$kg] = $goodsnames[$v['msg_id']]['creator_time'];//订单时间
                            }  elseif ($vg == 'shr_name') {
                                $rs[$k][$kg] = $customer[$v['customer_id']]['shr_name'];
                            } elseif ($vg == 'shr_sheng') {
                                $rs[$k][$kg] = $customer[$v['customer_id']]['shr_sheng'];
                            } elseif ($vg == 'shr_shi') {
                                $rs[$k][$kg] = $customer[$v['customer_id']]['shr_shi'];
                            }elseif ($vg == 'shr_xian') {
                                $rs[$k][$kg] = $customer[$v['customer_id']]['shr_xian'];
                            }elseif ($vg == 'shr_adress') {
                                $rs[$k][$kg] = $customer[$v['customer_id']]['shr_adress'];
                            }elseif($vg == 'ser_yycode'){
                                $rs[$k][$kg] = '`'.$certification[$v['ser_id']];
                            }
                            elseif ($vg == 'apply_for_time') {
                                $rs[$k][$kg] = $servceInfo[$v['wat_num']]['apply_for_time'];//申请结算时间
                            } elseif ($vg == 'apply_pay_time') {
                                $rs[$k][$kg] = $servceInfo[$v['wat_num']]['apply_pay_time'];//付款时间
                            } elseif ($vg == 'whether_inv') {
                                if ($servceInfo[$v['wat_num']]['whether_inv'] == 1) {
                                    $rs[$k][$kg] = '已收票';
                                } elseif ($servceInfo[$v['wat_num']]['whether_inv'] == 2) {
                                    $rs[$k][$kg] = '未收票';
                                }else{
                                    $rs[$k][$kg] = '';
                                }
                            } elseif ($vg == 'order_status_name') {
                                $rs[$k][$kg] = $statu_name[$v['list_service_type']];
                            } elseif ($vg == 'three_apply_for_time') {
                                    $rs[$k][$kg] = $three_time[$v['wat_three']]['apply_for_time'];;
                            } elseif ($vg == 'three_apply_pay_time') {
                                $rs[$k][$kg] = $three_time[$v['wat_three']]['apply_pay_time'];
                            } elseif ($vg == 'company_name') {
                                $rs[$k][$kg] = $sever_names[$v['ser_id']]['company_name'];
                            }elseif ($vg == 'mouth_pay') {
                                $mouth_pay = $sever_names[$v['ser_id']]['mouth_pay'];
                                $rs[$k][$kg] = $getMouthPay[$mouth_pay];
                            }  else {
                                $rs[$k][$kg] = "\t" . $v[$vg] . "\t";
                            }
                        }
                    }
                    $datas = $rs[$k];
                   //dd($datas);
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t", $datas) . "\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }


    /**
     * 导出门店报表结算算账单
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/12/16
     */
    public function performSettlementBillExport($res,$con='SettlementBillExport'){
        if(!$res['el_id']){
            return $this->error('请去下载列表执行', ErrorInc::FAILED_PARAM); exit;
        }
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];

            if($db){
               // print_r($db);

                $wats = array_column($db,'wat_num');
                $wats = array_unique($wats);
                $msg_ids = array_column($db,'msg_id');
                $goodsnames = collect(DB::table('order_msg')->whereIn('id',$msg_ids)->select('goods_name','goods_brand','goods_num','goods_price','creator_time','id')->get())->keyBy('id')->toArray();;
                //dump($goodsnames);

                //派单时间
                $list_ids = array_column($db,'list_id');

                $order_lists = DB::table('order_list')->whereIn('serial_number',$list_ids)->select('create_time','customer_id','serial_number')->get()->toarray();
                $order_listtimes = CommonService::jointArrayKey($order_lists, 'serial_number');
                $customer_ids = array_column($order_lists,'customer_id');
                $customer = collect(DB::table('user')->whereIn('id',$customer_ids)->select('shr_name','shr_phone','id')->get())->keyBy('id')->toArray();

                $adminids = array_column($db,'ser_id');
                $adminids = array_unique($adminids);
                $sever_names = DB::table('admin')->whereIn('id',$adminids)->pluck('company_name','id');
                $acount_names = DB::table('admin_infor')->whereIn('admin_id',$adminids)->pluck('accountname','admin_id');


                $sids = array_unique(array_column($db,'id'));
                $sem_types = DB::table('settlement_money')->whereIn('sem_slid',$sids)->select('sem_type','sem_price','sem_slid')->get()->toArray();
                $smoneysids = array_unique(array_column($sem_types, 'sem_type'));
                foreach ($sem_types as $k =>$vv){
                    $money[$vv['sem_slid']][$vv['sem_type']] = $vv['sem_price'];
                }
                // dd($money);
                $sidnames = DB::table('setmoney_type')->whereIn('sety_id',$smoneysids)->pluck('sety_name','sety_id');

                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ) {
                       if($vg == 'price_detail') {
                                $watmone = $money[$v['id']] ?? '';
                                $moneys = '';
                                if ($watmone) {
                                    foreach ($watmone as $k1 => $v1) {
                                        $moneys .= $sidnames[$k1] . ":" . $v1 . ';';
                                    }
                                    $rs[$k][$kg] = $moneys;
                                } else {

                                    $rs[$k][$kg] = '';
                                }

                            } elseif($vg == 'goods_number'){
                                $rs[$k][$kg] = mb_ereg_replace($v['goods_brand']."-",'',$goodsnames[$v['msg_id']]['goods_name']);
                            }
                            elseif ($vg == 'order_msg_time') {
                                $rs[$k][$kg] = $goodsnames[$v['msg_id']]['creator_time'];//订单时间
                            }elseif ($vg == 'all_price') {
                                $rs[$k][$kg] = $v['all_price'];
                            } elseif ($vg == 'shr_phone') {
                                $rs[$k][$kg] = '`'.$customer[$v['customer_id']]['shr_phone'];
                            }
                       elseif ($vg == 'accountname') {
                           $rs[$k][$kg] = $acount_names[$v['ser_id']];
                       }
                       elseif ($vg == 'company_name') {
                                $rs[$k][$kg] = $sever_names[$v['ser_id']];
                            }  else {
                                $rs[$k][$kg] = "\t" . $v[$vg] . "\t";
                            }

                    }
                    $datas = $rs[$k];
                    //dd($datas);
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t", $datas) . "\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }

    }


    /**
     * @name 服务账目中心导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/16
     */
    public function performServiceCenter($res,$con='ServiceCenter'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $adminids = array_column($db,'ser_id');
                $adminids = array_unique($adminids);
                $AdminKhacclist = [];
                if(in_array('khaccount', $group) || in_array('aka_name', $group)) {
                    $khaccdata = AdminKhacclist::whereIn("akl_adminid", $adminids)->where("akl_state", 1)->get();
                    if ($khaccdata) {
                        $khaccdata = CommonService::dataToArray($khaccdata);
                        $khaccdata = CommonService::jointArrayKey($khaccdata, 'akl_adminid', 2);
                        foreach ($khaccdata as $k => $v) {
                            $AdminKhacclist[$k][$v['akl_wat']] = $v['akl_khaccount'];
                        }
                    }
                }
                $AdminKhaccount = AdminKhaccount::where('aka_type',1)->pluck('aka_name','aka_account');
                //用友编号
                $code_res = DB::table("certification")->whereIn('ser_id',$adminids)->pluck('ser_yycode','ser_id');

                $num1 = count($db);

                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='whether_inv'){
                            if ($v['whether_inv'] == 1) {
                                $rs[$k]['whether_inv'] = '已开票';
                            } elseif ($v['whether_inv'] == 2) {
                                $rs[$k]['whether_inv'] = '未开票';
                            } else {
                                $rs[$k]['whether_inv'] = '未开票';
                            }
                        }elseif($vg=='invoice'){
                            if ($v['invoice'] == 1) {
                                $rs[$k]['invoice'] = '增票';
                            } elseif ($v['invoice'] == 2) {
                                $rs[$k]['invoice'] = '普票';
                            } else {
                                $rs[$k]['invoice'] = '未知';
                            }
                        }elseif($vg=='fdeduct'){
                            //税点
                            $deduct = explode(',',$v['deduct']);
                            if(count($deduct)==2){
                                //$list[$k]['deduct']=(int)$deduct[1];
                                $rs[$k]['fdeduct'] = $deduct[0];
                            }else{
                                $rs[$k]['fdeduct'] = "未设定";
                            }
                        }elseif($vg=='khaccount'){
                            //开户行行号
                            $wat_type = mb_substr($v['wat_num'], 0, 2);
                            if($wat_type!='J2'){
                                $rs[$k]['khaccount'] = '`'.$AdminKhacclist[$v['ser_id']][$wat_type]??$v['khaccount'];
                            }else {
                                $rs[$k]['khaccount'] = '`'.$v['khaccount'];
                            }
                        }elseif($vg=='aka_name'){
                            //开户行行号
                            $wat_type = mb_substr($v['wat_num'], 0, 2);
                            if($wat_type!='J2'){
                                $khaccount = $AdminKhacclist[$v['ser_id']][$wat_type]??$v['khaccount'];
                            }else {
                                $khaccount = $v['khaccount'];
                            }
                            $rs[$k]['aka_name'] = $AdminKhaccount[$khaccount]??'';
                        }


                        elseif($vg=='mouth_pay'){
                            if ($v['mouth_pay'] == 1) {
                                $rs[$k]['mouth_pay'] = '月结';
                            } elseif ($v['mouth_pay'] == 2) {
                                $rs[$k]['mouth_pay'] = '零散';
                            } elseif ($v['mouth_pay'] == 3) {
                                $rs[$k]['mouth_pay'] = '周结';
                            } elseif ($v['mouth_pay'] == 4) {
                                $rs[$k]['mouth_pay'] = '五大区';
                            } else {
                                $rs[$k]['mouth_pay'] = '未知';
                            }
                        }elseif($vg=='ser_yycode'){
                            if (isset($code_res[$v['ser_id']])) {
                                $rs[$k]['ser_yycode'] = '`'.$code_res[$v['ser_id']];
                            } else {
                                $rs[$k]['ser_yycode'] = '';
                            }
                        }elseif($vg=='apply_content'){
                            $note_res = DB::table('note')->where('orders_id',$v['wat_num'])->select('note_content')->get()->toarray();
                            $content = array_column($note_res,'note_content');
                            if ($note_res != []) {
                                $rs[$k]['apply_content'] = implode(' ',$content);
                            } else {
                                $rs[$k]['apply_content'] = '';
                            }
                        }elseif($vg=='account'){
                            $rs[$k]['account'] = '`'.$v['account'];
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }

    }


    /**
     * @name 申请退/收列表导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2021/9/22
     */
    public function performSubmitPlease($res,$con='SubmitPlease'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);

                $submit_state_names = SubmitPleaseService::getSubmitState();
                $submit_service_names = SubmitPleaseService::getSubmitService();
                $submit_stauas_names = SubmitPleaseService::getSubmitStauas();
                $attributeName = RefundService::getAttributeName(true);//退款服务类型1服务2商品

                $refund_ids = array_column($db, 'refund_id');
                //print_r($refund_ids);
                $apply_ids = Refund::whereIn('id',$refund_ids)->pluck('apply_type','id')->toarray();
                //print_r($apply_ids);
                $applyType = RefundService::getRefundApplyType(true);

                foreach( $db as $k => $v ){
                    $infoArr = explode("<br/>",$v['customer_info']);
                    $infoArra = explode("开户行/第三方：",$infoArr[0]);
                    $infoArrb = explode("帐号：",$infoArr[1]);
                    $infoArrc = explode("姓名：",$infoArr[2]);

                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='info_ing'){
                            $rs[$k][strtolower(chr(65+$num))] = $infoArra[1];
                        }elseif($vg=='info_acc'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$infoArrb[1];//帐号
                        }elseif($vg=='info_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $infoArrc[1];
                        }elseif($vg=='submit_state_name'){//差额处理类型
                            $rs[$k][strtolower(chr(65+$num))] = $submit_state_names[$v['submit_state']];
                        }elseif ($vg=='submit_service_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $submit_service_names[$v['submit_service']];
                        }elseif($vg=='submit_stauas_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $submit_stauas_names[$v['submit_stauas']];
                        }elseif($vg=='attribute_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $attributeName[$v['attribute']]??'未设定';//退款属性名称
                        }elseif($vg=='apply_type_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $applyType[$apply_ids[$v['refund_id']]];
                        }elseif($vg=='old_goods_name'){
                            if ($v['submit_service'] == 4){//换货旧商品
                                $goods_name_log = DB::table('order_log')->where('msg_id',$v['msg_id'])->value("goods_name");
                                if (!empty($goods_name_log)){
                                    $rs[$k][strtolower(chr(65+$num))] = $goods_name_log;
                                }else{
                                    $rs[$k][strtolower(chr(65+$num))] = "";
                                }
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = '';
                            }
                        }
                        elseif ($vg == 'order_num'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['order_num'];
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/1/17
     */
    public function perFormEventGift($res,$con='EventGift'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);

                $pts = Pt::pluck('pt_name','id')->toArray();
                $goods_need = EventGiftService::getGift(true);

                foreach( $db as $k => $v ){

                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='pt_name'){
                            if (isset($pts[$v['pt_id']])) {
                                $rs[$k][strtolower(chr(65 + $num))] = $pts[$v['pt_id']];
                            }else{
                                $rs[$k][strtolower(chr(65 + $num))] = '暂无';
                            }
                        }elseif ($vg=='gift_state_name'){
                            if ($v['gift_state'] == 1) {//礼品状态
                                $rs[$k][strtolower(chr(65+$num))] = '未处理';
                            } elseif ($v['gift_state'] == 5) {
                                $rs[$k][strtolower(chr(65+$num))] = '已处理';
                            } elseif ($v['gift_state'] == 50) {
                                $rs[$k][strtolower(chr(65+$num))] = '已撤销';
                            }
                        }elseif($vg=='goods_info_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $goods_need[$v['goods_info']]??'未设定';;
                        }elseif($vg=='express_num'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['express_num'];
                        }
                        elseif ($vg == 'order_num'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['order_num'];
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
}
    /**
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/2/7
     */
    public function perFormRefund($res,$con='Refund'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);

                $pts = Pt::pluck('pt_name','id')->toArray();
                $adminArr = Admin::where('admin_group',2)->pluck('company_name','id')->toArray();

                $order_status_name = OrderService::getOrderStatusName();//获取订单状态数组


                foreach( $db as $k => $v ){

                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='pt_name'){
                            if (isset($pts[$v['pt_id']])) {
                                $rs[$k][strtolower(chr(65 + $num))] = $pts[$v['pt_id']];
                            }else{
                                $rs[$k][strtolower(chr(65 + $num))] = '暂无';
                            }
                        }elseif ($vg=='status_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $order_status_name[$v['order_status']]??'未确认';
                        }/*elseif($vg=='user_info'){
                            $rs[$k][strtolower(chr(65+$num))] = $v['shr_name'].' '.$v['shr_phone'].' '.$v['shr_sheng'].$v['shr_shi'].$v['shr_xian'].$v['shr_adress'];
                        }*/elseif($vg=='receive_info'){
                            if (isset($adminArr[$v['ser_id']])){
                                $rs[$k][strtolower(chr(65+$num))] = $adminArr[$v['ser_id']];
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = "无";
                            }
                        }
                        elseif ($vg == 'order_num'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['order_num'];
                        }elseif($vg=='cd_name'){
                            $rs[$k][strtolower(chr(65+$num))] = CategoryService::getNameByCdId($v['category']);//订单类型
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }


    /**
     * @name 第三方付款导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/2/8
     */
    public function perFormSettlementThree($res,$con='SettlementThree'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);

                $pts = Pt::pluck('pt_name','id')->toArray();
                $adminArr = Admin::where('admin_group',2)->pluck('company_name','id')->toArray();

                //$order_status_name = OrderService::getOrderStatusName();//获取订单状态数组
                $three_statusname = SettlementThreeService::getSettlementThreeStatusName(1);

                foreach( $db as $k => $v ){

                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='pt_name'){
                            if (isset($pts[$v['p_id']])) {
                                $rs[$k][strtolower(chr(65 + $num))] = $pts[$v['p_id']];
                            }else{
                                $rs[$k][strtolower(chr(65 + $num))] = '暂无';
                            }
                        }elseif ($vg=='three_statusname'){
                            $rs[$k][strtolower(chr(65+$num))] = $three_statusname[$v['three_status']];
                        }/*elseif($vg=='user_info'){
                            $rs[$k][strtolower(chr(65+$num))] = $v['shr_name'].' '.$v['shr_phone'].' '.$v['shr_sheng'].$v['shr_shi'].$v['shr_xian'].$v['shr_adress'];
                        }*/elseif($vg=='receive_info'){
                            if (isset($adminArr[$v['ser_id']])){
                                $rs[$k][strtolower(chr(65+$num))] = $adminArr[$v['ser_id']];
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = "无";
                            }
                        }
                        elseif ($vg == 'order_num'){
                            $rs[$k][strtolower(chr(65+$num))] = '`'.$v['order_num'];
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }


    /**
     * 车膜售后列表导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/2/17
     */
    public function performAftersaleOrderCarfilms($res,$con='AftersaleOrderCarfilms'){

        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];

            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $ser_id = array_column($db, 'ser_id');
                $ser_id = array_unique($ser_id);
                $msg_id = array_column($db, 'msg_id');
                $order_num = array_column($db, 'order_num');
                $msg = DB::table("order_msg")->whereIn('id',$msg_id)->pluck('goods_id','id');
                $admin = Admin::whereIn('id',$ser_id)->select('id','company_name','ad_alias')->get()->toarray();
                $admin = CommonService::jointArrayKey($admin,'id');
                $admin_infor = DB::table("admin_infor")->whereIn('admin_id',$ser_id)->whereRaw("admin_dressi!=''")->select('admin_id','admin_province','admin_dressi')->get()->toarray();
                $admin_infor = CommonService::jointArrayKey($admin_infor,'admin_id');

                $get_id = array_column($db,'get_id');
                $get_id = array_unique($get_id);
                $get_info = Admin::whereIn('id',$get_id)->pluck('admin_acc','id')->toarray();

                $type_name = SetmoneyType::pluck('sety_name','sety_id')->toarray();

                $order_status = OrderService::getOrderStatusName(true);

                $num1 = count($db);
                foreach( $db as $k => $v ){
                    unset($msg[$v['msg_id']]);
                    $time = explode(" ",$v['create_time']);
                    $time = explode("-",$time[0]);
                    $order_time = explode(' ',$v['order_time'])[0];
                    $order_time = explode("-",$order_time);
                    $area = $this->check_dress($v['shr_sheng'], $v['shr_shi'], $v['shr_xian']);
                    $note = DB::table('note')->whereRaw("orders_id='".$v['sys_num']."' and note_content like '【售后】%'")->select('note_name','note_content','note_time')->orderBy('id','DESC')->first();
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='pt_name'){
                            if($v['p_id']){
                                $pt_name = Pt::where('id',$v['p_id'])->value('pt_name');
                                $rs[$k][$kg] = $pt_name;
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }elseif($vg=='shr_sheng'){
                            $rs[$k][$kg] = $area[0];
                        }elseif($vg=='shr_shi'){
                            $rs[$k][$kg] = $area[1];
                        }elseif($vg=='shr_xian'){
                            $rs[$k][$kg] = $area[2];
                        }elseif($vg=='shop_name'){
                            $rs[$k][$kg] =  $admin[$v['ser_id']]['company_name'];//门店名称
                        }elseif($vg=='shop_alias'){
                            $rs[$k][$kg] =  $admin[$v['ser_id']]['ad_alias'];//门店别名
                        }elseif($vg=='time_span'){
                            $period = ceil(strtotime($v['create_time'])-strtotime($v['order_time']));
                            $a = floor($period/86400/30); //月数
                            $b = floor($period/86400)-$a*30;//天数
                            $rs[$k][$kg] = $a.'月'.$b.'天';
                        }elseif ($vg=='shr_address'){
                            $rs[$k][$kg] = $admin_infor[$v['ser_id']]['admin_province'].$admin_infor[$v['ser_id']]['admin_dressi'];//门店地址
                        }elseif($vg=='note'){
                            $rs[$k][$kg] = $note['note_name'].":".$note['note_content'];
                        }elseif($vg=='feek_time'){
                            $rs[$k][$kg] = $note['note_time'];
                        }
                        elseif($vg=='order_status_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $order_status[$v['order_status']];
                        }
                        elseif ($vg == 'order_num'){
                            $rs[$k][$kg] = '`'.$v['order_num'];
                        }
                        elseif($vg=='Y'){
                            $rs[$k][$kg] = $time[0];//年
                        }elseif($vg=='M'){
                            $rs[$k][$kg] = $time[1];//月
                        }elseif($vg=='D'){
                            $rs[$k][$kg] = $time[2];//日
                        }elseif($vg=='oY'){
                            $rs[$k][$kg] = $order_time[0];//年
                        }elseif($vg=='oM'){
                            $rs[$k][$kg] = $order_time[1];//月
                        }elseif($vg=='oD'){
                            $rs[$k][$kg] = $order_time[2];//日
                        }elseif ($vg=='get_name'){
                            $rs[$k][$kg] = $get_info[$v['get_id']];//领取人oad_installstate
                        }elseif ($vg=='oad_installstate'){
                            if($v['oad_installstate']==2){
                                $rs[$k][$kg] = '已安装';
                            }else{
                                $rs[$k][$kg] = '未安装';
                            }
                        }elseif ($vg=='finish_times'){
                            if($v['oad_dealtime']!=''){
                                if($v['get_time']!=''){
                                    $rs[$k][$kg] = $this->computeTime($v['get_time'],$v['oad_dealtime']);
                                }else{
                                    $rs[$k][$kg] = $this->computeTime($v['create_time'],$v['oad_dealtime']);
                                }//耗时
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }elseif($vg=='deal_with_times'){
                            if($v['get_time']!=''){
                                $rs[$k][$kg] = $this->computeTime($v['create_time'],$v['get_time']);
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }
                        elseif($vg=='oad_typepid_name'){
                            $rs[$k][$kg] = $type_name[$v['oad_typepid']]??'';
                        }elseif($vg=='oad_type_name'){
                            $rs[$k][$kg] = $type_name[$v['oad_type']]??'';
                        }elseif ($vg=='oad_dealptype_name'){
                            $rs[$k][$kg] = $type_name[$v['oad_dealptype']]??'';
                        }elseif ($vg=='oad_dealtype_name'){
                            $rs[$k][$kg] = $type_name[$v['oad_dealtyp']]??'';
                        }elseif($vg=='oad_recycle_name'){
                            if($v['oad_recycle']==2){
                                $rs[$k][$kg] = '已回收';
                            }else{
                                $rs[$k][$kg] = '未回收';
                            }
                        }else{
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }

                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                //dump($rs);
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    public function computeTime($begin_time , $end_time = '' ){
        if($begin_time < $end_time){
            $starttime = $begin_time;
            $endtime = $end_time;
        }else{
            $starttime = $end_time;
            $endtime = $begin_time;
        }
        $starttime = strtotime($starttime);
        $endtime = strtotime($endtime);
        //计算天数
        $timediff = $endtime-$starttime;
        $days = intval($timediff/86400);
        //计算小时数
        $remain = $timediff%86400;
        $hours = intval($remain/3600);
        //计算分钟数
        $remain = $remain%3600;
        $mins = intval($remain/60);
        //计算秒数
        $secs = $remain%60;
        $res = array("day" => $days,"hour" => $hours,"min" => $mins,"sec" => $secs);
        return $days.'天'.$hours.'小时'.$mins.'分钟';
    }

    /**
     * @name 服务商导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/2/24
     */
    public function perFormServiceProvider($res,$con='serviceProvider'){

        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];

            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $entypenames = ServiceProviderService::getEnable(true);
                $brandServersNames = ServiceProviderService::getBrandService(true);
                $issix = ServiceProviderService::getFsixName(true);
                $goodbrand = PjBrandsService::getAll();
                $goodbrand = CommonService::jointArrayKey($goodbrand,'id');


                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                      if($vg=='enable_name'){
                            $rs[$k][$kg] = $entypenames[$v['enable']];
                        }
                      elseif($vg=='brand_service_name'){
                          $brandSername = [];
                          $brandsIds = explode(',', trim($v['brand_service'],','));//变为数组
                          foreach ($brandsIds as $kk => $vvv){
                              $brandSername[] = $brandServersNames[$vvv];
                          }
                          $rs[$k][$kg] = implode(',',$brandSername);
                      }
                      elseif($vg=='ad_brand_name'){
                          $ad_b_name = '';
                          if(isset($v['ad_brand'])){
                              $ad_brand = [];
                              $ad_brandIds = explode(',', trim($v['ad_brand'],','));//变为数组
                              foreach ($ad_brandIds as $kk => $vvv){
                                  $ad_brand[] = $goodbrand[$vvv]['brand_name'];
                              }
                              $ad_b_name = implode(',', $ad_brand);
                          }
                          $rs[$k][$kg] = $ad_b_name??'';
                      }
                      elseif($vg=='ad_project_name'){
                          if(isset($v['ad_project'])){
                              $ad_projects = explode(',', trim($v['ad_project'],','));//变为数组
                              $ad_projectsnames = CategoryName::whereIn('cn_id',$ad_projects)->pluck('cn_cname')->toarray();
                              $ad_project_name = implode(',', $ad_projectsnames);
                          }
                          $rs[$k][$kg] = $ad_project_name??'';
                      }elseif($vg=='is_fsix_name'){
                          if(isset($v['is_fsix'])){
                              $isF6 = $issix[$v['is_fsix']];
                          }
                          $rs[$k][$kg] = $isF6??'';
                      }
                      else{
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }

                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                //dump($rs);
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }


    /**
     * @name 回收列表导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/3/3
     */
    public function perFormRecycleOrder($res,$con='RecycleOrder'){

        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];

            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $ptids = array_unique(array_column($db, 'p_id'));
                $pts = Pt::where('id',$ptids)->pluck('pt_name','id')->toArray();
                $dealType = RecycleOrderService::getDealType('',1);

                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        if($vg=='pt_name'){
                            $rs[$k][$kg] = $pts[$v['p_id']];
                        }
                        elseif($vg=='dealtype_statusname'){

                            $rs[$k][$kg] = $dealType[$v['rog_dealtype']];
                        }
                     elseif($vg=='ro_ordernum'){

                            $rs[$k][$kg] = '`'.$v['ro_ordernum'];
                        }
                        else{
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                //dump($rs);
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * @name F6订单导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/3/4
     */
    public function perFormF6StoreOrder($res,$con='F6StoreOrder'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $ser_ids = array_column($data['list'], 'ser_id');
                $sever_names = DB::table('admin')->whereIn('id',$ser_ids)->pluck('company_name','id');
                $status_names  = F6StoreOrderService::getResultStateName();
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        if($vg=='result_state_name'){
                            $rs[$k][$kg] = $status_names[$v['result_state']];
                        }//
                        elseif($vg=='ser_name'){
                            $rs[$k][$kg] = $sever_names[$v['ser_name']];
                        }
                        elseif($vg=='order_id_sub'){
                            $rs[$k][$kg] = '`'.$v['order_id_sub'];
                        }
                        elseif($vg=='order_id'){
                            $rs[$k][$kg] = '`'.$v['order_id'];
                        }else{
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                //dump($rs);
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * name 账目中心发票导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/3/15
     */
    public function perFormInvoiceExcel($res,$con='InvoiceExcel'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){

                $num1 = count($db);
                foreach( $db as $k => $v ){
                    foreach( $group as $kg => $vg ){
                        if($vg=='account'){
                            $rs[$k][$kg] = '`'.$v['account'];
                        }
                        else{
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                //dump($rs);
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }


    /**
     * @name 商品订单导出
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/5/12
     * @Time: 14:10
     */
    public function performOrdersMsg($res,$con='OrdersMsg'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                $statu_name = OrderService::getOrderStatusName();
                $goods_service_name = OrderService::getGoodsServiceName();
                if(in_array('ser_name', $group) || in_array('shop_alias', $group)) {
                    $ser_ids = array_column($db, 'ser_id');
                    $admin = Admin::whereIn('id',$ser_ids)->select('id','company_name','ad_alias')->get()->toarray();
                    $admin = CommonService::jointArrayKey($admin,'id');
                }
                if(!empty(array_intersect(['wam','feed_time','all_price','intall_person'], $group))){
                    $order_num = array_column($db, 'order_num');
                    $sql = "SELECT feeds_time,wat_num,a.order_num,all_price,a.intall_person FROM gone_order_list as a LEFT JOIN gone_settlement_list as b on a.serial_number = b.list_id where a.order_num in ('".implode("','", $order_num)."')";
                    $settment = DB::select($sql);
                    $settment = CommonService::dataToArray($settment);
                    $settment = CommonService::jointArrayKey($settment, 'order_num');
                }
                foreach( $db as $k => $v ){
                    //$msgArr = OrderService::getOrderMsg($v['sys_num']);
                   // $msgArr = $msgArr['orderMsgArr'];
                    $time = explode(" ",$v['create_time']);
                    $year = explode("-",$time[0])[0];
                    $mouth = explode("-",$time[0])[1];
                    $day = explode("-",$time[0])[2];
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        /*if($vg=='goods_num'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_num'];
                        }elseif($vg=='goods_name'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_name'];
                        }elseif($vg=='goods_price'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_price'];
                        }elseif($vg=='goods_number'){
                            $rs[$k][strtolower(chr(65+$num))] = $msgArr[0]['goods_number'];
                        }else*/if($vg=='goods_service'){
                            $rs[$k][strtolower(chr(65+$num))] = $goods_service_name[$v['goods_service']];
                        }elseif ($vg=='order_status'){
                            $rs[$k][strtolower(chr(65+$num))] = $statu_name[$v['order_status']];
                        }elseif ($vg == 'order_num'){
                            $rs[$k][strtolower(chr(65+$num))]  = '`'.$v['order_num'];
                        }elseif ($vg == 'ser_name'){
                            $rs[$k][strtolower(chr(65+$num))]  = $admin[$v['ser_id']]['company_name'];
                        }elseif ($vg == 'shop_alias'){
                            $rs[$k][strtolower(chr(65+$num))]  = $admin[$v['ser_id']]['ad_alias'];
                        }elseif($vg == 'wam'){
                            $rs[$k][strtolower(chr(65+$num))]  = $settment[$v['order_num']]['wat_num'];
                        }elseif($vg == 'feed_time'){
                            $rs[$k][strtolower(chr(65+$num))]  = $settment[$v['order_num']]['feeds_time'];
                        }elseif($vg == 'all_price'){
                            $rs[$k][strtolower(chr(65+$num))]  = $settment[$v['order_num']]['all_price'];
                        }elseif($vg == 'intall_person'){
                            $rs[$k][strtolower(chr(65+$num))]  = $settment[$v['order_num']]['intall_person'];
                        }elseif($vg == 'creact_year'){
                            $rs[$k][strtolower(chr(65+$num))]  = $year;
                        }elseif($vg == 'creact_mouth'){
                            $rs[$k][strtolower(chr(65+$num))]  = $mouth;
                        }elseif($vg == 'creact_day'){
                            $rs[$k][strtolower(chr(65+$num))]  = $day;
                        }
                        else{
                            $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }

    /**
     * @name 缴费记录
     * @param $res
     * @param string $con
     * @return mixed
     * @author du
     * @date 2022/5/12
     * @Time: 14:10
     */
    public function performPayOverList($res,$con='PayOverList'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $data = $this->excelOut->getDatas($con, $res, $detail);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    if ($v['reo_type'] == 1){
                        $reo_type_name = "充值";
                        if ($v['reo_pay_way'] == 1){
                            $reo_pay_way_name = "微信";
                        }elseif($v['reo_pay_way'] == 2){
                            $reo_pay_way_name = "支付宝";
                        }elseif($v['reo_pay_way'] == 3){
                            $reo_pay_way_name = "线下打款";
                        } else {
                            $reo_pay_way_name = "--";
                        }
                    }elseif($v['reo_type'] == 2){
                        $reo_type_name = "扣费";
                        $reo_pay_way_name = "派单扣费";
                    } elseif($v['reo_type'] == 3) {
                        $reo_type_name = "扣费";
                        $reo_pay_way_name = "月费扣费";
                    }
                    if ($v['reo_pay_state'] == 1){
                        $reo_pay_state_name = "未支付";
                    }elseif($v['reo_pay_state'] == 2){
                        $reo_pay_state_name = "已支付";
                    }

                    if ($v['reo_client_type'] == 1){
                        $reo_client_type_name = "服务商";
                    }elseif($v['reo_client_type'] == 2){
                        $reo_client_type_name = "经销商";
                    } else {
                        $reo_client_type_name = "其他";
                    }
                    if ($v['reo_pay_time'] == '0000-00-00 00:00:00') {
                        $v['reo_pay_time'] = "--";
                    }
                    $com_name = DB::table('company')
                        ->where('com_id', $v['reo_company_id'])
                        ->value('com_name');
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if($vg=='reo_order_number'){
                            $rs[$k][strtolower(chr(65+$num))] = '`' . $v['reo_order_number'];
                        }elseif ($vg=='reo_type'){
                            $rs[$k][strtolower(chr(65+$num))] = $reo_type_name;
                        }elseif ($vg == 'reo_price'){
                            $rs[$k][strtolower(chr(65+$num))]  = $v['reo_price'];
                        }elseif ($vg == 'reo_pay_time'){
                            $rs[$k][strtolower(chr(65+$num))]  = $v['reo_pay_time'];
                        }elseif ($vg == 'reo_pay_way'){
                            $rs[$k][strtolower(chr(65+$num))]  = $reo_pay_way_name;
                        }elseif($vg == 'reo_client_type'){
                            $rs[$k][strtolower(chr(65+$num))]  = $reo_client_type_name;
                        }elseif($vg == 'com_name'){
                            $rs[$k][strtolower(chr(65+$num))]  = $com_name;
                        }elseif($vg == 'reo_pay_state'){
                            $rs[$k][strtolower(chr(65+$num))]  = $reo_pay_state_name;
                        }
                        // else{
                        //     $rs[$k][strtolower(chr(65+$num))] = "\t".$v[$vg]."\t";
                        // }
                    }
                    $datas = $rs[$k];
                    $datas = $this->excelOut->replaceData($datas);
                    $strexport = implode("\t",$datas)."\r";
                    $strexport = iconv("UTF-8", "gbk//IGNORE", $strexport);
                    file_put_contents($file, $strexport, FILE_APPEND);
                    unset($strexport);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item'] + $num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功1');
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return $this->success('操作成功2');
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return $this->success('操作成功3');
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 门店服务明细导出
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/11/6 11:29
     * |---------------------------------------------------------------------------------
    */
    public function performSerStatisticsDetail($res,$con='SerStatisticsDetail'){
        $detail = DB::table("excel_detail")->where("ed_elid", $res['el_id'])->where("ed_state", '1')->first();
        if ($detail) {
            $exporter = New BasicExport();
            $data = $exporter->creacrExporHeader($con, $res, $detail, 'B2');
            if ($data['db']) {
                $return = $exporter->addExceleDara($res, $detail, $data['file'], $data['db'], $data['group']);
                return $this->success('操作成功1');
            } else {
                DB::table("excel_detail")->where("ed_id", $detail['ed_id'])->update(['ed_state' => 2]);
                return $this->success('操作成功2');
            }
        } else {
            DB::table("excel_list")->where('el_id', $res['el_id'])->update(['el_state' => 2]);
            return $this->success('操作成功3');
        }
    }
}



