<?php
namespace App\Http\Controllers\ExcelInfo;
use App\Http\Controllers\BaseController;
use App\Services\ExcelListService;
use Illuminate\Http\Request;
use DB;
use BlueCity\Core\Inc\ErrorInc;
/**
 * @name 导出列表
 * Class ExcelListController
 * @package App\Http\Controllers\Pt
 */
class ExcelListController extends BaseController
{
    /**
     * @name 列表页
     * @param el_adminid    操作人ID
     * @param el_action      模块名
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/8/27
     */
    public function index (Request $request)
    {
        $input = $request->all();
        $session = $request->get('session_token');
        $list = ExcelListService::getList($input,$session);
        if($list['list']){
            return $this->success('获取成功', $list); exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
        }
    }


    /**
     * @name 添加下载次数
     * @param  el_id ID
     * @param Request $request
     * @author du
     * @date 2021/8/27
     */
    public function addDownloudnum (Request $request)
    {
        $input = $request->only('el_id');
        $db = DB::table('excel_list');
        $id = intval($input['el_id']);
        if (!$id){
            $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
        }
        $res = $db->where('el_id',$id)->increment('el_next',1);
        $path = DB::table('excel_list')->where('el_id',$id)->select('el_path','el_dataname','el_creactime')->first();
        $reduce_path = $path['el_path'].'.zip';
        $isexist = file_exists($reduce_path);
        if(!$isexist){
            return $this->error('文件不存在', ErrorInc::DATA_EMPTY);exit;
        }
        $filePath = $reduce_path;
        $file = fopen ( $filePath, "rb" );


        //告诉浏览器这是一个文件流格式的文件
        Header ( "Content-type: application/octet-stream" );
        //请求范围的度量单位
        Header ( "Accept-Ranges: bytes" );
        //Content-Length是指定包含于请求或响应中数据的字节长度
        Header ( "Accept-Length: " . filesize ( $filePath ) );
        //用来告诉浏览器，文件是可以当做附件被下载，下载后的文件名称为$file_name该变量的值。
        Header ( "Content-Disposition: attachment; filename = " . $path['el_dataname'].$path['el_creactime'].'.zip');

        //读取文件内容并直接输出到浏览器
        echo fread ( $file, filesize ( $filePath ) );
        fclose ( $file );

    }




}
