<?php
/**
 * 测试文件（权限服务）
 * 文件简单描述（权限基础操作权限）
 * @author DouBin
 * @Date: 2023-07-07 007
 * @Time: 下午 3:59:11
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Http\Controllers\Dou;

use App\Exports\BasicExport;
use App\Http\Controllers\Api\SynJdRapidController;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\Orders\AotuorderController;
use App\Models\Admin;
use App\Models\JdBound;
use App\Models\OrderList;
use App\Models\OrderMsg;
use App\Models\OrderRejected;
use App\Models\Orders;
use App\Models\PjGoods;
use App\Models\Pt;
use App\Models\RechargeOrder;
use App\Models\User;
use App\Services\CommonService;
use App\Services\OrderaddService;
use App\Services\OrderService;
use Chumper\Zipper\Zipper;
use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\TechnicalLevelService;
use BlueCity\Core\Inc\ErrorInc;
use DB;
use ACES\TDEClient;
class MyTestController extends BaseController
{
    public function test ( Request $request ){
        $input = $request->all();
        $AotuorderController = new AotuorderController();
        $data = $AotuorderController->Distrib($input['sys_num'], '192.168.1.140');
        return response()->json(['code'=>201, 'msg'=>'授权失败', 'data'=>$data]);
    }

    /**|---------------------------------------------------------------------------------
     * @name 方法入口
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/8/20 10:59
     * |---------------------------------------------------------------------------------
     */
    public function dataApi ( Request $request ){
        $input = $request->all();
        if(empty($input['method'])){
            return $this->error('缺少必要参数1',ErrorInc::FAILED_PARAM);
        }
        $api=['getSerStatistics','getSerStatisticsDetail','BasicExport','addOrderData','addOrderDatas','sysServiseCenter','getJdOrderStatus','getDataDecrypt','calculateOrderPrice','omnicOrderList'];
        if(!in_array($input['method'],$api)){
            return $this->error('接口不参数异常',ErrorInc::INVALID_PARAM,$input);
        }else {
            $api = (string)$input['method'];
            return $this->$api($input);
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取京东token
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/9/29 8:56
     * |---------------------------------------------------------------------------------
    */
    public function getSerStatistics ( $input ){
        if(empty($input['company_id'])){
            $html="<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><h1>请输入公司id</h1></html>";
            echo $html;exit;
        }
        $admindata = Admin::whereRaw("((company_id='".$input['company_id']."' and admin_groupnew=2) or admin_groupnew=3) and enable=1")
            ->select('id','company_name')
            ->get();
        $admindata = CommonService::dataToArray($admindata);
        if($admindata){
            $time_start = $input['time_start'];
            $time_end = date("Y-m-d", strtotime($input['time_end'] . " +1 day"));
            $html = "<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><table>";
            $html .= "<tr>";
            $html .= "<td rowspan='2'>序号</td><td rowspan='2'>服务商（公司名称）</td><td colspan='6'>本周".date("m-d", strtotime($input['time_start']))."-".date("m-d", strtotime($input['time_end']))."</td><td colspan='6'>累计至今</td>";
            $html .= "</tr>";
            $html .= "<tr>";
            $html .= "<td>总推送单量</td><td>接单量</td><td>拒单量</td><td>拒单率</td><td>接单时效</td><td>履约时效</td><td>总推送单量</td><td>接单量</td><td>拒单量</td><td>拒单率</td><td>接单时效</td><td>履约时效</td>";
            $html .= "</tr>";
            foreach($admindata as $k => $v){
                $order_listnum = OrderList::whereRaw("ser_id='".$v['id']."' and create_time BETWEEN '".$time_start."' and '".$time_end."' and is_delete=1 and get_time != '' and company_id = '".$input['company_id']."'")->count();//接单数量
                $order_rejectednum = OrderRejected::leftjoin('orders', 'or_order_num', '=', 'order_num')->whereRaw("or_ser_id='".$v['id']."' and or_creact_time BETWEEN '".$time_start."' and '".$time_end."' and or_show=1 and company_id = '".$input['company_id']."'")->count();//拒单数量
                $order_listAllnum = OrderList::whereRaw("ser_id='".$v['id']."' and create_time BETWEEN '2024-08-19' and '".$time_end."' and is_delete=1 and get_time != '' and company_id = '".$input['company_id']."'")->count();//总接单数量
                $order_rejectedAllnum = OrderRejected::leftjoin('orders', 'or_order_num', '=', 'order_num')->whereRaw("or_ser_id='".$v['id']."' and or_creact_time BETWEEN '2024-08-19' and '".$time_end."' and or_show=1 and company_id = '".$input['company_id']."'")->count();//总拒单数量
                $sql = "SELECT CAST((SUM(UNIX_TIMESTAMP(feeds_time))-SUM(UNIX_TIMESTAMP(get_time)))/COUNT(id) as SIGNED) as timenum FROM gone_order_list WHERE ser_id='".$v['id']."' and get_time != '' and get_time!='0000-00-00 00:00:00' and feeds_time != '' and feeds_time!='0000-00-00 00:00:00' and create_time BETWEEN '".$time_start."' and '".$time_end."' and is_delete=1 and company_id = '".$input['company_id']."'";
                $data = DB::select($sql);
                $sql1 = "SELECT CAST((SUM(UNIX_TIMESTAMP(get_time))-SUM(UNIX_TIMESTAMP(create_time)))/COUNT(id) as SIGNED) as pdnum FROM gone_order_list WHERE ser_id='".$v['id']."' and get_time != '' and get_time!='0000-00-00 00:00:00' and create_time BETWEEN '".$time_start."' and '".$time_end."' and time(create_time)>='08:30:00' and time(create_time)<='18:00:00' and is_delete=1 and company_id = '".$input['company_id']."'";
                $data1 = DB::select($sql1);
                $sqls = "SELECT CAST((SUM(UNIX_TIMESTAMP(feeds_time))-SUM(UNIX_TIMESTAMP(get_time)))/COUNT(id) as SIGNED) as timenum FROM gone_order_list WHERE ser_id='".$v['id']."' and create_time BETWEEN '2024-08-19' and '".$time_end."' and get_time != '' and get_time!='0000-00-00 00:00:00' and feeds_time != '' and feeds_time!='0000-00-00 00:00:00' and is_delete=1 and company_id = '".$input['company_id']."'";// and is_delete=1
                $datas = DB::select($sqls);
                $sqls1 = "SELECT CAST((SUM(UNIX_TIMESTAMP(get_time))-SUM(UNIX_TIMESTAMP(create_time)))/COUNT(id) as SIGNED) as pdnum FROM gone_order_list WHERE ser_id='".$v['id']."' and create_time BETWEEN '2024-08-19' and '".$time_end."' and get_time != '' and get_time!='0000-00-00 00:00:00' and time(create_time)>='08:30:00' and time(create_time)<='18:00:00' and is_delete=1 and company_id = '".$input['company_id']."'";// and is_delete=1
                $datas1 = DB::select($sqls1);
                $html .= "<tr>";
                $html .= "<td>".$v['id']."</td>";
                $html .= "<td>".$v['company_name']."</td>";
                $html .= "<td>".($order_listnum+$order_rejectednum)."</td>";
                $html .= "<td>".$order_listnum."</td>";
                $html .= "<td>".$order_rejectednum."</td>";
                if(($order_listnum+$order_rejectednum) == 0){
                    $html .= "<td>0.00%</td>";
                }else {
                    $gl = sprintf("%.2f", $order_rejectednum / ($order_listnum + $order_rejectednum) * 100);
                    $html .= "<td>" . $gl . "%</td>";
                }
                if($data){
                    $html .= "<td>".self::Compute_Time($data1[0]['pdnum'])."</td>";
                    $html .= "<td>".self::Compute_Time($data[0]['timenum'])."</td>";
                }else{
                    $html .= "<td>0时0分0秒</td>";
                    $html .= "<td>0时0分0秒</td>";
                }
                $html .= "<td>".($order_listAllnum+$order_rejectedAllnum)."</td>";
                $html .= "<td>".$order_listAllnum."</td>";
                $html .= "<td>".$order_rejectedAllnum."</td>";
                if(($order_listAllnum+$order_rejectedAllnum) == 0){
                    $html .= "<td>0.00%</td>";
                }else {
                    $gls = sprintf("%.2f", $order_rejectedAllnum / ($order_listAllnum + $order_rejectedAllnum) * 100);
                    $html .= "<td>" . $gls . "%</td>";
                }
                if($data){
                    $html .= "<td>".self::Compute_Time($datas1[0]['pdnum'])."</td>";
                    $html .= "<td>".self::Compute_Time($datas[0]['timenum'])."</td>";
                }else{
                    $html .= "<td>0时0分0秒</td>";
                    $html .= "<td>0时0分0秒</td>";
                }
                $html .= "</tr>";

            }
            $html .= "<table></html>";
            echo $html;
        }else{
            $html="<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><h1>无相应公司信息</h1></html>";
            echo $html;exit;
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取订单门店施工明细
     * @param string company_id 公司id
     * @param string time_start 开始时间
     * @param string time_end 结算是啊金
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2024/9/11 17:27
     * |---------------------------------------------------------------------------------
     */
    public function getSerStatisticsDetail ( $input ){
        if(empty($input['company_id'])){
            $html="<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><h1>请输入公司id</h1></html>";
            echo $html;exit;
        }
//        $admindata = Admin::where('company_id',$input['company_id'])
//            ->where('admin_groupnew',2)
//            ->where('enable',1)
//            ->pluck('company_name','id');
        $admindata = Admin::whereRaw("((company_id='".$input['company_id']."' and admin_groupnew=2) or admin_groupnew=3) and enable=1")
            ->pluck('company_name','id');
        $time_start = $input['time_start'];
        $time_end = date("Y-m-d", strtotime($input['time_end'] . " +1 day"));
        $sql = "SELECT (UNIX_TIMESTAMP(feeds_time)-UNIX_TIMESTAMP(get_time)) AS sgtime,(UNIX_TIMESTAMP(get_time)-UNIX_TIMESTAMP(create_time)) AS jdtime,stauas,order_num,ser_id,create_time,get_time,feeds_time FROM gone_order_list WHERE create_time BETWEEN '".$time_start."' and '".$time_end."' and is_delete=1 and company_id = ".$input['company_id']." order by create_time";
        $datas = DB::select($sql);
        $statusName = ['10'=>'未接单','20'=>'未接单','30'=>'安装中','34'=>'待审核','40'=>'已完成','50'=>'已撤销','55'=>'已撤销（补邮费）'];
        $html = "<html><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><table>";
        $html .= "<tr>";
        $html .= "<td>门店名称</td><td>单号</td><td>订单状态</td><td>创建时间</td><td>接单时间</td><td>反馈时间</td><td>接单时效</td><td>5分钟接单达标</td><td>10钟接单达标</td><td>履约时效</td><td>12小时履约达标</td><td>24小时履约达标</td><td>是否计入时效考核</td>";
        $html .= "</tr>";
        foreach($datas as $k => $v){
            $html .= "<tr>";
            $html .= "<td>".$admindata[$v['ser_id']]."</td>";
            $html .= "<td>".$v['order_num']."</td>";
            $html .= "<td>".$statusName[$v['stauas']]."</td>";
            $html .= "<td>".$v['create_time']."</td>";
            $html .= "<td>".$v['get_time']."</td>";
            $html .= "<td>".$v['feeds_time']."</td>";
            if($v['get_time'] != '' && $v['get_time'] != '0000-00-00 00:00:00'){
                $html .= "<td>".self::Compute_Time($v['jdtime'])."</td>";
                if($v['jdtime']<300){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
                if($v['jdtime']<600){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
            }else{
                $html .= "<td></td>";
                $html .= "<td>不达标</td>";
                $html .= "<td>不达标</td>";
            }

            if($v['feeds_time'] != '' && $v['feeds_time'] != '0000-00-00 00:00:00'){
                $html .= "<td>".self::Compute_Time($v['sgtime'])."</td>";
                if($v['sgtime']<43200){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
                if($v['sgtime']<86400){
                    $html .= "<td>达标</td>";
                }else{
                    $html .= "<td>不达标</td>";
                }
            }else{
                $html .= "<td></td>";
                $html .= "<td>不达标</td>";
                $html .= "<td>不达标</td>";
            }
            $time = explode(' ', $v['create_time'])[1];
            if($time>='08:30:00' && $time<='18:00:00'){
                $html .= "<td>是</td>";
            }else{
                $html .= "<td>否</td>";
            }
            $html .= "</tr>";
        }
        $html .= "<table></html>";
        echo $html;
    }
    /**|---------------------------------------------------------------------------------
     * @name 转化为时分秒
     * @param string timediff 时间
     * @retrun  /multitype:string
     * @author dou 2024/8/23 11:43
     * |---------------------------------------------------------------------------------
     */
    private function Compute_Time( $timediff ){
        $days = intval($timediff/86400);
        //计算小时数
        $remain = $timediff%86400;
        $hours = intval($remain/3600);
        //计算分钟数
        $remain = $remain%3600;
        $mins = intval($remain/60);
        //计算秒数
        $secs = $remain%60;
        //$res = array("day" => $days,"hour" => $hours,"min" => $mins,"sec" => $secs);
        $res = $days.'天'.$hours.'时'.$mins.'分'.$secs.'秒';
        return $res;
    }

    /**|---------------------------------------------------------------------------------
     * @name 自定义表头
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2024/10/22 14:43
     * |---------------------------------------------------------------------------------
    */
    public function BasicExport ( $input ){
        $exporter = New BasicExport();
//        $ewa = $exporter->creacrExporSerStatisticsDetail(json_decode($data,true));
//        $data = [];
//        $data[0] = $ewa;
//        return $this->error('接口不参数异常',ErrorInc::INVALID_PARAM,$data);
        $con='SerStatisticsDetail';
//        $id = intval($request->input('el_id'));
        $id = $input['el_id'];
        $res = DB::table("excel_list")
            ->where('el_id',$id)
            ->where('el_state','1')
            ->select("el_action","el_id","el_sql","el_path","el_item","el_adminid","company_id")
            ->orderBy('el_id','ASC')->first();
        if($res) {
            if (!file_exists($res['el_path'])) {
                // 创建文件夹
                mkdir($res['el_path'], 0775, true);
                chmod($res['el_path'], 0775);
            }
            $detail = DB::table("excel_detail")->where("ed_elid", $res['el_id'])->where("ed_state", '1')->first();
            if ($detail) {
                $data = $exporter->creacrExporHeader($con, $res, $detail, 'B2');
                if ($data['db']) {
                    $return = $exporter->addExceleDara($res, $detail, $data['file'], $data['db'], $data['group']);
                    return $this->success('操作成功1');
                } else {
                    DB::table("excel_detail")->where("ed_id", $detail['ed_id'])->update(['ed_state' => 2]);
                    return $this->success('操作成功2');
                }
            } else {
                DB::table("excel_list")->where('el_id', $res['el_id'])->update(['el_state' => 2]);
                return $this->success('操作成功3');
            }
        }else{
            $path = DB::table('excel_list')->where('el_id',$id)->value('el_path');
            $zipper = new Zipper();
            $arr = glob(public_path($path));   //$public_path  被压缩的文件名
            $reduce_path = $path.'.zip';
            $zipper->make(public_path($reduce_path))->add($arr)->close();  //public_path($reduce_path)  压缩之后 */
            $zip = new \ZipArchive();
            $zipStatus = $zip->open($reduce_path);
            if ($zipStatus !== true) {
                return $this->error('压缩失败', ErrorInc::FAILED_PARAM);exit;
            }
            DB::table("excel_list")->where('el_id',$id)->update(['el_state'=>2]);
            //	 = $this->baseurl().$reduce_path;
            return response()->json(['Data' =>'', 'ErrorMessage' => '执行完毕', 'ErrorCode' => 222]);exit;
        }

    }

    /**
     * @name 同步京东POP店未出库定单
     * @param Request $request
     * @author du
     * @date 2022/4/27
     */
    public function addOrderData ($input){
        $url = "http://116.196.75.172/index.php/GetOrder/index";

        $url_ex = "http://116.196.75.172/index.php/GetOrder/syncExpress";//出库

        $time_start = date("Y-m-d H:i:s",strtotime(" -3420 minute".date("Y-m-d H:i:s")));
        $time_end = date("Y-m-d H:i:s");
        $goods = DB::table('pj_goods')->select('pg_id','brand_name','pg_series','version','goods_pic_path','national_version')->get()->toarray();
        $goods = CommonService::jointArrayKey($goods, 'pg_id');
        $token = DB::table('jdpop_token')->where('status',1)->where('type',1)->select('app_key','app_secret','access_token','pt_id','appName')->get()->toarray();

        foreach ($token as $k =>$v){
            //  CommonService::addLog('token', json_encode($v['app_key']), $v['pt_id'],'jd_token');
            $res_ult = [];
            $res_ult[$k]['appKey'] = $v['app_key'];		//appkey
            $res_ult[$k]['appSecret'] = $v['app_secret'];	//secret
            $res_ult[$k]['accessToken'] = $v['access_token'];	//token
            $res_ult[$k]['time_start'] = $time_start;				//开始时间
            $res_ult[$k]['time_end'] = $time_end;				//结束时间
            $res_ult[$k]['setPageSize'] = 10;						//每页条数
            $res_ult[$k]['setOrderState']  = 'WAIT_SELLER_STOCK_OUT';	//订单状态 WAIT_SELLER_STOCK_OUT 等待出库 ,TRADE_CANCELED,POP_ORDER_PAUSE,LOCKED,WAIT_GOODS_RECEIVE_CONFIRM,WAIT_SELLER_DELIVERY
            $res_ult[$k]['setOptionalFields'] ='orderInfo,orderId,orderType,payType,orderTotalPrice,orderSellerPrice,open_id_buyer,open_id,orderMarkDesc,storeId,tuiHuoWuYou,taxFee,scDT,storeOrder,orderSource,customsModel,customs,parentOrderId,directParentOrderId,modified,vatInfo,logisticsId,paymentConfirmTime,returnOrder,balanceUsed,venderRemark,itemInfoList,consigneeInfo,orderEndTime,orderStartTime,orderRemark,invoiceCode,invoiceInfo,invoiceEasyInfo,orderStateRemark,orderState,sellerDiscount,orderPayment,venderId,pauseBizInfo,freightPrice';    //获取的订单字段

            /**TRADE_CANCELED,POP_ORDER_PAUSE,LOCKED
            这三个是取消的状态，还是通过获取订单那个接口，触发时间和获取订单时间一致就行，这个没有变更状态一说，所以需要你判定，比如五分钟查一次最近六分钟的取消订单，如果系统中未取消就锁定订单生成退款单，如果过系统中已经取消或者已经锁定退款单就不用管了**/

            $res_ult[$k]['page'] = 1;
            $res = $this->request_post($url,$res_ult[$k]);
            $ip = $_SERVER["REMOTE_ADDR"];
            $res='{"jingdong_pop_order_enSearch_responce":{"code":"0","request_id":"161875.39587.17333121021090126","searchorderinfo_result":{"apiResult":{"chineseErrCode":"成功","numberCode":10100000,"englishErrCode":"success","success":true},"orderTotal":35,"orderInfoList":[{"orderSellerPrice":"10.00","orderType":"22","venderRemark":"","logisticsId":"","orderId":"300473755730","sendpayMap":"{\"9\":\"2\",\"20\":\"5\",\"26\":\"2\",\"29\":\"1\",\"34\":\"3\",\"36\":\"1\",\"39\":\"1\",\"50\":\"1\",\"51\":\"6\",\"62\":\"1\",\"64\":\"2\",\"84\":\"1\",\"96\":\"1\",\"173\":\"2\",\"186\":\"1\",\"188\":\"3\",\"190\":\"2\",\"191\":\"1\",\"229\":\"1\",\"235\":\"2\",\"239\":\"2\",\"342\":\"1\",\"402\":\"3\",\"847\":\"1\",\"860\":\"1\",\"943\":\"1\",\"1007\":\"1\"}","orderRemark":"","venderId":"18433933","paymentConfirmTime":"2024-12-04 19:03:51","orderStateRemark":"等待出库","orderState":"WAIT_SELLER_STOCK_OUT","popSignMap":"{\"11\":\"1\",\"19\":\"1\"}","itemInfoList":[{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFB60/探界者/别克E5E6/本田/大众/奥迪","itemTotal":"1","outerSkuId":"","jdPrice":"608.00","invoiceContentId":"","skuId":"10127082830913","productNo":"","newStoreId":"0"},{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFB70/昂科拉/君越/创酷/科沃兹/威朗/丰田","itemTotal":"1","outerSkuId":"","jdPrice":"678.00","invoiceContentId":"","skuId":"10127082830914","productNo":"","newStoreId":"0"},{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFB80/君越/君威/威朗","itemTotal":"1","outerSkuId":"","jdPrice":"769.00","invoiceContentId":"","skuId":"10127082830915","productNo":"","newStoreId":"0"},{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFBQ85/马自达/奔腾/铃木/凯美瑞/汉兰达","itemTotal":"1","outerSkuId":"","jdPrice":"609.00","invoiceContentId":"","skuId":"10127082830916","productNo":"","newStoreId":"0"}],"payType":"4-在线支付","totalSellerReceivable":"10.000000","modified":"2024-12-04 19:04:05","freightPrice":"0.00","vatInfo":{},"balanceUsed":"0.00","orderSource":"移动端订单","invoiceInfo":"不需要开具发票","totalSellerDiscount":"2654.000000","shouldPay":"10.00","orderTotalPrice":"2664.00","storeId":"0","orderPayment":"10.00","consigneeInfo":{"town":"八五四农场","city":"鸡西市","mobile":"136*******2","county":"虎林市","telephone":"134*******7","cityId":"737","townId":"33230","provinceId":"10","province":"黑龙江","countyId":"740","fullAddress":"黑龙江鸡西市******","fullname":"张**","oaid":"ZDBjYzg5ABT5Yz05DTH47QCKVJNOXZu1Yjk1MpfVuAfLrAuYkgdrs9d5Bp2TQM4aJwTxKNDu3zmQuHGWJKJEPLnp2lNcsr3oS95J14OMddvp9OKcr8ed8KMSd0efsxC1QbLSjRc38HhZQq1AhUV2Jxhx38JXewtHLNDMiQ=="},"sellerDiscount":"2654.00","returnOrder":"0","invoiceEasyInfo":{"invoiceType":"0","invoiceContentId":"1","invoiceTitle":"个人"},"storeOrder":"","totalOriginalPrice":"2664.00","actualPay":"10.00","orderStartTime":"2024-12-04 19:03:38"},{"orderSellerPrice":"10.00","orderType":"22","venderRemark":"","logisticsId":"","orderId":"306537548398","sendpayMap":"{\"9\":\"2\",\"26\":\"2\",\"29\":\"1\",\"34\":\"3\",\"36\":\"1\",\"39\":\"1\",\"50\":\"1\",\"51\":\"6\",\"62\":\"1\",\"64\":\"3\",\"84\":\"1\",\"96\":\"1\",\"173\":\"2\",\"186\":\"1\",\"188\":\"3\",\"190\":\"2\",\"191\":\"1\",\"229\":\"1\",\"235\":\"2\",\"239\":\"2\",\"342\":\"1\",\"860\":\"1\",\"943\":\"1\",\"945\":\"1\",\"1007\":\"1\"}","orderRemark":"","venderId":"18433933","paymentConfirmTime":"2024-12-04 19:03:45","orderStateRemark":"等待出库","orderState":"WAIT_SELLER_STOCK_OUT","popSignMap":"{\"11\":\"1\",\"19\":\"1\"}","itemInfoList":[{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFB80/君越/君威/威朗","itemTotal":"1","outerSkuId":"","jdPrice":"769.00","invoiceContentId":"","skuId":"10127082830915","productNo":"","newStoreId":"0"},{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFB60/探界者/别克E5E6/本田/大众/奥迪","itemTotal":"1","outerSkuId":"","jdPrice":"608.00","invoiceContentId":"","skuId":"10127082830913","productNo":"","newStoreId":"0"},{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFB70/昂科拉/君越/创酷/科沃兹/威朗/丰田","itemTotal":"1","outerSkuId":"","jdPrice":"678.00","invoiceContentId":"","skuId":"10127082830914","productNo":"","newStoreId":"0"},{"wareId":"10027478481650","giftPoint":"0","skuName":"德科汽车电瓶启停蓄电池EFB系列 EFBQ85/马自达/奔腾/铃木/凯美瑞/汉兰达","itemTotal":"1","outerSkuId":"","jdPrice":"609.00","invoiceContentId":"","skuId":"10127082830916","productNo":"","newStoreId":"0"}],"payType":"4-在线支付","totalSellerReceivable":"10.000000","modified":"2024-12-04 19:04:05","freightPrice":"0.00","vatInfo":{},"balanceUsed":"0.00","orderSource":"移动端订单","invoiceInfo":"不需要开具发票","totalSellerDiscount":"2654.000000","shouldPay":"10.00","orderTotalPrice":"2664.00","storeId":"0","orderPayment":"10.00","consigneeInfo":{"town":"江南镇","city":"杭州市","mobile":"156*******0","county":"桐庐县","telephone":"158*******7","cityId":"1213","townId":"50207","provinceId":"15","province":"浙江","countyId":"1218","fullAddress":"浙江杭州市桐庐县******","fullname":"陈**","oaid":"N2I3NzIxABT5Yz05DTH47QCKVJNOXZu1Yjk1ModIy85ZAbUxhW/omviTzIpOU4//lMWfUJfEpEAxlJ6ozZBMc4QPnIb1c7ljRN6vP82dS2slRdr0284q4riuyKbnD/kJnmQbk5knzyKvUES/QPbPbPVL0ISQ19GJ1Ht3IQ=="},"sellerDiscount":"2654.00","returnOrder":"0","invoiceEasyInfo":{"invoiceType":"0","invoiceContentId":"1","invoiceTitle":"个人"},"storeOrder":"","totalOriginalPrice":"2664.00","actualPay":"10.00","orderStartTime":"2024-12-04 19:03:36"}]}}}';
            CommonService::addLog('token1--'.$v['pt_id'], $res, $v['pt_id'],'SynJdPopData-getOrder');


            $data = json_decode($res,true);
            if($data['jingdong_pop_order_enSearch_responce']['code']==0){

                $order_data = $data['jingdong_pop_order_enSearch_responce']['searchorderinfo_result']['orderInfoList'];
                if(!empty($order_data)){
                    $arr_goods = [];
                    $arr = [];
                    $num = 0;
                    foreach($order_data as $ksa => $vsa){
                        if(!empty($vsa['consigneeInfo']['oaid'])) {
                            $orderInfos[$num]['orderId'] = $vsa['orderId'];
                            $orderInfos[$num]['oaid'] = $vsa['consigneeInfo']['oaid'];
                            $num++;
                        }
                    }
                    if(!empty($orderInfos)){
                        $poss['appKey'] = $v['app_key'];
                        $poss['accessToken'] = $v['access_token'];
                        $poss['appSecret'] = $v['app_secret'];
                        $poss['orderType'] = 'POP';
                        $poss['appName'] = $v['appName'];
                        $poss['orderInfos'] = json_encode($orderInfos);
                        $user_data=$this->https_request('http://zptzchat.bluearp.com/m/index.php/GetUserDataApi/getOaidDecrypt',$poss);
                        $user_data = json_decode($user_data,true);
                        if($user_data['jingdong_jos_order_oaid_decrypt_responce']['returnType']['code']==200){
                            $user_data = $user_data['jingdong_jos_order_oaid_decrypt_responce']['returnType']['data'];
                            $user_datas = [];
                            foreach($user_data as $ks => $vs){
                                $user_datas[$vs['orderId']] = $vs;
                            }
                            if(!empty($user_datas)){
                                foreach($order_data as $ka => $va){
                                    $order_data[$ka]['user_data_dou'] = isset($user_datas[$va['orderId']])?$user_datas[$va['orderId']]:'';
                                }
                            }
                        }
                    }
                    // CommonService::addLog('token3', json_encode($order_data), $v['pt_id'],'jd_token');
                    foreach ($order_data as $kk=>$vv) {
                        $order_info = OrderService::getOrderBy('order_num', $vv['orderId'],['id','order_status','lock_type','sys_num','order_num','p_id','ser_id','create_time','new_customer_id','lock_type','company_id']);
                        $order_info = CommonService::dataToArray($order_info);
                        if(!empty($order_info)&&in_array($vv['orderState'], ['TRADE_CANCELED','POP_ORDER_PAUSE','LOCKED'])){
                            if($order_info['lock_type']==2||in_array($order_info['order_status'], [50,55])){
                                continue;
                            }else{
                                $datar['allprice'] = $vv['orderTotalPrice'];
                                $goods_arr = OrderMsg::where('sys_num',$order_info['sys_num'])->get(['id as msg_id','goods_name','goods_price','goods_id as good_id']);
                                $datar['goodsArr'] = CommonService::dataToArray($goods_arr);
                                $datar['goods_state'] = 2;//2:平台; 4:财务
                                $datar['sys_num'] = $order_info['sys_num'];
                                $datar['order_num'] = $order_info['order_num'];
                                $datar['apply_type'] = 1;
                                $datar['content'] = $vv['orderStateRemark'];
                                $datar['p_id'] = $order_info['p_id'];
                                $datar['ser_id'] = $order_info['ser_id'];
                                $datar['new_customer_id'] = $order_info['new_customer_id'];
                                $datar['order_status'] = $order_info['order_status'];
                                $datar['create_time'] = $order_info['create_time'];
                                $userArr = User::where('id',$order_info['new_customer_id'])->first();
                                $session['admin_groupnew'] = 7;
                                $session['admin_acc'] = '系统录入';
                                $session['id'] = 1133;
                                $session['company_id'] = $order_info['company_id'];
                                $ret = OrderService::lockByRefund($datar , $session , $userArr);
                                CommonService::addLog('取消订单', json_encode($ret), $vv['orderId'],'JDPOP-cancel');
                                continue;
                            }

                        }

                        // CommonService::addLog('token4', json_encode( $vv['orderId']), $v['pt_id'],'jd_token');
                        $exsit = OrderService::getOrderBy('order_num', $vv['orderId'],['id']);
                        $eisit_jd = DB::table('jd_proprietary')->where('order_id',$vv['orderId'])->value('id');
                        if(!$exsit||!$eisit_jd){
                            $flag = 1;
                            unset($skuId);
                            foreach( $vv['itemInfoList'] as $ka => $va ){
                                $skuId[] = "'".$va['skuId']."'";
                            }
                            $goodids = DB::table("jd_bound")->whereRaw("sku_id in (".implode(',',$skuId).")")->pluck('goods_id','sku_id')->toarray();
                            if(empty($goodids)){
                                CommonService::addLog('无sku', json_encode($skuId), $vv['orderId'],'JDPOP-无sku');
                                $flag = 2;
                            }
                            if($goodids){
                                if(count($goodids)<count($vv['itemInfoList'])){
                                    $flag = 2;
                                }
                            }

                            //解密
                            if(isset($vv['user_data_dou'])){
                                $str = $vv['user_data_dou']['customerName'];
                            }else {
                                $str = $vv['consigneeInfo']['fullname'];
                            }
                            $datafullname['accessToken'] = $v['access_token'];//'e0a1c90e617f4b3a9865ed059f99c5f42ztb';
                            $datafullname['appKey'] = $v['app_key'];;//'41D9668E8CB81C9890A065BEC300FD84';
                            $datafullname['appSecret'] = $v['app_secret'];//'93bff142bf5c4422ae7bec9eb992e751';

                            $fullname =  $this->decrypt($datafullname,$str,$vv['orderId']);
                            if(strpos($fullname,'<body>' )!==false){
                                //存另一数据库中
                                //是否存在
                                $exs_code = DB::table('jdpop_encode')->where('order_id',$vv['orderId'])->value('id');
                                if($exs_code){
                                    DB::table('jdpop_encode')->where('order_id',$vv['orderId'])->update(['name_code'=>$vv['consigneeInfo']['fullname']]);
                                }else{
                                    DB::table('jdpop_encode')->insert(['order_id'=>$vv['orderId'],'pt_id'=>$v['pt_id'],'name_code'=>$vv['consigneeInfo']['fullname']]);
                                }
                                $fullname = '无';
                            }

                            $fullname = $fullname??$vv['consigneeInfo']['fullname'];
                            if(isset($vv['user_data_dou'])){
                                $Address = $vv['user_data_dou']['address'];
                            }else {
                                $Address = $vv['consigneeInfo']['fullAddress'];
                            }
                            $fullAddress = $this->decrypt($datafullname,$Address,$vv['orderId']);

                            if(strpos($fullAddress,'<body>' )!==false){
                                //存另一数据库中
                                //是否存在
                                $exs_code = DB::table('jdpop_encode')->where('order_id',$vv['orderId'])->value('id');
                                if($exs_code){
                                    DB::table('jdpop_encode')->where('order_id',$vv['orderId'])->update(['address_code'=>$vv['consigneeInfo']['fullAddress']]);
                                }else{
                                    DB::table('jdpop_encode')->insert(['order_id'=>$vv['orderId'],'address_code'=>$vv['consigneeInfo']['fullAddress'],'pt_id'=>$v['pt_id']]);
                                }
                                $fullAddress = '无';
                            }

                            $fullAddress = $fullAddress??$vv['consigneeInfo']['fullAddress'];
                            $fullAddress = str_replace("'", '', $fullAddress);
                            $resjdgoods = DB::table('jdgoods')->where("order_id",$vv['orderId'])->value('id');
                            foreach( $vv['itemInfoList'] as $ka => $va ){
                                if(!$resjdgoods){
                                    $sql_dgoods .= "('".$vv['orderId']."',".$v['pt_id'].",'".$va['skuId']."','".$va['skuName']."','".$va['itemTotal']."','".$va['jdPrice']."','0'),";
                                    if(in_array($vv['orderId'], $arr_goods)){
                                        unset($arr_goods[$kk]);
                                    }

                                    $arr_goods[$kk]['order_id'] = $vv['orderId'];
                                    $arr_goods[$kk]['pt_id'] = $v['pt_id'];
                                    $arr_goods[$kk]['sku_id'] = $va['skuId'];
                                    $arr_goods[$kk]['item_total'] = $va['itemTotal'];
                                    $arr_goods[$kk]['jd_price'] = $va['itemTotal'];
                                    $arr_goods[$kk]['jd_cost'] = $va['jdPrice'];
                                    $arr_goods[$kk]['sku_name'] = $va['skuName'];
                                    DB::table('jdgoods')->insert($arr_goods[$kk]);
                                    unset($arr_goods[$kk]);

                                }
                                $sys_num = 'L'.date("YmdHis").str_pad(rand(0,999),3,'0',STR_PAD_LEFT);
                                if($flag==1) {
                                    $goodid = $goodids[$va['skuId']];
                                    if($goodid){
                                        $goods_res = $goods[$goodid];
                                        if($goods_res['pg_series']==''){
                                            $type = $goods_res['version'];
                                        }else{
                                            $type = $goods_res['pg_series']."-".$goods_res['version'];
                                        }
                                        $goods_name = $goods_name.$goods_res['brand_name'].",".$type.",".$goods_res['general_version'].",";
                                        $good_brand[] = $goods_res['brand_name'];

                                        $orderMsgData[$ka]['goods_id'] = $goodid;
                                        $orderMsgData[$ka]['goods_name'] = $goods_res['brand_name']."-".$type;
                                        $orderMsgData[$ka]['goods_price'] = $va['jdPrice'];//实收/商品单价
                                        // $orderMsgData['goods_paid'] = $va['jdPrice'];//应收
                                        $orderMsgData[$ka]['goods_num'] = $va['itemTotal'];
                                        $orderMsgData[$ka]['goods_brand'] = $goods_res['brand_name'];
                                        $orderMsgData[$ka]['goods_number'] = $type;
                                        $orderMsgData[$ka]['cd_id'] = 1;
                                        // dump($orderMsgData);
                                    }
                                }
                            }

                            //添单
//转换手机号
                            // $data['pt_name'] = $pt_name;//店铺名
                            $data_m[$kk]['order_id'] = $vv['orderId'];
                            $data_m[$kk]['appkey'] = $v['app_key'];		//appkey
                            $data_m[$kk]['appsecret'] = $v['app_secret'];	//secret
                            $data_m[$kk]['acctoken'] = $v['access_token'];	//token
                            $tel = $this->changeTelphone($data_m[$kk]);
                            if($flag==1){

                                $orders[$kk]['sys_bh'] = $sys_num;
                                $orders[$kk]['skb_bh'] = $vv['orderId'];
                                $orders[$kk]['pt_id'] = $v['pt_id'];
                                $orders[$kk]['ser_type'] = 1;//服务类型：1上门安装，2到店服务
                                $orders[$kk]['shr_name'] = $fullname;
                                $orders[$kk]['shr_phone'] = $tel??$vv['consigneeInfo']['telephone'];//$vv['consigneeInfo']['telephone'];//
                                $orders[$kk]['shr_sheng'] = $vv['consigneeInfo']['province'];//
                                $orders[$kk]['shr_shi'] = $vv['consigneeInfo']['city'];//
                                $orders[$kk]['shr_xian'] = $vv['consigneeInfo']['county'];//
                                $orders[$kk]['shr_adress'] = $fullAddress;//
                                $orders[$kk]['shr_other'] = '接单后10分钟内务必联系客户核实车型跟安装时间！不断电安装、如果无法完成 请立刻反馈我们处理~！';
                                $orders[$kk]['car_audit'] = 2;//1:新订单；2：可派单；3：处理中
                                $orders[$kk]['order_type'] = 1;//订单类型：1：普通；20加急；10：夜间
                                $orders[$kk]['order_time'] = $vv['orderStartTime'];
                                $orders[$kk]['pay_type'] = 1;//支付方式：1在线支付；2货到付款
                                $orders[$kk]['goods'] = $orderMsgData;

                                return response()->json(['Data' =>$orders, 'ErrorMessage' => '执行完毕', 'ErrorCode' => 222]);exit;
                                //   $session = $request->get('session_token');//获取操作人信息
                                $session['admin_groupnew'] = 7;
                                $session['admin_acc'] = '系统录入';
                                $session['id'] = 1133;
                                $session['company_id'] = 11;
                                // dump($orders[$kk]);
                                $return = OrderaddService::addOrder($orders[$kk], $session, $ip);
                                //    dump($return);
                                CommonService::addLog('添加定单', json_encode($return), $vv['orderId'],'jd_addOrder');
                                // $return['ErrorCode'] = 2;
                                if($return['ErrorCode']==1){
                                    //调用京东出库


                                    $res_ex = [];
                                    $res_ex['appKey'] = $v['app_key'];	//appkey
                                    $res_ex['appSecret'] = $v['app_secret'];//secret
                                    $res_ex['accessToken'] = $v['access_token'];	//token
                                    $res_ex['skb_bh'] = $vv['orderId'];//$vv['orderId'];
                                    $res_ex['jdid'] = 1274;
                                    $res_ex['kd_number'] = '';
                                    $res_ex['estimateDate'] = date("Y-m-d H:i:s");
                                    $result = $this->request_post($url_ex,$res_ex);//出库同步

                                    $filename = 'pop_ex'.date('Ym');
                                    CommonService::addLog('出库', json_encode($res_ex), $vv['orderId'],$filename);
                                    $reta = json_decode($result,true);
                                    if($reta['jingdong_pop_order_shipment_responce']['sopjosshipment_result']['success']==true){
                                        CommonService::addLog('添单成功出库', $result, $vv['orderId'],$filename);
                                    }else{
                                        CommonService::addLog('添单出库失败', $result, $vv['orderId'],$filename);
                                    }
                                    $newOrderId = true;
                                }else{
                                    $newOrderId = false;
                                }
                            }
                            $rea = DB::table('jd_proprietary')->where("order_id",$vv['orderId'])->value('id');
                            if (!$newOrderId || $flag=='2'){
                                //echo '添加订单信息失败';
                                if(!$rea){
                                    if(in_array($vv['orderId'], array_column($arr, 'order_id'))){
                                        unset($arr[$kk]);
                                    }
                                    $arr[$kk]['order_id'] = $vv['orderId'];
                                    $arr[$kk]['admin_acc'] = '系统录入';
                                    $arr[$kk]['pt_id'] = $v['pt_id'];
                                    $arr[$kk]['pay_type'] = $vv['payType'];
                                    $arr[$kk]['order_seller_price'] = $vv['orderSellerPrice'];
                                    $arr[$kk]['freight_price'] = $vv['freightPrice'];
                                    $arr[$kk]['order_state'] = $vv['orderState'];//'WAIT_SELLER_STOCK_OUT';
                                    $arr[$kk]['invoice_info'] = '不需要开具发票';
                                    $arr[$kk]['order_remark'] = '';
                                    $arr[$kk]['order_start_time'] = $vv['orderStartTime'];
                                    $arr[$kk]['fullname'] = $fullname;
                                    $arr[$kk]['mobile'] = $tel??$vv['consigneeInfo']['mobile'];
                                    $arr[$kk]['telephone'] = $tel??$vv['consigneeInfo']['telephone'];//
                                    $arr[$kk]['province'] = $vv['consigneeInfo']['province'];
                                    $arr[$kk]['city'] = $vv['consigneeInfo']['city'];
                                    $arr[$kk]['county'] = $vv['consigneeInfo']['county'];
                                    $arr[$kk]['full_address'] = $fullAddress;
                                    $arr[$kk]['order_pay'] = $vv['orderPayment'];
                                    $arr[$kk]['is_show'] = 1;
                                    $arr[$kk]['parent_orderid'] = $vv['parentOrderId'];
                                    DB::table('jd_proprietary')->insert($arr[$kk]);
                                    unset($arr[$kk]);
                                }
                            }else{
                                $reas = DB::table('jd_proprietary')->where("order_id",$vv['orderId'])->value('id');
                                if(!$reas){
                                    if(in_array($vv['orderId'], array_column($arr, 'order_id'))){
                                        unset($arr[$kk]);
                                    }
                                    $arr[$kk]['order_id'] = $vv['orderId'];
                                    $arr[$kk]['admin_acc'] = '系统录入';
                                    $arr[$kk]['pt_id'] = $v['pt_id'];
                                    $arr[$kk]['pay_type'] = $vv['payType'];
                                    $arr[$kk]['order_seller_price'] = $vv['orderSellerPrice'];
                                    $arr[$kk]['freight_price'] = $vv['freightPrice'];
                                    $arr[$kk]['order_state'] = 'WAIT_SELLER_STOCK_OUT';
                                    $arr[$kk]['invoice_info'] = '不需要开具发票';
                                    $arr[$kk]['order_remark'] = '';
                                    $arr[$kk]['order_start_time'] = $vv['orderStartTime'];
                                    $arr[$kk]['fullname'] = $fullname;
                                    $arr[$kk]['mobile'] = $tel??$vv['consigneeInfo']['mobile'];
                                    $arr[$kk]['telephone'] = $vv['consigneeInfo']['mobile'];//
                                    $arr[$kk]['province'] = $vv['consigneeInfo']['province'];
                                    $arr[$kk]['city'] = $vv['consigneeInfo']['city'];
                                    $arr[$kk]['county'] = $vv['consigneeInfo']['county'];
                                    $arr[$kk]['full_address'] = $fullAddress;
                                    $arr[$kk]['order_pay'] = $vv['orderPayment'];
                                    $arr[$kk]['is_show'] = 1;
                                    $arr[$kk]['parent_orderid'] = $vv['parentOrderId'];
                                    DB::table('jd_proprietary')->insert($arr[$kk]);
                                    unset($arr[$kk]);
                                }
                            }
                        }
                    }
                    echo '添加成功---';
                }
            }
            echo '操作成功--****';
        }
    }

    /**
     * @name 手机号转换
     * @param $data
     * @param $url
     * @author du
     * @date 2023/12/12
     * @Time: 10:51
     */
    public function changeTelphone($data){
        // $result = $this->request_post($url,$data);
        $url = 'jx.bluearp.com/m/index.php/Automatic/TzPopOrderGetPhone';
        $ret = $this->request_post($url, $data);
        $result = json_decode($ret,true);
        CommonService::addLog('手机号', $result['jingdong_pop_order_getmobilelist_responce']["result"]["data"][$data['order_id']]['consMobilePhone'].'----'.$ret.'---'.json_encode($data).'---'.$url, $data['order_id'],'jd_mobile');
        return $result['jingdong_pop_order_getmobilelist_responce']["result"]["data"][$data['order_id']]['consMobilePhone'];
    }

    /**
     * @name 出库
     * @param $data
     * @author du
     * @date 2024/3/21
     * @Time: 8:54
     */
    public function jdOrderEx($data){
        $json['orderId'] = $data['order_num'];
        $json['logiCoprId'] = 1274;
        $sysParams['method'] = "jingdong.pop.order.shipment";
        $sysParams['access_token'] = $data['accessToken'];
        $sysParams['app_key'] = $data['appKey'];//
        $sysParams['timestamp'] = date("Y-m-d H:i:s");
        $sysParams['v'] = '2.0';
        $apiParams["360buy_param_json"] = json_encode($json);
        $sysParams["sign"] = $this->generateSign(array_merge($sysParams, $apiParams),$data['appsecret']);
        $apiParams = array_merge($sysParams, $apiParams);
        ksort($apiParams);
        foreach( $apiParams as $k => $v ){
            if(strpos($v,' ')){
                $urldata[] = $k."=".urlencode ($v);
            }else{
                $urldata[] = $k."=".$v;
            }
        }
        $urldata = implode("&",$urldata);
        //$url = "https://api-dev.jd.com/routerjson?".$urldata;
        $url = "https://api.jd.com/routerjson?".$urldata;
        $resp = $this->https_get($url);
        echo $resp;
    }

    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2025/2/6 17:01
     * |---------------------------------------------------------------------------------
    */
    public function sysServiseCenter ( $data ){
        $find_data = DB::table('statements_list');
        if(isset($data['stl_id'])){
            $find_data = $find_data->where('stl_id','>', $data['stl_id']);
        }
        $find_data = $find_data->where('stl_type', 2)->orderBy('stl_id','asc')->first();
        $find_data = CommonService::dataToArray($find_data);
        if($find_data){
            $request['admin_id'] = $find_data['stl_serid'];
            $request['wat_num'] = $find_data['stl_wat'];
            $service_center = DB::table('service_center')->where('wat_num',$request['wat_num'])->first();
            if($service_center){
                return response()->json(['Data' =>$find_data['stl_id'], 'ErrorMessage' => '操作成功1', 'ErrorCode' => 200]);exit;
            }
            // 查询成员账号表数据
            $find_adm_data = DB::table('admin')
                ->where('id', $request['admin_id'])
                ->select('company_name', 'admin_acc')
                ->first();
            $find_adm_data = CommonService::dataToArray($find_adm_data);
            // 服务商账单金额明细（服务中心账目管理数据）
            $add_sece_data['wat_num'] = $request['wat_num']; //结算流水号
            $add_sece_data['ser_id'] = $request['admin_id']; //服务中心
            $add_sece_data['company_name'] = $find_adm_data['company_name']; //结算对象名称
            $add_sece_data['apply_for_name'] = $find_adm_data['admin_acc']; //申请人
            $add_sece_data['apply_for_money'] = $find_data['stl_money'] - $find_data['stl_ticket']; //申请金额 = 结算单金额 - 执行罚款金额
            $add_sece_data['apply_for_time'] = date('Y-m-d H:i:s'); //申请时间
            $settlement_num = '';
            $add_sece_data['settlement_num'] = $settlement_num;
            $add_sece_data['company_id'] = $find_data['company_id'];
            $add_sece_data['stl_category'] = $find_data['stl_category']; //1月结2零散3周结
            $add_sece_id = DB::table('service_center')->insert($add_sece_data);
            if($add_sece_id){
                return response()->json(['Data' =>$find_data['stl_id'],'wat_num'=>$request['wat_num'], 'ErrorMessage' => '操作成功', 'ErrorCode' => 200]);exit;
            }else{
                return response()->json(['Data' =>'', 'ErrorMessage' => '操作失败', 'ErrorCode' => 202]);exit;
            }
        }else{
            return response()->json(['Data' =>'', 'ErrorMessage' => '无更多数据', 'ErrorCode' => 201]);exit;
        }
    }
    private function generateSign($params,$sec) {
        if ($params != null) { // 所有请求参数按照字母先后顺序排序
            ksort($params);
            // 定义字符串开始 结尾所包括的字符串
            $stringToBeSigned = $sec;//'eb229319be99494583fe87810b608123';//'8de8b7903e7740abb9ac6ec39f22c0e5';
            // 把所有参数名和参数值串在一起
            foreach ($params as $k => $v) {
                $stringToBeSigned .= "$k$v";
            }
            unset($k, $v);

            // 把venderKey加在字符串的两端
            $stringToBeSigned .= $sec;//'eb229319be99494583fe87810b608123';//'8de8b7903e7740abb9ac6ec39f22c0e5';
        } else {
            // 定义字符串开始 结尾所包括的字符串
            $stringToBeSigned = $sec;//'eb229319be99494583fe87810b608123';//'8de8b7903e7740abb9ac6ec39f22c0e5';
            // 把venderKey加在字符串的两端
            $stringToBeSigned .= $sec;//'eb229319be99494583fe87810b608123';//'8de8b7903e7740abb9ac6ec39f22c0e5';
        }
        // 使用MD5进行加密，再转化成大写

        return strtoupper(md5($stringToBeSigned));
    }

    /**
     * @name 定时解密
     * @author du
     * @date 2024/4/10
     * @Time: 10:14
     */
    public function decOrder(){

        $token = DB::table('jdpop_token')->where('status',1)->select('app_key','app_secret','access_token','pt_id')->get()->toarray();
        foreach ($token as $k =>$v) {
            //  CommonService::addLog('token', json_encode($v['app_key']), $v['pt_id'],'jd_token');
            $res_ult = [];
            $res_ult[$k]['appKey'] = $v['app_key'];        //appkey
            $res_ult[$k]['appSecret'] = $v['app_secret'];    //secret
            $res_ult[$k]['accessToken'] = $v['access_token'];    //token

            $list = DB::table('jdpop_encode')->where('is_enj',1)->where('pt_id',$v['pt_id'])->OrderBy('id','desc')->limit(10)->get();
            $list = CommonService::dataToArray($list);

            if($list){
                foreach ($list as $item) {
                    $user_id = Orders::where('order_num',$item['order_id'])->value('new_customer_id');
                    //解密
                    $fullname = $this->decrypt($res_ult[$k],$item['name_code'],$item['order_id']);
                    //  echo $fullname;
                    if(strpos($fullname,'<body>' )!==false){

                    }else{
                        //修改用户表
                        $res = User::where('id',$user_id)->update(['shr_name'=>$fullname]);
                    }
                    $address = $this->decrypt($res_ult[$k], $item['address_code'],$item['order_id']);
                    if(strpos($address,'<body>' )!==false){
                    }else{
                        //修改用户表
                        $ret = User::where('id',$user_id)->update(['shr_adress'=>$address]);
                    }
                    if($res && $ret){
                        DB::table('jdpop_encode')->where('order_id',$item['order_id'])->update(['is_enj'=>2]);
                    }

                    CommonService::addLog('JD', $fullname.'--'.$address, $item['order_id'],'JDPOP-dec');

                }
            }

        }
    }


    /**
     * @name 解密
     * @param $data
     * @return string
     * @author du
     * @date 2024/3/29
     * @Time: 9:54
     */
    public function decrypt($data,$str,$order_num = ''){
        if(preg_match("/[\x7f-\xff]/",$str)){
            return $str;
        }
        $data['str'] = str_replace('+', '%2B', $str);
        $decrypt_data = json_encode($data);
        $url = "http://jm.bluearp.com/jd/jdDecrypt?data=".$decrypt_data;
        $res = (string)CommonService::https_request($url);
        CommonService::addLog('URL', $order_num.'---'.$url.'----'.$res, 111,'url');
        return $res;
    }


    function https_request($url, $data = null)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        if (!empty($data)) {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        curl_close($curl);
        return $output;
    }

    public function addOrderDatas (){
        $url = "http://116.196.75.172/index.php/GetOrder/searchAllOrders";

        $url_ex = "http://116.196.75.172/index.php/GetOrder/Shhdelivery";//出库
        $url_mobile = "http://116.196.75.172/index.php/GetOrder/getmobilelist";//出库

        $time_start = date("Y-m-d H:i:s",strtotime(" -1440 minute".date("Y-m-d H:i:s")));
        $time_end = date("Y-m-d H:i:s");
        $goods = DB::table('pj_goods')->select('pg_id','brand_name','pg_series','version','goods_pic_path','national_version')->get()->toarray();
        $goods = CommonService::jointArrayKey($goods, 'pg_id');
        $token = DB::table('jdpop_token')->where('status',1)->where('type',2)->select('app_key','app_secret','access_token','pt_id')->get()->toarray();
        foreach ($token as $k =>$v){
            //  CommonService::addLog('token', json_encode($v['app_key']), $v['pt_id'],'jd_token');
            $res_ult = [];
            $res_ult[$k]['appKey'] = $v['app_key'];		//appkey
            $res_ult[$k]['appSecret'] = $v['app_secret'];	//secret
            $res_ult[$k]['accessToken'] = $v['access_token'];	//token
            $res_ult[$k]['time_start'] = $time_start;				//开始时间
            $res_ult[$k]['time_end'] = $time_end;				//结束时间
            $res_ult[$k]['setPageSize'] = 20;
            $res_ult[$k]['page'] = 1;
            $res = $this->request_post($url,$res_ult[$k]);
            $ip = $_SERVER["REMOTE_ADDR"];
            CommonService::addLog('token1--'.$v['pt_id'], $res, $v['pt_id'],'JDshh-all');


            $res_data = json_decode($res, true, 100, JSON_BIGINT_AS_STRING);
            if (!is_array($res_data)) {
                CommonService::addLog('token1--'.$v['pt_id'], json_encode($res_ult[$k]).'-获取京东自营社会化数据失败', $v['pt_id'],'JDSelfShh-error');
                continue;
            }

            if (!isset($res_data['jingdong_socializationinventory_searchAllOrders_responce']['searchallorders_result'])) {
                CommonService::addLog('token1--'.$v['pt_id'], json_encode($res_ult[$k]).'-获取京东自营数据失败', $v['pt_id'],'JDSelfShh-error');
                continue;
            }

            $searchResult = $res_data['jingdong_socializationinventory_searchAllOrders_responce']['searchallorders_result'];
            if (!isset($searchResult['queryAllOrdersForJosResult'])) {
                CommonService::addLog('token1--'.$v['pt_id'], json_encode($res_ult[$k]).'-无可添加数据', $v['pt_id'],'JDSelfShh-error');
                continue;
            }
            $arr_goods = [];
            $arr = [];
            $order_data = $searchResult['queryAllOrdersForJosResult'];
            $orderInfos=[];
            $num = 0;
            foreach($order_data as $kks => $vks){
                if(!empty($vks['oaid'])) {
                    $orderInfos[$num]['orderId'] = $vks['customOrderId'];
                    $orderInfos[$num]['oaid'] = $vks['oaid'];
                    $num++;
                }
            }
            if(!empty($orderInfos)){
                $poss['appKey'] = $v['app_key'];
                $poss['accessToken'] = $v['access_token'];
                $poss['appSecret'] = $v['app_secret'];
                $poss['orderInfos'] = json_encode($orderInfos);
                $user_data=$this->https_request('http://zptzchat.bluearp.com/m/index.php/GetUserDataApi/getOaidDecrypt',$poss);
                $user_data = json_decode($user_data,true);
                if($user_data['jingdong_jos_order_oaid_decrypt_responce']['returnType']['code']==200){
                    $user_data = $user_data['jingdong_jos_order_oaid_decrypt_responce']['returnType']['data'];
                    $user_datas = [];
                    foreach($user_data as $ks => $vs){
                        $user_datas[$vs['orderId']] = $vs;
                    }
                    if(!empty($user_datas)){
                        foreach($order_data as $ka => $va){
                            $order_data[$ka]['user_data_dou'] = isset($user_datas[$va['customOrderId']])?$user_datas[$va['customOrderId']]:'';
                        }
                    }
                }
            }
            $company_id = Pt::where('id',$v['pt_id'])->value('company_id');
            foreach( $order_data as $kk => $vv ){
                $order_info = OrderService::getOrderBy('order_num', $vv['customOrderId'],['id','order_status','lock_type','sys_num','order_num','p_id','ser_id','create_time','new_customer_id','lock_type']);
                if($order_info){
                    continue;
                }
                $flag = 1;
                $skuId = array_column($vv['orderDetailList'], 'sku');
                $goodids = DB::table("jd_bound")->whereRaw("sku_id in (".implode(',',$skuId).")")->pluck('goods_id','sku_id')->toarray();
                if(empty($goodids)){
                    CommonService::addLog('无sku', json_encode($skuId), $vv['customOrderId'],'JDSelfShh-无sku');
                    $flag = 2;
                }
                if($goodids){
                    if(count($goodids)<count($vv['orderDetailList'])){
                        $flag = 2;
                    }
                }
                //解密
                /*****************************************解密姓名*************************************************/
//                $str = $vv['consigneeName'];
                if(isset($vv['user_data_dou'])){
                    $str = $vv['user_data_dou']['customerName'];
                }else {
                    $str = $vv['consigneeName'];
                }
                $data['accessToken'] = $v['access_token'];//'e0a1c90e617f4b3a9865ed059f99c5f42ztb';
                $data['appKey'] = $v['app_key'];;//'41D9668E8CB81C9890A065BEC300FD84';
                $data['appSecret'] = $v['app_secret'];//'93bff142bf5c4422ae7bec9eb992e751';

                $fullname =  $this->decrypt($data,$str);
                if(strpos($fullname,'<body>' )!==false){
                    //存另一数据库中
                    //是否存在
                    $exs_code = DB::table('jdpop_encode')->where('order_id',$vv['customOrderId'])->value('id');
                    if($exs_code){
                        DB::table('jdpop_encode')->where('order_id',$vv['customOrderId'])->update(['name_code'=>$vv['consigneeName']]);
                    }else{
                        DB::table('jdpop_encode')->insert(['order_id'=>$vv['customOrderId'],'pt_id'=>$v['pt_id'],'name_code'=>$vv['consigneeName']]);
                    }
                    $fullname = '无';
                }

                $fullname = $fullname??$vv['consigneeName'];
                /************************************************************************************************/
                /**********************************************解密地址******************************************/
                if(isset($vv['user_data_dou'])){
                    $Address = $vv['user_data_dou']['address'];
                }else {
                    $Address = $vv['address'];
                }
                $fullAddress = $this->decrypt($data,$Address);

                if(strpos($fullAddress,'<body>' )!==false){
                    //存另一数据库中
                    //是否存在
                    $exs_code = DB::table('jdpop_encode')->where('order_id',$vv['customOrderId'])->value('id');
                    if($exs_code){
                        DB::table('jdpop_encode')->where('order_id',$vv['customOrderId'])->update(['address_code'=>$vv['address']]);
                    }else{
                        DB::table('jdpop_encode')->insert(['order_id'=>$vv['customOrderId'],'address_code'=>$vv['address'],'pt_id'=>$v['pt_id']]);
                    }
                    $fullAddress = '无';
                }

                $fullAddress = $fullAddress??$vv['address'];
                /************************************************************************************************/
                /**********************************************整理商品信息******************************************/
                $resjdgoods = DB::table('jdgoods')->where("order_id",$vv['customOrderId'])->value('id');
                dump($vv['orderDetailList']);
                foreach( $vv['orderDetailList'] as $ka => $va ){
                    if(!$resjdgoods){
                        $sql_dgoods .= "('".$vv['customOrderId']."',".$v['pt_id'].",'".$va['sku']."','".$va['commodityName']."','".$va['jdPrice']."','".$va['jdPrice']."','0'),";
                        if(in_array($vv['customOrderId'], $arr_goods)){
                            unset($arr_goods[$kk]);
                        }

                        $arr_goods[$kk]['order_id'] = $vv['customOrderId'];//订单单号
                        $arr_goods[$kk]['pt_id'] = $v['pt_id'];//平台id
                        $arr_goods[$kk]['sku_id'] = $va['sku'];//京东sku
                        $arr_goods[$kk]['item_total'] = $va['wareNum'];//商品数量
                        $arr_goods[$kk]['jd_price'] = $va['jdPrice'];//京东单价
                        $arr_goods[$kk]['jd_cost'] = $va['jdPrice'];//采购价
                        $arr_goods[$kk]['sku_name'] = $va['wareName'];//商品名称
                        DB::table('jdgoods')->insert($arr_goods[$kk]);
                        unset($arr_goods[$kk]);

                    }
                    $sys_num = 'L'.date("YmdHis").str_pad(rand(0,999),3,'0',STR_PAD_LEFT);
                    if($flag==1) {
                        $goodid = $goodids[$va['sku']];
                        dump($goodids);
                        dump($goodid);
                        if($goodid){
                            $goods_res = $goods[$goodid];
                            if($goods_res['pg_series']==''){
                                $type = $goods_res['version'];
                            }else{
                                $type = $goods_res['pg_series']."-".$goods_res['version'];
                            }
                            $goods_name = $goods_name.$goods_res['brand_name'].",".$type.",".$goods_res['general_version'].",";
                            $good_brand[] = $goods_res['brand_name'];

                            $orderMsgData[$ka]['goods_id'] = $goodid;
                            $orderMsgData[$ka]['goods_name'] = $goods_res['brand_name']."-".$type;
                            $orderMsgData[$ka]['goods_price'] = $va['jdPrice'];//实收/商品单价
                            // $orderMsgData['goods_paid'] = $va['jdPrice'];//应收
                            $orderMsgData[$ka]['goods_num'] = $va['wareNum'];
                            $orderMsgData[$ka]['goods_brand'] = $goods_res['brand_name'];
                            $orderMsgData[$ka]['goods_number'] = $type;
                            $orderMsgData[$ka]['cd_id'] = 1;
                            // dump($orderMsgData);
                        }
                    }
                }
                /*********************************************************************************************/
                //添单
                /**********************************************转换手机号******************************************/
                // $data['pt_name'] = $pt_name;//店铺名
                $data_m[$kk]['customOrderId'] = $vv['customOrderId'];
                $data_m[$kk]['appKey'] = $v['app_key'];		//appkey
                $data_m[$kk]['appSecret'] = $v['app_secret'];	//secret
                $data_m[$kk]['accessToken'] = $v['access_token'];	//token

                $tel = $this->request_post($url_mobile,$data_m[$kk]);//同步手机号
                $phone=json_decode($tel,true);
                $phone = $phone['jingdong_pop_order_getmobilelist_responce']['result']['data'];
                $tel =  isset($phone[$vv['customOrderId']]['consMobilePhone'])?$phone[$vv['customOrderId']]['consMobilePhone']:$vv['phone'];
                /*********************************************************************************************/

                /**********************************************添加订单信息******************************************/
                if($flag==1){

                    $orders[$kk]['sys_bh'] = $sys_num;
                    $orders[$kk]['skb_bh'] = $vv['customOrderId'];//平台单号
                    $orders[$kk]['pt_id'] = $v['pt_id'];//平台id
                    $orders[$kk]['ser_type'] = 1;//服务类型：1上门安装，2到店服务
                    $orders[$kk]['shr_name'] = $fullname;//姓名
                    $orders[$kk]['shr_phone'] = $tel??$vv['phone'];//$vv['telephone'];//电话
                    $orders[$kk]['shr_sheng'] = $vv['provinceName'];//省份
                    $orders[$kk]['shr_shi'] = $vv['cityName'];//城市
                    $orders[$kk]['shr_xian'] = $vv['countyName'];//区县
                    $orders[$kk]['shr_adress'] = $fullAddress;//
                    $orders[$kk]['shr_other'] = '接单后10分钟内务必联系客户核实车型跟安装时间！不断电安装、如果无法完成 请立刻反馈我们处理~！';
                    $orders[$kk]['car_audit'] = 2;//1:新订单；2：可派单；3：处理中
                    $orders[$kk]['order_type'] = 1;//订单类型：1：普通；20加急；10：夜间
                    $orders[$kk]['order_time'] = date("Y-m-d H:i:s");
                    $orders[$kk]['pay_type'] = 1;//支付方式：1在线支付；2货到付款
                    $orders[$kk]['goods'] = $orderMsgData;

                    //   $session = $request->get('session_token');//获取操作人信息
                    $session['admin_groupnew'] = 7;
                    $session['admin_acc'] = '系统录入';
                    $session['id'] = 1133;
                    $session['company_id'] = $company_id;
                     dump($orders[$kk]);
                     exit;
                    $return = OrderaddService::addOrder($orders[$kk], $session, $ip);
                    //    dump($return);
                    CommonService::addLog('添加定单', json_encode($return), $vv['customOrderId'],'jd_addSelfShhOrder');
                    // $return['ErrorCode'] = 2;
                    if($return['ErrorCode']==1 && $v['pt_id']!=33){
                        //调用京东出库


                        $res_ex = [];
                        $res_ex['appKey'] = $v['app_key'];	//appkey
                        $res_ex['appSecret'] = $v['app_secret'];//secret
                        $res_ex['accessToken'] = $v['access_token'];	//token
                        $res_ex['customOrderId'] = $vv['customOrderId'];//$vv['orderId'];
                        $res_ex['carrierId'] = 1274;
                        if($company_id==14){
                            $res_ex['phone'] = '18518338010';
                        }else{
                            $res_ex['phone'] = '';
                        }
//                        $res_ex['estimateDate'] = date("Y-m-d H:i:s");
                        $result = $this->request_post($url_ex,$res_ex);//出库同步

                        $filename = 'selfShh_ex'.date('Ym');
                        CommonService::addLog('出库', json_encode($res_ex), $vv['customOrderId'],$filename);

                        // $result['code'] = 200;
                        $reta = json_decode($result,true);
                        if($reta['jingdong_socializationinventory_delivery_responce']['returnType']['status']==1){
                            CommonService::addLog('添单成功出库', $result, $vv['customOrderId'],$filename);
                        }else{
                            CommonService::addLog('添单出库失败', $result, $vv['customOrderId'],$filename);
                        }
                        $newOrderId = true;
                    }else{
                        $newOrderId = false;
                    }
                }
                /*********************************************************************************************/

                /**********************************************添加同步记录******************************************/
                $rea = DB::table('jd_proprietary')->where("order_id",$vv['customOrderId'])->value('id');
                if (!$newOrderId || $flag=='2'){
                    //echo '添加订单信息失败';
                    if(!$rea){
                        if(in_array($vv['customOrderId'], array_column($arr, 'order_id'))){
                            unset($arr[$kk]);
                        }
                        $arr[$kk]['order_id'] = $vv['customOrderId'];//订单单号
                        $arr[$kk]['admin_acc'] = '系统录入';//操作人
                        $arr[$kk]['pt_id'] = $v['pt_id'];//平台id
                        $arr[$kk]['pay_type'] = $vv['paymentCategory'];//支付方式
                        $arr[$kk]['order_seller_price'] = $vv['pay'];//订单金额
                        $arr[$kk]['freight_price'] = 0;//运费
                        $arr[$kk]['order_state'] = $vv['orderState'];//'WAIT_SELLER_STOCK_OUT';//订单状态7 新订单；10等待发货；16等待确认收货；19订单完成；22锁定，29删除
                        $arr[$kk]['invoice_info'] = '不需要开具发票';//'发票1开2不开'
                        $arr[$kk]['order_remark'] = '';//订单备注
                        $arr[$kk]['order_start_time'] = date("Y-m-d H:i:s");//下单时间
                        $arr[$kk]['fullname'] = $fullname;//客户姓名
                        $arr[$kk]['mobile'] = $tel??$vv['phone'];//客户手机
                        $arr[$kk]['telephone'] = $tel??$vv['telephone'];//客户电话
                        $arr[$kk]['province'] = $vv['provinceName'];//省
                        $arr[$kk]['city'] = $vv['cityName'];//市
                        $arr[$kk]['county'] = $vv['countyName'];//区县
                        $arr[$kk]['full_address'] = $fullAddress;//详细地址
                        $arr[$kk]['order_pay'] = $vv['pay'];//实收金额
                        $arr[$kk]['is_show'] = 2;//'1 未填单 2 已填单 3 已删除 4 已完成'
                        $arr[$kk]['parent_orderid'] = $vv['parentOrderId'];//父类单号
                        DB::table('jd_proprietary')->insert($arr[$kk]);
                        unset($arr[$kk]);
                    }
                }else{
                    $reas = DB::table('jd_proprietary')->where("order_id",$vv['customOrderId'])->value('id');
                    if(!$reas){
                        if(in_array($vv['customOrderId'], array_column($arr, 'order_id'))){
                            unset($arr[$kk]);
                        }
                        $arr[$kk]['order_id'] = $vv['customOrderId'];//订单单号
                        $arr[$kk]['admin_acc'] = '系统录入';//操作人
                        $arr[$kk]['pt_id'] = $v['pt_id'];//平台id
                        $arr[$kk]['pay_type'] = $vv['paymentCategory'];//支付方式
                        $arr[$kk]['order_seller_price'] = $vv['pay'];//订单金额
                        $arr[$kk]['freight_price'] = 0;//运费
                        $arr[$kk]['order_state'] = $vv['orderState'];//'WAIT_SELLER_STOCK_OUT';//订单状态 5新订单;9正在出库;10 出库成功;15正在发货;16发货成功;23等待退款
                        $arr[$kk]['invoice_info'] = '不需要开具发票';//'发票1开2不开'
                        $arr[$kk]['order_remark'] = '';//订单备注
                        $arr[$kk]['order_start_time'] = date("Y-m-d H:i:s");//下单时间
                        $arr[$kk]['fullname'] = $fullname;//客户姓名
                        $arr[$kk]['mobile'] = $tel??$vv['phone'];//客户手机
                        $arr[$kk]['telephone'] = $tel??$vv['telephone'];//客户电话
                        $arr[$kk]['province'] = $vv['provinceName'];//省
                        $arr[$kk]['city'] = $vv['cityName'];//市
                        $arr[$kk]['county'] = $vv['countyName'];//区县
                        $arr[$kk]['full_address'] = $fullAddress;//详细地址
                        $arr[$kk]['order_pay'] = $vv['pay'];//实收金额
                        $arr[$kk]['is_show'] = 2;//'1 未填单 2 已填单 3 已删除 4 已完成'
                        $arr[$kk]['parent_orderid'] = $vv['parentOrderId'];//父类单号
                        DB::table('jd_proprietary')->insert($arr[$kk]);
                        unset($arr[$kk]);
                    }
                }
                /*********************************************************************************************/
            }
            echo '操作成功--****';
        }
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取京东订单状态
     * @retrun /multitype:array
     * @author dou 2025/2/17 15:35
     * |---------------------------------------------------------------------------------
    */
    public function getJdOrderStatus ( $input ){
        return OrderService::getJdOrderStatus($input['orderId'], 33);
    }

    /**|---------------------------------------------------------------------------------
     * @name 解密
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2025/2/19 14:29
     * |---------------------------------------------------------------------------------
    */
    public function getDataDecrypt ( $input ){
//        $datafullname['accessToken'] = $input['access_token'];//'e0a1c90e617f4b3a9865ed059f99c5f42ztb';
//        $datafullname['appKey'] = $input['app_key'];;//'41D9668E8CB81C9890A065BEC300FD84';
//        $datafullname['appSecret'] = $input['app_secret'];//'93bff142bf5c4422ae7bec9eb992e751';
//        $fullname =  $this->decrypt($datafullname,$input['str'],$input['orderId']);
//        echo "解密信息：".$fullname;exit;
//        phpinfo();
//        die();
//        $encrypted = base64_decode('bMOcnvCGA9MOesFFyVFRYXj2ZVGIAJzcvm2k4SsrwDfIHIhRwnE/4MFQ6XrQmc6E/XQbNwo6UENiDlrlHcbq1Jy0TgcnJLS6ugL5J0iKEQMkbfFYBaIuFFZGVAZBUiLd3278u+RWIQhfTQaPPevKx+CkC1ArYX4O66vGA7vQGnwDHxYOu5X7vBkLn45K4awJpgTfUqM7oDAI9F5KCs4BWto+18x+h329ctcn1WziPoG49Wx9EBT+RQm27m8FCo3xEgJwqK7fAdbX3G2rdr0kgNyOMnlBNvEEVZtKVVQtUGvzR052UBueWYti2WRtEtpITpQyQQ44kBOYTJT6tveLZofgtzLHn0Yh+bJ46gRlXgBiozVIgK65yueOtTyRWW3wMSeLLHWm9YtfBKBSy5A92M//kWOR4Of4Yds+Q6MY7BKru6siKjS1mNkcuHiNJj9TnJ/fa7ioICkfIsSpSJjbF2uF6cwRUYvEbB+IUSs5at11yA32cQaa5muYTyW0lG04qvlcVtuQ4L3hzd0JiB181JfWfvqdR2Fcs01pOqWjMmdvesz42WevffftdUkHEBQ3bfDUh4QbFjpLeBrQP1eAoCjetyBqB8vDUeDHgnmEdxiJxHHgBB58wwAepQpL+GdEVUJuyxevxXUGJSk0BjCE56h1zWlfiQcjBF76NPoK4kSCzqPkMCUVtPk2Vm7S/dcUKQfSl0z4NWieAfsdTqIkN39q0tYyI/2bC/L7qfugepu4kk8dcsWwqPV2zA+kwdeESdGkOM4zv4dUOeMTdDnkWuK5r8kEhpLtBQj9nw7q/K7lzhZrdQ+frUzHVUB8MByH67ZwuZL/QF0Nri4nWEbG9gIOiEDjHqm0h/qa4i+9UZXOe+nG5NXg8jF4pGk/U6ludgxepMf+rS5NN6XT9Snx1Ob18Hdw8MhtRYEsMLMJfKV5Ff03CAeZSGdYzfYIKCHW/10Js7hdDsf4eKHIcRGBxvydYVDDwSFh24uc4IbjUS1cH67I/qh2xh8Omis5dpLwtkhJdV2Ed7/JgBMuFi2PUVMTdiJnT+j2bdztcY5oxYb4Hiofi5VBDodYqmYb5eS65f9Kb2K7epem0bZ6c0cVmy682MxeEaB/F2Oz0hPk3xDR25U2uilIoKfEymxWchLVmN8yuqHqgb/cHBblRlLeINfxqnsqvq9kEIBP1gGz6XpPgU7HXkhlZkFxcVCspHiNMiI9H1fudcIifkxvB7LmyeUzTyfCqJJi/Vh/QrjozjwlaNu8OEcOeYkhMO2kmhGg58WJIXgDDuxcGjItxXdLHNRD7mNRg6tLhFA3b7Brj/FT5iP0RGKgwZUdQK2riDmFa2y5sE4KoKsN6bR2bEHCaCsRkcoGzN2+LBymAVjU/03L+oQDOrX5Z9yxbeCwDjzv2CmxsMNocemlQF716QOmRZeHwVXo0vswhel9D8hMvIu8XDwY9KDWfk36N4R3+gB/8OiIcs5J6QeiNvn+vJ9hlMUYLzpzpphDwsQtA3QhlUvXFfZAjOER4X5JvLPCdeamASSiFkjfPthMdBPZBeic/lJM71JQUF7AYThvNqE1/QIGb0PV2MA2LOH2THlrG2k+md9A5BMxg7aPujhMCW/YCC8CDlAiyrxVXaPNwbtITluO/Z++YozyyG7qPCLmW0NwrGPTiNYFQGFWblBQq6lLEOd5JTFQ2nL/QFmgCa2cWo+nn20K1hUZcqWjPC9DYAaGc7kXLo8g6m6aF9vbW+0wFq1Wqu1rcg1bVIVSvjmMkp2skUeEU6I49C3LhnFq+9cDDWBuGSMZCtdYTeL5YQGY2UQgJ15xmkxuV1ZqOWzJ8ob8rR8QMw1CIMfb1MhXUoyJALS9ZgD3w+pETP0EEFBophHb59ypuBUyi5hJR0/awLlmZAP07aAoE/5enUaH76h46ErUCveu2apYvPPdGRkr3PC5cnkDHIU8daOFSvSQWf+/QaXTT/WBsgri33QipjD1ALmyim1ZUqcyboWaUvgrKoazsXRLaRyVeZtsqZEgiyusv6DK99zT6xtaXc2ZAeayNBg3CBmc6UYiZA9tvCf+SNYF7LEWkTw6t3WK4DhY8WK/rbyiuKGtLcjTilMp4MvoBTK5neVOuLtLfyBQvofkQwEQbn3FV9JvBjgeT7AG4AF7iXh0TbFIZlNs7gNzA449uD8iAp8ct+X3sYt4OyBdZrhsLdSG6sV0JD0jtR/N46/41Ryit2TbpT1oQ7MQMXIapbZ2Xboz1MhUGiFkepmSLG9wxtM7eJSJIbnCT/FKuj5Cu2OF1CURJQwwkPMtPZbM4myOQDnrfR9KLIlbIHJ+7b0l6pM724eUsRfGntEKuzerp7HuLw8e2FiRh2D4mlniskk4ln3sFKOeeynYU/MmOfxuDQ5NVgVqbVqa/jC+AOkuDEf8M6zP5rN0uBlv0yJ5uPeyiHcghG0PCkjsfHs8EikvSyIE2gFKWHWHYe45JJs0LuGWCjjFyLcX4UpSsiCUcTf5dIDo4aFAtqDvj7uVKP+GkJ4HC8yngCJAOBmKKJzy/qcR8Nv0fFtGclXCLs2Cc9uOJEawQ83YAoQeRn+AvtgP3G93JDRCnre/CUYOfZTOKNJhEFxN6tLg582kebN7MJuLRYhCjqsPyrNdROXwLMmUhdBPtoBe2ZwKnWksuOWNWBagy0cNA2GHTCCJrgQi4SrESbsY3vmtY/Kf3KdyRpVHkIAV7dqJepptCgueHiZBenX+L1KrpVXI6Ucj9w7CVV7edl8e11VY2LxqKs2iNKiJf38PKerTkj/fDKtiTajT1QSxOVrzzVElmxNt7y2YB0k01/a8ddpgKRiTsvstsM3LElrzBICYWV1PDv6ILTmwfHLkvKp6wpTUEHzCMC1gZGKZpwk5y2Gy3s/CvGZ/bZ8H5fUml7G4nnFsAsoZPtTrQX0SkvnjY2RFF+qHw5Moq2VbtY8CPxIleXki9g5zgEQfVoazDwVB1rQNoJNo7H4PadP9kadE8cznX+rpSU6WoZmmCXqM2n7yf01pO0cNu26hT6AGiIv9lZW4tLUfUPU2hHPnsKpWcHGicOIgCk5eFG/+JgkD6ULfTyUcGf3ZtN0yX+OD4HKYMl6Cu0nDRg/TzTHIxZ5ywU69UyeW4GJcoI8xliwHUwFtI1ShJB4cLy7M9uHTe8ZGaEkJgs4M++AqeMqJYjH2EEOeVuV1W+nWjxMpupaa1/dyaZ8+Mo35qimlegWyDKJ4s06tUvU10+8unqDngLzd8TkxJDi75gdIkpj06plVE7jIf7m0edXpdT3R59w5thwTsd98xTFfREDdgbCDDkdfVdMF99b1aByu5xDkxyxOxjW5+IikbLS+C1OhR2vtiIykxwe75DL0Aee1z4dXNiv1RNhWxWVGaXbN58tfurYpGSoWZMX0KWfr7tRb5F4IqGGbWYcU36yTS/b6BRMV53TXQPGy9E1ZGphc33y+DRbVRnbpRG1klYJnGgoJepIPWD0MaU8u17JNHyoiipTvfxN66aJMiPh9imZ6VARGi1ElIswoO0kcdOLmVDRyze+KwINea4Wi2m680dGPCxf2sWd4atqyLBDVqMU7RLtniTiUPmXjw6ceqhydUmOeIP2DgegYI1j6G6izSQG1SGjFOSbg6nddnursjemKVCIPoL3hvGiMLuluaOfsuGQLnRTQDEik66mzwihfHHAOHUmIBego7VXwahyQxCBuV8/oo4B/vEIiYl6sgLYdHiYai9IgQJk0yF30AivjLGccVd0RmbYNzTFUaCvWVHbTBU3hWKXzeH3U02FgYWrdjig3xAjsrCH0mxH6GIe5Al6lUU4ZI4nI+VOs9rRN3txzExzugO4K9ilFHPuk3PUa/s0hTzjxmJZNKSmA7dBtt6ZygrP/z4uNNFI8CHuM4M4ba4UfGZsFt6zIV9PHach12C16je4UBrKOOSE4sUTOm9y0F9ZX0FCqoJUS+r40BRk16zYbdzqm9C2+cpHfLQS98HoDf63k+iRZOH/bG8qHqkWYAFis6egts3+vIHyU8Vg8wjDGfksA2emnLhrb0aVJa+rYyih8bD1R/NERmWc/lR4bTBLGd/8CoJSIDoSs85Q5PLAIvZ8Q0vUtroGoFLCSFH/i0yDJAIQS96rv6BHS/J4BWA+4zU/rpTAOltqgwRxf+PloTu6AAfnHt4KW8/KXUa1OukaTb4UzhnxYe7kRfoxeoyBT6EGTDt44h7tuZxk2RFEKQN1iq9KOGQVd+rtnLXrHic2yyg6lb1PuLPYCzG2awUhVZDEjIspklzaEGV8QiAK9xaSJE87KZhs3ehgmrb9Vt7P+UoAfE8a8WhzMYFbz0u4F0MjhJpR1NLtMdima46hm+Lnz+WJF2OBsrZxzDYHp4jZ9GeWKaTDcOVcYVCVR58q6n9X074Ycs3pzwXRvv8ayj/V5lzKzWEBqCPCxaVv3oK9lWfqwGIK9tPVCfP9XzB/6VZeNW/WoT09hmuXQgCrdc9OnZOyh+Aj+oVZxAxpA7S6RE9tIbjue54C+dRugnd/6tlA1G0DuEQukvKMSQi2F9WKs7RkTBBVC+fD+P2EHAU1ICWr23qSJ+2M/lx7C2wK+Fmpb4afY3eiErPZqxAZ1SCgjodHrb9rRLBqfZIxtuHPvI9UTmq/fZ1bIpBzcRVHOKyPtMYSIK96louByIEtJBfNrCpL9eI2/f/Bd5kBk91wVpld6qRvMaQ4xoJAuvA4CqKhZX2Z4x4eLXCjsR14nVaV4RKRzYomNyPx7OsqAwU2S8G0atlhSAhSzPD4yrX7YwU5l3gNJLkVtPvXjhdXZ7o1ll9CC12z/eKX+esV2HVR9kHLsq7R6dVg42sqZTaCNPuIYRZ1Q0y2+J2OJvvrisjxmp29lc3pQyJZY80o9jxib6OP2Gn4WuvabYn29UV8y50ZygTudMz70T7Wr4KU/bbBs+bWI4oXCPgKlIHp1qfJN/dujX9oDeuVBjhp+A8mcWhN2fSCBlsHXRxQEqhtqiTDKPKCg6SBcY4xpAaNdAs0JegfgcC7t6lIc52Wf+wllJnzEuDXniW0em+JWniBX5+bwelpx+p1PvuVbn+IaUEJWl8jOLKiV0gk01P77+Q1m+luzlIVdDbJUnVjV76o2LVImhuiS+WQF7J1TQ8Rd1Tq0b1rzEanpUPG4EY/tG68ox5DXgkJTUwb2KLnc6d9qO9HMEXBaL30/e6x+KhvTSJivXh5cQ2bsj2kBjf2EpxDolOXSabRAyAM61H/jPxb/JibvNt6ITDipYrdCwjd270PVxBy4o8QhsMYCSWZhY7lcTheo7UbeGR3KZlM46akxlHHc+ETkV0BsphG5TNaBrtozgBMLD+6S0Hpg3QrZu2hfHc199B/vdPMe1VadqTTCiWIELjsw9ZHduKsHpKtdF0VgQrZr2QWpEsnV2U05ozafhnyYR6ZkIxAk7qEkFR5Ht4GOiDYTXSx/qrfXpPv5HoZqTKcvIuurttZ6E8Vk0KdRcGv6nKsownLblD3s9oSbVvocOhXf+VdbZJNaUc2g3CmkqMfAGPsNYgiTMQ/pP3Sto6qldZgFDtU7jklif8hENvIpTGHlZ6Vbp7HqZSP1BKe0wohEh7U0EtACuzhRjoi+U9ZGEK+mWeSX11+anNp4UTzxXJNxLvdPfqmIerT3srpRejqBXOQesNBtdaCCeOQ4MVt7voXGZuxv2hgCaCniu3oFAlPg4Um8KSoCokvvuD01xrVt4X32Js3ASEYjRBi08Zh0VlZGuR50r5mdsWqag8+cVgY8r6WonqczdeGx4o8/gA8hw8Q+pEQZCnhOZGCw0OaA3EhsBtS/dMnxwlzbx5g4fJyVrs1ljfUVwMS5RF2waAP9oAsgat/fv4Ser4WgeUHmOfEeVgauuscg93uf13SymvG8Z8vo6O7Rx3am45biRaDg7DhCNh7RJy73xD+ROg3KMvgDC5VURpJ5ilyZXFTR61G2dbBZ/Rwbi7AZn3HH8LD1aNnEzDPe964qMaL5PqCWkNSZIxVd5sAUXlAAyYw+YnWhNJUX4X/tB84tfpoL/6kjMyGJ5scI7Yhvm0mATYepFobFQFhlO0MUwWVk8VUw/3J0VoDyg2S2OeNMRhXYkaPRUMWSsYhk5QaK2+FLqMBX7qI60smFdN5pBSsldNKL57kt654x5NKOx09t0nHq6FJnitibiFuSMbYDPhzy9ceNr1sIFYmXRHFwNiv97Efjj8e5h+nbohkVb4uMBe/Hei1LByE+dU6tH+q/F/mcftRH1Pxri0cTazBv+LJq5NHRm2T5+3xxBfhdL9E65hcw8mJPE76+Y7mw4ngLf3zxGDxgxk8VjDy/prDo45Xl81LUzTpGrfG8vlIHWK6cZAOj82dBI2p2lOSK445NkSu1vjL8bBQvRrpq2mG3iOpaTooF1xPF5n/NPRJeq9QqjkmqN+fLoa3vxFE07gYHhMB/FzSV4jX6ks4NvEEue2QDXajzX7NJvOaSa6PKUoc9LK9cxSZBnujrG3oV22FRkWIHG0jbDdrqCrXMtzRBa9q8dIoPXvJ9sajbu/wMpcb+J4nZGDgPat0iSLS927yC5qv4P1xyYFqVLnVQu721pq1Hqd4uzs9GYLQeP9U/JBgpNxfa3wsuqgoul+CilTIQQuDakgk4+2kORmMvUz8ilauiGku2RIkyQvrDpcwhs4WagP0cRnTE7wwRf1YIOQX8X/+1cuGYLgmJXyuEmaQd9lcHjIEBlTlZc+eNBWoM3sJljQnZe2E1V/PoBfZ/EoFFFshPFMCz55LGnR9OAO0p2LKFiHJsqUmiCLVjkMVBA+uYf5MIIfcAqZ12KlLOqWv9DO5zIuq8NadUIVNo/l6UPJ52JFgG8OPKwMVmN8jLtl/+eAMBJgS4uaAQkO0pRiSzhBN3jGzSFLPEBwWnMZ4w+y3yTjW2vZTY52iEDGjAcQPji6pf7+4TrktOXdvENLiheU7dSHhnhcVjNNBGATrnkSskLgEAcQNfiBi+/dyJOvHpRThyHC9kZI7xxqUJBfnEzDa1FFXgBvsfmOZms90KWGKXEdHRxA12sjp391OHXvy02toda+xE8YdMj1LpvrtQHtF/1bycP9mMZ7zo7Bl2TH6gx+tkiOpuKTOW/KKa+njzuax9oc6QCkN2yD7ImVGNbciqwo5K+FBTZIAI0NM2ZdRP3tm5FF5Jygf6LOlXuTjpu8LpyDl29nmwQmUkZAcLyM52w/RlKU75AQsWDkc8hBWNN6eyOsYD1TjTx1b6cGZNacv9qWfxzpZcBnzDsitCxeM6NJwTP1JvfRaTHHPXsEj72i6eHKm9GirOs2DstInpIJkv/aVHSm4N0uP4Zir7a+xX+AhYkYEJLWTNQRCX');
//
//        // 解密
//        $decrypted = openssl_decrypt(
//            $encrypted,
//            'AES-128-CBC',
//            '285ad85204144f41',
//            OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING,
//            '981bab04953790b1'
//        );
        $SynJdRapidController = new SynJdRapidController();
//        $decrypted = $SynJdRapidController->sysJdData($input['orderId'],$input['token'],$input['type']);
        $decrypted = $SynJdRapidController->searchJdOrder();
//        dump($decrypted);
        return $decrypted;

    }
    /**|---------------------------------------------------------------------------------
     * @name 计算订单退款
     * @param string ju_ordernum 订单单号
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2025/8/6 15:24
     * |---------------------------------------------------------------------------------
    */
    public function calculateOrderPrice ( $input ){
        $company_id = [14];
        $start_time = date("Y-m-01",strtotime('-1 month'));
        $end_time = date("Y-m-01",time());
        foreach($company_id as $k => $v){
            try {
                //获取取消的订单信息
                $order1 = RechargeOrder::where('reo_company_id', $v)
                    ->where('reo_sg', 1)
                    ->where('reo_type', 2)
                    ->where('reo_refund', 1)
                    ->whereBetween('reo_create_time', [$start_time, $end_time])
                    ->leftjoin('orders', 'orders.order_num', '=', 'recharge_order.reo_order_number')
                    ->whereIn('order_status', [50, 55])
                    ->select('order_num')
                    ->get();
                $order1 = CommonService::dataToArray($order1);
                $xct_num = array_column($order1, 'order_num');
                //计算退款金额
                $cxt = 0.5 * count($order1);
                $cxtk['reo_adm_id'] = 164;
                $cxtk['reo_company_id'] = $v;//公司id
                $cxtk['reo_order_number'] = 'TKC' . CommonService::creactNumber();
                $cxtk['reo_price'] = $cxt;
                $cxtk['reo_pay_state'] = 2;
                $cxtk['reo_state'] = 1;
                $cxtk['reo_create_time'] = date("Y-m-d H:i:s");
                $cxtk['reo_pay_time'] = date("Y-m-d H:i:s");
                $cxtk['reo_pay_way'] = 6;
                $cxtk['reo_paid_money'] = $cxt;
                $cxtk['reo_pay_check'] = 1;
                $cxtk['reo_type'] = 1;
                $cxtk['reo_client_type'] = 3;
                $cxtk['reo_remaek'] = '取消订单退款';

                DB::beginTransaction(); //开启事务
                //添加取消退款记录
                $rea = RechargeOrder::insert($cxtk);
                //更改已取消退款状态
                $reb = RechargeOrder::whereIn('reo_order_number',$xct_num)
                    ->update(['reo_refund'=>2]);
                //公司账号退款充值
                $update_res = DB::table('admin_recharge')
                    ->where('adre_company_id', $v)//公司id
                    ->increment('adre_banlance',$cxt);
                if($rea && $reb && $update_res) {
                    DB::commit();
                    $jttorder = RechargeOrder::where('reo_company_id', $v)
                        ->where('reo_type', 2)
                        ->where('reo_refund', 1)
                        ->whereBetween('reo_create_time', [$start_time, $end_time])
                        ->select('reo_id')
                        ->get();
                    $jttorder = CommonService::dataToArray($jttorder);
                    $reo_id = array_column($jttorder, 'reo_id');
                    $jt_num = count($jttorder);
                    $price = DB::table('recharge_refund')->where('rer_company_id',$v)->where('rer_min','<=',$jt_num)->where('rer_max','>=',$jt_num)->value('rer_price');
                    if(empty($price)){
                        $price = DB::table('recharge_refund')->where('rer_company_id',0)->where('rer_min','<=',$jt_num)->where('rer_max','>=',$jt_num)->value('rer_price');
                    }
                    if($price<0.5){
                        $allprice = (0.5-$price);
                        $allprice = (float)$allprice;
                        $allprice = $allprice * $jt_num;
                        $allprice = sprintf("%.2f", $allprice); // 保留2位小数
                        $cxtk['reo_adm_id'] = 164;
                        $cxtk['reo_company_id'] = $v;//公司id
                        $cxtk['reo_order_number'] = 'TKJ' . CommonService::creactNumber();
                        $cxtk['reo_price'] = $allprice;
                        $cxtk['reo_pay_state'] = 2;
                        $cxtk['reo_state'] = 1;
                        $cxtk['reo_create_time'] = date("Y-m-d H:i:s");
                        $cxtk['reo_pay_time'] = date("Y-m-d H:i:s");
                        $cxtk['reo_pay_way'] = 5;
                        $cxtk['reo_paid_money'] = $allprice;
                        $cxtk['reo_pay_check'] = 1;
                        $cxtk['reo_type'] = 1;
                        $cxtk['reo_client_type'] = 3;
                        $cxtk['reo_remaek'] = '阶梯价退款';
                        DB::beginTransaction(); //开启事务
                        //添加阶梯价退款记录
                        $rec = RechargeOrder::insert($cxtk);
                        //更改已取消退款状态
                        $red = RechargeOrder::whereIn('reo_id',$reo_id)
                            ->update(['reo_refund'=>3]);
                        //公司账号退款充值
                        $update_rea = DB::table('admin_recharge')
                            ->where('adre_company_id', $v)//公司id
                            ->increment('adre_banlance',$allprice);
                        if($rec && $red && $update_rea) {
                            DB::commit();
                        }else{
                            DB::rollBack();
                            continue;
                        }
                    }
                }else{
                    DB::rollBack();
                    continue;
                }
                return [$cxt, $jt_num,$price,0.5-$price,$allprice];
            }catch (Exception $e) {
                DB::rollBack();
                continue;
                // 处理错误
            }

        }
    }


    /**|---------------------------------------------------------------------------------
     * @name 获取京东全渠道订单
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2025/9/30 14:22
     * |---------------------------------------------------------------------------------
    */
    public function omnicOrderList ( $input ){
        $startDate = date("Y-m-d H:i:s",strtotime(" -1360 minute".date("Y-m-d H:i:s")));
        $endDate = date("Y-m-d H:i:s");
        $url_mobile = "http://116.196.75.172/index.php/GetOrder/getmobilelist";//出库
        $url = "http://116.196.75.172/index.php/SaasApiGetOrder/omnicOrderList?startDate=".$startDate."&endDate=".$endDate."&status=300";
        $token = DB::table('jdpop_token')->where('status',1)->where('type',2)->select('app_key','app_secret','access_token','pt_id','auth_key')->get()->toarray();
        foreach($token as $k => $vs) {
            $appKey = $vs['app_key'];
            $accessToken = $vs['access_token'];
            $appSecret = $vs['app_secret'];
            $urls = $url."&authKey=".$vs['auth_key']."&access_token=".$vs['access_token']."&app_key=".$vs['app_key']."&app_secret=".$vs['app_secret'];
            $company_id = Pt::where('id',$vs['pt_id'])->value('company_id');
//            echo $urls;
            $res = $this->http_get($urls);
            $ip = $_SERVER["REMOTE_ADDR"];
            $data = json_decode($res, true);
            $pt_id = $vs['pt_id'];
            CommonService::addLog('获取订单', $urls.'---'.$res, $vs['pt_id'], 'JdOrderApi-getOrder');
            $result = $data['jingdong_omnic_order_query_orderList_responce']['result'];
            if ($result['success'] == true) {
                $order_data = $result['data'];
                if (!empty($order_data)) {
                    $arr = [];
                    $arr_goods = [];
                    if (isset($order_data['data'])) {
                        $order_data = $order_data['data'];
                        $orderInfos=[];
                        $num = 0;
                        foreach($order_data as $kks => $vks){
                            if(!empty($vks['orderShip']['oaid'])) {
                                $orderInfos[$num]['orderId'] = $vks['orderInfo']['salesChannelOrderId'];
                                $orderInfos[$num]['oaid'] = $vks['orderShip']['oaid'];
                                $num++;
                            }
                        }
                        if(!empty($orderInfos)){
                            $poss['appKey'] = $appKey;
                            $poss['accessToken'] = $accessToken;
                            $poss['appSecret'] = $appSecret;
                            $poss['orderInfos'] = json_encode($orderInfos);
                            $user_data=CommonService::requestPost('http://zptzchat.bluearp.com/m/index.php/GetUserDataApi/getOaidDecrypt',$poss);
                            $user_data = json_decode($user_data,true);
                            if($user_data['jingdong_jos_order_oaid_decrypt_responce']['returnType']['code']==200){
                                $user_data = $user_data['jingdong_jos_order_oaid_decrypt_responce']['returnType']['data'];
                                $user_datas = [];
                                foreach($user_data as $ks => $vs){
                                    $user_datas[$vs['orderId']] = $vs;
                                }
                                if(!empty($user_datas)){
                                    foreach($order_data as $ka => $va){
                                        $order_data[$ka]['orderShip']['user_data_dou'] = isset($user_datas[$va['orderInfo']['salesChannelOrderId']])?$user_datas[$va['orderInfo']['salesChannelOrderId']]:'';
                                    }
                                }
                            }
                        }
                        foreach ($order_data as $kkk => $vvv) {
                            if ($vvv['orderDetailList']) {
                                $sku_ids = array_unique(array_column($vvv['orderDetailList'], 'skuId'));
                                $goods_ids = JdBound::whereIn('sku_id', $sku_ids)->pluck('goods_id', 'sku_id');
                                $goods_ids = CommonService::dataToArray($goods_ids);
                                if (empty($goods_ids)) {
                                    CommonService::addLog('SKU_all_no', json_encode($sku_ids), $vvv['orderInfo']['salesChannelOrderId'], 'SKU_all_no');
                                    continue;
                                }
                                $goods_idss = JdBound::whereIn('sku_id', $sku_ids)->pluck('goods_id');
                                $goods_idss = CommonService::dataToArray($goods_idss);
                                if (empty($goods_idss)) {
                                    continue;
                                }
                                $goods = PjGoods::whereIn('pg_id', $goods_idss)->select('pg_id', 'brand_name', 'pg_series', 'version', 'goods_pic_path', 'national_version')->get()->toarray();
                                if ($goods) {
                                    $brand_name = array_unique(array_column($goods, 'brand_name'));
                                } else {
                                    CommonService::addLog('SKU_all_no', json_encode($sku_ids), $vvv['orderInfo']['salesChannelOrderId'], 'nogood');
                                    continue;
                                }
                                $goods = CommonService::jointArrayKey($goods, 'pg_id');
                                if (count($goods) < count($vvv['orderDetailList'])) {
                                    CommonService::addLog('SKU_all_no', json_encode($sku_ids), $vvv['orderInfo']['salesChannelOrderId'], 'SKU_all_no');
                                    continue;
                                }

                                $exsit = Orders::where('order_num', $vvv['orderInfo']['salesChannelOrderId'])->value('id');
                                //存订单
                                $eisit_jd = DB::table('jd_proprietary')->where('order_id', $vvv['orderInfo']['salesChannelOrderId'])->value('id');
                                if ($exsit || !$eisit_jd) {
                                    $resjdgoods = DB::table('jdgoods')->where("order_id", $vvv['orderInfo']['salesChannelOrderId'])->value('id');
                                    $sys_num = 'L' . date("YmdHis") . str_pad(rand(0, 999), 3, '0', STR_PAD_LEFT);
                                    foreach ($vvv['orderDetailList'] as $k => $v) {
                                        //存商品
                                        //`gone_jdgoods` (`order_id`,`pt_id`,`sku_id`,`sku_name`,`item_total`,`jd_price`,`jd_cost`)
                                        if (!$resjdgoods) {
                                            if (in_array($vvv['orderInfo']['salesChannelOrderId'], array_column($arr_goods, 'order_id'))) {
                                                unset($arr_goods[$k]);
                                                // echo 1;echo '---'.$v['orderId'].'---';
                                            }
                                            $arr_goods[$k]['order_id'] = $vvv['orderInfo']['salesChannelOrderId'];
                                            $arr_goods[$k]['pt_id'] = $pt_id;
                                            $arr_goods[$k]['sku_id'] = $v['skuId'];
                                            $arr_goods[$k]['item_total'] = $v['num'];
                                            $arr_goods[$k]['jd_price'] = $v['skuAmount'];
                                            $arr_goods[$k]['jd_cost'] = $v['skuPrice'];
                                            $arr_goods[$k]['sku_name'] = $v['skuName'];
                                            DB::table('jdgoods')->insert($arr_goods[$k]);
                                            unset($arr_goods[$k]);

                                        }
                                        $goodid = $goods_ids[$v['skuId']];
                                        if ($goodid) {
                                            $goods_res = $goods[$goodid];
                                            //    dd($goods_res);
                                            if ($goods_res['pg_series'] == '') {
                                                $type = $goods_res['version'];
                                            } else {
                                                $type = $goods_res['pg_series'] . "-" . $goods_res['version'];
                                            }
                                            $goods_name = $goods_name . $goods_res['brand_name'] . "," . $type . "," . $goods_res['general_version'] . ",";
                                            $good_brand[] = $goods_res['brand_name'];

                                            $orderMsgData[$k]['goods_id'] = $goodid;
                                            $orderMsgData[$k]['goods_name'] = $goods_res['brand_name'] . "-" . $type;
                                            $orderMsgData[$k]['goods_price'] = $v['skuPrice'];//实收/商品单价
                                            $orderMsgData[$k]['goods_paid'] = $v['skuPrice'];
                                            $orderMsgData[$k]['goods_num'] = $v['num'];
                                            $orderMsgData[$k]['goods_brand'] = $goods_res['brand_name'];
                                            $orderMsgData[$k]['goods_number'] = $type;
                                            $orderMsgData[$k]['cd_id'] = 1;
                                        } else {
                                            //未绑定SKU
                                            CommonService::addLog('未绑定SKU', $v['skuId'], $vvv['orderInfo']['salesChannelOrderId'], 'jdAPI_sku');
                                            continue;
                                        }
                                    }

                                    $orders[$kkk]['sys_bh'] = $sys_num;
                                    $orders[$kkk]['skb_bh'] = $vvv['orderInfo']['salesChannelOrderId'];
                                    $orders[$kkk]['pt_id'] = $pt_id;
                                    $orders[$kkk]['ser_type'] = 1;//服务类型：1上门安装，2到店服务
                                    if(isset($vvv['orderShip']['user_data_dou'])){
                                        $fullname = $vvv['orderShip']['user_data_dou']['customerName']??$vvv['orderShip']['consignee'];
                                        if(mb_strlen($fullname, 'UTF-8')>30){
                                            $fullname =  $this->decrypt(['accessToken'=>$accessToken,'appKey'=>$appKey,'appSecret'=>$appSecret],$vvv['orderShip']['consigneeEnc']);
                                            if(strpos($fullname,'<body>' )!==false){
                                                $exs_code = DB::table('jdpop_encode')->where('order_id',$vvv['orderInfo']['salesChannelOrderId'])->value('id');
                                                if($exs_code){
                                                    DB::table('jdpop_encode')->where('order_id',$vvv['orderInfo']['salesChannelOrderId'])->update(['name_code'=>$vvv['orderShip']['consigneeEnc']]);
                                                }else{
                                                    DB::table('jdpop_encode')->insert(['order_id'=>$vvv['orderInfo']['salesChannelOrderId'],'pt_id'=>$pt_id,'name_code'=>$vvv['orderShip']['consigneeEnc']]);
                                                }
                                                $fullname = $vvv['orderShip']['consignee'];
                                            }
                                        }
                                    }else {
                                        $fullname =  $this->decrypt(['accessToken'=>$accessToken,'appKey'=>$appKey,'appSecret'=>$appSecret],$vvv['orderShip']['consigneeEnc']);
                                        if(strpos($fullname,'<body>' )!==false){
                                            $exs_code = DB::table('jdpop_encode')->where('order_id',$vvv['orderInfo']['salesChannelOrderId'])->value('id');
                                            if($exs_code){
                                                DB::table('jdpop_encode')->where('order_id',$vvv['orderInfo']['salesChannelOrderId'])->update(['name_code'=>$vvv['orderShip']['consigneeEnc']]);
                                            }else{
                                                DB::table('jdpop_encode')->insert(['order_id'=>$vvv['orderInfo']['salesChannelOrderId'],'pt_id'=>$pt_id,'name_code'=>$vvv['orderShip']['consigneeEnc']]);
                                            }
                                            $fullname = $vvv['orderShip']['consignee'];
                                        }
                                    }
                                    $orders[$kkk]['shr_name'] = $fullname;
                                    if(isset($vvv['orderShip']['user_data_dou'])){
                                        $tel = $vvv['orderShip']['user_data_dou']['consMobilePhone']??$vvv['orderShip']['consigneePhone'];
                                        if(mb_strlen($tel, 'UTF-8')>20){
                                            $tel =  $this->decrypt(['accessToken'=>$accessToken,'appKey'=>$appKey,'appSecret'=>$appSecret],$tel);
                                            if(strpos($tel,'<body>' )!==false){
                                                $tel = $vvv['orderShip']['consigneePhone'];
                                            }
                                        }

                                    }else {
                                        $tel = $this->request_post($url_mobile,['accessToken'=>$accessToken,'appKey'=>$appKey,'appSecret'=>$appSecret,'customOrderId'=>$vvv['orderInfo']['salesChannelOrderId']]);//同步手机号
                                    }
                                    $orders[$kkk]['shr_phone'] = $tel;//$vv['consigneeInfo']['telephone'];//
                                    $orders[$kkk]['shr_sheng'] = $vvv['orderShip']['addressLevel1Name'];//
                                    $orders[$kkk]['shr_shi'] = $vvv['orderShip']['addressLevel2Name'];//
                                    $orders[$kkk]['shr_xian'] = $vvv['orderShip']['addressLevel3Name'];//
                                    if(isset($vvv['orderShip']['user_data_dou'])){
                                        $fullAddress = $vvv['orderShip']['user_data_dou']['address']??$vvv['orderShip']['deliveryAddress'];
                                        if(!preg_match('/\p{Han}/u', $fullAddress)){
                                            $fullAddress =  $this->decrypt(['accessToken'=>$accessToken,'appKey'=>$appKey,'appSecret'=>$appSecret],$fullAddress);
                                            if(strpos($fullAddress,'<body>' )!==false){
                                                $fullAddress = $vvv['orderShip']['deliveryAddress'];
                                            }
                                        }
                                    }else {
                                        $fullAddress =  $this->decrypt(['accessToken'=>$accessToken,'appKey'=>$appKey,'appSecret'=>$appSecret],$vvv['orderShip']['deliveryAddressEnc']);
                                        if(strpos($fullAddress,'<body>' )!==false){
                                            $exs_code = DB::table('jdpop_encode')->where('order_id',$vvv['orderInfo']['salesChannelOrderId'])->value('id');
                                            if($exs_code){
                                                DB::table('jdpop_encode')->where('order_id',$vvv['orderInfo']['salesChannelOrderId'])->update(['name_code'=>$vvv['orderShip']['deliveryAddressEnc']]);
                                            }else{
                                                DB::table('jdpop_encode')->insert(['order_id'=>$vvv['orderInfo']['salesChannelOrderId'],'pt_id'=>$pt_id,'name_code'=>$vvv['orderShip']['deliveryAddressEnc']]);
                                            }
                                            $fullAddress = $vvv['orderShip']['deliveryAddress'];
                                        }
                                    }
                                    $orders[$kkk]['shr_adress'] = $fullAddress;//
                                    $orders[$kkk]['shr_other'] = '接单后10分钟内务必联系客户核实车型跟安装时间！不断电安装、如果无法完成 请立刻反馈我们处理~！';
                                    $orders[$kkk]['car_audit'] = 2;//1:新订单；2：可派单；3：处理中
                                    $orders[$kkk]['order_type'] = 1;//订单类型：1：普通；20加急；10：夜间
                                    $orders[$kkk]['order_time'] = date('Y-m-d H:i:s', $v['createTime'] / 1000);
                                    $orders[$kkk]['pay_type'] = 1;//支付方式：1在线支付；2货到付款 $input['shr_other']
                                    $orders[$kkk]['goods'] = $orderMsgData;
                                    $orders[$kkk]['shr_other'] = $vvv['orderInfo']['promiseMsg'];
                                    $orders[$kkk]['clientAccount'] = $vvv['orderInfo']['customerId']??'';//客户账号
                                    //   $session = $request->get('session_token');//获取操作人信息
                                    $session['admin_groupnew'] = 7;
                                    $session['admin_acc'] = '系统录入';
                                    $session['id'] = 1133;
                                    $session['company_id'] = $company_id;
                                    $return = OrderaddService::addOrder($orders[$kkk], $session, $ip);
                                    CommonService::addLog('添加定单', json_encode($return), $vvv['orderInfo']['salesChannelOrderId'], 'jdAPI_addOrder');
                                    if ($return['ErrorCode'] == 1 && $company_id!=14) {
                                        $url = "http://116.196.75.172/index.php/SaasApiGetOrder/updatestatus?orderId=" . $vvv['orderInfo']['salesChannelOrderId'] . "&storeId=" . $vvv['orderInfo']['warehouseId'];
                                        $urls = $url."&authKey=".$vs['auth_key']."&access_token=".$vs['access_token']."&app_key=".$vs['app_key']."&app_secret=".$vs['app_secret'];
                                        $ck = $this->http_get($urls);
                                        CommonService::addLog('订单出库', $ck, $vvv['orderInfo']['salesChannelOrderId'], 'jdAPI_addOrderck');
                                    }
                                    //    dump($return);
                                    unset($orderMsgData);
                                    unset($orders[$kkk]);

                                    if (in_array($vvv['orderInfo']['salesChannelOrderId'], array_column($arr, 'order_id'))) {
                                        unset($arr[$kkk]);
                                        // echo 2;echo '---'.$v['orderId'].'---';
                                    }
//                                    $arr[$kkk]['salesChannelOrderId'] = $v['orderId'];
                                    //
                                    $arr[$kkk]['order_id'] = $vvv['orderInfo']['salesChannelOrderId'];
                                    $arr[$kkk]['admin_acc'] = '系统';
                                    $arr[$kkk]['pt_id'] = $pt_id;
                                    $arr[$kkk]['pay_type'] = '在线支付';
                                    $arr[$kkk]['order_seller_price'] = $v['skuAmount'];
                                    $arr[$kkk]['freight_price'] = $v['transactionPrice'] ?? $vvv['orderInfo']['orderTotalAmount'];
                                    $arr[$kkk]['order_state'] = 'WAIT_SELLER_STOCK_OUT';
                                    $arr[$kkk]['invoice_info'] = '不需要开具发票';
                                    $arr[$kkk]['order_remark'] = $vvv['orderInfo']['promiseMsg'];
                                    $arr[$kkk]['order_start_time'] = date('Y-m-d H:i:s', $v['createTime'] / 1000);
                                    $arr[$kkk]['fullname'] = $vvv['orderShip']['consignee'];
                                    $arr[$kkk]['mobile'] = $vvv['orderShip']['consigneeMobile'];
                                    $arr[$kkk]['telephone'] = $vvv['orderShip']['consigneePhone'];//
                                    $arr[$kkk]['province'] = $vvv['orderShip']['addressLevel1Name'];
                                    $arr[$kkk]['city'] = $vvv['orderShip']['addressLevel2Name'];
                                    $arr[$kkk]['county'] = $vvv['orderShip']['addressLevel3Name'];
                                    $arr[$kkk]['full_address'] = $vvv['orderShip']['deliveryAddress'];
                                    $arr[$kkk]['order_pay'] = $v['skuAmount'];
                                    $arr[$kkk]['is_show'] = 1;
                                    $arr[$kkk]['parent_orderid'] = 0;
                                    DB::table('jd_proprietary')->insert($arr[$kkk]);
//                                    dd($arr[$kkk]);
                                    unset($arr[$kkk]);

                                } else {
                                    CommonService::addLog('单号已存在', json_encode($vvv), $vvv['orderInfo']['salesChannelOrderId'], 'jdAPI_addOrder');
                                }

                            }
                        }
                    }
                    echo "succese";
                }
            }
        }
    }
}
