<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use BlueCity\Data\Service\DataCenter\AutoDataService;
use DB;
class QueryBrandController extends BaseController
{
    /**
     * @name 搜索问题及答案
     * @param need 输入内容
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/1
     */
/*    public function search_need(Request $request)
    {
        $need = $request->input('need','');
        $list =　Db::table('databasescontent')->join('databasestitle','d_id','=','dc_did')->join('databasestype','dc_type','=','dt_id')->leftjoin('pt','dc_pid','=','id')->where('d_title','like','%'.$need.'%')->orWhere('d_name','like','%'.$need.'%')->orWhere('d_product','like','%'.$need.'%')->where('d_keywords','like','%'.$need.'%')->orWhere('d_content','like','%'.$need.'%')->orderBy('dc_sord','desc')->select('dc_id','d_title','dc_content','dc_sord','dc_status','dc_creatime','d_name','dt_name','pt_name')->get();
        if (!$list->isEmpty()){
            return $this->success('获取成功',$list);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }

    }*/

    /**
     * @name 根据车型搜电瓶
     * @param conditions 查询内容
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2021/9/1
     */
	public function search_battery (Request $request)
    {
        $input  = $request->all();
        if(!$request->input('conditions')){
            return $this->error('请输入查询关键字', ErrorInc::FAILED_PARAM);
        }
        $session_token = $request->get('session_token');
        if(in_array($session_token['company_id'],[14])){
            $wqj = $input['conditions'];
            if(ctype_digit($wqj)) {
                $car = DB::table('car_searchnew_deke')
                    ->whereRaw("cs_brand like '%" . $wqj . "%' or cs_series like '%" . $wqj . "%' or cs_dpm like '%" . $wqj . "%' or cs_config like '%" . $wqj . "%' or (cs_start_year<='" . $wqj . "' and (cs_end_year>='" . $wqj . "' or cs_end_year=''))")
                    ->orderBy('cs_id', 'ASC')->get();
            }else{
                $car = DB::table('car_searchnew_deke')
                    ->whereRaw("cs_brand like '%" . $wqj . "%' or cs_series like '%" . $wqj . "%' or cs_dpm like '%" . $wqj . "%' or cs_config like '%" . $wqj . "%'")
                    ->orderBy('cs_id', 'ASC')->get();
            }
            if(!empty($car)){
                $car = CommonService::dataToArray($car);
                foreach($car as $k => $v){
                    $car[$k]['cs_startyear'] = explode('/', $v['cs_start_year'])[0];
                    if($car[$k]['cs_end_year']!=''){
                        $car[$k]['cs_endyear'] = explode('/', $v['cs_end_year'])[0];
                    }else{
                        $car[$k]['cs_end_year'] = '今';
                        $car[$k]['cs_endyear'] =date("Y-m-d");
                    }
                    $car[$k]['details']=$v['cs_brand']." ".$v['cs_series']." ".$v['cs_dpm']." ".$v['cs_config']." ".$car[$k]['cs_startyear']." ".$car[$k]['cs_endyear'];
                    $car[$k]['good_name'] = $v['cs_good_baran']."-".$v['cs_good_series']."-".$v['cs_good_version']."(".$v['cs_good_versions'].")";
                    $car[$k]['psj_pjid']=$v['cs_id'];
                    $car[$k]['psj_brand']=$v['cs_brand'];
                    $car[$k]['psj_series']=$v['cs_series'];
                    $car[$k]['psj_model']='';
                    $car[$k]['psj_models']=$v['cs_dpm']." ".$v['cs_config'];
                    $car[$k]['psj_year']=$v['cs_start_year'].'至'.$car[$k]['cs_end_year'];
                }
                return response()->json(['Data' => $car, 'ErrorCode' => 1, 'ErrorMessage' => '成功']);
            }else{
                return response()->json(['Data' => '', 'ErrorCode' => 2, 'ErrorMessage' => '暂无数据']);
            }
        }else {
            $url = 'http://zptz.bluearp.com/index.php/api/searchBrand/index';

            $ret = CommonService::requestPost($url, $input);
            return $ret;
        }
       /* $wqj  = $request->input('conditions');
//        $car = DB::table('pj_search')->where('psj_brand','like','%'.$wqj.'%')->orWhere('psj_series','like','%'.$wqj.'%')->orWhere('psj_model','like','%'.$wqj.'%')->orWhere('psj_models','like','%'.$wqj.'%')->orWhere('psj_year','like','%'.$wqj.'%')->orderBy('psj_pjid','ASC')->get();
        $car = DB::table('car_searchnew')->where('cs_brand','like','%'.$wqj.'%')->orWhere('cs_series','like','%'.$wqj.'%')->orWhere('cs_model','like','%'.$wqj.'%')->orWhere('cs_config','like','%'.$wqj.'%')->orWhere('cs_year','like','%'.$wqj.'%')->orderBy('cs_id','ASC')->get();
        if (!$car->isEmpty()){
            $car = $car->toArray();
            foreach( $car as $k => $v ){
                $car[$k]['details']=$v['cs_brand']." ".$v['cs_series']." ".$v['cs_model']." ".$v['cs_config']." ".$v['cs_standard']." ".$v['cs_structure']." ".$v['cs_dpm']." ".$v['cs_drive']." ".$v['cs_year'];
                if($v['cs_varta']!="" && $v['cs_varta']!="无"){
                    //$car[$k]['psj_varta']=explode("::",$v['psj_varta'])[1];
                    unset($car[$k]['cs_varta']);
                    $car[$k]['psj_varta']=$this->break_up($v['cs_varta']);
                }else{
                    $car[$k]['psj_varta']="无";
                }
                if($v['cs_fengf']!="" && $v['cs_fengf']!="无"){
                    //$car[$k]['psj_fengf']=explode("::",$v['psj_fengf'])[1];
                    unset($car[$k]['cs_fengf']);
                    $car[$k]['psj_fengf']=$this->break_up($v['cs_fengf']);
                }else{
                    $car[$k]['psj_fengf']="无";
                }
                if($v['cs_luot']!="" && $v['cs_luot']!="无"){
                    //$car[$k]['psj_luot']=explode("::",$v['psj_luot'])[1];
                    unset($car[$k]['cs_luot']);
                    $car[$k]['psj_luot']=$this->break_up($v['cs_luot']);
                }else{
                    $car[$k]['psj_luot']="无";
                }
                if($v['cs_tangq']!="" && $v['cs_tangq']!="无"){
                    //$car[$k]['psj_tangq']=explode("::",$v['psj_tangq'])[1];
                    unset($car[$k]['cs_tangq']);
                    $car[$k]['psj_tangq']=$this->break_up($v['cs_tangq']);
                }else{
                    $car[$k]['psj_tangq']="无";
                }
                if($v['cs_tongy']!="" && $v['cs_tongy']!="无"){
                    //$car[$k]['psj_tongy']=explode("::",$v['psj_tongy'])[1];
                    unset($car[$k]['cs_tongy']);
                    $car[$k]['psj_tongy']=$this->break_up($v['cs_tongy']);
                }else{
                    $car[$k]['psj_tongy']="无";
                }
                if($v['cs_lish']!="" && $v['cs_lish']!="无"){
                    //$car[$k]['psj_lish']=explode("::",$v['psj_lish'])[1];
                    unset($car[$k]['cs_lish']);
                    $car[$k]['psj_lish']=$this->break_up($v['cs_lish']);
                }else{
                    $car[$k]['psj_lish']="无";
                }
                if($v['cs_derf']!="" && $v['cs_derf']!="无"){
                    //$car[$k]['psj_derf']=explode("::",$v['psj_derf'])[1];
                    unset($car[$k]['cs_derf']);
                    $car[$k]['psj_derf']=$this->break_up($v['cs_derf']);
                }else{
                    $car[$k]['psj_derf']="无";
                }
                if($v['cs_boshi']!="" && $v['cs_boshi']!="无"){
                    //$car[$k]['psj_derf']=explode("::",$v['psj_derf'])[1];
                    unset($car[$k]['cs_boshi']);
                    $car[$k]['psj_boshi']=$this->break_up($v['cs_boshi']);
                }else{
                    $car[$k]['psj_boshi']="无";
                }
                $car[$k]['psj_pjid']=$v['cs_id'];
                $car[$k]['psj_brand']=$v['cs_brand'];
                $car[$k]['psj_series']=$v['cs_series'];
                $car[$k]['psj_model']=$v['cs_model'];
                $car[$k]['psj_models']=$v['cs_config']." ".$v['cs_standard']." ".$v['cs_structure']." ".$v['cs_dpm']." ".$v['cs_drive'];
                $car[$k]['psj_year']=$v['cs_year'];
                unset($car[$k]['cs_id']);
                unset($car[$k]['cs_brand']);
                unset($car[$k]['cs_series']);
                unset($car[$k]['cs_model']);
                unset($car[$k]['cs_year']);
                unset($car[$k]['cs_config']);
                unset($car[$k]['cs_standard']);
                unset($car[$k]['cs_structure']);
                unset($car[$k]['cs_dpm']);
                unset($car[$k]['cs_drive']);
            }
            return response()->json(['Data' => $car, 'ErrorCode' => 1, 'ErrorMessage' => '成功']);
        }else{
            return response()->json(['Data' => '', 'ErrorCode' => 2, 'ErrorMessage' => '无数据']);
        }
        exit;*/
        $wqj  = $request->input('conditions');
        $limit = $request->input('limit', 9999);
        $data = AutoDataService::searchBatteryByKeyword($wqj, $limit);
        // return $this->success('获取成功',$data);exit;
        if($data){
            if($data['code'] != 0){
                return $this->error($data['msg'], ErrorInc::MYSQL_FAILED);exit;
            }
            if(empty($data['data'])){
                return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
            }
            $car = [];
            //排量符号
            $carDpm = [
                0 => '',
                1 => 'L',
                2 => 'T'
            ];
            foreach( $data['data'] as $k => $v ){
                $car[$k]['details'] = $v['carMasterBrandName']." ".$v['carBrandName']." ".$v['carSeriesName']." ".$v['carNewName']." ".$v['carEmissionStandardName']." ".$v['carStructure']." ".$v['carDpm'].$carDpm[$v['engineType']]." ".$v['carDrive']." ".$v['carYear'];
                if(!empty($v['brandBatteryList'])){
                    foreach($v['brandBatteryList'] as $key => $value){
                        switch ($value['brandName']) {
                            case '瓦尔塔':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_varta'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_varta'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_varta'] = '无';
                                }
                                break;
                            case '风帆':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_fengf'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_fengf'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_fengf'] = '无';
                                }
                                break;
                            case '骆驼':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_luot'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_luot'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_luot'] = '无';
                                }
                                break;
                            case '汤浅':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_tangq'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_tangq'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_tangq'] = '无';
                                }
                                break;
                            case '统一':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_tongy'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_tongy'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_tongy'] = '无';
                                }
                                break;
                            case '理士':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_lish'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_lish'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_lish'] = '无';
                                }
                                break;
                            case '德尔福':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_derf'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_derf'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_derf'] = '无';
                                }
                                break;
                            case '博世':
                                if(!empty($value['batteryList'])){
                                    $car[$k]['psj_boshi'] = [];
                                    foreach($value['batteryList'] as $ke => $va){
                                        $car[$k]['psj_boshi'][] = ['good_id'=>$va['id'],'good_name'=>$va['seriesName'].'-'.$va['name']];
                                    }
                                }else{
                                    $car[$k]['psj_boshi'] = '无';
                                }
                                break;
                            default:
                                # code...
                                break;
                        }
                    }
                }else{
                    $car[$k]['psj_varta'] = '无';
                    $car[$k]['psj_fengf'] = '无';
                    $car[$k]['psj_luot'] = '无';
                    $car[$k]['psj_tangq'] = '无';
                    $car[$k]['psj_tongy'] = '无';
                    $car[$k]['psj_lish'] = '无';
                    $car[$k]['psj_derf'] = '无';
                    $car[$k]['psj_boshi'] = '无';
                }
                $car[$k]['psj_pjid'] = $v['id'];
                $car[$k]['psj_brand'] = $v['carMasterBrandName'];
                $car[$k]['psj_series'] = $v['carBrandName'];
                $car[$k]['psj_model'] = $v['carSeriesName'];
                $car[$k]['psj_models'] = $v['carNewName']." ".$v['carEmissionStandardName']." ".$v['carStructure']." ".$v['carDpm'].$carDpm[$v['engineType']]." ".$v['carDrive'];
                $car[$k]['psj_year'] = $v['carYear'];
            }
            return $this->success('获取成功',$car);exit;
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }

        if(!$data){
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);exit;
        }
        // return $this->success('获取成功',$data);exit;

    }
    public function break_up ($version)
    {
        $version = explode(':x:',$version);
        foreach( $version as $k => $v ){
            $html[$k]['good_id'] = explode('::',$v)[0];
            $html[$k]['good_name'] = explode('::',$v)[1];
        }
        return $html;
    }
     /**|---------------------------------------------------------------------------------
     * @name 纠错匹配型号
     * @param wqj 输入内容
     * @param psj_pjid 车辆数据id
     * @param good_id 商品id
     * @param good_name  商品旧型号
     * @param good_namenew  纠错型号
     * @param good_pic  纠正图片
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020-01-16 17:54>
     * |---------------------------------------------------------------------------------
     */
    public function good_correct(Request $request){
        $input = $request->all();
        if(!$request->filled('good_id')||!$request->filled('psj_pjid')||!$request->filled('good_namenew')||!$request->filled('details')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM);
        }
        $data = AutoDataService::batteryErrorCorrection($input['psj_pjid'], $input['good_id'], $input['good_namenew'], $input['good_pic'], $request->get('session_token')['admin_acc']);
        if($data){
            if($data['code'] != 0){
                return $this->error($data['msg'], ErrorInc::MYSQL_FAILED);exit;
            }
            $this->insertingLog("纠错",'',"纠错：".$input['good_name']."，电瓶id：".$input['good_id'],"电瓶查询",$request->ip(), $request->get('session_token')['admin_acc']);//日志
            return $this->success('操作成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }
    }
}
