<?php
namespace App\Http\Controllers\DatasBase;
use App\Http\Controllers\BaseController;
use App\Services\BmmcService;
use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;

class PtTypeController extends BaseController{
    public function index ( Request $request ){
        $input = $request->all();
        $Db = DB::table('pt_type');
        if(isset($input['type_name'])){
            $Db = $Db->where('type_name',$input['type_name']);
        }
        $page_size = (int)$request->input('page_size',10);
        $page = (int)$request->input('page',1);
        if($page<1){
            $page = 1;
        }
        $offset = ($page-1)*$page_size;
        $count = $Db->count();

        $list = $Db->orderBy('id','DESC')->offset($offset)->limit($page_size)->get();
        $all_button = BmmcService::whereButton($request->input('token'),$request->input('Pri_id'));
        $export = BmmcService::getTopButton('addPtType','',$all_button);
        $data['button_top'] = $export['button_top']??[];//顶部按钮
        $data['button_search'] = $export['button_search']??[];//搜索栏按钮

        if (!$list->isEmpty()) {
            $list = $list->toArray();
            foreach ($list as $k=>$v){
                $buttonData = [];
                $buttonData[] = 'editPtType';
                $button = BmmcService::getListButton($buttonData,$all_button);
                $list[$k]['button_one'] = $button['button_one']??[];
                $list[$k]['button_two'] = $button['button_two']??[];
                $list[$k]['button_three'] = $button['button_three']??[];
            }
        $data['list'] = $list;
        $data['page'] = [
            'count' => $count,
            'page'  => $page,
            'page_size' => $page_size,
            'allPage'  => ceil($count/$page_size)
        ];
        return $this->success('获取成功', $data); exit;
    }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$data);exit;
        }
    }

    /**
     * @name 添加
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/4/19
     */
public function addPtType(Request $request){
    if (!$request->filled('type_name')) {
        return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
    }
        $type_name = $request->input('type_name');
        $exits = DB::table('pt_type')->where('type_name',$type_name)->value('id');
        if ($exits) {
            return $this->error('该类型已存在，无需重复添加', ErrorInc::MYSQL_FAILED);exit;
        }
        $remark = $request->input('remark','');

        $res = DB::table('pt_type')->insertGetId([
            'type_name'          => $type_name,//类型名
            'remark'      => $remark,
            'create_name'       => $request->get('session_token')['admin_acc'],
            'update_name'      => $request->get('session_token')['admin_acc']
        ]);
        if ($res) {
            $this->insertingLog("添加","",'数据id：'.$res.'，类型名：'.$type_name,"平台类型",$request->ip(), $request->get('session_token')['admin_acc']);
            return $this->success('操作成功');exit;
        }else{
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
        }

}

    /**
     * @name 编辑
     * @param Request $request
     * @return mixed
     * @author du
     * @date 2022/4/19
     */
public function editPtType(Request $request){
    if (!$request->filled('type_name')||!$request->filled('id')) {
        return $this->error('参数错误', ErrorInc::FAILED_PARAM);exit;
    }
    $type_name = $request->input('type_name');
    $id = intval($request->input('id'));
    $exits = DB::table('pt_type')->where('type_name',$type_name)->where('id','!=',$id)->value('id');
    if ($exits) {
        return $this->error('该类型已存在，无需重复添加', ErrorInc::MYSQL_FAILED);exit;
    }
    $remark = $request->input('remark','');
    $res = DB::table('pt_type')->where('id',$id)->update([
        'type_name'          => $type_name,//类型名
        'remark'      => $remark,
        'update_time'   => date('Y-m-d H:i:s'),
        'update_name'      => $request->get('session_token')['admin_acc']
    ]);
    if ($res) {
        $this->insertingLog("编辑","",'数据id：'.$id.'，类型名：'.$type_name,"平台类型",$request->ip(), $request->get('session_token')['admin_acc']);
        return $this->success('编辑成功');exit;
    }else{
        return $this->error('操作失败', ErrorInc::MYSQL_FAILED);exit;
    }
}



}
