<?php
/**
 * 文件名称（开户行号管理）
 * 文件简单描述（管理门店结算的使用到的开户行的银行编号）
 * @author DouBin
 * @Date: 2022/6/7
 * @Time: 18:17
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use App\Models\AdminKhaccount;
use App\Services\CommonService;
use App\Services\KhAccountService;
use Illuminate\Http\Request;
use DB;
use Validator;
use BlueCity\Core\Inc\ErrorInc;
/**
 * @name 开户行号管理
 * Class KhAccountController
 * @package App\Http\Controllers\Common
 */
class KhAccountController extends BaseController
{
	/**|---------------------------------------------------------------------------------
	 * @name 列表页
	 * @param string ju_ordernum 订单单号
	 * @retrun \Illuminate\Http\JsonResponse
	 * @author dou 2022/6/7 18:17
	 * |---------------------------------------------------------------------------------
	*/
	public function index (Request $request){
        $session = $request->get('session_token');
        $input = $request->all();
        $list = KhAccountService::getList($input, $session);
        if (!in_array($request->input('state'),[0,1,2])){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
        if($list['list']){
            return $this->success('获取成功', $list);
        }else{
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);
        }
        exit;
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加数据
     * @param string aka_account 开户行账号
     * @param string aka_name 开户行名称
     * @param string aka_type 数据状态1启用2停用
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2022/6/7 19:30
     * |---------------------------------------------------------------------------------
    */
    public function addEntry ( Request $request ){
        $input = $request->only('aka_account','aka_name','aka_type');
        $checkKey=CommonService::checkKey(['aka_account','aka_name','aka_type'],$input,array('aka_account'=>'开户行账号','aka_name'=>'开户行名称','aka_type'=>'数据状态'));
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $session = $request->get('session_token');
        $ip = $request->ip();
        $list = AdminKhaccount::where('aka_account',$input['aka_account'])->whereOr('aka_name',$input['aka_name'])->value("aka_id");
        if(!$list) {
            $input['aka_creactor'] = $session['admin_acc'];
            $input['aka_creactid'] = $session['id'];
            $input['aka_creactime'] = date("Y-m-d H:i:s");
            $res = AdminKhaccount::insert($input);
            $content = "添加" . $input['aka_name'] . "(" . $input['aka_account'] . ")";
            if ($res) {
                $this->insertingLog('添加信息，', $input['aka_account'], $content, '开户行行号管理', $ip, $session['admin_acc']);
                return $this->success('操作成功');
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_STEP_FAILED);
            }
        }else{
            return $this->error('数据已存在', ErrorInc::REPEAT_SUBMIT);
        }
        exit;
    }

    /**|---------------------------------------------------------------------------------
     * @name 编辑数据
     * @param string aka_account 开户行账号
     * @param string aka_name 开户行名称
     * @param string aka_type 数据状态1启用2停用
     * @param string aka_id 数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2022/6/8 14:35
     * |---------------------------------------------------------------------------------
    */
    public function editEntry ( Request $request ){
        $input = $request->only('aka_account','aka_name','aka_type','aka_id');
        $checkKey=CommonService::checkKey(['aka_account','aka_name','aka_type','aka_id'],$input,array('aka_account'=>'开户行账号','aka_name'=>'开户行名称','aka_type'=>'数据状态','aka_id'=>'数据编号'));
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $session = $request->get('session_token');
        $ip = $request->ip();
        $db = new AdminKhaccount();
        $data = CommonService::getMysqlData($db, ['aka_id'=>$input['aka_id']],[],[],'first');
        $list = AdminKhaccount::whereRaw("(aka_account = '".$input['aka_account']."' or aka_name = '".$input['aka_name']."')")->where('aka_id','!=',$input['aka_id'])->value("aka_id");
        if(!$list) {
            $id = $input['aka_id'];
            unset($input['aka_id']);
            $input['aka_updatetime'] = date("Y-m-d H:i:s");
            CommonService::startmysql();
            $res = AdminKhaccount::where('aka_id',$id)->update($input);
            $content = "编辑" . $data['aka_name'] . "(" . $data['aka_account'] . ")->".$input['aka_name'] . "(" . $input['aka_account'] . ")";
            if ($res) {
                $this->insertingLog('编辑信息，', $input['aka_account'], $content, '开户行行号管理', $ip, $session['admin_acc']);
                return $this->success('操作成功');
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_STEP_FAILED);
            }
        }else{
            return $this->error('数据已存在', ErrorInc::REPEAT_SUBMIT);
        }
        exit;
    }

}
