<?php

namespace App\Http\Controllers;

use App\Models\Czrz;
use App\Services\CommonService;
use App\Services\PlatformService;
use DB;
use Illuminate\Http\Request;
use League\Flysystem\Exception;
use BlueCity\Core\Controllers\CoreController as Controller;
use \BlueCity\Core\Inc\ErrorInc;
use App\Models\Note;
use App\Models\OrderTime;

class BaseController extends Controller
{
	/**|---------------------------------------------------------------------------------
     * 写入日志
     * @param $type         类型
     * @param $order_number 单号
     * @param $content      内容
     * @param $model        模块名称
     * @param $ip           ip
     * @param $admin_acc    用户名
     * @return int
     * @author dou <2021/07/16>
     * |---------------------------------------------------------------------------------
     */
    public function insertingLog($type,$order_number,$content,$model,$ip,$admin_acc)
    {

        $data['czrz_name'] = $admin_acc . "(新)";//登录者
        $data['czrz_ip'] = $ip;//操作ip
        $data['czrz_czsj'] = date("Y-m-d H:i:s");//创建时间
        $data['test_data'] = $model;//操作模块名称
        $data['czrz_czlx'] = $type;//创建类型
        $data['czrz_czxq'] = $content;//操作内容
        $data['czrz_number'] = $order_number;//操作单号

        $res = Czrz::insert($data); //添加操作日志
        if ($res) {
            return 1;
        } else {
            return 2;
        }
    }
    /**|---------------------------------------------------------------------------------
     * 外层数组内层对象转数组
     * @param array $list   带转化数据
     * @return array
     * @author dou <2021/07/16>
     * |---------------------------------------------------------------------------------
     */
     public function dataToArray ( $list ){
     	return json_decode(json_encode($list),true);
     }



     /**
      *@name 添加备注
      * @param $sys_num 系统单号
      * @param $note_type 备注类型
      * @param $note_content 备注内容
      * @param $send_num 派工单号
      * @param $public_state 安装点是否可见 1：可见；2：不可见
      * @param $admin_groupnew
      * @param $admin_acc
      * @param $id
      * @return number
      * @author du 2021年7月28日下午4:04:42
      */
     public function accMe ($sys_num,$note_type,$note_content,$send_num,$public_state,$admin_groupnew,$admin_acc,$id)
     {
         return CommonService::accMe($sys_num, $note_type, $note_content, $send_num, $public_state, $admin_groupnew, $admin_acc, $id);
//     	if($send_num){
//     		$note_content = $note_content."(".$send_num.")";
//     	}
//     	if($admin_groupnew==2){//设置服务中心添加的备注为可见
//     		$data['public_state'] = 2;
//     	}else{
//     		if($public_state){
//     			$data['public_state'] = $public_state;
//     		}
//     	}
//
//     	$data['orders_id'] = $sys_num;
//     	$data['note_name'] = $admin_acc;
//     	$data['note_content'] = $note_content;
//     	$data['note_time'] = date("Y-m-d H:i:s");
//     	$data['note_type'] = $note_type;
//     	$data['note_adid'] = $id;//添加人id
//     	$data['note_group'] = $admin_groupnew;//备注类型
//     	$rest = Note::insert($data);
//     	if(strpos($note_type,"售后") >= 0){
//     		$after_num = DB::table("order_after")->where('sys_num',$sys_num)->select('p_id','order_num')->first();
//     		$data['order_num'] = $after_num['order_num'];
//     		if($after_num['p_id']=='140' || $after_num['p_id']=='146'){
//     			$rese=$this->request_post('http://jyo2o.sudianwang.com/index.php/Car/add_not',$data,'');
//     			$rese = json_decode($rese, true);
//     			if ($rese['code'] != 1) {
//     				return 2;
//     			}
//     		}
//     	}
//     	if($rest){
//     		return 1;
//     	}else{
//     		return 2;
//     	}
     }


     /**|---------------------------------------------------------------------------------
      * @name  通知人设置
      * @param  $search_type  操作类型
      * @param  $admin_id  同时人id
      * @param  $type  通知类型
      * @return \Illuminate\Http\JsonResponse
      *|---------------------------------------------------------------------------------
      */
     public function Notifier($search_type,$admin_id,$type){
     	if($search_type=='1'){
     		$res = Db::table('infonotifier')->where('inn_type',$type)->first();
     		if($res){
     			return $this->success('操作成功', $res);exit;
     			//return response()->json(['ErrorCode'=>1,'ErrorMessage'=>"操作成功",'Data'=>$res]);exit;
     		}else{
     			return $this->error('操作失败', ErrorInc::MYSQL_FAILED, []);exit;
     			//return response()->json(['ErrorCode'=>2,'ErrorMessage'=>"操作失败",'Data'=>'']);exit;
     		}
     	}elseif ( $search_type=='2' ){
     		if($admin_id==''){
     			return $this->error('人员信息不可为空', ErrorInc::FAILED_PARAM, []);exit;
     			//return response()->json(['ErrorCode'=>2,'ErrorMessage'=>"人员信息不可为空",'Data'=>'']);exit;
     		}
     		$poss['inn_admin_id']=$admin_id;
     		$res = Db::table('infonotifier')->where('inn_type',$type)->update($poss);
     		if($res){
     			return $this->success('操作成功', $res);exit;
     			//return response()->json(['ErrorCode'=>1,'ErrorMessage'=>"操作成功",'Data'=>$res]);exit;
     		}else{
     			return $this->error('操作失败', ErrorInc::MYSQL_FAILED, []);exit;
     			//return response()->json(['ErrorCode'=>2,'ErrorMessage'=>"操作失败",'Data'=>'']);exit;
     		}
     	}
     }


     /**|---------------------------------------------------------------------------------
      * @name 推送自定义消息
      * @param $msgBody 推送数据
      * @param $pushTime 延时时间
      * @param $moduleId 推送类型 1消息，2催单，3退款，4预约 5,预备注咨询 6,回收通知
      * @param $moduleDataId 推送编号
      * @param $recId 接收人
      * @param $targetType 推送类别 0pc接收，1后台接口
      * @param $storeId 推送部门默认无部门填写0
      * @return \Illuminate\Http\JsonResponse   //sd-test6e384e3df1480d7c  sd-testb7ef5f8db304dc53a3c59adee7706f
      * @author dou <2021/03/30 14:31>
      * |---------------------------------------------------------------------------------
      */
     public function pushRecord ($msgBody,$pushTime='',$moduleId,$moduleDataId,$recId,$targetType,$storeId ){
     	$poss['appId'] = 'sd6e384e3df1480d7c';//"sd-test6e384e3df1480d7c";//"sd6e384e3df1480d7c";　
     	$poss['moduleDataId'] = $moduleDataId;
     	$poss['moduleId'] = $moduleId;
     	$poss['msgBody'] = json_encode($msgBody,JSON_UNESCAPED_UNICODE);
     	$poss['recId'] = $recId;
     	$poss['storeId'] = $storeId;
     	$poss['targetType'] = $targetType;
     	if($pushTime!=''){
     		$poss['pushTime'] = $pushTime;
     	}
     	$poss = json_encode($poss,JSON_UNESCAPED_UNICODE);
     	$header[] = "signature:".md5($poss."sdb7ef5f8db304dc53a3c59adee7706f");//"sdb7ef5f8db304dc53a3c59adee7706f"  "sd-testb7ef5f8db304dc53a3c59adee7706f"
     	$header[] = 'Content-Type:application/json';
     	$push = $this->request_post('http://im.bluearp.com/im/push-record/save',$poss,$header);
     	return $push;
     }
     /**|-------------------------------------------------------------------------------
      * @name 取消推送
      * @param $moduleDataId 订单单号
      * @param $moduleId  推送类型 1消息，2催单，3退款，4预约
      * @author du <2021-02-24>
      * |---------------------------------------------------------------------------------
      */
     public function pushWebDel($moduleDataId,$moduleId){
     	$poss['appId'] = "sd6e384e3df1480d7c";
     	$poss['moduleDataId'] = $moduleDataId;//订单单号
     	$poss['moduleId'] = $moduleId;// 推送类型 1：新订单
     	$poss = json_encode($poss,JSON_UNESCAPED_UNICODE);
     	$header[] = "signature:".md5($poss."sdb7ef5f8db304dc53a3c59adee7706f");
     	$header[] = 'Content-Type:application/json';
     	$push = $this->request_post('http://im.bluearp.com/im/push-record/remove',$poss,$header);
     	return $push;
     }

     public function request_post($url,$param,$header='') {
     	/*$header = array(
     	 'Content-Type: application/json',
     	);*/
     	$ch = curl_init();
     	curl_setopt($ch, CURLOPT_URL, $url);
     	if($header!=''){
     		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
     	}
     	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
     	curl_setopt($ch, CURLOPT_POST, 1);
     	if($header!=''){
     		curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
     	}else{
     		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($param));
     	}
     	$response = curl_exec($ch);
     	curl_close($ch);
     	return trim($response);
     }

    function http_get($url, $ssl = FALSE)
    {
        $curl = curl_init(); // 启动一个CURL会话
        curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址
        if($ssl)
        {
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0); // 对认证证书来源的检查
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 1); // 从证书中检查SSL加密算法是否存在
            curl_setopt($curl, CURLOPT_SSLVERSION, 3);
        }
        curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览器
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1); // 自动设置Referer
        curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循环
        curl_setopt($curl, CURLOPT_HEADER, 0); // 显示返回的Header区域内容
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); // 获取的信息以文件流的形式返回
        $tmpInfo = curl_exec($curl); // 执行操作
        if (curl_errno($curl)) {
            //var_dump(curl_error($curl));
            return FALSE;
        }
        curl_close($curl); // 关闭CURL会话
        return $tmpInfo; // 返回数据
    }

     /**|-----------------------------------------------------------------
      * @name 订单操作时间
      * @param $num
      * @param $type
      * @param $order_num
      * @param $time
      * @return int
      * |-----------------------------------------------------------------
      */
     public function operatingTime ($num,$type,$time,$order_num,$admin_acc)
     {
     	$data['serial_number'] = $num;
     	$data['create_name'] = $admin_acc;
     	$data['is_type'] = $type;
     	$data['order_num'] = $order_num;
     	$data['create_time'] = $time;
     	$result = OrderTime::insert($data);
     	if($result){
     		return 1;exit;
     	}else{
     		return 2;exit;
     	}
     }



     /**|------------------------------------------------------------
      * @name 添加时间戳
      * @param $number
      * @param $timetype
      * @param $time
      * @param $ser_id
      * @param $type
      * |------------------------------------------------------------
      */
     public function addThistory ($number,$timetype,$time,$ser_id,$type)
     {
     	if($type==1){
     		$poss[$timetype] = strtotime($time);
     		$poss['tih_serid'] = $ser_id;
     		$poss['tih_number'] = $number;
     		DB::table('time_history')->insert($poss);
     	}else{
     		$poss[$timetype] = strtotime($time);
     		DB::table('time_history')->where('tih_number',$number)->update($poss);
     	}
     }

    /**|---------------------------------------------------------------------------------
     * @name 图片链接获取
     * @param $pic 问价地址链接
     * @param $type 请求类型
     * @param $pt_id 所属平台
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020/12/17 14:35>
     * |---------------------------------------------------------------------------------
     */
    public function picurl($pic , $type = 1, $pt_id = 0)
    {
        if(strstr($pic,'http') || $pic == ''){
            return $pic;
        }else{
            return $this->baseurl($type,$pt_id).$pic;
        }
    }
    //本域名
    public function baseurl($type,$pt_id)
    {
        $pt_id_arr = PlatformService::getPtIdByPtType();
       // if($pt_id == '453')
        if(in_array($pt_id, $pt_id_arr)){
            return 'http://jdh.bluearp.com/';
        }else {
            if ($type == 3) {
                return 'http://jx.bluearp.com/o/';
            } else {
                return 'http://mo2o.sudianwang.com/';
            }
        }
    }
}


