<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\ServiceEvaluationValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\ServiceEvaluationService;

// 移动端-账单列表
class ServiceEvaluationController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataValidator = new ServiceEvaluationValidator();
    }

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        
        $return_data = ServiceEvaluationService::index($request->all(), $this->show_count);
        return $return_data;
    }
}
