<?php
/**
 * 文件名称（同步京东据）
 * 文件简单描述（用于同步京东平台数据数据）
 * @author DouBin
 * @Date: 2022/04/21
 * @Time: 18:19
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Http\Controllers\Api;
use App\Http\Controllers\BaseController;
use App\Services\CommonService;
use App\Services\OrderService;
use App\Services\RefundService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use DB;


class AddJdDataController extends BaseController
{
    /**|---------------------------------------------------------------------------------
     * @name 同步退款数据
     * @param string
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2022/4/21 18:21
     * |---------------------------------------------------------------------------------
    */
    public function addRefundData ( Request $request ){
        $inputdata = $request->input('data');
        $post_arr = json_decode($inputdata,true);
        $data = $post_arr['resultDtoList']??'';
        if($data){
            $return = [];
            foreach($data as $k => $v){
                if($v['approvalState']===0) {
                    $flag = 1;
                    $refundlist = RefundService::getInfoByKeyValue('order_num', $v['customOrderId'], ['state', 'roPreNo']);
                    if ($refundlist) {
                        $state = array_column($refundlist, 'state');
                        $state = min($state);
                        if ($state < 5) {
                            $rea = '存在未完成的退款数据';
                            $flag = 2;
                        } else {
                            $roPreNo = array_column($refundlist, 'roPreNo');
                            if (in_array($v['roPreNo'], $roPreNo)) {
                                $rea = '退款单已同步';
                                $flag = 2;
                            }
                        }
                    }
                    if ($flag == 1) {
                        $refund['order_num'] = $v['customOrderId'];
                        $refund['refund'] = 1;
                        $refund['content'] = $v['roReason'] . ",平台申请时间：(" . date("Y-m-d H:i:s", mb_substr($v['roApplyDate'], 0, 10)) . ")";
                        $refund['urgent'] = 1;
                        $refund['allprice'] = $v['roApplyFee'];
                        $refund['recycle_type'] = 0;
                        $refund['roPreNo'] = $v['roPreNo'];
                        $sys_num = OrderService::getOrderBy('order_num', $v['customOrderId'], ['sys_num']);
                        if ($sys_num) {
                            $refund['sys_num'] = $sys_num;
                            $msg = OrderService::getOrderMsg($sys_num);
                            if ($msg['orderMsgArr']) {
                                $msg = $msg['orderMsgArr'];
                                $goodsArr = [];
                                foreach ($msg as $ka => $va) {
                                    $goodsArr[$ka]['goods_name'] = $va['goods_name'];
                                    $goodsArr[$ka]['goods_price'] = $va['goods_price'];
                                    $goodsArr[$ka]['msg_id'] = $va['id'];
                                    $goodsArr[$ka]['goods_num'] = $va['goods_num'];
                                    $goodsArr[$ka]['goods_id'] = $va['goods_id'];
                                }
                                $refund['goodsArr'] = $goodsArr;
                                $refund['goods_state'] = 2;
                                $refund['info_ing'] = '';
                                $refund['info_acc'] = '';
                                $refund['info_name'] = '';
                                $session['id'] = '1133';
                                $session['admin_acc'] = '系统操作';
                                $session['admin_groupnew'] = 7;
                                $rea = OrderService::lockOrder($refund, $session, '39.105.188.64');
                            } else {
                                $rea = '无订单商品';
                            }

                        } else {
                            $rea = '无订单号';
                        }
                    }
                }else{
                    $rea = '平台已处理'.$v['approvalState'];
                }
                $return[$k]['lockOrder'] = $rea;
                $return[$k]['order_num'] = $v['customOrderId'];
            }
            return $this->error('操作成功', ErrorInc::DATA_EMPTY,$return);exit;
        }else{
            return $this->error('操作成功', ErrorInc::DATA_EMPTY);exit;
        }
    }
}
