<?php

namespace App\Http\Requests\Validators\Api\MobileWeb;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class LoginValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return false;
    }

    // 登录验证器
    public function loginValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'account.required' => '请输入账号',
            'account.max' => '参数错误',
            'password.required' => '请输入密码',
            'password.max' => '参数错误',
            'login_type.required' => '请传入类型',
            'login_type.in' => '参数错误',
            'user_type.required' => '请传入类型',
            'user_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'account' => 'required|string|max:50',
            'password' => 'required|string|max:50',
            'login_type' => [//类型1强制登录2不登录
                'required',
                Rule::in(['1', '2']),
            ],'user_type' => [//登录类型1技师2服务商
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
