<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\StatementsListValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\StatementsListService;
use App\Services\DealPicService;

// 移动端-账单
class StatementsListController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataValidator = new StatementsListValidator();
    }

    /**
     * 售后列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function index(Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }

        $return_data = StatementsListService::index($request->all(), $this->show_count,1);
        return response()->json($return_data);
    }

    /**
     * 售后立即处理
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-12
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function businessFirm(Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->businessFirmValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $data = $request->all();
        $data['ip'] = $request->ip();
        $return_data = StatementsListService::businessFirm($data);
        return response()->json($return_data);
    }

    /**
     * 详情
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-13
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function info (Request $request) {
        // 验证数据
        $error_message = $this->dataValidator->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'Data'=>[$error_message]]);
        }
        $data = $request->all();
        $data['ip'] = $request->ip();
        $return_data = StatementsListService::info($data);
        return response()->json($return_data);
    }
}
