<?php

/*
|--------------------------------------------------------------------------
| 服务商补贴管理 (原来的 “活动系统/平台活动支持” ，服务商提供优惠活动，相当于给我们优惠)
|--------------------------------------------------------------------------
 *
 * @author lixiaolin
 * @Date: 2021/08/01
 * @Time: 下午18:10
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Service\Service;
use App\Models\PjGoods;
use App\Models\Supportacti;
use App\Models\GhPrice;
use App\Models\Admin;
use Illuminate\Support\Facades\Log;

class ActivityService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new Supportacti();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $Db = Supportacti::where("sup_id", '>', 0);
        if ($param["brand_name"]) {
            $Db = $Db->where('sup_brname', $param['brand_name']);
        }
        if ($param["sup_cadid"]) {
            $Db = $Db->where('sup_cadid', $param['sup_cadid']);
        }
        $count = $Db->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $Db->select('sup_id', 'sup_brname', 'sup_price', 'sup_startime', 'sup_endtime', 'sup_creacer', 'sup_num','sup_cadid')
                ->offset($offset)
                ->limit($pageSize)
                ->orderBy('sup_id', 'desc')
                ->get();
        } else {
            $list = $Db->select('sup_id', 'sup_brname', 'sup_price', 'sup_startime', 'sup_endtime', 'sup_creacer', 'sup_num','sup_cadid')
                ->orderBy('sup_id', 'desc')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;

        return $result;
    }

    public function formatPageContent($token, $priID, $data)
    {
        $list = $data['list'];
        $all_button = BmmcService::wherebutton($token, $priID);
        $addPt = BmmcService::getTopButton('addSupport', '', $all_button);
        $data['button_top'] = $addPt['button_top'] ?? [];//顶部按钮
        $data['button_search'] = $addPt['button_search'] ?? [];//搜索栏按钮
        $cdList = CategoryService::getall([],'cd_id');
        $res = [];
        if (!$list->isEmpty()) {
            $list = $list->toArray();
            foreach ($list as $key => $val) {
                $now_time = time();
                $start_time = strtotime($val['sup_startime']);//开始时间
                $end_time = strtotime($val['sup_endtime']); //结束时间
                $buttonData = [];
                $buttonData[] = 'lookSupport';
                if ($start_time > $now_time) {
                    $buttonData[] = 'editSupport,delSupport';
                    //未开始
                    $list[$key]['type'] = 1;
                    $list[$key]['typename'] = '未开始';
                } elseif ($end_time < $now_time) {
                    //已结束
                    $list[$key]['type'] = 3;
                    $list[$key]['typename'] = '已结束';
                } else {
                    $buttonData[] = 'AdvanceEnd';

                    //进行中
                    $list[$key]['type'] = 2;
                    $list[$key]['typename'] = '进行中';
                }
                $list[$key]['categoryname'] = $cdList[$val['sup_cadid']]['cd_pname'];
                $button = BmmcService::getListButton($buttonData, $all_button);//提前结束
                $list[$key]['button_one'] = $button['button_one'] ?? [];
                $list[$key]['button_two'] = $button['button_two'] ?? [];
                $list[$key]['button_three'] = $button['button_three'] ?? [];
            }

            $data['list'] = $list;
        }

        return $data;
    }


    /**
     * 检查系统是不是已经存在这个价格设置
     *
     * @param $acID
     * @return mixed
     */
    public static function getActivity($acID)
    {
        $entity = Supportacti::find($acID);

        if ($entity) {
            return $entity;
        }

        return false;
    }
    /**|---------------------------------------------------------------------------------
     * @name 根据单条件获取活动支持数据
     * @param  $key
     * @param  $value
     * @param  $select
     * @param   string $type
     * @retrun /multitype:array
     * @author dou 2021/10/12 19:57
     * |---------------------------------------------------------------------------------
    */
    public static function getSupportByKey ($key, $value, $select = [] , $type = 'get'){
        $db = new Supportacti();
        if(in_array($key, ['sup_id'])) {
            $type = 'first';
        }
        if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
        $list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
        return $list;
    }

    /**|---------------------------------------------------------------------------------
     * @name 根据多条件获取活动支持数据
     * @param array $params 查询条件
     * @param array $select 查询字段
     * @param array $type 查询类型
     * @retrun  /multitype:array
     * @author dou 2021/10/12 21:05
     * |---------------------------------------------------------------------------------
    */
    public static function getSupport ( $params , $select = [] , $type = 'get'){
        $db = new Supportacti();
        return CommonService::getMysqlData($db, $params,$select,[],$type);
    }
    //貌似没用
    public static function getSupportActivity(int $supportID, int $goodsID = 0) {
        $where = [];
        $time = time();
        $where[] = ['sup_endtime', '>', $time];
        $where[] = ['sup_startime', '<', $time];
        $where[] = ['sup_serid', '=', $supportID];
        if ($goodsID > 0) {
            $where[] = ['sup_goodids' , '=' , $goodsID];
        }

        $activities = Supportacti::where($where)->get()->toArray();

        return $activities;
    }

    //貌似没用
    public static function getGoodsActivity($goodsID) {
        $where = [];
        $time = time();
        $where[] = ['sup_endtime', '>', $time];
        $where[] = ['sup_startime', '<', $time];
        if ($goodsID > 0) {
            $where[] = ['sup_goodids' , '=' , $goodsID];
        }

        $activities = Supportacti::where($where)->get()->toArray();

        return $activities;
    }
}
