<?php

namespace App\Services;
use BlueCity\Core\Service\Service;
use DB;

class ExcelListService extends Service
{


    /**
     * @name 获取列表
     * @param $input
     * @param $session
     * @return array
     * @author du
     * @date 2021/8/25
     */
    public static function getList($input,$session){
    	$where = [];
        $Db = DB::table('excel_list');

        if($session['admin_groupnew']!=7){
            $where['el_adminid'] = $session['id'];
            $where['company_id'] = $session['company_id'];
        }
        if (isset($input['el_adminid'])){//操作人
            $where['el_adminid'] = $input['el_adminid'];
        }
        if (isset($input['el_action'])){//导出模块
            $where['el_dataname_rlike'] = $input['el_action'];
        }
        if (isset($input['datatime'])){//导出模块
            $creatData = $input['datatime'];
            $time_arr[0] = $creatData[0];
            $time_arr[1] = $creatData[1].' 23:59:59';
            $where['el_creactime_between'] = $time_arr;
        }
    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;
    	//DB::connection()->enableQueryLog();#开启执行日志
        if($where !='') {
            $paginate = $Db->whereRaw($where)->select('el_path','el_id','el_dataname','el_adminname','el_creactime','el_state','el_item','el_next')->orderBy('el_id','desc')->paginate($page_size);
        }else{
            $paginate = $Db->select('el_path','el_id','el_dataname','el_adminname','el_creactime','el_state','el_item','el_next')->orderBy('el_id','desc')->paginate($page_size);
        }
    	//print_r(DB::getQueryLog());
    	$all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
    	$export = BmmcService::getTopButton('excelAdd','',$all_button);
    	$data['button_top'] = $export['button_top']??[];//顶部按钮
    	$data['button_search'] = $export['button_search']??[];//搜索栏按钮
    	$list = CommonService::dataToArray($paginate->items());
    	if($list){
    	    foreach ($list as $k =>$v){
                $reduce_path = $v['el_path'].'.zip';
                $isexist = file_exists($reduce_path);
                if(!$isexist&&$v['el_state']!=1){
                    $list[$k]['el_state'] = 4;
                }
            }

    		$data['list'] = $list;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=> $paginate->currentPage(),
    				'page_size' => $page_size,
    				'allPage' => $paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }




}
