<?php
/*
|--------------------------------------------------------------------------
| 电话沟通 (原来的 “订单系统/电话沟通” ，电话回访等管理)
|--------------------------------------------------------------------------
|
|  @author liXiaoLin
|  @Date: 2021/8/13
|  @Time: 10:03
|  @Email: lixiaolin@bluearp.com
|  @version 1.0
|  @copyright BlueCity
*/

namespace App\Http\Controllers\Orders;

use App\Http\Controllers\BaseController;
use App\Services\AftercustService;
use App\Services\CommonService;
use App\Services\DownloadService;
use App\Services\RefundService;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Http\Request;
use App\Models\Aftercust;
use App\Models\Orders;
use App\Models\Refund;
use DB;
use Maatwebsite\Excel\Facades\Excel;
use League\Flysystem\Exception;

/**
 * @name 电话沟通
 * Class AftercustController
 * @package App\Http\Controllers\Admin
 */
class AfterCustController extends BaseController
{
    public $dataService = null;  // CurdControllerMethod 必备参数

    public function __construct()
    {
        $service = new AftercustService();
        $this->bootWithService($service);
    }

    /**
     * @api {get} /api/orders/aftercust/Deals 列表页
     * @apiGroup 电话沟通
     * @apiName 列表页
     * @apiVersion 1.0.0
     *
     * @apiDescription 列表页
     *
     * @apiParam afs_state  电话沟通状态
     * @apiParam shr_name   客户姓名
     * @apiParam afs_order  平台单号
     * @apiParam start_time 开始时间
     * @apiParam end_time   结束时间
     * @apiParam page       页码
     * @apiParam page_size  每页条数
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {
    "Data": {
    "page": {
    "totalPage": 1957,
    "count": 19563,
    "page": 0,
    "page_size": 10
    },
    "list": [
    {
    "afc_id": 19565,
    "afc_sys": "L20210812155120659",
    "afc_order": "L20210812155120659",
    "afc_serial": null,
    "afc_pid": 137,
    "afc_ordertime": "2021-08-12 15:52:22",
    "afc_gid": 761,
    "afc_price": "100.00",
    "afc_num": 1,
    "afc_user": 702784,
    "afc_serid": 0,
    "afc_creactime": "2021-08-12 15:55:55",
    "afc_creacter": "WQJ",
    "afc_dealtime": null,
    "afc_dealer": null,
    "afc_state": 1,
    "afc_creactid": 1475,
    "afc_dealid": null,
    "afc_centent": "测试",
    "afc_goodname": "AC德科-GW6666",
    "afc_code": null,
    "afc_orderstatus": 10,
    "afc_update": null,
    "afc_dealcenent": null,
    "afc_refund": 2,
    "duration": null,
    "afc_type": 1,
    "id": 19565,
    "admin_acc": null,
    "admin_password": null,
    "admin_group": null,
    "perso_nal": null,
    "admin_pic": null,
    "admin_name": null,
    "company_name": null,
    "ptid": null,
    "admin_pt_id": null,
    "type": null,
    "invoice": null,
    "deduct": null,
    "mouth_pay": null,
    "unified": null,
    "all_show": null,
    "reward": null,
    "is_sord": null,
    "enable": null,
    "ad_urgent": null,
    "ad_brand": null,
    "ad_project": null,
    "ad_paper": null,
    "children_id": null,
    "is_lidao": null,
    "owner": null,
    "attribute": null,
    "ad_alias": null,
    "agent_brand": null,
    "admin_groupnew": null,
    "token": null,
    "phone_type": null,
    "sord": "B",
    "pt_name": "本地测试",
    "pt_zt": 1,
    "pt_other": null,
    "model_id": 0,
    "three_pd": 0,
    "code": null,
    "p_oname": null,
    "p_paytype": 1,
    "bus_type": 1,
    "is_bx": 1,
    "skb_xm": "13810601569",
    "shr_name": "王二",
    "shr_phone": "13810601569",
    "shr_sheng": "北京",
    "shr_shi": "北京市",
    "shr_xian": "海淀区",
    "shr_adress": "测试小区",
    "shr_stype": 0,
    "shr_youbian": null,
    "car_make": null,
    "car_line": null,
    "car_model": null,
    "car_id": 0,
    "user_email": null,
    "sys_num": "L20210812155120659",
    "shr_other": null,
    "create_time": "2021-08-12 15:52:22",
    "shr_type": 1,
    "car_plate": null,
    "car_vin": null,
    "button_one": [],
    "button_two": [],
    "button_three": [],
    "type_name": null,
    "afc_state_name": null,
    "status": null,
    "reminder_num": 0
    }],
    "showMenu": [
    {
    "show_name": "未处理",
    "show_num": 10
    },
    {
    "show_name": "需跟进",
    "show_num": 5
    },
    {
    "show_name": "待审核",
    "show_num": 22
    },
    {
    "show_name": "已完成",
    "show_num": "--"
    }
    ],
    "button_top": [],
    "button_search": [],
    "button_export": []
    },
    "ErrorCode": 1,
    "ErrorMessage": "获取成功"
    }
     *
     *
     */
    public function index(Request $request)
    {
        $token = $request->input('token');
        $priID = $request->get('Pri_id');
        $page_size = (int)$request->input('page_size', 10);
        $page = intval($request->input('page'));
        //检索条件
        $where = $this->parseCondition($request);
        //获取数据
        $data = $this->dataService->search($where, ['*'], $page, $page_size);
        //获取统计
        $showMenu = AftercustService::searchNum($where);
        $data['showMenu'] = $showMenu;
        //获取页面button等信息

        $data = $this->dataService->formatPageContent($token, $priID, $data,$request->input('Login_id'));

        if (!empty($data['list'])) {
            return $this->success('获取成功', $data);
        } else {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$data);
        }
    }

    private function parseCondition($request) {
        $where = [];
        if ($request->filled('afc_state')) {
            $where[] = ['afc_state' , '=', $request->input('afc_state')];
        }
        if ($request->filled('shr_name')) {//客户姓名
            $where[] = ['shr_name' , 'like', '%' . $request->input('shr_name') . '%'];
        }
        if ($request->filled('shr_phone')) {//客户电话
            $where[] = ['shr_phone', 'like', '%' . $request->input('shr_phone') . '%'];
        }
        if ($request->filled('afc_order')) {//平台单号
            $where[] = ['afc_order' ,  'like', '%' . $request->input('afc_order') . '%'];
        }
        if ($request->filled('status')) {//订单状态
            $where[] = ['afc_orderstatus' , '=', $request->input('status')];
        }
        if ($request->filled('afc_type')) {//沟通类型
            $where[] = ['afc_refund' , '=', $request->input('afc_type')];
        }
        //搜索处理人ID
        if ($request->filled('afc_dealid')) {//沟通类型
            $where[] = ['afc_dealid' , '=', $request->input('afc_dealid')];
        }
        if ($request->filled('ordertime')) {//开始时间
            $timearr = $request->input('ordertime');
            $time_arr[0] = date("Y-m-d 00:00:00",strtotime($timearr[0]));
            $time_arr[1] = date("Y-m-d 23:59:59",strtotime($timearr[1]));
            $where[] = ['afc_creactime' ,'>=',$time_arr[0]];
            $where[] = ['afc_creactime' ,'<=', $time_arr[1]];
            //$where[] = ['afc_creactime' , 'between', $request->input('ordertime')];
        }
        $sessionToken = $request->get('session_token');
        if ($sessionToken['admin_groupnew'] == 96) {
            $where[] = ['afc_ordertime' , '>', '2020-01-01'];
        }
        return $where;
    }

    /**
     * @api {post} /api/orders/aftercust/downloadFields 下载选项
     * @apiGroup 电话沟通
     * @apiName 下载选项
     * @apiVersion 1.0.0
     *
     * @apiDescription 下载选项
     *
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     *  {
    "Data": {
    "afc_id": "【编号】",
    "afc_sys": "【系统单号】",
    "afc_order": "【平台单号】",
    "afc_serial": "【派工单号】",
    "pt_name": "【平台名称】",
    "afc_ordertime": "【订单创建时间】",
    "afc_goodname": "【商品名称】",
    "afc_price": "【商品单价】",
    "afc_num": "【商品数量】",
    "afc_creacter": "【创建人】",
    "afc_creactime": "【创建时间】",
    "invoice": "【发票类型】",
    "kd_no": "【快递单号】",
    "shr_name": "【客户姓名】",
    "shr_phone": "【客户电话】",
    "shr_adree": "【客户地址】"
    },
    "ErrorCode": 1,
    "ErrorMessage": "获取成功"
    }
     *
     *
     */
    public function downloadFields() {
        $fields = AftercustService::exportCollection();

        return $this->success('获取成功', $fields);
    }
    /**
     * @api {post} /api/orders/aftercust/export 下载提示
     * @apiGroup 电话沟通
     * @apiName 下载提示
     * @apiVersion 1.0.0
     *
     * @apiDescription 下载提示
     *
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     *  {
        "Data": {
        "file_id": 1220},
        "ErrorCode": 1,
        "ErrorMessage": "文件下载生成成功"
        }
     *
     *
     */
    public function export(Request $request)
    {
        $pageSize = (int)$request->input('page_size', 10);
        $page = intval($request->filled('page'));

        $fields = $request->get('export_fields')?? [];
        $where = $this->parseCondition($request);
        //执行导出
        $fileName = '客户沟通内容列表导出' . date('Ymdhis');
        $fileExt = '.xlsx';

        $data = $this->dataService->search($where, ['*'], $page, $pageSize);
        if ($data['list']->isEmpty()) {
            return $this->error('数据为空无法导出到文件', ErrorInc::DATA_EMPTY);
        }
        $filePath = $this->dataService->export($data['list'], $fields, $fileName, $fileExt);

        if (!$filePath) {
            return $this->error('文件存储失败', ErrorInc::MYSQL_FAILED);
        }

        $fileData = [];
        $fileData['file_name'] = $fileName;
        $fileData['file_type'] = 'serviceprovider-export';
        $fileData['file_path'] = $filePath;
        $fileData['file_ext'] = $fileExt;
        $fileData['comments'] = json_encode($request->all());

        $downLoad = (new DownloadService())->create($fileData);
        if ($downLoad) {
            $downLoadID = $downLoad->id;

            return $this->success('文件下载生成成功', ['file_id' => $downLoadID]);
        } else {
            return $this->error('文件存储失败', ErrorInc::MYSQL_FAILED);
        }
    }

    /**
     * @api {post} /api/orders/aftercust/Deals 处理订单
     * @apiGroup 电话沟通
     * @apiName 处理订单
     * @apiVersion 1.0.0
     *
     * @apiDescription 处理订单
     *
     * @apiParam afs_id    数据id
     * @apiParam deal_type 1：未处理；2：需跟进；3：待审核
     * @apiParam afc_sys   系统单号
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":[]}
     *
     */
    public function Deals(Request $request)
    {
        $input = $request->all();
        $checkKey=CommonService::checkKey(['afc_id', 'deal_type','afc_sys'],$input,array('afc_id'=>'数据编号','deal_type'=>'处理类型','afc_sys'=>'系统单号'));
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $afc_id = $input['afc_id'];
        $deal_type = $input['deal_type'];
        $afc_state = $this->dataService->find($afc_id);
        if ($deal_type <= $afc_state['afc_state']) {
            return $this->error('状态错误', ErrorInc::INVALID_PARAM);
        } else {
            $poss['afc_state'] = $deal_type;
            $session = $request->get('session_token');
            $poss['afc_dealer'] = $session['admin_acc'];
            $poss['afc_dealid'] = $session['id'];
            $poss['afc_dealtime'] = date("Y-m-d H:i:s");
            $update_time = time();
            $time = $update_time - strtotime($afc_state['afc_creactime']);
            $poss['duration'] = $time;
            if ($deal_type == 3) {
                $poss['afc_dealcenent'] = $input['afc_content']??'';//处理备注
            }
            $res = $this->dataService->update($poss, $afc_id);
            if ($res) {
                $stateNma = AftercustService::getStateName(true);
                $type = $stateNma[$deal_type]??'未定义';
                $type .="(".$deal_type.")";
                $this->insertingLog("处理订单，", $request->input('afs_sys'), "订单；(" . $afc_state['afc_code'] . ")" . $type, "电话沟通", $request->ip(), $session['admin_acc']);//日志
                if ($request->input('afc_content')) {
                    $rest = CommonService::accMe($request->input('afc_sys'), '电话沟通', $request->input('afc_content'), '', 1, $session['admin_groupnew'], $session['admin_acc'], $session['id']);

                    if (!$rest) {
                        return $this->error('备注添加失败', ErrorInc::MYSQL_FAILED);
                    }
                }
                return $this->success('更新成功');
            } else {
                return $this->error('失败', ErrorInc::MYSQL_FAILED);
            }
        }
    }


    /**
     * @api {post} /api/orders/aftercust/Audits 订单审核
     * @apiGroup 电话沟通
     * @apiName 订单审核
     * @apiVersion 1.0.0
     *
     * @apiDescription 订单审核
     *
     * @apiParam afc_id id号
     * @apiParam audits_type 审核状态
     * @apiParam afc_content 备注内容
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":[]}
     *
     */
    public function Audits(Request $request)
    {
        $input = $request->all();
        $checkKey=CommonService::checkKey(['afc_id', 'audits_type'],$input,array('afc_id'=>'数据编号','audits_type'=>'审核状态'));
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $afterCust = $this->dataService->find($request->input('afc_id'));
        if(!$afterCust){
            return $this->error('数据不存在', ErrorInc::DATA_EMPTY);
        }
        if ($afterCust['afc_state'] > 1 && $afterCust['afc_state']<4) {
            $afc_states = $afterCust;
        } else {
            $afc_states = false;
        }
        $session = $request->get('session_token');
        if (!$afc_states) {
            return $this->error('状态错误', ErrorInc::DATA_EMPTY);
        } else {
            $afc_state = $afc_states['afc_state'];
            if (!$request->filled('afc_content') && $afc_state != 3) {
                return $this->error('备注内容不能为空', ErrorInc::INVALID_PARAM);
            }
            switch ($request->input('audits_type')) {
                case 1:
                    $type = '驳回至';
                    $afc_state = $afc_state - 1;
                    break;
                case 2:
                    $type = '确认至';
                    $afc_state = $afc_state + 1;
                    break;
            }
            $stateNma = AftercustService::getStateName(true);
            $type .= $stateNma[$afc_state]??'未定义';
            $type .="(".$afc_state.")";
            $poss['afc_state'] = $afc_state;
            $res = $this->dataService->update($poss, $request->input('afc_id'));

            if ($res) {
                if ($request->filled('afc_content')) {
                    $rest = CommonService::accMe($afterCust['afc_sys'], '电话沟通', $request->input('afc_content'), '', 1, $session['admin_groupnew'], $session['admin_acc'], $session['id']);
                }
                $this->insertingLog("审核订单，", $afterCust['afc_sys'], "订单；(" . $afc_states['afc_code'] . ")" . $type, "电话沟通", $request->ip(), $session['admin_acc']);//日志
                return $this->success('操作成功');
            } else {
                return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
            }
        }
    }


    /**
     * @api {post} /api/orders/aftercust/updatedata 更新状态
     * @apiGroup 电话沟通
     * @apiName 更新状态
     * @apiVersion 1.0.0
     *
     * @apiDescription 更新状态
     *
     * @apiParam type 1：暂停
     * @apiParam time 时间
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":[]}
     *
     */
    public function updatedata(Request $request)
    {
        if ($request->input('type') == '1') {
            $data['ErrorCode'] = 1;
            $data['ErrorMessage'] = '操作成功';
            $list = date("Y-m-d H:i:s");
        } else {
            $time = str_replace('/', '-', $request->input('time'));
            //return $time;exit;
            if ($request->filled('afc_max')) {
                $afsArr = Aftercust::whereIn('afc_state', [1, 2, 3])->where('afc_update', '<', $time)->where('afc_id', '>', $request->input('afc_max'))->select('afc_id', 'afc_order')->orderBy('afc_id', 'ASC')->limit("10")->get();
            } else {
                $afsArr = Aftercust::whereIn('afc_state', [1, 2, 3])->where('afc_update', '<', $time)->select('afc_id', 'afc_order')->orderBy('afc_id', 'ASC')->limit("10")->get();
            }


            if (!$afsArr->isEmpty()) {
                $list = $afsArr->toArray();

                foreach ($list as $k => $v) {
                    $afc_order[] = $v['afc_order'];
                    $afc_max[] = $v['afc_id'];
                }

                $order_state = Orders::whereIn('order_num', $afc_order)->select('order_num', 'ser_id', 'order_status')->get();

                if (!$order_state->isEmpty()) {
                    $order_state = $order_state->toArray();
                    foreach ($order_state as $ks => $vs) {
                        $ordered[$vs['order_num']] = $vs;
                    }
                    foreach ($list as $k => $v) {
                        if (isset($ordered[$v['afc_order']])) {
                            $poss['afc_orderstatus'] = $ordered[$v['afc_order']]['order_status'];
                            $poss['afc_serid'] = $ordered[$v['afc_order']]['ser_id'];
                            $poss['afc_update'] = date("Y-m-d H:i:s");
                            Aftercust::where('afc_id', $v['afc_id'])->update($poss);
                        }
                    }
                    $data['afc_max'] = max($afc_max) ?? "";
                    $data['ErrorCode'] = 1;
                    $data['ErrorMessage'] = '操作成功';
                    $list = $afsArr->count();
                }


            } else {
                $data['afc_max'] = "";
                $data['ErrorCode'] = 2;
                $data['ErrorMessage'] = '操作完成';
            }
        }

        $data['data'] = $list ?? 0;

        return response()->json($data);
    }


    /**
     * @api {post} /api/orders/aftercust/refundprocc 单据处理
     * @apiGroup 单据处理
     * @apiName 退款处理
     * @apiVersion 1.0.0
     *
     * @apiDescription 单据处理
     *
     * @apiParam id 数据id
     * @apiParam afc_order 平台单号
     * @apiParam content 备注内容
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":[]}
     *
     */
    public function refundprocc(Request $request)
    {
        $input = $request->all();
        $checkKey=CommonService::checkKey(['afc_id', 'content'],$input,array('afc_id'=>'数据编号','content'=>'备注'));
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        try {
            $input = $request->only('afc_id', 'afc_order', 'content');
            $session = $request->get('session_token');
            $after_info = $this->dataService->find($input['afc_id']);
            if ($after_info) {
                Db::beginTransaction();
                $afcInfo = Aftercust::where('afc_id', $input['afc_id'])->update([
                    'afc_state' => 4,
                    'afc_dealer' => $session['admin_acc'],
                    'afc_dealid' => $session['id'],
                    'afc_dealtime' => date("Y-m-d H:i:s"),
                    'afc_dealcenent' => $input['content']
                ]);
                $rest = CommonService::accMe($after_info['afc_sys'], '电话沟通', $input['content'], '', 1, $session['admin_groupnew'], $session['admin_acc'], $session['id']);

                if ($afcInfo && $rest) {
                    $typeName = AftercustService::getTypeName(true);
                    $afc_refund = $typeName[$after_info['afc_refund']]??'未定义';
                    $afc_refund .="(".$after_info['afc_refund'].")";
                    if ($after_info['afc_refund'] == '2') {
                        $res = Refund::where('order_num', $after_info['afc_order'])->where('state', '2')->first();
                        if ($res) {
                            $refInfo = Refund::where('order_num', $after_info['afc_order'])->where('state', '2')->update(['state' => 3, 'updated_at' => date("Y-m-d H:i:s")]);
                            if (!$refInfo) {
                                DB::rollback();

                                return $this->error('操作失败', ErrorInc::MYSQL_TRANSACTION_FAILED);
                            }
                        }
                    } else if ($after_info['afc_refund'] == '3') {
                        DB::table("ser_infor")->where("sin_ordernum", $after_info['afc_order'])->update(['sin_state' => 3]);
                    }
                        $this->insertingLog('处理,', $after_info['afc_sys'], "订单：" . $after_info['afc_code'].$afc_refund, "电话沟通", $request->ip(), $session['admin_acc']);
                    DB::commit();
                    return $this->success('操作成功');
                } else {
                    return $this->error('操作失败[AC]', ErrorInc::MYSQL_FAILED);
                }
            } else {
                return $this->error('操作失败[RF]', ErrorInc::MYSQL_FAILED);
            }

        } catch (\Exception $e) {
            return $this->error($e->getMessage(), ErrorInc::SERVER_FAILED);
        }
    }

    /**
     * @api {post} /api/orders/aftercust/updatecl 更新处理
     * @apiGroup 电话沟通
     * @apiName 更新处理
     * @apiVersion 1.0.0
     *
     * @apiDescription 更新处理
     *
     * @apiParam sys_num 系统单号
     *
     * @apiSuccess {Number} ErrorCode    状态码，1：请求成功
     * @apiSuccess {String} ErrorMessage   提示信息
     * @apiSuccess {Object} Data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"ErrorCode":1,"ErrorMessage":"","Data":[]}
     *
     */
    public function updatecl(Request $request)
    {
        $input = $request->all();
        $checkKey=CommonService::checkKey(['afc_id', 'note'],$input,array('afc_id'=>'数据编号','note'=>'更新备注'));
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }
        $afterCust = $this->dataService->find($request->input('afc_id'));
        if(!$afterCust){
            return $this->error('数据不存在', ErrorInc::DATA_EMPTY);
        }
        $update['afc_state'] = 3;
        $update['afc_dealcenent'] = $request->input('note');

        $after_info = AftercustService::updateByKey('afc_id', $request->input('afc_id'), $update);
        if ($after_info) {
            $session = $request->get('session_token');
            CommonService::accMe($afterCust['afc_sys'], "电话沟通", "更新处理 原因：" . $request->input('note'), '', '', $request->get('session_token')['admin_groupnew'], $request->get('session_token')['admin_acc'], $request->get('session_token')['id']);
            $this->insertingLog("电话沟通", $afterCust['afc_sys'], "订单：(" . $request->filled('afc_code').")", "更新处理", $request->ip(), $session['admin_acc']);

            return $this->success('操作成功');
        } else {
            return $this->error('操作失败', ErrorInc::MYSQL_FAILED);
        }
    }

}
