<?php

namespace App\Http\Controllers\Api\MobileWeb;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Validators\Api\MobileWeb\TechnicianValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\Api\MobileWeb\TechnicianService;

// 移动端-技师管理
class TechnicianController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    public function __construct()
    {
        $this->dataValidator = new TechnicianValidator();
    }

    // 列表
    public function index(Request $request)
    {
        $return_data = TechnicianService::index($request->all(), $this->show_count);
        return $return_data;
    }


    // 技师新增
    public function add(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->addValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[$error_message]]);
        }

        $return_data = TechnicianService::add($request->all(),$request->ip());
        return response()->json($return_data);
    }

    // 技师编辑
    public function edit(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->editShowValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[$error_message]]);
        }
        if ($request['type'] == 1) {
            $return_data = TechnicianService::editShow($request);
            return response()->json($return_data);
        }

        // 编辑提交验证数据
        $error_message = $this->dataValidator->addValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[$error_message]]);
        }
        $return_data = TechnicianService::edit($request->all(),$request->ip());
        return response()->json($return_data);
    }

    // 修改密码
    public function changePassword(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->changePasswordValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[$error_message]]);
        }

        $return_data = TechnicianService::changePassword($request->all());
        return response()->json($return_data);
    }

    // 删除
    public function delete(Request $request)
    {
        // 验证数据
        $error_message = $this->dataValidator->deleteValidator($request->all());
        if ($error_message) {
            return response()->json(['ErrorCode'=>ErrorInc::INVALID_PARAM, 'ErrorMessage'=>$error_message->first(), 'data'=>[$error_message]]);
        }

        $return_data = TechnicianService::delete($request->all(),$request->ip());
        return response()->json($return_data);
    }
}
