<?php
/**
 * 合约服务
 *
 * @author lixiaolin
 * @Date: 2021/4/2
 * @Time: 下午13:50
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\Contracts;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class ContractsService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new Contracts();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public function create(array $input)
    {
        $userArr['skb_xm'] = $input['shr_phone'];
        $userArr['shr_name'] =$this->restrict($input['shr_name']);
        $userArr['shr_phone'] = $input['shr_phone'];
        $userArr['create_time'] = date('Y-m-d H:i:s');
        $customer_id = Contracts::insertGetId($userArr);

        return $customer_id;
    }

    public function search($param, $columns = array('*'), $perPage = 20)
    {
        return $this->modelMain
            ->select($columns)
            ->where($param)
            ->get();
    }

    /**
     * @param int $id
     *
     * @return mixed
     */
    public function setEnabled(int $id){
        return $this->modelMain->where('id', $id)
            ->update(['enabled'=>1]);
    }

    /**
     * @param int $id
     *
     * @return mixed
     */
    public function setDisabled(int $id){
        return $this->modelMain->where('id', $id)
            ->update(['enabled'=>0]);
    }
}
