<?php

namespace App\Http\Controllers\DataSyn;
use App\Http\Controllers\BaseController;
use App\Models\JdBound;
use App\Models\PjGoods;
use App\Services\CommonService;
use App\Services\JdBoundService;
use App\Services\PlatformService;
use Illuminate\Http\Request;
use BlueCity\Core\Inc\ErrorInc;

class JdBoundController extends BaseController
{

	/**
	 * @name  列表页
     * @param sku_id     sku
     * @param jd_goodn   平台名称
     * @param brand_name 商品品牌
     * @param version    商品型号
	 * @param  $request
	 * @author du 2021年8月20日下午17:28:06
	 */
	public function index(Request $request){
		$input = $request->all();
        $session = $request->get('session_token');
    	$list = JdBoundService::getList($input,$session);
    	if($list['list']){
	    	return $this->success('获取成功', $list); exit;
    	}else{
	    	return $this->error('暂无数据', ErrorInc::DATA_EMPTY,$list);exit;
    	}
	}

	/**|---------------------------------------------------------------------------------
	 * @name  添加
     * @param is_long  1:绑定  2:临时绑定
     * @param sku_id   商品sku
     * @param jd_goodn 平台商品sku名
     * @param goods_id 系统商品id
	 * @retrun \Illuminate\Http\JsonResponse /multitype:array
	 * @author du 2021/8/23 9:34
	 * |---------------------------------------------------------------------------------
	*/
	public function addBound(Request $request){
        if (!$request->filled('goods_id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
		//平台id
		$pt_id = intval($request->input('pt_id'));
		if (empty($pt_id)){
            return $this->error('请选择平台', ErrorInc::MYSQL_FAILED);exit;
		}
        $company_id = PlatformService::getPtBy('id', $pt_id, ['company_id'], 'first');
		$is_long = (int)$request->input('is_long',1);
		$goods_id = intval($request->input('goods_id'));
		if($request->filled('sku_id') && $request->filled('jd_goodn') && $request->filled('goods_id')){

			$sku_id = $request->input('sku_id');
			$jd_goodn = $request->input('jd_goodn');

            $old_sku = JdBoundService::getInfoBy('sku_id', $sku_id,['id']);
            if (!empty($old_sku)){
                return $this->error('该sku已绑定', ErrorInc::MYSQL_FAILED);exit;
            }
            $info = PjGoods::where(["pg_id"=>$goods_id])->select('brand_name','pg_series','version')->first();
            if ($info['pg_series'] != ""){
                $good_name = $info['brand_name'].'-'.$info['pg_series'].'-'.$info['version'];
            }else{
                $good_name = $info['brand_name'].'-'.$info['version'];
            }
			if($goods_id){
				if($is_long!=1){
					$bding = "临时绑定商品，";
				}else{
					$bding = "永久绑定商品，";
				}
				$res = JdBoundService::createjdBound($sku_id, $jd_goodn, $pt_id, $goods_id, $is_long, '', $good_name,$company_id);

				if($res){
					 $this->insertingLog($bding,'','商品sku：'.$sku_id,'京东商品绑定',$request->ip(), $request->get('session_token')['admin_acc']);//日志
                    return $this->success('绑定成功'); exit;
                }else{
                    return $this->error('绑定失败', ErrorInc::DATA_EMPTY);exit;
                }
			}else{
                return $this->error('未找到该系统商品', ErrorInc::DATA_EMPTY);exit;
			}
		}else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
		}
	}

    /**|---------------------------------------------------------------------------------
     * @name  编辑
     * @param id       数据id
     * @param is_long  1:绑定 2:临时绑定
     * @param sku_id   sku
     * @param goods_id 商品id
     * @param goods_name 商品名
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author du 2021/8/23 9:41
     * |---------------------------------------------------------------------------------
    */
	public function editBound(Request $request){

        $input = $request->only('id','goods_id','sku_id');
        $checkKey = CommonService::checkKey(['id','goods_id','sku_id'],$input);
        if($checkKey['code']!=1){
            return $this->error('参数'.$checkKey['data'].'未填写,或值为空', ErrorInc::INVALID_PARAM);exit;
        }

        $is_long = (int)$request->input('is_long',1);
		$id = (int)$request->input('id',0);
        $ext = JdBoundService::getInfoBy('id', $id,['id']);
        if(!$ext){
            return $this->error('无此数据', ErrorInc::FAILED_PARAM, []);exit;
        }
		$sku_id = (int)$request->input('sku_id',0);
		$goods_id = (int)$request->input('goods_id');
		if($goods_id>0 && $id > 0 && $sku_id > 0){
			$good_name = $request->input('goods_name');
			$good_id = PjGoods::where(["pg_id"=>$goods_id])->value('pg_id');
			if($good_id){
				$poss['goods_id'] = $good_id;
				$poss['goods_name'] = $good_name;
				$poss['is_long'] = $is_long;
				$res = JdBound::where("id",$id)->update($poss);
				if($res){
                    $this->insertingLog('编辑，','','商品sku：'.$sku_id,'京东商品绑定',$request->ip(), $request->get('session_token')['admin_acc']);//日志
                    return $this->success('编辑成功'); exit;
                }else{
                    return $this->error('编辑失败', ErrorInc::DATA_EMPTY);exit;
                }
			}else{
                return $this->error('未找到该系统商品', ErrorInc::DATA_EMPTY);exit;
            }
        }else{
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
	}

	/**|---------------------------------------------------------------------------------
	 *  @name  删除
     * @param id 数据id
	 * @retrun \Illuminate\Http\JsonResponse /multitype:array
	 * @author du 2021/8/23 9:52
	 * |---------------------------------------------------------------------------------
	*/
	public function deleteBound(Request $request){
        if (!$request->filled('id')){
            return $this->error('参数错误', ErrorInc::FAILED_PARAM, []);exit;
        }
		$id = (int)$request->input('id');
        $sku_id = JdBoundService::getInfoBy('id', $id,['sku_id']);
        if(!$sku_id){
            return $this->error('无此数据', ErrorInc::FAILED_PARAM, []);exit;
        }
		$res = JdBound::where(['id'=>$id])->delete();
		if($res){
            $this->insertingLog('删除，','','删除，sku：'.$sku_id,'京东商品绑定',$request->ip(), $request->get('session_token')['admin_acc']);//日志
            return $this->success('删除成功'); exit;
        }else{
            return $this->error('删除失败', ErrorInc::DATA_EMPTY);exit;
        }
	}
}
