<?php
/**
 * 类别服务
 * @author du 2021年7月23日上午9:40:36
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services;
use App\Models\ServiceMode;
use BlueCity\Core\Service\Service;
use App\Models\CategoryDetail;

use App\Services\RedisService;
use App\Services\CommonService;
class ServiceModeService extends Service{


    /**
     * 服务方式数据
     * @param array $ids
     * @param string $key
     * @return array|\Illuminate\Http\JsonResponse|mixed
     * @author du
     * @date 2021/12/3
     */
     public static function getall($ids = [],$key = '')
     {
         $data = [];
         if (!is_array($ids)) {
             return $data;
         }
         $list = RedisService::redisGet('smList');
         if ($list) {
             $data = CommonService::filterIds($ids, $list, 'sm_id');
         } else {
             $brandData = ServiceMode::where('sm_delflag', 1)->orderBy('sm_id', 'asc')->get()->toarray();
             $data = CommonService::filterIds($ids, $brandData, 'sm_id');
             RedisService::redisSet('smList', json_encode($brandData));
         }
         if ($key) {
             $data = CommonService::jointArrayKey($data, $key);
         }
         return $data;
     }


        /**
         * 根据ID获取品类名
         * @param $sm_id
         * @return mixed
         * @author du
         * @date 2021/12/3
         */
    public static function getNameBySmId($sm_id){
         $name = ServiceMode::where('sm_delflag',1)->where('sm_id',$sm_id)->value('sm_name');
         return $name;
    }


}
