<?php

namespace App\Services;
use App\Models\Admin;
use App\Models\ExcelPermiss as Excelpermiss;
use App\Models\User;
use BlueCity\Core\Service\Service;
use DB;

class ExcelpermissService extends Service
{
    /**
     * 获取详细内容
     * @param string $key 查询键
     * @param string $value 查询值
     * @param array $select 待查询参数
     * @param array $type 查询类型
     * @return array|mixed
     * @author du
     * @date 2021/8/25
     */
    public static function getInfoBy($key, $value, $select = [] , $type = 'get')
    {
    	$db = new ExcelPermiss();
    	if(in_array($key, ['adg_id'])) {
            $type = 'first';
        }
    	if($type == 'first') {
            if (count($select) == 1) {
                $type = 'value';
            }
        }
    	$list = CommonService::getMysqlData($db,[$key=>$value],$select,[],$type);
    	return $list;
    }

    /**
     * @name 获取列表
     * @param $input
     * @param $session
     * @return array
     * @author du
     * @date 2021/8/25
     */
    public static function getList($input,$session){
    	$where = [];
    	$Db = Excelpermiss::orderBy('adg_id','ASC');
        if (isset($input['action_name'])) {
            $where['adg_acname'] = $input['action_name'];
        }
        if (isset($input['admin_id'])) {
            $where['adg_admin'] = $input['admin_id'];
        }

        if ($session['admin_groupnew'] != 7) {//管理员可以看全部
            $where['company_id'] = $session['company_id'];
        }

    	$where = CommonService::jointWhere($where);
    	$page_size = $input['page_size']??10;
    	//DB::connection()->enableQueryLog();#开启执行日志
        if($where !='') {
            $paginate = $Db->whereRaw($where)->paginate($page_size);
        }else{
            $paginate = $Db->paginate($page_size);
        }
    	//print_r(DB::getQueryLog());
    	$all_button = BmmcService::whereButton($input['token'],$input['Pri_id']);
    	$export = BmmcService::getTopButton('excelAdd','',$all_button);
    	$data['button_top'] = $export['button_top']??[];//顶部按钮
    	$data['button_search'] = $export['button_search']??[];//搜索栏按钮
    	$list = CommonService::dataToArray($paginate->items());
    	if($list){
    		$list = ExcelpermissService::getButtonDatas($all_button, $list);
    		$data['list'] = $list;
    		$data['page'] = [
    				'count' => $paginate->total(),
    				'page'=> $paginate->currentPage(),
    				'page_size' => $page_size,
    				'allPage' => $paginate->lastPage()
    		];
    	}else{
    		$data['list'] = [];
    	}
    	return $data;
    }

    /**
     * @name 获取按钮和数据
     * @param $all_button
     * @param $list
     * @return array
     * @author du
     * @date 2021/8/25
     */
    public static function getButtonDatas($all_button,$list){

        $adminArr = Admin::where('admin_groupnew','!=',2)->pluck('admin_acc','id')->toArray();
    	foreach ($list as $k => $v){
            $buttonData = [];
            if ($v['adg_id'] >1) {
                $list[$k]['adg_data'] = json_decode($v['adg_data'],true);
            }
            if (isset($adminArr[$v['adg_admin']])) {
                $list[$k]['admin_acc'] = $adminArr[$v['adg_admin']];
            } else {
                $list[$k]['admin_acc'] = "测试";
            }
    		$buttonData[] = 'excelEdit,excelDel';
    		$button = BmmcService::getListButton($buttonData,$all_button);
    		$list[$k]['button_one'] = $button['button_one']??[];
    		$list[$k]['button_two'] = $button['button_two']??[];
    		$list[$k]['button_three'] = $button['button_three']??[];
    	}
    	return $list;
    }



}
