<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// });
Route::any('b1/DataAdjust/entrance', 'Api\BackEnd\DataAdjustController@entrance'); //调整数据
Route::any('b1/FestivalRemind/entrance', 'Api\BackEnd\FestivalRemindSendMessageController@entrance'); //发送节日短信
Route::any('b1/SendMessage/entrance', 'Api\BackEnd\SendMessageController@entrance'); //发送节日短信
Route::get('b1/ServiceProject/executeLead', 'Api\ProductManage\ServiceProjectController@executeLead'); //执行导入数据
Route::any('b1/WashOrder/executeLead', 'Mounting\Business\WashOrderController@executeLead'); //订单列表-执行导入数据
Route::get('b1/Common/versionCompare', 'Common\CommonController@versionCompare'); //获取版本信息
Route::any('Dou/MyTest/dataApi', 'Dou\MyTestController@dataApi'); //执行数据入口

Route::any('t1/cutParam', 'Api\CeshiController@cutParam'); //测试获取数据-国通
Route::any('t1/getCutParam', 'Api\CeshiController@getCutParam'); //测试获取数据-国通
Route::any('t1/addToLat', 'Api\CeshiController@addToLat'); //地址转经纬度
Route::any('t1/upload', 'Api\CeshiController@upload'); //测试上传文件
Route::any('t1/syncGoods', 'Api\CeshiController@syncGoods'); //锁定库存计算
Route::any('t1/syncCost', 'Api\CeshiController@syncCost'); //同步成本
Route::any('f1/Files/upload', 'Api\Files\FilesController@upload'); //上传文件
Route::any('f1/Files/basicUpload', 'Api\Files\FilesController@basicUpload'); //上传基础文件
Route::any('f1/Files/qrCode', 'Api\Files\FilesController@qrCode'); //生成二维码


Route::any('ClearDatas/delete', 'Api\ClearDatasController@delete'); //清空数据
Route::any('v1/ClearDatas/importExcelData', 'Api\ClearDatasController@importExcelData'); //导入Excel数据
Route::any('v1/ClearDatas/test', 'Api\ClearDatasController@test'); //测试

Route::post('v1/ocLogin', 'Api\LoginController@ocLogin'); //OC登录
Route::any('v1/text', 'Api\CeshiController@text'); //测试
Route::post('v1/login', 'Api\LoginController@login'); //登录
Route::post('v1/bindingPhone', 'Api\LoginController@bindingPhone'); //绑定手机号
Route::post('v1/saveValidation', 'Api\LoginController@saveValidation'); //保存设备标识
Route::post('v1/alterValidation', 'Api\LoginController@alterValidation'); //更改验证状态
Route::post('v1/inquireVerify', 'Api\LoginController@inquireVerify'); //车型查询验证
Route::post('v1/getCode', 'Api\LoginController@getCode'); //忘记密码--获取验证码
Route::post('v1/forgetPwd', 'Api\LoginController@forgetPwd'); //忘记密码--提交
Route::post("v3/BrandList/adds", "Api\ProductManage\BrandListController@adds"); //接口测试
Route::post('v1/SettleIn/synchronousData', 'SettleIn\SettleInController@synchronousData');//智配数据同步美装

/*************** 微信信息推送路由开始 **********/
Route::namespace('WeChat')->group(function () {
    //微信消息推送-添加权限
    Route::post('v3/WeChatPush/inforPush', 'WeChatPush\WeChatPushController@inforPush');
    //微信消息推送-提交微信绑定信息
    Route::post('v3/WeChatPush/weChatBinding', 'WeChatPush\WeChatPushController@weChatBinding');
    //微信消息推送-解除绑定
    Route::any('v3/WeChatPush/removeData', 'WeChatPush\WeChatPushController@removeData');

    // 个人会员微信公众号授权绑定
    Route::post('v1/WeChatMemberPush/weChatBinding', 'WeChatPush\WeChatMemberPushController@weChatBinding');
    // 个人会员微信公众号解除绑定
    Route::post('v1/WeChatMemberPush/removeData', 'WeChatPush\WeChatMemberPushController@removeData');
});
/*************** 微信信息推送路由结束 **********/


// 用友U8财务系统对接
Route::post('u8/YongYou/test', 'Api\YongYou\YongYouController@test'); //用友测试接口

//日常销量数据同步Dou
Route::post('v3/DataStatistical/sysData', 'Api\DataStatistical\DataStatisticalController@sysData');

/*************** 洗美贴装pc端路由结束 **********/


// 后台路由v1版-要逐步废弃
Route::namespace('Api')->prefix('v1')->group(function () {
    Route::post('/quit', 'LoginController@quit');
    Route::post('/Mobilequit', 'LoginController@quit');

    Route::group(['middleware' => ['islogin']], function () {
        Route::post('/leftList', 'LoginController@leftList'); //左侧列表
        Route::any('v1/explort', 'CeshiController@explort'); //导入
        Route::any('ClearDatas/addData', 'ClearDatasController@addData'); //添加到数据库

        // 移动端
        Route::post('Mobile/getlag', 'MobileManage\MobileController@getlag'); //接受移动端经纬度
        Route::post('Notifications/warning', 'NotificationsController@warning'); //仓库预警路由
    });
});

// 后台路由v3版-要逐步废弃
Route::namespace('Api')->prefix('v3')->group(function () {
    Route::group(['middleware' => ['islogin']], function () {
        // 员工列表
        Route::post('EmployeeList/set', 'SystemsManage\EmployeeListController@set'); //员工列表-设置

        // 系统设置--登录设备
        Route::post('LoginEquipment/index', 'SystemsManage\LoginEquipmentController@index'); //列表
        Route::post('LoginEquipment/consent', 'SystemsManage\LoginEquipmentController@consent'); //同意
        Route::post('LoginEquipment/start', 'SystemsManage\LoginEquipmentController@start'); //启用
        Route::post('LoginEquipment/reject', 'SystemsManage\LoginEquipmentController@reject'); //禁用

        // 加盟店
        Route::post('Stores/index', 'SystemsManage\StoresController@index'); //加盟店-列表
        Route::post('Stores/add', 'SystemsManage\StoresController@add'); //加盟店-新增
        Route::post('Stores/edit', 'SystemsManage\StoresController@edit'); //加盟店-编辑
        Route::post('Stores/start', 'SystemsManage\StoresController@start'); //加盟店-启用
        Route::post('Stores/stop', 'SystemsManage\StoresController@stop'); //加盟店-停用

        // 采购入库【已废弃】
        Route::post('Procurement/export', 'WarehouseManage\ProcurementController@export'); //采购入库-导出
        Route::post('Procurement/printNumber', 'WarehouseManage\ProcurementController@printNumber'); //采购入库-打印次数提交

        // 订单账单
        Route::post('OrderBill/del', 'AccountManage\OrderBillController@del'); //删除
        Route::post('OrderBill/audit', 'AccountManage\OrderBillController@audit'); //审核
        Route::post('OrderBill/advanceMoney', 'AccountManage\OrderBillController@advanceMoney'); //搜索预收款
        Route::post('OrderBill/lookInfo', 'AccountManage\OrderBillController@lookInfo'); //查看
        Route::post('OrderBill/cancelAudit', 'AccountManage\OrderBillController@cancelAudit'); //反审核
        Route::post('OrderBill/edit', 'AccountManage\OrderBillController@edit'); //编辑

        // 工单账单【已废弃】
        Route::post('WorkBill/del', 'AccountManage\WorkBillController@del'); //删除
        Route::post('WorkBill/audit', 'AccountManage\WorkBillController@audit'); //审核
        Route::post('WorkBill/lookInfo', 'AccountManage\WorkBillController@lookInfo'); //查看
        Route::post('WorkBill/cancelAudit', 'AccountManage\WorkBillController@cancelAudit'); //反审核
        Route::post('WorkBill/edit', 'AccountManage\WorkBillController@edit'); //编辑

        // 采购账单【已废弃】
        Route::post('ProcurementBill/del', 'AccountManage\ProcurementBillController@del'); //删除
        Route::post('ProcurementBill/audit', 'AccountManage\ProcurementBillController@audit'); //审核
        Route::post('ProcurementBill/lookInfo', 'AccountManage\ProcurementBillController@lookInfo'); //查看
        Route::post('ProcurementBill/advanceMoney', 'AccountManage\ProcurementBillController@advanceMoney'); //搜索预付账款
        Route::post('ProcurementBill/cancelAudit', 'AccountManage\ProcurementBillController@cancelAudit'); //反审核
        Route::post('ProcurementBill/edit', 'AccountManage\ProcurementBillController@edit'); //编辑

        // 销售账单
        Route::post('SellBill/del', 'AccountManage\SellBillController@del'); //删除
        Route::post('SellBill/audit', 'AccountManage\SellBillController@audit'); //审核
        Route::post('SellBill/lookInfo', 'AccountManage\SellBillController@lookInfo'); //查看
        Route::post('SellBill/cancelAudit', 'AccountManage\SellBillController@cancelAudit'); //反审核
        Route::post('SellBill/edit', 'AccountManage\SellBillController@edit'); //编辑

        // 技师地图
        Route::post('Location/searchLocation', 'Workbench\LocationController@searchLocation'); //技师定位列表
    });
});

// *****************与智配贴装系统对接接口*****************
Route::namespace('Api')->group(function () {
    // 贴装系统调用接口，不验证登录
    // 智配贴装派单，美装接单
    Route::post('v1/zptzSystemOrders/importOrders', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@importOrders');
    Route::post('v1/zptzSystemOrders/recycleOrder', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@recycleOrder'); //撤销订单
    Route::post('v1/zptzSystemOrders/opinionOrder', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@opinionOrder'); //审核订单
    Route::post('v1/zptzSystemOrders/orderLock', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@orderLock'); //锁定、取消锁定

    Route::post('v1/zptzSystemOrders/importBillOrders', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@importBillOrders'); //推送账单　
    Route::post('v1/zptzSystemOrders/editSd', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@editSd');//编辑地址


    Route::post('v1/zptzSystemOrders/reject', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@reject');//驳回账单

    // 搜索未绑定的门店
    Route::post('v1/zptzSystemShop/searchShop', 'OtherSystemInterfaces\zptz\zptzSystemShopController@searchShop');
    // 门店绑定接口，与贴装系统绑定
    Route::post('v1/zptzSystemShop/correlation', 'OtherSystemInterfaces\zptz\zptzSystemShopController@correlation');

    Route::post('v1/zptzSystemOrders/synShopByZptz','OtherSystemInterfaces\zptz\zptzSystemOrdersController@synShopByZptz');//智配服务同步门店　2023-6-15　du add
    Route::post('v1/zptzSystemOrders/synVoucher', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@synVoucher');//智配同步凭证　2023-6-16　du add
    Route::post('v1/zptzSystemOrders/sysBillOrderState', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@sysBillOrderState');//智配结款　2023-8-3　dou add
    

    // 美装系统相关接口，增加的功能接口，需要验证登录
    Route::group(['middleware' => ['islogin']], function () {
         //贴装系统订单的派单流程-订单相关
         Route::post('v1/zptzSystemOrders/refuseLabel', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@refuseLabel'); //拒单标签
         Route::post('v1/zptzSystemOrders/orderRefuse', 'OtherSystemInterfaces\zptz\zptzSystemOrdersController@orderRefuse'); //拒单
    });
});
// *****************与智配贴装系统对接接口*****************
// *****************与ERP系统对接接口*****************
Route::namespace('Api')->group(function () {
    // 贴装系统调用接口，不验证登录
    Route::post('v1/DataApi/dataApi', 'OtherSystemInterfaces\ERP\DataApiController@dataApi'); //数据入口
});
// *****************与ERP系统对接接口*****************

// 门店后台路由
Route::namespace('Api')->group(function () {
    Route::post("v3/VehicleInquire/index", "DataSearch\VehicleInquireController@index"); //车型查询列表
    Route::post("v3/VehicleInquire/getCarInfor", "DataSearch\VehicleInquireController@getCarInfor"); //车型查询列表
    Route::post("v3/VehicleInquire/getCarInfobyid", "DataSearch\VehicleInquireController@getCarInfobyid"); //车型查询列表

    Route::post("v3/AutoData/search", "DataSearch\AutoDataController@search"); //关键字搜索车型
    Route::post("v3/AutoData/getTopBrandByLetter", "DataSearch\AutoDataController@getTopBrandByLetter"); //字母搜索主品牌
    Route::post("v3/AutoData/getBrandByTopID", "DataSearch\AutoDataController@getBrandByTopID"); //主品牌查询子品牌
    Route::post("v3/AutoData/getSeriesByBrandID", "DataSearch\AutoDataController@getSeriesByBrandID"); //子品牌查车系
    Route::post("v3/AutoData/getModelsBySeriesID", "DataSearch\AutoDataController@getModelsBySeriesID"); //车系查车型
    Route::post("v3/AutoData/getGoodsByCarId", "DataSearch\AutoDataController@getGoodsByCarId"); //车型id查商品
    Route::post("v3/AutoData/getCarSeriesListByKeyword", "DataSearch\AutoDataController@getCarSeriesListByKeyword"); //关键词查车系
    Route::post("v3/AutoData/getTopBrand", "DataSearch\AutoDataController@getTopBrand"); //字母搜索主品牌

    // 打印设置
    // Route::post('v3/SystemPrint/index', 'SystemsManage\SystemPrintController@index'); //功能设置-打印模板设置列表
    // Route::post('v3/SystemPrint/add', 'SystemsManage\SystemPrintController@add'); //功能设置-创建打印模板
    // Route::post('v3/SystemPrint/set', 'SystemsManage\SystemPrintController@set'); //功能设置-设置打印模板
    Route::post('v3/SystemPrint/getshptType', 'SystemsManage\SystemPrintController@getshptType'); //功能设置-创建打印模板

    // 需要验证
    Route::group(['middleware' => ['islogin']], function () {
        Route::post('v1/Personal/shopInfo', 'SystemsManage\PersonalController@shopInfo'); //账号信息
        Route::post('v1/switchShopLogin', 'LoginController@switchShopLogin'); //选择门店登录
        // 业务系统 -- 工作总台
        Route::post('v1/CashierDesk/index', 'Workbench\CashierDeskController@index'); //收银台-权限列表
        Route::post('v1/CashierDesk/searchMember', 'Workbench\CashierDeskController@searchMember'); //收银台-搜索会员
        Route::post('v1/CashierDesk/searchBusiness', 'Workbench\CashierDeskController@searchBusiness'); //收银台-搜索企业客户
        Route::post('v1/CashierDesk/searchAllBusiness', 'Workbench\CashierDeskController@searchAllBusiness'); //收银台-搜索企业客户
        Route::post('v1/CashierDesk/searchBusinessacc', 'Workbench\CashierDeskController@searchBusinessacc'); //收银台-搜索企业客户-账户
        Route::post('v1/CashierDesk/searchChannelUnit', 'Workbench\CashierDeskController@searchChannelUnit'); //收银台-搜索渠道单位
        Route::post('v1/CashierDesk/searchShop', 'Workbench\CashierDeskController@searchShop'); //收银台-搜索服务门店
        Route::post('v1/CashierDesk/searchChannelType', 'Workbench\CashierDeskController@searchChannelType'); //收银台-搜索渠道类型
        Route::post('v1/CashierDesk/searchProject', 'Workbench\CashierDeskController@searchProject'); //收银台-搜索服务项目
        Route::post('v1/CashierDesk/searchWarehouse', 'Workbench\CashierDeskController@searchWarehouse'); //收银台-搜索仓库
        Route::post('v1/CashierDesk/searchTechnician', 'Workbench\CashierDeskController@searchTechnician'); //收银台-搜索技师
        Route::post('v1/CashierDesk/searchGoods', 'Workbench\CashierDeskController@searchGoods'); //收银台-搜索商品
        Route::post('v1/CashierDesk/goodsStock', 'Workbench\CashierDeskController@goodsStock'); //收银台-搜索商品库存
        Route::post('v1/CashierDesk/searchLocation', 'Workbench\CashierDeskController@searchLocation'); //收银台-搜索技师定位数据
        Route::post('v1/CashierDesk/searchMobileSilo', 'Workbench\CashierDeskController@searchMobileSilo'); //收银台-搜索移动仓数据
        Route::post('v1/CashierDesk/getTechnician', 'Workbench\CashierDeskController@getTechnician'); //收银台-搜索服务技师
        Route::post('v1/CashierDesk/searchWare', 'Workbench\CashierDeskController@searchWare'); //收银台-搜索供货仓库
        Route::post('v1/CashierDesk/searchGoodsEncode', 'Workbench\CashierDeskController@searchGoodsEncode'); //收银台-扫码根据商品编码搜索商品
        // 业务系统 -- 工作总台
        Route::post('v2/CashierDesk/addOrder', 'Workbench\CashierDeskController@addOrder'); //工作总台-生成订单
        Route::post('v2/CashierDesk/editOrder', 'Workbench\CashierDeskController@editOrder'); //工作总台-编辑订单
        Route::post('v2/CashierDesk/addWorkOrder', 'Workbench\CashierDeskController@addWorkOrder'); //工作总台-生成工单
        Route::post('v2/CashierDesk/assign', 'Workbench\CashierDeskController@assign'); //工作总台-派单--订单列表生成工单
        Route::post('v2/CashierDesk/settlement', 'Workbench\CashierDeskController@settlement'); //工作总台-结算
        Route::post('v2/CashierDesk/getMember', 'Workbench\CashierDeskController@getMember'); //工作总台-搜索会员信息
        Route::post('v2/CashierDesk/searchMemberCar', 'Workbench\CashierDeskController@searchMemberCar'); //工作总台-搜索会员车辆信息
        Route::post('v2/CashierDesk/getMemberCar', 'Workbench\CashierDeskController@getMemberCar'); //工作总台-获取会员车辆信息
        // 业务系统 -- 工作总台
        Route::post('v3/CashierDesk/getStoreShop', 'Workbench\CashierDeskController@getStoreShop'); //获取运营中下下的所有门店
        Route::post('v3/CashierDesk/workOrderAssign', 'Workbench\CashierDeskController@workOrderAssign'); //工作总台-生成工单+派单
        Route::post('v3/CashierDesk/assignAgain', 'Workbench\CashierDeskController@assignAgain'); //工作总台-重新给门店派单
        Route::post('v3/CashierDesk/searchAllTechnician', 'Workbench\CashierDeskController@searchAllTechnician'); //搜索服务技师--不论上班与否都可以搜索出来
        Route::post('v3/CashierDesk/searchAllShop', 'Workbench\CashierDeskController@searchAllShop'); //搜索勾选过的服务门店
        Route::post('v3/CashierDesk/getAllShop', 'Workbench\CashierDeskController@getAllShop'); //搜索勾选过的服务门店，加盟店
        Route::post('v3/CashierDesk/getVirtualShop', 'Workbench\CashierDeskController@getVirtualShop'); //搜索搜索虚拟加盟店
        Route::post('v3/CashierDesk/searchAllWarehouse', 'Workbench\CashierDeskController@searchAllWarehouse'); //工作总台查询仓库库存
        Route::post('v3/CashierDesk/quickSearchWarehouse', 'Workbench\CashierDeskController@quickSearchWarehouse'); //快速查询页面库存查询
        Route::post('v3/CashierDesk/searchExchangeGoods', 'Workbench\CashierDeskController@searchExchangeGoods'); //搜索换货商品
        Route::post('v3/CashierDesk/searchExchangeGoods2', 'Workbench\CashierDeskController@searchExchangeGoods2'); //搜索换货商品
        Route::post('v3/CashierDesk/searchOrderLabel', 'Workbench\CashierDeskController@searchOrderLabel'); //搜索订单标签
        Route::post('v3/CashierDesk/getGoodsStock', 'Workbench\CashierDeskController@getGoodsStock'); //获取商品库存信息
        Route::post('v3/CashierDesk/ceshi', 'Workbench\CashierDeskController@ceshi'); //测试接口
        Route::post('v3/CashierDesk/getCache', 'Workbench\CashierDeskController@getCache'); //工作总台-缓存获取
        Route::post('v3/CashierDesk/infoCache', 'Workbench\CashierDeskController@infoCache'); //工作总台-缓存提交
        Route::post('v3/CashierDesk/deleteCache', 'Workbench\CashierDeskController@deleteCache'); //工作总台-删除缓存
        Route::post('v3/CashierDesk/oweDay', 'Workbench\CashierDeskController@oweDay'); //工作总台-验证天数
        Route::post('v3/CashierDesk/searchAccount', 'Workbench\CashierDeskController@searchAccount'); //工作总台-搜索会计科目
        Route::post('v3/CashierDesk/searchInventory', 'Workbench\CashierDeskController@searchInventory'); //工作总台-搜索库存
        Route::post('v3/CashierDesk/searchStandbyBattery', 'Workbench\CashierDeskController@searchStandbyBattery'); //工作总台-搜索备用电池
        Route::post('v3/WearingPartDesk/addOrder', 'Workbench\WearingPartDeskController@addOrder'); //工作总台-新增易损件订单
        Route::post('v3/WearingPartDesk/editOrder', 'Workbench\WearingPartDeskController@editOrder'); //工作总台-编辑易损件订单
        Route::post('v3/WearingPartDesk/getGoodsinfo', 'Workbench\WearingPartDeskController@getGoodsinfo'); //工作总台-易损件商品搜索

        // 业务系统 -- 订单列表
        Route::post('v2/Order/index', 'OrderManage\OrderController@index'); //订单列表-列表
        Route::post('v2/Order/edit', 'OrderManage\OrderController@edit'); //订单列表-编辑
        Route::post('v2/Order/info', 'OrderManage\OrderController@info'); //订单列表-详情
        Route::post('v2/Order/settlement', 'OrderManage\OrderController@settlement'); //订单列表-结算
        Route::post('v2/Order/cancelSettlement', 'OrderManage\OrderController@cancelSettlement'); //订单列表-撤销结算
        Route::post('v2/Order/cancel', 'OrderManage\OrderController@cancel'); //订单列表-取消订单
        Route::post('v2/Order/afterSale', 'OrderManage\OrderController@afterSale'); //订单列表-转售后
        Route::post('v2/Order/workOrder', 'OrderManage\OrderController@workOrder'); //订单列表-生成工单
        Route::post('v2/Order/searchBill', 'OrderManage\OrderController@searchBill'); //订单列表-生成账单搜索
        Route::post('v2/Order/createBill', 'OrderManage\OrderController@createBill'); //订单列表-生成账单
        Route::post('v2/Order/editUnit', 'OrderManage\OrderController@editUnit'); //订单列表-修改来往单位
        Route::post('v3/Order/print', 'OrderManage\OrderController@print'); //订单列表-打印
        Route::post('v3/Order/export', 'OrderManage\OrderController@export'); //订单列表-导出
        Route::post('v3/Order/printNumber', 'OrderManage\OrderController@printNumber'); //订单列表-打印次数提交
        Route::post('v3/Order/againstOrder', 'OrderManage\OrderController@againstOrder'); //订单列表-冲单操作
        Route::post('v3/Order/achieve', 'OrderManage\OrderController@achieve'); //订单列表-完成订单
        Route::post('v3/Order/activityAudit', 'OrderManage\OrderController@activityAudit'); //订单列表-审核
        Route::post('v3/Order/createWorkAssign', 'OrderManage\OrderController@createWorkAssign'); //订单列表-外派门店工单
        Route::post('v3/Order/assignmentOrder', 'OrderManage\OrderController@assignmentOrder'); //订单列表-外派工单
        Route::post('v3/Order/undertakesPurchase', 'OrderManage\OrderController@undertakesPurchase'); //订单列表-代发采购
        Route::post('v3/Order/remark', 'OrderManage\OrderController@remark'); //订单列表-添加备注
        Route::post('v3/Order/orderVoucher', 'OrderManage\OrderController@orderVoucher'); //订单列表-生成凭证
        Route::post('v3/Order/editAssign', 'OrderManage\OrderController@editAssign'); //订单列表-派单
        Route::post('v3/Order/termination', 'OrderManage\OrderController@termination'); //订单列表-终止
        Route::post('v3/Order/appointmentSet', 'OrderManage\OrderController@appointmentSet'); //订单列表-预约设置
        Route::post('v3/Order/isExceed', 'OrderManage\OrderController@isExceed'); //订单列表-可欠天数金额审核的订单
        Route::post('v3/Order/cancelOrder', 'OrderManage\OrderController@cancelOrder'); //订单列表-作废易损件订单

        // 业务系统 -- 工单列表
        Route::post('v2/WorkOrder/index', 'OrderManage\WorkOrderController@index'); //工单列表-列表
        Route::post('v2/WorkOrder/assign', 'OrderManage\WorkOrderController@assign'); //工单列表-派单
        Route::post('v2/WorkOrder/delete', 'OrderManage\WorkOrderController@delete'); //工单列表-删除
        Route::post('v2/WorkOrder/info', 'OrderManage\WorkOrderController@info'); //工单列表-详情
        Route::post('v2/WorkOrder/pass', 'OrderManage\WorkOrderController@pass'); //工单列表-通过
        Route::post('v2/WorkOrder/reject', 'OrderManage\WorkOrderController@reject'); //工单列表-驳回
        Route::post('v2/WorkOrder/searchBill', 'OrderManage\WorkOrderController@searchBill'); //工单列表-生成账单搜索
        Route::post('v2/WorkOrder/createBill', 'OrderManage\WorkOrderController@createBill'); //工单列表-生成账单
        Route::post('v3/WorkOrder/edit', 'OrderManage\WorkOrderController@edit'); //工单列表-改单
        Route::post('v3/WorkOrder/print', 'OrderManage\WorkOrderController@print'); //工单列表-打印
        Route::post('v3/WorkOrder/export', 'OrderManage\WorkOrderController@export'); //工单列表-导出
        Route::post('v3/WorkOrder/updatePass', 'OrderManage\WorkOrderController@updatePass'); //工单列表-通过
        Route::post('v3/WorkOrder/updateTechnician', 'OrderManage\WorkOrderController@updateTechnician'); //修派技师
        Route::post('v3/WorkOrder/cancelAudit', 'OrderManage\WorkOrderController@cancelAudit'); //工单列表-反审核
        Route::post('v3/WorkOrder/printNumber', 'OrderManage\WorkOrderController@printNumber'); //工单列表-打印次数提交
        Route::post('v3/WorkOrder/runningRoute', 'OrderManage\WorkOrderController@runningRoute'); //工单列表-行驶轨迹
        Route::post('v3/WorkOrder/searchShop', 'OrderManage\WorkOrderController@searchShop'); //工单列表-搜索加盟店
        Route::post('v3/WorkOrder/beforePass', 'OrderManage\WorkOrderController@beforePass'); //工单列表-通过之前判断是否回收
        Route::post('v3/WorkOrder/lock', 'OrderManage\WorkOrderController@lock'); //工单列表-锁定
        Route::post('v3/WorkOrder/unlock', 'OrderManage\WorkOrderController@unlock'); //工单列表-取消锁定
        Route::post('v3/WorkOrder/reminder', 'OrderManage\WorkOrderController@reminder'); //工单列表-催单
        Route::post('v3/WorkOrder/changePass', 'OrderManage\WorkOrderController@changePass'); //改单审核通过
        Route::post('v3/WorkOrder/changeReject', 'OrderManage\WorkOrderController@changeReject'); //改单审核驳回
        Route::post('v3/WorkOrder/settlement', 'OrderManage\WorkOrderController@settlement'); //工单结算
        Route::post('v3/WorkOrder/deletePerformance', 'OrderManage\WorkOrderController@deletePerformance'); //删除绩效
        Route::post('v3/WorkOrder/editLicence', 'OrderManage\WorkOrderController@editLicence'); //修改车牌号和车型
        Route::post('v3/WorkOrder/remark', 'OrderManage\WorkOrderController@remark'); //工单备注
        Route::post('v3/WorkOrder/workOrderVoucher', 'OrderManage\WorkOrderController@workOrderVoucher'); //生成凭证
        Route::post('v3/WorkOrder/forceTermination', 'OrderManage\WorkOrderController@forceTermination'); //强制终止
        Route::post('v3/WorkOrder/editVirtual', 'OrderManage\WorkOrderController@editVirtual'); //虚拟加盟店改单
        Route::post('v3/WorkOrder/preciseLock', 'OrderManage\WorkOrderController@preciseLock'); //工单精确打卡开关
        Route::post('v3/WorkOrder/appointmentSet', 'OrderManage\WorkOrderController@appointmentSet'); //预约设置
        Route::post('v3/WorkOrder/sendMessage', 'OrderManage\WorkOrderController@sendMessage'); //发送短信
        Route::post('v3/WorkOrder/imageform', 'OrderManage\WorkOrderController@imageform'); //上传图片
        Route::post('v3/WorkOrder/delimageform', 'OrderManage\WorkOrderController@delimageform'); //删除图片

        // 传图统计
        Route::post('v3/UploadImage/index', 'OrderManage\UploadImageController@index'); //传图统计-列表
        Route::post('v3/UploadImage/imagePass', 'OrderManage\UploadImageController@imagePass'); //传图审核，上传图片是否合格

        // 基础管理 -- 商品列表
        Route::post('v1/GoodsList/index', 'ProductManage\GoodsListController@index'); //商品列表-列表
        Route::post('v1/GoodsList/add', 'ProductManage\GoodsListController@add'); //商品列表-新增
        Route::post('v1/GoodsList/edit', 'ProductManage\GoodsListController@edit'); //商品列表-编辑
        Route::post('v1/GoodsList/start', 'ProductManage\GoodsListController@start'); //商品列表-启用
        Route::post('v1/GoodsList/stop', 'ProductManage\GoodsListController@stop'); //商品列表-停用
        Route::post('v1/GoodsList/delete', 'ProductManage\GoodsListController@delete'); //商品列表-删除
        Route::post('v1/GoodsList/searchStock', 'ProductManage\GoodsListController@searchStock'); //商品列表-搜索库存
        Route::post('v3/GoodsList/lead', 'ProductManage\GoodsListController@lead'); //商品列表 -- 批量新增导入
        Route::post('v3/GoodsList/downTemplate', 'ProductManage\GoodsListController@downTemplate'); //导入-下载模板
        Route::post('v3/GoodsList/pulldownSearch', 'ProductManage\GoodsListController@pulldownSearch'); //列表下拉搜索-搜索商品
        Route::post('v3/GoodsList/assignSearch', 'ProductManage\GoodsListController@assignSearch'); //订单外派-搜索商品
        Route::post('v3/GoodsList/exportGoods', 'ProductManage\GoodsListController@exportGoods'); //商品列表 -- 导出
        Route::post('v3/GoodsList/importGoods', 'ProductManage\GoodsListController@importGoods'); //批量修改生成系统编码
        Route::post('v3/GoodsList/getBrandSerie', 'ProductManage\GoodsListController@getBrandSerie'); //商品列表 -- 搜索品牌系列
        Route::post('v3/GoodsList/info', 'ProductManage\GoodsListController@info'); //商品列表 -- 查看详情
        //商品列表 -- 绑定城市运营中心
        Route::post('v3/GoodsList/bind', 'ProductManage\GoodsListController@bind'); //商品列表 -- 绑定城市运营中心
        Route::post('v3/GoodsList/importEditGoods', 'ProductManage\GoodsListController@importEditGoods'); //商品列表 -- 批量编辑导入
        Route::post('v3/GoodsList/selectUnit', 'ProductManage\GoodsListController@selectUnit'); //商品列表 -- 查询单位
        Route::post('v3/GoodsList/bindGoods', 'ProductManage\GoodsListController@bindGoods'); //商品列表 -- 绑定商品
        Route::post('v3/GoodsList/bindList', 'ProductManage\GoodsListController@bindList'); //商品列表 -- 绑定商品列表
        Route::post('v3/GoodsList/searchColGoods', 'ProductManage\GoodsListController@searchColGoods'); //商品切换单位
        
        // 易损件列表
        Route::post('v3/WearingPart/wearingPartindex', 'ProductManage\WearingPartController@wearingPartindex'); //易损件列表 -- 易损件商品列表
        Route::post('v3/WearingPart/addwearingPart', 'ProductManage\WearingPartController@addwearingPart'); //易损件列表 -- 新增易损件
        Route::post('v3/WearingPart/editwearingPart', 'ProductManage\WearingPartController@editwearingPart'); //易损件列表 -- 编辑易损件
        Route::post('v3/WearingPart/editPrice', 'ProductManage\WearingPartController@editPrice'); //易损件列表 -- 价格维护
        Route::post('v3/WearingPart/matchModel', 'ProductManage\WearingPartController@matchModel'); //易损件列表 -- 价格维护

        // 仓储系统 -- 盘库单
        Route::post('v1/Stocktake/index', 'WarehouseManage\StocktakeController@index'); //盘库单-列表
        Route::post('v1/Stocktake/save', 'WarehouseManage\StocktakeController@save'); //盘库单-新增保存
        Route::post('v1/Stocktake/add', 'WarehouseManage\StocktakeController@add'); //盘库单-新增提交
        Route::post('v1/Stocktake/edit', 'WarehouseManage\StocktakeController@edit'); //盘库单-编辑
        Route::post('v1/Stocktake/submit', 'WarehouseManage\StocktakeController@submit'); //盘库单-提交
        Route::post('v1/Stocktake/pass', 'WarehouseManage\StocktakeController@pass'); //盘库单-通过
        Route::post('v1/Stocktake/reject', 'WarehouseManage\StocktakeController@reject'); //盘库单-驳回
        Route::post('v1/Stocktake/delete', 'WarehouseManage\StocktakeController@delete'); //盘库单-删除
        Route::post('v1/Stocktake/info', 'WarehouseManage\StocktakeController@info'); //盘库单-详情
        Route::post('v1/Stocktake/searchGoods', 'WarehouseManage\StocktakeController@searchGoods'); //盘库单-搜索商品
        Route::post('v1/Stocktake/searchGoods2', 'WarehouseManage\StocktakeController@searchGoods2'); //盘库单-搜索商品
        Route::post('v1/Stocktake/goodsStock', 'WarehouseManage\StocktakeController@goodsStock'); //盘库单-获取商品库存数量
        Route::post('v1/Stocktake/warehouseInfo', 'WarehouseManage\StocktakeController@warehouseInfo'); //盘库单-获取盘点仓库信息
        Route::post('v1/Stocktake/warehouseAllGoods', 'WarehouseManage\StocktakeController@warehouseAllGoods'); //盘库单-通盘获取仓库所有商品数据
        Route::post('v1/Stocktake/print', 'WarehouseManage\StocktakeController@print'); //盘库单-打印
        Route::post('v3/Stocktake/workOrderVoucher', 'WarehouseManage\StocktakeController@workOrderVoucher'); //盘库单-生成凭证
        Route::post('v3/Stocktake/selectGoodsWarehouse', 'WarehouseManage\StocktakeController@selectGoodsWarehouse'); //查询当前仓位商品库存数量【新增21.12.17】
        Route::post('v3/Stocktake/openingImport', 'WarehouseManage\StocktakeController@openingImport'); //盘库单期初导入

        // 仓储系统 -- 出入库记录
        Route::post('v1/OutinRecord/index', 'WarehouseManage\OutinRecordController@index'); //列表
        Route::post('v1/OutinRecord/warehouseInfo', 'WarehouseManage\OutinRecordController@warehouseInfo'); //获取仓库信息
        Route::post('v1/OutinRecord/numberDetails', 'WarehouseManage\OutinRecordController@numberDetails'); //获取单号详情
        Route::post('v3/OutinRecord/delete', 'WarehouseManage\OutinRecordController@delete'); //删除

        // 仓储系统 -- 我的仓库
        Route::post('v1/MyWarehouse/index', 'WarehouseManage\MyWarehouseController@index'); //我的仓库-列表
        Route::post('v1/MyWarehouse/add', 'WarehouseManage\MyWarehouseController@add'); //我的仓库-新增
        Route::post('v1/MyWarehouse/edit', 'WarehouseManage\MyWarehouseController@edit'); //我的仓库-编辑
        Route::post('v1/MyWarehouse/start', 'WarehouseManage\MyWarehouseController@start'); //我的仓库-启用
        Route::post('v1/MyWarehouse/stop', 'WarehouseManage\MyWarehouseController@stop'); //我的仓库-停用
        Route::post('v1/MyWarehouse/repeal', 'WarehouseManage\MyWarehouseController@repeal'); //我的仓库-撤仓
        Route::post('v1/MyWarehouse/setDefault', 'WarehouseManage\MyWarehouseController@setDefault'); //我的仓库-设为默认仓库
        Route::post('v1/MyWarehouse/fixedWarehouse', 'WarehouseManage\MyWarehouseController@fixedWarehouse'); //我的仓库-获取固定仓信息
        Route::post('v1/MyWarehouse/searchEmployee', 'WarehouseManage\MyWarehouseController@searchEmployee'); //我的仓库-搜索员工
        Route::post('v1/MyWarehouse/searchWarehouse', 'WarehouseManage\MyWarehouseController@searchWarehouse'); //我的仓库-调货-搜索仓库
        Route::post('v1/MyWarehouse/searchGoods', 'WarehouseManage\MyWarehouseController@searchGoods'); //我的仓库-调货-搜索商品
        Route::post('v1/MyWarehouse/stock', 'WarehouseManage\MyWarehouseController@stock'); //我的仓库-调货-从左向右调货获取库存量
        Route::post('v1/MyWarehouse/goodsStock', 'WarehouseManage\MyWarehouseController@goodsStock'); //我的仓库-调货-获取右侧商品的库存数量
        Route::post('v1/MyWarehouse/allocating', 'WarehouseManage\MyWarehouseController@allocating'); //我的仓库-调货-提交
        Route::post('v1/MyWarehouse/setMaster', 'WarehouseManage\MyWarehouseController@setMaster'); //我的仓库-主仓设置
        Route::post('v1/MyWarehouse/goodsList', 'WarehouseManage\MyWarehouseController@goodsList'); //我的仓库-查看仓库商品
        Route::post('v3/MyWarehouse/transition', 'WarehouseManage\MyWarehouseController@transition'); //我的仓库-转换-提交
        Route::post('v3/MyWarehouse/setWarning', 'WarehouseManage\MyWarehouseController@setWarning'); //我的仓库-设置预警类型
        Route::post('v3/MyWarehouse/goodsWarning', 'WarehouseManage\MyWarehouseController@goodsWarning'); //我的仓库-设置商品预警
        Route::post('v3/MyWarehouse/adjacentTransition', 'WarehouseManage\MyWarehouseController@adjacentTransition'); //我的仓库-临时仓转旧货仓
        Route::post('v3/MyWarehouse/exportGoods', 'WarehouseManage\MyWarehouseController@exportGoods'); //我的仓库-商品库存导出
        Route::post('v3/MyWarehouse/warehousing', 'WarehouseManage\MyWarehouseController@warehousing'); //我的仓库-入库
        Route::post('v3/MyWarehouse/downTemplate', 'WarehouseManage\MyWarehouseController@downTemplate'); //我的仓库-导入模板
        Route::post('v3/MyWarehouse/lead', 'WarehouseManage\MyWarehouseController@lead'); //我的仓库-导入
        Route::post('v3/MyWarehouse/unitConversion', 'WarehouseManage\MyWarehouseController@unitConversion'); //我的仓库-转库存

        // 仓储系统 -- 我的仓库 -- 仓位
        Route::post('v3/WarehouseFreight/index', 'WarehouseManage\WarehouseFreightController@index'); //我的仓库-仓位列表
        Route::post('v3/WarehouseFreight/addFreight', 'WarehouseManage\WarehouseFreightController@addFreight'); //我的仓库-新增仓位
        Route::post('v3/WarehouseFreight/info', 'WarehouseManage\WarehouseFreightController@info'); //我的仓库-仓位详情
        Route::post('v3/WarehouseFreight/transitionFreight', 'WarehouseManage\WarehouseFreightController@transitionFreight'); //我的仓库-转仓位
        Route::post('v3/WarehouseFreight/freightGoodsList', 'WarehouseManage\WarehouseFreightController@freightGoodsList'); //我的仓库-查看仓位商品
        Route::post('v3/WarehouseFreight/transitionWarehouse', 'WarehouseManage\WarehouseFreightController@transitionWarehouse'); //我的仓库-仓位转仓库
        // 我的仓库-仓位转仓位
        Route::post('v3/WarehouseFreight/transitionOtherFreight', 'WarehouseManage\WarehouseFreightController@transitionOtherFreight'); 
        // 我的仓库-搜索仓位，搜索1500个
        Route::post('v3/WarehouseFreight/searchFreight', 'WarehouseManage\WarehouseFreightController@searchFreight');
        // 我的仓库-搜索仓位,搜索10个
        Route::post('v3/WarehouseFreight/getFreight', 'WarehouseManage\WarehouseFreightController@getFreight');
        // 我的仓库-获取推荐仓位
        Route::post('v3/WarehouseFreight/getRecommendFreight', 'WarehouseManage\WarehouseFreightController@getRecommendFreight');
        // 我的仓库-获取仓位库存数量
        Route::post('v3/WarehouseFreight/getFreightStock', 'WarehouseManage\WarehouseFreightController@getFreightStock');
        Route::post('v3/WarehouseFreight/transitions', 'WarehouseManage\WarehouseFreightController@transitions'); //仓位库存转换

        // 仓储系统 -- 发货单
        Route::post('v3/Dispatch/index', 'WarehouseManage\DispatchController@index'); //发货单--列表
        Route::post('v3/Dispatch/searchShop', 'WarehouseManage\DispatchController@searchShop'); //发货单--搜索门店
        Route::post('v3/Dispatch/voicePrompt', 'WarehouseManage\DispatchController@voicePrompt'); //新发货单--语音提示
        Route::post('v3/Dispatch/info', 'WarehouseManage\DispatchController@info'); //发货单详情
        Route::post('v3/Dispatch/shipments', 'WarehouseManage\DispatchController@shipments'); //发货单--发货
        Route::post('v3/Dispatch/export', 'WarehouseManage\DispatchController@export'); //发货单--导出
        Route::post('v3/Dispatch/print', 'WarehouseManage\DispatchController@print'); //发货单--打印
        Route::post('v3/Dispatch/getFreight', 'WarehouseManage\DispatchController@getFreight'); //发货单--立即发货-获取仓位数据
        Route::post('v3/Dispatch/getorderpic', 'WarehouseManage\DispatchController@getorderpic'); //发货单--查看订单凭证
        Route::post('v3/Dispatch/getWareHouses', 'WarehouseManage\DispatchController@getWareHouses'); //发货查询仓库
        Route::post('v3/Dispatch/changeWare', 'WarehouseManage\DispatchController@changeWare'); //发货更改仓库

        // 仓储系统 -- 快递公司列表
        Route::post('v3/Delivery/add', 'WarehouseManage\DeliveryController@add'); //发货单--添加快递公司
        Route::post('v3/Delivery/index', 'WarehouseManage\DeliveryController@index'); //发货单--快递公司列表
        Route::post('v3/Delivery/allIndex', 'WarehouseManage\DeliveryController@allIndex'); //发货单--快递公司列表
        Route::post('v3/Delivery/edit', 'WarehouseManage\DeliveryController@edit'); //发货单--快递公司修改
        Route::post('v3/Delivery/editStatus', 'WarehouseManage\DeliveryController@editStatus'); //发货单--快递公司修改状态
        Route::post('v3/Delivery/addDelivery', 'WarehouseManage\DeliveryController@addDelivery'); //发货单--添加快递公司
        Route::post('v3/Delivery/deliveryList', 'WarehouseManage\DeliveryController@deliveryList'); //发货单--快递公司列表
        Route::post('v3/Delivery/deliveryEdit', 'WarehouseManage\DeliveryController@deliveryEdit'); //发货单--修改快递公司

        // 赠品商品【已废弃】
        Route::post('v3/GiftLists/index', 'ProductManage\GiftListsController@index'); //赠品列表-列表
        Route::post('v3/GiftLists/add', 'ProductManage\GiftListsController@add'); //赠品列表-新增
        Route::post('v3/GiftLists/edit', 'ProductManage\GiftListsController@edit'); //赠品列表-编辑
        Route::post('v3/GiftLists/start', 'ProductManage\GiftListsController@start'); //赠品列表-启用
        Route::post('v3/GiftLists/stop', 'ProductManage\GiftListsController@stop'); //赠品列表-停用
        Route::post('v3/GiftLists/delete', 'ProductManage\GiftListsController@delete'); //赠品列表-删除
        Route::post('v3/GiftLists/searchStock', 'ProductManage\GiftListsController@searchStock'); //赠品列表-搜索库存

        // 财务系统 【已废弃】 进销存查询-原来的进销存，现在已弃用
        Route::post('v3/StockingSelling/index', 'AccountControl\StockingSellingController@index'); //列表
        Route::post('v3/StockingSelling/indexExport', 'AccountControl\StockingSellingController@indexExport'); //导出
        Route::post('v3/StockingSelling/detail', 'AccountControl\StockingSellingController@detail'); //进销存查询详情
        Route::post('v3/StockingSelling/detailExport', 'AccountControl\StockingSellingController@detailExport'); //进销存查询详情导出

        // 财务系统 -- 进销存查询(新)
        Route::post('v3/StockSellStorageGoods/index', 'AccountControl\StockSellStorageGoodsController@index'); //进销存查列表

        // 财务系统 -- 银行卡管理
        Route::post('v3/AccountTitle/index', 'AccountControl\AccountTitleController@index'); //列表
        Route::post('v3/AccountTitle/add', 'AccountControl\AccountTitleController@add'); //新增
        Route::post('v3/AccountTitle/edit', 'AccountControl\AccountTitleController@edit'); //编辑
        Route::post('v3/AccountTitle/start', 'AccountControl\AccountTitleController@start'); //启用
        Route::post('v3/AccountTitle/stop', 'AccountControl\AccountTitleController@stop'); //停用
        Route::post('v3/AccountTitle/print', 'AccountControl\AccountTitleController@print'); //打印
        Route::post('v3/AccountTitle/selectIndex', 'AccountControl\AccountTitleController@selectIndex'); //银行卡查询列表
        Route::post('v3/AccountTitle/export', 'AccountControl\AccountTitleController@export'); //银行卡查询-导出

        // 财务系统 -- 会计科目（用友系统）
        Route::post('v3/AccountSubject/index', 'AccountControl\AccountSubjectController@index'); //列表
        Route::post('v3/AccountSubject/add', 'AccountControl\AccountSubjectController@add'); //新增
        Route::post('v3/AccountSubject/info', 'AccountControl\AccountSubjectController@info'); //详情
        Route::post('v3/AccountSubject/delete', 'AccountControl\AccountSubjectController@delete'); //删除
        Route::post('v3/AccountSubject/searchBdinfo', 'AccountControl\AccountSubjectController@searchBdinfo'); //搜索辅助核算项
        Route::post('v3/AccountSubject/searchSubjectType', 'AccountControl\AccountSubjectController@searchSubjectType'); //搜索科目类型
        Route::post('v3/AccountSubject/searchCurrtype', 'AccountControl\AccountSubjectController@searchCurrtype'); //搜索币种
        Route::post('v3/AccountSubject/searchSubject', 'AccountControl\AccountSubjectController@searchSubject'); //搜索科目

        // 财务系统 -- 期初余额（用友系统）
        Route::post('v3/InitialBalance/index', 'AccountControl\InitialBalanceController@index'); //期初余额——列表
        Route::post('v3/InitialBalance/edit', 'AccountControl\InitialBalanceController@edit'); //期初余额——编辑

        // 基础管理 -- 订单标签【已废弃】
        Route::post('v3/OrderLabel/index', 'ProductManage\OrderLabelController@index'); //列表
        Route::post('v3/OrderLabel/add', 'ProductManage\OrderLabelController@add'); //新增
        Route::post('v3/OrderLabel/edit', 'ProductManage\OrderLabelController@edit'); //编辑
        Route::post('v3/OrderLabel/start', 'ProductManage\OrderLabelController@start'); //启用
        Route::post('v3/OrderLabel/stop', 'ProductManage\OrderLabelController@stop'); //停用
        Route::post('v3/OrderLabel/delete', 'ProductManage\OrderLabelController@delete'); //删除
        Route::post('v3/OrderLabel/getOrderLabel', 'ProductManage\OrderLabelController@getOrderLabel'); //获取订单标签数据

        // 财务系统 -- 结款明细
        Route::post('v3/AccountingSettlement/index', 'AccountControl\AccountingSettlementController@index'); //列表
        Route::post('v3/AccountingSettlement/print', 'AccountControl\AccountingSettlementController@print'); //打印
        Route::post('v3/AccountingSettlement/export', 'AccountControl\AccountingSettlementController@export'); //导出
        Route::post('v3/AccountingSettlement/check', 'AccountControl\AccountingSettlementController@check'); //核销
        Route::post('v3/AccountingSettlement/cancelCheck', 'AccountControl\AccountingSettlementController@cancelCheck'); //取消核销
        Route::post('v3/AccountingSettlement/reject', 'AccountControl\AccountingSettlementController@reject'); //驳回
        Route::post('v3/AccountingSettlement/info', 'AccountControl\AccountingSettlementController@info'); //详情查看
        Route::post('v3/AccountingSettlement/moneyDetails', 'AccountControl\AccountingSettlementController@moneyDetails'); //结款详情
        Route::post('v3/AccountingSettlement/moneyExport', 'AccountControl\AccountingSettlementController@moneyExport'); //结款导出
        Route::post('v3/AccountingSettlement/workOrderVoucher', 'AccountControl\AccountingSettlementController@workOrderVoucher'); //生成凭证
        Route::post('v3/AccountingSettlement/delete', 'AccountControl\AccountingSettlementController@delete'); //删除凭证
        Route::post('v3/AccountingSettlement/sync', 'AccountControl\AccountingSettlementController@sync'); //同步

        // 财务系统 -- 应收应付
        Route::post('v3/receivableBill/index', 'AccountControl\receivableBillController@index'); //应收账款-列表
        Route::post('v3/receivableBill/advanceMoney', 'AccountControl\receivableBillController@advanceMoney'); //应收账款-预收款
        Route::post('v3/receivableBill/particulars', 'AccountControl\receivableBillController@particulars'); //应收账款-应收账款账单详情
        Route::post('v3/receivableBill/details', 'AccountControl\receivableBillController@details'); //应收账款-详情
        Route::post('v3/receivableBill/editTime', 'AccountControl\receivableBillController@editTime'); //应收账款-修改预收款截止时间
        Route::post('v3/receivableBill/leisurely', 'AccountControl\receivableBillController@leisurely'); //应收账款-收款还款路由
        Route::post('v3/receivableBill/nonphysical', 'AccountControl\receivableBillController@nonphysical'); //应收账款-非实物开单
        Route::post('v3/receivableBill/againstBill', 'AccountControl\receivableBillController@againstBill'); //应收账款-冲红按钮
        Route::post('v3/receivableBill/prepayment', 'AccountControl\receivableBillController@prepayment'); //应收账款-预付款
        Route::post('v3/receivableBill/export', 'AccountControl\receivableBillController@export'); //应收账款-导出
        Route::post('v3/receivablePay/edit', 'AccountControl\receivablePayController@edit'); //订单应收应付-修改 20230724
        Route::post('v3/receivablePay/add', 'AccountControl\receivablePayController@add'); //订单应收应付-添加 20230724
        Route::post('v3/receivablePay/index', 'AccountControl\receivablePayController@index'); //订单应收应付-列表 20230724
        Route::post('v3/receivablePay/info', 'AccountControl\receivablePayController@info'); //订单应收应付-详情 20230724
        Route::post('v3/receivablePay/export', 'AccountControl\receivablePayController@export'); //订单应收应付-导出 20230724

        // 财务系统 -- 应收账款分析
        Route::post('v3/receivableAnalyze/index', 'AccountControl\receivableAnalyzeController@index'); //应收账款分析-列表
        Route::post('v3/receivableAnalyze/export', 'AccountControl\receivableAnalyzeController@export'); //应收账款分析-列表

        // 应付账款【已废弃】
        Route::post('v3/PaymentBill/index', 'AccountControl\PaymentBillController@index'); //列表
        Route::post('v3/PaymentBill/paymentMoney', 'AccountControl\PaymentBillController@paymentMoney'); //预付款
        Route::post('v3/PaymentBill/details', 'AccountControl\PaymentBillController@details'); //详情
        Route::post('v3/PaymentBill/particulars', 'AccountControl\PaymentBillController@particulars'); //应付账款账单详情

        // 销售明细【已废弃】
        Route::post('v3/SellDetail/index', 'AccountControl\SellDetailController@index'); //列表
        Route::post('v3/SellDetail/goodsSales', 'AccountControl\SellDetailController@goodsSales'); //商品销量
        Route::post('v3/SellDetail/clientSales', 'AccountControl\SellDetailController@clientSales'); //客户销量
        Route::post('v3/SellDetail/shopSales', 'AccountControl\SellDetailController@shopSales'); //门店销量
        Route::post('v3/SellDetail/searchGoods', 'AccountControl\SellDetailController@searchGoods'); //搜索商品
        Route::post('v3/SellDetail/export', 'AccountControl\SellDetailController@export'); // 销售出库-导出

        // 采购明细【已废弃】
        Route::post('v3/ProcurementDetail/index', 'AccountControl\ProcurementDetailController@index'); //列表
        Route::post('v3/ProcurementDetail/export', 'AccountControl\ProcurementDetailController@export'); //导出

        // 销售利润【已废弃】
        Route::post('v3/SellProject/index', 'AccountControl\SellProjectController@index'); //列表

        // 运营系统 -- 客户单位
        Route::post('v1/ChannelUnit/index', 'ChannelManage\ChannelUnitController@index'); //客户单位-列表
        Route::post('v1/ChannelUnit/add', 'ChannelManage\ChannelUnitController@add'); //客户单位-新增
        Route::post('v1/ChannelUnit/edit', 'ChannelManage\ChannelUnitController@edit'); //客户单位-编辑
        Route::post('v1/ChannelUnit/start', 'ChannelManage\ChannelUnitController@start'); //客户单位-启用
        Route::post('v1/ChannelUnit/stop', 'ChannelManage\ChannelUnitController@stop'); //客户单位-停用
        Route::post('v1/ChannelUnit/details', 'ChannelManage\ChannelUnitController@details'); //客户单位-详情
        Route::post('v1/ChannelUnit/searchChannelType', 'ChannelManage\ChannelUnitController@searchChannelType'); //客户单位-搜索渠道类型
        Route::post('v3/ChannelUnit/searchSalesman', 'ChannelManage\ChannelUnitController@searchSalesman'); //搜索业务员
        Route::post('v3/ChannelUnit/searchPrecincts', 'ChannelManage\ChannelUnitController@searchPrecincts'); //搜索业务划区
        Route::post('v3/ChannelUnit/lead', 'ChannelManage\ChannelUnitController@lead'); //导入
        Route::post('v3/ChannelUnit/downTemplate', 'ChannelManage\ChannelUnitController@downTemplate'); //导入-下载模板
        Route::post('v3/ChannelUnit/searchCustomer', 'ChannelManage\ChannelUnitController@searchCustomer'); //搜索客户单位
        Route::post('v3/ChannelUnit/merge', 'ChannelManage\ChannelUnitController@merge'); //合并
        Route::post('v3/ChannelUnit/pulldownSearch', 'ChannelManage\ChannelUnitController@pulldownSearch'); //列表下拉搜索客户单位
        Route::post('v3/ChannelUnit/pulldownChan', 'ChannelManage\ChannelUnitController@pulldownChan'); //列表下拉搜索客户单位
        Route::post('v3/ChannelUnit/getChannelUnit', 'ChannelManage\ChannelUnitController@getChannelUnit'); //获取客户单位信息
        Route::post('v3/ChannelUnit/searchAddChannelGoods', 'ChannelManage\ChannelUnitController@searchAddChannelGoods'); //客户单位搜索商品绑定商品
        Route::post('v3/ChannelUnit/searchGoodsList', 'ChannelManage\ChannelUnitController@searchGoodsList'); //查询客户单位绑定商品
        Route::post('v3/ChannelUnit/export', 'ChannelManage\ChannelUnitController@export'); //导出
        Route::post('v3/ChannelUnit/getPaymentWay', 'ChannelManage\ChannelUnitController@getPaymentWay'); //结算方式
        Route::post('v3/ChannelUnit/getDeliverType', 'ChannelManage\ChannelUnitController@getDeliverType'); //交货方式
        Route::post('v3/ChannelUnit/getInvoiceType', 'ChannelManage\ChannelUnitController@getInvoiceType'); //票据类型
        Route::post('v3/ChannelUnit/settlementInformation', 'ChannelManage\ChannelUnitController@getSettlementInformation'); //结算信息

        // 拜访列表【暂时用不到】
        Route::post('v3/VisitLists/index', 'ChannelManage\VisitListsController@index'); //拜访列表-列表
        Route::post('v3/VisitLists/info', 'ChannelManage\VisitListsController@info'); //拜访列表-详情查看
        Route::post('v3/VisitLists/add', 'ChannelManage\VisitListsController@add'); //拜访列表-新增
        Route::post('v3/VisitLists/edit', 'ChannelManage\VisitListsController@edit'); //拜访列表-编辑
        Route::post('v3/VisitLists/delete', 'ChannelManage\VisitListsController@delete'); //拜访列表-删除
        Route::post('v3/VisitLists/visitRecord', 'ChannelManage\VisitListsController@visitRecord'); //拜访记录列表-列表
        Route::post('v3/VisitLists/runningRoute', 'ChannelManage\VisitListsController@runningRoute'); //拜访记录列表-行驶轨迹
        Route::post('v3/VisitLists/terminate', 'ChannelManage\VisitListsController@terminate'); //拜访列表-终止

        // 竞品展示列表【暂时用不到】
        Route::post('v3/CompetingLists/index', 'ChannelManage\CompetingListsController@index'); //竞品展示列表-列表

        // 铺货更换列表【暂时用不到】
        Route::post('v3/DistirbutionLists/index', 'ChannelManage\DistirbutionListsController@index'); //铺货更换列表-列表
        Route::post('v3/DistirbutionLists/dispose', 'ChannelManage\DistirbutionListsController@dispose'); //铺货更换列表-处理

        // 基础管理
        Route::post('v3/Features/settings', 'SystemsManage\FeaturesController@settings'); //功能设置
        Route::post('v3/Features/imageUploadTemplateSet', 'SystemsManage\FeaturesController@imageUploadTemplateSet'); //功能设置-图片上传模板

        // 打印设置
        Route::post('v3/SystemPrint/index', 'SystemsManage\SystemPrintController@index'); //打印设置-打印模板设置列表
        Route::post('v3/SystemPrint/add', 'SystemsManage\SystemPrintController@add'); //打印设置-创建打印模板
        Route::post('v3/SystemPrint/set', 'SystemsManage\SystemPrintController@set'); //打印设置-设置打印模板
        Route::post('v3/SystemPrint/getshptComponent', 'SystemsManage\SystemPrintController@getshptComponent'); //打印设置-打印模板获取组件
        Route::post('v3/SystemPrint/print', 'SystemsManage\SystemPrintController@print'); //打印设置-打印
        Route::post('v3/SystemPrint/delete', 'SystemsManage\SystemPrintController@delete'); //打印设置-删除打印模板

        // 我的门店
        Route::post('v1/StoreList/index', 'SystemsManage\StoreListController@index'); //我的门店-列表
        Route::post('v1/StoreList/add', 'SystemsManage\StoreListController@add'); //我的门店-新增
        Route::post('v1/StoreList/edit', 'SystemsManage\StoreListController@edit'); //我的门店-编辑
        Route::post('v1/StoreList/start', 'SystemsManage\StoreListController@start'); //我的门店-营业
        Route::post('v1/StoreList/stop', 'SystemsManage\StoreListController@stop'); //我的门店-停业
        Route::post('v1/StoreList/searchPeople', 'SystemsManage\StoreListController@searchPeople'); //人员分配-搜索员工
        Route::post('v1/StoreList/searchShop', 'SystemsManage\StoreListController@searchShop'); //人员分配-搜索门店
        Route::post('v1/StoreList/peopleSubmit', 'SystemsManage\StoreListController@peopleSubmit'); //人员分配-提交

        // 基础管理 -- 绑定上级商品
        Route::post('v1/GoodsList/parentGoodsList', 'ProductManage\GoodsListController@parentGoodsList'); //绑定上级商品
        Route::post('v1/GoodsList/parentGoodsBinding', 'ProductManage\GoodsListController@parentGoodsBinding'); //绑定操作

        // 基础管理 -- 角色设置
        Route::post('v1/RoleSet/index', 'SystemsManage\RoleSetController@index'); //角色设置-列表
        Route::post('v1/RoleSet/add', 'SystemsManage\RoleSetController@add'); //角色设置-新增
        Route::post('v1/RoleSet/edit', 'SystemsManage\RoleSetController@edit'); //角色设置-编辑
        Route::post('v1/RoleSet/start', 'SystemsManage\RoleSetController@start'); //角色设置-启用
        Route::post('v1/RoleSet/stop', 'SystemsManage\RoleSetController@stop'); //角色设置-停用
        Route::post('v1/RoleSet/getRole', 'SystemsManage\RoleSetController@getRole'); //角色设置-获取角色信息
        Route::post('v1/RoleSet/appAdd', 'SystemsManage\RoleSetController@appAdd'); //角色设置-新增app角色
        Route::post('v3/RoleSet/appletAdd', 'SystemsManage\RoleSetController@appletAdd'); //角色设置-新增微信小程序角色
        Route::post('v3/RoleSet/addition', 'SystemsManage\RoleSetController@addition'); //角色设置-新增角色
        Route::post('v3/RoleSet/modify', 'SystemsManage\RoleSetController@modify'); //角色设置-编辑角色

        // 基础管理 -- 新增基础版门店
        Route::post('v1/Store/index', 'Store\StoreListController@index'); //基础版门店-列表
        Route::post('v1/Store/add', 'Store\StoreListController@add'); //基础版门店-新增
        Route::post('v1/Store/edit', 'Store\StoreListController@edit'); //基础版门店-编辑
        Route::post('v1/Store/start', 'Store\StoreListController@edit'); //基础版门店-营业
        Route::post('v1/Store/stop', 'Store\StoreListController@edit'); //基础版门店-停业

        // 基础管理 -- 员工列表
        Route::post('v1/EmployeeList/index', 'SystemsManage\EmployeeListController@index'); //员工列表-列表
        Route::post('v1/EmployeeList/add', 'SystemsManage\EmployeeListController@add'); //员工列表-新增
        Route::post('v1/EmployeeList/edit', 'SystemsManage\EmployeeListController@edit'); //员工列表-编辑
        Route::post('v1/EmployeeList/start', 'SystemsManage\EmployeeListController@start'); //员工列表-启用
        Route::post('v1/EmployeeList/stop', 'SystemsManage\EmployeeListController@stop'); //员工列表-停用
        Route::post('v1/EmployeeList/addGrle', 'SystemsManage\EmployeeListController@addGrle'); //员工列表-停用
        Route::post('v1/EmployeeList/exportadm', 'SystemsManage\EmployeeListController@exportadm'); //员工列表-导出
        Route::post('v1/EmployeeList/resetPassword', 'SystemsManage\EmployeeListController@resetPassword'); //员工列表-重置密码
        Route::post('v3/EmployeeList/downTemplate', 'SystemsManage\EmployeeListController@downTemplate'); //员工列表-导入模板
        Route::post('v3/EmployeeList/lead', 'SystemsManage\EmployeeListController@lead'); //员工列表-导入
        Route::post('v3/EmployeeList/unbindWx', 'SystemsManage\EmployeeListController@unbindWx'); //员工列表-解绑微信
        Route::post('v1/EmployeeList/searchList', 'SystemsManage\EmployeeListController@searchList'); //员工搜索

        // 基础管理 -- 个人中心
        Route::post('v1/Personal/enterssellssaves', 'SystemsManage\PersonalController@enterssellssaves'); //计算历史进销存
        Route::post('v1/Personal/personal', 'SystemsManage\PersonalController@personal'); //获取页面信息
        Route::post('v1/Personal/getQrimg', 'SystemsManage\PersonalController@getQrimg'); //获取店铺小程序二维码
        Route::post('v1/Personal/editPwd', 'SystemsManage\PersonalController@editPwd'); //修改密码
        Route::post('v1/Personal/editTel', 'SystemsManage\PersonalController@editTel'); //修改电话
        Route::post('v1/Personal/img', 'SystemsManage\PersonalController@img'); //上传图片
        Route::post('v1/Personal/edit', 'SystemsManage\PersonalController@edit'); //编辑
        Route::post('v3/Personal/editPerson', 'SystemsManage\PersonalController@editPerson'); //个人信息编辑
        Route::post('v3/Personal/submitAudit', 'SystemsManage\PersonalController@submitAudit'); //个人信息修改提交审核
        Route::post('v1/Personal/companyProfile', 'SystemsManage\PersonalController@companyProfile'); //公司简介信息-查看
        Route::post('v1/Personal/companyProfileEdit', 'SystemsManage\PersonalController@companyProfileEdit'); //公司简介信息-编辑
        Route::post('v1/Personal/invitation', 'SystemsManage\PersonalController@invitation'); //邀请记录
        Route::post('v1/Personal/getInvQrimg', 'SystemsManage\PersonalController@getInvQrimg'); //邀请二维码

        // 基础管理 -- 系统日志
        Route::post('v1/SystemLog/index', 'SystemsManage\SystemLogController@index'); //系统日志-列表

        // 基础管理 -- 服务项目
        Route::post('v1/ServiceProject/index', 'ProductManage\ServiceProjectController@index'); //服务项目-列表
        Route::post('v1/ServiceProject/add', 'ProductManage\ServiceProjectController@add'); //服务项目-新增
        Route::post('v1/ServiceProject/edit', 'ProductManage\ServiceProjectController@edit'); //服务项目-编辑
        Route::post('v1/ServiceProject/start', 'ProductManage\ServiceProjectController@start'); //服务项目-启用
        Route::post('v1/ServiceProject/stop', 'ProductManage\ServiceProjectController@stop'); //服务项目-停用
        Route::post('v1/ServiceProject/delete', 'ProductManage\ServiceProjectController@delete'); //服务项目-删除
        Route::post('v1/ServiceProject/assignSearch', 'ProductManage\ServiceProjectController@assignSearch'); //订单外派-搜索服务项目
        Route::post('v1/ServiceProject/binding', 'ProductManage\ServiceProjectController@binding'); //服务项目-绑定
        Route::post('v1/ServiceProject/zptzServiceProject', 'ProductManage\ServiceProjectController@zptzServiceProject'); //服务项目-搜索支配贴装服务项目
        Route::post('v1/ServiceProject/getConimg', 'ProductManage\ServiceProjectController@getConimg'); //服务项目-获取配置图片
        Route::post('v1/ServiceProject/lead', 'ProductManage\ServiceProjectController@lead'); //导入服务信息
        Route::post('v1/ServiceProject/executeLead', 'ProductManage\ServiceProjectController@executeLead'); //执行导入数据
        Route::post('v1/ServiceProject/getClass', 'ProductManage\ServiceProjectController@getClass'); //执行导入数据

        // 基础管理 -- 品牌列表
        Route::post('v1/BrandList/index', 'ProductManage\BrandListController@index'); //品牌列表-列表
        Route::post('v1/BrandList/add', 'ProductManage\BrandListController@add'); //品牌列表-新增
        Route::post('v1/BrandList/edit', 'ProductManage\BrandListController@edit'); //品牌列表-编辑
        Route::post('v1/BrandList/start', 'ProductManage\BrandListController@start'); //品牌列表-启用
        Route::post('v1/BrandList/stop', 'ProductManage\BrandListController@stop'); //品牌列表-停用
        Route::post('v1/BrandList/delete', 'ProductManage\BrandListController@delete'); //品牌列表-删除
        Route::post('v1/BrandList/getBrand', 'ProductManage\BrandListController@getBrand'); //品牌列表-获取品牌信息

        // 基础管理 -- 品牌系列列表
        Route::post('v3/BrandSerie/index', 'ProductManage\BrandSerieController@index'); //品牌系列列表-列表
        Route::post('v3/BrandSerie/add', 'ProductManage\BrandSerieController@add'); //品牌系列列表-新增
        Route::post('v3/BrandSerie/edit', 'ProductManage\BrandSerieController@edit'); //品牌系列列表-编辑
        Route::post('v3/BrandSerie/start', 'ProductManage\BrandSerieController@start'); //品牌系列列表-启用
        Route::post('v3/BrandSerie/stop', 'ProductManage\BrandSerieController@stop'); //品牌系列列表-停用
        Route::post('v3/BrandSerie/delete', 'ProductManage\BrandSerieController@delete'); //品牌系列列表-删除
        Route::post('v3/BrandSerie/getBrandSerie', 'ProductManage\BrandSerieController@getBrandSerie'); //品牌系列列表-获取品牌系列信息
        Route::post('v3/BrandSerie/getCategory', 'ProductManage\BrandSerieController@getCategory'); //品牌系列列表-获取品类信息

        // 基础管理 -- 品类列表
        Route::post('v1/CategoryList/index', 'ProductManage\CategoryListController@index'); //品类列表-列表
        Route::post('v1/CategoryList/add', 'ProductManage\CategoryListController@add'); //品类列表-新增
        Route::post('v1/CategoryList/edit', 'ProductManage\CategoryListController@edit'); //品类列表-编辑
        Route::post('v1/CategoryList/start', 'ProductManage\CategoryListController@start'); //品类列表-启用
        Route::post('v1/CategoryList/stop', 'ProductManage\CategoryListController@stop'); //品类列表-停用
        Route::post('v1/CategoryList/delete', 'ProductManage\CategoryListController@delete'); //品类列表-删除
        Route::post('v1/CategoryList/getCategory', 'ProductManage\CategoryListController@getCategory'); //品类列表-获取品类信息

        // 审核管理 -- 账号审核
        Route::post('v1/AccountReview/index', 'SystemsManage\AccountReviewController@index'); //账号审核-列表
        Route::post('v1/AccountReview/add', 'SystemsManage\AccountReviewController@add'); //账号审核-添加
        Route::post('v1/AccountReview/edit', 'SystemsManage\AccountReviewController@edit'); //账号审核-修改
        Route::post('v1/AccountReview/info', 'SystemsManage\AccountReviewController@info'); //账号审核-详情
        Route::post('v1/AccountReview/address', 'SystemsManage\AccountReviewController@address'); //账号审核-邀请地址

        // 收款管理【废弃】
        Route::post('v1/GatheringManage/index', 'FinanceManage\GatheringManageController@index'); //收款管理-列表
        Route::post('v1/GatheringManage/orderDetails', 'FinanceManage\GatheringManageController@orderDetails'); //收款管理-订单详情
        Route::post('v1/GatheringManage/warehouseInfo', 'FinanceManage\GatheringManageController@warehouseInfo'); //收款管理-供货仓库信息
        Route::post('v1/GatheringManage/searchShop', 'FinanceManage\GatheringManageController@searchShop'); //收款管理-搜索门店

        // 运营系统 -- 单位类型
        Route::post('v1/ChannelType/index', 'ChannelManage\ChannelTypeController@index'); //渠道类型-列表
        Route::post('v1/ChannelType/add', 'ChannelManage\ChannelTypeController@add'); //渠道类型-新增
        Route::post('v1/ChannelType/edit', 'ChannelManage\ChannelTypeController@edit'); //渠道类型-编辑
        Route::post('v1/ChannelType/start', 'ChannelManage\ChannelTypeController@start'); //渠道类型-启用
        Route::post('v1/ChannelType/stop', 'ChannelManage\ChannelTypeController@stop'); //渠道类型-停用
        Route::post('v1/ChannelType/delete', 'ChannelManage\ChannelTypeController@delete'); //渠道类型-删除
        Route::post('v1/ChannelType/searchChannelType', 'ChannelManage\ChannelTypeController@searchChannelType'); //渠道类型-搜索渠道类型

        // 运营系统 -- 会员客户
        Route::post('v1/MemberList/index', 'MemberManage\MemberListController@index'); //会员列表-列表
        Route::post('v1/MemberList/add', 'MemberManage\MemberListController@add'); //会员列表-新增
        Route::post('v1/MemberList/edit', 'MemberManage\MemberListController@edit'); //会员列表-编辑
        Route::post('v1/MemberList/sendMessage', 'MemberManage\MemberListController@sendMessage'); //会员列表-发送消息
        Route::post('v1/MemberList/sendRecord', 'MemberManage\MemberListController@sendRecord'); //会员列表-发送记录
        Route::post('v1/MemberList/recharge', 'MemberManage\MemberListController@recharge'); //会员列表-充值
        Route::post('v1/MemberList/refund', 'MemberManage\MemberListController@refund'); //会员列表-退款
        Route::post('v1/MemberList/reclog', 'MemberManage\MemberListController@reclog'); //会员列表-消费记录
        Route::post('v1/MemberList/getBanlance', 'MemberManage\MemberListController@getBanlance'); //会员列表-获取余额
        Route::post('v1/MemberList/getInfo', 'MemberManage\MemberListController@getInfo'); //会员列表-获取单条信息
        Route::post('v1/MemberList/setRemind', 'MemberManage\MemberListController@setRemind'); //会员列表-设置提醒节日
        Route::post('v1/MemberList/searchList', 'MemberManage\MemberListController@searchList'); //会员搜索下拉
        Route::post('v1/MemberList/arrearsRecord', 'MemberManage\MemberListController@arrearsRecord'); //会员列表-会员欠款记录
        Route::post('v1/MemberList/salesmanRep', 'MemberManage\MemberListController@salesmanRep'); //会员列表-业务员替换
        Route::post('v1/MemberList/downTemplate', 'MemberManage\MemberListController@downTemplate'); //会员列表-导入模板
        Route::post('v1/MemberList/lead', 'MemberManage\MemberListController@lead'); //会员列表-导入
        Route::post('v1/MemberList/export', 'MemberManage\MemberListController@export'); //会员列表-导出
        Route::post('v1/MemberList/memberLog', 'MemberManage\MemberListController@memberLog'); //会员列表-导入会员记录
        Route::post('v1/MemberList/memState', 'MemberManage\MemberListController@memState'); //会员列表-停启用
        Route::post('v1/MemberList/editOrderMember', 'MemberManage\MemberListController@editOrderMember'); //编辑用户信息
        Route::post('v1/MemberLevel/index', 'MemberManage\MemberLevelController@index'); //会员设置-会员列表
        Route::post('v1/MemberLevel/edit', 'MemberManage\MemberLevelController@edit'); //会员设置-修改会员等级
        Route::post('v1/MemberLevel/getGoods', 'MemberManage\MemberLevelController@getGoods'); //会员设置-商品列表
        Route::post('v1/MemberLevel/upgrade', 'MemberManage\MemberLevelController@upgrade'); //会员列表-黑钻升级
        Route::post('v1/MemberLabel/index', 'MemberManage\MemberLabelController@index'); //会员标签-列表
        Route::post('v1/MemberLabel/add', 'MemberManage\MemberLabelController@add'); //会员标签-添加
        Route::post('v1/MemberLabel/edit', 'MemberManage\MemberLabelController@edit'); //会员标签-修改
        Route::post('v1/MemberLabel/editStatus', 'MemberManage\MemberLabelController@editStatus'); //会员标签-隐藏
        Route::post('v1/MemberLabel/allIndex', 'MemberManage\MemberLabelController@allIndex'); //会员标签-全部数据列表
        Route::post('v1/MemberLabel/setMemberData', 'MemberManage\MemberListController@setMemberData'); //会员列表-设置客户来源

        // 运营系统 -- 关怀设置
        Route::post('v1/FestivalRemind/index', 'MemberManage\FestivalRemindController@index'); //关怀设置-列表
        Route::post('v1/FestivalRemind/add', 'MemberManage\FestivalRemindController@add'); //关怀设置-新增
        Route::post('v1/FestivalRemind/edit', 'MemberManage\FestivalRemindController@edit'); //关怀设置-修改
        Route::post('v1/FestivalRemind/getCount', 'MemberManage\FestivalRemindController@getCount'); //关怀设置-预计发送条数
        Route::post('v1/FestivalRemind/getList', 'MemberManage\FestivalRemindController@getList'); //关怀设置-列表
        Route::post('v1/FestivalRemind/signature', 'MemberManage\FestivalRemindController@signature'); //关怀设置-签名修改
        Route::post('v1/FestivalRemind/sendContent', 'MemberManage\FestivalRemindController@sendContent'); //关怀设置-测试发送短信
        Route::post('v1/FestivalRemind/sendMes', 'MemberManage\FestivalRemindController@sendMes'); //关怀设置-发送短信

        // 运营系统 -- 短信设置
        Route::post('v1/FestivalRemind/getMessageList', 'MemberManage\FestivalRemindController@getMessageList'); //短信设置-列表
        Route::post('v1/FestivalRemind/sendMessage', 'MemberManage\FestivalRemindController@sendMessage'); //短信设置-重新发送
        Route::post('v1/FestivalRemind/smsLabel', 'MemberManage\FestivalRemindController@smsLabel'); //短信设置-短信标签

        // 财务系统 -- 账单列表
        Route::post('v2/OrderBill/index', 'AccountManage\OrderBillController@index'); //列表
        Route::post('v2/OrderBill/billNumber', 'AccountManage\OrderBillController@billNumber'); //单量
        Route::post('v2/OrderBill/clearing', 'AccountManage\OrderBillController@clearing'); //结算
        Route::post('v2/OrderBill/moneyRecord', 'AccountManage\OrderBillController@moneyRecord'); //结款记录
        Route::post('v2/OrderBill/details', 'AccountManage\OrderBillController@details'); //账单查看详情
        Route::post('v2/OrderBill/export', 'AccountManage\OrderBillController@export'); //导出
        Route::post('v2/OrderBill/billExport', 'AccountManage\OrderBillController@billExport'); //账单导出
        Route::post('v2/OrderBill/openingBill', 'AccountManage\OrderBillController@openingBill'); //期初账单导入

        // 运营系统 -- 导出权限
        Route::post('v1/Excelpermiss/excelFields', 'ExcelInfo\ExcelpermissController@excelFields'); //导出权限-获取字段数据
        Route::post('v1/Excelpermiss/excelActions', 'ExcelInfo\ExcelpermissController@excelActions');//导出权限-获取控制器名称
        Route::post('v1/Excelpermiss/excelAdd', 'ExcelInfo\ExcelpermissController@excelAdd');//导出权限-添加
        Route::post('v1/Excelpermiss/index', 'ExcelInfo\ExcelpermissController@index');//导出权限-列表
        Route::post('v1/Excelpermiss/excelEdit', 'ExcelInfo\ExcelpermissController@excelEdit');//导出权限-编辑
        Route::post('v1/Excelpermiss/excelDel', 'ExcelInfo\ExcelpermissController@excelDel');//导出权限-删除
        Route::post('v1/Excelpermiss/roleList', 'ExcelInfo\ExcelpermissController@roleList');//导出权限-角色列表
        Route::post('v1/Excelpermiss/shopList', 'ExcelInfo\ExcelpermissController@shopList');//导出权限-门店列表

        // 运营系统 -- 下载管理
        Route::post('v1/excel/execExcelOut', 'ExcelInfo\ExceloutController@execExcelOut');//执行
        Route::post('v1/excel/index', 'ExcelInfo\ExcelListController@index');//列表
        Route::any('v1/excel/addDownloudnum', 'ExcelInfo\ExcelListController@addDownloudnum');//下载次数
        Route::post('v1/excel/userList', 'ExcelInfo\ExcelListController@userList');//申请人

        // 运营系统 -- pc权限
        Route::post('v1/Privileges/index', 'SystemsManage\PrivilegesController@index');//权限-列表
        Route::post('v1/Privileges/add', 'SystemsManage\PrivilegesController@add');//权限-添加栏目
        Route::post('v1/Privileges/addList', 'SystemsManage\PrivilegesController@addList');//权限-添加列表
        Route::post('v1/Privileges/addFunction', 'SystemsManage\PrivilegesController@addFunction');//权限-添加动作
        Route::post('v1/Privileges/edit', 'SystemsManage\PrivilegesController@edit');//权限-编辑
        Route::post('v1/Privileges/del', 'SystemsManage\PrivilegesController@del');//权限-删除
        Route::post('v1/Privileges/columnList', 'SystemsManage\PrivilegesController@columnList');//权限-栏目列表
        Route::post('v1/Privileges/modelList', 'SystemsManage\PrivilegesController@modelList');//权限-左侧列表
        Route::post('v1/Privileges/rolePrivileges', 'SystemsManage\PrivilegesController@rolePrivileges');//权限-角色对应展示的权限
        
        // 运营系统 -- 小程序权限
        Route::post('v1/AppletPrivileges/index', 'SystemsManage\AppletPrivilegesController@index');//权限-列表
        Route::post('v1/AppletPrivileges/addModel', 'SystemsManage\AppletPrivilegesController@addModel');//权限-添加模块
        Route::post('v1/AppletPrivileges/add', 'SystemsManage\AppletPrivilegesController@add');//权限-添加栏目
        Route::post('v1/AppletPrivileges/addList', 'SystemsManage\AppletPrivilegesController@addList');//权限-添加列表
        Route::post('v1/AppletPrivileges/addFunction', 'SystemsManage\AppletPrivilegesController@addFunction');//权限-添加动作
        Route::post('v1/AppletPrivileges/edit', 'SystemsManage\AppletPrivilegesController@edit');//权限-编辑
        Route::post('v1/AppletPrivileges/del', 'SystemsManage\AppletPrivilegesController@del');//权限-删除
        Route::post('v1/AppletPrivileges/columnList', 'SystemsManage\AppletPrivilegesController@columnList');//权限-栏目列表
        Route::post('v1/AppletPrivileges/modelList', 'SystemsManage\AppletPrivilegesController@modelList');//权限-左侧列表
        Route::post('v1/AppletPrivileges/rolePrivileges', 'SystemsManage\AppletPrivilegesController@rolePrivileges');//权限-角色对应展示的权限
        Route::post('v1/AppletPrivileges/getInfo', 'SystemsManage\AppletPrivilegesController@getInfo');//权限-获取单条记录

        // 财务系统 -- 速电账单
        Route::post('v2/BillContrast/index', 'AccountManage\BillContrastController@index');
        Route::post('v2/BillContrast/affirm', 'AccountManage\BillContrastController@affirm'); //账单确认
        Route::post('v2/BillContrast/look', 'AccountManage\BillContrastController@look'); //查看账单

        // 工单账单【已废弃】
        Route::post('v2/WorkBill/index', 'AccountManage\WorkBillController@index'); //列表
        Route::post('v2/WorkBill/billNumber', 'AccountManage\WorkBillController@billNumber'); //单量
        // 采购账单【已废弃】
        Route::post('v2/ProcurementBill/index', 'AccountManage\ProcurementBillController@index'); //列表
        Route::post('v2/ProcurementBill/billNumber', 'AccountManage\ProcurementBillController@billNumber'); //单量
        // 销售账单【已废弃】
        Route::post('v2/SellBill/index', 'AccountManage\SellBillController@index'); //列表
        Route::post('v2/SellBill/billNumber', 'AccountManage\SellBillController@billNumber'); //单量

        // 售后管理
        // 订单售后
        // AfterSale/OrderAfterSale
        Route::post('v2/OrderAfter/index', 'AfterSaleManage\OrderAfterSaleController@index'); //订单售后-列表
        Route::post('v2/OrderAfter/cancel', 'AfterSaleManage\OrderAfterSaleController@cancel'); //订单售后-取消售后
        Route::post('v2/OrderAfter/dispose', 'AfterSaleManage\OrderAfterSaleController@dispose'); //订单售后-售后处理
        Route::post('v2/OrderAfter/info', 'AfterSaleManage\OrderAfterSaleController@info'); //订单售后-详情
        Route::post('v2/OrderAfter/finish', 'AfterSaleManage\OrderAfterSaleController@finish'); //订单售后-售后完成
        Route::post('v2/OrderAfter/remark', 'AfterSaleManage\OrderAfterSaleController@remark'); //订单售后-备注

        // 采购入库【已废弃】
        Route::post('v2/Procurement/index', 'WarehouseManage\ProcurementController@index'); //采购入库-列表
        Route::post('v2/Procurement/save', 'WarehouseManage\ProcurementController@save'); //采购入库-提交
        Route::post('v2/Procurement/add', 'WarehouseManage\ProcurementController@add'); //采购入库-提交并清点入库
        Route::post('v2/Procurement/edit', 'WarehouseManage\ProcurementController@edit'); //采购入库-编辑
        Route::post('v2/Procurement/info', 'WarehouseManage\ProcurementController@info'); //采购入库-详情
        Route::post('v2/Procurement/warehouseInfo', 'WarehouseManage\ProcurementController@warehouseInfo'); //获取采购仓库信息
        Route::post('v2/Procurement/pass', 'WarehouseManage\ProcurementController@pass'); //采购入库-通过
        Route::post('v2/Procurement/reject', 'WarehouseManage\ProcurementController@reject'); //采购入库-驳回
        Route::post('v2/Procurement/submitStorage', 'WarehouseManage\ProcurementController@submitStorage'); //采购入库-提交入库
        Route::post('v2/Procurement/scanRecord', 'WarehouseManage\ProcurementController@scanRecord'); //采购入库-扫码记录
        Route::post('v2/Procurement/deleteRecord', 'WarehouseManage\ProcurementController@deleteRecord'); //采购入库-删除扫码记录
        Route::post('v2/Procurement/searchRecord', 'WarehouseManage\ProcurementController@searchRecord'); //采购入库-商品搜索记录
        Route::post('v2/Procurement/originalRecord', 'WarehouseManage\ProcurementController@originalRecord'); //采购入库-原单入库
        Route::post('v2/Procurement/searchBill', 'WarehouseManage\ProcurementController@searchBill'); //采购入库-生成账单搜索
        Route::post('v2/Procurement/createBill', 'WarehouseManage\ProcurementController@createBill'); //采购入库-生成账单
        Route::post('v2/Procurement/print', 'WarehouseManage\ProcurementController@print'); //采购入库-打印
        Route::post('v2/Procurement/partStorage', 'WarehouseManage\ProcurementController@partStorage'); //采购入库-部分入库

        // 仓储系统 -- 销售出库
        Route::post('v3/Sell/index', 'WarehouseManage\SellController@index'); //销售出库-列表
        Route::post('v3/Sell/save', 'WarehouseManage\SellController@save'); //销售出库-保存
        Route::post('v3/Sell/add', 'WarehouseManage\SellController@add'); //销售出库-提交并备货出库
        Route::post('v3/Sell/edit', 'WarehouseManage\SellController@edit'); //销售出库-编辑
        Route::post('v3/Sell/info', 'WarehouseManage\SellController@info'); //销售出库-详情
        Route::post('v3/Sell/submit', 'WarehouseManage\SellController@submit'); //销售出库-提交
        Route::post('v3/Sell/audit', 'WarehouseManage\SellController@audit'); //销售出库-审核
        Route::post('v3/Sell/submitStorage', 'WarehouseManage\SellController@submitStorage'); //销售出库-提交出库
        Route::post('v3/Sell/originalRecord', 'WarehouseManage\SellController@originalRecord'); //销售出库-原单出库
        Route::post('v3/Sell/warehouseInfo', 'WarehouseManage\SellController@warehouseInfo'); //获取出库仓库信息
        Route::post('v3/Sell/scanRecord', 'WarehouseManage\SellController@scanRecord'); //销售出库-扫码记录
        Route::post('v3/Sell/deleteRecord', 'WarehouseManage\SellController@deleteRecord'); //销售出库-删除扫码记录
        Route::post('v3/Sell/searchRecord', 'WarehouseManage\SellController@searchRecord'); //销售出库-添加商品搜索记录
        Route::post('v3/Sell/searchGoods', 'WarehouseManage\SellController@searchGoods'); //销售出库-搜索出库仓库商品
        Route::post('v3/Sell/searchBill', 'WarehouseManage\SellController@searchBill'); // 销售出库-生成账单搜索
        Route::post('v3/Sell/createBill', 'WarehouseManage\SellController@createBill'); // 销售出库-生成账单
        Route::post('v3/Sell/partStorage', 'WarehouseManage\SellController@partStorage'); // 销售出库-部分出库
        Route::post('v3/Sell/print', 'WarehouseManage\SellController@print'); // 销售出库-打印
        Route::post('v3/Sell/export', 'WarehouseManage\SellController@export'); // 销售出库-导出
        Route::post('v3/Sell/printNumber', 'WarehouseManage\SellController@printNumber'); // 销售出库-打印次数提交
        Route::post('v3/Sell/audit', 'WarehouseManage\SellController@audit'); //销售出库-审核
        Route::post('v3/Sell/sellSettlement', 'WarehouseManage\SellController@sellSettlement'); //销售出库-销售单结算
        Route::post('v3/Sell/sellRecord', 'WarehouseManage\SellController@sellRecord'); //出库记录

        // 运营系统 -- 客户车辆
        Route::post('v2/MemberCar/index', 'MemberManage\MemberCarController@index'); //会员车辆-列表
        Route::post('v2/MemberCar/add', 'MemberManage\MemberCarController@add'); //会员车辆-新增
        Route::post('v2/MemberCar/edit', 'MemberManage\MemberCarController@edit'); //会员车辆-编辑
        Route::post('v2/MemberCar/info', 'MemberManage\MemberCarController@info'); //会员车辆-详情
        Route::post('v2/MemberCar/delete', 'MemberManage\MemberCarController@delete'); //会员车辆-删除
        Route::post('v2/MemberCar/searchMember', 'MemberManage\MemberCarController@searchMember'); //会员车辆-搜索会员

        // 门店车辆
        Route::post('v2/ShoprCar/index', 'SystemsManage\ShoprCarController@index'); //门店车辆-列表
        Route::post('v2/ShoprCar/add', 'SystemsManage\ShoprCarController@add'); //门店车辆-新增
        Route::post('v2/ShoprCar/edit', 'SystemsManage\ShoprCarController@edit'); //门店车辆-编辑
        Route::post('v2/ShoprCar/info', 'SystemsManage\ShoprCarController@info'); //门店车辆-查看
        Route::post('v2/ShoprCar/delete', 'SystemsManage\ShoprCarController@delete'); //门店车辆-删除
        Route::post('v2/ShoprCar/searchShopCar', 'SystemsManage\ShoprCarController@searchShopCar'); //门店车辆-搜索车辆

        // 仓储系统 -- 旧货回收
        Route::post('v2/Recycling/index', 'recycleManage\RecyclingController@index'); //列表
        Route::post('v2/Recycling/add', 'recycleManage\RecyclingController@add'); //新增
        Route::post('v2/Recycling/affirm', 'recycleManage\RecyclingController@affirm'); //回收入库
        Route::post('v2/Recycling/audit', 'recycleManage\RecyclingController@audit'); //回收审核
        Route::post('v2/Recycling/edit', 'recycleManage\RecyclingController@edit'); //编辑
        Route::post('v2/Recycling/recycle', 'recycleManage\RecyclingController@recycle'); //回收
        Route::post('v2/Recycling/noRecycle', 'recycleManage\RecyclingController@noRecycle'); //不回收
        Route::post('v2/Recycling/del', 'recycleManage\RecyclingController@del'); //删除
        Route::post('v2/Recycling/remark', 'recycleManage\RecyclingController@remark'); //备注
        Route::post('v2/Recycling/searchAll', 'recycleManage\RecyclingController@searchAll'); //需要搜索的数据
        Route::post('v2/Recycling/details', 'recycleManage\RecyclingController@details'); //详情
        Route::post('v3/Recycling/labelPrint', 'recycleManage\RecyclingController@labelPrint'); //标签打印详情
        Route::post('v3/Recycling/print', 'recycleManage\RecyclingController@print'); //标签打印
        Route::post('v3/Recycling/searchGoods', 'recycleManage\RecyclingController@searchGoods'); //搜索商品
        Route::post('v3/Recycling/export', 'recycleManage\RecyclingController@export'); //搜索商品
        Route::post('v3/Recycling/infoPrint', 'recycleManage\RecyclingController@infoPrint'); //详情打印
        Route::post('v3/Recycling/infoPrintNumber', 'recycleManage\RecyclingController@infoPrintNumber'); //详情打印-打印次数提交
        Route::post('v3/Recycling/revocation', 'recycleManage\RecyclingController@revocation'); //撤销

        // 仓储系统 -- 退换入库
        Route::post('v2/RecedeRecycle/index', 'recycleManage\RecedeRecycleController@index'); //列表
        Route::post('v2/RecedeRecycle/add', 'recycleManage\RecedeRecycleController@add'); //新增
        Route::post('v2/RecedeRecycle/edit', 'recycleManage\RecedeRecycleController@edit'); //编辑
        Route::post('v2/RecedeRecycle/del', 'recycleManage\RecedeRecycleController@del'); //删除
        Route::post('v2/RecedeRecycle/recycle', 'recycleManage\RecedeRecycleController@recycle'); //回收
        Route::post('v2/RecedeRecycle/remark', 'recycleManage\RecedeRecycleController@remark'); //备注
        Route::post('v2/RecedeRecycle/details', 'recycleManage\RecedeRecycleController@details'); //详情

        Route::post('v2/OrderBill/settleAccounts', 'AccountManage\OrderBillController@settleAccounts'); //订单账单结款
        Route::post('v2/WorkBill/settleAccounts', 'AccountManage\WorkBillController@settleAccounts'); //工单账单结款
        Route::post('v2/ProcurementBill/settleAccounts', 'AccountManage\ProcurementBillController@settleAccounts'); //采购账单结款
        Route::post('v2/SellBill/settleAccounts', 'AccountManage\SellBillController@settleAccounts'); //销售账单结款

        // 仓库管理 -- 调拨单
        Route::post('v3/TransferringOrders/index', 'WarehouseManage\TransferringOrdersController@index'); //调拨单-列表
        Route::post('v3/TransferringOrders/info', 'WarehouseManage\TransferringOrdersController@info'); //调拨单-详情查看
        Route::post('v3/TransferringOrders/add', 'WarehouseManage\TransferringOrdersController@add'); //调拨单-生成调拨单
        Route::post('v3/TransferringOrders/delete', 'WarehouseManage\TransferringOrdersController@delete'); //调拨单-删除
        Route::post('v3/TransferringOrders/audit', 'WarehouseManage\TransferringOrdersController@audit'); //调拨单-审核
        Route::post('v3/TransferringOrders/delivery', 'WarehouseManage\TransferringOrdersController@delivery'); //调拨单-出库
        Route::post('v3/TransferringOrders/putInStorage', 'WarehouseManage\TransferringOrdersController@putInStorage'); //调拨单-入库
        Route::post('v3/TransferringOrders/revocation', 'WarehouseManage\TransferringOrdersController@revocation'); //调拨单-撤销
        Route::post('v3/TransferringOrders/searchGoods', 'WarehouseManage\TransferringOrdersController@searchGoods'); //调拨单-搜索商品
        Route::post('v3/TransferringOrders/print', 'WarehouseManage\TransferringOrdersController@print'); //调拨单-打印
        Route::post('v3/TransferringOrders/export', 'WarehouseManage\TransferringOrdersController@export'); //调拨单-导出
        Route::post('v3/TransferringOrders/edit', 'WarehouseManage\TransferringOrdersController@edit'); //编辑

        // 财务系统 -- 销售统计
        Route::post('v3/SalesStatistics/index', 'SalesManagement\SalesStatisticsController@index'); //列表

        // 运营系统 -- 活动列表【暂时用不到】
        Route::post('v3/ActivityLists/index', 'ActivityManagements\ActivityListsController@index'); //活动列表-列表
        Route::post('v3/ActivityLists/info', 'ActivityManagements\ActivityListsController@info'); //活动列表-详情查看
        Route::post('v3/ActivityLists/add', 'ActivityManagements\ActivityListsController@add'); //活动列表-新增
        Route::post('v3/ActivityLists/delete', 'ActivityManagements\ActivityListsController@delete'); //活动列表-删除
        Route::post('v3/ActivityLists/start', 'ActivityManagements\ActivityListsController@start'); //活动列表-启动
        Route::post('v3/ActivityLists/publish', 'ActivityManagements\ActivityListsController@publish'); //活动列表-发布
        Route::post('v3/ActivityLists/unpublish', 'ActivityManagements\ActivityListsController@unpublish'); //活动列表-撤销发布
        Route::post('v3/ActivityLists/terminate', 'ActivityManagements\ActivityListsController@terminate'); //活动列表-终止
        Route::post('v3/ActivityLists/details', 'ActivityManagements\ActivityListsController@details'); //活动列表-明细
        Route::post('v3/ActivityLists/searchActivity', 'ActivityManagements\ActivityListsController@searchActivity'); //活动列表-搜索活动名称
        Route::post('v3/ActivityLists/searchActivityDetails', 'ActivityManagements\ActivityListsController@searchActivityDetails'); //活动列表-搜索活动详情
        Route::post('v3/ActivityLists/searchDefaultDetails', 'ActivityManagements\ActivityListsController@searchDefaultDetails'); //活动列表-搜索活动默认数据
        Route::post('v3/ActivityLists/searchGoods', 'ActivityManagements\ActivityListsController@searchGoods'); //搜索商品
        Route::post('v3/ActivityLists/searchBrand', 'ActivityManagements\ActivityListsController@searchBrand'); //搜索品牌
        Route::post('v3/ActivityLists/searchCategory', 'ActivityManagements\ActivityListsController@searchCategory'); //搜索品类

        // 仓储系统 -- 采购管理
        Route::post('v3/PurchaseOrder/index', 'Purchase\PurchaseOrderController@index');  //采购系统--采购管理页面
        Route::post('v3/PurchaseOrder/add', 'Purchase\PurchaseOrderController@add');          //添加
        Route::post('v3/PurchaseOrder/searchShopinfo', 'Purchase\PurchaseOrderController@searchShopinfo'); //添加时查询上级供货方信息
        Route::post('v3/PurchaseOrder/uploadFile', 'Purchase\PurchaseOrderController@uploadFile'); //采购导入商品接口
        Route::post('v3/PurchaseOrder/submitAudit', 'Purchase\PurchaseOrderController@submitAudit');  //提交审核
        Route::post('v3/PurchaseOrder/edit', 'Purchase\PurchaseOrderController@edit');        //编辑
        Route::post('v3/PurchaseOrder/twiceEdit', 'Purchase\PurchaseOrderController@twiceEdit'); //二次编辑【废弃】
        Route::post('v3/PurchaseOrder/audit', 'Purchase\PurchaseOrderController@audit');        //审核
        Route::post('v3/PurchaseOrder/look', 'Purchase\PurchaseOrderController@look');          //查看
        Route::post('v3/PurchaseOrder/delete', 'Purchase\PurchaseOrderController@delete'); //删除
        Route::post('v3/PurchaseOrder/exportExcel', 'Purchase\PurchaseOrderController@exportExcel');      //导出
        Route::post('v3/PurchaseOrder/getList', 'Purchase\PurchaseOrderController@getList');  //生成账单
        Route::post('v3/PurchaseOrder/generateBill', 'Purchase\PurchaseOrderController@generateBill');  //生成账单
        Route::post('v3/PurchaseOrder/purchasement', 'Purchase\PurchaseOrderController@purchasement');  //结算
        Route::post('v3/PurchaseOrder/cancelrefund', 'Purchase\PurchaseOrderController@cancelrefund');  //撤销采购退货
        Route::post('v3/PurchaseOrder/suspend', 'Purchase\PurchaseOrderController@suspend');  //中止
        Route::post('v3/PurchaseOrder/getChannelUnit', 'Purchase\PurchaseOrderController@getChannelUnit');  //获取供货商信息
        Route::post('v3/PurchaseOrder/financialAudit', 'Purchase\PurchaseOrderController@financialAudit');   //财务审核
        Route::post('v3/PurchaseOrder/confirmCompleted', 'Purchase\PurchaseOrderController@confirmCompleted'); //确认完成
        Route::post('v3/PurchaseOrder/returnGoods', 'Purchase\PurchaseOrderController@returnGoods'); //退货
        Route::post('v3/PurchaseOrder/exchanGoods', 'Purchase\PurchaseOrderController@exchanGoods'); //换货【废弃】
        Route::post('v3/PurchaseOrder/info', 'Purchase\PurchaseOrderController@info'); //详情
        Route::post('v3/PurchaseOrder/relieveAccount', 'Purchase\PurchaseOrderController@relieveAccount'); //解除封账期
        Route::post('v3/PurchaseOrder/purchaseVoucher', 'Purchase\PurchaseOrderController@purchaseVoucher'); //生成凭证
        Route::post('v3/PurchaseOrder/akeyProcurement', 'Purchase\PurchaseOrderController@akeyProcurement'); //一键采购
        Route::post('v3/PurchaseOrder/searchGoods', 'Purchase\PurchaseOrderController@searchGoods'); //商品查询
        Route::post('v3/PurchaseOrder/downTemplate', 'Purchase\PurchaseOrderController@downTemplate'); //模板地址
        Route::post('v3/PurchaseOrder/setPurchaseOrder', 'Purchase\PurchaseOrderController@setPurchaseOrder'); //采购流程设置

        // 采购系统 -- 采购计划
        Route::post('v3/PurchasePlan/index', 'Purchase\PurchasePlanController@index');    //采购系统--采购计划页面
        Route::post('v3/PurchasePlan/turnPurchase', 'Purchase\PurchasePlanController@turnPurchase');      //转采购
        Route::post('v3/PurchasePlan/add', 'Purchase\PurchasePlanController@add');      //添加采购计划
        Route::post('v3/PurchasePlan/exportExcel', 'Purchase\PurchasePlanController@exportExcel');  //导出

        // 仓储系统 -- 入库列表
        Route::post('v3/WareInorder/index', 'Storage\WareInorderController@index'); //库房系统--入库列表页面
        Route::post('v3/WareInorder/wareRecord', 'Purchase\PurchaseOrderController@look'); //记录
        Route::post('v3/WareInorder/warehousing', 'Storage\WareInorderController@Warehousing'); //入库
        Route::post('v3/WareInorder/delivery', 'Storage\WareInorderController@delivery'); //出库
        Route::post('v3/WareInorder/info', 'Storage\WareInorderController@info'); //详情
        Route::post('v3/WareInorder/exchanGoods', 'Storage\WareInorderController@exchanGoods'); //换货
        Route::post('v3/WareInorder/exportExcel', 'Storage\WareInorderController@exportExcel'); //导出

        // 分销系统 -- 分销管理【暂时用不到】
        Route::post("v3/Distribution/index", "Distribution\DistributionController@index"); //分销系统--分销管理页面
        Route::post("v3/Distribution/add", "Distribution\DistributionController@add");    //添加
        Route::post("v3/Distribution/deliveryRecord", "Distribution\DistributionController@deliveryRecord"); //发货记录
        Route::post("v3/Distribution/generateBill", "Distribution\DistributionController@generateBill"); //生成账单
        Route::post("v3/Distribution/exportExcel", "Distribution\DistributionController@exportExcel");    //导出
        Route::post("v3/Distribution/retrievaDistribu", "Distribution\DistributionController@retrievaDistribu"); //根据来往单位，账单日期来检索已经完成，并且未生成账单的分销单

        // 数据查询
        // 车型查询
        // Route::post("v3/VehicleInquire/index", "DataSearch\VehicleInquireController@index"); //车型查询列表
        Route::post('v3/VehicleInquire/correction', 'DataSearch\VehicleInquireController@correction'); //车型查询-纠错
        // 锁定库存的订单
        Route::post('v3/LockGoodsOrder/queryList', 'DataSearch\LockGoodsOrderController@queryList'); //查询锁定库存商品对应的订单
        // 业务系统-快速查询-商品查询
        Route::post('v3/GoodsInventory/goodsIndex', 'DataSearch\GoodsInventoryController@goodsIndex'); //商品查询
        Route::post('v3/GoodsInventory/goodsStockIndex', 'DataSearch\GoodsInventoryController@goodsStockIndex'); //商品库存查询
        // 业务系统 -- 库存查询
        Route::post("v3/InventoryInquiry/index", "InventoryManage\InventoryInquiryController@index"); //库存查询列表

        // 售后管理 -- 售后标签
        Route::post('v3/AfterLabel/index', 'AfterSaleManage\AfterLabelController@index'); //列表
        Route::post('v3/AfterLabel/add', 'AfterSaleManage\AfterLabelController@add'); //新增
        Route::post('v3/AfterLabel/edit', 'AfterSaleManage\AfterLabelController@edit'); //编辑
        Route::post('v3/AfterLabel/start', 'AfterSaleManage\AfterLabelController@start'); //启用
        Route::post('v3/AfterLabel/stop', 'AfterSaleManage\AfterLabelController@stop'); //停用
        Route::post('v3/AfterLabel/delete', 'AfterSaleManage\AfterLabelController@delete'); //删除
        Route::post('v3/AfterLabel/getAfterLabel', 'AfterSaleManage\AfterLabelController@getAfterLabel'); //获取售后标签数据

        // 售后管理 -- 订单售后
        Route::post('v3/OrderAfter/index', 'AfterSaleManage\OrderAfterController@index'); //列表
        Route::post('v3/OrderAfter/sendOrders', 'AfterSaleManage\OrderAfterController@sendOrders'); //派单
        Route::post('v3/OrderAfter/afterNote', 'AfterSaleManage\OrderAfterController@afterNote'); //售后备注
        Route::post('v3/OrderAfter/afterNoteList', 'AfterSaleManage\OrderAfterController@afterNoteList'); //售后备注列表
        Route::post('v3/OrderAfter/lock', 'AfterSaleManage\OrderAfterController@lock'); //锁定
        Route::post('v3/OrderAfter/unlock', 'AfterSaleManage\OrderAfterController@unlock'); //取消锁定
        Route::post('v3/OrderAfter/dailyFeedback', 'AfterSaleManage\OrderAfterController@dailyFeedback'); //日常反馈
        Route::post('v3/OrderAfter/dailyFeedbackList', 'AfterSaleManage\OrderAfterController@dailyFeedbackList'); //日常反馈列表
        Route::post('v3/OrderAfter/reminder', 'AfterSaleManage\OrderAfterController@reminder'); //催单
        Route::post('v3/OrderAfter/cancel', 'AfterSaleManage\OrderAfterController@cancel'); //取消售后
        Route::post('v3/OrderAfter/settlement', 'AfterSaleManage\OrderAfterController@settlement'); //结算
        Route::post('v3/OrderAfter/export', 'AfterSaleManage\OrderAfterController@export'); //导出
        Route::post('v3/OrderAfter/info', 'AfterSaleManage\OrderAfterController@info'); //售后详情
        Route::post('v3/OrderAfter/orderInfo', 'AfterSaleManage\OrderAfterController@orderInfo'); //订单详情
        Route::post('v3/OrderAfter/pass', 'AfterSaleManage\OrderAfterController@pass'); //审核通过
        Route::post('v3/OrderAfter/runningRoute', 'AfterSaleManage\OrderAfterController@runningRoute'); //行驶轨迹
        Route::post('v3/OrderAfter/feedback', 'AfterSaleManage\OrderAfterController@feedback'); //售后处理

        // 信息提示
        Route::post("v3/InformationHint/index", "InformationHint\InformationHintController@index"); //信息提示-查询
        Route::post("v3/InformationHint/changeState", "InformationHint\InformationHintController@changeState"); //信息提示-更改状态
        Route::post("v3/InformationHint/getPopup", "InformationHint\InformationHintController@getPopup"); //信息提示-获取弹出提示信息
        Route::post("v3/InformationHint/getHintMessage", "InformationHint\InformationHintController@getHintMessage"); //信息提示-获取弹出提示信息

        // 财务系统 -- 网单查询
        Route::post('v3/NetSingle/index', 'AccountControl\NetSingleController@index'); //列表

        // 仓储系统 - 商品流水记录
        Route::post('v3/GoodsRecord/index', 'WarehouseManage\GoodsRecordController@index'); //列表
        Route::post('v3/GoodsRecord/export', 'WarehouseManage\GoodsRecordController@export'); //导出

        // 仓储系统 - 库存锁定-出入库记录
        Route::post('v3/lockGoodsRecord/index', 'WarehouseManage\lockGoodsRecordController@index'); //列表
        Route::post('v3/lockGoodsRecord/export', 'WarehouseManage\lockGoodsRecordController@export'); //导出

        // 运营系统 -- 虚拟加盟店相关路由
        Route::post('v3/VirtualStores/index', 'SystemsManage\VirtualStoresController@index'); //虚拟加盟店列表
        Route::post('v3/VirtualStores/add', 'SystemsManage\VirtualStoresController@add'); //添加虚拟加盟店
        Route::post('v3/VirtualStores/edit', 'SystemsManage\VirtualStoresController@edit'); //编辑
        Route::post('v3/VirtualStores/start', 'SystemsManage\VirtualStoresController@start'); //启用
        Route::post('v3/VirtualStores/stop', 'SystemsManage\VirtualStoresController@stop'); //停用
        Route::post('v3/VirtualStores/accountList', 'SystemsManage\VirtualStoresController@accountList'); //账号列表
        Route::post('v3/VirtualStores/addAccount', 'SystemsManage\VirtualStoresController@addAccount'); //添加技师
        Route::post('v3/VirtualStores/startAccount', 'SystemsManage\VirtualStoresController@startAccount'); //启用技师
        Route::post('v3/VirtualStores/stopAccount', 'SystemsManage\VirtualStoresController@stopAccount'); //停用技师
        Route::post('v3/VirtualStores/searchingAccount', 'SystemsManage\VirtualStoresController@searchingAccount'); //检索技师
        Route::post('v3/VirtualStores/lookAccount', 'SystemsManage\VirtualStoresController@lookAccount'); //查看技师

        // 财务系统 -- 销售统计Dou
        Route::post('v3/DataStatistical/index', 'DataStatistical\DataStatisticalController@index'); //列表页
        Route::post('v3/DataStatistical/export', 'DataStatistical\DataStatisticalController@export'); //导出
        Route::post('v3/DataStatistical/headData', 'DataStatistical\DataStatisticalController@headData'); //导出

        // 财务系统 -- 凭证列表
        Route::post('v3/VoucherReceipts/index', 'AccountControl\VoucherReceiptsController@index'); //列表
        Route::post('v3/VoucherReceipts/sync', 'AccountControl\VoucherReceiptsController@sync'); //同步
        Route::post('v3/VoucherReceipts/info', 'AccountControl\VoucherReceiptsController@info'); //详情
        Route::post('v3/VoucherReceipts/remarks', 'AccountControl\VoucherReceiptsController@remarks'); //备注
        Route::post('v3/VoucherReceipts/delete', 'AccountControl\VoucherReceiptsController@delete'); //删除

        // 财务系统 -- 对单列表
        Route::post('v3/MatchOrder/index', 'AccountControl\MatchOrderController@index'); //列表
        Route::post('v3/MatchOrder/affirm', 'AccountControl\MatchOrderController@affirm'); //确认
        Route::post('v3/MatchOrder/unAffirm', 'AccountControl\MatchOrderController@unAffirm'); //取消确认
        Route::post("v3/MatchOrder/print", "AccountControl\MatchOrderController@print"); //打印
        Route::post("v3/MatchOrder/export", "AccountControl\MatchOrderController@export"); //导出

        // 财务系统 -- 业绩明细
        Route::post('v3/Performance/index', 'SystemsManage\PerformanceController@index'); //列表
        Route::post('v3/Performance/export', 'SystemsManage\PerformanceController@export'); //导出

        // 财务系统 -- 短信模块
        Route::post('v3/NoteMessage/index', 'AccountControl\NoteMessageController@index'); //列表

        // 退货管理-退货管理
        Route::post('v1/ReturnGoods/add', 'ReturnGoodsManage\ReturnGoodsController@add'); //退货管理-添加退货单
        Route::post('v1/ReturnGoods/getInfo', 'ReturnGoodsManage\ReturnGoodsController@getInfo'); //退货管理-获取订单信息
        Route::post('v1/ReturnGoods/index', 'ReturnGoodsManage\ReturnGoodsController@index'); //退货管理-列表
        Route::post('v1/ReturnGoods/payment', 'ReturnGoodsManage\ReturnGoodsController@payment'); //退货管理-打款记录
        Route::post('v1/ReturnGoods/recovery', 'ReturnGoodsManage\ReturnGoodsController@recovery'); //退货管理-回收记录
        Route::post('v1/ReturnGoods/revoke', 'ReturnGoodsManage\ReturnGoodsController@revoke'); //退货管理-撤销

        // 退货管理-退款管理
        Route::post('v1/RefundGoods/index', 'ReturnGoodsManage\RefundGoodsController@index'); //退货管理-列表
        Route::post('v1/RefundGoods/edit', 'ReturnGoodsManage\RefundGoodsController@edit'); //退货管理-修改
        Route::post('v1/RefundGoods/getStatusList', 'ReturnGoodsManage\RefundGoodsController@getStatusList'); //退货管理-状态下拉

        // 消息推送
        Route::post('v1/PushMessage/add', 'Push\PushMessageController@add'); //新增推送消息
        Route::post('v1/PushMessage/delete', 'Push\PushMessageController@delete'); //删除推送消息

        // 公共搜索方法
        Route::post('v3/PublicSearch/searchSalesman', 'PublicsManage\PublicSearchController@searchSalesman'); //搜索业务员
        Route::post('v3/PublicSearch/searchTechnician', 'PublicsManage\PublicSearchController@searchTechnician'); //搜索服务技师
        Route::post('v3/PublicSearch/searchGoods', 'PublicsManage\PublicSearchController@searchGoods'); //搜索商品
        Route::post('v3/PublicSearch/findImageUploadPrivilege', 'PublicsManage\PublicSearchController@findImageUploadPrivilege'); //查询图片上传模板权限
        Route::post('v3/PublicSearch/searchUniqueString', 'PublicsManage\PublicSearchController@searchUniqueString'); //生成订单的唯一标识
        Route::post('v3/PublicSearch/searchFreightGoods', 'PublicsManage\PublicSearchController@searchFreightGoods'); //搜索仓位商品
        Route::post('v3/PublicSearch/searchHistoricalPrice', 'PublicsManage\PublicSearchController@searchHistoricalPrice'); //搜索历史价格
        Route::post('v3/PublicSearch/searchWashService', 'PublicsManage\PublicSearchController@searchWashService'); //洗美-搜索施工项目接口
        Route::post('v3/PublicSearch/searchWashGooods', 'PublicsManage\PublicSearchController@searchWashGooods'); //洗美-搜索商品接口
        Route::post('v3/PublicSearch/searchPersonel', 'PublicsManage\PublicSearchController@searchPersonel'); //洗美-搜索人员接口
        Route::post('v3/PublicSearch/searchWashMember', 'PublicsManage\PublicSearchController@searchWashMember'); //洗美-搜索会员
        Route::post('v3/PublicSearch/searchExaminationItem', 'PublicsManage\PublicSearchController@searchExaminationItem'); //洗美-搜索考核项
        Route::post('v3/PublicSearch/searchQualityInspectionItem', 'PublicsManage\PublicSearchController@searchQualityInspectionItem'); //洗美-搜索质检项
        Route::post('v3/PublicSearch/getParts', 'PublicsManage\PublicSearchController@getParts'); //洗美-获取部位

        // 财务系统 -- 发送短信的模板设置相关路由
        Route::post('v3/NoteMessage/listTemplate', 'AccountControl\NoteMessageController@listTemplate'); //模板列表
        Route::post('v3/NoteMessage/addTemplate', 'AccountControl\NoteMessageController@addTemplate'); //添加模板
        Route::post('v3/NoteMessage/editTemplate', 'AccountControl\NoteMessageController@editTemplate'); //编辑模板
        Route::post('v3/NoteMessage/deleteTemplate', 'AccountControl\NoteMessageController@deleteTemplate'); //删除模板
        Route::post('v3/NoteMessage/listModule', 'AccountControl\NoteMessageController@listModule'); //短信模块
        Route::post('v3/NoteMessage/binding', 'AccountControl\NoteMessageController@binding'); //绑定
        Route::post('v3/NoteMessage/stopModule', 'AccountControl\NoteMessageController@stopModule'); //停用
        Route::post('v3/NoteMessage/startModule', 'AccountControl\NoteMessageController@startModule'); //启用
        Route::post('v3/NoteMessage/listPay', 'AccountControl\NoteMessageController@listPay'); //支付记录

        Route::any('v3/NotePay/index', 'AccountControl\NotePayController@index'); //支付记录
    });

    Route::post('v1/PushMessage/pushApp', 'Push\PushMessageController@pushApp'); //APP推送
    Route::post('v2/BillContrast/reject', 'AccountManage\BillContrastController@reject'); //速电账单撤销

    // 运行系统 -- 业务划区
    Route::group(['middleware' => ['islogin']], function () {
        // 业务划区列表
        Route::post('v3/Precincts/index', 'RegionManage\PrecinctsController@index'); //列表
        Route::post('v3/Precincts/add', 'RegionManage\PrecinctsController@add'); //添加
        Route::post('v3/Precincts/edit', 'RegionManage\PrecinctsController@edit'); //编辑
        Route::post('v3/Precincts/start', 'RegionManage\PrecinctsController@start'); //启用
        Route::post('v3/Precincts/stop', 'RegionManage\PrecinctsController@stop'); //停用
    });

    // 渠道商补货功能路由
    Route::group(['middleware' => ['islogin']], function () {
        Route::post('g1/ReplenishmentsGoods/index', 'DistributorsManages\ReplenishmentsGoodsController@index'); //渠道补货商品
        Route::post('g1/DispatchingBills/index', 'DistributorsManages\DispatchingBillsController@index'); //配送账单列表
        Route::post('g1/DispatchingBills/indexExport', 'DistributorsManages\DispatchingBillsController@indexExport'); //配送账单列表导出
        Route::post('g1/DispatchingBills/remark', 'DistributorsManages\DispatchingBillsController@remark'); //配送账单列表备注
        Route::post('g1/DispatchingBills/recall', 'DistributorsManages\DispatchingBillsController@recall'); //配送账单列表账单撤回确认

        Route::post('g1/DispatchingBills/details', 'DistributorsManages\DispatchingBillsController@details'); //配送账单列表详情
        Route::post('g1/DispatchingBills/detailsExport', 'DistributorsManages\DispatchingBillsController@detailsExport'); //配送账单列表详情导出
        Route::post('g1/DispatchingBills/detailsRevocation', 'DistributorsManages\DispatchingBillsController@detailsRevocation'); //配送账单撤回
        Route::post('g1/DispatchingBills/shipmentState', 'DistributorsManages\DispatchingBillsController@shipmentState'); //配送账单列表详情配送状态
        //配送账单送货单列表
        Route::post('g1/DispatchingBills/deliveryList', 'DistributorsManages\DispatchingBillsController@deliveryList'); //配送账单送货单列表
        Route::post('g1/DispatchingBills/deliveryAdd', 'DistributorsManages\DispatchingBillsController@deliveryAdd'); //配送账单送货单列表新增送货单
        Route::post('g1/DispatchingBills/deliveryEdit', 'DistributorsManages\DispatchingBillsController@deliveryEdit'); //配送账单送货单列表新增送货单
        Route::post('g1/DispatchingBills/deliveryDetails', 'DistributorsManages\DispatchingBillsController@deliveryDetails'); //配送账单送货单商品列表
        Route::post('g1/DispatchingBills/deliveryRemark', 'DistributorsManages\DispatchingBillsController@deliveryRemark'); //配送账单送货单备注方法

        //渠道补货账单相关路由
        Route::post('g1/ReplenishBills/index', 'DistributorsManages\ReplenishBillsController@index'); //补货账单列表
        Route::post('g1/ReplenishBills/remark', 'DistributorsManages\ReplenishBillsController@remark'); //补货账单列表备注
        Route::post('g1/ReplenishBills/verification', 'DistributorsManages\ReplenishBillsController@verification'); //补货账单列表核销接口
        Route::post('g1/ReplenishBills/details', 'DistributorsManages\ReplenishBillsController@details'); //补货账单列表详情
        Route::post('g1/ReplenishBills/detailsExport', 'DistributorsManages\ReplenishBillsController@detailsExport'); //补货账单列表详情导出
        Route::post('g1/ReplenishBills/deliveryList', 'DistributorsManages\ReplenishBillsController@deliveryList'); //补货账单列表送货单列表
        Route::post('g1/ReplenishBills/deliveryDetails', 'DistributorsManages\ReplenishBillsController@deliveryDetails'); //补货账单列表送货单详情
        Route::post('g1/ReplenishBills/deliveryRemark', 'DistributorsManages\ReplenishBillsController@deliveryRemark'); //补货账单列表送货单详情
        Route::post('g1/ReplenishBills/takeDelivery', 'DistributorsManages\ReplenishBillsController@takeDelivery'); //补货账单列表送货单收货接口
        Route::post('g1/ReplenishBills/detailsRevocation', 'DistributorsManages\ReplenishBillsController@detailsRevocation'); //补货账单列表送货单撤销收货接口

        // 渠道残损申报模块
        Route::post('g1/DamagedReports/index', 'DistributorsManages\DamagedReportsController@index'); //渠道残损申报列表
        Route::post('g1/DamagedReports/details', 'DistributorsManages\DamagedReportsController@details'); //残损单详情
        Route::post('g1/DamagedReports/add', 'DistributorsManages\DamagedReportsController@add'); //新增残损单
        Route::post('g1/DamagedReports/edit', 'DistributorsManages\DamagedReportsController@edit'); //编辑残损单
        Route::post('g1/DamagedReports/delete', 'DistributorsManages\DamagedReportsController@delete'); //删除残损单
        Route::post('g1/DamagedReports/remark', 'DistributorsManages\DamagedReportsController@remark'); //备注残损单
        Route::post('g1/DamagedReports/revocation', 'DistributorsManages\DamagedReportsController@revocation'); //撤销残损单

        //残损补货模块
        Route::post('g1/DamagedReplenishs/index', 'DistributorsManages\DamagedReplenishsController@index'); //残损补货列表
        Route::post('g1/DamagedReplenishs/remark', 'DistributorsManages\DamagedReplenishsController@remark'); //残损补货备注
        Route::post('g1/DamagedReplenishs/details', 'DistributorsManages\DamagedReplenishsController@details'); //残损补货详情
        Route::post('g1/DamagedReplenishs/reportsDetails', 'DistributorsManages\DamagedReplenishsController@reportsDetails'); //残损单号详情
        Route::post('g1/DamagedReplenishs/takeDelivery', 'DistributorsManages\DamagedReplenishsController@takeDelivery'); //收货
    });

    // 门店补货功能相关路由
    Route::group(['middleware' => ['islogin']], function () {
        //门店补货账单
        Route::post('g1/SupplyBills/index', 'SupplyChains\SupplyBillsController@index'); //补货账单列表
        Route::post('g1/SupplyBills/details', 'SupplyChains\SupplyBillsController@details'); //补货账单列表详情
        Route::post('g1/SupplyBills/export', 'SupplyChains\SupplyBillsController@export'); //补货账单列表导出
        Route::post('g1/SupplyBills/remark', 'SupplyChains\SupplyBillsController@remark'); //备注接口
        Route::post('g1/SupplyBills/cancel', 'SupplyChains\SupplyBillsController@cancel'); //核销接口
        Route::post('g1/SupplyBills/deliveryList', 'SupplyChains\SupplyBillsController@deliveryList'); //补货账单送货单列表

        Route::post('g1/SupplyBills/scanCode', 'SupplyChains\SupplyBillsController@scanCode'); //收货单扫码收货

        Route::post('g1/SupplyBills/deliveryRemark', 'SupplyChains\SupplyBillsController@deliveryRemark'); //补货账单送货单列表备注
        Route::post('g1/SupplyBills/revocation', 'SupplyChains\SupplyBillsController@revocation'); //补货账单送货单列表撤销收货
        Route::post('g1/SupplyBills/takeDelivery', 'SupplyChains\SupplyBillsController@takeDelivery'); //补货账单收货单列表送货方法
        Route::post('g1/SupplyBills/deliveryDetails', 'SupplyChains\SupplyBillsController@deliveryDetails'); //补货账单收货单商品列表

        Route::post('g1/SupplyOrders/index', 'SupplyChains\SupplyOrdersController@index'); //补货订单列表
        Route::post('g1/SupplementedsGoods/index', 'SupplyChains\SupplementedsGoodsController@index'); //门店待补商品

        // 残损补货模块
        Route::post('g1/SpoiledReplenishs/index', 'SupplyChains\SpoiledReplenishsController@index'); //残损补货列表
        Route::post('g1/SpoiledReplenishs/details', 'SupplyChains\SpoiledReplenishsController@details'); //残损补货列表详情
        Route::post('g1/SpoiledReplenishs/reportsDetails', 'SupplyChains\SpoiledReplenishsController@reportsDetails'); //残损补货列表残损单号详情
        Route::post('g1/SpoiledReplenishs/remark', 'SupplyChains\SpoiledReplenishsController@remark'); //残损补货列表备注
        Route::post('g1/SpoiledReplenishs/takeDelivery', 'SupplyChains\SpoiledReplenishsController@takeDelivery'); //残损补货列表收货
    });

    // 速电派单
    Route::post('g1/DispatchingBills/getDeliveryBills', 'DistributorsManages\DispatchingBillsController@getDeliveryBills'); //获取配送账单信息
    Route::post('g1/SupplementedsGoods/goodsSurplus', 'SupplyChains\SupplementedsGoodsController@goodsSurplus'); //速电待补商品数量同步

    // 网单管理模块相关路由
    Route::group(['middleware' => ['islogin']], function () {
        // 网单管理 -- 网单商品
        Route::post('v3/PlatformGoodsLists/index', 'SystemPlatform\PlatformGoodsListsController@index'); //网单商品列表
        Route::post('v3/PlatformGoodsLists/sync', 'SystemPlatform\PlatformGoodsListsController@sync'); //同步
        Route::post('v3/PlatformGoodsLists/changeBindGoods', 'SystemPlatform\PlatformGoodsListsController@changeBindGoods'); //改绑商品
        Route::post('v3/PlatformGoodsLists/exportGoods', 'SystemPlatform\PlatformGoodsListsController@exportGoods'); //导出
        Route::post('v3/PlatformGoodsLists/importGoods', 'SystemPlatform\PlatformGoodsListsController@importGoods'); //导入
        Route::post('v3/PlatformGoodsLists/downTemplate', 'SystemPlatform\PlatformGoodsListsController@downTemplate'); //导入-下载模板

        //派单流程-订单相关
        Route::post('v3/OtherSystemOrders/orderReceiving', 'OtherSystemInterfaces\OtherSystemOrdersController@orderReceiving'); //接单
        Route::post('v3/OtherSystemOrders/cyorderReceiving', 'OtherSystemInterfaces\OtherSystemOrdersController@cyorderReceiving'); //门店接单
        Route::post('v3/OtherSystemOrders/orderRefuse', 'OtherSystemInterfaces\OtherSystemOrdersController@orderRefuse'); //拒单

        Route::post('v3/OtherSystemOrders/orderLock', 'OtherSystemInterfaces\OtherSystemOrdersController@orderLock'); //系统锁单
        Route::post('v3/OtherSystemOrders/unOrderLock', 'OtherSystemInterfaces\OtherSystemOrdersController@unOrderLock'); //系统取消锁单

        // 售后管理 -- 接单
        Route::post('v3/OtherSystemAfterOrders/orderReceiving', 'OtherSystemInterfaces\OtherSystemAfterOrdersController@orderReceiving'); //接单

        Route::post('v3/OtherSystemOrders/changePass', 'OtherSystemInterfaces\OtherSystemOrdersController@changePass'); //审核速电改的订单
        Route::post('v3/OtherSystemOrders/undoOperation', 'OtherSystemInterfaces\OtherSystemOrdersController@undoOperation'); //速电回收确认
        Route::post('v3/OtherSystemOrders/feedback', 'OtherSystemInterfaces\OtherSystemOrdersController@feedback'); //催单反馈
    });
    Route::post('v3/OtherSystemOrders/placeOrder', 'OtherSystemInterfaces\OtherSystemOrdersController@placeOrder'); //三方下单接口
    Route::post('v3/OtherSystemOrders/getServiceShop', 'OtherSystemInterfaces\OtherSystemOrdersController@getServiceShop'); //三方下单接口-获取施工门店
    Route::post('v3/OtherSystemOrders/editAppointTime', 'OtherSystemInterfaces\OtherSystemOrdersController@editAppointTime'); //三方下单接口-修改预约时间
    // 速电对接--商品信息
    Route::post('v3/OtherSystemGoods/getSystemGoods', 'OtherSystemInterfaces\OtherSystemGoodsController@getSystemGoods'); //获取商品信息
    // 速电对接--门店绑定
    Route::post('v3/OtherSystemShop/correlation', 'OtherSystemInterfaces\OtherSystemShopController@correlation'); //门店绑定
    Route::post('v3/OtherSystemShop/secretKey', 'OtherSystemInterfaces\OtherSystemShopController@secretKey');

    //派单流程-订单相关
    Route::post('v3/OtherSystemOrders/importOrders', 'OtherSystemInterfaces\OtherSystemOrdersController@importOrders'); //导入订单

    Route::post('v3/OtherSystemOrders/sdOrderLock', 'OtherSystemInterfaces\OtherSystemOrdersController@sdOrderLock'); //速电锁单

    Route::post('v3/OtherSystemOrders/sdOrderEdit', 'OtherSystemInterfaces\OtherSystemOrdersController@sdOrderEdit'); //速电改单
    Route::post('v3/OtherSystemOrders/sdReminder', 'OtherSystemInterfaces\OtherSystemOrdersController@sdReminder'); //速电催单
    Route::post('v3/OtherSystemOrders/recycleOrder', 'OtherSystemInterfaces\OtherSystemOrdersController@recycleOrder'); //速电回收撤销订单
    Route::post('v3/OtherSystemOrders/opinionOrder', 'OtherSystemInterfaces\OtherSystemOrdersController@opinionOrder'); //速电审核驳回完成的订单

    Route::post('v3/OtherSystemOrders/getLabel', 'OtherSystemInterfaces\OtherSystemOrdersController@getLabel'); //获取标签

    Route::post('v3/OtherSystemOrders/importAfterOrders', 'OtherSystemInterfaces\OtherSystemOrdersController@importAfterOrders'); //导入售后单
    Route::post('v3/OtherSystemOrders/opinionAfterOrder', 'OtherSystemInterfaces\OtherSystemOrdersController@opinionAfterOrder'); //速电审核通过驳回完成的售后订单
    Route::post('v3/OtherSystemOrders/importBillOrders', 'OtherSystemInterfaces\OtherSystemOrdersController@importBillOrders'); //速电账单同步
});

// 移动端路由--要逐步废弃
Route::post('m2/Mobilelogin', 'Api\MobileLoginController@login'); //移动端登录
Route::post('m2/forgetPwd', 'Api\MobileManage\MyselfController@forgetPwd'); //忘记密码


// 半径美装-技师小程序路由
Route::post('w1/login', 'WeChatApplet\LoginController@login'); //登录
Route::post('w1/forgotPassword', 'WeChatApplet\LoginController@forgotPassword'); //忘记密码
Route::post('w1/getSmsCode', 'WeChatApplet\LoginController@getSmsCode'); //获取验证码
Route::post('w1/getToken', 'WeChatApplet\LoginController@getToken'); //根据openid获取token
Route::post('w1/getOpenId', 'WeChatApplet\LoginController@getOpenId'); //获取open_id
Route::namespace('WeChatApplet')->group(function () {
    Route::post('w2/Personal/getRole', 'Technician\PersonalController@getRole'); //所有角色
    Route::post('w2/Personal/addProcess', 'Technician\PersonalController@addProcess'); //新建员工审核
    Route::post('w2/Personal/getRoleData', 'Technician\PersonalController@getRoleData'); //角色数据
    

    Route::post('w1/SettleIn/zhuceYz', 'AppletSettleIn\SettleInController@zhuceYz');//注册验证
    Route::post('w1/SettleIn/add', 'AppletSettleIn\SettleInController@add');//添加入驻信息
    Route::post('w1/SettleIn/getServiceScope', 'AppletSettleIn\SettleInController@getServiceScope');//获取服务范围　2023-6-5

    Route::post('w1/quit', 'LoginController@quit'); //退出
    Route::post('w1/SettleIn/getScheduleinfoById', 'AppletSettleIn\SettleInController@getScheduleinfoById');//获取最后一条审核信息
    Route::post('w1/SettleIn/edit', 'AppletSettleIn\SettleInController@edit');//完善入驻信息
    Route::post('w1/SettleIn/info', 'AppletSettleIn\SettleInController@info');//获取一条入驻信息
    Route::post('w1/SettleIn/getBrands', 'AppletSettleIn\SettleInController@getBrands');//获取品牌　2023-6-8
    Route::post('w1/SettleIn/getSettleWorkshop', 'AppletSettleIn\SettleInController@getSettleWorkshop');//获取车间类型　2023-6-6
    Route::post('w1/SettleIn/getSettleWashCar', 'AppletSettleIn\SettleInController@getSettleWashCar');//获取是否能洗车　2023-6-6
    Route::post('w1/SettleIn/getPayType', 'AppletSettleIn\SettleInController@getPayType');//获取付款方式　2023-6-6
    Route::post('w1/SettleIn/getContentByImg', 'AppletSettleIn\SettleInController@getContentByImg');//入驻信息图片获取内容
    Route::post('w1/SettleIn/upStatus', 'AppletSettleIn\SettleInController@upStatus');//入驻信息修改状态
    Route::post('w1/SettleIn/getAddress', 'AppletSettleIn\SettleInController@getAddress');//根据经纬度获取省市区
    // 需要验证
    Route::group(['middleware' => ['WechatAppletLogin']], function () {

        Route::post('w1/switchShopLogin', 'LoginController@switchShopLogin'); //选择门店登录
        #入驻相关　2023-5-19　du add


        Route::post('w1/SettleIn/index', 'AppletSettleIn\SettleInController@index');//技师列表
        Route::post('w1/SettleIn/addPerson', 'AppletSettleIn\SettleInController@addPerson');//添加技师
        Route::post('w1/SettleIn/editPerson', 'AppletSettleIn\SettleInController@editPerson');//编辑技师
        Route::post('w1/SettleIn/resetPassword', 'AppletSettleIn\SettleInController@resetPassword');//重置密码
        Route::post('w1/SettleIn/editPassword', 'AppletSettleIn\SettleInController@editPassword');//修改密码

        Route::post('w1/SettleIn/listOrder', 'AppletSettleIn\SettleInController@listOrder');//账单详情　5-24
        Route::post('w1/SettleIn/listSdOrderBill', 'AppletSettleIn\SettleInController@listSdOrderBill');//已出账单　5-24
        Route::post('w1/SettleIn/uploadInv', 'AppletSettleIn\SettleInController@uploadInv');//上传发票　5-24
        Route::post('w1/SettleIn/getInvType', 'AppletSettleIn\SettleInController@getInvType');//获取发票类型



        Route::post('w1/SettleIn/confirmOrder', 'AppletSettleIn\SettleInController@confirmOrder'); //确认账单　2023-6-7
        Route::post('w1/SettleIn/billDetail', 'AppletSettleIn\SettleInController@billDetail');//账单详情　2023-6-7

        Route::post('w1/SettleIn/getInvImg', 'AppletSettleIn\SettleInController@getInvImg');//获取发票信息　2023-6-8

        Route::post('w1/SettleIn/isExsitOrderNum', 'AppletSettleIn\SettleInController@isExsitOrderNum');//是否存在此定单　2023-6-8

        Route::post('w1/SettleIn/receivingOrder', 'AppletSettleIn\SettleInController@receivingOrder');//接单　2023-6-9

        Route::post('w1/SettleIn/refuseOrder', 'AppletSettleIn\SettleInController@refuseOrder');//拒单　2023-6-12
        Route::post('w1/SettleIn/getRefuseLable', 'AppletSettleIn\SettleInController@getRefuseLable');//拒单标签　2023-6-12


        // 业务系统 -- 订单列表
        Route::post('w1/getPri', 'LoginController@getPri'); //获取权限
        Route::post('w1/experience', 'LoginController@experience'); //立即体验
        Route::post('w1/unremind', 'LoginController@unremind'); //立即体验
        Route::post('w1/getReminder', 'LoginController@getReminder'); //获取更新提醒
        Route::post('w1/closeReminder', 'LoginController@closeReminder'); //关闭更新提醒

        Route::post('w1/AppletOrder/index', 'AppletOrderManage\AppletOrderController@index'); //订单列表
        Route::post('w1/AppletOrder/info', 'AppletOrderManage\AppletOrderController@info'); //查看详情
        Route::post('w1/AppletOrder/cancel', 'AppletOrderManage\AppletOrderController@cancel'); //取消订单
        Route::post('w1/AppletOrder/isExceed', 'AppletOrderManage\AppletOrderController@isExceed'); //订单审核
        Route::post('w1/OtherSystemOrders/orderReceiving', 'OtherSystemInterfaces\OtherSystemOrdersController@orderReceiving'); //门店接单（速电网单的会有这个）

        // 业务系统 -- 工单列表
        Route::post('w1/AppletWorkOrder/index', 'AppletOrderManage\AppletWorkOrderController@index'); //工单列表
        Route::post('w1/AppletWorkOrder/info', 'AppletOrderManage\AppletWorkOrderController@info'); //查看详情
        Route::post('w1/AppletWorkOrder/assign', 'AppletOrderManage\AppletWorkOrderController@assign'); //重新派单
        Route::post('w1/AppletWorkOrder/delete', 'AppletOrderManage\AppletWorkOrderController@delete'); //取消工单

        // 财务系统 -- 账单列表
        Route::post('w1/AppletOrderBill/index', 'AppletAccountControl\AppletOrderBillController@index'); //账单列表
        Route::post('w1/AppletOrderBill/billNumber', 'AppletAccountControl\AppletOrderBillController@billNumber'); //单量详情
        Route::post('w1/AppletOrderBill/lookInfo', 'AppletAccountControl\AppletOrderBillController@lookInfo'); //查看详情

        // 财务系统 -- 应收账款分析
        Route::post('w1/AppletReceivableAnalyze/index', 'AppletAccountControl\AppletReceivableAnalyzeController@index'); //应收账款分析

        // 仓储系统 -- 发货单
        Route::post('w1/AppletDispatch/index', 'AppletWarehouseManage\AppletDispatchController@index'); //发货列表
        Route::post('w1/AppletDispatch/info', 'AppletWarehouseManage\AppletDispatchController@info'); //查看详情
        Route::post('w1/AppletDispatch/shipments', 'AppletWarehouseManage\AppletDispatchController@shipments'); //发货

        // 仓储系统 -- 入库列表
        Route::post('w1/AppletWareInorder/index', 'AppletWarehouseManage\AppletWareInorderController@index'); //入库列表
        Route::post('w1/AppletWareInorder/info', 'AppletWarehouseManage\AppletWareInorderController@info'); //查看
        Route::post('w1/AppletWareInorder/wareRecord', 'AppletWarehouseManage\AppletWareInorderController@wareRecord'); //库房记录
        Route::post('w1/AppletWareInorder/warehousing', 'AppletWarehouseManage\AppletWareInorderController@Warehousing'); //入库
        Route::post('w1/AppletWareInorder/delivery', 'AppletWarehouseManage\AppletWareInorderController@delivery'); //出库

        // 数据查询 -- 商品库存
        Route::post('w1/GoodsInventory/goodsIndex', 'DataSearch\GoodsInventoryController@goodsIndex'); //查询商品信息
        Route::post('w1/GoodsInventory/stockIndex', 'DataSearch\GoodsInventoryController@stockIndex'); //查询商品库存信息

        // 数据查询 -- 销售统计
        Route::post('w1/DataStatistical/index', 'DataSearch\DataStatisticalController@index'); //列表

        // 个人中心
        Route::post('w1/Personal/personal', 'SystemsManage\PersonalController@personal'); //获取页面信息
        Route::post('w1/Personal/dataCount', 'Technician\PersonalController@dataCount'); //驾驶舱数据
        Route::post('w1/Personal/salesVolume', 'Technician\PersonalController@salesVolume'); //驾驶舱数据

        // 公共搜索方法
        Route::post('w1/PublicSearch/searchBrand', 'PublicsManage\PublicSearchController@searchBrand'); //搜索商品品牌
        Route::post('w1/PublicSearch/searchBrandSerie', 'PublicsManage\PublicSearchController@searchBrandSerie'); //搜索品牌系列
        Route::post('w1/PublicSearch/searchCategory', 'PublicsManage\PublicSearchController@searchCategory'); //搜索商品品类
        Route::post('w1/PublicSearch/searchWarehouse', 'PublicsManage\PublicSearchController@searchWarehouse'); //搜索仓库
        Route::post('w1/PublicSearch/searchTechnician', 'PublicsManage\PublicSearchController@searchTechnician'); //搜索服务技师
        Route::post('w1/PublicSearch/searchSalesman', 'PublicsManage\PublicSearchController@searchSalesman'); //搜索业务员
        Route::post('w1/PublicSearch/searchPersonel', 'PublicsManage\PublicSearchController@searchPersonel'); //搜索人员
        Route::post('w1/PublicSearch/searchChannelUnit', 'PublicsManage\PublicSearchController@searchChannelUnit'); //搜索客户单位
        Route::post('w1/PublicSearch/searchPrecincts', 'PublicsManage\PublicSearchController@searchPrecincts'); //搜索业务划区
        Route::post('w1/PublicSearch/searchFreight', 'PublicsManage\PublicSearchController@searchFreight'); //搜索仓位
        Route::post('w1/PublicSearch/searchFreightGoods', 'PublicsManage\PublicSearchController@searchFreightGoods'); //搜索采购退货仓位
        Route::post('w1/PublicSearch/searchQualityReward', 'PublicsManage\PublicSearchController@searchQualityReward'); //搜索质检项

        // 洗美技师小程序路由
        Route::post('w1/WashWork/home', 'Technician\WashWorkController@home'); //首页-预约信息列表
        Route::post('w1/WashWork/homeCollect', 'Technician\WashWorkController@homeCollect'); //首页-预约汇总、排行榜
        Route::post('w1/WashWork/homeAppointTime', 'Technician\WashWorkController@homeAppointTime'); //首页-预约时间
        Route::post('w1/WashWork/planAppointTime', 'Technician\WashWorkController@planAppointTime'); //首页-排班计划预约时间
        Route::post('w1/WashWork/planTitle', 'Technician\WashWorkController@planTitle'); //首页-排班计划列表表头
        Route::post('w1/WashWork/planappIndex', 'Technician\WashWorkController@planappIndex'); //首页-排班计划列表
        Route::post('w1/WashWork/planappSetnum', 'Technician\WashWorkController@planappSetnum'); //排班计划列表-设置预约数量
        Route::post('w1/WashWork/info', 'Technician\WashWorkController@info'); //工单详情
        Route::post('w1/WashWork/orderInfo', 'Technician\WashWorkController@orderInfo'); //待派订单详情
        Route::post('w1/WashWork/index', 'Technician\WashWorkController@index'); //工单列表
        Route::post('w1/WashWork/dispatchList', 'Technician\WashWorkController@dispatchList'); //待派单
        Route::post('w1/WashWork/appointmentOrderSet', 'Technician\WashWorkController@appointmentOrderSet'); //待派单订单修改预约时间
        Route::post('w1/WashWork/createWork', 'Technician\WashWorkController@createWork'); //派单-生成工单
        Route::post('w1/WashWork/assign', 'Technician\WashWorkController@assign'); //派单-重新派单
        Route::post('w1/WashWork/refuse', 'Technician\WashWorkController@refuse'); //工单列表-拒单
        Route::post('w1/WashWork/validateCar', 'Technician\WashWorkController@validateCar'); //工单列表-验车
        Route::post('w1/WashWork/checkCar', 'Technician\WashWorkController@checkCar'); //工单列表-实时验车
        Route::post('w1/WashWork/addCheckCar', 'Technician\WashWorkController@addCheckCar'); //工单列表-补充验车
        Route::post('w1/WashWork/cancelSelect', 'Technician\WashWorkController@cancelSelect'); //工单列表-验车取消选择
        Route::post('w1/WashWork/construction', 'Technician\WashWorkController@construction'); //工单列表-施工
        Route::post('w1/WashWork/constructionInfo', 'Technician\WashWorkController@constructionInfo'); //工单列表-施工信息
        Route::post('w1/WashWork/getLeft', 'Technician\WashWorkController@getLeft'); //工单列表-左侧列表
        Route::post('w1/WashWork/completionInfo', 'Technician\WashWorkController@completionInfo'); //工单列表-施工信息
        Route::post('w1/WashWork/completion', 'Technician\WashWorkController@completion'); //工单列表-施工实时存储
        Route::post('w1/WashWork/cancelCom', 'Technician\WashWorkController@cancelCom'); //工单列表-施工实时删除
        Route::post('w1/WashWork/qualityInfo', 'Technician\WashWorkController@qualityInfo'); //工单列表-质检信息
        Route::post('w1/WashWork/quality', 'Technician\WashWorkController@quality'); //工单列表-质检实时存储
        Route::post('w1/WashWork/cancelQuality', 'Technician\WashWorkController@cancelQuality'); //工单列表-质检实时存储-删除
        Route::post('w1/WashWork/materials', 'Technician\WashWorkController@materials'); //工单列表-余料废料实时存储
        Route::post('w1/WashWork/conInfo', 'Technician\WashWorkController@conInfo'); //工单列表-提交施工查看施工信息
        Route::post('w1/WashWork/submitConstruction', 'Technician\WashWorkController@submitConstruction'); //工单列表-提交施工
        Route::post('w1/WashWork/qualityTesting', 'Technician\WashWorkController@qualityTesting'); //工单列表-质检
        Route::post('w1/WashWork/accomplish', 'Technician\WashWorkController@accomplish'); //工单列表-施工完成提交
        Route::post('w1/WashWork/receiveSubmit', 'Technician\WashWorkController@receiveSubmit'); //工单列表-接单提交
        Route::post('w1/WashWork/appointmentSet', 'Technician\WashWorkController@appointmentSet'); //工单列表-预约设置
        Route::post('w1/WashWork/getWorkHistory', 'Technician\WashWorkController@getWorkHistory'); //工单列表-工单历史
        Route::post('w1/WashWork/editTechnician', 'Technician\WashWorkController@editTechnician'); //工单列表-修改技师
        Route::post('w1/WashWork/getMessage', 'Technician\WashWorkController@getMessage'); //小红点
        Route::post('w1/WashWork/rejectCount', 'Technician\WashWorkController@rejectCount'); //工单列表-智配驳回订单数量
        Route::post('w1/WashWork/rejectList', 'Technician\WashWorkController@rejectList'); //工单列表-智配驳回订单列表
        Route::post('w1/WashWork/resubmit', 'Technician\WashWorkController@resubmit'); //工单列表-智配驳回订单重新提交
        Route::post('w1/WashWork/userPicState', 'Technician\WashWorkController@userPicState'); //工单列表-同步图片给客户
        Route::post('w1/WashWork/cancelOrder', 'Technician\WashWorkController@cancelOrder'); //工单列表-取消订单
        Route::post('w1/WashWork/returnWork', 'Technician\WashWorkController@returnWork'); //工单列表-返工
        Route::post('w1/WashWork/returnItem', 'Technician\WashWorkController@returnItem'); //工单列表-还件
        Route::post('w1/WashWork/auditWork', 'Technician\WashWorkController@auditWork'); //工单列表-审核工单
        Route::post('w1/WashWork/returnItemInfo', 'Technician\WashWorkController@returnItemInfo'); //工单列表-还件信息

        // 合作商服务列表
        Route::post('w1/WashService/index', 'Technician\WashServiceController@index'); //服务查询

        // 合作商预约
        Route::post('w1/WashOrder/addReservation', 'Technician\WashOrderController@addReservation'); //服务查询
        Route::post('w1/WashOrder/orderCount', 'Technician\WashOrderController@orderCount'); //首页-数据统计
        Route::post('w1/WashOrder/getOrder', 'Technician\WashOrderController@getOrder'); //订单再来一单获取数据
        Route::post('w1/WashOrder/pictoplace', 'Technician\WashOrderController@pictoplace'); //车牌识别
        Route::post('w1/WashOrder/uploadOrdPic', 'Technician\WashOrderController@uploadOrdPic'); //上传订单凭证
        
        // 技师开单
        Route::post('w1/WashOrder/index', 'Technician\WashOrderController@index'); //订单查询
        Route::post('w1/WashOrder/searchMember', 'Technician\WashOrderController@searchMember'); //查询会员，会员列表
        Route::post('w1/WashOrder/getMembershipByLicensePlate', 'Technician\WashOrderController@getMembershipByLicensePlate'); //根据车牌查询会员信息
        Route::post('w1/WashOrder/getSourceState', 'Technician\WashOrderController@getSourceState'); //获取来源类型
        Route::post('w1/WashOrder/searchBusinessacc', 'Technician\WashOrderController@searchBusinessacc'); //查询企业会员
        Route::post('w1/WashOrder/searchWashService', 'Technician\ServiceProjectController@searchWashService'); //洗美-技师端搜索施工项目接口
        Route::post('w1/WashOrder/getConimg', 'Technician\ServiceProjectController@getConimg'); //洗美-技师端新增施工项目获取配置接口
        Route::post('w1/WashOrder/addProject', 'Technician\ServiceProjectController@addProject'); //洗美-技师端新增施工项目
        Route::post('w1/WashOrder/getClass', 'Technician\ServiceProjectController@getClass'); //洗美-技师端新增施工项目
        Route::post('w1/WashOrder/getServiceData', 'Technician\ServiceProjectController@getServiceData'); //洗美-技师端获取施工项目信息
        Route::post('w1/WashOrder/editServiceProject', 'Technician\ServiceProjectController@editServiceProject'); //洗美-技师端编辑施工项目信息
        Route::post('w1/WashOrder/addGoods', 'Technician\WashOrderController@addGoods'); //洗美-技师端新增商品
        Route::post('w1/WashOrder/getWareHouses', 'Technician\WashOrderController@getWareHouses'); //洗美-技师端新增商品查询默认仓库
        Route::post('w1/WashOrder/unitConversion', 'Technician\WashOrderController@unitConversion'); //洗美-小程序转库存
        Route::post('w1/WashOrder/addBrandlist', 'Technician\WashOrderController@addBrandlist'); //洗美-技师端新增品牌
        Route::post('w1/WashOrder/addCate', 'Technician\WashOrderController@addCate'); //洗美-技师端新增品类
        Route::post('w1/WashOrder/addBre', 'Technician\WashOrderController@addBre'); //洗美-技师端新增品牌系列
        Route::post('w1/WashOrder/selectUnit', 'Technician\WashOrderController@selectUnit'); //获取单位
        Route::post('w1/WashOrder/searchAllWarehouse', 'Technician\WashOrderController@searchAllWarehouse'); //洗美-技师端搜索仓库
        Route::post('w1/WashOrder/getCategory', 'Technician\WashOrderController@getCategory'); //洗美-技师端获取品类
        Route::post('w1/WashOrder/getBrand', 'Technician\WashOrderController@getBrand'); //洗美-技师端获取品牌
        Route::post('w1/WashOrder/getBrandSerie', 'Technician\WashOrderController@getBrandSerie'); //洗美-技师端获取品牌系列
        Route::post('w1/WashOrder/searchUniqueString', 'Technician\WashOrderController@searchUniqueString'); //洗美-生成唯一标识
        Route::post('w1/WashOrder/getGoodsStock', 'Technician\WashOrderController@getGoodsStock'); //洗美-技师端搜索仓库商品
        Route::post('w1/WashOrder/getGoodsStockInfo', 'Technician\WashOrderController@getGoodsStockInfo'); //洗美-技师端搜索仓库商品
        Route::post('w1/WashOrder/info', 'Technician\WashOrderController@info'); //订单查询-详情
        Route::post('w1/WashOrder/orderExplain', 'Technician\WashOrderController@orderExplain'); //订单查询-安装明细
        Route::post('w1/WashOrder/scan', 'Technician\WashOrderController@scan'); //扫码查询信息
        Route::post('w1/WashOrder/getmyVip', 'Technician\WashOrderController@getmyVip'); //查询会员卡信息
        Route::post('w1/WashOrder/getMemberAndMyVip', 'Technician\WashOrderController@getMemberAndMyVip'); //查询会员卡信息
        Route::post('w1/WashOrder/package', 'Technician\WashOrderController@package'); //查询套餐信息
        Route::post('w1/WashOrder/packageInfo', 'Technician\WashOrderController@packageInfo'); //查询套餐信息
        Route::post('w1/WashOrder/add', 'Technician\WashOrderController@add'); //开单
        Route::post('w1/WashOrder/addMember', 'Technician\WashOrderController@addMember'); //创建会员
        Route::post('w1/WashOrder/addBusinessAcc', 'Technician\WashOrderController@addBusinessAcc'); //创建企业会员
        Route::post('w1/WashOrder/searchBusiness', 'Technician\WashOrderController@searchBusiness'); //搜索合作商
        Route::post('w1/WashOrder/addWashCarOrder', 'Technician\WashOrderController@addWashCarOrder'); //创建洗车订单
        Route::post('w1/WashOrder/cancel', 'Technician\WashOrderController@cancel'); //订单取消
        Route::post('w1/WashOrder/receiveOrder', 'Technician\WashOrderController@receiveOrder'); //订单-领取订单
        Route::post('w1/WashOrder/appointmentSet', 'Technician\WashOrderController@appointmentSet'); //预约设置
        Route::post('w1/WashOrder/auditOrder', 'Technician\WashOrderController@auditOrder'); //修改价格
        Route::post('w1/WashOrder/settlement', 'Technician\WashOrderController@settlement'); //结算
        Route::post('w1/WashOrder/exchangeGoods', 'Technician\WashOrderController@exchangeGoods'); //订单换货
        Route::post('w1/WashOrder/getRefundWay', 'Technician\WashOrderController@getRefundWay'); //换货获取退款方式
        Route::post('w1/WashOrder/getPayWay', 'Technician\WashOrderController@getPayWay'); //换货获取付款方式
        Route::post('w1/WashOrder/searchColGoods', 'Technician\WashOrderController@searchColGoods'); //开单转换单位
        Route::post('w1/WashOrder/addRemark', 'Technician\WashOrderController@addRemark'); //添加备注
        // 发货列表
        Route::post('w2/WashDispatch/index', 'Technician\WashDispatchController@index'); //发货列表
        Route::post('w2/WashDispatch/getCount', 'Technician\WashDispatchController@getCount'); //发货列表-数量统计
        Route::post('w2/WashDispatch/info', 'Technician\WashDispatchController@info'); //发货详情
        Route::post('w2/WashDispatch/shipments', 'Technician\WashDispatchController@shipments'); //发货
        Route::post('w2/WashDispatch/getWareHouses', 'Technician\WashDispatchController@getWareHouses'); //发货-获取仓库
        Route::post('w2/WashDispatch/changeWare', 'Technician\WashDispatchController@changeWare'); //发货-更换仓库
        //快递公司列表
        Route::post('w2/WashDelivery/add', 'Technician\WashDeliveryController@add'); //发货单--添加快递公司
        Route::post('w2/WashDelivery/index', 'Technician\WashDeliveryController@index'); //发货单--快递公司列表
        Route::post('w2/WashDelivery/allIndex', 'Technician\WashDeliveryController@allIndex'); //发货单--快递公司列表
        Route::post('w2/WashDelivery/edit', 'Technician\WashDeliveryController@edit'); //发货单--快递公司修改
        Route::post('w2/WashDelivery/editStatus', 'Technician\WashDeliveryController@editStatus'); //发货单--快递公司修改状态
        Route::post('w2/WashDelivery/addDelivery', 'Technician\WashDeliveryController@addDelivery'); //发货单--添加快递公司
        Route::post('w2/WashDelivery/deliveryList', 'Technician\WashDeliveryController@deliveryList'); //发货单--快递公司列表
        Route::post('w2/WashStockake/add', 'Technician\WashStockakeController@add'); //新增盘库单
        // 退换入库列表
        Route::post('w2/WashRecedeRecycle/index', 'Technician\WashRecedeRecycleController@index'); //退换列表
        Route::post('w2/WashRecedeRecycle/info', 'Technician\WashRecedeRecycleController@info'); //退换详情
        Route::post('w2/WashRecedeRecycle/recycle', 'Technician\WashRecedeRecycleController@recycle'); //退换
        //盘库单
        Route::post('w2/WashRecedeRecycle/recycle', 'Technician\WashRecedeRecycleController@recycle'); //
        //售后单
        Route::post('w1/AfterOrder/index', 'Technician\AfterOrderController@index'); //
        Route::post('w1/AfterOrder/info', 'Technician\AfterOrderController@info'); //售后详情
        Route::post('w1/AfterOrder/dealwith', 'Technician\AfterOrderController@dealwith'); //处理售后-跟进反馈
        Route::post('w1/AfterOrder/complete', 'Technician\AfterOrderController@complete'); //处理售后-完工提交
        Route::post('w1/AfterOrder/getParts', 'Technician\AfterOrderController@getParts'); //处理售后-获取部位

        // 合作商订单
        Route::post('w1/WashOrder/BusOrder', 'Technician\WashOrderController@BusOrder'); //订单查询
        Route::post('w1/WashOrder/BusOrderinfo', 'Technician\WashOrderController@BusOrderinfo'); //订单查询详情
        Route::post('w1/WashOrder/buscancel', 'Technician\WashOrderController@buscancel'); //取消订单
        Route::post('w1/WashOrder/validateCarData', 'Technician\WashOrderController@validateCarData'); //验车结果
        Route::post('w1/WashOrder/signatureSubmit', 'Technician\WashOrderController@signatureSubmit'); //签字确认
        Route::post('w1/WashOrder/OrderWorksindex', 'Technician\WashOrderController@OrderWorksindex'); //作品列表
        Route::post('w1/WashOrder/OrderWorksinfo', 'Technician\WashOrderController@OrderWorksinfo'); //作品详情
        Route::post('w1/WashOrder/busreindex', 'Technician\WashOrderController@busreindex'); //订单-待处理-预约单
        Route::post('w1/WashOrder/busreinfo', 'Technician\WashOrderController@busreinfo'); //订单-待处理-预约单
        Route::post('w1/WashOrder/withdraw', 'Technician\WashOrderController@withdraw'); //订单-待处理-预约单-撤回
        Route::post('w1/WashOrder/getPaymentWay', 'Technician\WashOrderController@getPaymentWay'); //获取结算方式

        // 技师动态
        Route::post('w2/Personal/technicianDynamics', 'Technician\PersonalController@technicianDynamics'); //技师动态
        Route::post('w2/Personal/workOrderTh', 'Technician\PersonalController@workOrderTh'); //技师动态
        // 合作商个人中心
        Route::post('w2/Personal/getPersonalShops', 'Technician\PersonalController@getPersonalShops'); //获取个人所有门店信息
        Route::post('w2/Personal/personal', 'Technician\PersonalController@personal'); //个人中心
        Route::post('w2/Personal/BusPersonal', 'Technician\PersonalController@BusPersonal'); //合作商个人中心
        Route::post('w2/Personal/edit', 'Technician\PersonalController@edit'); //个人中心-编辑
        Route::post('w2/Personal/getOrderNumList', 'Technician\PersonalController@getOrderNumList'); //获取工单统计
        Route::post('w2/Personal/collectionTh', 'Technician\PersonalController@collectionTh'); //收藏技师
        Route::post('w2/Personal/cancelCoTh', 'Technician\PersonalController@cancelCoTh'); //取消收藏技师
        Route::post('w2/Personal/myCoTh', 'Technician\PersonalController@myCoTh'); //我收藏的技师
        Route::post('w2/Personal/invitation', 'Technician\PersonalController@invitation'); //邀请记录
        Route::post('w2/Personal/listWorkPic', 'Technician\PersonalController@listWorkPic'); //同步图片
        Route::post('w2/Personal/getInvQrimg', 'Technician\PersonalController@getInvQrimg'); //获取邀请码
        Route::post('w2/Personal/addInvCode', 'Technician\PersonalController@addInvCode'); //获取邀请码

        
        Route::post('w2/Personal/Process', 'Technician\PersonalController@Process'); //新建员工审核
        Route::post('w2/Personal/index', 'Technician\PersonalController@index'); //员工审核列表
        Route::post('w2/Personal/getReason', 'Technician\PersonalController@getReason'); //驳回原因

        Route::post('w1/AdminMessage/index', 'Technician\AdminMessageController@index'); //消息列表
        Route::post('w1/AdminMessage/busindex', 'Technician\AdminMessageController@busindex'); //合作商消息列表
        Route::post('w1/AdminMessage/readbusmsg', 'Technician\AdminMessageController@readbusmsg'); //合作商阅读消息
        Route::post('w1/AdminMessage/read', 'Technician\AdminMessageController@read'); //阅读消息
        Route::post('w1/AdminMessage/unreadTotal', 'Technician\AdminMessageController@unreadTotal'); //未读消息总数
        Route::post('w1/AdminMessage/busunreadTotal', 'Technician\AdminMessageController@busunreadTotal'); //未读消息总数

        Route::post('w1/appoinTimeJudge', 'Technician\WashWorkController@appoinTimeJudge'); //根据预约时间返回限制预约数量
        Route::post('w1/getOrderType', 'Technician\WashWorkController@getOrderType'); //获取订单类型

        Route::post('w1/ValidateCarManage/index', 'Technician\ValidateCarManageController@index'); //验车管理列表

        Route::post('w1/ContactUs/right', 'Technician\ContactUsController@right'); //意见反馈
        Route::post('w1/ContactUs/getModel', 'Technician\ContactUsController@getModel'); //获取模块
        Route::post('w1/ContactUs/submit', 'Technician\ContactUsController@submit'); //提交
        Route::post('w1/ContactUs/video', 'Technician\ContactUsController@video'); //视频列表
        Route::post('w1/ContactUs/tryNow', 'Technician\ContactUsController@tryNow'); //视频列表

        // *****************会员列表接口*****************
        Route::post('w2/Member/editMember', 'Technician\MemberController@editMember'); //编辑
        Route::post('w2/Member/recharge', 'Technician\MemberController@recharge'); //充值
        Route::post('w2/Member/reclog', 'Technician\MemberController@reclog'); //充值记录
        Route::post('w2/Member/getBanlance', 'Technician\MemberController@getBanlance'); //余额
        Route::post('w2/Member/editOrderMember', 'Technician\MemberController@editOrderMember'); //订单编辑用户信息
        // *****************会员列表接口*****************

        Route::post('u1/ReturnGoods/add', 'Technician\AreturnGoodsController@add'); //退货管理-添加退货单
        Route::post('u1/ReturnGoods/getInfo', 'Technician\AreturnGoodsController@getInfo'); //退货管理-获取订单信息
        Route::post('u1/ReturnGoods/index', 'Technician\AreturnGoodsController@index'); //退货管理-列表
        Route::post('u1/ReturnGoods/payment', 'Technician\AreturnGoodsController@payment'); //退货管理-打款记录
        Route::post('u1/ReturnGoods/recovery', 'Technician\AreturnGoodsController@recovery'); //退货管理-回收记录
        Route::post('u1/ReturnGoods/revoke', 'Technician\AreturnGoodsController@revoke'); //退货管理-撤销
        Route::post('u1/RefundGoods/index', 'Technician\ArefundGoodsController@index'); //退货管理-列表
        Route::post('u1/RefundGoods/edit', 'Technician\ArefundGoodsController@edit'); //退货管理-修改
        Route::post('u1/RefundGoods/getStatusList', 'Technician\ArefundGoodsController@getStatusList'); //退货管理-状态下拉
        Route::post('u1/RefundGoods/info', 'Technician\ArefundGoodsController@info'); //退货管理-退款详情
    });

    Route::post('w1/weixinThAuth', 'WeChatThAuthController@weixinThAuth'); //微信授权
    Route::post('w1/decryption', 'WeChatThAuthController@decryption'); //微信数据解密
    Route::post('w1/WeixinUser/login', 'User\WeixinUserController@login'); //微信用户-用户登录
});

Route::get('/clear-config', function() {
 Artisan::call('config:clear');
 return "config is cleared";
});
Route::get('/clear-cache', function() {
 Artisan::call('cache:clear');
 return "Cache is cleared";
});
Route::get('/laravel-version', function(){
    $laravel = app();
    return "Your Laravel version is ".$laravel::VERSION;
});
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['prefix' => 'Mounting', 'namespace' => 'Mounting'], function () { //Mounting为贴装功能的所有根目录

    // 售后路由
    Route::get('afterSales/index', 'AfterSalesController@index')->name('afterSales.index'); //售后列表
    Route::post('afterSales/cancel', 'AfterSalesController@cancel')->name('afterSales.cancel'); //售后取消
    Route::post('afterSales/done', 'AfterSalesController@done')->name('afterSales.done'); //售后完成
    Route::post('afterSales/memo', 'AfterSalesController@memo')->name('afterSales.memo'); //售后备注
    Route::post('afterSales/approve', 'AfterSalesController@approve')->name('afterSales.approve'); //售后审核

    Route::resource('exhibition', 'ExhibitionController', ['as' => 'exhibition']); //店铺作品

    Route::resource('meritPay', 'MeritPayController', ['as' => 'meritPay']); //绩效管理
    Route::resource('meritPayOptions', 'MeritPayOptionsController', ['as' => 'meritPayOptions']); //绩效项管理

    Route::resource('carDetectOptions', 'CarDetectOptionsController', ['as' => 'carDetectOptions']); //验车项异常管理

    Route::post('technicalLevel/{id}/setEnable', 'TechnicalLevelController@setEnable'); //技师技能等级管理
    Route::resource('technicalLevel', 'TechnicalLevelController', ['as' => 'technicalLevel']); //技师技能等级管理

    Route::post('technicalTitle/{id}/setEnable', 'TechnicalTitleController@setEnable'); //技师职称管理
    Route::resource('technicalTitle', 'TechnicalTitleController', ['as' => 'technicalTitle']); //技师职称管理

    Route::resource('serviceProjects', 'ServiceProjectsController', ['as' => 'serviceProjects']); //服务项目管理

    Route::resource('qualityInspectOptions', 'QualityInspectOptionsController', ['as' => 'qualityInspectOptions']); //质检项管理
});

Route::post('v1/login', 'Api\LoginController@login'); //登录
Route::post('v1/getPri', 'Api\LoginController@getPri'); //获取权限
Route::post('v1/Pay/addAccount', 'Mounting\Business\PayController@addAccount'); //添加商户
Route::post('v1/Pay/getApplymentByid', 'Mounting\Business\PayController@getApplymentByid'); //查询申请状态
Route::post('v1/Pay/uploadFile', 'Mounting\Business\PayController@uploadFile'); //上传图片到微信
Route::post('v1/Pay/alipay', 'Mounting\Pay\PayController@alipay'); //支付宝支付
Route::post('v1/Pay/aliPayNotify', 'Mounting\Pay\PayController@aliPayNotify'); //支付宝支付回调


// 洗美店程序-pc端路由
#入驻门店　2023-5-18　du add
Route::namespace('SettleIn')->group(function () {
    Route::group(['middleware' => ['islogin']], function () {
        Route::post('v1/SettleIn/index', 'SettleInController@index'); //入驻门店列表
        Route::post('v1/SettleIn/info', 'SettleInController@info');//审核
        Route::post('v1/SettleIn/creatAccout', 'SettleInController@creatAccout');//创建账号
        Route::post('v1/SettleIn/editStatus', 'SettleInController@editStatus');//跟进状态
        Route::post('v1/SettleIn/getStaues', 'SettleInController@getStaues');//获取状态

        Route::post('v1/SettleIn/exmInfo', 'SettleInController@exmInfo');//详情

    });
});

Route::namespace('Mounting')->group(function () {
    // 需要验证是否登录
    Route::any('v1/Shop/getQr', 'Shop\ShopController@getQr'); //获取token
    Route::post('v1/Shop/setQrState', 'Shop\ShopController@setQrState'); //修改二维码状态
    Route::post('v1/Shop/getQrState', 'Shop\ShopController@getQrState'); //二维码状态
    Route::post('v1/Shop/addShop', 'Shop\ShopController@addShop'); //新增门店
    Route::post('v1/Shop/verifyPhone', 'Shop\ShopController@verifyPhone'); //验证手机号
    Route::post('v1/Pay/wechatNotify', 'Shop\ShopController@wechatNotify'); //回调
    Route::post('v1/Shop/getService', 'Shop\ShopController@getService'); //服务范围
    Route::any('v1/Pay/notify', 'Business\PayController@notify'); //微信支付回调
    Route::post('v1/Shop/getGrant', 'Shop\ShopController@getGrant'); //获取发放的优惠券
    Route::post('v1/Shop/addShopOrder', 'Shop\ShopController@addShopOrder'); //新增产品订单
    Route::group(['middleware' => ['islogin']], function () {
        Route::post('v1/Shop/shopVersions', 'Shop\ShopController@shopVersions'); //门店版本列表
        Route::post('v1/Shop/getCoupon', 'Shop\ShopController@getCoupon'); //获取优惠券
        Route::post('v1/Shop/createShop', 'Shop\ShopController@createShop'); //新增门店
        Route::post('v1/Shop/addOrder', 'Shop\ShopController@addOrder'); //新增订单
        Route::post('v1/Shop/payShopOrder', 'Shop\ShopController@payShopOrder'); //支付订单
        Route::post('v1/Shop/index', 'Shop\ShopController@index'); //产品列表
        Route::post('v1/Shop/getOrderState', 'Shop\ShopController@getOrderState'); //获取订单状态
        Route::post('v1/Shop/bindShop', 'Shop\ShopController@bindShop'); //绑定门店
        Route::post('v1/Shop/bindIndex', 'Shop\ShopController@bindIndex'); //分店列表
        Route::post('v1/Shop/addBindShop', 'Shop\ShopController@addBindShop');   //新增分店
        Route::post('v1/Shop/editBindShop', 'Shop\ShopController@editBindShop');   //新增分店
        Route::post('v1/Shop/bindState', 'Shop\ShopController@bindState');   //分店状态修改
        Route::post('v1/Shop/shopAdmin', 'Shop\ShopController@shopAdmin');   //分店员工列表
        Route::post('v1/Shop/addShopAdm', 'Shop\ShopController@addShopAdm');   //分店员工列表 新增员工 
        Route::post('v1/Shop/editShopAdm', 'Shop\ShopController@editShopAdm');   //分店员工列表 在职离职员工 
        Route::post('v1/Shop/editShopRole', 'Shop\ShopController@editShopRole');   //分店员工列表查询角色
        Route::post('v1/Shop/getShopRole', 'Shop\ShopController@getShopRole');   //分店员工列表 获取分店角色
        Route::post('v1/Shop/addSpaceOrder', 'Shop\ShopController@addSpaceOrder');   //购买空间
        Route::post('v1/Shop/getSpaceInfo', 'Shop\ShopController@getSpaceInfo');   //购买空间 详情
        Route::post('v1/Shop/getSpaPrice', 'Shop\ShopController@getSpaPrice');   //续费版本 获取金额
        Route::post('v1/Shop/getUpShopPrice', 'Shop\ShopController@getUpShopPrice');   //升级 获取金额
        Route::post('v1/Shop/getOrderType', 'Shop\ShopController@getOrderType');   //购买记录类型
        Route::post('v1/Shop/feedBack', 'Shop\ShopController@feedBack');   //意见反馈
        Route::post('v1/Shop/confirm', 'Shop\ShopController@confirm');   //确认处理
        Route::post('v1/Shop/changeSpace', 'Shop\ShopController@changeSpace');   //空间划拨
        Route::post('v1/Shop/video', 'Shop\ShopController@video');   //视频列表
        Route::post('v1/Shop/addVideo', 'Shop\ShopController@addVideo');   //新增视频
        Route::post('v1/Shop/editVideo', 'Shop\ShopController@editVideo');   //编辑视频
        //新增邀请码
        Route::post('v1/Shop/addInvCode', 'Shop\ShopController@addInvCode');   //新增邀请码
        Route::post('v1/Shop/invCodeIndex', 'Shop\ShopController@invCodeIndex');   //邀请码列表
        
        Route::post('v1/Shop/shopOrder', 'Shop\ShopController@shopOrder'); //购买记录
        Route::post('v1/Shop/cancel', 'Shop\ShopController@cancel'); //购买记录-取消
        Route::post('v1/Pay/add', 'Business\PayController@add'); //添加商户
        Route::post('v1/Shop/getNeedPay', 'Shop\ShopController@getNeedPay'); //升级补差价的金额
        Route::post('v1/Shop/getMsgnum', 'Shop\ShopController@getMsgnum'); //获取短信数量
        Route::post('v1/Shop/addMsg', 'Shop\ShopController@addMsg'); //划拨短信
        Route::post('v1/Shop/buyShop', 'Shop\ShopController@buyShop'); //购买分店
        Route::post('v1/Shop/getCodePrice', 'Shop\ShopController@getCodePrice'); //获取邀请码金额
        
        Route::post('v1/Shop/checkShopOrder', 'Shop\ShopController@checkShopOrder'); //门店审核列表
        Route::post('v1/Shop/checkShop', 'Shop\ShopController@checkShop'); //门店审核

        Route::post('v1/Shop/getAddress', 'Shop\ShopController@getAddress'); //查询地址
        Route::post('v1/Shop/addAddress', 'Shop\ShopController@addAddress'); //设置地址
        
        // pc支付
        Route::post('v1/Shop/pay', 'Shop\WeChatPayController@getToPid'); //支付

        // 短信充值 - 查询
        Route::post('v1/Shop/msgPackage', 'Shop\ShopController@msgPackage'); //短信套餐
        Route::post('v1/Shop/getPaymentWay', 'Shop\ShopController@getPaymentWay'); //支付方式
        Route::post('v1/Shop/addSmsOrder', 'Shop\ShopController@addSmsOrder'); //新增短信充值订单
        Route::post('v1/Shop/record', 'Shop\ShopController@record'); //消费记录
        Route::post('v1/Shop/smsLog', 'Shop\ShopController@smsLog'); //短信记录
        Route::post('v1/Shop/getSmsType', 'Shop\ShopController@getSmsType'); //短信类型
        Route::post('v1/Shop/resend', 'Shop\ShopController@resend'); //短信重发
        Route::post('v1/Shop/msgSet', 'Shop\ShopController@msgSet'); //短信预警设置
        Route::post('v1/Shop/addBanner', 'Shop\ShopController@addBanner'); //添加banner
        Route::post('v1/Shop/delBanner', 'Shop\ShopController@delBanner'); //删除banner
        Route::post('v1/Shop/banner', 'Shop\ShopController@banner'); //banner
        Route::post('v1/Shop/msgConfig', 'Shop\ShopController@msgConfig'); //发送短信设置
        Route::post('v1/Shop/getMsgCon', 'Shop\ShopController@getMsgCon'); //发送短信设置

        Route::post('v1/Pay/wxpay', 'Business\PayController@wxpay'); //微信支付
        Route::post('v1/Pay/Mztuikuan', 'Business\PayController@Mztuikuan'); //微信支付
        // 基础管理 -- 验车管理
        Route::post('v1/ValidateCarManage/index', 'BasicManage\ValidateCarManageController@index'); //验车管理-列表
        Route::post('v1/ValidateCarManage/add', 'BasicManage\ValidateCarManageController@add'); //验车管理-新增
        Route::post('v1/ValidateCarManage/edit', 'BasicManage\ValidateCarManageController@edit'); //验车管理-编辑
        Route::post('v1/ValidateCarManage/start', 'BasicManage\ValidateCarManageController@start'); //验车管理-启用
        Route::post('v1/ValidateCarManage/stop', 'BasicManage\ValidateCarManageController@stop'); //验车管理-停用
        Route::post('v1/ValidateCarManage/delete', 'BasicManage\ValidateCarManageController@delete'); //验车管理-删除
        Route::post('v1/ValidateCarManage/searchValidateCar', 'BasicManage\ValidateCarManageController@searchValidateCar'); //验车管理-搜索验车管理数据

        // 基础管理 -- 作品管理
        Route::post('v1/ProductionManage/index', 'BasicManage\ProductionManageController@index'); //作品管理-列表 
        Route::post('v1/ProductionManage/add', 'BasicManage\ProductionManageController@add'); //作品管理-新增
        Route::post('v1/ProductionManage/edit', 'BasicManage\ProductionManageController@edit'); //作品管理-编辑
        Route::post('v1/ProductionManage/start', 'BasicManage\ProductionManageController@start'); //作品管理-启用
        Route::post('v1/ProductionManage/stop', 'BasicManage\ProductionManageController@stop'); //作品管理-停用
        Route::post('v1/ProductionManage/delete', 'BasicManage\ProductionManageController@delete'); //作品管理-删除
        Route::post('v1/ProductionManage/info', 'BasicManage\ProductionManageController@info'); //作品管理-详情

        // 基础管理 -- 职级管理
        Route::post('v1/GradeProfessional/index', 'BasicManage\GradeProfessionalController@index'); //职级管理-列表 
        Route::post('v1/GradeProfessional/add', 'BasicManage\GradeProfessionalController@add'); //职级管理-新增
        Route::post('v1/GradeProfessional/edit', 'BasicManage\GradeProfessionalController@edit'); //职级管理-编辑
        Route::post('v1/GradeProfessional/start', 'BasicManage\GradeProfessionalController@start'); //职级管理-启用
        Route::post('v1/GradeProfessional/stop', 'BasicManage\GradeProfessionalController@stop'); //职级管理-停用
        Route::post('v1/GradeProfessional/delete', 'BasicManage\GradeProfessionalController@delete'); //职级管理-删除
        Route::post('v1/GradeProfessional/info', 'BasicManage\GradeProfessionalController@info'); //职级管理-详情
        Route::post('v1/GradeProfessional/getGradeLevel', 'BasicManage\GradeProfessionalController@getGradeLevel'); //职级管理-获取级别

        // 业务系统-订单列表
        Route::post('v1/WashOrder/index', 'Business\WashOrderController@index'); //订单列表-列表
        Route::post('v1/WashOrder/add', 'Business\WashOrderController@add'); //订单列表-新增
        Route::post('v1/WashOrder/edit', 'Business\WashOrderController@edit'); //订单列表-编辑
        Route::post('v1/WashOrder/info', 'Business\WashOrderController@info'); //订单列表-详情
        Route::post('v1/WashOrder/settlement', 'Business\WashOrderController@settlement'); //订单列表-结算
        Route::post('v1/WashOrder/cancelSettlement', 'Business\WashOrderController@cancelSettlement'); //订单列表-撤销结算
        Route::post('v1/WashOrder/getmyVip', 'Business\WashOrderController@getmyVip'); //订单列表-结算-获取会员卡
        Route::post('v1/WashOrder/cancel', 'Business\WashOrderController@cancel'); //订单列表-取消订单
        Route::post('v1/WashOrder/afterSale', 'Business\WashOrderController@afterSale'); //订单列表-转售后
        Route::post('v1/WashOrder/createWork', 'Business\WashOrderController@createWork'); //订单列表-生成工单
        Route::post('v1/WashOrder/export', 'Business\WashOrderController@export'); //订单列表-导出
        Route::post('v1/WashOrder/remark', 'Business\WashOrderController@remark'); //订单列表-添加备注
        Route::post('v1/WashOrder/appointmentSet', 'Business\WashOrderController@appointmentSet'); //订单列表-预约设置
        Route::post('v1/WashOrder/validateCar', 'Business\WashOrderController@validateCar'); //订单列表-验车
        Route::post('v1/WashOrder/signatureSubmit', 'Business\WashOrderController@signatureSubmit'); //订单列表-签字
        Route::post('v1/WashOrder/addOrderWorks', 'Business\WashOrderController@addOrderWorks'); //订单列表-添加作品
        Route::post('v1/WashOrder/OrderWorksindex', 'Business\WashOrderController@OrderWorksindex'); //订单列表-作品列表
        Route::post('v1/WashOrder/OrderWorksinfo', 'Business\WashOrderController@OrderWorksinfo'); //订单列表-作品详情
        Route::post('v1/WashOrder/OrderWorksedit', 'Business\WashOrderController@OrderWorksedit'); //订单列表-作品编辑
        Route::post('v1/WashOrder/OrderWorksdel', 'Business\WashOrderController@OrderWorksdel'); //订单列表-作品删除
        Route::post('v1/WashOrder/auditOrder', 'Business\WashOrderController@auditOrder'); //订单列表-订单修正
        Route::post('v1/WashOrder/receive', 'Business\WashOrderController@receive'); //订单列表-接单，小程序接单
        Route::post('v1/WashOrder/getorderpic', 'Business\WashOrderController@getorderpic'); //订单列表-查看凭证
        Route::post('v1/WashOrder/getPaymentWay', 'Business\WashOrderController@getPaymentWay'); //获取支付方式
        Route::post('v1/WashOrder/addPerson', 'Business\WashOrderController@addPerson'); //订单列表-生成工单-新增技师
        Route::post('v1/WashOrder/exchangeGoods', 'Business\WashOrderController@exchangeGoods'); //订单列表-换货
        Route::post('v1/WashOrder/getRefundWay', 'Business\WashOrderController@getRefundWay'); //订单列表-换货退款方式
        Route::post('v1/WashOrder/getPayWay', 'Business\WashOrderController@getPayWay'); //订单列表-换货付款方式
        Route::post('v1/WashOrder/searchWarehouse', 'Business\WashOrderController@searchWarehouse'); //订单列表-接单查询仓库
        Route::post('v1/WashOrder/recOrder', 'Business\WashOrderController@recOrder'); //订单列表-修改领取状态
        Route::post('v1/WashOrder/lead', 'Business\WashOrderController@lead'); //订单列表-数据导入
        Route::post('v1/WashOrder/executeLead', 'Business\WashOrderController@executeLead'); //订单列表-执行导入数据
        Route::post('v1/WashOrder/getTitle', 'Business\WashOrderController@getTitle'); //获取表头
        Route::post('v1/WashOrder/setTitle', 'Business\WashOrderController@setTitle'); //设置表头
        Route::post('v1/WashOrder/orderType', 'Business\WashOrderController@orderType'); //订单类型
        Route::post('v1/WashOrder/addOrderType', 'Business\WashOrderController@addOrderType'); //订单类型-新增
        Route::post('v1/WashOrder/editOrderType', 'Business\WashOrderController@editOrderType'); //订单类型-编辑
        Route::post('v1/WashOrder/startOrderType', 'Business\WashOrderController@startOrderType'); //订单类型-启用
        Route::post('v1/WashOrder/stopOrderType', 'Business\WashOrderController@stopOrderType'); //订单类型-停用
        Route::post('v1/WashOrder/setUpDefault', 'Business\WashOrderController@setUpDefault'); //订单类型-设置默认
        Route::post('v1/WashOrder/suspended', 'Business\WashOrderController@suspended'); //订单挂起
        Route::post('v1/WashOrder/cancelSuspended', 'Business\WashOrderController@cancelSuspended'); //取消订单挂起
        Route::post('v1/WashOrder/basicSet', 'Business\WashOrderController@basicSet'); //基础设置
        Route::post('v1/WashOrder/openBill', 'Business\WashOrderController@openBill'); //订单开票
        Route::post('v1/WashOrder/auditCancel', 'Business\WashOrderController@auditCancel'); //取消订单审核

        // 业务系统-工单列表
        Route::post('v1/WashWork/index', 'Business\WashWorkController@index'); //工单列表-列表
        Route::post('v1/WashWork/export', 'Business\WashWorkController@export'); //工单列表-列表导出
        Route::post('v1/WashWork/check', 'Business\WashWorkController@check'); //工单列表-工单审核
        Route::post('v1/WashWork/info', 'Business\WashWorkController@info'); //工单列表-详情
        Route::post('v1/WashWork/validateCar', 'Business\WashWorkController@validateCar'); //工单详情-验车按钮
        Route::post('v1/WashWork/cancel', 'Business\WashWorkController@cancel'); //工单列表-取消工单
        Route::post('v1/WashWork/afterSale', 'Business\WashWorkController@afterSale'); //工单列表-转售后
        Route::post('v1/WashWork/remark', 'Business\WashWorkController@remark'); //工单列表-添加备注
        Route::post('v1/WashWork/appointmentSet', 'Business\WashWorkController@appointmentSet'); //工单列表-预约设置
        Route::post('v1/WashWork/assign', 'Business\WashWorkController@assign'); //工单列表-预约设置
        Route::post('v1/WashWork/getMeritPay', 'Business\WashWorkController@getMeritPay'); //工单审核-获取绩效金额
        Route::post('v1/WashWork/getMeritPayCar', 'Business\WashWorkController@getMeritPayCar'); //工单审核-获取车型
        Route::post('v1/WashWork/getConstructionHistory', 'Business\WashWorkController@getConstructionHistory'); //工单审核-施工历史
        // 排班计划
        Route::post('v1/WashWork/planIndex', 'Business\WashWorkController@planIndex'); //工单列表-排班计划
        Route::post('v1/WashWork/setPlanTitle', 'Business\WashWorkController@setPlanTitle'); //工单列表-排班计划
        Route::post('v1/WashWork/withdraw', 'Business\WashWorkController@withdraw'); //工单列表-撤回工单
        Route::post('v1/WashWork/userPicState', 'Business\WashWorkController@userPicState'); //工单列表-是否展示工单图片给客户
        Route::post('v1/WashWork/listWorkPic', 'Business\WashWorkController@listWorkPic'); //工单列表-是否展示工单图片给客户-全局
        Route::post('v1/WashWork/auditWork', 'Business\WashWorkController@auditWork'); //工单列表-施工审核

        
        // 业务系统-预约单列表
        Route::post('v1/Reservation/index', 'Business\ReservationController@index'); //预约单列表-列表
        Route::post('v1/Reservation/info', 'Business\ReservationController@info'); //预约单列表-详情
        Route::post('v1/Reservation/cancel', 'Business\ReservationController@cancel'); //预约单列表-取消
        Route::post('v1/Reservation/remark', 'Business\ReservationController@remark'); //预约单列表-添加备注
        Route::post('v1/Reservation/appointmentSet', 'Business\ReservationController@appointmentSet'); //预约单列表-预约设置
        // 业务系统-售后列表
        Route::post('v1/WashAfterSales/index', 'Business\WashAfterSalesController@index'); //售后列表-列表
        Route::post('v1/WashAfterSales/info', 'Business\WashAfterSalesController@info'); //售后列表-详情
        Route::post('v1/WashAfterSales/dealWith', 'Business\WashAfterSalesController@dealWith'); //售后列表-确认处理
        Route::post('v1/WashAfterSales/assignTechnician', 'Business\WashAfterSalesController@assignTechnician'); //售后列表-指派技师
        Route::post('v1/WashAfterSales/cancel', 'Business\WashAfterSalesController@cancel'); //售后列表-撤销售后
        Route::post('v1/WashAfterSales/applyComplete', 'Business\WashAfterSalesController@applyComplete'); //售后列表-申请完成
        Route::post('v1/WashAfterSales/auditPass', 'Business\WashAfterSalesController@auditPass'); //售后列表-审核通过
        Route::post('v1/WashAfterSales/auditReject', 'Business\WashAfterSalesController@auditReject'); //售后列表-审核驳回
        Route::post('v1/WashAfterSales/remark', 'Business\WashAfterSalesController@remark'); //售后列表-添加备注

        // 财务系统 -- 绩效明细
        Route::post('v1/WashPerformance/index', 'Finance\WashPerformanceController@index'); //绩效明细-列表
        Route::post('v1/WashPerformance/info', 'Finance\WashPerformanceController@info'); //绩效明细-详情
        Route::post('v1/WashPerformance/lead', 'Finance\WashPerformanceController@lead'); //绩效明细-导出

        // 财务系统 -- 充值管理
        Route::post('v1/WashRecharge/index', 'Finance\WashRechargeController@index'); //充值管理-列表
        Route::post('v1/WashRecharge/add', 'Finance\WashRechargeController@add'); //充值管理-新增
        Route::post('v1/WashRecharge/info', 'Finance\WashRechargeController@info'); //充值管理-详情
        Route::post('v1/WashRecharge/edit', 'Finance\WashRechargeController@edit'); //充值管理-编辑
        Route::post('v1/WashRecharge/start', 'Finance\WashRechargeController@start'); //充值管理-启用
        Route::post('v1/WashRecharge/stop', 'Finance\WashRechargeController@stop'); //充值管理-停用
        Route::post('v1/WashRecharge/accountCancellation', 'Finance\WashRechargeController@accountCancellation'); //充值管理-销户
        Route::post('v1/WashRecharge/recharge', 'Finance\WashRechargeController@recharge'); //充值管理-充值
        // 财务系统 -- 罚单管理
        Route::post('v1/WashViolation/index', 'Finance\WashViolationController@index'); //罚单列表
        Route::post('v1/WashViolation/info', 'Finance\WashViolationController@info'); //罚单列表
        Route::post('v1/WashViolation/add', 'Finance\WashViolationController@add'); //新增
        Route::post('v1/WashViolation/reject', 'Finance\WashViolationController@reject'); //驳回
        Route::post('v1/WashViolation/restore', 'Finance\WashViolationController@restore'); //恢复
        Route::post('v1/WashViolation/test', 'Finance\WashViolationController@test'); //ceshi

        // 基础管理 -- 作品管理
        Route::post('v1/WorkManagement/index', 'BasicManage\WorkManagementController@index'); //作品管理-列表 
        Route::post('v1/WorkManagement/add', 'BasicManage\WorkManagementController@add'); //作品管理-新增
        Route::post('v1/WorkManagement/edit', 'BasicManage\WorkManagementController@edit'); //作品管理-编辑
        Route::post('v1/WorkManagement/start', 'BasicManage\WorkManagementController@start'); //作品管理-启用
        Route::post('v1/WorkManagement/ivstart', 'BasicManage\WorkManagementController@ivstart'); //作品管理-启用(视频图文)
        Route::post('v1/WorkManagement/stop', 'BasicManage\WorkManagementController@stop'); //作品管理-停用
        Route::post('v1/WorkManagement/ivstop', 'BasicManage\WorkManagementController@ivstop'); //作品管理-停用(视频图文)
        Route::post('v1/WorkManagement/delete', 'BasicManage\WorkManagementController@delete'); //作品管理-删除
        Route::post('v1/WorkManagement/searchValidateCar', 'BasicManage\WorkManagementController@searchValidateCar'); //作品管理-搜索作品管理数据
        Route::post('v1/WorkManagement/imageform', 'BasicManage\WorkManagementController@imageform'); //上传图片
        Route::post('v1/WorkManagement/delimageform', 'BasicManage\WorkManagementController@delimageform'); //删除图片
        Route::post('v1/WorkManagement/Videoupload', 'BasicManage\WorkManagementController@Videoupload'); //上传视频
        Route::post('v1/WorkManagement/delVideoupload', 'BasicManage\WorkManagementController@delVideoupload'); //删除视频

        // 基础管理 -- 绩效管理
        Route::post('v1/MeritPay/index', 'BasicManage\MeritPayController@index'); //绩效管理-列表
        Route::post('v1/MeritPay/add', 'BasicManage\MeritPayController@add'); //绩效管理-新增
        Route::post('v1/MeritPay/edit', 'BasicManage\MeritPayController@edit'); //绩效管理-编辑
        Route::post('v1/MeritPay/newEdit', 'BasicManage\MeritPayController@newEdit'); //绩效管理-编辑
        Route::post('v1/MeritPay/start', 'BasicManage\MeritPayController@start'); //绩效管理-启用
        Route::post('v1/MeritPay/stop', 'BasicManage\MeritPayController@stop'); //绩效管理-停用
        Route::post('v1/MeritPay/getGradeProfessional', 'BasicManage\MeritPayController@getGradeProfessional'); //绩效管理-获取职位职级
        Route::post('v1/MeritPay/getParts', 'BasicManage\MeritPayController@getParts'); //绩效管理-获取部位金额

        // 基础管理 -- 质检奖惩管理
        Route::post('v1/QualityTesting/index', 'BasicManage\QualityTestingController@index'); //质检奖惩管理-列表
        Route::post('v1/QualityTesting/add', 'BasicManage\QualityTestingController@add'); //质检奖惩管理-新增
        Route::post('v1/QualityTesting/edit', 'BasicManage\QualityTestingController@edit'); //质检奖惩管理-编辑
        Route::post('v1/QualityTesting/start', 'BasicManage\QualityTestingController@start'); //质检奖惩管理-启用
        Route::post('v1/QualityTesting/stop', 'BasicManage\QualityTestingController@stop'); //质检奖惩管理-停用

        // 基础管理 -- 分享模板管理
        Route::post('v1/ShareTemplate/index', 'BasicManage\ShareTemplateController@index'); //分享模板管理-列表
        Route::post('v1/ShareTemplate/info', 'BasicManage\ShareTemplateController@info'); //分享模板管理-列表
        Route::post('v1/ShareTemplate/add', 'BasicManage\ShareTemplateController@add'); //分享模板管理-新增
        Route::post('v1/ShareTemplate/edit', 'BasicManage\ShareTemplateController@edit'); //分享模板管理-编辑
        Route::post('v1/ShareTemplate/start', 'BasicManage\ShareTemplateController@start'); //分享模板管理-启用
        Route::post('v1/ShareTemplate/stop', 'BasicManage\ShareTemplateController@stop'); //分享模板管理-停用
        Route::post('v1/ShareTemplate/delete', 'BasicManage\ShareTemplateController@delete'); //分享模板管理-删除

        // 运营系统 -- 企业客户
        Route::post('v3/Business/index', 'Operation\BusinessController@index'); //企业客户-列表
        Route::post('v3/Business/add', 'Operation\BusinessController@add'); //企业客户-新增
        Route::post('v3/Business/busdelete', 'Operation\BusinessController@busdelete'); //企业客户-删除
        Route::post('v3/Business/edit', 'Operation\BusinessController@edit'); //企业客户-编辑
        Route::post('v3/Business/start', 'Operation\BusinessController@start'); //企业客户-启用
        Route::post('v3/Business/stop', 'Operation\BusinessController@stop'); //企业客户-停用

        Route::post('v3/Business/accIndex', 'Operation\BusinessController@accIndex'); //企业客户-停用
        Route::post('v3/Business/addAccount', 'Operation\BusinessController@addAccount'); //企业客户-账号新增
        Route::post('v3/Business/accdelete', 'Operation\BusinessController@accdelete'); //企业客户-账号新增
        Route::post('v3/Business/downTemplate', 'Operation\BusinessController@downTemplate'); //企业客户-导入模板
        Route::post('v3/Business/lead', 'Operation\BusinessController@lead'); //企业客户-账号导入

        // 商城系统-会员卡
        Route::post('v3/VipCard/index', 'Shop\VipCardController@index'); //会员卡-列表
        Route::post('v3/VipCard/add', 'Shop\VipCardController@add'); //会员卡-新增
        Route::post('v3/VipCard/edit', 'Shop\VipCardController@edit'); //会员卡-编辑
        Route::post('v3/VipCard/start', 'Shop\VipCardController@start'); //会员卡-上架
        Route::post('v3/VipCard/stop', 'Shop\VipCardController@stop'); //会员卡-下架
        // 会员列表
        Route::post('v3/VipCard/addvipcard', 'Shop\VipCardController@addvipcard'); //会员卡-绑定会员
        Route::post('v3/VipCard/vipCardIndex', 'Shop\VipCardController@vipCardIndex'); //会员列表-我的会员卡
        Route::post('v3/VipCard/detailIndex', 'Shop\VipCardController@detailIndex'); //会员列表-我的会员卡使用明细
        // 商品列表
        Route::post('v3/Goods/addClassification', 'Shop\GoodsController@addClassification'); //商品列表-添加分类
        Route::post('v3/Goods/editClassification', 'Shop\GoodsController@editClassification'); //商品列表-编辑分类
        Route::post('v3/Goods/claStart', 'Shop\GoodsController@claStart'); //商品列表-分类开启
        Route::post('v3/Goods/claStop', 'Shop\GoodsController@claStop'); //商品列表-分类关闭
        Route::post('v3/Goods/claDelete', 'Shop\GoodsController@claDelete'); //商品列表-分类删除
        Route::post('v3/Goods/classificationIndex', 'Shop\GoodsController@classificationIndex'); //商品列表-分类列表
        Route::post('v3/Goods/getClassification', 'Shop\GoodsController@getClassification'); //商品列表-获取分类
        Route::post('v3/Goods/add', 'Shop\GoodsController@add'); //商品列表-新增商品
        Route::post('v3/Goods/index', 'Shop\GoodsController@index'); //商品列表-商品列表
        Route::post('v3/Goods/info', 'Shop\GoodsController@info'); //商品列表-商品详情
        Route::post('v3/Goods/edit', 'Shop\GoodsController@edit'); //商品列表-商品编辑
        Route::post('v3/Goods/start', 'Shop\GoodsController@start'); //商品列表-商品上架
        Route::post('v3/Goods/stop', 'Shop\GoodsController@stop'); //商品列表-商品下架
        Route::post('v3/Goods/replenishment', 'Shop\GoodsController@replenishment'); //商品列表-商品补货
        Route::post('v3/Goods/paitLogIndex', 'Shop\GoodsController@paitLogIndex'); //商品列表-商品操作记录
        Route::post('v3/Goods/correlation', 'Shop\GoodsController@correlation'); //商品列表-关联
        Route::post('v3/Goods/delCorrelation', 'Shop\GoodsController@delCorrelation'); //商品列表-解除关联
        Route::post('v3/Goods/colist', 'Shop\GoodsController@colist'); //商品列表-关联商品
        Route::post('v3/Goods/package', 'Shop\GoodsController@package'); //商品
        
        /*****采购单******/
        Route::post('v3/Purchase/createShopCode', 'Shop\PurchaseController@createShopCode'); //商品
        Route::post('v3/Purchase/getShop', 'Shop\PurchaseController@getShop'); //获取门店
        Route::post('v3/Purchase/getFshop', 'Shop\PurchaseController@getFshop'); //获取门店
        Route::post('v3/Purchase/getShopInfo', 'Shop\PurchaseController@getShopInfo'); //获取门店信息
        Route::post('v3/Purchase/getShopGoods', 'Shop\PurchaseController@getShopGoods'); //获取门店商品
        Route::post('v3/Purchase/add', 'Shop\PurchaseController@add'); //下单
        Route::post('v3/Purchase/index', 'Shop\PurchaseController@index'); //列表
        Route::post('v3/Purchase/wholesale', 'Shop\PurchaseController@wholesale'); //采购单列表
        Route::post('v3/Purchase/receive', 'Shop\PurchaseController@receive'); //接单
        Route::post('v3/Purchase/purchasingPlan', 'Shop\PurchaseController@purchasingPlan'); //采购计划列表
        Route::post('v3/Purchase/planInfo', 'Shop\PurchaseController@planInfo'); //采购计划详情
        Route::post('v3/Purchase/getPlanGoods', 'Shop\PurchaseController@getPlanGoods'); //采购计划快速采购获取商品
        Route::post('v3/Purchase/getUnit', 'Shop\PurchaseController@getUnit'); //获取单位

        Route::post('v1/appoinTimeJudge', 'Business\WashWorkController@appoinTimeJudge'); //根据预约时间返回限制预约数量

        // *****************运营系统*****************
        // 门店列表
        Route::post('v3/StoreList/add', 'Operation\StoreListController@add'); //新增
        // *****************运营系统*****************

        // 积分设置
        Route::post('v3/Point/pointConfig', 'Point\PointController@pointConfig'); //积分设置
        Route::post('v3/Point/pointGoods', 'Point\PointController@pointGoods'); //积分设置-商品列表
        Route::post('v3/Point/addPointGoods', 'Point\PointController@addPointGoods'); //积分设置-新增积分商品
        Route::post('v3/Point/editPointGoods', 'Point\PointController@editPointGoods'); //积分设置-编辑积分商品
        Route::post('v3/Point/editState', 'Point\PointController@editState'); //积分设置-编辑积分商品
        Route::post('v3/Point/getType', 'Point\PointController@getType'); //积分设置-获取商品类型
        Route::post('v3/Point/getGoods', 'Point\PointController@getGoods'); //积分设置-获取商品
        //签到设置
        Route::post('v3/Point/signinConfig', 'Point\PointController@signinConfig'); //签到设置
        Route::post('v3/Point/addSignGoods', 'Point\PointController@addSignGoods'); //签到设置-新增签到礼品
        Route::post('v3/Point/editSignGoods', 'Point\PointController@editSignGoods'); //签到设置-编辑签到礼品
        Route::post('v3/Point/signGoods', 'Point\PointController@signGoods'); //签到礼品
        Route::post('v3/Point/signState', 'Point\PointController@signState'); //终止签到礼品
        Route::post('v3/Point/getSignState', 'Point\PointController@getSignState'); //获取签到礼品状态
        Route::post('v3/Point/getSignWay', 'Point\PointController@getSignWay'); //获取签到礼品状态
        Route::post('v3/Point/getSignNum', 'Point\PointController@getSignNum'); //获取签到礼品状态
        Route::post('v3/Point/shareConfig', 'Point\PointController@shareConfig'); //分享设置
        Route::post('v3/Point/getPointGift', 'Point\PointController@getPointGift'); //积分商品类型
        Route::post('v3/Point/addPointGift', 'Point\PointController@addPointGift'); //新增积分商品
        Route::post('v3/Point/getProperties', 'Point\PointController@getProperties'); //获取活动属性
        Route::post('v3/Point/index', 'Point\PointController@index'); //积分商品列表
        Route::post('v3/Point/editPointGift', 'Point\PointController@editPointGift'); //编辑积分商品
        Route::post('v3/Point/poggState', 'Point\PointController@poggState'); //开启关闭积分商品

        // 销售员绩效设置
        Route::post('v3/ProPerformance/index', 'Shop\ProPerformanceController@index'); //绩效列表
        Route::post('v3/ProPerformance/add', 'Shop\ProPerformanceController@add'); //新增
        Route::post('v3/ProPerformance/edit', 'Shop\ProPerformanceController@edit'); //编辑

        Route::post('v3/ProPerformance/ordersp', 'Shop\ProPerformanceController@ordersp'); //订单销售绩效
        Route::post('v3/ProPerformance/export', 'Shop\ProPerformanceController@export'); //订单销售绩效导出
        Route::post('v3/ProPerformance/start', 'Shop\ProPerformanceController@start'); //销售绩效开启类型
        Route::post('v3/ProPerformance/getPerType', 'Shop\ProPerformanceController@getPerType'); //销售绩效开启类型
        Route::post('v3/ProPerformance/getOrderPer', 'Shop\ProPerformanceController@getOrderPer'); //销售绩效按订单类型查询
    });
});

// 用户小程序路由
Route::namespace('WeChatApplet')->group(function () {
    // 需要验证是否登录
    Route::post('u1/WashOrder/OrderWorksinfo', 'User\WashOrderController@OrderWorksinfo'); //订单列表-订单作品详情
    Route::post('u1/Pay/otherTransactionsJsapi', 'User\PayController@otherTransactionsJsapi'); //微信支付
    Route::post('u1/Pay/otherReqAccount', 'User\PayController@otherReqAccount'); //微信分账-其他小程序
    Route::post('u1/Pay/otherApplyRefund', 'User\PayController@otherApplyRefund'); //微信申请退款-其他小程序
    Route::post('u1/Pay/otherNotifyRefund', 'User\PayController@otherNotifyRefund'); //微信申请退款回调-其他小程序
    
    Route::post('u1/Pay/notifyPay', 'User\PayController@notifyPay'); //微信支付回调地址
    Route::post('u1/Pay/notifyRefund', 'User\PayController@notifyRefund'); //微信退款回调地址
    Route::post('u1/Pay/otherNotifyPay', 'User\PayController@otherNotifyPay'); //微信退款回调地址
    Route::post('u1/Pay/reqAccount', 'User\PayController@reqAccount'); //微信支付分账
    Route::post('u1/Pay/finishAccount', 'User\PayController@finishAccount'); //其他系统微信支付解冻
    Route::post('u1/WeixinUser/todaySign', 'User\WeixinUserController@todaySign'); //微信用户-今天是否签到
    Route::post('u1/WeixinUser/getActionList', 'User\WeixinUserController@getActionList'); //微信用户-栏目展示
    Route::group(['middleware' => ['UserWechatAppletLogin']], function () {
        Route::post('u1/WashOrder/index', 'User\WashOrderController@index'); //订单列表-列表
        Route::post('u1/WashOrder/reindex', 'User\WashOrderController@reindex'); //订单列表-预约单列表
        Route::post('u1/WashOrder/reinfo', 'User\WashOrderController@reinfo'); //订单列表-预约单详情
        Route::post('u1/WashOrder/info', 'User\WashOrderController@info'); //订单列表-详情
        Route::post('u1/WashOrder/signatureSubmit', 'User\WashOrderController@signatureSubmit'); //订单列表-签字提交
        Route::post('u1/WashOrder/getOrderHistory', 'User\WashOrderController@getOrderHistory'); //订单列表-订单历史
        Route::post('u1/WashOrder/cancel', 'User\WashOrderController@cancel'); //订单列表-客户取消订单
        Route::post('u1/WashOrder/validateCarData', 'User\WashOrderController@validateCarData'); //订单列表-验车结果
        Route::post('u1/WashOrder/OrderWorks', 'User\WashOrderController@OrderWorks'); //订单列表-订单作品
        Route::post('u1/WashOrder/addPointOrder', 'User\WashOrderController@addPointOrder'); //积分商品兑换
        Route::post('u1/WashOrder/recOrder', 'User\WashOrderController@recOrder'); //修改
        
        // ====================微信小程序支付===========================
        Route::post('u1/Pay/transactionsJsapi', 'User\PayController@transactionsJsapi'); //微信支付
        Route::post('u1/Pay/wxpay', 'User\PayController@wxpay'); //微信支付
        Route::post('u1/Pay/wechatPaySuccess', 'User\PayController@wechatPaySuccess'); //微信支付成功
        Route::post('u1/Pay/wechatPayError', 'User\PayController@wechatPayError'); //微信支付取消-失败
        

        Route::post('u1/UserMessage/index', 'User\UserMessageController@index'); //消息列表
        Route::post('u1/UserMessage/read', 'User\UserMessageController@read'); //阅读消息
        Route::post('u1/UserMessage/unreadTotal', 'User\UserMessageController@unreadTotal'); //未读消息总数

        Route::post('u1/UserSearch/index', 'User\UserSearchController@index'); //用户搜索记录列表
        Route::post('u1/UserSearch/clearRecord', 'User\UserSearchController@clearRecord'); //清空历史搜索记录
        Route::post('u1/UserSearch/searchGooods', 'User\UserSearchController@searchGooods'); //用户搜索商品信息
        Route::post('u1/UserSearch/searchHot', 'User\UserSearchController@searchHot'); //热门推荐

        Route::post('u1/UserAddress/index', 'User\UserAddressController@index'); //用户地址搜索记录列表
        Route::post('u1/UserAddress/searchRecord', 'User\UserAddressController@searchRecord'); //用户的地址搜索记录
        Route::post('u1/UserAddress/clearRecord', 'User\UserAddressController@clearRecord'); //用户地址清空历史记录

        Route::post('u1/Reservation/add', 'User\ReservationController@add'); //预约单下单新增
        Route::post('u1/Reservation/addOrder', 'User\ReservationController@addOrder'); //新预约单下单新增
        Route::post('u1/Reservation/addvipcard', 'User\ReservationController@addVipCard'); //购买会员卡
        Route::post('u1/Reservation/addGoodsOrder', 'User\ReservationController@addGoodsOrder'); //购买纯商品
        Route::post('u1/Reservation/getmyVip', 'User\ReservationController@getmyVip'); //车主下单获取会员卡
        Route::post('u1/Reservation/getlastReli', 'User\ReservationController@getlastReli'); //预约单获取上一个预约单信息
        Route::post('u1/Reservation/withdraw', 'User\ReservationController@withdraw'); //预约单列表-撤回

        Route::post('u1/WeixinUser/info', 'User\WeixinUserController@info'); //微信用户-用户信息
        Route::post('u1/WeixinUser/edit', 'User\WeixinUserController@edit'); //微信用户-修改个人信息
        Route::post('u1/WeixinUser/myvip', 'User\WeixinUserController@myvip'); //微信用户-我的会员卡
        Route::post('u1/WeixinUser/myVipInfo', 'User\WeixinUserController@myVipInfo'); //微信用户-我的会员卡
        Route::post('u1/WeixinUser/vipQrcode', 'User\WeixinUserController@vipQrcode'); //微信用户-我的会员卡-生成二维码
        Route::post('u1/WeixinUser/getVipQrcode', 'User\WeixinUserController@getVipQrcode'); //微信用户-我的会员卡-获取二维码
        
        Route::post('u1/WeixinUser/myvipDetail', 'User\WeixinUserController@myvipDetail'); //微信用户-我的会员卡-使用明细
        Route::post('u1/WeixinUser/myPoints', 'User\WeixinUserController@myPoints'); //微信用户-我的积分
        Route::post('u1/WeixinUser/myPointsInfo', 'User\WeixinUserController@myPointsInfo'); //微信用户-我的积分-明细
        Route::post('u1/WeixinUser/signRule', 'User\WeixinUserController@signRule'); //微信用户-签到规则
        Route::post('u1/WeixinUser/signGoods', 'User\WeixinUserController@signGoods'); //微信用户-签到规则
        Route::post('u1/WeixinUser/getSigninData', 'User\WeixinUserController@getSigninData'); //微信用户-签到数据
        Route::post('u1/WeixinUser/sign', 'User\WeixinUserController@sign'); //微信用户-签到
        Route::post('u1/WeixinUser/activities', 'User\WeixinUserController@activities'); //微信用户-其他活动积分
        Route::post('u1/WeixinUser/claimPoints', 'User\WeixinUserController@claimPoints'); //微信用户-其他活动积分-领取
        
        Route::post('u1/WeixinUser/shareBind', 'User\WeixinUserController@shareBind'); //微信用户-绑定分享人
        Route::post('u1/WeixinUser/phoneBind', 'User\WeixinUserController@phoneBind'); //微信用户-通过手机号绑定分享人
        Route::post('u1/WeixinUser/invitation', 'User\WeixinUserController@invitation'); //微信用户-受邀记录
        Route::post('u1/WeixinUser/shareQrCode', 'User\WeixinUserController@shareQrCode'); //微信用户-二维码分享
        
        Route::post('u1/WeixinUser/claimSignGoods', 'User\WeixinUserController@claimSignGoods'); //微信用户-领取签到礼品
        Route::post('u1/WeixinUser/banlance', 'User\WeixinUserController@banlance'); //微信用户-余额明细
        Route::post('u1/EvaluatePart/add', 'User\EvaluatePartController@add'); //订单列表-用户评价

        Route::post('u1/MemberCar/index', 'User\MemberCarController@index'); //车辆管理-列表
        Route::post('u1/MemberCar/add', 'User\MemberCarController@add'); //车辆管理-新增
        Route::post('u1/MemberCar/edit', 'User\MemberCarController@edit'); //车辆管理-编辑
        Route::post('u1/MemberCar/info', 'User\MemberCarController@info'); //车辆管理-详情
        Route::post('u1/MemberCar/carDefault', 'User\MemberCarController@carDefault'); //车辆管理-详情

        Route::post('u1/MemberLevel/info', 'User\MemberLevelController@info'); //会员等级-个人会员页面
        Route::post('u1/MemberLevel/list', 'User\MemberLevelController@list'); //会员等级-等级列表
        Route::post('u1/MemberLevel/blackInfo', 'User\MemberLevelController@blackInfo'); //会员等级-黑钻页面
        Route::post('u1/MemberLevel/goodsList', 'User\MemberLevelController@goodsList'); //会员等级-我的礼品列表
        Route::post('u1/MemberLevel/useLevelGoods', 'User\MemberLevelController@useLevelGoods'); //会员等级-使用礼品
        Route::post('u1/MemberLevel/buyBlack', 'User\MemberLevelController@buyBlack'); //会员等级-购买黑钻
        Route::post('u1/MemberLevel/addOrder', 'User\MemberLevelController@addOrder'); //会员等级-下单黑钻
        Route::post('u1/MemberLevel/cancelOrder', 'User\MemberLevelController@cancelOrder'); //会员等级-取消下单黑钻
    });

    Route::post('u1/weixinAuth', 'WeChatAuthController@weixinAuth'); //微信授权
    Route::post('u1/pcWeixinAuth', 'WeChatAuthController@pcWeixinAuth'); //微信授权
    Route::post('u1/decryption', 'WeChatAuthController@decryption'); //微信数据解密
    Route::post('u1/WeixinUser/login', 'User\WeixinUserController@login'); //微信用户-用户登录
    Route::post('u1/WeixinUser/getCode', 'User\WeixinUserController@getCode'); //微信用户-用户登录获取验证码
    Route::post('u1/WeixinUser/getList', 'User\WeixinUserController@getList'); //微信用户-获取手机号
    Route::post('u1/WeixinUser/shopList', 'User\WeixinUserController@shopList'); //微信用户-登录过的门店列表
    Route::post('u1/WeixinUser/delPhone', 'User\WeixinUserController@delPhone'); //微信用户-用户解绑手机号
    Route::post('u1/WeixinUser/changeShop', 'User\WeixinUserController@changeShop'); //微信用户-用户解绑手机号
    Route::post('u1/WeixinUser/pcLogin', 'User\WeixinUserController@pcLogin'); //微信用户-用户登录
    

    Route::post('u1/EvaluatePart/index', 'User\EvaluatePartController@index'); //评价列表
    Route::post('u1/UserShop/index', 'User\UserShopController@index'); //用户的门店-列表
    Route::post('u1/UserShop/info', 'User\UserShopController@info'); //门店详情
    Route::post('u1/UserShop/getClassification', 'User\UserShopController@getClassification'); //获取分类
    Route::post('u1/UserShop/getGoods', 'User\UserShopController@getGoods'); //获取商品
    Route::post('u1/UserShop/getVip', 'User\UserShopController@getVip'); //获取会员卡
    Route::post('u1/UserShop/getRecommendGoods', 'User\UserShopController@getRecommendGoods'); //获取推荐商品
    Route::post('u1/UserShop/getOrderWork', 'User\UserShopController@getOrderWork'); //获取案例
    Route::post('u1/UserShop/goodsInfo', 'User\UserShopController@goodsInfo'); //商品详情
    Route::post('u1/UserShop/goodsOrderWork', 'User\UserShopController@goodsOrderWork'); //商品案例
    Route::post('u1/UserShop/vipCardInfo', 'User\UserShopController@vipCardInfo'); //会员卡详情
    Route::post('u1/UserShop/dataValidation', 'User\UserShopController@dataValidation'); //数据验证
    Route::post('u1/UserShop/companyProfile', 'User\UserShopController@companyProfile'); //获取公司信息
    Route::post('u1/UserShop/pointGoods', 'User\UserShopController@pointGoods'); //积分商城
    Route::post('u1/UserShop/pointGoodsInfo', 'User\UserShopController@pointGoodsInfo'); //积分商品详情
    Route::post('u1/UserShop/getAppointNum', 'User\UserShopController@getAppointNum'); //获取可预约数量

    Route::post('u1/UserSearch/searchService', 'User\UserSearchController@searchService'); //用户搜索服务信息

    Route::post('u1/ProductionManage/index', 'User\ProductionManageController@index'); //作品管理-列表 
    Route::post('u1/ProductionManage/info', 'User\ProductionManageController@info'); //作品管理-详情
});


Route::group(['prefix' => 'Common', 'namespace' => 'Common'], function () {

    Route::get('technicals/{shopID}/title', 'TechnicalsController@title'); //
    Route::get('technicals/{shopID}/level', 'TechnicalsController@level'); //
    Route::get('technicals/{shopID}/index', 'TechnicalsController@index'); //
    Route::any('auto/parts', 'AutoController@parts'); //车辆部位
    Route::post('searchPhoneData', 'CommonController@searchPhoneData'); //判定手机信息是否存在

    Route::group(['middleware' => ['islogin']], function () {
        Route::post('excelPerson', 'CommonController@excelPerson'); //设置个人权限
    });
});

Route::group(['prefix' => 'Dou', 'namespace' => 'Dou'], function () {
    Route::any('MyTest/test', 'MyTestController@test'); //车辆部位

});

// Route::group(['middleware'=>['islogin']],function(){
//     Route::post('v1/login',"Order\OrderController@remark_list");    //订单备注列表
// });
// php artisan make:controller Api/OtherSystemInterfaces/zptz/zptzSystemOrdersController
// php artisan make:controller WeChatApplet/Technician/ValidateCarManageController
// php artisan make:controller Mounting/BasicManage/MeritPayController
// php artisan make:controller Mounting/BasicManage/GradeProfessionalController
// php artisan make:request Validators/BasicManagement/GradeProfessionalValidator
// php artisan make:controller Mounting/BasicManage/ProductionManageController
// php artisan make:model Http/Models/Services/ProductManage/GoodsList
// php artisan make:model Models/BasicManagement/GradeLevel
// php artisan make:model Services/Software/QrCodeService
// php artisan make:middleware IsLogin
// php artisan make:model Http/Enum/Business/WorkOrderEnum