<?php

namespace App\Services\WeChatApplet\user;

use App\Models\WeChatApplet\User\WeixinUser;
use App\Services\LoginUserService;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\User\WeixinUserValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Crypt;
use App\Http\Controllers\Api\LoginController;
use App\Services\WeChatApplet\Technician\MemberService;
use App\Services\Point\PointService;
use App\Services\Business\NewOrderService;
use App\Models\Common;
use App\Services\Business\WashOrderService;
use App\Services\Software\QrCodeService;
use App\Services\WeChatApplet\user\MemberLevelService as leService;

// 用户小程序-用户信息
class WeixinUserService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WeixinUser();
        $this->mainValidator = new WeixinUserValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    // 登录
    public static function login($request, $show_count = 10)
    {
        $weus_id = DB::table('weixin_user')
            ->where('weus_openid', $request['weus_openid'])
            ->value('weus_id');
        if (empty($weus_id)) {//新微信用户
            if (!isset($request['code']) || empty($request['code'])) {
                return ['code'=>500, 'msg'=>'请填写验证码', 'data'=>''];
            }
            // 查看是否发送验证码
            $find_phone_code = DB::table('phone_code')
                ->where('phc_type', 1)
                ->where('phc_code', $request['code'])
                ->where('phc_phone', $request['weus_phone'])
                ->exists();
            if (empty($find_phone_code)) {
                return ['code'=>500, 'msg'=>'验证码错误', 'data'=>''];
            }
            $find_phone_code = DB::table('phone_code')
                ->where('phc_type', 1)
                ->where('phc_code', $request['code'])
                ->where('phc_phone', $request['weus_phone'])
                ->update(['phc_type'=>2]);
            // 不存在就新增用户
            $data['weus_openid'] = $request['weus_openid'];
            if (isset($request['weus_session_key'])) {
                $data['weus_session_key'] = $request['weus_session_key'];
            }
            $data['weus_nickmame'] = $request['weus_phone'];
            $data['weus_phone'] = $request['weus_phone'];
            $data['weus_shop_id'] = $request['shop_id'];
            $data['weus_update_time'] = date('Y-m-d H:i:s');
            $weus_id = DB::table('weixin_user')->insertGetId($data);   
        } else {
            $weus_update_res = DB::table('weixin_user')
                ->where('weus_id', $weus_id)
                ->update(['weus_shop_id'=>$request['shop_id'],'weus_update_time'=>date('Y-m-d H:i:s')]);
        }
        // 查询手机号与门店的关系是否存在绑定关系
        $find_user_shop_data = DB::table('user_shop')
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_phone', $request['weus_phone'])
            ->where('ussh_now_login', 1)
            ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
            ->first();
        // 根据手机号查询当前门店用户的会员是否存在，不存在默认新增会员,与微信用户绑定
        if (empty($find_user_shop_data)) {
            $mem_id = DB::table('member')
                ->where('mem_shop_id', $request['shop_id'])
                ->where('mem_phone', $request['weus_phone'])
                ->value('mem_id');
            if (!$mem_id) {
                // 新增门店会员
                $add_mem_data['mem_superior_shop_id'] = $request['shop_id'];
                $add_mem_data['mem_cid'] = 1;
                $add_mem_data['mem_shop_id'] = $request['shop_id'];
                $add_mem_data['mem_name'] = $request['weus_phone'];
                $add_mem_data['mem_phone'] = $request['weus_phone'];
                $add_mem_data['mem_sex'] = 3;
                $mem_id = MemberService::addMember($add_mem_data);
            }
        } else {
            $mem_id = $find_user_shop_data->ussh_user_id;
        }
        // 查询手机号与门店的关系是否存在绑定关系
        $find_user_data = DB::table('user_shop')
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_phone', $request['weus_phone'])
            ->where('ussh_weus_id', $weus_id)
            ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone', 'ussh_weus_id')
            ->first();
        if (empty($find_user_data)) {
            if (!isset($request['code']) || empty($request['code'])) {
                return ['code'=>500, 'msg'=>'请填写验证码', 'data'=>''];
            }
            // 查看是否发送验证码
            $find_phone_code = DB::table('phone_code')
                ->where('phc_type', 1)
                ->where('phc_code', $request['code'])
                ->where('phc_phone', $request['weus_phone'])
                ->exists();
            if (empty($find_phone_code)) {
                return ['code'=>500, 'msg'=>'验证码错误', 'data'=>''];
            }
            $find_phone_code = DB::table('phone_code')
                ->where('phc_type', 1)
                ->where('phc_code', $request['code'])
                ->where('phc_phone', $request['weus_phone'])
                ->update(['phc_type'=>2]);
            $find_ussh = DB::table('user_shop')
                ->where('ussh_shop_id', $request['shop_id'])
                ->where('ussh_weus_id', $weus_id)
                ->where('ussh_phone', '')
                ->select('ussh_phone', 'ussh_id')
                ->first();

            // 用户没有与当前门店绑定，把用户与当前门店绑定
            $ussh_data['ussh_weus_id'] = $weus_id;
            $ussh_data['ussh_shop_id'] = $request['shop_id'];
            $ussh_data['ussh_user_type'] = 1;
            $ussh_data['ussh_phone'] = $request['weus_phone'];
            $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
            $ussh_data['ussh_user_id'] = $mem_id;
            $ussh_data['ussh_now_login'] = 1;
            if (empty($find_ussh)) {
                $ussh_data['ussh_register_time'] = date('Y-m-d H:i:s');
                $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
            } else {
                $ussh_res = DB::table('user_shop')->where('ussh_id', $find_ussh->ussh_id)->update($ussh_data);
                $ussh_id = $find_ussh->ussh_id;
            }
            if (!$ussh_id) {
                return ['code'=>500, 'msg'=>'登录失败2', 'data'=>''];
            }
            $new_ussh['ussh_now_login'] = 2;
            $new_ussh_id = DB::table('user_shop')
                ->where('ussh_id', '<>', $ussh_id)
                ->where('ussh_weus_id', $weus_id)
                ->update($new_ussh);
        } else {
            $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
            $ussh_data['ussh_now_login'] = 1;
            $ussh_id = DB::table('user_shop')->where('ussh_id', $find_user_data->ussh_id)->update($ussh_data);
            $new_ussh['ussh_now_login'] = 2;
            $ussh_id = DB::table('user_shop')
                ->where('ussh_id', '<>', $find_user_data->ussh_id)
                ->where('ussh_weus_id', $find_user_data->ussh_weus_id)
                ->update($new_ussh);
        }
        $mem_data = DB::table('member')->where('mem_id', $mem_id)->select('mem_name', 'mem_phone', 'mem_image')->first();
        if ($mem_data) {
            $return_data['weus_phone'] = $mem_data->mem_phone;
            $return_data['weus_nickmame'] = $mem_data->mem_name;
            $return_data['weus_headimgurl'] = $mem_data->mem_image;
            $return_data['meca_car_data'] = DB::table('member_car')
                ->where('meca_mem_id', $mem_id)
                ->where('meca_shop_id', $request['shop_id'])
                ->where('meca_default', 1)
                ->select('meca_car_num', 'meca_car_series', 'meca_car_model', 'meca_car_brand_series', 'meca_car_frame')
                ->first();
        } else {
            $return_data['weus_phone'] = '';
            $return_data['weus_nickmame'] = '';
            $return_data['weus_headimgurl'] = '';
            $return_data['meca_car_data'] = DB::table('member_car')
                ->where('meca_mem_id', $mem_id)
                ->where('meca_shop_id', $request['shop_id'])
                ->where('meca_default', 1)
                ->select('meca_car_num', 'meca_car_series', 'meca_car_model', 'meca_car_brand_series', 'meca_car_frame')
                ->first();
        }

        // 查询店铺信息
        $list_data = DB::table('user_shop as a')
            ->leftJoin('shop as b', 'a.ussh_shop_id', '=', 'b.shop_id')
            ->where(function ($query) use ($request) { //门店id
                if (!empty($request['shop_id'])) {
                    $query->where('ussh_shop_id', $request['shop_id']);
                }
            })
            ->where('ussh_weus_id', $weus_id)
            ->where('ussh_now_login', 1)
            ->where('ussh_phone', $request['weus_phone'])
            ->select('shop_id', 'shop_store_name', 'shop_phone', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'shop_image', 'shop_state', 'shop_longitude', 'shop_latitude', 'ussh_user_id')
            ->orderBy('ussh_create_time', 'desc')
            ->first();

        // // 查询微信用户openid,手机号是否存在
        // $find_weixin_data = DB::table('weixin_user as w')
        //     ->leftJoin('user_shop as u', 'u.ussh_weus_id', '=', 'w.weus_id')
        //     ->where(function ($query) use ($request) { //手机号/openid
        //         $query->where('weus_openid', $request['weus_openid']);
        //             // ->orwhere('weus_phone', $request['weus_phone']);
        //     })
        //     // ->where('ussh_shop_id', $request['shop_id'])
        //     ->where('ussh_phone', $request['weus_phone'])
        //     ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
        //     ->first();
        // // if (empty($find_weixin_data)) {
        // //     $find_weixin_data = DB::table('weixin_user')
        // //         ->where(function ($query) use ($request) { //手机号/openid
        // //             $query->where('weus_phone', $request['weus_phone']);
        // //                 // ->orwhere('weus_phone', $request['weus_phone']);
        // //         })
        // //         // ->where('weus_openid', $request['weus_openid'])
        // //         // ->where('weus_phone', $request['weus_phone'])
        // //         ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
        // //         ->first();
        // // }
        // $return_data = (array)$find_weixin_data;
        // if (empty($find_weixin_data)) {
        //     if (!isset($request['code']) || empty($request['code'])) {
        //         return ['code'=>500, 'msg'=>'请填写验证码', 'data'=>''];
        //     }
        //     // 查看是否发送验证码
        //     $find_phone_code = DB::table('phone_code')
        //         ->where('phc_type', 1)
        //         ->where('phc_code', $request['code'])
        //         ->where('phc_phone', $request['weus_phone'])
        //         ->exists();
        //     if (empty($find_phone_code)) {
        //         return ['code'=>500, 'msg'=>'验证码错误', 'data'=>''];
        //     }
        //     // 不存在就新增用户
        //     $data['weus_openid'] = $request['weus_openid'];
        //     if (isset($request['weus_session_key'])) {
        //         $data['weus_session_key'] = $request['weus_session_key'];
        //     }
        //     $data['weus_phone'] = $request['weus_phone'];
        //     $data['weus_nickmame'] = $request['weus_nickmame'];
        //     $data['weus_follow'] = Request::input('weus_follow', '1');
        //     $data['weus_sex'] = Request::input('weus_sex', 0);
        //     // $data['weus_province'] = Request::input('weus_province', '');
        //     // $data['weus_city'] = Request::input('weus_city', '');
        //     // $data['weus_headimgurl'] = Request::input('weus_headimgurl', '');
        //     $data['weus_province'] = !empty($request['weus_province']) ? $request['weus_province'] : '';
        //     $data['weus_city'] = !empty($request['weus_city']) ? $request['weus_city'] : '';
        //     $data['weus_headimgurl'] = !empty($request['weus_headimgurl']) ? $request['weus_headimgurl'] : '';
        //     $data['weus_update_time'] = date('Y-m-d H:i:s');
        //     $weus_id = DB::table('weixin_user')->insertGetId($data);
        //     if (!$weus_id) {
        //         return ['code'=>500, 'msg'=>'登录失败', 'data'=>''];
        //     }
        //     $data['weus_id'] = $weus_id;
        //     unset($data['weus_update_time']);
        //     $return_data = $data;
        // } else {
        //     // 更新微信用户信息
        //     $edit_weus['weus_phone'] = $request['weus_phone'];
        //     if (isset($request['weus_session_key'])) {
        //         $edit_weus['weus_session_key'] = $request['weus_session_key'];
        //     }
        //     $edit_weus['weus_openid'] = $request['weus_openid'];
        //     $edit_weus['weus_nickmame'] = $request['weus_nickmame'];
        //     if (!empty($request['weus_headimgurl'])) {
        //         $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
        //     }
        //     $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
        //     $edit_weus_res = DB::table('weixin_user')
        //         ->where('weus_id', $find_weixin_data->weus_id)
        //         ->update($edit_weus);
        //     unset($edit_weus);
        //     $weus_id = $find_weixin_data->weus_id;

        //     $return_data['weus_id'] = $weus_id;
        //     $return_data['weus_phone'] = $request['weus_phone'];
        //     $return_data['weus_nickmame'] = $request['weus_nickmame'];
        //     $return_data['weus_headimgurl'] = $request['weus_headimgurl'];
        // }

        // if (!empty($request['shop_id'])) {
        //     // 查询微信用户与门店的关系是否存在绑定关系
        //     $find_user_shop_data = DB::table('user_shop')
        //         ->where('ussh_weus_id', $weus_id)
        //         ->where('ussh_shop_id', $request['shop_id'])
        //         ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
        //         ->first();
        //     // 根据手机号查询当前门店用户的会员是否存在，不存在默认新增会员,与微信用户绑定
        //     if (!empty($request['weus_phone'])) {
        //         $find_mem_data = DB::table('member')
        //             ->where('mem_phone', $request['weus_phone'])
        //             ->where('mem_shop_id', $request['shop_id'])
        //             ->select('mem_id', 'mem_name', 'mem_phone','mem_level')
        //             ->first();
        //         if (empty($find_mem_data)) {
        //             $find_shop_cid = DB::table('shop')
        //                 ->where('shop_id', $request['shop_id'])
        //                 ->value('shop_cid');
        //             // 新增门店会员
        //             $add_mem_data['mem_superior_shop_id'] = $request['shop_id'];
        //             $add_mem_data['mem_cid'] = $find_shop_cid;
        //             $add_mem_data['mem_shop_id'] = $request['shop_id'];
        //             $add_mem_data['mem_name'] = $request['weus_nickmame'];
        //             $add_mem_data['mem_phone'] = $request['weus_phone'];
        //             if (isset($request['weus_sex'])) {
        //                 $add_mem_data['mem_sex'] = $request['weus_sex'];
        //             } else {
        //                 $add_mem_data['mem_sex'] = 3;
        //             }
        //             // $mem_id = DB::table('member')->insertGetId($add_mem_data);
        //             $mem_id = MemberService::addMember($add_mem_data);
        //             $ussh_data['ussh_user_id'] = $mem_id;
        //             unset($add_mem_data);
        //         } else {
        //             $ussh_data['ussh_user_id'] = $find_mem_data->mem_id;

        //             // 更新会员的名称
        //             // $edit_mem['mem_name'] = $request['weus_nickmame'];
        //             // $edit_mem['mem_update_time'] = date('Y-m-d H:i:s');
        //             // DB::table('member')->where('mem_id',$find_mem_data->mem_id)->update($edit_mem);
        //         }
        //     }

        //     if (empty($find_user_shop_data)) {
        //         // 用户没有与当前门店绑定，把用户与当前门店绑定
        //         $ussh_data['ussh_weus_id'] = $weus_id;
        //         $ussh_data['ussh_shop_id'] = $request['shop_id'];
        //         $ussh_data['ussh_user_type'] = 1;
        //         $ussh_data['ussh_phone'] = $request['weus_phone'];
        //         $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
        //         $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
        //         if (!$ussh_id) {
        //             return ['code'=>500, 'msg'=>'登录失败2', 'data'=>''];
        //         }
        //     } else {
        //         if (empty($find_user_shop_data->ussh_user_id)) {
        //             $ussh_data['ussh_user_type'] = 1;
        //             $ussh_data['ussh_phone'] = $request['weus_phone'];
        //             $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
        //             $ussh_id = DB::table('user_shop')
        //                 ->where('ussh_id', $find_user_shop_data->ussh_id)
        //                 ->update($ussh_data);
        //         }
        //     }
        // }

        // // 查询店铺信息
        // $list_data = DB::table('user_shop as a')
        //     ->leftJoin('shop as b', 'a.ussh_shop_id', '=', 'b.shop_id')
        //     ->where(function ($query) use ($request) { //门店id
        //         if (!empty($request['shop_id'])) {
        //             $query->where('ussh_shop_id', $request['shop_id']);
        //         }
        //     })
        //     ->where('ussh_weus_id', $weus_id)
        //     ->select('shop_id', 'shop_store_name', 'shop_phone', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'shop_image', 'shop_state', 'shop_longitude', 'shop_latitude', 'ussh_user_id')
        //     ->orderBy('ussh_create_time', 'desc')
        //     ->first();

        // 查询登录表id
        $login_id = DB::table('login_user_wechat_applet')
            ->where("openid", $request['weus_openid'])
            ->value('id');
        $unique_string = md5(uniqid(md5(microtime(true)) . rand(100000, 999999), true)); //生成唯一字符串
        $api_token = sha1($unique_string); //加密
        $crypt_api_token = Crypt::encrypt($api_token); //生成前台token

        $old_login_res = DB::table('login_user_wechat_applet')
            ->where('adm_phone', $request['weus_phone'])
            ->update(['api_token'=>'']);
        if ($login_id) {
            // 更新登录信息
            $login_data['weus_id'] = $weus_id;
            $login_data['api_token'] = $api_token;
            $login_data['adm_phone'] = $request['weus_phone'];
            $login_data['last_login'] = time() + 4*60*60;//4个小时有效时间
            $login_res = DB::table('login_user_wechat_applet')
                ->where("id", $login_id)
                ->update($login_data);
        } else {
            // 插入登录信息
            $login_data['openid'] = $request['weus_openid'];
            $login_data['weus_id'] = $weus_id;
            $login_data['api_token'] = $api_token;
            $login_data['adm_phone'] = $request['weus_phone'];
            $login_data['last_login'] = time() + 4*60*60;//4个小时有效时间
            $login_res = DB::table('login_user_wechat_applet')->insertGetId($login_data);
        }

        $return_data['api_token'] = $crypt_api_token;
        $return_data['shop_data'] = $list_data;
        $return_data['weus_id'] = $weus_id;
        $return_data['ussh_user_id'] = $list_data->ussh_user_id;
        $return_data['meca_car_data'] = DB::table('member_car')
            ->where('meca_mem_id', $list_data->ussh_user_id)
            ->where(function ($query) use ($request) { //门店id
                if (!empty($request['shop_id'])) {
                    $query->where('meca_shop_id', $request['shop_id']);
                }
            })
            ->where('meca_default', 1)
            ->select('meca_car_num', 'meca_car_series', 'meca_car_model', 'meca_car_brand_series', 'meca_car_frame')
            ->first();
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
    }

    // 小程序授权登录pc
    public static function pcLogin($request, $show_count = 10)
    {
        // 根据openid查询用户id
        $find_admin = DB::table('admin as a')
            ->leftjoin('role', 'role.rol_id', '=', 'a.adm_role')
            ->where("adm_bjfw_openid", $request['adm_bjfw_openid'])
            ->select('adm_id', 'adm_name', 'adm_account', 'adm_phone', 'adm_cid', 'adm_shop_id', 'adm_state', 'rol_state', 'rol_privilege', 'rol_privilege_multiple', 'adm_superior_shop_id')
            ->first();
        if (empty($find_admin)) {
            return ['code'=>500, 'msg'=>'请先授权', 'data'=>'请先授权'];
        }

        if (empty($find_admin->adm_phone)) {
            $update_data['adm_phone'] = $request['adm_phone'];
            $update_data['adm_name'] = $request['adm_phone'];
            $update_data['adm_password'] = md5(substr($request['adm_phone'],-6));
            $update_data['adm_update_time'] = date('Y-m-d H:i:s');
            $update_data_res = DB::table('admin')
                ->where('adm_id', $find_admin->adm_id)
                ->update($update_data);
        } else {
            $find_admin_shop_role = DB::table('admin_shop_role')
                ->where('adm_id', $find_admin->adm_id)
                ->where('adm_shop_leave', 1)
                ->first();
            if ($find_admin_shop_role) {
                $update_qrdata['shqr_scan_adm_id'] = $find_admin->adm_id;
                $update_qrdata['shqr_state'] = 6;//二维码状态1未扫码2已扫码3取消失效4授权成功5过期失效
                $update_qrdata['shqr_update_time'] = date('Y-m-d H:i:s');
                $update_qrres = DB::table('shop_qr')
                    ->where('shqr_number', $request['shqr_number'])
                    ->update($update_qrdata);
                return ['code'=>200, 'msg'=>'您已注册门店，请直接前往登录', 'data'=>'您已注册门店，请直接前往登录'];
            }
        }
        $update_shqr_res = DB::table('shop_qr')
            ->where('shqr_number', $request['shqr_number'])
            ->update(['shqr_state'=>4, 'shqr_scan_adm_id'=>$find_admin->adm_id,'shqr_update_time'=>date('Y-m-d H:i:s')]);
        if (empty($find_admin->adm_shop_id)) {
            // 查询登录表id
            $find_login = DB::table('login_temporary')
                ->where('adm_id', '=', $find_admin->adm_id)
                ->select('adm_id', 'last_login')
                ->first();
            // 生成token
            $unique_string = md5(uniqid(md5(microtime(true)) . rand(100000, 999999), true)); //生成唯一字符串
            $api_token = sha1($unique_string); //加密
            if (empty($find_login)) {
                // 如果用户第一次登陆,将用户的登录状态保存到临时表
                $lote_data['adm_id'] = $find_admin->adm_id; //账号id
                $lote_data['last_login'] = time() + 2 * 60 * 60; //最后登陆时间
                $lote_data['api_token'] = $api_token; //api_token
                $lote_data['adm_name'] = $find_admin->adm_name; //账号姓名
                $lote_data['adm_phone'] = $find_admin->adm_phone; //手机号
                $lote_data['adm_cid'] = $find_admin->adm_cid; //公司id
                $lote_data['shop_versions'] = 0; //系统版本：0试用1门店版2运营中心版
                $lote_res = DB::table('login_temporary')->insert($lote_data);
                if (empty($lote_res)) {
                    return ['code'=>500, 'msg'=>'登录失败', 'data'=>'api_token写入失败'];
                }
            } else {
                // 修改登陆状态
                $lote_data['last_login'] = time() + 2 * 60 * 60; //最后登陆时间
                $lote_data['api_token'] = $api_token; //api_token
                $lote_data['adm_name'] = $find_admin->adm_name; //账号姓名
                $lote_data['adm_phone'] = $find_admin->adm_phone; //手机号
                $lote_data['adm_cid'] = $find_admin->adm_cid; //公司id
                $lote_data['adm_shop_id'] = $find_admin->adm_shop_id; //门店id
                $lote_data['shop_superior_id'] = $find_admin->adm_shop_id; //所属总店id
                $lote_data['shop_versions'] = 0; //系统版本：1门店版2运营中心版
                $lote_data['role_auth'] = ''; //当前账号所有角色权限
                $lote_data['auth_routes'] = ''; //当前账号所有角色权限路径
                $lote_res = DB::table('login_temporary')
                    ->where('adm_id', $find_admin->adm_id)
                    ->update($lote_data);
            }
            // 返回数据
            $return_data = [
                'api_token' => Crypt::encrypt($api_token), //生成前台token
                'default_url' => 'zhuce.com', //默认跳转页面
                'adm_id' => $find_admin->adm_id,
                'adm_name' => $find_admin->adm_name,
                'adm_phone' => $find_admin->adm_phone,
                'shop_id' => $find_admin->adm_shop_id,
                'shop_store_name' => '',
                'shop_type' => 0,
                'shop_province' => '',
                'shop_city' => '',
                'shop_county' => '',
                'shop_longitude' => '',
                'shop_latitude' => '',
                'shop_versions' => 0,
            ];
            return ['code'=>200, 'msg'=>'登录成功，请前往注册', 'data'=>$return_data];
        }

        // 判断账号时效
        if (!empty($find_admin->adm_shop_id) && !in_array($find_admin->adm_shop_id, config('apisystem.NO_TIME_CHECK'))) {
            $sup_shop_info = DB::table('shop')
                ->where('shop_id', $find_admin->adm_shop_id)
                ->select('shop_opening_end_time', 'shop_opening_start_time', 'shop_on_trial_end_time', 'shop_on_trial_start_time')
                ->first();
            if ($sup_shop_info) {
                $time = time();
                // 判断试用是否到期
                if ($time > strtotime($sup_shop_info->shop_on_trial_end_time)) {
                    // 过期判断开通结束时间
                    if ($time > strtotime($sup_shop_info->shop_opening_end_time)) {
                        // 已过期 将权限隐藏
                        // 查询所有权限
                        $where['pri_show'] = 1;
                        $where['pri_type'] = 3;
                        $pri_res = DB::table('privileges')->where($where)->select('pri_id')->get()->toArray();
                        // 当前账号权限转为数组
                        $rol_privilege_arr = explode(',', $find_admin->rol_privilege);
                        foreach ($pri_res as $v) {
                            if (in_array($v->pri_id, $rol_privilege_arr)) {
                                $key = array_search($v->pri_id, $rol_privilege_arr);
                                unset($rol_privilege_arr[$key]);
                            } elseif (in_array(1, $rol_privilege_arr)) {
                                $key = array_search(1, $rol_privilege_arr);
                                unset($rol_privilege_arr[$key]);
                            } elseif (in_array(102, $rol_privilege_arr)) {
                                $key = array_search(102, $rol_privilege_arr);
                                unset($rol_privilege_arr[$key]);
                            }
                        }
                        $find_admin->rol_privilege = implode(',', $rol_privilege_arr);
                    }
                }
            } else {
                return ['code'=>500, 'msg'=>'查询总店信息失败', 'data'=>'查询总店信息失败'];
            }
        }

        // 查询门店信息
        $find_shop = DB::table('shop')
            ->where('shop_id', $find_admin->adm_shop_id)
            ->select('shop_state', 'shop_superior_id', 'shop_store_name', 'shop_type', 'shop_longitude', 'shop_latitude', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'shop_versions')
            ->first();
        if ($find_shop->shop_state != 1) {
            return ['code'=>500, 'msg'=>'当前账号所属门店已被停用', 'data'=>'当前账号所属门店已被停用'];
        }
         // 查询账号设置表的经纬度
        $find_admin_set = DB::table('admin_set')
            ->where('adms_adm_id', $find_admin->adm_id)
            ->where('adms_shop_id', $find_admin->adm_shop_id)
            ->select('adms_province', 'adms_city', 'adms_county', 'adms_address', 'adms_longitude', 'adms_latitude')
            ->first();

        // 查询门店信息
        $find_shop = DB::table('shop')
            ->where('shop_id', $find_admin->adm_shop_id)
            ->select('shop_state', 'shop_superior_id', 'shop_store_name', 'shop_type', 'shop_longitude', 'shop_latitude', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'shop_versions')
            ->first();
        if ($find_shop->shop_state != 1) {
            return ['code'=>500, 'msg'=>'当前账号所属门店已被停用', 'data'=>'当前账号所属门店已被停用'];
        }
        if (!empty($find_admin_set)) {
            if ($find_admin_set->adms_longitude != '0' && $find_shop->shop_longitude != '0') {
                $find_shop->shop_longitude = $find_admin_set->adms_longitude;
                $find_shop->shop_latitude = $find_admin_set->adms_latitude;
            }
            if (empty($find_shop->shop_province)) {
                $find_shop->shop_province = $find_admin_set->adms_province;
                $find_shop->shop_city = $find_admin_set->adms_city;
                $find_shop->shop_county = $find_admin_set->adms_county;
            }
        }

        // 生成token
        $unique_string = md5(uniqid(md5(microtime(true)) . rand(100000, 999999), true)); //生成唯一字符串
        $api_token = sha1($unique_string); //加密
        $find_login = DB::table('login_temporary')
            ->where('adm_id', '=', $find_admin->adm_id)
            ->select('adm_id', 'last_login')
            ->first();
        if (empty($find_login)) {
            // 获取用户对应角色权限
            $role_auth = $this->getRolePrivilege($find_admin);
            if (empty($role_auth['routes_auth']) || empty($role_auth['role_auth'])) {
                return ['code'=>500, 'msg'=>'请联系管理员设置员工角色权限！', 'data'=>'请联系管理员设置员工角色权限！'];
            }

            // 确认此账号默认跳转页面
            $default_url = $this->getDefaultPath($role_auth['role_auth']);

            // 如果用户第一次登陆,将用户的登录状态保存到临时表
            $lote_data['adm_id'] = $find_admin->adm_id; //账号id
            $lote_data['last_login'] = time() + 2 * 60 * 60; //最后登陆时间
            $lote_data['api_token'] = $api_token; //api_token
            $lote_data['adm_name'] = $find_admin->adm_name; //账号姓名
            $lote_data['adm_phone'] = $find_admin->adm_phone; //手机号
            $lote_data['adm_cid'] = $find_admin->adm_cid; //公司id
            $lote_data['adm_shop_id'] = $find_admin->adm_shop_id; //门店id
            $lote_data['shop_superior_id'] = $find_admin->adm_shop_id; //门店id
            $lote_data['shop_versions'] = $find_shop->shop_versions; //系统版本：1门店版2运营中心版
            $lote_data['role_auth'] = json_encode($role_auth['role_auth']); //当前账号所有角色权限
            $lote_data['auth_routes'] = json_encode($role_auth['routes_auth']); //当前账号所有角色权限路径
            $lote_res = DB::table('login_temporary')->insert($lote_data);
            if (empty($lote_res)) {
                return ['code'=>500, 'msg'=>'登录失败', 'data'=>'api_token写入失败'];
            }
            // 返回数据
            $return_data = [
                'api_token' => Crypt::encrypt($api_token), //生成前台token
                'default_url' => $default_url, //默认跳转页面
                'adm_id' => $find_admin->adm_id,
                'adm_name' => $find_admin->adm_name,
                'adm_phone' => $find_admin->adm_phone,
                'shop_id' => $find_admin->adm_shop_id,
                'shop_store_name' => $find_shop->shop_store_name,
                'shop_type' => $find_shop->shop_type,
                'shop_province' => $find_shop->shop_province,
                'shop_city' => $find_shop->shop_city,
                'shop_county' => $find_shop->shop_county,
                'shop_longitude' => $find_shop->shop_longitude,
                'shop_latitude' => $find_shop->shop_latitude,
                'shop_versions' => $find_shop->shop_versions,
            ];
            // 删除订单和工单临时商品信息
            $find_orgt_id = DB::table('order_goods_temporary')
                ->where('orgt_adm_id', $find_admin->adm_id)
                ->delete();
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        }

        $now_time = time();

        // 当前时间大于最后登陆时间，登录时间已过期，重新登录
        // login_type 值为1 强制登录
        // 查找此用户对应得角色权限
        $login = new LoginController();
        $role_auth = $login->getRolePrivilege($find_admin);

        // 确认此账号默认跳转页面
        $default_url = $login->getDefaultPath($role_auth['role_auth']);

        // 修改登陆状态
        $lote_data['last_login'] = time() + 2 * 60 * 60; //最后登陆时间
        $lote_data['api_token'] = $api_token; //api_token
        $lote_data['adm_name'] = $find_admin->adm_name; //账号姓名
        $lote_data['adm_phone'] = $find_admin->adm_phone; //手机号
        $lote_data['adm_cid'] = $find_admin->adm_cid; //公司id
        $lote_data['adm_shop_id'] = $find_admin->adm_shop_id; //门店id
        $lote_data['shop_superior_id'] = $find_admin->adm_shop_id; //所属总店id
        $lote_data['shop_versions'] = $find_shop->shop_versions; //系统版本：1门店版2运营中心版
        $lote_data['role_auth'] = json_encode($role_auth['role_auth']); //当前账号所有角色权限
        if (!isset($role_auth['routes_auth'])) {
            return ['code'=>500, 'msg'=>'此账号无权限', 'data'=>'此账号无权限'];
        }
        $lote_data['auth_routes'] = json_encode($role_auth['routes_auth']); //当前账号所有角色权限路径
        $lote_res = DB::table('login_temporary')
            ->where('adm_id', $find_admin->adm_id)
            ->update($lote_data);
        if (empty($lote_res)) {
            return ['code'=>500, 'msg'=>'登录失败', 'data'=>'api_token写入失败'];
        }
        // 返回数据
        $return_data = [
            'api_token' => Crypt::encrypt($api_token), //生成前台token
            'default_url' => $default_url, //默认跳转页面
            'adm_id' => $find_admin->adm_id,
            'adm_name' => $find_admin->adm_name,
            'adm_phone' => $find_admin->adm_phone,
            'shop_id' => $find_admin->adm_shop_id,
            'shop_store_name' => $find_shop->shop_store_name,
            'shop_type' => $find_shop->shop_type,
            'shop_province' => $find_shop->shop_province,
            'shop_city' => $find_shop->shop_city,
            'shop_county' => $find_shop->shop_county,
            'shop_longitude' => $find_shop->shop_longitude,
            'shop_latitude' => $find_shop->shop_latitude,
            'shop_versions' => $find_shop->shop_versions, //系统版本：1门店版2运营中心版
        ];
        // 删除订单和工单临时商品信息
        $find_orgt_id = DB::table('order_goods_temporary')
            ->where('orgt_adm_id', $find_admin->adm_id)
            ->delete();
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];

        $return_data['api_token'] = $crypt_api_token;
        $return_data['shop_data'] = $list_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
    }

    // 详情
    public static function info($request)
    {
        $data = DB::table('weixin_user')
            ->leftJoin('user_shop', 'ussh_weus_id', '=', 'weus_id')
            ->leftjoin('member as m', function ($join){
                $join->on('m.mem_phone', '=', 'ussh_phone')
                    ->on('m.mem_shop_id', '=', 'ussh_shop_id');
            })
            ->where('mem_shop_id', $request['shop_id'])
            ->where('weus_id', $request['weus_id'])
            // ->where('ussh_now_login', 1)
            ->where('ussh_user_id', $request['ussh_user_id'])
            ->select('weus_id', 'ussh_phone as weus_phone', 'mem_name as weus_nickmame', 'mem_points', 'mem_birthday', 'mem_image as weus_headimgurl')
            ->first();
        $data->is_experience = 1;
        //当前经验值
        //$user_info = LoginUserService::getUser();
        //$mem_value = leService::currentExperience($user_info);
        $mem_level_count = DB::table('member_level')
            ->where('meml_shop_id', $request['shop_id'])
            ->where('meml_show', 2)
            ->count();
        if($mem_level_count > 0){
            $mem = DB::table('member')
                ->where('mem_shop_id', $request['shop_id'])
                ->where('mem_phone', $data->weus_phone)
                ->first();
            $all_price = 0;
            $amount = DB::table('order')
                ->where('ord_shop_id', $request['shop_id'])
                ->whereIN('ord_wor_state', [4,18,19,20])
                ->where('ord_delete', 1)
                ->where('ord_add_type', 1)
                ->where('ord_client_id', $mem->mem_id)
                ->select('ord_actual_price','ord_mem_price')
                ->get()->toArray();
            foreach ($amount as $key => $value){
                if($value->ord_mem_price > 0){
                    $price = $value->ord_mem_price;
                }else{
                    $price = $value->ord_actual_price;
                }
                $all_price += $price;
            }
            $data->experience = intval(intval($all_price) / 100);
            $data->is_experience = 2;
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 编辑
    public static function edit($user_info,$request)
    {

        if(!empty($request['weus_headimgurl'])) {
            $data['weus_headimgurl'] = $request['weus_headimgurl'];
        }
        $data['weus_nickmame'] = $request['weus_nickmame'];
        // $data['weus_phone'] = $request['weus_phone'];
        $data['weus_update_time'] = date('Y-m-d H:i:s');
        $edit_res = DB::table('weixin_user')
            ->where('weus_id', $request['weus_id'])
            ->update($data);
        $update_data['mem_image'] = $request['weus_headimgurl'];
        $update_data['mem_name'] = $request['weus_nickmame'];
        $update_data['mem_birthday'] = $request['weus_birthday'];
        $update_data['mem_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->update($update_data);
        if ($edit_res && $update_data) {
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'修改失败', 'data'=>''];
        }
    }

    // 生成会员卡二维码
    public static function vipQrcode($user_info,$request)
    {
        $find_myvi_data = DB::table('myvip')
            ->where('myvi_id', $request['myvi_id'])
            ->select('myvi_id', 'myvi_create_time', 'myvi_surplus_times', 'myvi_long_term', 'myvi_effective_date', 'myvi_end_time')
            ->first();
        if (empty($find_myvi_data)) {
            return ['code'=>200, 'msg'=>'会员卡不存在', 'data'=>'会员卡不存在'];
        }
        if ($find_myvi_data->myvi_surplus_times == 0) {
            return ['code'=>200, 'msg'=>'会员卡剩余次数为0', 'data'=>'会员卡剩余次数为0'];
        }
        $time = (time() - strtotime($find_myvi_data->myvi_end_time))/86400;
        if ($find_myvi_data->myvi_long_term == 2 && $time > 0) {
            return ['code'=>200, 'msg'=>'会员卡已过期', 'data'=>'会员卡已过期'];
        }
        $add_data['vico_myvi_id'] = $request['myvi_id'];
        $add_data['vico_create_time'] = date("Y-m-d H:i:s");
        $add_data['vico_end_time'] = date("Y-m-d H:i:s", time()+30*60);
        $vico_id = DB::table('vip_code')->insertGetId($add_data);
        // $QrCodeService = new QrCodeService();
        // // $type = 1;//类型：1创建二维码不保存图片2创建二维码并保存图片
        // $text = 'vico_id='.$user_info->adm_shop_id;
        // $qrCode = $QrCodeService->qrCode(2, $text);
        // $update_data['vico_img'] = $qrCode;
        // $update_data_res = DB::table('vip_code')->where('vico_id', $vico_id)->update($update_data);
        $data['vico_id'] = $vico_id;
        $data['vico_end_time'] = $add_data['vico_end_time'];
        if ($vico_id) {
            return ['code'=>200, 'msg'=>'生成成功', 'data'=>$data];
        } else {
            return ['code'=>200, 'msg'=>'生成失败', 'data'=>'生成失败'];
        }
    }

    // 获取会员卡二维码
    public static function getVipQrcode($user_info,$request)
    {
        $info = DB::table('vip_code')
            ->where('vico_myvi_id', $request['myvi_id'])
            ->select('vico_end_time', 'vico_id', 'vico_state')
            ->orderBy('vico_create_time', 'desc')
            ->first();
        if ($info) {
            $time = time() - strtotime($info->vico_end_time);
            if ($time > 0 || $info->vico_state == 2) {
                $res = self::vipQrcode($user_info,$request);
                return $res;
            } else {
                return ['code'=>200, 'msg'=>'获取二维码成功', 'data'=>$info];
            }
        } else {
            $res = self::vipQrcode($user_info,$request);
            return $res;
        }
    }

    /**
     * 我的积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-18
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function myPoints($user_info,$request)
    {
        $mem_id = DB::table('user_shop')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->value('ussh_user_id');
        $mem_points = DB::table('member')
            ->where('mem_id', $mem_id)
            ->value('mem_points');
        if (empty($request['time'])) {
            $time = date('Y-m-d');
        } else {
            $time = date('Y-m-d', strtotime('-1 month', strtotime($request['time'])));
        }
        for ($i=0;$i<12;$i++) {
            $month = date('Y-m', strtotime('-'.$i.' month', strtotime($time)));
            if ($request['pode_type'] == 1) {
                $pode_type = [1,2];
            } elseif ($request['pode_type'] == 2) {
                $pode_type = [3];
            }
            $find_data = DB::table('point_detail')
                ->where('pode_mem_id', $request['mem_id'])
                ->where('pode_state', 1)
                ->whereIn('pode_type', $pode_type)
                ->where('pode_year_month', $month)
                ->sum('pode_points');
            $data[$i]['date'] = $month;
            $data[$i]['points'] = $find_data;
        }
        $state = DB::table('point_config')
            ->where('poco_shop_id', $request['shop_id'])
            ->value('poco_point_switch');
        $return_data['points'] = $mem_points;
        $return_data['data'] = $data;
        $return_data['state'] = $state;
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];   
    }

    /**
     * 我的积分明细
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-18
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function myPointsInfo($user_info,$request)
    {
        if (empty($request['time'])) {
            $month = date('Y-m');
        } else {
            $month = date('Y-m', strtotime($request['time']));
        }
        if ($request['pode_type'] == 1) {
            $pode_type = [1,2];
        } elseif ($request['pode_type'] == 2) {
            $pode_type = [3];
        }
        $find_data = DB::table('point_detail')
            ->where('pode_mem_id', $request['mem_id'])
            ->wherein('pode_type', $pode_type)
            ->where('pode_state', 1)
            ->where('pode_year_month', $month)
            ->select('pode_points', 'pode_name', 'pode_create_time', 'pode_type')
            ->orderBy('pode_id', 'desc')
            ->get()->toArray();
        
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_data];   
    }

    /**
     * 签到礼品列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-20
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  [type]           $show_count [description]
     * @return [type]                       [description]
     */
    public static function signGoods($user_info,$request)
    {   
        $find_data = DB::table('sign_goods')
            ->where('sigo_shop_id', $user_info->adm_shop_id)
            ->where('sigo_state', 1)
            ->get()->toArray();
        foreach ($find_data as $key1 => $value1) {
            if (date('Y-m-d H:i:s') >= $value1->sigo_start_time) {
                DB::table('sign_goods')->where('sigo_id', $value1->sigo_id)->update(['sigo_state'=>2]);
            }
        }
        $list_data = DB::table('sign_goods')
            ->where('sigo_shop_id', $user_info->adm_shop_id)
            ->where('sigo_state', 2)
            ->select('sigo_id', 'sigo_shop_id', 'sigo_goo_type', 'sigo_goo_name', 'sigo_sign_days', 'sigo_sign_type', 'sigo_state', 'sigo_goo_id', 'sigo_start_time', 'sigo_end_time', 'sigo_create_time', 'sigo_sign_num')
            ->orderBy('sigo_id', 'desc')
            ->get()->toArray();
        if ($list_data) {
            $typeName = PointService::getType(true);//获取类型
            $state = PointService::getSignState(true);
            $way = PointService::getSignWay(true);
            $getSignNum = PointService::getSignNum(true);
            foreach ($list_data as $key => $value) {
                if (date('Y-m-d') > $value->sigo_end_time) {
                    DB::table('sign_goods')->where('sigo_id', $value->sigo_id)->update(['sigo_state'=>3]);
                    unset($list_data[$key]);
                }
                $list_data[$key]->sigo_goo_type_name = PointService::getTypeData($value->sigo_goo_type, $typeName);
                $list_data[$key]->sigo_state_name = PointService::getTypeData($value->sigo_state, $state);
                $list_data[$key]->sigo_sign_type_name = PointService::getTypeData($value->sigo_sign_type, $way);
                $list_data[$key]->sigo_sign_num_name = PointService::getTypeData($value->sigo_sign_num, $getSignNum);
                $list_data[$key]->sigo_start_time = date('Y-m-d', strtotime($value->sigo_start_time));
                $list_data[$key]->sigo_end_time = date('Y-m-d', strtotime($value->sigo_end_time));
                $find_data = DB::table('clisigood_log')
                    ->where('csgl_shop_id', $user_info->adm_shop_id)
                    ->where('csgl_mem_id', $user_info->ussh_user_id)
                    ->where('csgl_sigo_id', $value->sigo_id)
                    ->count();
                if ($value->sigo_sign_type == 1) {//签到类型1累计2连续
                    $sih_num = DB::table('sign_history')
                        ->where('sih_shop_id', $user_info->adm_shop_id)
                        ->where('sih_creact_id', $user_info->ussh_user_id)
                        ->where('sih_day', '>=', $list_data[$key]->sigo_start_time)
                        ->count();
                    $num = intval($sih_num/$value->sigo_sign_days);//可领取次数
                    if ($num > 0) {
                        $sih_num = $sih_num - $find_data * $value->sigo_sign_days;
                    }
                }

                if ($value->sigo_sign_type == 2) {//签到类型1累计2连续
                    $find_sign = DB::table('sign_history')
                        ->where('sih_shop_id', $user_info->adm_shop_id)
                        ->where('sih_creact_id', $user_info->ussh_user_id)
                        ->where('sih_day', '>=', $list_data[$key]->sigo_start_time)
                        ->where('sih_day', '<=', $list_data[$key]->sigo_end_time)
                        ->select('sih_num','sih_id', 'sih_day')
                        ->get()->toArray();
                    $num = 0;//可领取数量
                    $sih_day = 0;
                    $sih_num = 0;//已签到天数
                    foreach ($find_sign as $key1 => $value1) {
                        $dis = $value1->sih_num - $sih_day;
                        if ($dis > 0) {
                            $sih_num++;
                        } else {
                            $sih_num = 1;
                        }
                        if (($sih_num % $value->sigo_sign_days)==0) {
                            $num++;
                        }
                        $sih_day = $value1->sih_num;
                    }
                    if ($num > 0) {
                        $sih_num = $sih_num - $value->sigo_sign_days;
                    }
                }
                $num = $num - $find_data;

                if ($find_data) {//是否已领取
                    $rec_state = 1;
                } else {
                    $rec_state = 2;
                }
                
                $list_data[$key]->sih_num = $sih_num;
                $list_data[$key]->rec_state = $rec_state;
                $list_data[$key]->num = $num;
                if ($num > 0 && $value->sigo_sign_num == 1) {
                    $list_data[$key]->num = 1;
                    if ($find_data) {
                        $list_data[$key]->num = 0;
                    }
                }
            }
        }
        return $list_data;
    }

    /**
     * 其他活动送积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  [type]           $user_info [description]
     * @return [type]                      [description]
     */
    public static function activities($user_info) {
        $find_info = DB::table('point_config')
            ->where('poco_shop_id', $user_info->adm_shop_id)
            ->select('poco_firstord_point', 'poco_phone_point', 'poco_birth_point', 'poco_firstord_times')
            ->first();
        $info_points = $find_info->poco_phone_point + $find_info->poco_birth_point;
        if ($find_info->poco_firstord_times == 1) {//1一次2每月3每年
            $find_pode = DB::table('point_detail')
                ->where('pode_shop_id', $user_info->adm_shop_id)
                ->where('pode_mem_id', $user_info->ussh_user_id)
                // ->where('pode_year_month', 'like',date('Y').'%')
                ->where('pode_add_type', 4)
                ->first();
        } elseif ($find_info->poco_firstord_times == 2) {
            $find_pode = DB::table('point_detail')
                ->where('pode_shop_id', $user_info->adm_shop_id)
                ->where('pode_mem_id', $user_info->ussh_user_id)
                ->where('pode_year_month', date('Y-m'))
                ->where('pode_add_type', 4)
                ->first();
        } elseif ($find_info->poco_firstord_times == 3) {
            $find_pode = DB::table('point_detail')
                ->where('pode_shop_id', $user_info->adm_shop_id)
                ->where('pode_mem_id', $user_info->ussh_user_id)
                ->where('pode_year_month', 'like',date('Y').'%')
                ->where('pode_add_type', 4)
                ->first();
        }
        if ($find_pode) {
            $ord_state = 3;
        } else {
            $ord_state = 1;
        }
        $find_info_data = DB::table('point_detail')
            ->where('pode_shop_id', $user_info->adm_shop_id)
            ->where('pode_mem_id', $user_info->ussh_user_id)
            ->where('pode_add_type', 14)//完善信息
            ->select('pode_id', 'pode_state')
            ->first();
        $find_mem = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->select('mem_phone', 'mem_birthday')
            ->first();
        
        if (!$find_info_data) {
            $info_state = 1;//未完成
            $id = 0;
            if ($find_mem->mem_birthday && $find_mem->mem_phone) {
                $add_point['pode_shop_id'] = $user_info->adm_shop_id;
                $add_point['pode_mem_id'] = $user_info->ussh_user_id;
                $add_point['pode_type'] = 1;
                $add_point['pode_name'] = '完善信息送积分';
                $add_point['pode_points'] = $info_points;
                $add_point['pode_year_month'] = date('Y-m');
                $add_point['pode_create_time'] = date('Y-m-d H:i:s');
                $add_point['pode_create_id'] = 0;
                $add_point['pode_soure'] = 2;
                $add_point['pode_add_type'] = 14;
                $add_point['pode_ord_id'] = 0;
                $add_point['pode_state'] = 2;
                $add_shord_point_res = PointService::addPointDetail($add_point);
                $info_state = 2;//2待领取
                $id = $add_shord_point_res;
            }
        } else {
            $info_state = $find_info_data->pode_state == 2 ? 2:3;
            $id = $find_info_data->pode_id;
        }
        $data = [];
        if ($info_points) {
            $data[] = ['name'=>'完善个人信息','points'=>$info_points,'state'=>$info_state, 'pode_add_type'=>14, 'pode_id'=>$id];
        }
        if ($find_info->poco_firstord_point) {
            $data[] = ['name'=>'首单的积分','points'=>$find_info->poco_firstord_point, 'state'=>$ord_state, 'pode_add_type'=>4,];
        }
        return $data;
    }

    /**
     * 领取积分
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function claimPoints($user_info, $request) {
        $find_data = DB::table('point_detail')
            ->where('pode_id', $request['pode_id'])
            ->first();
        if (!$find_data) {
            return ['code'=>500, 'msg'=>'未查询到数据', 'data'=>''];
        }
        if ($find_data->pode_state != 2) {
            return ['code'=>500, 'msg'=>'不是待领取状态', 'data'=>''];
        }
        DB::beginTransaction();
        $update_res = DB::table('point_detail')
            ->where('pode_id', $request['pode_id'])
            ->update(['pode_state'=>1]);
        $find_mem = DB::table('member')
            ->where('mem_id', $find_data->pode_mem_id)
            ->select('mem_points')
            ->first();
        $mem_points = $find_mem->mem_points + $find_data->pode_points;
        $update_mem = DB::table('member')
            ->where('mem_id', $find_data->pode_mem_id)
            ->update(['mem_points'=>$mem_points,'mem_update_time'=>date('Y-m-d H:i:s')]);
        if ($update_res && $update_mem) {
            return ['code'=>200, 'msg'=>'领取成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'领取失败', 'data'=>''];
        }
    }

    /**
     * 签到礼品-领取
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-21
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function claimSignGoods($user_info,$request)
    {
        $list_data = DB::table('sign_goods')
            ->where('sigo_id', $request['sigo_id'])
            ->select('sigo_id', 'sigo_shop_id', 'sigo_goo_type', 'sigo_goo_name', 'sigo_sign_days', 'sigo_sign_type', 'sigo_state', 'sigo_goo_id', 'sigo_start_time', 'sigo_end_time', 'sigo_create_time', 'sigo_sign_num')
            ->first();
        if ($list_data) {
            $typeName = PointService::getType(true);//获取类型
            $state = PointService::getSignState(true);
            $way = PointService::getSignWay(true);
            $num = PointService::getSignNum(true);
            
            $list_data->sigo_start_time = date('Y-m-d', strtotime($list_data->sigo_start_time));
            $list_data->sigo_end_time = date('Y-m-d', strtotime($list_data->sigo_end_time));
            if ($list_data->sigo_sign_type == 1) {//签到类型1累计2连续
                $sih_num = DB::table('sign_history')
                    ->where('sih_shop_id', $user_info->adm_shop_id)
                    ->where('sih_creact_id', $user_info->ussh_user_id)
                    ->where('sih_day', '>=', $list_data->sigo_start_time)
                    ->count();
                if ($sih_num < $list_data->sigo_sign_days) {
                    return ['code'=>500, 'msg'=>'签到天数不足', 'data'=>''];
                }
            }

            if ($list_data->sigo_sign_num == 1) {//一次
                $find_data = DB::table('clisigood_log')
                    ->where('csgl_shop_id', $user_info->adm_shop_id)
                    ->where('csgl_mem_id', $user_info->ussh_user_id)
                    ->where('csgl_sigo_id', $request['sigo_id'])
                    ->first();
                if ($find_data) {
                    return ['code'=>500, 'msg'=>'此礼品仅可领取一次', 'data'=>''];
                }
            }

            if ($list_data->sigo_sign_num == 2) {//多次
                $find_sign = DB::table('sign_history')
                    ->where('sih_shop_id', $user_info->adm_shop_id)
                    ->where('sih_creact_id', $user_info->ussh_user_id)
                    ->where('sih_day', '>=', $list_data->sigo_start_time)
                    ->where('sih_day', '<=', $list_data->sigo_end_time)
                    ->select('sih_num','sih_id', 'sih_day')
                    ->get()->toArray();
                $num = 0;//可领取数量
                $sih_day = 0;
                $sih_num = 0;//已签到天数
                foreach ($find_sign as $key1 => $value1) {
                    $dis = $value1->sih_num - $sih_day;
                    if ($dis > 0) {
                        $sih_num++;
                    } else {
                        $sih_num = 1;
                    }
                    if (($sih_num % $list_data->sigo_sign_days)==0) {
                        $num++;
                    }
                    $sih_day = $value1->sih_num;
                }
                $find_data = DB::table('clisigood_log')
                    ->where('csgl_shop_id', $user_info->adm_shop_id)
                    ->where('csgl_mem_id', $user_info->ussh_user_id)
                    ->where('csgl_sigo_id', $list_data->sigo_id)
                    ->count();
                $sih_num = $sih_num - $find_data*$list_data->sigo_sign_days;
                $num = $num - $find_data;
                if ($num <= 0) {
                    return ['code'=>500, 'msg'=>'签到天数不足', 'data'=>''];
                }
            }

            // 添加订单
            $poss['goods_data'] = json_decode(json_encode($list_data,true),true);
            $poss['weus_id'] = $request['weus_id'];
            $find_mem = DB::table('member')->where('mem_id', $user_info->ussh_user_id)->first();
            $poss['orcl_name'] = $find_mem->mem_name;
            $poss['orcl_phone'] = $find_mem->mem_phone;
            $ord_res = self::addSignOrder($user_info, $poss);
            if ($ord_res['code'] != 200) {
                return $ord_res;
            }

            // 新增领取记录
            $add_clisigood_log['csgl_shop_id'] = $user_info->adm_shop_id;
            $add_clisigood_log['csgl_mem_id'] = $user_info->ussh_user_id;
            $add_clisigood_log['csgl_ord_id'] = $ord_res['data']['ord_id'];
            $add_clisigood_log['csgl_sigo_id'] = $request['sigo_id'];
            $add_clisigood_log['csgl_create_id'] = 0;
            $add_clisigood_log['csgl_create_time'] = date('Y-m-d H:i:s');
            $add_log_res = DB::table('clisigood_log')->insertGetId($add_clisigood_log);
            if ($add_log_res) {
                return ['code'=>200, 'msg'=>'领取成功', 'data'=>''];
            } else {
                return ['code'=>500, 'msg'=>'领取失败', 'data'=>''];
            }
        }
    }

    /**
     * 领取签到礼品订单,会员等级获取礼品使用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-22
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     */
    public static function addSignOrder($user_info, $request,$payment_way = 10)
    {
        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->ussh_user_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $ord_unique_string)
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>ErrorInc::DATA_EXIST, 'msg'=>'当前订单已提交，请勿重复操作！', 'data'=>''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $request['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : '';
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1;//买家类型：1门店零售2企业客户
        $data['ord_source'] = 2;//下单来源：1 pc  2 车主小程序  3 技师
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $payment_way; //结算方式1现金、2支付宝、3微信、4银行卡、5会员卡 10签到 11会员等级礼品
        $data['ord_wor_state'] = 7;
        $data['ord_add_type'] = 2;
        $data['ord_state'] = 2;
        $data['ord_pay_state'] = 1;

        $data['ord_settlement_time'] = date('Y-m-d H:i:s');
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $ord_id = NewOrderService::newOrder($data);


        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_id', $request['weus_id'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        $request['orcl_carowner_name'] = $request['orcl_name'];
        $request['orcl_carowner_phone'] = $request['orcl_phone'];
        // 选择的客户id，对应的订单数量增加
        if ($user_info->ussh_user_id) {
            // 零售，会员表
            $client_res = DB::table('member')
                ->where('mem_id', $user_info->ussh_user_id)
                ->increment('mem_order_all');
            $mem_data = DB::table('member')
                ->where('mem_id', $user_info->ussh_user_id)
                ->select('mem_id', 'mem_name', 'mem_phone')
                ->first();
            if ($mem_data) {
                $request['orcl_name'] = $mem_data->mem_name;
                $request['orcl_phone'] = $mem_data->mem_phone;
            }
            $weus_id = $find_weixin_data->weus_id;
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => $user_info->ussh_user_id, //选择客户id
            'orcl_name' => $request['orcl_name'] ? $request['orcl_name'] : '散户',
            'orcl_phone' => $request['orcl_phone'] ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => $request['orcl_carowner_name'] ? $request['orcl_carowner_name'] : '散户',
            'orcl_carowner_phone' => $request['orcl_carowner_phone'] ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类2其他车系
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $goods_data = $request['goods_data'];
        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0;
        $orgo_data['orgo_wago_id'] = 0;
        $orgo_data['orgo_goo_id'] = $goods_data['sigo_goo_id'];
        
        $orgo_data['orgo_goo_inventory'] = 1;
        $orgo_data['orgo_state'] = 1;
        if ($goods_data['sigo_goo_type'] == 2) {//商品
            $find_goods = DB::table('goods')
                ->where('goo_id', $goods_data['sigo_goo_id'])
                ->first();
            $orgo_data['orgo_goo_type'] = 1;
            $orgo_data['orgo_goo_name'] = $find_goods->goo_name;
            $orgo_data['orgo_goo_goods_encode'] = $find_goods->goo_goods_encode;
            $orgo_data['orgo_goo_unit'] = $find_goods->goo_unit;
            $orgo_data['orgo_goo_unta_id'] = $find_goods->goo_unta_id;
            $orgo_data['orgo_goo_quantity'] = 1;
            $orgo_data['orgo_goo_price'] = $find_goods->goo_price;
            $orgo_data['orgo_goo_amount'] = $find_goods->goo_price;
            $orgo_data['orgo_can_assign_quantity'] = 1;
            $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
            $ord_edit_data['ord_service_type'] = 3;//只有商品
        }
        if ($goods_data['sigo_goo_type'] == 1) {//服务
            $find_goods = DB::table('service_project')
                ->where('sepr_id', $goods_data['sigo_goo_id'])
                ->first();
            $orgo_data['orgo_goo_type'] = 2;
            $orgo_data['orgo_goo_name'] = $find_goods->sepr_name;
            $orgo_data['orgo_goo_unit'] = '次';
            $orgo_data['orgo_goo_quantity'] = 1;
            $orgo_data['orgo_goo_price'] = $find_goods->sepr_order_money;
            $orgo_data['orgo_goo_amount'] = $find_goods->sepr_order_money;
            $orgo_data['orgo_can_assign_quantity'] = 1;
            $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
            if ($find_goods->sepr_work_type == 1) {
                $ord_edit_data['ord_service_type'] = 1;
                $ord_edit_data['ord_add_work_state'] = 1;
            } else {
                $ord_edit_data['ord_service_type'] = 2;
            }
        }
        if ($goods_data['sigo_goo_type'] == 3) {//会员卡
            $find_goods = DB::table('vip_card')
                ->where('vica_id', $goods_data['sigo_goo_id'])
                ->first();
            $orgo_data['orgo_goo_type'] = 4;
            $orgo_data['orgo_goo_name'] = $find_goods->vica_name;
            $orgo_data['orgo_goo_unit'] = '张';
            $orgo_data['orgo_goo_quantity'] = 1;
            $orgo_data['orgo_goo_price'] = $find_goods->vica_price;
            $orgo_data['orgo_goo_amount'] = $find_goods->vica_price;
            $orgo_data['orgo_can_assign_quantity'] = 1;
            $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
            $ord_edit_data['ord_service_type'] = 4;//订单类型：1服务单 2洗车单3商品单4会员卡5充值6提现
            $ord_edit_data['ord_wor_state'] = 20;

            $data_vip['myvi_create_adm_id'] = 0;
            $data_vip['myvi_shop_id'] = $user_info->adm_shop_id;
            $data_vip['myvi_adm_id'] = $user_info->ussh_user_id; //选择客户id
            $data_vip['myvi_surplus_times'] = $find_goods->vica_num; //剩余次数
            $data_vip['myvi_all_times'] = $find_goods->vica_num; //总次数
            $data_vip['myvi_long_term'] = $find_goods->vica_long_term; //是否长期1是2否
            $data_vip['myvi_carnum'] = !empty($request['myvi_carnum']) ? $request['myvi_carnum']:''; //绑定车_vip牌
            $data_vip['myvi_sepr_id'] = $find_goods->vica_sepr_id; //服务项目id
            $data_vip['myvi_sepr_name'] = $find_goods->vica_sepr_name; //服务项目名称
            $data_vip['myvi_name'] = $find_goods->vica_name; //会员卡名称
            $data_vip['myvi_explain'] = $find_goods->vica_instructions; //会员卡使用说明
            $data_vip['myvi_vica_id'] = $goods_data['sigo_goo_id']; //会员卡id
            $data_vip['myvi_create_time'] = date('Y-m-d H:i:s');
            $data_vip['myvi_num'] = 'HYK'.time().rand(10000,99999);
            if ($find_goods->vica_long_term == 2) {//是否长期1是2否
                $data_vip['myvi_effective_date'] = $find_goods->vica_effective_date; //有效天数
                $data_vip['myvi_end_time'] = date('Y-m-d', strtotime(date('Y-m-d').'23:59:59') + ($find_goods->vica_effective_date)*60*60*24).' 23:59:59';
            } else {
                $data_vip['myvi_end_time'] = date('Y-m-d', time() + 99999*60*60*24);
            }
            $myvi_id = DB::table('myvip')->insertGetId($data_vip);
            $find_detail = DB::table('vip_card_detail')
                ->where('vicad_vcid', $find_goods->vica_id)
                ->get()->toArray();
            foreach ($find_detail as $key => $value) {
                $add_detail['myvid_mvid'] = $myvi_id;
                $add_detail['myvid_surplus_times'] = $value->vicad_num;
                $add_detail['myvid_all_times'] = $value->vicad_num;
                $add_detail['myvid_data_id'] = $value->vicad_data_id;
                $add_detail['myvid_data_name'] = $value->vicad_data_name;
                $add_detail['myvid_type'] = $value->vicad_type;
                $add_detail['myvid_goo_price'] = $value->vicad_goo_price;
                $add_detail_res = DB::table('myvip_detail')->insert($add_detail);
                if (!$add_detail_res) {
                    return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
                }
            }
        }
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_order_price'] = $orgo_data['orgo_goo_price'];
        $ord_edit_data['ord_zero_price'] = $orgo_data['orgo_goo_price'];
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res =NewOrderService::editOrder($ord_id,$ord_edit_data);
        if ($ord_id && $orcl_id && $ord_edit_res) {
            $return_data['ord_id'] = $ord_id;
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    /**
     * 签到状态
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-22
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function todaySign($user_info, $request) {
        if (empty($user_info)) {
            $data['state'] = 0;
            return ['code'=>200, 'msg'=>'success', 'data'=>$data['state']];
        }
        $point_config = DB::table('point_config')
            ->where('poco_shop_id', $user_info->adm_shop_id)
            ->first();
        $sign_config = DB::table('sign_config')
            ->where('sico_shop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($point_config)) {
            $data['state'] = 0;
        } else {
            if ($point_config->poco_point_switch == 1 && $sign_config->sico_state == 1) {
                $today = DB::table('sign_history')
                    ->where('sih_shop_id', $user_info->adm_shop_id)
                    ->where('sih_creact_id', $user_info->ussh_user_id)
                    ->where('sih_day', date('Y-m-d'))
                    ->first();
                if ($today) {
                    $data['state'] = 1;
                } else {
                    $data['state'] = 2;
                }
            } else {
                $data['state'] = 0;
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取主页操作按钮
     * @retrun  /multitype:array
     * @author dou 2024/3/29 17:40
     * |---------------------------------------------------------------------------------
    */
    public static function getActionList ( $user_info , $request ){
        //获取积分数据
        $point_config = DB::table('point_config')
            ->where('poco_shop_id', $user_info->adm_shop_id)
            ->first();
        $shop_shve_id = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->value('shop_shve_id');//获取门店版本
        $mainMenuInfo = [];
        $mainMenuInfo[] = ["id"=>2,"name"=>"会员卡","icon"=>"mine_menu_icon_02.png"];
        $mainMenuInfo[] = ["id"=>3,"name"=>"售后服务","icon"=>"mine_menu_icon_03.png"];
        $mainMenuInfo[] = ["id"=>4,"name"=>"爱车管理","icon"=>"mine_menu_icon_04.png"];
        if($shop_shve_id > 1) {
            $mainMenuInfo[] = ["id" => 5, "name" => "我的余额", "icon" => "mine_menu_icon_05.png"];
        }
        $mainMenuInfo[] = ["id"=>6,"name"=>"我的设置","icon"=>"mine_menu_icon_06.png"];
        $pointShow = 1;
        if (!empty($point_config) && $point_config->poco_point_switch == 1) {
            $pointShow = 2;
            $mainMenuInfo[] = ["id"=>7,"name"=>"填写邀请人","icon"=>"mine_menu_icon_07.png"];
            $mainMenuInfo[] = ["id"=>8,"name"=>"我的邀请","icon"=>"mine_menu_icon_08.png"];
        }
        $data['mainMenuInfo'] = $mainMenuInfo;
        $data['pointShow'] = $pointShow;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }
    /*
     * @name 列表页
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/10/17 16:43
     *
    */
    public static function shopList($user_info, $request){
        $shop_data = DB::table('shop as s')
            ->leftJoin('user_shop as u','u.ussh_shop_id' ,'=', 's.shop_id')
            //->where('ussh_phone', $request['weus_phone'])
            ->where('ussh_weus_id', $request['weus_id'])
            ->select('shop_id','shop_store_name','shop_province','shop_city','shop_county','shop_address','shop_opening_time','shop_phone','shop_service_scope','shop_longitude','shop_latitude')
            ->groupBy('ussh_shop_id')
            ->orderBy('ussh_create_time','desc')
            ->get()->toArray();
        if($shop_data){
            foreach ($shop_data as $key => $value){
                $shop_data[$key]->address = $value->shop_province.$value->shop_city.$value->shop_county.$value->shop_address;
                //计算记录
                if($value->shop_longitude == '0.0000000' || $value->shop_latitude == '0.0000000'){
                    $new_distance = '获取失败';
                }else{
                    if (!empty($request['longitude']) && !empty($request['latitude'])) {
                        // 计算两个地址之间的距离（千米）
                        $distance = getDistance($request['latitude'], $request['longitude'], $value->shop_latitude, $value->shop_longitude);
                    } else {
                        $distance = 0;
                    }
                    if ($distance < 1) {
                        $new_distance = $distance*1000;
                        $new_distance = $new_distance.'米';
                    } else {
                        $new_distance = $distance.'公里';
                    }
                }
                $shop_data[$key]->new_distance = $new_distance;//两点之间的距离（千米）
                unset($shop_data[$key]->shop_province);
                unset($shop_data[$key]->shop_city);
                unset($shop_data[$key]->shop_county);
                unset($shop_data[$key]->shop_address);
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$shop_data];
    }

    /**
     * 分享绑定
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-27
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function shareBind($user_info, $request) {
        $find_ussh = DB::table('user_shop')
            ->leftJoin('member', 'mem_id', '=', 'ussh_user_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($find_ussh)) {
            return ['code'=>500, 'msg'=>'未查询到此用户', 'data'=>''];
        }
        if (!empty($find_ussh->mem_fid)) {
            return ['code'=>500, 'msg'=>'您已绑定，无需再次绑定', 'data'=>''];
        }
        $time = time()-strtotime($find_ussh->ussh_register_time);
        $find_log = DB::table('bind_log')
            ->where('bilo_shop_id', $user_info->adm_shop_id)
            ->where('bilo_Inviter_id', $request['mem_fid'])
            ->where('bilo_Invitee_id', $user_info->ussh_user_id)
            ->first();
        if ($time > 10*3600*24) {
            if (empty($find_log)) {
                $add_data['bilo_shop_id'] = $user_info->adm_shop_id;
                $add_data['bilo_Inviter_id'] = $request['mem_fid'];
                $add_data['bilo_Invitee_id'] = $user_info->ussh_user_id;
                $add_data['bilo_state'] = 2;
                $add_data['bilo_create_time'] = date('Y-m-d H:i:s');
                $add_data['bilo_update_time'] = date('Y-m-d H:i:s');
                $add_res = DB::table('bind_log')->insertGetId($add_data);
                return ['code'=>200, 'msg'=>'绑定失败', 'data'=>''];
            } else {
                return ['code'=>200, 'msg'=>'绑定失败', 'data'=>''];
            }
        }
        
        $find_fid = DB::table('user_shop')
            ->where('ussh_shop_id', $user_info->adm_shop_id)
            ->where('ussh_user_id', $request['mem_fid'])
            ->first();
        if (empty($find_fid)) {
            return ['code'=>500, 'msg'=>'未查询到此分享人信息', 'data'=>$data];
        }
        $update_data['mem_fid'] = $request['mem_fid'];
        $update_data['mem_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->update($update_data);

        $add_data['bilo_shop_id'] = $user_info->adm_shop_id;
        $add_data['bilo_Inviter_id'] = $request['mem_fid'];
        $add_data['bilo_Invitee_id'] = $user_info->ussh_user_id;
        $add_data['bilo_state'] = 1;
        $add_data['bilo_create_time'] = date('Y-m-d H:i:s');
        $add_data['bilo_update_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('bind_log')->insertGetId($add_data);
        return ['code'=>200, 'msg'=>'绑定成功', 'data'=>''];
    }

    /**
     * 分享绑定=通过手机号
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-27
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function phoneBind($user_info, $request) {
        $find_user = DB::table('user_shop')
            ->leftJoin('member', 'mem_id', '=', 'ussh_user_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_user_type', 1)
            ->where('ussh_now_login', 1)
            ->select('ussh_register_time', 'mem_fid')
            ->first();
        if ($request['type'] == 1) {
            if ($find_user->mem_fid) {
                $fmem_phone = DB::table('member')
                    ->where('mem_id', $find_user->mem_fid)
                    ->value('mem_phone');
                $data['phone'] = $fmem_phone;
                $data['state'] = 1;
                return ['code'=>200, 'msg'=>'已绑定', 'data'=>$data];
            }
            if ($find_user->ussh_register_time) {
                $time = time()-strtotime($find_user->ussh_register_time);
                if ($time > 10*3600*24) {
                    $data['state'] = 3;
                    return ['code'=>200, 'msg'=>'已过期', 'data'=>$data];
                } else {
                    $data['state'] = 2;
                    return ['code'=>200, 'msg'=>'正常', 'data'=>$data];
                }
            } else {
                $data['state'] = 3;
                return ['code'=>200, 'msg'=>'已过期', 'data'=>$data];
            }
        }
        $find_ussh = DB::table('user_shop')
            ->where('ussh_phone', $request['phone'])
            ->where('ussh_shop_id', $user_info->adm_shop_id)
            ->first();
        if (empty($find_ussh)) {
            return ['code'=>500, 'msg'=>'未查询到此用户', 'data'=>''];
        }
        if ($find_user->ussh_register_time) {
            $time = time()-strtotime($find_user->ussh_register_time);
            if ($time > 10*3600*24) {
                $data['state'] = 3;
                return ['code'=>200, 'msg'=>'已过期', 'data'=>$data];
            }
        } else {
            $data['state'] = 3;
            return ['code'=>200, 'msg'=>'已过期', 'data'=>$data];
        }
        $find_mem = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->first();
        if ($find_ussh->ussh_user_id == $user_info->ussh_user_id) {
            return ['code'=>500, 'msg'=>'不能绑定自己', 'data'=>''];
        }
        if ($find_mem->mem_fid) {
            return ['code'=>500, 'msg'=>'您已绑定，无需再次绑定', 'data'=>''];
        }
        $update_data['mem_fid'] = $find_ussh->ussh_user_id;
        $update_data['mem_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->update($update_data);

        $add_data['bilo_shop_id'] = $user_info->adm_shop_id;
        $add_data['bilo_Inviter_id'] = $find_ussh->ussh_user_id;
        $add_data['bilo_Invitee_id'] = $user_info->ussh_user_id;
        $add_data['bilo_state'] = 1;
        $add_data['bilo_create_time'] = date('Y-m-d H:i:s');
        $add_data['bilo_update_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('bind_log')->insertGetId($add_data);
        return ['code'=>200, 'msg'=>'绑定成功', 'data'=>''];
    }

    /**
     * 我的邀请记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-30
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function invitation($user_info, $request) {
        $list_data = DB::table('bind_log')
            ->where('bilo_shop_id', $user_info->adm_shop_id)
            ->where('bilo_Inviter_id', $user_info->ussh_user_id)
            ->get()->toArray();
        $count = 0;
        $success_num = 0;
        $fail_num = 0;
        foreach ($list_data as $key => $value) {
            $count++;
            if ($value->bilo_state == 1) {//成功
                $success_num++;
            }
            if ($value->bilo_state == 2) {//失败
                $fail_num++;
            }
            $phone = DB::table('member')
                ->where('mem_id', $value->bilo_Invitee_id)
                ->value('mem_phone');
            $list_data[$key]->phone = substr($phone,0,3).'****'.substr($phone,-4);
            $ussh_register_time = DB::table('user_shop')
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->where('ussh_user_id', $value->bilo_Invitee_id)
                ->value('ussh_register_time');
            $list_data[$key]->weus_headimgurl = DB::table('user_shop')
                ->leftJoin('weixin_user', 'weus_id', '=', 'ussh_weus_id')
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->where('ussh_user_id', $value->bilo_Invitee_id)
                ->value('weus_headimgurl');
            $list_data[$key]->ussh_register_time = $ussh_register_time;
            $time = (strtotime($value->bilo_create_time) - strtotime($ussh_register_time));
            if ($time > 10*3600*24) {
                $list_data[$key]->user_state = 2;
            } else {
                $list_data[$key]->user_state = 1;
            }
        }
        $data['count'] = $count;
        $data['success_num'] = $success_num;
        $data['fail_num'] = $fail_num;
        $data['reward_num'] = DB::table('point_detail')
            ->where('pode_mem_id', $user_info->ussh_user_id)
            ->whereIn('pode_add_type', [1,2,3])
            ->count();

        $data['data'] = $list_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 生成二维码
    public static function shareQrCode($user_info, $request)
    {
        $find_data = DB::table('user_invite_code')
            ->where('usic_shop_id', $user_info->adm_shop_id)
            ->where('usic_ussh_user_id', $user_info->ussh_user_id)
            ->first();
        if (empty($find_data)) {
            $QrCodeService = new QrCodeService();
            // $type = 1;//类型：1创建二维码不保存图片2创建二维码并保存图片

            $text = config('apisystem.server_name_https'). '/shareShop?shop_id='.$user_info->adm_shop_id.'&ussh_user_id='.$user_info->ussh_user_id;//内容数据
            $res = $QrCodeService->qrCode(2, $text);

            $add_data['usic_shop_id'] = $user_info->adm_shop_id;
            $add_data['usic_ussh_user_id'] = $user_info->ussh_user_id;
            $add_data['usic_code'] = config('apisystem.server_name_https').'/'.$res;
            $add_data['usic_create_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('user_invite_code')->insert($add_data);
            $return_data = config('apisystem.server_name_https').'/'.$res;
        } else {
            $return_data = $find_data->usic_code;
        }
        return $return_data;
    }

    /**
     * 发送验证码
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getCode($user_info, $request)
    {
        if (empty($user_info)) {
            $user_info = DB::table('shop')
                ->where('shop_id', $request['shop_id'])
                ->select('shop_id as adm_shop_id', 'shop_cid as adm_cid')
                ->first();
        }
        $send = isSend($user_info,5);
        $find_shop_data = DB::table('shop')
            ->where('shop_id', $request['shop_id'])
            ->first();
        if ($send) {
            // 2.给相应的客户发送短信
            $code = mt_rand(100000, 999999); //生成六位验证码
            $message = '【半径服务】尊敬的客户您好，账号的验证码为'.$code.'，十分钟内有效。';
            $now_time = date('Y-m-d H:i:s');
            $phone = $request['weus_phone'];
            if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                if ($find_shop_data->shop_message_num <= 0) {
                    $send_state = 2;
                    $send_res = 0;
                    return ['code'=>500, 'msg'=>'发送失败', 'data'=>''];
                } else {
                    $msg_remind_log = DB::table('msg_remind_log')
                        ->where('mrlo_shop_id', $user_info->adm_shop_id)
                        ->where('mrlo_state', 2)
                        ->first();
                    if ($msg_remind_log) {//已提醒过
                        if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                            $update_remind['mrlo_state'] = 1;
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->update($update_remind);
                        }
                    }
                    
                    $msg_remind_log = DB::table('msg_remind_log')
                        ->where('mrlo_shop_id', $user_info->adm_shop_id)
                        ->where('mrlo_state', 2)
                        ->first();
                    // 短信不足提醒
                    if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                        $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                        // $wechat_msg['pushtype'] = 5; //短信预警
                        // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                        // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                        // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                        // $wechat_msg['remark'] = '短信不足预警';
                        // $CashierDesk = new CashierDesk;
                        // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                        $remind_phone = $adm_data->adm_phone;
                        $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                        $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                        if ($remind_send_res > 0) {
                            $send_state = 1;
                            $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                            $add_remind['mrlo_state'] = 2;//未充值，
                            $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                            $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                            $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                            $add_remind['mrlo_create_id'] = 0;
                            $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                        } else {
                            $send_state = 2;
                        }
                        // 短信模块日志
                        $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                        $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                        $seme_data['seme_wor_id'] = 0; //订单id
                        $seme_data['seme_name'] = '短信不足预警'; //模板名称
                        $seme_data['seme_phone'] = $remind_phone; //手机号
                        $seme_data['seme_content'] = $remind_content; //内容
                        $seme_data['seme_row'] = 1; //条数
                        $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                        $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                        $seme_data['seme_ip'] = $request['ip']; //ip地址
                        $seme_data['seme_adm_id'] = isset($user_info->adm_id) ? $user_info->adm_id : 0; //创建人id
                        $seme_id = DB::table('send_message')->insert($seme_data);
                    }
                    // 查看是否发送验证码
                    $find_phone_code = DB::table('phone_code')
                        ->where('phc_type', 1)
                        ->where('phc_phone', $request['weus_phone'])
                        ->first(['phc_id', 'phc_code', 'phc_type', 'phc_expirationtime']);
                    if ($find_phone_code) {
                        if ($find_phone_code->phc_type == 1 && $find_phone_code->phc_expirationtime > date('Y-m-d H:i:s')) {
                            return ['code'=>200, 'msg'=>'短信验证码已发送过，十分钟内到期。', 'data'=>$find_phone_code->phc_code];
                        }
                        $find_phone_code = DB::table('phone_code')
                            ->where('phc_id', $find_phone_code->phc_id)
                            ->update(['phc_type'=>2]);
                        $send_res = sendSmsCode($phone, $message);
                        $phc_data['phc_send_code'] = $send_res; //短信发送返回值
                    } else {
                        $send_res = sendSmsCode($phone, $message);
                        $phc_data['phc_send_code'] = $send_res; //短信发送返回值
                    }
                    if ($send_res > 0) {
                        $phc_data['phc_phone'] = $request['weus_phone'];
                        $phc_data['phc_code'] = $code;
                        $phc_data['phc_type'] = 1;
                        $phc_data['phc_creacttime'] = $now_time;
                        $phc_data['phc_expirationtime'] = date('Y-m-d H:i:s', strtotime($now_time) + 600); //过期时间
                        $phc_res = DB::table('phone_code')->insert($phc_data);
                        $send_state = 1;
                        $update_shop = DB::table('shop')
                            ->where('shop_id', $user_info->adm_shop_id)
                            ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                    } else {
                        $send_state = 2;
                    }
                }
                // 短信模块日志
                $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                $seme_data['seme_wor_id'] = 0; //订单id
                $seme_data['seme_name'] = '会员登录手机号验证码'; //模板名称
                $seme_data['seme_phone'] = $phone; //手机号
                $seme_data['seme_content'] = $message; //内容
                $seme_data['seme_row'] = 1; //条数
                $seme_data['seme_status_code'] = $send_res; //短信状态码
                $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                $seme_data['seme_ip'] = $request['ip']; //ip地址
                $seme_data['seme_adm_id'] = 0; //创建人id
                $seme_id = DB::table('send_message')->insert($seme_data);

                $find_member = DB::table('member')
                    ->where('mem_shop_id', $user_info->adm_shop_id)
                    ->where('mem_phone', $phone)
                    ->first();
                $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                if (empty($find_member)) {
                    $add_log['smlo_mem_id'] = 0;
                    $add_log['smlo_mem_name'] = '';
                } else {
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                }
                $add_log['smlo_mem_phone'] = $phone;
                $add_log['smlo_type'] = 2;
                $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                $add_log['smlo_state'] = $send_state;
                $add_log['smlo_msg_type'] = 4;
                $add_log['smlo_num'] = 1;
                $add_log['smlo_content'] = $message; //内容
                $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                return ['code'=>200, 'msg'=>'短信验证码已发送，十分钟内到期。', 'data'=>$code];
            }
        } else {
            return ['code'=>500, 'msg'=>'发送失败', 'data'=>''];
        }
    }

    /**
     * 获取账号
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getList($user_info, $request) {
        $weus_id = DB::table('weixin_user')
            ->where('weus_openid', $request['weus_openid'])
            ->value('weus_id');
        $list_data = DB::table('user_shop')
            ->leftJoin('member', 'mem_id', '=', 'ussh_user_id')
            ->where('ussh_weus_id', $weus_id)
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_phone', '!=', '')
            ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone', 'mem_image')
            ->orderBy('ussh_now_login', 'asc')
            ->get()->toArray();
        foreach ($list_data as $key => $value) {
            if (!empty($value->ussh_phone)) {
                $list_data[$key]->phone = substr($value->ussh_phone,0,3).'****'.substr($value->ussh_phone,-4);
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * 删除账号
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function delPhone($user_info, $request) {
        $weus_id = DB::table('weixin_user')
            ->where('weus_openid', $request['weus_openid'])
            ->value('weus_id');
        $list_data = DB::table('user_shop')
            ->where('ussh_weus_id', $weus_id)
            ->where('ussh_phone', $request['weus_phone'])
            ->delete();
        return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
    }

    /**
     * 切换门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-24
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function changeShop($user_info, $request) {
        if (empty($request['weus_id']) || empty($request['change_shop_id'])) {
            return ['code'=>500, 'msg'=>'请选择门店', 'data'=>''];
        }
        $new_update_user_shop = DB::table('user_shop')
            ->where('ussh_weus_id', $request['weus_id'])
            ->update(['ussh_now_login'=>2]);
        // 查询此账号是否注册
        $find_data = DB::table('user_shop')
            ->where('ussh_shop_id', $request['change_shop_id'])
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_phone', $request['ussh_phone'])
            ->first();
        if (empty($find_data)){
            if (!empty($request['ussh_phone'])) {
                $mem_id = DB::table('member')
                    ->where('mem_shop_id', $request['change_shop_id'])
                    ->where('mem_phone', $request['ussh_phone'])
                    ->value('mem_id');
                if (!$mem_id) {
                    // 新增门店会员
                    $add_mem_data['mem_superior_shop_id'] = $request['change_shop_id'];
                    $add_mem_data['mem_cid'] = 1;
                    $add_mem_data['mem_shop_id'] = $request['change_shop_id'];
                    $add_mem_data['mem_name'] = $request['ussh_phone'];
                    $add_mem_data['mem_phone'] = $request['ussh_phone'];
                    $add_mem_data['mem_sex'] = 3;
                    $mem_id = MemberService::addMember($add_mem_data);
                }
                $find_ussh = DB::table('user_shop')
                    ->where('ussh_shop_id', $request['change_shop_id'])
                    ->where('ussh_weus_id', $request['weus_id'])
                    ->where('ussh_phone', '')
                    ->select('ussh_phone', 'ussh_id')
                    ->first();
                $ussh_datas['ussh_weus_id'] = $request['weus_id'];
                $ussh_datas['ussh_shop_id'] = $request['change_shop_id'];
                $ussh_datas['ussh_user_type'] = 1;
                $ussh_datas['ussh_now_login'] = 1;
                $ussh_datas['ussh_user_id'] = $mem_id;
                $ussh_datas['ussh_phone'] = $request['ussh_phone'];
                $ussh_datas['ussh_create_time'] = date('Y-m-d H:i:s');
                if (empty($find_ussh)) {
                    $ussh_datas['ussh_register_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_datas);
                } else {
                    $ussh_res = DB::table('user_shop')->where('ussh_id', $find_ussh->ussh_id)->update($ussh_datas);
                    $ussh_id = $find_ussh->ussh_id;
                }
                $update_user_shop = DB::table('user_shop')
                    ->where('ussh_weus_id', $request['weus_id'])
                    ->where('ussh_shop_id', $request['change_shop_id'])
                    ->where('ussh_phone', $request['ussh_phone'])
                    ->update(['ussh_now_login'=>1, 'ussh_create_time'=>date('Y-m-d H:i:s')]);
            } else {
                $find_data = DB::table('user_shop')
                    ->where('ussh_shop_id', $request['change_shop_id'])
                    ->where('ussh_weus_id', $request['weus_id'])
                    ->orderBy('ussh_create_time', 'desc')
                    ->first();
                if ($find_data->ussh_phone) {
                    $update_user_shop = DB::table('user_shop')
                        ->where('ussh_id', $find_data->ussh_id)
                        ->update(['ussh_now_login'=>1, 'ussh_create_time'=>date('Y-m-d H:i:s')]);
                } else {
                    $update_user_shop = DB::table('user_shop')
                        ->where('ussh_id', $find_data->ussh_id)
                        ->update(['ussh_create_time'=>date('Y-m-d H:i:s')]);
                }
            }
        } else {
            $find_data = DB::table('user_shop')
                ->where('ussh_shop_id', $request['change_shop_id'])
                ->where('ussh_weus_id', $request['weus_id'])
                ->where('ussh_phone', $request['ussh_phone'])
                ->update(['ussh_now_login'=>1, 'ussh_create_time'=>date('Y-m-d H:i:s')]);
        }
        $weus_res = DB::table('weixin_user')
            ->where('weus_id', $request['weus_id'])
            ->update(['weus_shop_id'=>$request['change_shop_id']]);
        return ['code'=>200, 'msg'=>'切换成功', 'data'=>''];
    }
}
