<?php

namespace App\Services\WeChatApplet\User;

use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\User\UserSearch;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\User\UserSearchValidator;
use BlueCity\Core\Inc\ErrorInc;

class UserSearchService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new UserSearch();
        $this->mainValidator = new UserSearchValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($search_data, $show_count = 10)
    {
        $list_data = DB::table('user_search_history')
            ->where('ussh_weus_id', $search_data['weus_id'])
            ->where('ussh_state', 1)
            ->select('ussh_search_content')
            ->orderBy('ussh_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 根据条件搜索服务项目数据
     *微信用户小程序搜素
     * @param array $search_data 条件
     * @param int $show_count 页容量
     * @param array $fields 查询字段
     * @param string $field_sort 排序方式
     * @return mixed
     */
    public function searchService($search_data, $show_count = 10, $fields = [], $field_sort = 'desc')
    {
        if (empty($fields)) {
            $fields = ['sepr_id', 'sepr_name', 'sepr_img'];//默认查询字段
        }
        $list_data = DB::table('service_project as a')
            ->leftJoin('shop as b', 'b.shop_id', '=', 'a.sepr_shop_id')
            ->where('sepr_shop_id', $search_data['shop_id'])
            ->where('sepr_delete', 1)
            ->where('sepr_state', 1)
            ->where('sepr_work_type', 1)//1生成工单2不生成工单 洗车
            ->where(function ($query) use ($search_data) { //服务项目名称
                if (!empty($search_data['keywords'])) {
                    $query->where('sepr_name', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //服务项目id
                if (!empty($search_data['sepr_id'])) {
                    $query->where('sepr_id', $search_data['sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //状态1启用2停用
                if (!empty($search_data['sepr_state'])) {
                    $query->where('sepr_state', $search_data['sepr_state']);
                }
            })
            ->select($fields)
            ->orderBy('sepr_id', $field_sort)
            ->paginate($show_count);
        $list_items = $list_data->items();
        if (!empty($search_data['keywords'])) {
            // 记录搜索内容
            $this->searchRecord($search_data);
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 根据条件搜索商品数据
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchGooods($search_data, $show_count = 10)
    {
        $list_data = DB::table('goods')
            ->where('goo_shop_id', $search_data['shop_id'])
            ->where('goo_type', 5)
            ->where('goo_delete', 1)
            ->where('goo_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['keywords'])) {
                    $query->where('goo_name', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('goo_goods_encode', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //商品id
                if (!empty($search_data['goo_id'])) {
                    $query->where('goo_id', $search_data['goo_id']);
                }
            })
            ->select('goo_id', 'goo_name', 'goo_goods_encode')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 记录搜索内容
    public function searchRecord($request)
    {
        // 查询搜索内容是否已添加历史记录
        $find_data = DB::table('user_search_history')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_state', 1)
            ->where('ussh_search_content', $request['keywords'])
            ->exists();
        if ($find_data) {
            // 已添加记录不做调整
            return $find_data;
        } else {
            // 没有添加记录，把搜索内容添加历史记录
            $data['ussh_search_content'] = $request['keywords'];
            $data['ussh_weus_id'] = $request['weus_id'];
            $data['ussh_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('user_search_history')->insert($data);
            return $res;
        }
    }

    // 清空历史搜索记录
    public function clearRecord($request)
    {
        $data['ussh_state'] = 2;
        $data['ussh_weus_id'] = $request['weus_id'];
        $data['ussh_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('user_search_history')
            ->where('ussh_weus_id', $request['weus_id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'历史记录清除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'历史记录清除失败', 'data'=>''];
        }
    }
}
