<?php

namespace App\Services\WeChatApplet\User;

use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\User\UserMessage;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\User\UserMessageValidator;
use BlueCity\Core\Inc\ErrorInc;

class UserMessageService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new UserMessage();
        $this->mainValidator = new UserMessageValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info,$search_data, $show_count = 10)
    {
        $list_data = DB::table('user_message as a')
            ->leftJoin('shop as b', 'b.shop_id', '=', 'a.shop_id')
            ->where('weus_id', $search_data['weus_id'])
            // ->where('read_state', 1)
            ->where('a.shop_id', $user_info->adm_shop_id)
            ->where('adm_type', 1)
            ->select('content', 'create_adm_name', 'create_time', 'primary_id', 'primary_type', 'shop_store_name', 'a.shop_id', 'id', 'read_state')
            ->orderBy('read_state', 'asc')
            ->orderBy('id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 已读消息接口
    public function read($search_data)
    {
        if ($search_data['id']) {
            $data['read_state'] = 2;
            $data['update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('user_message')
                ->where('id', $search_data['id'])
                ->update($data);
        } else {
            $find_data = DB::table('user_message')
                ->where('weus_id', $search_data['weus_id'])
                ->where('read_state', 1)
                ->where('adm_type', 1)
                ->value('id');
            if ($find_data) {
                $data['read_state'] = 2;
                $data['update_time'] = date('Y-m-d H:i:s');
                $res = DB::table('user_message')
                    ->where('weus_id', $search_data['weus_id'])
                    ->where('read_state', 1)
                    ->where('adm_type', 1)
                    ->update($data);
                }
        }
        if ($res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
        }
    }

    // 未读消息数量总计
    public function unreadTotal($search_data)
    {
        $list_data = DB::table('user_message')
            ->where('weus_id', $search_data['weus_id'])
            ->where('read_state', 1)
            ->where('adm_type', 1)
            ->select(DB::raw('count(*) as count'))
            ->first();
        return $list_data;
    }
}
