<?php

namespace App\Services\WeChatApplet\user;

use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\User\MemberCar;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\User\MemberCarValidator;
use BlueCity\Core\Inc\ErrorInc;

// 用户车辆管理
class MemberCarService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new MemberCar();
        $this->mainValidator = new MemberCarValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($search_data, $show_count = 10)
    {
        // 查询用户在门店的会员id
        $mem_id = DB::table('user_shop')
            ->where('ussh_weus_id', $search_data['weus_id'])
            ->where('ussh_shop_id', $search_data['shop_id'])
            ->where('ussh_user_type', 1)
            ->where('ussh_now_login', 1)
            ->value('ussh_user_id');
        // 查询会员车辆信息
        $list_data = DB::table('member_car as a')
            ->leftJoin('member as b', 'a.meca_mem_id','=','b.mem_id')
            ->where('meca_shop_id', $search_data['shop_id'])
            ->where('meca_mem_id', $mem_id)
            ->select('meca_id', 'meca_mem_id', 'meca_car_num', 'meca_car_series', 'meca_car_model', 'meca_car_frame', 'mem_name', 'mem_phone', 'meca_car_brand_series', 'meca_default')
            ->orderBy('meca_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 详情
    public static function info($request)
    {
        // 查询会员车辆信息
        $find_data = DB::table('member_car as a')
            ->leftJoin('member as b', 'a.meca_mem_id','=','b.mem_id')
            ->where('meca_shop_id', $request['shop_id'])
            ->where('meca_id', $request['meca_id'])
            ->select('meca_id', 'meca_mem_id', 'meca_car_num', 'meca_car_series', 'meca_car_model', 'meca_car_frame', 'mem_name', 'mem_phone', 'meca_car_brand_series')
            ->first();
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_data];
    }

    /**
     * 查询会员的车牌号是否存在
     * @param $car_num 待检测车牌号
     * @param $shop_id 门店id
     * @param $weus_id 微信用户id
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function nameExists($car_num, $shop_id, $weus_id, $id = 0) 
    {
        // 查询微信用户在当前门店的会员id
        $mem_id = DB::table('user_shop')
            ->where('ussh_weus_id', $weus_id)
            ->where('ussh_shop_id', $shop_id)
            ->where('ussh_user_type', 1)
            ->value('ussh_user_id');
        if ($id == 0) {
            return MemberCar::where('meca_car_num', $car_num)
                ->where('meca_shop_id', $shop_id)
                ->where('meca_mem_id', $mem_id)
                ->exists();
        } else {
            return MemberCar::where('meca_car_num', $car_num)
            ->where('meca_shop_id', $shop_id)
            ->where('meca_mem_id', $mem_id)
            ->where('meca_id', '<>', $id)
            ->exists();
        }
    }

    // 新增
    public static function add($request)
    {
        // 判断是否有微信用户、门店信息，没有用户、门店信息不新增数据
        if (empty($request['weus_id']) || empty($request['shop_id'])) {
            return ['code'=>200, 'msg'=>'201', 'data'=>''];
        }

        // 查询微信用户在当前门店的会员id
        $find_user_data = DB::table('user_shop as a')
            ->leftJoin('shop as b', 'a.ussh_shop_id', '=', 'b.shop_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_user_type', 1)
            ->where('ussh_now_login', 1)
            ->select('ussh_user_id', 'shop_cid', 'shop_superior_id')
            ->first();

        $data['meca_cid'] = $find_user_data->shop_cid;
        $data['meca_superior_shop_id'] = $find_user_data->shop_superior_id;
        $data['meca_mem_id'] = $find_user_data->ussh_user_id;
        $data['meca_shop_id'] = $request['shop_id'];
        // $data['meca_create_adm_id'] = $request['weus_phone'];
        $data['meca_car_num'] = $request['meca_car_num'];
        if (!empty($request['meca_car_brand_series'])) {//品牌车系
            $data['meca_car_brand_series'] = $request['meca_car_brand_series'];
        }
        // if (!empty($request['meca_car_series'])) {//车系
        //     $data['meca_car_series'] = $request['meca_car_series'];
        // }
        // if (!empty($request['meca_car_model'])) {//车型
        //     $data['meca_car_model'] = $request['meca_car_model'];
        // }
        if (!empty($request['meca_car_frame'])) {//车架号
            $data['meca_car_frame'] = $request['meca_car_frame'];
        } else {
            $data['meca_car_frame'] = '';
        }
        $data['meca_update_time'] = date('Y-m-d H:i:s');
        $add_res = DB::table('member_car')->insert($data);
        if ($add_res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    // 编辑
    public static function edit($request)
    {
        // 查询微信用户在当前门店的会员id
        $find_user_data = DB::table('user_shop as a')
            ->leftJoin('shop as b', 'a.ussh_shop_id', '=', 'b.shop_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_user_type', 1)
            ->select('ussh_user_id', 'shop_cid', 'shop_superior_id')
            ->first();

        $data['meca_cid'] = $find_user_data->shop_cid;
        $data['meca_superior_shop_id'] = $find_user_data->shop_superior_id;
        $data['meca_mem_id'] = $find_user_data->ussh_user_id;
        $data['meca_shop_id'] = $request['shop_id'];
        // $data['meca_create_adm_id'] = $request['weus_phone'];
        $data['meca_car_num'] = $request['meca_car_num'];
        if (!empty($request['meca_car_brand_series'])) {
            $data['meca_car_brand_series'] = $request['meca_car_brand_series'];
        } else {
            return ['code'=>500, 'msg'=>'请选择品牌车系', 'data'=>'请选择品牌车系'];
        }
        // if (!empty($request['meca_car_series'])) {
        //     $data['meca_car_series'] = $request['meca_car_series'];
        // }
        // if (!empty($request['meca_car_model'])) {
        //     $data['meca_car_model'] = $request['meca_car_model'];
        // }
        if (!empty($request['meca_car_frame'])) {
            $data['meca_car_frame'] = $request['meca_car_frame'];
        } else {
            $data['meca_car_frame'] = '';
        }
        $data['meca_update_time'] = date('Y-m-d H:i:s');
        
        $edit_res = DB::table('member_car')
            ->where('meca_id', $request['meca_id'])
            ->update($data);
        if ($edit_res) {
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'修改失败', 'data'=>''];
        }
    }

    // 设置默认
    public static function carDefault($request)
    {
        // 判断是否有微信用户、门店信息，没有用户、门店信息不新增数据
        if (empty($request['weus_id']) || empty($request['shop_id'])) {
            return ['code'=>200, 'msg'=>'201', 'data'=>''];
        }

        // 查询微信用户在当前门店的会员id
        $find_user_data = DB::table('user_shop as a')
            ->leftJoin('shop as b', 'a.ussh_shop_id', '=', 'b.shop_id')
            ->where('ussh_weus_id', $request['weus_id'])
            ->where('ussh_shop_id', $request['shop_id'])
            ->where('ussh_user_type', 1)
            ->select('ussh_user_id', 'shop_cid', 'shop_superior_id')
            ->first();
        $old_data['meca_default'] = 2;
        $edit_res = DB::table('member_car')
            // ->where('meca_shop_id', $find_user_data->shop_superior_id)
            ->where('meca_mem_id', $find_user_data->ussh_user_id)
            ->update($old_data);
        $data['meca_default'] = 1;
        $data['meca_update_time'] = date('Y-m-d H:i:s');
        
        $edit_res = DB::table('member_car')
            ->where('meca_id', $request['meca_id'])
            ->update($data);
        if ($edit_res) {
            return ['code'=>200, 'msg'=>'设置成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'设置失败', 'data'=>''];
        }
    }
}
