<?php

namespace App\Services\WeChatApplet\Technician;

use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\Technician\LoginTechnician;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
//use App\Http\Requests\Validators\WeChatApplet\Technician\LoginTechnicianValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Crypt;

class LoginTechnicianService extends Model
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new LoginTechnician();
        // $this->mainValidator = new LoginTechnicianValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    // 微信授权
    public function weixinthAuth($code2Session)
    {
        // 根据openid查询用户id
        $wete_id = DB::table('weixin_technician')
            ->where("wete_openid", $code2Session['openid'])
            ->value('wete_id');
        if ($wete_id) {
            $wete_data['wete_session_key'] = $code2Session['session_key'];
            $wete_data['wete_update_time'] = date('Y-m-d H:i:s');
            $wete_res = DB::table('weixin_Technician')
                ->where("wete_id", $wete_id)
                ->update($wete_data);
            $find_weixin_data = DB::table('weixin_technician')
                ->where('wete_id', $wete_id)
                ->select('wete_id', 'wete_phone', 'wete_nickmame', 'wete_headimgurl')
                ->first();
            $return_data = (array)$find_weixin_data;
        }

        // 查询登录表id
        $login_id = DB::table('login_wechat_applet')
            ->where("open_id", $code2Session['openid'])
            ->value('id');
        $unique_string = md5(uniqid(md5(microtime(true)) . rand(100000, 999999), true)); //生成唯一字符串
        $api_token = sha1($unique_string); //加密
        $crypt_api_token = Crypt::encrypt($api_token); //生成前台token
        if ($login_id) {
            // 更新登录信息
            $login_data['session_key'] = $code2Session['session_key'];
            $login_data['api_token'] = $api_token;
            $login_data['wete_id'] = $wete_id ? $wete_id : '';
            $login_data['last_login'] = time() + 24*60*60;//4个小时有效时间
            $login_res = DB::table('login_wechat_applet')
                ->where("id", $login_id)
                ->update($login_data);
        } else {
            // 插入登录信息
            $login_data['open_id'] = $code2Session['openid'];
            $login_data['wete_id'] = $wete_id ? $wete_id : '';
            $login_data['session_key'] = $code2Session['session_key'];
            $login_data['api_token'] = $api_token;
            $login_data['last_login'] = time() + 4*60*60;//4个小时有效时间
            $login_res = DB::table('login_wechat_applet')->insertGetId($login_data);
        }

        $return_data['api_token'] = $crypt_api_token;
        $return_data['openid'] = $code2Session['openid'];
        $return_data['session_key'] = $code2Session['session_key'];
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
    }
}
