<?php

namespace App\Services\WeChatApplet\Technician;

use Illuminate\Database\Eloquent\Model;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\Technician\ContactUsValidator;
use BlueCity\Core\Inc\ErrorInc;

class ContactUsService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->mainValidator = new ContactUsValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    public static function video($user_info, $request) {
        $list_data = DB::table('instructional_video')
            ->where('inv_type', $request['inv_type'])
            ->where('inv_state', 1)
            ->orderBy('inv_sort', 'desc')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * 立即试用
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function tryNow($user_info, $request) {
        $adm_shop_leave = DB::table('admin_shop_role')
            ->where('adm_id', $user_info->adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            ->value('adm_shop_leave');
        if ($adm_shop_leave == 1) {//店长
            $find_most = DB::table('moudle_statistics')
                ->where('most_shop_id', $user_info->adm_shop_id)
                ->where('most_adm_id', $user_info->adm_id)
                // ->where('most_moudle_id', $request['most_moudle_id'])
                ->first();
            if (empty($find_most)) {
                $add_most['most_shop_id'] = $user_info->adm_shop_id;
                $add_most['most_adm_id'] = $user_info->adm_id;
                $add_most['most_prompt_date'] = date('Y-m-d H:i:s', strtotime('+1 month'));
                $add_most['most_create_time'] = date('Y-m-d H:i:s');
                $add_most['most_moudle_id'] = $request['most_moudle_id'];
                $add_most['most_moudle'] = $request['most_moudle'];
                $add_res = DB::table('moudle_statistics')->insertGetId($add_most);
            } else {
                $update_data['most_prompt_nums'] = $find_most->most_prompt_nums + 1;
                if ($update_data['most_prompt_nums'] >= 3) {
                    $update_data['most_remind'] = 2;
                } else {
                    $update_data['most_prompt_date'] = date('Y-m-d H:i:s', strtotime('+1 month'));
                }
                $add_res = $find_most = DB::table('moudle_statistics')
                    ->where('most_shop_id', $user_info->adm_shop_id)
                    ->where('most_adm_id', $user_info->adm_id)
                    ->update($update_data);
            }
            return ['code'=>200, 'msg'=>'试用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'不是店长 请联系管理员', 'data'=>$list_data];
        }
    }
}
