<?php

namespace App\Services\WeChatApplet\Technician;

use Illuminate\Database\Eloquent\Model;
use App\Models\WeChatApplet\Technician\AdminMessage;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\WeChatApplet\Technician\AdminMessageValidator;
use BlueCity\Core\Inc\ErrorInc;

class AdminMessageService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new AdminMessage();
        $this->mainValidator = new AdminMessageValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        $list_data = DB::table('admin_message')
            ->leftJoin('work_order', 'primary_id', '=', 'wor_id')
            ->where('adm_id', $user_info->adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            // ->where('read_state', 1)
            ->where('primary_type', 2)
            ->select('content', 'create_adm_name', 'create_time', 'primary_id', 'primary_type', 'title', 'read_state', 'id', 'wor_state')
            ->orderBy('id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $wor_id = array_column($list_items, 'primary_id'); //工单id
            // 查询工单相关信息
            $work_data = DB::table('work_order as a')
                ->leftJoin('admin as c','a.wor_service_adm_id', '=', 'c.adm_id')
                ->where('wor_shop_id', $user_info->adm_shop_id)
                ->whereIn('wor_id', $wor_id)
                ->select('wor_id', 'wor_number', 'wor_state', 'wor_appoint_time', 'wor_service_adm_id', 'adm_name', 'wor_province', 'wor_city', 'wor_county', 'wor_address')
                ->orderBy('wor_id', 'desc')
                ->get()->toarray();
            // 查询工单返工相关信息
            $rwwork_data = DB::table('rework_message')
                ->where('shop_id', $user_info->adm_shop_id)
                ->where('adm_id', $user_info->adm_id)
                ->whereIn('wor_id', $wor_id)
                ->select('wor_id', 'content')
                ->orderBy('wor_id', 'desc')
                ->get()->toarray();
        } else {
            $work_data = [];
            $rwwork_data = [];
        }

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $work_data;                        //返回数据
        $data['rwwork_data'] = $rwwork_data;                        //返回数据
        $data['list_items'] = $list_items;                        //返回数据
        return $data;
    }

    // 合作商消息列表
    public function busmsgindex($user_info, $search_data, $show_count = 10)
    {
        $list_data = DB::table('user_message as a')
            ->leftJoin('shop as b', 'b.shop_id', '=', 'a.shop_id')
            ->where('weus_id', $search_data['buac_id'])
            ->where('adm_type', 2)
            ->select('content', 'create_adm_name', 'create_time', 'primary_id', 'primary_type', 'shop_store_name', 'adm_type')
            ->orderBy('id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 已读消息接口
    public function readbusmsg($user_info, $request)
    {
        $find_data = DB::table('user_message')
            ->where('weus_id', $request['buac_id'])
            ->where('shop_id', $user_info->adm_shop_id)
            ->where('read_state', 1)
            ->where('adm_type', 2)
            ->value('id');
        if ($find_data) {
            $data['read_state'] = 2;
            $data['update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('user_message')
                ->where('weus_id', $request['buac_id'])
                ->where('shop_id', $user_info->adm_shop_id)
                ->where('read_state', 1)
                ->where('adm_type', 2)
                ->update($data);
            if ($res) {
                return ['code'=>200, 'msg'=>'success', 'data'=>''];
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
            }
        } else {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }
    }

    // 已读消息接口
    public function read($user_info, $request)
    {
        if (!empty($request['id'])) {
            $data['read_state'] = 2;
            $data['update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('admin_message')
                ->where('id', $request['id'])
                ->update($data);
            if ($res) {
                return ['code'=>200, 'msg'=>'success', 'data'=>''];
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
            }
        } else {
            $find_data = DB::table('admin_message')
                ->where('adm_id', $user_info->adm_id)
                ->where('shop_id', $user_info->adm_shop_id)
                ->where('read_state', 1)
                ->where('primary_type', 2)
                ->value('id');
            if ($find_data) {
                $data['read_state'] = 2;
                $data['update_time'] = date('Y-m-d H:i:s');
                $res = DB::table('admin_message')
                    ->where('adm_id', $user_info->adm_id)
                    ->where('shop_id', $user_info->adm_shop_id)
                    ->where('read_state', 1)
                    ->where('primary_type', 2)
                    ->update($data);
                if ($res) {
                    return ['code'=>200, 'msg'=>'success', 'data'=>''];
                } else {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
                }
            } else {
                return ['code'=>200, 'msg'=>'success', 'data'=>''];
            }
        }
    }

    // 合作商未读消息数量总计
    public function busunreadTotal($search_data)
    {
        $list_data = DB::table('user_message')
            ->where('weus_id', $search_data->buac_id)
            ->where('read_state', 1)
            ->where('adm_type', 2)
            ->select(DB::raw('count(*) as count'))
            ->first();
        return $list_data;
    }

    // 未读消息数量总计
    public function unreadTotal($user_info)
    {
        $list_data = DB::table('admin_message')
            ->where('adm_id', $user_info->adm_id)
            ->where('shop_id', $user_info->adm_shop_id)
            ->where('read_state', 1)
            ->where('primary_type', 2)
            ->select(DB::raw('count(*) as count'))
            ->first();
        return $list_data;
    }
}
