<?php

/**
 * 用户汽车服务
 *
 * @author lixiaolin
 * @Date: 2021/8/31
 * @Time: 下午15:23
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Inc\CacheInc;
use App\Models\MemberVehicles;
use App\Models\MeritPayOptions;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use App\Models\MemberAccount;

class VehicleService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new MemberVehicles();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $shopID = LoginUserService::getUserShopID();
        $where = [];
        $where[] = ['meca_shop_id', '=', $shopID];

        if (!empty($param['car_num'])) {
            $where[] = ['meca_car_num', '=', $param['car_num']];
        }
        if (!empty($param['car_series'])) {
            $where[] = ['meca_car_series', '=', $param['car_series']];
        }
        if (!empty($param['year'])) {
            $where[] = ['meca_year', '=', $param['year']];
        }
        if (!empty($param['car_frame'])) {
            $where[] = ['meca_car_frame', '=', $param['car_frame']];
        }

        $count = $this->modelMain
            ->where($where)
            ->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('meca_id', 'ASC')
                ->offset($offset)
                ->limit($pageSize)
                ->get();
        } else {
            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('meca_id', 'ASC')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;

        return $result;
    }

    public function create(array $requestData)
    {
        $data['meca_cid']                = $requestData['adm_cid'];
        $data['meca_shop_id']            = $requestData['shop_id'];
        $data['meca_superior_shop_id']   = $requestData['superior_shop_id'];
        $data['meca_create_adm_id']      = $requestData['adm_id'];
        $data['meca_car_num']            = $requestData['mem_car_num'];
        $data['meca_car_series']         = $requestData['mem_car_series'] ? $requestData['mem_car_series'] : '';
        $data['meca_car_model']          = $requestData['mem_car_model'] ? $requestData['mem_car_model'] : '';

        return parent::create($data); // TODO: Change the autogenerated stub
    }

    /**
     * 获取单行数据
     * @param int    $id       内容ID
     * @param mixed  $fields   字段
     * @param int    $shopID   门店编号
     *
     * @return mixed
     */
    public static function getFieldsById($id, $fields = '*', $shopID = 0){
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return MemberVehicles::where('id', $id)
            ->where('mem_shop_id', $shopID)
            ->select($fields)
            ->first();
    }

    /**
     * 判断是否存在
     * @param array  $where    条件字段
     * @param int    $shopID   门店编号
     *
     * @return mixed
     */
    public static function getExists($where, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return MemberVehicles::where('mem_shop_id', $shopID)
            ->where('mem_shop_id', $shopID)
            ->where($where)
            ->exist();
    }

    /**
     * 获取首条
     * @param array  $where    条件字段
     * @param int    $shopID   门店编号
     *
     * @return mixed
     */
    public static function getOne($where, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return MemberVehicles::where('mem_shop_id', $shopID)
            ->where($where)
            ->first();
    }

    /**
     * 获取确定行数据
     *
     * @param int $ID       获取ID值
     * @param int $shopID   门店ID
     *
     * @return mixed
     */
    public static function getByID(int $ID,  $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }

        return MemberVehicles::where('id', $ID)
            ->where('shop_id', $shopID)
            ->where('enabled', 1)
            ->first();
    }

}
