<?php

/**
 * 百度接口服务（权限服务）
 * 百度对接使用到的服务文件相关方法（权限基础操作权限）
 * @author DouBin
 * @Date: 2023-07-06 006
 * @Time: 下午 6:01:35
 * @Email: db@sudianwang.com
 * @version 1.0
 * @copyright BlueCity
 */
namespace App\Services\ThreeApi\BaiDu;

use App\Services\CommonService;
use BlueCity\Core\Inc\ErrorInc;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\DB;

class BaiDuService extends Service
{
    /**|---------------------------------------------------------------------------------
     * @name 获取token
     * @param string ju_ordernum 订单单号
     * @retrun /multitype:array
     * @author dou 2023-07-07 007 下午 2:07:56
     * |---------------------------------------------------------------------------------
    */
    public static function getAccessToken ( ){
        $data = DB::table('three_token')->where("type",1)->first();
        if($data){
            $data = CommonService::dataToArray($data);
            if($data['last_time'] > time()){
                $access_token = json_decode($data['data']);
                $access_token = CommonService::dataToArray($access_token);
                return $access_token;
            }
        }
        $url = 'https://aip.baidubce.com/oauth/2.0/token';
        $post_data['grant_type']       = 'client_credentials';
        $post_data['client_id']      = '9CLxL7Z11Gq6XwwgKBIvPcLh';
        $post_data['client_secret'] = 'qVqDIg85oAZTWlWy6eYq0TdpyUeIReza';
        $o = "";
        foreach ( $post_data as $k => $v )
        {
            $o.= "$k=" . urlencode( $v ). "&" ;
        }
        $post_data = substr($o,0,-1);
        $ress = CommonService::requestPost($url, $post_data);
        $res = json_decode($ress);
        $res = CommonService::dataToArray($res);
        if(isset($res['access_token'])){
            $poss['data'] = $ress;
            $poss['create_time'] = date("Y-m-d H:i:s");
            $poss['last_time'] = strtotime($poss['create_time']." +29 day");
            if($data){
                DB::table('three_token')->where("type",1)->update($poss);
            }else{
                $poss['type'] = 1;
                DB::table('three_token')->insert($poss);
            }

        }
        return $res;
    }
    /**|---------------------------------------------------------------------------------
     * @name 获取识别信息
     * @param string $bodys 图片识别信息   url 图片全路径  image 图片base64 两者二选一 id_card_side身份证识别使用区分正反面  具体信息查看百度文档 https://cloud.baidu.com/doc/OCR/index.html   请上传小于4M的图片调用方法 resizeImage
     * @param int $type 1车牌号  2 营业执照  3身份证
     * @retrun \Illuminate\Http\JsonResponse /multitype:array
     * @author dou 2023-07-10 010 上午 10:20:43
     * |---------------------------------------------------------------------------------
    */
    public static function getPicData ( $bodys , $type ){
          if(!in_array($type, [1,2,3,4])){
              return ['code'=>ErrorInc::INVALID_PARAM, 'msg'=>'请求类型错误', 'data'=>''];
          }else{
              $res = self::getAccessToken();
              if(!isset($res['access_token'])){
                  return ['code'=>ErrorInc::REQUEST_FORBIDDEN, 'msg'=>'授权失败', 'data'=>''];
              }else {
                  $token = $res['access_token'];
                  switch ($type) {
                      case 1:
                          $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/license_plate?access_token=' . $token;// 车牌号
                          break;
                      case 2:
                          $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/business_license?access_token=' . $token;//营业执照
                          break;
                      case 3:
                          $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/idcard?access_token=' . $token;//身份证
                          break;
                      case 4:
                          $url = 'https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic?access_token=' . $token;//通用文字识别高精度
                          break;
                      default:
                          return ['code' => ErrorInc::INVALID_PARAM, 'msg' => '请求类型错误', 'data' => ''];
                          break;
                  }
                  $res = CommonService::requestPost($url, $bodys);
                  return ['code'=>200, 'msg'=>'操作成功', 'data'=>json_decode($res)];
              }
          }
    }
}
