<?php

namespace App\Services\SystemsManage;

use App\Http\Controllers\Api\Verify\SystemsManage\VerifyPrivilegesController;
use App\Services\CommonService;
use App\Services\LoginUserService;
use App\Services\Point\PointService;
use App\Services\Shop\ShopService;
use BlueCity\Core\Service\Service;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Models\Common as Comm;

// 权限
class PrivilegesService extends Service
{

    //获取列表信息
    public static function list($search_data)
    {
        $page_size = $search_data['show_count'] ??10;
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        //$shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $list_data = DB::table('privileges')
            //->where('meml_cid', $user_info->adm_cid)
            //->where('meml_superior_shop_id', $shop_id)
            ->where(function ($query) use ($search_data) { //是否显示是否显示：1否2是
                if (!empty($search_data['pri_controller'])) {
                    $query->where('pri_controller', $search_data['pri_controller']);
                }
            })
            ->where(function ($query) use ($search_data) { //是否显示是否显示：1否2是
                if (!empty($search_data['pri_operate_method'])) {
                    $query->where('pri_operate_method', $search_data['pri_operate_method']);
                }
            })
            ->where(function ($query) use ($search_data) { //动作
                if (!empty($search_data['pri_method_name'])) {
                    $query->where('pri_method_name', $search_data['pri_method_name']);
                }
            })
            ->orderBy('pri_id', 'asc')
            ->paginate($page_size);
        $list_items = $list_data->items();
        // 获取当前列表下的按钮
        $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
        //获取top按钮
        $top_button = CommonService::getTopButton('add,addList,addFunction',[],$list_button);
        $default_data = AppletPrivilegesService::rolePrivileges(1,2);
        foreach ($default_data as $ke => $ve){
            $default_d[$ve['id']] = $ve['name'];
        }
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                unset($default_name);
                $pri_fid[] = $value->pri_fid;
                $list_items[$key]->pri_default_name = '';
                if($value->pri_default){
                    $pri_default = explode(',',$value->pri_default);
                    foreach ($pri_default as $k => $v){
                        if(isset($default_d[$v])){
                            $default_name[] = $default_d[$v];
                        }
                    }
                    if(!empty($default_name)){
                        $list_items[$key]->pri_default_name = implode(",",$default_name);
                    }
                }
                //按钮
                $buttonData[] = 'edit';//编辑
                $buttonData[] = 'del';//删除
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];
                unset($buttonData);
            }
        }
        if(isset($pri_fid) && !empty($pri_fid)){
            $fri_data = DB::table('privileges')
                ->whereIn('pri_id', $pri_fid)
                ->get()->toArray();
            foreach ($fri_data as $k => $v) {
                $pri_fid_data[$v->pri_id] = $v->pri_method_name;
            }
        }
        foreach ($list_items as $ke => $ve) {
            $list_items[$ke]->pri_fid_method_name = '';
            if(isset($pri_fid_data[$ve->pri_fid])){
                $list_items[$ke]->pri_fid_method_name = $pri_fid_data[$ve->pri_fid];
            }
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        $data_info['top_button'] = $top_button;
        if ($list_data) {
            return ['code' => 200, 'msg' => '成功', 'data' => $data_info];
        } else {
            return ['code' => 200, 'msg' => '暂无数据', 'data' => '暂无数据'];
        }
    }

    //添加栏目
    public static function add($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyPrivilegesController;
        $error_message = $verify_data->addValidator($request);
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $data = DB::table('privileges')
            ->where('pri_method_name', $request['pri_method_name'])
            ->where('pri_controller', $request['pri_controller'])
            ->where('pri_fid', 0)
            ->where('pri_type', 1)
            ->where('pri_show', 1)
            ->count();
        if($data > 0){
            return ['code' => 500, 'msg' => '该权限已添加,请勿重复添加', 'data' => ''];
        }

        $add_data['pri_fid'] = 0;//父级id
        $add_data['pri_method_name'] = $request['pri_method_name'];//方法名
        $add_data['pri_controller'] = $request['pri_controller'];//控制器
        $add_data['pri_img'] = $request['pri_img'];//栏目图标
        if(isset($request['pri_sord'])){
            $add_data['pri_sord'] = $request['pri_sord'];//排序
        }
        $add_data['pri_type'] = 1;//类型1栏目2列表3方法
        $add_data['pri_show'] = 1;//1显示2不显示
        if(isset($request['pri_default'])){
            $add_data['pri_default'] = $request['pri_default'];//1超级管理员2自家申请的管理员
        }
        $ret_id =  DB::table('privileges')->insertGetId($add_data);
        if ($ret_id) {
            return ['code' => 200, 'msg' => '新增成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => '新增失败'];
        }
    }

    //添加列表
    public static function addList($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyPrivilegesController;
        $error_message = $verify_data->addValidator($request);
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $data = DB::table('privileges')
            ->where('pri_fid', $request['pri_fid'])
            ->where('pri_method_name', $request['pri_method_name'])
            ->where('pri_controller', $request['pri_controller'])
            ->where('pri_operate_method', 'index')
            ->where('pri_type', 2)
            ->where('pri_show', 1)
            ->count();
        if($data > 0){
            return ['code' => 500, 'msg' => '该权限已添加,请勿重复添加', 'data' => ''];
        }
        $add_data['pri_fid'] = $request['pri_fid'];//父级id
        $add_data['pri_method_name'] = $request['pri_method_name'];//方法名
        $add_data['pri_controller'] = $request['pri_controller'];//控制器
        $add_data['pri_operate_method'] = 'index';//操作方法
        if(isset($request['pri_sord'])){
            $add_data['pri_sord'] = $request['pri_sord'];//排序
        }
        $add_data['pri_type'] = 2;//类型1栏目2列表3方法
        $add_data['pri_show'] = 1;//1显示2不显示
        if(isset($request['pri_default'])){
            $add_data['pri_default'] = $request['pri_default'];//1超级管理员2自家申请的管理员
        }
        $ret_id =  DB::table('privileges')->insertGetId($add_data);
        if ($ret_id) {
            return ['code' => 200, 'msg' => '新增成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => '新增失败'];
        }
    }


    //添加方法
    public static function addFunction($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyPrivilegesController;
        $error_message = $verify_data->addValidator($request);
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $data = DB::table('privileges')
            ->where('pri_fid', $request['pri_fid'])
            ->where('pri_method_name', $request['pri_method_name'])
            ->where('pri_controller', $request['pri_controller'])
            ->where('pri_operate_method', $request['pri_operate_method'])
            ->where('pri_type', 3)
            ->where('pri_show', 1)
            ->where('pri_position', $request['pri_position'])
            ->count();
        if($data > 0){
            return ['code' => 500, 'msg' => '该权限已添加,请勿重复添加', 'data' => ''];
        }
        $add_data['pri_fid'] = $request['pri_fid'];//父级id
        $add_data['pri_method_name'] = $request['pri_method_name'];//方法名
        $add_data['pri_controller'] = $request['pri_controller'];//控制器
        $add_data['pri_operate_method'] = $request['pri_operate_method'];//操作方法
        if(isset($request['pri_sord'])){
            $add_data['pri_sord'] = $request['pri_sord'];//排序
        }
        $add_data['pri_type'] = 3;//类型1栏目2列表3方法
        $add_data['pri_show'] = 1;//1显示2不显示
        $add_data['pri_position'] = $request['pri_position'];//动作显示位置：1，横排；2，记录后;3不显示；4搜索栏
        if(isset($request['pri_default'])){
            $add_data['pri_default'] = $request['pri_default'];//1超级管理员2自家申请的管理员
        }
        $ret_id =  DB::table('privileges')->insertGetId($add_data);
        if ($ret_id) {
            return ['code' => 200, 'msg' => '新增成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => '新增失败'];
        }
    }

    //删除
    public static function del($request)
    {
        // 验证数据
        $verify_data = new VerifyPrivilegesController;
        $error_message = $verify_data->delValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $data = DB::table('privileges')
            ->where('pri_id', $request['id'])
            ->count();
        if($data <= 0){
            return ['code' => 500, 'msg' => '数据不存在', 'data' => ''];
        }
        if($request['id']){
            $del_res = DB::table('privileges')
                ->where('pri_id', $request['id'])
                ->update(['pri_show'=>2]);
            if ($del_res) {
                return ['code' => 200, 'msg' => '删除成功', 'data' =>''];
            } else {
                return ['code' => 500, 'msg' => '删除失败', 'data' => ''];
            }
        }

    }

    //编辑
    public static function edit($request)
    {
        // 验证数据
        $verify_data = new VerifyPrivilegesController;
        $error_message = $verify_data->editValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        if($request['type'] == 1){//栏目
            $update_data['pri_method_name'] = $request['pri_method_name'];
            $update_data['pri_controller'] = $request['pri_controller'];
            $update_data['pri_img'] = $request['pri_img'];
            $update_data['pri_sord'] = $request['pri_sord'];
            $update_data['pri_show'] = $request['pri_show']??1;
            $update_data['pri_default'] = $request['pri_default'];
        }else if($request['type'] == 2){
            $update_data['pri_fid'] = $request['pri_fid'];
            $update_data['pri_method_name'] = $request['pri_method_name'];
            $update_data['pri_controller'] = $request['pri_controller'];
            $update_data['pri_sord'] = $request['pri_sord'];
            $update_data['pri_show'] = $request['pri_show']??1;
            $update_data['pri_default'] = $request['pri_default'];
        }else if($request['type'] == 3){
            $update_data['pri_fid'] = $request['pri_fid'];
            $update_data['pri_method_name'] = $request['pri_method_name'];
            $update_data['pri_controller'] = $request['pri_controller'];
            $update_data['pri_operate_method'] = $request['pri_operate_method'];
            $update_data['pri_sord'] = $request['pri_sord'];
            $update_data['pri_show'] = $request['pri_show']??1;
            $update_data['pri_position'] = $request['pri_position'];
            $update_data['pri_default'] = $request['pri_default'];
        }
        if($request['id'] && $update_data){
            $data = DB::table('privileges')
                ->where('pri_id', $request['id'])
                ->update($update_data);
        }
        if ($data) {
            return ['code' => 200, 'msg' => '编辑成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '编辑失败', 'data' => ''];
        }
    }

    //栏目列表
    public static function columnList()
    {
        $data = DB::table('privileges')
            ->where('pri_type', 1)//栏目
            ->where('pri_show', 1)//显示
            ->select('pri_id','pri_method_name')
            ->get()->toArray();
        if ($data) {
            return ['code' => 200, 'msg' => '成功', 'data' =>$data];
        } else {
            return ['code' => 500, 'msg' => '失败', 'data' => '失败'];
        }
    }

    //左侧列表
    public static function modelList()
    {
        $data_list = DB::table('privileges')
            ->whereIn('pri_type', [1,2])//栏目
            ->where('pri_show', 1)//显示
            ->get()->toArray();
        foreach ($data_list as $key => $value){
            if($value->pri_type == 1){
                $data[$value->pri_type][] = $value;
            }else{
                $list[$value->pri_fid][] = $value;
            }
        }
        if(isset($data[1])){
            foreach ($data[1] as $k => $v){
                if(isset($list[$v->pri_id])){
                    foreach ($list[$v->pri_id] as $ke => $kv){
                        $res[] = ['id'=>$kv->pri_id,'name'=>$v->pri_method_name.'-'.$kv->pri_method_name];
                    }
                }
            }
        }
        if (isset($res)) {
            return ['code' => 200, 'msg' => '成功', 'data' =>$res];
        } else {
            return ['code' => 500, 'msg' => '失败', 'data' => '失败'];
        }
    }
}