<?php

namespace App\Services\Software;

use BlueCity\Core\Service\Service;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Ramsey\Uuid\Uuid;
use Illuminate\Support\Facades\Storage;

class QrCodeService extends Service
{

    /**
     * 生成二维码
     * @param int $type 类型：1创建二维码不保存图片2创建二维码并保存图片
     * @param string $text 内容数据
     * @param string $filename 二维码图片路径
     * @return mixed
     */
    public function qrCode($type = 1, $text = '内容数据', $filename = '')
    {
        // 二维码的参数设置
        // format('png')      //format自定义输出图片格式,必须第一个被设置,支持 PNG，EPS，SVG 三种格式；不输出图片不用设置
        // size(200)         //设置尺寸
        // color(255,0,255)    //颜色设置的格式必须是RBG格式
        // backgroundColor(125,245,0)    //设置背景色
        // encoding('UTF-8')   //指定中文编码
        // margin(2)         //边距设置
        // errorCorrection("L")  //容错级别设置(L<M<Q<H容错级别越高,二维码里能存储的数据越少)
        // merge($png,.3,true) //Logo或者头像放到二维码图片中($png是Logo或者头像的路径与图片名;.3:LOGO图片占整个二维码图片的30%;true:绝对路径的LOGO图片地址)。merge 方法当前只支持PNG格式的图片 默认使用相对于应用程序的根路径,把第三个参数设置为 true 就能切换到使用绝对路径
        // generate($text,$filename)  //创建二维码($text数据,$filename保存的路径与图片名)

        // 创建二维码不生成图片
        if ($type == 1) {
            // 把生成的二维码数据返回
            return QrCode::encoding('UTF-8')
                ->size(200)
                ->errorCorrection("L")
                ->margin(2)
                ->generate($text);
        } else {
            //随机二维码图片名
            $fileName = Uuid::uuid4()->toString() . '.png';
            //二维码图片路径
            $file_path = storage_path('app/public/qrcode').'/'.$fileName;
            //创建二维码并保存二维码图片
            QrCode::format('png')                //format自定义输出图片格式,必须第一个被设置,支持 PNG，EPS，SVG 三种格式
                ->size(200)                   //设置尺寸
                ->color(0,0,0)       //颜色设置的格式必须是RBG格式
                ->backgroundColor(255,255,255)    //设置背景色
                ->encoding('UTF-8')     //指定中文编码
                ->margin(0)               //边距设置
                ->errorCorrection("L")  //容错级别设置(L<M<Q<H容错级别越高,二维码里能存储的数据越少)
                // ->merge($png,.3,true) //Logo或者头像放到二维码图片中($png是Logo或者头像的路径与图片名;.3:LOGO图片占整个二维码图片的30%;true:绝对路径的LOGO图片地址)。merge 方法当前只支持PNG格式的图片 默认使用相对于应用程序的根路径,把第三个参数设置为 true 就能切换到使用绝对路径
                ->generate($text,$file_path);              //创建二维码($text数据,$filename保存的路径与图片名)
            
            // 返回路径
            $file_path = "storage/qrcode/" . $fileName;
            return $file_path;  
        }
    }
}
