<?php

namespace App\Services\Shop;

use App\Services\Business\WashOrderService;
use Illuminate\Database\Eloquent\Model;
use App\Models\Shop\VipCard;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Shop\VipCardValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Request;
use App\Models\Common;
use App\Services\Business\NewOrderService;
use App\Services\Business\WashOrderBasicService;

class VipCardService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new VipCard();
        $this->mainValidator = new VipCardValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10, $field_columns = [])
    {
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            // 查询字段
            $field_columns = ['vica_id', 'vica_name', 'vica_sepr_id', 'vica_sepr_name', 'vica_num', 'vica_price', 'vica_effective_date', 'vica_instructions', 'vica_create_time', 'vica_create_adm_id', 'vica_update_time', 'vica_update_adm_id', 'vica_state', 'vica_long_term'];
        }
        // 企业客户管理表
        $list_data = DB::table('vip_card')
            ->where('vica_cid', $user_info->adm_cid)
            ->where('vica_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vica_name'])) {
                    $query->where('vica_name', 'like', '%' . $search_data['vica_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vica_state'])) {
                    $query->where('vica_state', $search_data['vica_state']);
                }
            })
            ->select($field_columns)
            ->orderBy('vica_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $vica_create_adm_id = array_unique(array_column($list_items, 'vica_create_adm_id')); //创建人id
            $vica_update_adm_id = array_unique(array_column($list_items, 'vica_update_adm_id')); //更新人id
            $adm_id_merge = array_merge($vica_create_adm_id, $vica_update_adm_id);
            // 查询人员信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();
            foreach ($list_items as $key => $value) {
                $vica_detail = DB::table('vip_card_detail')
                    ->where('vicad_vcid',$value->vica_id)
                    ->get()->toArray();
                if ($vica_detail) {
                    foreach ($vica_detail as $key1 => $value1) {
                        if ($value1->vicad_type == 1) {
                            $goo_unit = DB::table('goods')
                                ->where('goo_id', $value1->vicad_data_id)
                                ->value('goo_unit');
                            $vica_detail[$key1]->vicad_data_name = $value1->vicad_data_name.'('.$goo_unit.')';
                        }
                    }
                }
                $list_items[$key]->vica_detail = $vica_detail;
                // 创建人
                if ($value->vica_create_adm_id) {
                    $list_items[$key]->vica_create_adm_name = isset($find_adm[$value->vica_create_adm_id]) ? $find_adm[$value->vica_create_adm_id] : '';
                } else {
                    $list_items[$key]->vica_create_adm_name = '';
                }
                // 更新人
                if ($value->vica_update_adm_id) {
                    $list_items[$key]->vica_update_adm_name = isset($find_adm[$value->vica_update_adm_id]) ? $find_adm[$value->vica_update_adm_id] : '';
                } else {
                    $list_items[$key]->vica_update_adm_name = '';
                }
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 我的会员卡列表
    public static function vipCardIndex($user_info, $search_data, $show_count = 20, $field_columns = [])
    {
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            // 查询字段
            $field_columns = ['myvi_id', 'myvi_adm_id', 'myvi_num', 'myvi_create_adm_id', 'myvi_create_time', 'myvi_surplus_times', 'myvi_all_times', 'myvi_effective_date', 'myvi_state', 'myvi_carnum', 'myvi_name', 'myvi_sepr_id', 'myvi_sepr_name', 'myvi_long_term', 'myvi_end_time'];
        }
        // 我的会员卡管理表
        $list_data = DB::table('myvip')
            ->where('myvi_adm_id', $search_data['adm_id'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['myvi_state'])) {//1未使用完2已使用完3已过期
                    $query->where('myvi_state', $search_data['myvi_state']);
                }
            })
            ->select($field_columns)
            ->orderBy('myvi_end_time', 'asc')
            ->orderBy('myvi_create_time', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $myvi_create_adm_id = array_unique(array_column($list_items, 'myvi_create_adm_id')); //创建人id
            // 查询人员信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $myvi_create_adm_id)
                ->pluck('adm_name', 'adm_id')->toArray();
            foreach ($list_items as $key => $value) {
                $detail = DB::table('myvip_detail')
                    ->where('myvid_mvid', $value->myvi_id)
                    ->get()->toArray();
                if (!empty($detail)) {
                    foreach ($detail as $k => $v) {
                        if ($v->myvid_type == 1) {
                            $goo_unit = DB::table('goods')
                                ->where('goo_id', $v->myvid_data_id)
                                ->select('goo_unta_id', 'goo_unit')
                                ->first();
                        } else {
                            $goo_unit = '';
                        }
                        if ($goo_unit) {
                            $detail[$k]->myvid_data_name = $v->myvid_data_name.'('.$goo_unit->goo_unit.')';
                            $detail[$k]->goo_unit = $goo_unit->goo_unit;
                            $detail[$k]->goo_unta_id = $goo_unit->goo_unta_id;
                        } else {
                            $detail[$k]->goo_unit = '次';
                            $detail[$k]->goo_unta_id = 0;
                        }
                    }
                }
                $list_items[$key]->detail = $detail;

                // 创建人
                if ($value->myvi_create_adm_id && isset($find_adm[$value->myvi_create_adm_id])) {
                    $list_items[$key]->myvi_create_adm_name = $find_adm[$value->myvi_create_adm_id];
                } else {
                    $list_items[$key]->myvi_create_adm_name = '';
                }

                if (time() > strtotime($value->myvi_end_time) && $value->myvi_state == 1 && $value->myvi_long_term == 2) {
                    $update_data['myvi_state'] = 3;//1未使用完2已使用完3已过期
                    $update_data['myvi_update_time'] = date('Y-m-d H:i:s');
                    $update_res = DB::table('myvip')
                        ->where('myvi_id', $value->myvi_id)
                        ->update($update_data);
                    if (!$update_res) {
                        return ['code'=>500, 'msg'=>'会员卡更新失败', 'data'=>'会员卡更新失败'];
                    }
                }
                // 失效时间
                if ($value->myvi_end_time) {
                    $list_items[$key]->myvi_end_time = date("Y-m-d", strtotime($value->myvi_end_time));
                } else {
                    $list_items[$key]->myvi_end_time = '';
                }
            }
        }
        $data['code'] = 200;  //状态码
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 我的会员卡详情
    public static function myVipInfo($user_info, $request)
    {
        $info = DB::table('myvip')
            ->where('myvi_adm_id', $request['adm_id'])
            ->where('myvi_id', $request['myvi_id'])
            ->select('myvi_id', 'myvi_adm_id', 'myvi_num', 'myvi_create_adm_id', 'myvi_create_time', 'myvi_surplus_times', 'myvi_all_times', 'myvi_effective_date', 'myvi_state', 'myvi_carnum', 'myvi_name', 'myvi_sepr_id', 'myvi_sepr_name', 'myvi_long_term', 'myvi_vica_id', 'myvi_explain', 'myvi_end_time')
            ->first();
        if ($info->myvi_end_time != '0000-00-00 00:00:00') {
            $info->myvi_end_time = date('Y-m-d', strtotime($info->myvi_end_time));
        } else {
            $info = '';
        }
        $info->detail = DB::table('myvip_detail')
            ->where('myvid_mvid', $info->myvi_id)
            ->get()->toArray();
        return $info;
    }


    /**
     * 检查是不是存在同名内容
     * @param $name 考核项名称
     * @param $type 类型：1施工部位2整车3其他
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function nameExists($user_info, $request, $id = 0)
    {
        if ($id == 0) {
            return VipCard::where('vica_name', $request['vica_name'])
                ->where('vica_shop_id', $user_info->adm_shop_id)
                ->where('vica_state', 1)
                ->exists();
        } else {
            return VipCard::where('vica_name', $request['vica_name'])
                ->where('vica_shop_id', $user_info->adm_shop_id)
                ->where('vica_state', 1)
                ->where('vica_id', '<>', $id)
                ->exists();
        }
    }

    // 新增
    public static function add($user_info, $request)
    {
        $goo_info = $request['goo_info'];
        $vica_num = 0;
        if (!empty($goo_info)) {
            foreach ($goo_info as $key => $value) {
                $vica_num += $value['goo_num'];
            }
        }
        $data['vica_cid'] = $user_info->adm_cid;
        $data['vica_shop_id'] = $user_info->adm_shop_id;
        $data['vica_create_adm_id'] = $user_info->adm_id;
        $data['vica_update_adm_id'] = $user_info->adm_id;
        $data['vica_name'] = $request['vica_name']; //会员卡名称
        // $data['vica_sepr_id'] = $request['vica_sepr_id']; //服务项目id
        // $data['vica_sepr_name'] = $request['vica_sepr_name']; //服务项目名称
        $data['vica_create_time'] = date('Y-m-d H:i:s');
        $data['vica_update_time'] = date('Y-m-d H:i:s');
        $data['vica_num'] = $vica_num; //次数
        if (round($request['vica_price'],2) == 0.00 || round($request['vica_shop_price'],2) == 0.00) {
            return ["code"=>500, 'msg'=>'金额错误', 'data'=>'金额错误'];
        }
        $data['vica_price'] = $request['vica_price']*100; //价格
        $data['vica_shop_price'] = $request['vica_shop_price']*100; //门市价格
        $data['vica_effective_date'] = $request['vica_effective_date']; //有效期
        $data['vica_long_term'] = $request['vica_long_term']; //是否长期
        if ($request['vica_long_term'] == 2) {
            if (empty($request['vica_effective_date'])) {
                return ["code"=>500, 'msg'=>'有效期不能为0', 'data'=>'有效期不能为0'];
            }
            if ($request['vica_effective_date'] < 0) {
                return ["code"=>500, 'msg'=>'有效期不能小于0', 'data'=>'有效期不能为0'];
            }
        }
        $data['vica_instructions'] = isset($request['vica_instructions']) ? $request['vica_instructions'] : ''; //使用说明
        DB::beginTransaction();
        $vip_id = VipCard::insertGetId($data);
        if (!$vip_id) {
            DB::rollBack();
            return ["code"=>500, 'msg'=>'添加失败', 'data'=>'添加失败'];
        }
        $goo_info = $request['goo_info'];
        $count = count($goo_info);
        if ($count > 5) {
            return ["code"=>500, 'msg'=>'项目数量不能大于5', 'data'=>'项目数量不能大于5'];
        }
        if (!empty($goo_info)) {
            foreach ($goo_info as $key => $value) {
                $add_data['vicad_vcid'] = $vip_id;
                if (empty($value['goo_id'])) {
                    DB::rollBack();
                    return ["code"=>500, 'msg'=>'请设置项目', 'data'=>'请设置项目'];
                }
                $add_data['vicad_data_id'] = $value['goo_id'];
                $add_data['vicad_data_name'] = $value['goo_name'];
                if ($value['goo_num'] == 0) {
                    DB::rollBack();
                    return ["code"=>500, 'msg'=>'请设置项目数量', 'data'=>'请设置项目数量'];
                }
                $add_data['vicad_num'] = $value['goo_num'];
                $add_data['vicad_type'] = $value['goo_type'];
                $add_data['vicad_goo_price'] = $value['goo_price']*100;
                $res = DB::table('vip_card_detail')->insert($add_data);
                if (!$res) {
                    DB::rollBack();
                    return ["code"=>500, 'msg'=>'添加失败', 'data'=>'添加失败'];
                }
            }
        }
        DB::commit();
        return ["code"=>200, 'msg'=>'添加成功', 'data'=>'添加成功'];
    }

    // 新增会员卡
    public static function addvipcard($user_info, $request, $type = 1)
    {
        $find_user_data = DB::table('member')
            ->where('mem_id', $request['adm_id'])
            ->select('mem_address', 'mem_phone', 'mem_name', 'mem_province', 'mem_city', 'mem_county')
            ->first();
        $find_vica_data = DB::table('vip_card')
            ->where('vica_id', $request['vica_id'])
            ->where('vica_state', 1)
            ->select('vica_price', 'vica_state', 'vica_id', 'vica_name', 'vica_num', 'vica_long_term', 'vica_sepr_id', 'vica_sepr_name', 'vica_instructions', 'vica_effective_date')
            ->first();
        if ($find_vica_data) {
            if (!isset($request['vica_price'])) {
                $request['vica_price'] = $find_vica_data->vica_price;
            }
        } else {
            return ['code'=>500, 'msg'=>'未查询到此会员卡', 'data'=>'未查询到此会员卡'];
        }
        $request['ord_type'] = 1;
        $request['add_type'] = 1;
        $request['ord_client_id'] = $request['adm_id'];
        $request['orcl_phone'] = $find_user_data->mem_phone;
        $request['orcl_name'] = $find_user_data->mem_name;
        $request['orcl_car_num'] = $request['myvi_carnum'];
        $request['orcl_province'] = $find_user_data->mem_province;
        $request['orcl_city'] = $find_user_data->mem_city;
        $request['orcl_county'] = $find_user_data->mem_county;
        $request['orcl_address'] = $find_user_data->mem_address;
        $request['orcl_province'] = $find_user_data->mem_name;
        $request['goods_data'][0]['goo_name'] = $find_vica_data->vica_name; //会员卡名称
        $request['goods_data'][0]['goo_price'] = $request['vica_price'];
        $request['goods_data'][0]['goo_id'] = $request['vica_id'];
        $add_order_res = self::addOrder($user_info, $request, $type);
        if ($add_order_res['code'] == 500) {
            return $add_order_res;
        }
        $myvi_num = 'HYK'.time().rand(10000,99999);
        $data['myvi_num'] = $myvi_num;//会员卡编号
        if ($type == 1) {//pc添加会员卡
            $data['myvi_create_adm_id'] = $user_info->adm_id;
            $data['myvi_shop_id'] = $user_info->adm_shop_id;
            $data['myvi_adm_id'] = $request['adm_id'];
            $data['myvi_surplus_times'] = $find_vica_data->vica_num; //剩余次数
            $data['myvi_all_times'] = $find_vica_data->vica_num; //总次数
            $data['myvi_long_term'] = $find_vica_data->vica_long_term; //是否长期1是2否
            $data['myvi_carnum'] = !empty($request['myvi_carnum']) ? $request['myvi_carnum']:''; //绑定车牌
            // $data['myvi_sepr_id'] = $find_vica_data->vica_sepr_id; //服务项目id
            // $data['myvi_sepr_name'] = $find_vica_data->vica_sepr_name; //服务项目名称
            $data['myvi_name'] = $find_vica_data->vica_name; //会员卡名称
            $data['myvi_explain'] = $find_vica_data->vica_instructions; //会员卡使用说明
            $data['myvi_vica_id'] = $request['vica_id']; //会员卡id
            $data['myvi_create_time'] = date('Y-m-d H:i:s');
            if ($find_vica_data->vica_long_term == 2) {//是否长期1是2否
                $data['myvi_effective_date'] = $find_vica_data->vica_effective_date; //有效天数
                $data['myvi_end_time'] = date('Y-m-d', strtotime(date('Y-m-d').'23:59:59') + ($find_vica_data->vica_effective_date)*60*60*24).' 23:59:59';
            } else {
                $data['myvi_end_time'] = date('Y-m-d', time() + 99999*60*60*24);
            }
            $myvi_id = DB::table('myvip')->insertGetId($data);
            $find_detail = DB::table('vip_card_detail')
                ->where('vicad_vcid', $request['vica_id'])
                ->get()->toArray();
            foreach ($find_detail as $key => $value) {
                $add_detail['myvid_mvid'] = $myvi_id;
                $add_detail['myvid_surplus_times'] = $value->vicad_num;
                $add_detail['myvid_all_times'] = $value->vicad_num;
                $add_detail['myvid_data_id'] = $value->vicad_data_id;
                $add_detail['myvid_data_name'] = $value->vicad_data_name;
                $add_detail['myvid_type'] = $value->vicad_type;
                $add_detail['myvid_goo_price'] = $value->vicad_goo_price;
                $add_detail_res = DB::table('myvip_detail')->insert($add_detail);
                if (!$add_detail_res) {
                    return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
                }
            }
        } else {
            $myvi_id = true;
        }

        if ($myvi_id) {
            return $add_order_res;
            // return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    // 新增-添加会员卡订单
    public static function addOrder($user_info, $request, $type = 1)
    {
        if ($type == 1) {
            // 获取唯一字符串标识
            $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        } else {
            // 获取唯一字符串标识
            $ord_unique_string = md5(md5($user_info->ussh_user_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        }
        $ord_order_number = Common::numberRule($user_info, 1);
        $data['ord_is_split'] = 1;
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        if ($type == 1) {
            $data['ord_create_id'] = $user_info->adm_id;
            $data['ord_client_id'] = $request['ord_client_id'];
        } else {
            $data['ord_create_id'] = 0;
            $data['ord_client_id'] = $user_info->ussh_user_id;
        }
        $data['ord_address'] = Db::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_store_name');
        $data['ord_address_id'] = $user_info->adm_shop_id;
        $data['ord_address_type'] = 1;
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1;//买家类型：1门店零售2企业客户
        $data['ord_service_type'] = 4; //订单类型：1服务单 2洗车单3商品单4会员卡
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式1账期2现结
        $data['ord_source'] = $type;//下单来源1pc2车主小程序
        $data['ord_wor_state'] = 20; //4已完成
        if ($type == 1) {//pc新增会员卡
            $data['ord_state'] = 2; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_order_price'] = $request['vica_price']*100; //订单金额（前端传过来的金额单位是分，这里不*100）
            $data['ord_actual_price'] = $request['vica_price']*100; //结算金额
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算时间
        } else {
            $data['ord_actual_price'] = $request['vica_price']; //结算金额
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算时间
            $data['ord_order_price'] = $request['vica_price']; //订单金额（数据库查询的金额单位是分，这里不*100）
        }
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $data['ord_source'] = 1;  // 来源  1 pc  2 车主小程序   3 技师
        if(isset($request['rt'])){
            if($request['rt']=='wechat'){
                $data['ord_source'] = 3;
            }elseif($request['rt']=='wechatWash'){
                $data['ord_source'] = 2;
            }
        }
        $ord_id = NewOrderService::newOrder($data);
        //计算会员消费总金额
        if(isset($request['ord_client_id']) && !empty($request['ord_client_id'])){
            WashOrderService::consume_money($request['ord_client_id']);
        }

        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_phone', $request['orcl_phone'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            if ($request['ord_type'] == 1) { //买家类型：1会员零售
                // 零售，会员表
                $client_res = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->increment('mem_order_all');
                // $weus_id = $find_weixin_data->weus_id;
            } else {
                $client_res = true;
            }
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_name' => $request['orcl_name'],
            'orcl_phone' => $request['orcl_phone'],
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_province' => isset($request['orcl_province']) ? $request['orcl_province'] : '',
            'orcl_city' => isset($request['orcl_city']) ? $request['orcl_city'] : '',
            'orcl_county' => isset($request['orcl_county']) ? $request['orcl_county'] : '',
            'orcl_address' => isset($request['orcl_address']) ? $request['orcl_address'] : '',
            'orcl_shipment_party' => isset($request['orcl_shipment_party']) ? $request['orcl_shipment_party'] : 1, //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];
        
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);

        $goods_data = $request['goods_data'];
        if (!empty($goods_data)) {
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            // 新增订单商品数据
            foreach ($goods_data as $key => $value) {
                if (!isset($value['goo_type'])) {
                    $value['goo_type'] = 4;//1商品2服务3套餐商品4会员卡
                    $goods_data[$key]['goo_type'] = 4;
                }
                if (!isset($value['goo_state'])) {
                    $value['goo_state'] = 4;
                    $goods_data[$key]['goo_state'] = 4;
                }
                $orgo_data['orgo_ord_id'] = $ord_id;
                $orgo_data['orgo_order_number'] = $ord_order_number;
                $orgo_data['orgo_goo_id'] = $value['goo_id'];
                $orgo_data['orgo_goo_name'] = $value['goo_name'];
                $orgo_data['orgo_goo_type'] = $value['goo_type'];
                if ($type == 2) {
                    $orgo_data['orgo_goo_price'] = $request['vica_price'];
                } else {
                    $orgo_data['orgo_goo_price'] = $request['vica_price']*100;
                }
                $orgo_data['orgo_state'] = $value['goo_state'];
                $orgo_data['orgo_goo_quantity'] = 1;
                $orgo_data['orgo_goo_unit'] = '张';
                $orgo_data['orgo_goo_unta_id'] = 7;
                $orgo_goo_point = DB::table('point_goods')  
                    ->where('pogo_shop_id', $user_info->adm_shop_id)
                    ->where('pogo_goo_type', 3)
                    ->where('pogo_goo_id', $value['goo_id'])
                    ->value('pogo_goo_point');
                $orgo_data['orgo_goo_amount'] = $orgo_data['orgo_goo_price'];
                $orgo_data['orgo_goo_point'] = $orgo_goo_point;
                $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                $goods_data[$key]['orgo_id'] = $orgo_id; //立即派单使用
                $goo_all_quantity += 1; //商品总数量
            }
        }

        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = DB::table('order')->where('ord_id', $ord_id)->update($ord_edit_data);
        $ord_data = DB::table('order')
            ->where('ord_id', $ord_id)
            ->select('ord_state', 'ord_wor_state', 'ord_type', 'ord_client_id')
            ->first();
        if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1 && $request['ord_payment_way'] != 5) {//已结算 待评价或已完成 个人会员 添加积分
            $add_point = WashOrderBasicService::addPoint($user_info,$ord_data->ord_client_id,$ord_id);
        }
        if ($ord_id && $orcl_id && $ord_edit_res) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_price'] = $data['ord_order_price']; //订单金额
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['goods_data'] = json_encode($goods_data); //商品信息
            $return_data['ord_type'] = $request['ord_type']; //买家类型1.会员零售2.企业客户
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增失败'];
        }
    }

    // 编辑
    public static function edit($user_info,$request)
    {
        $data['vica_cid'] = $user_info->adm_cid;
        $data['vica_shop_id'] = $user_info->adm_shop_id;
        $data['vica_update_adm_id'] = $user_info->adm_id;
        $data['vica_name'] = $request['vica_name']; //会员卡名称
        $data['vica_sepr_id'] = $request['vica_sepr_id']; //服务项目id
        $data['vica_sepr_name'] = $request['vica_sepr_name']; //服务项目名称
        $data['vica_update_time'] = date('Y-m-d H:i:s');
        $data['vica_num'] = $request['vica_num']; //次数
        $data['vica_price'] = $request['vica_price']*100; //价格
        $data['vica_effective_date'] = $request['vica_effective_date']; //有效期
        $data['vica_long_term'] = $request['vica_long_term']; //是否长期
        $data['vica_instructions'] = isset($request['vica_instructions']) ? $request['vica_instructions'] : ''; //使用说明
        return VipCard::where('vica_id', $request['vica_id'])->update($data);
    }

    // 更改状态
    public static function editState($ids, $state)
    {
        $data['vica_state'] = $state;
        $data['vica_update_time'] = date('Y-m-d H:i:s');
        return VipCard::whereIn('vica_id', $ids)
            ->update($data);
    }

    // 会员卡使用明细
    public static function detailIndex($user_info, $search_data, $show_count = 10, $field_columns = [])
    {
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            // 查询字段
            $field_columns = ['vcre_id', 'vcre_myvi_id', 'vcre_user_id', 'vcre_ord_num', 'vcre_ord_id', 'vcre_create_time', 'vcre_car_adm_name', 'vcre_car_adm_phone', 'vcre_myvi_num', 'myvi_name', 'vcre_num_change', 'vcre_log', 'orcl_car_num', 'myvi_surplus_times','vcrd_num', 'myvid_data_name','myvid_surplus_times'];
        }
        // 会员卡明细表
        $list_data = DB::table('vipca_record_datail')
            ->leftJoin('vip_card_record as v', 'vcre_id','=','vcrd_vcre_id')
            ->leftJoin('myvip_detail', 'myvid_id', '=','vcrd_myvid_id')
            ->leftJoin('myvip as m', 'm.myvi_id', '=', 'v.vcre_myvi_id')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'v.vcre_ord_id')
            ->where('vcre_user_id', $search_data['mem_id'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['myvi_id'])) {
                    $query->where('myvi_id', $search_data['myvi_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vcre_myvi_num'])) {
                    $query->where('vcre_myvi_num', 'like', '%' . $search_data['vcre_myvi_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('vcre_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('vcre_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('vcre_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select($field_columns)
            ->orderBy('vcre_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        foreach ($list_items as $key => $value) {
        //     $detail = DB::table('vipca_record_datail')
        //         ->leftJoin('myvip_detail', 'myvid_id', '=','vcrd_myvid_id')
        //         ->where('vcrd_vcre_id', $value->vcre_id)
        //         ->get()->toArray();
        //     $description = '';
        //     foreach ($detail as $k => $v) {
        //         $description .= 
        //     }
            // if ($value->vcre_log == 1) {//1结算2取消
            //     $list_items[$key]->vcre_num_change = '-'.$value->vcrd_num.'/余'.$value->myvid_surplus_times;
            // } else {
            //     $list_items[$key]->vcre_num_change = '+'.$value->vcrd_num.'/余'.$value->myvid_surplus_times;
            // }
            $list_items[$key]->vcre_num_change  = $value->vcrd_description;
            if ($value->myvid_type == 1) {
                $goo_unit = DB::table('goods')
                    ->where('goo_id', $value->myvid_data_id)
                    ->value('goo_unit');
            } else {
                $goo_unit = '';
            }
            if ($goo_unit) {
                $list_items[$key]->myvid_data_name = $value->myvid_data_name.'('.$goo_unit.')';
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }
}
