<?php
namespace App\Services\Point;
use App\Models\Point\Point;
use App\Services\CommonService;
use BlueCity\Core\Service\Service;
use DB;
use App\Http\Requests\Validators\Point\PointValidator;

class PointService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new Point();
        $this->mainValidator = new PointValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 积分设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function pointConfig($user_info,$data)
    {
        $poco_id = Point::where('poco_shop_id', $user_info->adm_shop_id)->value('poco_id');
        $add_data['poco_shop_id'] = $user_info->adm_shop_id;
        if (isset($data['poco_point_switch'])) {
            $add_data['poco_point_switch'] = $data['poco_point_switch'];
            if ($data['poco_point_switch'] == 1) {
                $sico_id = DB::table('sign_config')->where('sico_shop_id', $user_info->adm_shop_id)->value('sico_id');
                $add_share_data['shco_proportion'] = 1;
                $add_share_data['shco_divide_proportion'] = 1;
                $add_share_data['shco_shop_id'] = $user_info->adm_shop_id;
                $shco_id = DB::table('share_config')->where('shco_shop_id', $user_info->adm_shop_id)->value('shco_id');
                if (!$sico_id) {
                    DB::beginTransaction();
                    $add_sign_data['sico_shop_id'] = $user_info->adm_shop_id;
                    $add_sign_data['sico_create_time'] = date("Y-m-d H:i:s");
                    $add_sign_data['sico_start_time'] = date("Y-m-d");
                    $add_sign_data['sico_create_id'] = $user_info->adm_id;
                    $sico_id = DB::table('sign_config')->insertGetId($add_sign_data);
                    for($i=0;$i<31;$i++){
                        $add_sign_day_data[$i]['sidco_scid'] = $sico_id;
                        $add_sign_day_data[$i]['sidco_name'] = '';
                        $add_sign_day_data[$i]['sidco_type'] = $i+1;
                        if($i>0){
                            $add_sign_day_data[$i]['sidco_points'] = 0;
                        }else {
                            $add_sign_day_data[$i]['sidco_points'] = '1';
                        }
                    }
                    $dayadd = DB::table('sign_day_config')->insert($add_sign_day_data);
                    if($sico_id && $dayadd){
                        DB::commit();
                    }else{
                        DB::rollback();
                    }
                }
                if (!$shco_id) {
                    $shco_id = DB::table('share_config')->insertGetId($add_share_data);
                }
            }
        }
        if (isset($data['poco_firstord_point'])) {
            $add_data['poco_firstord_point'] = $data['poco_firstord_point'];
        }
        if (isset($data['poco_firstord_times'])) {
            $add_data['poco_firstord_times'] = $data['poco_firstord_times'];
        }
        if (isset($data['poco_name_point'])) {
            $add_data['poco_name_point'] = $data['poco_name_point'];
        }
        if (isset($data['poco_phone_point'])) {
            $add_data['poco_phone_point'] = $data['poco_phone_point'];
        }
        if (isset($data['poco_birth_point'])) {
            $add_data['poco_birth_point'] = $data['poco_birth_point'];
        }
        $add_data['poco_update_id'] = $user_info->adm_id;
        $add_data['poco_update_time'] = date('Y-m-d H:i:s');
        if ($poco_id) {
            $poco_update_res = DB::table('point_config')->where('poco_id', $poco_id)->update($add_data);
        } else {
            $poco_id = Point::insertGetId($add_data);
        }
        return $poco_id;
    }

    /**
     * 积分设置-新增积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function addPointGoods($user_info,$data)
    {
        $pogo_id = DB::table('point_goods')
            ->where('pogo_shop_id', $user_info->adm_shop_id)
            ->where('pogo_goo_type', $data['pogo_goo_type'])
            ->where('pogo_goo_id', $data['pogo_goo_id'])
            ->value('pogo_id');
        $add_data['pogo_shop_id'] = $user_info->adm_shop_id;
        $add_data['pogo_goo_type'] = $data['pogo_goo_type'];
        $add_data['pogo_goo_id'] = $data['pogo_goo_id'];
        $add_data['pogo_goo_name'] = $data['pogo_goo_name'];
        $add_data['pogo_goo_point'] = $data['pogo_goo_point'];
        $add_data['pogo_rule'] = $data['pogo_rule'];
        $add_data['pogo_enable'] = $data['pogo_enable'];
        $add_data['pogo_create_id'] = $user_info->adm_id;
        $add_data['pogo_create_time'] = date('Y-m-d H:i:s');
        if ($pogo_id) {
            return ['code'=>500, 'msg'=>'此商品已添加，不可重复添加', 'data'=>''];
        } else {
            $pogo_id = DB::table('point_goods')->insertGetId($add_data);
            return ['code'=>200, 'msg'=>'添加成功', 'data'=>$pogo_id];
        }
    }

    /**
     * 积分设置-编辑积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function editPointGoods($user_info,$data)
    {
        $pogo_id = DB::table('point_goods')
            ->where('pogo_id', '<>', $data['pogo_id'])
            ->where('pogo_goo_type', $data['pogo_goo_type'])
            ->where('pogo_goo_id', $data['pogo_goo_id'])
            ->value('pogo_id');
        if ($pogo_id) {
            return ['code'=>500, 'msg'=>'已有此商品，请修改商品', 'data'=>''];
        }
        $add_data['pogo_goo_type'] = $data['pogo_goo_type'];
        $add_data['pogo_goo_id'] = $data['pogo_goo_id'];
        $add_data['pogo_goo_name'] = $data['pogo_goo_name'];
        $add_data['pogo_goo_point'] = $data['pogo_goo_point'];
        $add_data['pogo_rule'] = $data['pogo_rule'];
        $add_data['pogo_update_id'] = $user_info->adm_id;
        $add_data['pogo_update_time'] = date('Y-m-d H:i:s');
        
        $pogo_id = DB::table('point_goods')
            ->where('pogo_id',$data['pogo_id'])
            ->update($add_data);
        return ['code'=>200, 'msg'=>'修改成功', 'data'=>''];
    }

    /**
     * 积分设置-开启关闭积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function editState($user_info,$data)
    {
        $pogo_id = DB::table('point_goods')
            ->where('pogo_id', $data['pogo_id'])
            ->value('pogo_id');

        $add_data['pogo_enable'] = $data['pogo_enable'];
        $add_data['pogo_update_id'] = $user_info->adm_id;
        $add_data['pogo_update_time'] = date('Y-m-d H:i:s');
        if (!$pogo_id) {
            return ['code'=>500, 'msg'=>'未查询到此商品，请联系管理员', 'data'=>''];
        } else {
            $pogo_id = DB::table('point_goods')
                ->where('pogo_id',$data['pogo_id'])
                ->update($add_data);
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>''];
        }
    }

    /**
     * 积分设置-购买商品获取积分的商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function pointGoods($user_info,$request,$show_count)
    {
        $list_data = DB::table('point_goods')
            ->where('pogo_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['pogo_goo_type'])) {
                    $query->where('pogo_goo_type', $request['pogo_goo_type']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['pogo_goo_name'])) {
                    $query->where('pogo_goo_name', 'like', '%' . $request['pogo_goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['pogo_enable'])) {
                    $query->where('pogo_enable', $request['pogo_enable']);
                }
            })
            ->select('pogo_id', 'pogo_shop_id', 'pogo_goo_type', 'pogo_goo_name', 'pogo_goo_point', 'pogo_rule', 'pogo_enable', 'pogo_goo_id')
            ->orderBy('pogo_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $typeName = self::getType(true);//获取类型
            foreach ($list_items as $key => $value) {
                $list_items[$key]->pogo_goo_type_name = self::getTypeData($value->pogo_goo_type, $typeName);
            }
        }
        $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['pages']['total'] = $list_data->total();               //总数据个数
        $data['pages']['current_number'] = $show_count;        //一页显示多少个
        $data['list'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public static function getGoods($user_info, $search_data, $show_count = 10)
    {
        if ($search_data['type'] == 1) {
            // 服务列表
            $post['string'] = 'sepr_';
            $post['user_info'] = $user_info;
            $type = 3;
            $where_data = whereFunction($post,$type);
            $list_data = DB::table('service_project')
                ->whereIn($where_data['string'], $where_data['shop_id'])
                ->where('sepr_delete', 1)
                ->where('sepr_state', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['keywords'])) {
                        $query->where('sepr_name', 'like', '%' . $search_data['keywords'] . '%');
                    }
                })
                ->select('sepr_id as goo_id', 'sepr_name as goo_name')
                ->orderBy('sepr_id', 'desc')
                ->paginate($show_count);
        }
        if ($search_data['type'] == 2) {
            // 商品列表
            $post['string'] = 'goo_';
            $post['user_info'] = $user_info;
            $type = 3;
            $where_data = whereFunction($post,$type);
            $list_data = DB::table('goods')
                ->whereIn($where_data['string'], $where_data['shop_id'])
                ->where('goo_delete', 1)
                ->where('goo_state', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['keywords'])) {
                        $query->where('goo_name', 'like', '%' . $search_data['keywords'] . '%');
                    }
                })
                ->select('goo_id', 'goo_name', 'goo_bra_name', 'goo_cate_name', 'goo_unit')
                ->orderBy('goo_id', 'desc')
                ->paginate($show_count);
            if ($list_data) {
                foreach ($list_data as $key => $value) {
                    $list_data[$key]->goo_name = $value->goo_bra_name.$value->goo_cate_name.$value->goo_name.'('.$value->goo_unit.')';
                }
            }
        }
        if ($search_data['type'] == 3) {
            $post['string'] = 'vica_';
            $post['user_info'] = $user_info;
            $type = 3;
            $where_data = whereFunction($post,$type);
            // 会员卡列表
            $list_data = DB::table('vip_card')
                ->whereIn($where_data['string'], $where_data['shop_id'])
                ->where('vica_state', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['keywords'])) {
                        $query->where('vica_name', 'like', '%' . $search_data['keywords'] . '%');
                    }
                })
                ->select('vica_id as goo_id', 'vica_name as goo_name')
                ->orderBy('vica_id', 'desc')
                ->paginate($show_count);
        }
        $list_items = $list_data->items();
        if ($list_items) {
            
            $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
            $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data['pages']['total'] = $list_data->total();               //总数据个数
            $data['pages']['current_number'] = $show_count;        //一页显示多少个
            $data['list'] = $list_items;                        //返回数据
            return $data;
        } else {
            return [];
        }
    }

    // 商品类型
    public static function getType($type) {
        $data = [['type'=>1,'name'=>'服务'],['type'=>2,'name'=>'商品'],['type'=>3,'name'=>'会员卡']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param string $type 服务类型数据
     * @param string $typeName 服务类型数据
     * @retrun /multitype:array
     * @author dou 2023-05-31 031 上午 11:47:59
     * |---------------------------------------------------------------------------------
     */
    public static function getTypeData ( $type , $typeName ){
        $typeData = trim($type);
        $typeData = explode(',', $typeData);
        $return = [];
        foreach($typeData as $k => $v){
            $return[] = $typeName[$v]??'未定义';
        }
        $return = implode(',', $return);
        return $return;
    }

    /**
     * 签到积分设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function signinConfig($user_info,$data)
    {
        $sico_id = DB::table('sign_config')->where('sico_shop_id', $user_info->adm_shop_id)->value('sico_id');
        $add_data['sico_shop_id'] = $user_info->adm_shop_id;
        if (isset($data['sico_state'])) {
            $add_data['sico_state'] = $data['sico_state'];
        }
        if (isset($data['sico_type'])) {
            $add_data['sico_type'] = $data['sico_type'];
        }
        if (isset($data['sico_day_type'])) {
            $add_data['sico_day_type'] = $data['sico_day_type'];
        }
        if (isset($data['sico_day_num'])) {
            $add_data['sico_day_num'] = $data['sico_day_num'];
        }
        $add_data['sico_update_id'] = $user_info->adm_id;
        $add_data['sico_update_time'] = date('Y-m-d H:i:s');
        DB::beginTransaction();
        if ($sico_id) {
            $sico_id_res = DB::table('sign_config')->where('sico_id', $sico_id)->update($add_data);
            $flag = true;
            if(isset($data['day_data'])) {
                //$sql = [];
                $day_data = $data['day_data'];
                for ($i = 0; $i < 31; $i++) {
                    $add_sign_day_data[$i]['sidco_scid'] = $sico_id;
                    $add_sign_day_data[$i]['sidco_name'] = '';
                    $add_sign_day_data[$i]['sidco_type'] = $i + 1;
                    if ($i > 0) {
                        $add_sign_day_data[$i]['sidco_points'] = $day_data[$i] ?? 0;
                    } else {
                        $add_sign_day_data[$i]['sidco_points'] = $day_data[$i] ?? 1;
                    }
                    //                $sql[] = "UPDATE faster_sign_day_config SET sidco_points = '".$add_sign_day_data[$i]['sidco_points']."' where sidco_scid = '".$sico_id."' and sidco_type = '".$add_sign_day_data[$i]['sidco_type']."';";
                    $res = DB::table('sign_day_config')->where('sidco_scid', $sico_id)->where('sidco_type', $add_sign_day_data[$i]['sidco_type'])->update(['sidco_points' => $add_sign_day_data[$i]['sidco_points'], 'sidco_updatetime' => date("Y-m-d H:i:s")]);
                }
                //            $dayadd = DB::update(DB::raw(implode('', $sql)));
            }
            $dayadd = $flag;
        } else {
            $add_data['sico_create_id'] = $user_info->adm_id;
            $add_data['sico_create_time'] = date('Y-m-d H:i:s');
            $add_data['sico_start_time'] = date('Y-m-d');
            $sico_id = DB::table('sign_config')->insertGetId($add_data);
            if(isset($data['day_data'])) {
                $day_data = $data['day_data'];
                for ($i = 0; $i < 31; $i++) {
                    $add_sign_day_data[$i]['sidco_scid'] = $sico_id;
                    $add_sign_day_data[$i]['sidco_name'] = '';
                    $add_sign_day_data[$i]['sidco_type'] = $i + 1;
                    if ($i > 0) {
                        $add_sign_day_data[$i]['sidco_points'] = $day_data[$i] ?? 0;
                    } else {
                        $add_sign_day_data[$i]['sidco_points'] = $day_data[$i] ?? 1;
                    }
                }
                $dayadd = DB::table('sign_day_config')->insert($add_sign_day_data);
            }else{
                $dayadd = true;
            }
        }
        
        if($sico_id && $dayadd){
            DB::commit();
            return $sico_id;
        }else{
            DB::rollback();
            return false;
        }
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 数据名称
     * @param string $type 数据类型
     * @param string $day_data 天数数据
     * @retrun /multitype:array
     * @author dou 2023/9/15 17:45
     * |---------------------------------------------------------------------------------
    */
    public static function getSigninType ( $type , $day_data ){
        $data = [];
        //自定义
        $custom = [];
        for($i=1;$i<=31;$i++){
            $custom[$i] = "第".$i."天";
        }
        $data[1] = $custom;
        //按周
        $week = ['1'=>'星期一','2'=>'星期二','3'=>'星期三','4'=>'星期四','5'=>'星期五','6'=>'星期六','7'=>'星期日'];
        $data[2] = $week;
        //按月
        $month = [];
        for($i=1;$i<=31;$i++){
            $month[$i] = $i."号";
        }
        $data[3] = $month;
        $data = $data[$type];
        foreach($day_data as $k => $v){
            $day_data[$k]['sidco_name'] = $data[$v['sidco_type']];
        }
        return $day_data;
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取当月积分数据
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2023/9/18 18:59
     * |---------------------------------------------------------------------------------
    */
    public static function getSigninData ($user_info, $request){
        $now = date("Y-m-d");//获取当前天
        $sign_history = DB::table('sign_history')->where('sih_shop_id', $user_info->adm_shop_id)->where('sih_creact_id', $user_info->ussh_user_id)->where('sih_day', $now)->exists();
        if ($sign_history) {
            $state = 1;
        } else {
            $state = 2;
        }
        $mem_points = DB::table('member')->where('mem_id', $user_info->ussh_user_id)->value('mem_points');

        $find_sign = DB::table('sign_history')
            ->where('sih_shop_id', $user_info->adm_shop_id)
            ->where('sih_creact_id', $user_info->ussh_user_id)
            ->select('sih_num','sih_id', 'sih_day')
            ->orderBy('sih_num', 'desc')
            ->first();
        if ($find_sign) {
            $data['sih_num'] = $find_sign->sih_num;
        } else {
            $data['sih_num'] = 0;
        }
        $data['state'] = $state;
        $data['sign_state'] = DB::table('sign_config')
            ->where('sico_shop_id', $user_info->adm_shop_id)
            ->value('sico_state');
        $data['mem_points'] = $mem_points;
        $data['time'] = date("Y-m-d");
        if ($request['type'] == 1) {
            return ['code' => 200, 'msg' => '操作成功', 'data'=>$data];
        }
        // $day = date('t',time());//获取查询月天数
        // $month = date("Y-m",time());//查询月分
        if (!isset($request['month'])) {
            $request['month'] = date('Y-m');
        }
        $day = date('t',strtotime($request['month']));//获取查询月天数
        $month = date("Y-m",strtotime($request['month']));//查询月分
        $searchDay = date('Y-m-d', strtotime('-1 day'));//判定累计签到昨天是否签到
        //获取签到设置数据
        $data = DB::table('sign_config')->where('sico_shop_id', $user_info->adm_shop_id)->first();
        $data = CommonService::dataToArray($data);
        //获取签到对应天数数据
        $sign_day_config = DB::table('sign_day_config')->where('sidco_scid', $data['sico_id'])->where('sidco_type', '<=' ,$data['sico_day_num'])->pluck('sidco_points','sidco_type');
//        $sign_day_config = CommonService::dataToArray($sign_day_config);
//        $sign_day_config = array_column($sign_day_config, 'sidco_points','sidco_type');
        //获取签到历史数据
        $sign_history = DB::table('sign_history')->where('sih_shop_id', $user_info->adm_shop_id)->where('sih_creact_id', $user_info->ussh_user_id)->where('sih_month', $month)->pluck('sih_points','sih_day');
        $return = [];
        $k = 0;
        for($i=1;$i<=$day;$i++) {
            if ($i < 10) {
                $num = '0' . $i;
            } else {
                $num = $i;
            }
            $days = $month . '-' . $num;
            $return[$k]['day'] = $days;
            if($data['sico_start_time']>$days){
                $return[$k]['state'] = 3;
                $return[$k]['points'] = 0;
            }else {
                $points = $sign_history[$days]??false;
                if($points){
                    $return[$k]['state'] = 1;
                    $return[$k]['points'] = $points;
                }else {
                    $return[$k]['state'] = 2;
                    if ($days < $now) {
                        $return[$k]['state'] = 3;
                    }
                    if ($data['sico_type'] == 1) {
                        $sih_num = DB::table('sign_history')->where('sih_shop_id', $user_info->adm_shop_id)->where('sih_creact_id', $user_info->ussh_user_id)->where('sih_day', $searchDay)->value('sih_num');
                        if(!$sih_num){
                            $sih_num = 0;
                        }
                        $daynum = CommonService::getDiffDate($now, $days);
                        if($daynum<1){
                            $points = 0;
                        }else{
                            $daynum = $daynum + $sih_num;
                            if($daynum > $data['sico_day_num']){
                                $daynum = $data['sico_day_num'];
                            }
                            $points = self::getContinuousData($daynum, $data['sico_day_num'], $sign_day_config);

                        }
                    } elseif ($data['sico_type'] == 2) {
                        switch ($data['sico_day_type']) {
                            case 1:
                                $daynum = CommonService::getDiffDate($data['sico_start_time'], $days);
                                $points = self::getCustomData($daynum, $data['sico_day_num'], $sign_day_config);
                                break;
                            case 2:
                                $points = self::getWeekData($sign_day_config, $days);
                                break;
                            case 3:
                                $points = self::getMonthData($sign_day_config, $i);
                                break;
                            default:
                                return ['code' => 202, 'msg' => '数据异常', 'data' => []];
                        }
                    } else {
                        return ['code' => 201, 'msg' => '数据异常', 'data' => []];
                    }
                    $return[$k]['points'] = $points;
                }
            }
            $k++;
        }
        
        return ['code' => 200, 'msg' => '操作成功', 'data' => ['data'=>$return,'today'=>$state,'mem_points'=>$mem_points,'time'=>date("Y-m-d")]];
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取星期对应分数
     * @param string $sign_day_config 自定义分数数据
     * @param string $day 日期
     * @retrun /multitype:array
     * @author dou 2023/9/18 19:49
     * |---------------------------------------------------------------------------------
    */
    public static function getWeekData ( $sign_day_config , $day ){
        $week = date('w',strtotime($day));
        if($week<1){
            $week = 7;
        }
        return $sign_day_config[$week];
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取月对应数据
     * @param string $sign_day_config 自定义分数数据
     * @param string $day 对应天
     * @retrun /multitype:array
     * @author dou 2023/9/18 20:06
     * |---------------------------------------------------------------------------------
    */
    public static function getMonthData ( $sign_day_config , $day ){
        return $sign_day_config[$day];
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取自定义对应天数分数
     * @param string $sign_day_config 自定义分数数据
     * @param array $day 获取差值
     * @param array $daynum 这只天数
     * @retrun /multitype:array
     * @author dou 2023/9/18 17:56
     * |---------------------------------------------------------------------------------
     */
    public static function getCustomData ( $day , $daynum ,$sign_day_config ){
        $day = $day%$daynum;
        if($day<1){
            $day = $daynum;
        }
        return $sign_day_config[$day];
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取连续签到分数
     * @param string $sign_day_config 自定义分数数据
     * @param array $day 获取差值
     * @param array $daynum 这只天数
     * @retrun /multitype:array
     * @author dou 2023/9/19 9:25
     * |---------------------------------------------------------------------------------
    */
    public static function getContinuousData ( $day , $daynum , $sign_day_config ){
        if($day>$daynum){
            $day = $daynum;
        }
        return $sign_day_config[$day];
    }

    /**
     * 新增签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $data      [description]
     */
    public static function addSignGoods($user_info,$data)
    {
        $sigo_id = DB::table('sign_goods')
            ->where('sigo_shop_id', $user_info->adm_shop_id)
            ->where('sigo_goo_type', $data['sigo_goo_type'])
            ->wherein('sigo_state', [1,2])
            ->where('sigo_goo_id', $data['sigo_goo_id'])
            ->value('sigo_id');
        $add_data['sigo_shop_id'] = $user_info->adm_shop_id;
        
        $add_data['sigo_goo_type'] = $data['sigo_goo_type'];
        $add_data['sigo_goo_id'] = $data['sigo_goo_id'];
        $add_data['sigo_goo_name'] = $data['sigo_goo_name'];
        $add_data['sigo_sign_days'] = $data['sigo_sign_days'];
        $add_data['sigo_sign_type'] = $data['sigo_sign_type'];
        $add_data['sigo_sign_num'] = $data['sigo_sign_num'];
        $add_data['sigo_start_time'] = $data['sigo_start_time'];
        $add_data['sigo_end_time'] = $data['sigo_end_time'].' 23:59:59';
        if (time() < strtotime($data['sigo_start_time'])) {
            $data['sigo_state'] = 1;//未开启
        } elseif (strtotime($data['sigo_start_time'])< time() && time() < strtotime($data['sigo_end_time'])) {
            $data['sigo_state'] = 2;//已开启
        } elseif (time() > strtotime($data['sigo_end_time'])) {
            return ['code'=>500, 'msg'=>'结束时间错误', 'data'=>''];
        }
        $day = intval((strtotime($add_data['sigo_end_time']) - strtotime($add_data['sigo_start_time']))/(24*60*60))+1;
        if ($day < $data['sigo_sign_days']) {
            return ['code'=>500, 'msg'=>'活动时间天数不能小于签到天数', 'data'=>''];
        }
        $add_data['sigo_state'] = $data['sigo_state'];
        $add_data['sigo_create_id'] = $user_info->adm_id;
        $add_data['sigo_create_time'] = date('Y-m-d H:i:s');
        if ($sigo_id) {
            return ['code'=>500, 'msg'=>'此商品已添加，不可重复添加', 'data'=>''];
        } else {
            $sigo_id = DB::table('sign_goods')->insertGetId($add_data);
            return ['code'=>200, 'msg'=>'添加成功', 'data'=>$sigo_id];
        }
    }

    /**
     * 编辑签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $data      [description]
     */
    public static function editSignGoods($user_info,$data)
    {
        if (time() < strtotime($data['sigo_start_time'])) {
            $data['sigo_state'] = 1;//未开启
        } elseif (strtotime($data['sigo_start_time'])< time() && time() < strtotime($data['sigo_end_time'])) {
            $data['sigo_state'] = 2;//已开启
        } elseif (time() > strtotime($data['sigo_end_time'])) {
            return ['code'=>500, 'msg'=>'结束时间错误', 'data'=>''];
        }
        $add_data['sigo_state'] = $data['sigo_state'];
        $add_data['sigo_sign_days'] = $data['sigo_sign_days'];
        $add_data['sigo_sign_num'] = $data['sigo_sign_num'];
        $add_data['sigo_start_time'] = $data['sigo_start_time'];
        $add_data['sigo_end_time'] = $data['sigo_end_time'].' 23:59:59';
        $add_data['sigo_update_id'] = $user_info->adm_id;
        $add_data['sigo_update_time'] = date('Y-m-d H:i:s');
        $day = intval((strtotime($add_data['sigo_end_time']) - strtotime($add_data['sigo_start_time']))/(24*60*60))+1;
        if ($day < $data['sigo_sign_days']) {
            return ['code'=>500, 'msg'=>'活动时间天数不能小于签到天数', 'data'=>''];
        }
        $sigo_id = DB::table('sign_goods')
            ->where('sigo_id', $data['sigo_id'])
            ->update($add_data);
        if ($sigo_id) {
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'修改失败', 'data'=>''];
        }
    }

    /**
     * 签到礼品列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $user_info  [description]
     * @param  [type]           $request    [description]
     * @param  [type]           $show_count [description]
     * @return [type]                       [description]
     */
    public static function signGoods($user_info,$request,$show_count)
    {
        $list_data = DB::table('sign_goods')
            ->where('sigo_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['sigo_goo_type'])) {
                    $query->where('sigo_goo_type', $request['sigo_goo_type']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['sigo_goo_name'])) {
                    $query->where('sigo_goo_name', 'like', '%' . $request['sigo_goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['sigo_state'])) {
                    $query->where('sigo_state', $request['sigo_state']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['sigo_sign_type'])) {
                    $query->where('sigo_sign_type', $request['sigo_sign_type']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['sigo_sign_num'])) {
                    $query->where('sigo_sign_num', $request['sigo_sign_num']);
                }
            })
            ->where(function ($query) use ($request) { //活动时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($request['sigo_start_time']) && !empty($request['sigo_end_time'])) {
                    $query->where('sigo_end_time', '>=', $request['sigo_start_time'])
                        ->where('sigo_start_time', '<=', $request['sigo_end_time']);
                } else {
                    // 如果选择开始时间
                    if (!empty($request['sigo_start_time'])) {
                        $query->where('sigo_start_time', '>=', $request['sigo_start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($request['sigo_end_time'])) {
                            $query->where('sigo_end_time', '<=', $request['sigo_end_time'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('sigo_id', 'sigo_shop_id', 'sigo_goo_type', 'sigo_goo_name', 'sigo_sign_days', 'sigo_sign_type', 'sigo_state', 'sigo_goo_id', 'sigo_start_time', 'sigo_end_time', 'sigo_create_time', 'sigo_sign_num')
            ->orderBy('sigo_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $typeName = self::getType(true);//获取类型
            $state = self::getSignState(true);
            $way = self::getSignWay(true);
            $num = self::getSignNum(true);
            foreach ($list_items as $key => $value) {
                if (date('Y-m-d H:i:s') >= $value->sigo_start_time && $value->sigo_state == 1) {
                    $value->sigo_state = 2;
                    DB::table('sign_goods')->where('sigo_id', $list_items[$key]->sigo_id)->update(['sigo_state'=>2]);
                }
                if (date('Y-m-d  H:i:s') > $value->sigo_end_time && $value->sigo_state == 2) {
                    $value->sigo_state = 3;
                    DB::table('sign_goods')->where('sigo_id', $list_items[$key]->sigo_id)->update(['sigo_state'=>3]);
                }
                $list_items[$key]->sigo_goo_type_name = self::getTypeData($value->sigo_goo_type, $typeName);
                $list_items[$key]->sigo_state_name = self::getTypeData($value->sigo_state, $state);
                $list_items[$key]->sigo_sign_type_name = self::getTypeData($value->sigo_sign_type, $way);
                $list_items[$key]->sigo_sign_num_name = self::getTypeData($value->sigo_sign_num, $num);
            }
        }
        $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['pages']['total'] = $list_data->total();               //总数据个数
        $data['pages']['current_number'] = $show_count;        //一页显示多少个
        $data['list'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 签到设置-终止签到礼品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function signState($user_info,$data)
    {
        $sigo_id = DB::table('sign_goods')
            ->where('sigo_id', $data['sigo_id'])
            ->value('sigo_id');

        $add_data['sigo_state'] = 4;
        $add_data['sigo_update_id'] = $user_info->adm_id;
        $add_data['sigo_update_time'] = date('Y-m-d H:i:s');
        if (!$sigo_id) {
            return ['code'=>500, 'msg'=>'未查询到此商品，请联系管理员', 'data'=>''];
        } else {
            if ($data['sigo_state'] == 1) {
                $state = '开启';
            } else {
                $state = '关闭';
            }
            $sigo_id = DB::table('sign_goods')
                ->where('sigo_id',$data['sigo_id'])
                ->update($add_data);
            return ['code'=>200, 'msg'=>$state.'成功', 'data'=>''];
        }
    }

    // 签到礼品状态
    public static function getSignState($type) {
        $data = [['type'=>1,'name'=>'未生效'],['type'=>2,'name'=>'生效中'],['type'=>3,'name'=>'已失效'],['type'=>4,'name'=>'已终止']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    // 签到礼品方式
    public static function getSignWay($type) {
        $data = [['type'=>1,'name'=>'累计'],['type'=>2,'name'=>'连续']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    // 签到礼品次数
    public static function getSignNum($type) {
        $data = [['type'=>1,'name'=>'单次'],['type'=>2,'name'=>'多次']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**
     * 分享设置
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function shareConfig($user_info,$data)
    {
        $shco_id = DB::table('share_config')->where('shco_shop_id', $user_info->adm_shop_id)->value('shco_id');
        $add_data['shco_shop_id'] = $user_info->adm_shop_id;
        if (isset($data['shco_first_point'])) {
            $add_data['shco_first_point'] = $data['shco_first_point'];
        }
        if (isset($data['shco_proportion'])) {
            $add_data['shco_proportion'] = $data['shco_proportion'];
        }
        if (isset($data['shco_divide_point'])) {
            $add_data['shco_divide_point'] = $data['shco_divide_point'];
        }
        if (isset($data['shco_divide_proportion'])) {
            $add_data['shco_divide_proportion'] = $data['shco_divide_proportion'];
        }
        $add_data['shco_update_id'] = $user_info->adm_id;
        $add_data['shco_update_time'] = date('Y-m-d H:i:s');
        if ($shco_id) {
            $poco_update_res = DB::table('share_config')->where('shco_id', $shco_id)->update($add_data);
        } else {
            $add_data['shco_create_id'] = $user_info->adm_id;
            $add_data['shco_create_time'] = date('Y-m-d H:i:s');
            $shco_id = DB::table('share_config')->insertGetId($add_data);
        }
        return $shco_id;
    }

    /**
     * 新增积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $data      [description]
     */
    public static function addPointGift($user_info,$data)
    {
        $pogg_id = DB::table('point_gift_goods')
            ->where('pogg_shop_id', $user_info->adm_shop_id)
            ->where('pogg_goo_type', $data['pogg_goo_type'])
            ->where(function ($query) use ($data) {
                if (!empty($data['pogg_goo_id'])) {
                    $query->where('pogg_goo_id', $data['pogg_goo_id']);
                } else {
                    $query->where('pogg_goo_name', $data['pogg_goo_name']);
                }
            })
            ->value('pogg_id');
        $add_data['pogg_shop_id'] = $user_info->adm_shop_id;
        $add_data['pogg_goo_type'] = $data['pogg_goo_type'];
        $goo_type_name = self::getPointGift(true);
        $pogg_goo_type_name = self::getTypeData($data['pogg_goo_type'],$goo_type_name);
        $add_data['pogg_goo_type_name'] = $pogg_goo_type_name;
        $add_data['pogg_goo_id'] = $data['pogg_goo_id'];
        $add_data['pogg_goo_name'] = $data['pogg_goo_name'];
        $add_data['pogg_goo_price'] = $data['pogg_goo_price']*100;
        $add_data['pogg_goo_num'] = $data['pogg_goo_num'];
        if (empty($data['pogg_goo_num'])) {//不填写数量 = 不限数量
            $add_data['pogg_goo_limitation'] = 2;//不限
        } else {
            $add_data['pogg_goo_limitation'] = 1;
        }
        if (!empty($data['pogg_activity_properties'])) {
            $pogg_goo_limitation = explode(',', $data['pogg_activity_properties']);
            if (in_array(2,$pogg_goo_limitation)) {
                if (empty($data['pogg_start_time']) || empty($data['pogg_end_time'])) {
                    return ['code'=>500, 'msg'=>'请选择活动时间', 'data'=>''];
                }
                $add_data['pogg_start_time'] = $data['pogg_start_time'];
                $add_data['pogg_end_time'] = date('Y-m-d', strtotime("+1 day", strtotime($data['pogg_end_time'])));
                $add_data['pogg_limited_time'] = 1;
            }
        }
        $add_data['pogg_exchange_person'] = $data['pogg_exchange_person'];
        $add_data['pogg_exchange_day'] = $data['pogg_exchange_day'];
        $add_data['pogg_goo_point'] = $data['pogg_goo_point'];
        $add_data['pogg_goo_money'] = $data['pogg_goo_money']*100;
        $add_data['pogg_activity_properties'] = $data['pogg_activity_properties'];//活动属性
        $add_data['pogg_state'] = $data['pogg_state'];
        $add_data['pogg_create_id'] = $user_info->adm_id;
        $add_data['pogg_create_time'] = date('Y-m-d H:i:s');
        $add_data['pogg_pic'] = $data['pogg_pic'];
        $add_data['pogg_detail_pic'] = $data['pogg_detail_pic'];
        if ($pogg_id) {
            return ['code'=>500, 'msg'=>'此商品已添加，不可重复添加', 'data'=>''];
        } else {
            $pogg_id = DB::table('point_gift_goods')->insertGetId($add_data);
            return ['code'=>200, 'msg'=>'添加成功', 'data'=>$pogg_id];
        }
    }

    // 积分商品类型
    public static function getPointGift($type) {
        $data = [['type'=>1,'name'=>'服务'],['type'=>2,'name'=>'商品'],['type'=>3,'name'=>'会员卡']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    // 活动属性
    public static function getProperties($type) {
        $data = [/*['type'=>1,'name'=>'首页推荐'],*/['type'=>2,'name'=>'限时兑换']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**
     * 积分设置-积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-14
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function index($user_info,$request,$show_count)
    {
        $list_data = DB::table('point_gift_goods')
            ->where('pogg_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['pogg_goo_type'])) {
                    $query->where('pogg_goo_type', $request['pogg_goo_type']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['pogg_goo_name'])) {
                    $query->where('pogg_goo_name', 'like', '%' . $request['pogg_goo_name'] . '%');
                }
            })
            ->where(function ($query) use ($request) { //活动时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($request['pogg_start_time']) && !empty($request['pogg_end_time'])) {
                    $query->where('pogg_end_time', '>=', $request['pogg_start_time'])
                        ->where('pogg_start_time', '<=', $request['pogg_end_time']);
                } else {
                    // 如果选择开始时间
                    if (!empty($request['pogg_start_time'])) {
                        $query->where('pogg_end_time', '>=', $request['pogg_start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($request['pogg_end_time'])) {
                            $query->where('pogg_start_time', '<=', $request['pogg_end_time'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['pogg_state'])) {
                    $query->where('pogg_state', $request['pogg_state']);
                }
            })
            // ->select('pogg_id', 'pogg_shop_id', 'pogg_goo_type', 'pogg_goo_type_name', 'pogg_goo_name', 'pogg_goo_price', 'pogg_goo_num', 'pogo_goo_id', 'pogg_goo_limitation', 'pogg_exchange_person')
            ->orderBy('pogg_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $data['pages']['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['pages']['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['pages']['total'] = $list_data->total();               //总数据个数
        $data['pages']['current_number'] = $show_count;        //一页显示多少个
        $data['list'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 新增积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $data      [description]
     */
    public static function editPointGift($user_info,$data)
    {
        $pogg_id = DB::table('point_gift_goods')
            ->where('pogg_shop_id', $user_info->adm_shop_id)
            ->where('pogg_id', '<>', $data['pogg_id'])
            ->where('pogg_goo_type', $data['pogg_goo_type'])
            ->where(function ($query) use ($data) {
                if (!empty($data['pogg_goo_id'])) {
                    $query->where('pogg_goo_id', $data['pogg_goo_id']);
                } else {
                    $query->where('pogg_goo_name', $data['pogg_goo_name']);
                }
            })
            ->value('pogg_id');
        if ($pogg_id) {
            return ['code'=>500, 'msg'=>'此积分商品已存在', 'data'=>''];
        }
        $add_data['pogg_goo_type'] = $data['pogg_goo_type'];
        $goo_type_name = self::getPointGift(true);
        $pogg_goo_type_name = self::getTypeData($data['pogg_goo_type'],$goo_type_name);
        $add_data['pogg_goo_type_name'] = $pogg_goo_type_name;
        $add_data['pogg_goo_id'] = $data['pogg_goo_id'];
        $add_data['pogg_goo_name'] = $data['pogg_goo_name'];
        $add_data['pogg_goo_price'] = $data['pogg_goo_price']*100;
        $add_data['pogg_goo_num'] = $data['pogg_goo_num'];
        if (empty($data['pogg_goo_num'])) {//不填写数量 = 不限数量
            $add_data['pogg_goo_limitation'] = 2;//不限
        } else {
            $add_data['pogg_goo_limitation'] = 1;
        }
        if (!empty($data['pogg_activity_properties'])) {
            $pogg_goo_limitation = explode(',', $data['pogg_activity_properties']);
            if (in_array(2,$pogg_goo_limitation)) {
                if (empty($data['pogg_start_time']) || empty($data['pogg_end_time'])) {
                    return ['code'=>500, 'msg'=>'请选择活动时间', 'data'=>''];
                }
                $add_data['pogg_start_time'] = $data['pogg_start_time'];
                $add_data['pogg_end_time'] = date('Y-m-d', strtotime("+1 day", strtotime($data['pogg_end_time'])));
                $add_data['pogg_limited_time'] = 1;
            } else {
                $add_data['pogg_start_time'] = '';
                $add_data['pogg_end_time'] = '';
                $add_data['pogg_limited_time'] = 2;
            }
        } else {
            $add_data['pogg_start_time'] = '';
            $add_data['pogg_end_time'] = '';
            $add_data['pogg_limited_time'] = 2;
        }
        $add_data['pogg_exchange_person'] = $data['pogg_exchange_person'];
        $add_data['pogg_exchange_day'] = $data['pogg_exchange_day'];
        $add_data['pogg_goo_point'] = $data['pogg_goo_point'];
        $add_data['pogg_goo_money'] = $data['pogg_goo_money']*100;
        $add_data['pogg_activity_properties'] = $data['pogg_activity_properties'];//活动属性
        $add_data['pogg_update_id'] = $user_info->adm_id;
        $add_data['pogg_update_time'] = date('Y-m-d H:i:s');
        $add_data['pogg_pic'] = $data['pogg_pic'];
        $add_data['pogg_detail_pic'] = $data['pogg_detail_pic'];
        $update_res = DB::table('point_gift_goods')->where('pogg_id', $data['pogg_id'])->update($add_data);
        if ($update_res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>''];
        }
    }

    /**
     * 开启关闭积分商品
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-11
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public static function poggState($user_info,$data)
    {
        $pogg_id = DB::table('point_gift_goods')
            ->where('pogg_id', $data['pogg_id'])
            ->value('pogg_id');

        $add_data['pogg_state'] = $data['pogg_state'];
        $add_data['pogg_update_id'] = $user_info->adm_id;
        $add_data['pogg_update_time'] = date('Y-m-d H:i:s');
        if (!$pogg_id) {
            return ['code'=>500, 'msg'=>'未查询到此商品，请联系管理员', 'data'=>''];
        } else {
            $pogg_id = DB::table('point_gift_goods')
                ->where('pogg_id',$data['pogg_id'])
                ->update($add_data);
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>''];
        }
    }

    // 添加积分明细
    public static function addPointDetail($data)
    {
        $add_point_res = DB::table('point_detail')->insertGetId($data);
        if (!isset($data['pode_state']) || $data['pode_state'] != 2) {
            self::memPoint($data['pode_mem_id'], $data['pode_points']);
        }
        return $add_point_res;
    }

    // 会员加积分
    public static function memPoint($mem_id,$point)
    {
        $mem_points = DB::table('member')
            ->where('mem_id', $mem_id)
            ->value('mem_points');
        $update_data['mem_points'] = $mem_points + $point;
        $update_res = DB::table('member')->where('mem_id', $mem_id)->update($update_data);
    }

    /**
     * 签到
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-20
     * @param  [type]           $mem_id [description]
     * @param  [type]           $point  [description]
     * @return [type]                   [description]
     */
    public static function sign($user_info)
    {
        // $today = '2023-09-07';
        $today = date('Y-m-d');
        $yesterday = date('Y-m-d',strtotime('-1 day',strtotime($today)));
        //获取签到设置数据
        $data = DB::table('sign_config')->where('sico_shop_id', $user_info->adm_shop_id)->first();
        $data = CommonService::dataToArray($data);
        if ($data) {
            if ($data['sico_state'] != 1) {
                return ['code'=>500, 'msg'=>'签到未开启，改天再来吧！', 'data'=>''];
            }
        }
        //获取签到对应天数数据
        $sign_day_config = DB::table('sign_day_config')->where('sidco_scid', $data['sico_id'])->where('sidco_type', '<=' ,$data['sico_day_num'])->pluck('sidco_points','sidco_type');
        //获取签到历史数据
        $sign_today = DB::table('sign_history')->where('sih_shop_id', $user_info->adm_shop_id)->where('sih_creact_id', $user_info->ussh_user_id)->where('sih_day', $today)->pluck('sih_points','sih_day');
        $sign_today = CommonService::dataToArray($sign_today);
        $sign_yesterday = DB::table('sign_history')->where('sih_shop_id', $user_info->adm_shop_id)->where('sih_creact_id', $user_info->ussh_user_id)->where('sih_day', $yesterday)->pluck('sih_num','sih_day');
        $sign_yesterday = CommonService::dataToArray($sign_yesterday);
        $add_data['sih_shop_id'] = $user_info->adm_shop_id;
        $add_data['sih_creact_id'] = $user_info->ussh_user_id;
        $add_data['sih_month'] = date('Y-m');
        $add_data['sih_day'] = $today;
        $add_data['sih_addtime'] = date('Y-m-d H:i:s');
        
        if (!empty($sign_today)) {
            return ['code'=>500, 'msg'=>'今天已签到，明天再来吧！', 'data'=>''];
        }
        if ($data['sico_type'] == 1) {//签到类型  1 连续签到2周期签到
            if (empty($sign_yesterday)) {
                $add_data['sih_points'] = $sign_day_config[1];
                $add_data['sih_num'] = 1;
            } else {
                $add_data['sih_points'] = $sign_day_config[$sign_yesterday[$yesterday] + 1];
                if ($sign_day_config[$sign_yesterday[$yesterday] + 1] == 0) {
                    $add_data['sih_points'] = $sign_day_config[$sign_yesterday[$yesterday]];
                }
                $add_data['sih_num'] = $sign_yesterday[$yesterday] + 1;
            }
        } elseif ($data['sico_type'] == 2) {
            switch ($data['sico_day_type']) {
                case 1:
                    $daynum = CommonService::getDiffDate($data['sico_start_time'], $today);
                    $points = self::getCustomData($daynum, $data['sico_day_num'], $sign_day_config);
                    break;
                case 2:
                    $points = self::getWeekData($sign_day_config, $today);
                    break;
                case 3:
                    $points = self::getMonthData($sign_day_config, date('d'));
                    break;
                default:
                    return ['code' => 202, 'msg' => '数据异常', 'data' => []];
            }
            $add_data['sih_points'] = $points;
            if (empty($sign_yesterday)) {
                $add_data['sih_num'] = 1;
            } else {
                $add_data['sih_num'] = $sign_yesterday[$yesterday] + 1;
            }
        } else {
            return ['code' => 201, 'msg' => '数据异常', 'data' => []];
        }
        $add_data_res = DB::table('sign_history')->insertGetId($add_data);
        $add_goo_point['pode_shop_id'] = $user_info->adm_shop_id;
        $add_goo_point['pode_mem_id'] = $user_info->ussh_user_id;
        $add_goo_point['pode_type'] = 1;
        $add_goo_point['pode_name'] = '签到送积分';
        $add_goo_point['pode_points'] = intval($add_data['sih_points']);
        $add_goo_point['pode_year_month'] = date('Y-m');
        $add_goo_point['pode_create_time'] = date('Y-m-d H:i:s');
        $add_goo_point['pode_create_id'] = 0;
        $add_goo_point['pode_soure'] = 2;
        $add_goo_point['pode_add_type'] = 13;
        $add_goo_point['pode_ord_id'] = 0;
        $add_goo_point_res = self::addPointDetail($add_goo_point);

        if (!$add_data_res) {
            return ['code'=>500, 'msg'=>'签到失败', 'data'=>''];
        } else {
            return ['code'=>200, 'msg'=>'签到成功', 'data'=>''];
        }
    }
}
