<?php

/**
 * 演示服务
 *
 * @author lixiaolin
 * @Date: 2021/8/17
 * @Time: 下午17:33
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Log;

class MeritPayService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
//        $this->modelMain = new Pt();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $where = [];
        if ($param['type']) {
            $where[] = ['type', '=', $param['type']];
        }

        $count = $this->modelMain
            ->where($where)
            ->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('id', 'ASC')
                ->offset($offset)
                ->limit($pageSize)
                ->get();
        } else {
            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('id', 'ASC')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;

        return $result;
    }

    public function formatPageContent($token, $priID, $data)
    {


        return $data;
    }

    public static function getInvoiceType()
    {
        return [1 => "暂无", 2 => "速电", 5 => "蓝城", 6 => "个人"];
    }

    /**
     * @param int $id
     *
     * @param int $enable
     * @return mixed
     */
    public function setEnable(int $id, $enable = 1)
    {
        return $this->modelMain->where('id', $id)
            ->update(['enabled' => $enable]);
    }


    public static function getFieldsById($id, $fields = '*'){
    	$platForm = Pt::where('id', $id)->select($fields)->first();

    	return $platForm;
    }
}
