<?php

/**
 * 演示服务
 *
 * @author lixiaolin
 * @Date: 2021/8/17
 * @Time: 下午17:33
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Inc\CacheInc;
use App\Models\MeritPayOptions;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class MeritPayOptionsService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new MeritPayOptions();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $where = [];
        if (!empty($param['type'])) {
            $where[] = ['merit_type', '=', $param['type']];
        }
        if (!empty($param['keywords'])) {
            $where[] = ['merit_name', 'like',  '%'.$param['keywords'].'%'];
        }

        $count = $this->modelMain
            ->where($where)
            ->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('id', 'ASC')
                ->offset($offset)
                ->limit($pageSize)
                ->get();
        } else {
            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('id', 'ASC')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;

        return $result;
    }

    /**
     * @param int $id
     *
     * @param int $enable
     * @return mixed
     */
    public function setEnable(int $id, $enable = 1)
    {
        return $this->modelMain->where('id', $id)
            ->update(['enabled' => $enable]);
    }


    public static function getFieldsById($id, $fields = '*'){
        return MeritPayOptions::where('id', $id)
            ->select($fields)
            ->first();
    }

    public static function getPartsMerits($meritName, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return MeritPayOptions::where('merit_name', $meritName)
            ->where('shop_id', $shopID)
            ->where('merit_type', 1)
            ->where('enabled', 1)
            ->get();
    }

    public static function getTecMerits($meritName, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return MeritPayOptions::where('merit_name', $meritName)
            ->where('shop_id', $shopID)
            ->where('merit_type', 2)
            ->where('enabled', 1)
            ->get();
    }

    public static function getOtherMerits($meritName, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return MeritPayOptions::where('merit_name', $meritName)
            ->where('shop_id', $shopID)
            ->where('merit_type', 3)
            ->where('enabled', 1)
            ->get();
    }

    /**
     * 获取同类型 唯一绩效办法名称
     * @param $meritName
     * @param int $type
     * @param int $shopID
     * @return mixed
     */
    public static function getMeritNames($meritName , $type = 1, $shopID = 0) {
        return MeritPayOptions::where('merit_name', 'like', '%'.$meritName.'%')
            ->where('shop_id', $shopID)
            ->where('merit_type', $type)
            ->where('enabled', 1)
            ->select('merit_name')
            ->distinct()
            ->get();
    }

    /**
     * 获取某个职称
     *
     * @param int $ID       获取ID值
     * @param int $shopID   门店ID
     * @param int $refresh  强制读库
     *
     * @return mixed
     */
    public static function getByID(int $ID,  $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }

        return MeritPayOptions::where('id', $ID)
            ->where('shop_id', $shopID)
            ->where('enabled', 1)
            ->first();
    }
}
