<?php

namespace App\Services\Finance;

use App\Http\Controllers\Common\CommonController;
use Illuminate\Database\Eloquent\Model;
use App\Models\Finance\WashPerformance;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Finance\WashPerformanceValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Models\Api\Export;

// 业绩明细
class WashPerformanceService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WashPerformance();
        $this->mainValidator = new WashPerformanceValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchWork($user_info, $search_data, $show_count = 10)
    {
        $list_data = DB::table('wash_performance_work as pewo')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'pewo.pewo_goo_id')
            ->leftJoin('work_client as wc', 'pewo.pewo_wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('work_order as wor', 'pewo.pewo_wor_id', '=', 'wor.wor_id')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'wor.wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_wor_number'])) {
                    $query->where('pewo_wor_number', 'like', '%' . $search_data['pewo_wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_ord_order_number'])) {
                    $query->where('pewo_ord_order_number', 'like', '%' . $search_data['pewo_ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//施工项目id
                if (!empty($search_data['pewo_sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['pewo_sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_id', 'pewo_wor_id', 'pewo_wor_number', 'pewo_ord_order_number', 'pewo_service_adm_id', 'pewo_service_adm_name', 'pewo_service_time', 'pewo_sepr_name', 'pewo_goo_name', 'pewo_goo_goods_encode', 'pewo_car_vehicle_type','pewo_car_vin', 'pewo_car_brand_series', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price', 'goo_bra_name', 'goo_guarantee', 'wocl_car_num', 'pewo_create_time', 'ord_order_price', 'wocl_car_brand_series','wotp_service_end_time')
            ->orderBy('pewo_id', 'desc')
            ->groupBy('pewo_wor_number')
            ->groupBy('wotp_wor_id')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $pewo_wor_id = array_column($list_items, 'pewo_wor_id');
        $new_data = DB::table('wash_performance_work')
            ->whereIn('pewo_wor_id', $pewo_wor_id)
            ->select('pewo_wor_id', 'pewo_performance_total_price')
            ->get()->toArray();
        $new_list = [];
        foreach ($new_data as $key => $value) {
            if (isset($new_list[$value->pewo_wor_id])) {
                $new_list[$value->pewo_wor_id]['pewo_performance_total_price'] += $value->pewo_performance_total_price;
            } else {
                $new_list[$value->pewo_wor_id]['pewo_performance_total_price'] = $value->pewo_performance_total_price;
            }
        }
        foreach ($list_items as $key => $value) {
            $sepr_data = DB::table('work_good as wogo')
                ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'wogo.wogo_goo_id')
                ->where('wogo_wor_id', $value->pewo_wor_id)
                ->where('wogo_goo_type', 2)
                ->select('sepr_name', 'wogo_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                ->get()->toArray();
            $goods_data = DB::table('goods as g')
                ->leftJoin('work_good as wogo', 'wogo.wogo_goo_id', '=', 'g.goo_id')
                ->where('wogo_wor_id', $value->pewo_wor_id)
                ->select('goo_name', 'wogo_new_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                ->get()->toArray();

            if ($sepr_data) {
                $list_items[$key]->pewo_sepr_name = $sepr_data;
            } else {
                $list_items[$key]->pewo_sepr_name = [];
            }
            if ($goods_data) {
                foreach ($goods_data as $key1 => $value1) {
                    $goods_data[$key1]->wogo_new_goo_amount = $value1->wogo_new_goo_amount.$value1->wogo_goo_unit;
                }
                $list_items[$key]->pewo_goo_name = $goods_data;
            } else {
                $list_items[$key]->pewo_goo_name = [];
            }
            $list_items[$key]->pewo_performance_total_price = $new_list[$value->pewo_wor_id]['pewo_performance_total_price'];
            $find_adm_data = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $value->pewo_wor_id)
                ->select('wotp_service_adm_id', 'wotp_service_adm_name')
                ->get()->toArray();
            $find_adm_lead = DB::table('work_order')
                ->where('wor_id', $value->pewo_wor_id)
                ->value('wor_service_adm_id');
            $number = '';
            foreach ($find_adm_data as $key1 => $value1) {
                if ($value1->wotp_service_adm_id == $find_adm_lead) {
                    $list_items[$key]->adm_name_leader = $value1->wotp_service_adm_name;
                } else {
                    if (empty($number)) {
                        $number = $value1->wotp_service_adm_name;
                    } else {
                        $number = $number.' '.$value1->wotp_service_adm_name;
                    }
                }
            }
            $list_items[$key]->adm_name_numbers = $number;
        }

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 根据条件搜索数据内容
     *按技师分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchTechnician($user_info, $search_data, $show_count = 10)
    {
        // 查询技师数据
        $list_data = DB::table('wash_performance_work as pewo')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'pewo.pewo_service_adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'asr.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'b.grle_grpr_id', '=', 'c.grpr_id')
            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->where('asr.shop_id', $user_info->adm_shop_id)
            // ->where(function ($query) use ($search_data) {
            //     if (!empty($search_data['pewo_wor_number'])) {
            //         $query->where('pewo_wor_number', 'like', '%' . $search_data['pewo_wor_number'] . '%');
            //     }
            // })
            // ->where(function ($query) use ($search_data) {
            //     if (!empty($search_data['pewo_ord_order_number'])) {
            //         $query->where('pewo_ord_order_number', 'like', '%' . $search_data['pewo_ord_order_number'] . '%');
            //     }
            // })
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//服务技师电话
                if (!empty($search_data['pewo_service_adm_name'])) {
                    $query->where('pewo_service_adm_name', $search_data['pewo_service_adm_name']);
                }
            })
            ->where(function ($query) use ($search_data) {//施工项目id
                if (!empty($search_data['pewo_sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['pewo_sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_service_adm_id')
            ->orderBy('pewo_id', 'asc')
            ->groupBy('pewo_service_adm_id')
            ->paginate($show_count);

        // 查询出小于当前结束时间的所有商品id相关数据
        $list_service_items = $list_data->items();
        $service_adm_id = array_column($list_service_items, 'pewo_service_adm_id');//技师id

        // 查询技师信息
        $find_adm = DB::table('admin as a')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'a.adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'asr.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'b.grle_grpr_id', '=', 'c.grpr_id')
            ->whereIn('asr.adm_id', $service_adm_id)
            ->where('asr.shop_id', $user_info->adm_shop_id)
            ->select('a.adm_id', 'adm_name', 'adm_phone', 'grle_name', 'grpr_name')
            ->get()->toArray();

        $find_adm = array_column($find_adm, null, 'adm_id');
        // 查询技师相关的业绩数据
        $list_detail_data = DB::table('wash_performance_work as pewo')
            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->whereIn('pewo_service_adm_id', $service_adm_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_wor_number'])) {
                    $query->where('pewo_wor_number', 'like', '%' . $search_data['pewo_wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_ord_order_number'])) {
                    $query->where('pewo_ord_order_number', 'like', '%' . $search_data['pewo_ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//施工项目id
                if (!empty($search_data['pewo_sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['pewo_sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_id', 'pewo_wor_id', 'pewo_service_adm_id', 'pewo_service_adm_name', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price', 'pewo_create_time','wotp_service_end_time')
            ->orderBy('pewo_id', 'desc')
            ->groupBy('pewo_id')
            ->get()->toArray();

        $list_items = [];
        $service_work_data = [];
        foreach ($list_detail_data as $key => $value) {//每个技师的业绩
            if (isset($list_items[$value->pewo_service_adm_id])) {
                if (!in_array($value->pewo_wor_id, $service_work_data[$value->pewo_service_adm_id])) {
                    $list_items[$value->pewo_service_adm_id]['work_quantity'] += 1;//工单数量
                    $service_work_data[$value->pewo_service_adm_id][] = $value->pewo_wor_id;//技师服务的工单
                }
                $list_items[$value->pewo_service_adm_id]['score'] += $value->pewo_score;
                $list_items[$value->pewo_service_adm_id]['rewards_punishment_price'] += $value->pewo_rewards_punishment_price;
                $list_items[$value->pewo_service_adm_id]['performance_total_price'] += $value->pewo_performance_total_price;
            } else {
                $temp_data['pewo_service_adm_id'] = $value->pewo_service_adm_id;
                $temp_data['pewo_service_adm_name'] = $value->pewo_service_adm_name;
                $temp_data['adm_phone'] = isset($find_adm[$value->pewo_service_adm_id]) ? $find_adm[$value->pewo_service_adm_id]->adm_phone : '';//技师手机号
                $temp_data['grle_name'] = '';
                if (isset($find_adm[$value->pewo_service_adm_id]) && !empty($find_adm[$value->pewo_service_adm_id]->grle_name)) {
                    $temp_data['grle_name'] = $find_adm[$value->pewo_service_adm_id]->grle_name;//技师级别名称
                }
                $temp_data['grpr_name'] = '';
                if (isset($find_adm[$value->pewo_service_adm_id]) && !empty($find_adm[$value->pewo_service_adm_id]->grpr_name)) {
                    $temp_data['grpr_name'] = $find_adm[$value->pewo_service_adm_id]->grpr_name;//技师职称名称
                }
                $temp_data['work_quantity'] = 1;//工单数量
                $temp_data['score'] = $value->pewo_score;//惩罚分数
                $temp_data['rewards_punishment_price'] = $value->pewo_rewards_punishment_price;//奖励、惩罚金额
                $temp_data['performance_total_price'] = $value->pewo_performance_total_price;//绩效总金额
                $service_work_data[$value->pewo_service_adm_id][] = $value->pewo_wor_id;//技师服务的工单
                $list_items[$value->pewo_service_adm_id] = $temp_data;
                unset($temp_data);
            }
        }

        sort($list_items);//对数组重新升序排序，主要为了重新排序数组的键值
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 详情
    public static function info($user_info, $request, $show_count = 10)
    {
        if ($request['type'] == 1) {//按工单分类
            $info = DB::table('work_order as wo')
                ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
                ->leftJoin('shop as s', 'wo.wor_service_shop_id', '=', 's.shop_id')
                ->where('wor_id', $request['wor_id'])
                ->where('wor_shop_id', $user_info->adm_shop_id)
                ->select('wor_id', 'wor_number', 'wor_create_id', 'wor_goo_amount', 'wor_actual_price', 'wor_account_state', 'wor_type', 'wor_state', 'wor_delete', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_remark', 'wocl_client_id', 'wor_appoint_time', 'wocl_appoint_remark', 'wocl_car_vehicle_type', 'wocl_pick_up_car_time', 'wocl_pick_up_car_adm_id', 'wocl_check_car_state', 'wocl_service_quality', 'wocl_car_vin', 'wor_service_shop_id', 'shop_store_name', 'wor_service_adm_id')
                ->first();
            if (empty($info)) {
                return ['code' => ErrorInc::DATA_EMPTY, 'msg' => '当前工单不存在', 'data' => ''];
            }

            // 获取该工单下的商品信息
            $goods_data = DB::table('work_good as wg')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
                ->where('wogo_wor_id', $request['wor_id'])
                ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_price', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_unit as goo_unit', 'goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            $service_adm_id = $info->wor_service_adm_id; //服务技师id
            // 账号id
            $adm_id[] = $info->wor_create_id;
            $adm_id[] = $service_adm_id;
            $adm_id = array_filter(array_unique($adm_id));
            // 查询账号id对应姓名
            $adm_name = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')
                ->toArray();
            $info->create_name = '';
            if ($info->wor_create_id != '0') {
                $info->create_name = $adm_name[$info->wor_create_id]; //创建人
            }
            unset($info->wor_create_id);
            unset($info->wor_service_adm_id);

            // 查看工单技师施工检测信息
            $technician_part = DB::table('wash_work_technician_part as wotp')
                ->leftJoin('wash_performance_work as pewo',function ($join) {
                    $join->on('pewo.pewo_wor_id', '=', 'wotp.wotp_wor_id')
                        ->on('pewo.pewo_service_adm_id', '=', 'wotp.wotp_service_adm_id')
                        ->on('pewo.pewo_work_type', '=', 'wotp.wotp_work_type');
                })
                ->where('wotp_wor_id', $request['wor_id'])
                ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_part', 'wotp_service_quality', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price', 'pewo_create_time', 'wotp_service_end_time')
                ->get()->toArray();
            if ($technician_part) {
                $info->pewo_create_time = $technician_part[0]->pewo_create_time;
            } else {
                $info->pewo_create_time = '';
            }
            $data['work_data'] = $info;
            $data['goods_data'] = $goods_data;
            $data['technician_part'] = $technician_part;
        } else {//按技师分类
            $search_data = $request;
            // 查询技师工单绩效根据工单id
            $find_pewo = DB::table('wash_performance_work as pewo')
                ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
                ->where('pewo_shop_id', $user_info->adm_shop_id)
                ->where('pewo_service_adm_id', $request['pewo_service_adm_id'])
                ->where(function ($query) use ($search_data) {//订单编号
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('pewo_ord_order_number', $search_data['ord_order_number']);
                    }
                })
                ->where(function ($query) use ($search_data) {//工单编号
                    if (!empty($search_data['wor_number'])) {
                        $query->where('pewo_wor_number', $search_data['wor_number']);
                    }
                })
                ->where(function ($query) use ($search_data) {//服务项目
                    if (!empty($search_data['sepr_id'])) {
                        $query->where('pewo_sepr_id', $search_data['sepr_id']);
                    }
                })
                ->where(function ($query) use ($search_data) { //施工结束时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                        $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['service_end_time_start'])) {
                            $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['service_end_time_end'])) {
                                $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //创建时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                        $query->whereBetween('pewo_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])) {
                            $query->where('pewo_create_time', '>=', $search_data['start_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('pewo_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                            }
                        }
                    }
                })
                ->select('pewo_id', 'pewo_wor_number', 'pewo_ord_order_number', 'pewo_service_adm_name', 'pewo_service_time', 'pewo_sepr_name', 'pewo_goo_name', 'pewo_goo_goods_encode', 'pewo_car_vehicle_type','pewo_car_vin', 'pewo_car_brand_series', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price', 'pewo_wor_id', 'pewo_create_time', 'wotp_service_end_time', 'pewo_service_adm_id')
                ->groupBy('pewo_wor_id')
                ->orderBy('pewo_create_time', 'desc')
                ->paginate($show_count);
            $find_pewo_data = $find_pewo->items();
            
            foreach ($find_pewo_data as $key => $value) {
                $find_pewo_data[$key]->pewo_rewards_punishment_price = DB::table('wash_performance_work')
                    ->where('pewo_wor_id', $value->pewo_wor_id)
                    ->where('pewo_service_adm_id', $value->pewo_service_adm_id)
                    ->sum('pewo_rewards_punishment_price');
                $find_pewo_data[$key]->pewo_performance_total_price = DB::table('wash_performance_work')
                    ->where('pewo_wor_id', $value->pewo_wor_id)
                    ->where('pewo_service_adm_id', $value->pewo_service_adm_id)
                    ->sum('pewo_performance_total_price');
                $sepr_data = DB::table('work_good as wogo')
                    ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'wogo.wogo_goo_id')
                    ->where('wogo_wor_id', $value->pewo_wor_id)
                    ->where('wogo_goo_type', 2)
                    ->select('sepr_name', 'wogo_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                    ->get()->toArray();
                $goods_data = DB::table('goods as g')
                    ->leftJoin('work_good as wogo', 'wogo.wogo_goo_id', '=', 'g.goo_id')
                    ->where('wogo_wor_id', $value->pewo_wor_id)
                    ->select('goo_name', 'wogo_new_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                    ->get()->toArray();

                if ($sepr_data) {
                    $find_pewo_data[$key]->pewo_sepr_name = $sepr_data;
                } else {
                    $find_pewo_data[$key]->pewo_sepr_name = [];
                }
                if ($goods_data) {
                    foreach ($goods_data as $key1 => $value1) {
                        $goods_data[$key1]->wogo_new_goo_amount = $value1->wogo_new_goo_amount.$value1->wogo_goo_unit;
                    }
                    $find_pewo_data[$key]->pewo_goo_name = $goods_data;
                } else {
                    $find_pewo_data[$key]->pewo_goo_name = [];
                }
                $find_pewo_data[$key]->items_data = DB::table('wash_performance_technician_items')
                    ->where('peti_pewo_id', $value->pewo_wor_id)
                    ->where('peti_service_adm_id', $request['pewo_service_adm_id'])
                    ->select('peti_id', 'peti_pewo_id', 'peti_service_adm_id', 'peti_items_name', 'peti_score', 'peti_items_id', 'peti_pema_id', 'peti_pema_name')
                    ->get()->toArray();
                $find_adm_data = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value->pewo_wor_id)
                    ->select('wotp_service_adm_id', 'wotp_service_adm_name')
                    ->get()->toArray();
                $find_adm_lead = DB::table('work_order')
                    ->where('wor_id', $value->pewo_wor_id)
                    ->value('wor_service_adm_id');
                $number = '';
                foreach ($find_adm_data as $key1 => $value1) {
                    if ($value1->wotp_service_adm_id == $find_adm_lead) {
                        $find_pewo_data[$key]->adm_name_leader = $value1->wotp_service_adm_name;
                    } else {
                        if (empty($number)) {
                            $number = $value1->wotp_service_adm_name;
                        } else {
                            $number = $number.' '.$value1->wotp_service_adm_name;
                        }
                    }
                }
                $find_pewo_data[$key]->adm_name_numbers = $number;
                $find_pewo_data[$key]->pewo_service_time = $find_pewo_data[$key]->pewo_create_time;
            }
            $data['current_page'] = $find_pewo->currentPage();  //当前页面页码
            $data['last_page'] = $find_pewo->lastPage();        //表示最后一页的页码
            $data['total'] = $find_pewo->total();               //总数据个数
            $data['current_number'] = $show_count;        //一页显示多少个
            $data['data_info'] = $find_pewo_data;
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 导出
    public static function lead($user_info, $request)
    {
        $search_data = $request;
        // 查询技师数据
        $list_data = DB::table('wash_performance_work as pewo')
            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_wor_number'])) {
                    $query->where('pewo_wor_number', 'like', '%' . $search_data['pewo_wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_ord_order_number'])) {
                    $query->where('pewo_ord_order_number', 'like', '%' . $search_data['pewo_ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//施工项目id
                if (!empty($search_data['pewo_sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['pewo_sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_service_adm_id')
            ->orderBy('pewo_id', 'asc')
            ->groupBy('pewo_service_adm_id')
            ->get()->toArray();
        $service_adm_id = array_column($list_data, 'pewo_service_adm_id');//技师id
        
        // 查询技师信息
        $find_adm = DB::table('admin as a')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'a.adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'asr.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'b.grle_grpr_id', '=', 'c.grpr_id')
            ->whereIn('a.adm_id', $service_adm_id)
            ->select('a.adm_id', 'adm_name', 'adm_phone', 'grle_name', 'grpr_name')
            ->get()->toArray();
        $find_adm = array_column($find_adm, null, 'adm_id');

        DB::connection()->enableQueryLog();#开启执行日志
        // 查询技师相关的业绩数据
        $list_detail_data = DB::table('wash_performance_work as pewo')
            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->whereIn('pewo_service_adm_id', $service_adm_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_wor_number'])) {
                    $query->where('pewo_wor_number', 'like', '%' . $search_data['pewo_wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_ord_order_number'])) {
                    $query->where('pewo_ord_order_number', 'like', '%' . $search_data['pewo_ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//施工项目id
                if (!empty($search_data['pewo_sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['pewo_sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_id', 'pewo_wor_id', 'pewo_service_adm_id', 'pewo_service_adm_name', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price','wotp_service_end_time')
            ->orderBy('pewo_id', 'desc')
            ->groupBy('pewo_id')
            ->get()->toArray();
        $data['sqls'] = DB::getQueryLog()[0];
        $sqls = $data['sqls'];
        $excel = new CommonController();
        $amp_id = $search_data['amp_id']??0;
        return $excel->getExcelOut($amp_id,$user_info,$search_data['pri_id'], $sqls, $search_data['api_token'],'500','TechnicianPerformance','绩效明细-技师');
        $list_items = [];
        $service_work_data = [];
        foreach ($list_detail_data as $key => $value) {
            if (isset($list_items[$value->pewo_service_adm_id])) {
                if (!in_array($value->pewo_wor_id, $service_work_data[$value->pewo_service_adm_id])) {
                    $list_items[$value->pewo_service_adm_id]['work_quantity'] += 1;//工单数量
                    $service_work_data[$value->pewo_service_adm_id][] = $value->pewo_wor_id;//技师服务的工单
                }
                $list_items[$value->pewo_service_adm_id]['score'] += $value->pewo_score;
                $list_items[$value->pewo_service_adm_id]['rewards_punishment_price'] += $value->pewo_rewards_punishment_price;
                $list_items[$value->pewo_service_adm_id]['performance_total_price'] += $value->pewo_performance_total_price;
            } else {
                $temp_data['pewo_service_adm_id'] = $value->pewo_service_adm_id;
                $temp_data['pewo_service_adm_name'] = $value->pewo_service_adm_name;
                $temp_data['adm_phone'] = isset($find_adm[$value->pewo_service_adm_id]) ? $find_adm[$value->pewo_service_adm_id]->adm_phone : '';//技师手机号
                $temp_data['grle_name'] = '';
                if (isset($find_adm[$value->pewo_service_adm_id]) && !empty($find_adm[$value->pewo_service_adm_id]->grle_name)) {
                    $temp_data['grle_name'] = $find_adm[$value->pewo_service_adm_id]->grle_name;//技师级别名称
                }
                $temp_data['grpr_name'] = '';
                if (isset($find_adm[$value->pewo_service_adm_id]) && !empty($find_adm[$value->pewo_service_adm_id]->grpr_name)) {
                    $temp_data['grpr_name'] = $find_adm[$value->pewo_service_adm_id]->grpr_name;//技师职称名称
                }
                $temp_data['work_quantity'] = 1;//工单数量
                $temp_data['score'] = $value->pewo_score;//惩罚分数
                $temp_data['rewards_punishment_price'] = $value->pewo_rewards_punishment_price;//奖励、惩罚金额
                $temp_data['performance_total_price'] = $value->pewo_performance_total_price;//绩效总金额
                $temp_data['wotp_service_end_time'] = $value->wotp_service_end_time;//施工结束时间
                $service_work_data[$value->pewo_service_adm_id][] = $value->pewo_wor_id;//技师服务的工单
                $list_items[$value->pewo_service_adm_id] = $temp_data;
                unset($temp_data);
            }
        }
        sort($list_items);//对数组重新升序排序，主要为了重新排序数组的键值
        if (!empty($list_items)) {
            $new_list = [];
            foreach ($list_items as $key => $value) {
                $new_list[$key]['pewo_service_adm_name'] = $value['pewo_service_adm_name'];
                $new_list[$key]['adm_phone'] = $value['adm_phone'];
                $new_list[$key]['grle_name'] = $value['grpr_name'].'-'.$value['grle_name'];
                $new_list[$key]['work_quantity'] = $value['work_quantity'];
                $new_list[$key]['performance_total_price'] = $value['performance_total_price']/100;
            }
            $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName, 0775, true);
                chmod($pathName, 0775);
            }

            $streamFileRand = time() . rand(10000, 99999) . '.xls';
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' . $streamFileRand;

            $where['action_name'] = '绩效表';
            $where['field_name'] = ['技师姓名', '联系电话', '技师职级', '工单数量', '绩效总金额'];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $new_list      //导出数据
            );
            return ['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
    }

    // 按工单分类导出
    public static function leadWork($user_info, $request)
    {
        DB::connection()->enableQueryLog();#开启执行日志
        $search_data = $request;
        $list_data = DB::table('wash_performance_work as pewo')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'pewo.pewo_goo_id')
            ->leftJoin('work_client as wc', 'pewo.pewo_wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('work_order as wor', 'pewo.pewo_wor_id', '=', 'wor.wor_id')
            ->leftJoin('order as o', 'o.ord_id', '=', 'wor.wor_order_id')
            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_wor_number'])) {
                    $query->where('pewo_wor_number', 'like', '%' . $search_data['pewo_wor_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['pewo_ord_order_number'])) {
                    $query->where('pewo_ord_order_number', 'like', '%' . $search_data['pewo_ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//施工项目id
                if (!empty($search_data['pewo_sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['pewo_sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_id', 'pewo_wor_id', 'pewo_wor_number', 'pewo_ord_order_number', 'pewo_service_adm_id', 'pewo_service_adm_name', 'pewo_service_time', 'pewo_sepr_name', 'pewo_goo_name', 'pewo_goo_goods_encode', 'pewo_car_vehicle_type','pewo_car_vin', 'pewo_car_brand_series', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price', 'goo_bra_name', 'goo_guarantee', 'wocl_car_num', 'pewo_create_time', 'pewo_performance_total_price', 'ord_order_price', 'wor_create_time', 'ord_id')
            ->orderBy('pewo_id', 'desc')
            ->groupBy('pewo_wor_number')
            ->get()->toArray();
        $data['sqls'] = DB::getQueryLog()[0];
        $sqls = $data['sqls'];
        $excel = new CommonController();
        $amp_id = $search_data['amp_id']??0;
        return $excel->getExcelOut($amp_id,$user_info,$search_data['pri_id'], $sqls, $search_data['api_token'],'500','OrderPerformance','绩效明细-工单');
        $list_items = json_decode(json_encode($list_data,true), true);
        if (!empty($list_items)) {
            $new_list = [];
            foreach ($list_items as $key => $value) {
                $sepr_data = DB::table('work_good as wogo')
                    ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'wogo.wogo_goo_id')
                    ->where('wogo_wor_id', $value['pewo_wor_id'])
                    ->where('wogo_goo_type', 2)
                    ->select('sepr_name', 'wogo_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                    ->get()->toArray();
                $sepr_name = '';
                if ($sepr_data) {
                    foreach ($sepr_data as $key1 => $value1) {
                        if ($sepr_name) {
                            $sepr_name = $sepr_name.','.$value1->sepr_name.'*'.$value1->wogo_goo_amount.$value1->wogo_goo_unit;
                        } else {
                            $sepr_name = $value1->sepr_name.'*'.$value1->wogo_goo_amount.$value1->wogo_goo_unit;
                        }
                    }
                }
                $goods_data = DB::table('goods as g')
                    ->leftJoin('work_good as wogo', 'wogo.wogo_goo_id', '=', 'g.goo_id')
                    ->where('wogo_wor_id', $value['pewo_wor_id'])
                    ->select('goo_name', 'wogo_new_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit', 'wogo_recycle_quantity')
                    ->get()->toArray();
                $goo_name = '';
                if ($goods_data) {
                    foreach ($goods_data as $key1 => $value1) {
                        $goo_unit = $value1->wogo_goo_unit;
                        if ($goo_name) {
                            $goo_name = $goo_name.','.$value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                        } else {
                            $goo_name = $value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                        }
                        // if ($goo_name) {
                        //     $goo_name = $goo_name.','.$value1->goo_name;
                        // } else {
                        //     $goo_name = $value1->goo_name;
                        // }
                    }
                }
                $new_data = DB::table('wash_performance_work')
                    ->where('pewo_wor_id', $value['pewo_wor_id'])
                    ->select('pewo_wor_id', 'pewo_performance_total_price')
                    ->get()->toArray();
                $pewo_performance_total_price = 0;
                if ($new_data) {
                    foreach ($new_data as $key2 => $value2) {
                        $pewo_performance_total_price += $value2->pewo_performance_total_price;
                    }
                }
                
                $new_list[$key]['pewo_wor_number'] = $value['pewo_wor_number'];
                $new_list[$key]['pewo_ord_order_number'] = $value['pewo_ord_order_number'];
                $new_list[$key]['pewo_sepr_name'] = $sepr_name;
                $new_list[$key]['pewo_create_time'] = $value['pewo_create_time'];
                $new_list[$key]['pewo_goo_name'] = $goo_name;
                $new_list[$key]['ord_order_price'] = $value['ord_order_price']/100;
                $wor_service_adm_id = DB::table('work_order')
                    ->where('wor_id', $value['pewo_wor_id'])
                    ->value('wor_service_adm_id');//组长id
                $find_team_members = DB::table('wash_work_technician_part')
                    ->where('wotp_wor_id', $value['pewo_wor_id'])
                    ->select('wotp_service_adm_id', 'wotp_service_adm_name')
                    ->get()->toArray();

                $team_members = '';
                if ($find_team_members) {
                    foreach ($find_team_members as $key1 => $value1) {
                        if ($team_members) {
                            if ($wor_service_adm_id == $value1->wotp_service_adm_id) {
                                $team_members = $team_members.','.$value1->wotp_service_adm_name.'(组长)';
                            } else {
                                $team_members = $team_members.','.$value1->wotp_service_adm_name;
                            }
                        } else {
                            if ($wor_service_adm_id == $value1->wotp_service_adm_id) {
                                $team_members = $value1->wotp_service_adm_name.'(组长)';
                            } else {
                                $team_members = $value1->wotp_service_adm_name;
                            }
                        }
                    }
                }

                $new_list[$key]['pewo_service_adm_name'] = $team_members;
                $new_list[$key]['wocl_car_num'] = $value['wocl_car_num'];
                $new_list[$key]['pewo_car_brand_series'] = $value['pewo_car_brand_series'];
                $new_list[$key]['pewo_score'] = $value['pewo_score'];
                $new_list[$key]['pewo_performance_total_price'] = $pewo_performance_total_price/100;
                $new_list[$key]['wor_create_time'] = $value['wor_create_time'];
                $wash_validate_car = DB::table('wash_validate_car')
                    ->where('vaca_ord_id', $value['ord_id'])
                    ->select('vaca_create_time')
                    ->first();
                if ($wash_validate_car) {
                    $new_list[$key]['vaca_create_time'] = $wash_validate_car->vaca_create_time;
                } else {
                    $new_list[$key]['vaca_create_time'] = '';
                }
                $new_list[$key]['wor_achieve_time'] = $value['wor_achieve_time'];
                // 记录开始时间
                $startTime = $value['wor_create_time']; // 开始时间
                 
                // 假设你在一个小时20分钟后完成操作
                $endTime = $value['wor_achieve_time'];
                 
                // 计算时间差
                $interval = $endTime->diff($startTime);
                 
                // 显示时间差
                $new_list[$key]['consuming'] =  $interval->format('%h小时%i分钟'); // 输出：1小时20分钟
                //$new_list[$key]['wotp_service_end_time'] = $value['wotp_service_end_time'];
                $find_wash_after_sale_items = DB::table('wash_after_sale_items')
                    ->leftJoin('wash_after_sale_list', 'afsl_id', '=', 'afsi_afsl_id')
                    ->where('afsl_ord_id', $value['ord_id'])
                    ->where('afsi_goo_id', '!=', '')
                    ->get()->toArray();
                $afsi_goo_name = '';
                if ($find_wash_after_sale_items) {
                    foreach ($find_wash_after_sale_items as $key_af => $value_af) {
                        $afsi_goo_unit = $value_af->afsi_goo_unit;
                        if ($afsi_goo_name) {
                            $afsi_goo_name = $afsi_goo_name.','.$value_af->afsi_goo_name.'*'.$value_af->afsi_goo_quantity.$afsi_goo_unit;
                        } else {
                            $afsi_goo_name = $value_af->goo_name.'*'.$value_af->afsi_goo_quantity.$afsi_goo_unit;
                        }
                    }
                }
                $new_list[$key]['afsi_goo_name'] = $value['afsi_goo_name'];
            }
            $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName, 0775, true);
                chmod($pathName, 0775);
            }

            $streamFileRand = time() . rand(10000, 99999) . '.xls';
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' . $streamFileRand;

            $where['action_name'] = '绩效工单表';
            $where['field_name'] = ['工单单号', '订单单号', '服务名称', '审核时间', '商品名称', '订单金额', '服务技师', '服务车辆', '品牌车系', '综合得分', '绩效金额'];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $new_list      //导出数据
            );
            return ['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
    }

    // 按详情导出
    public static function leadInfo($user_info, $request)
    {
        $search_data = $request;
        DB::connection()->enableQueryLog();#开启执行日志
        // 查询技师工单绩效根据工单id
        $find_pewo = DB::table('wash_performance_work as pewo')
            ->leftJoin('work_order as wor', 'wor.wor_id', '=', 'pewo.pewo_wor_id')
            ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'pewo.pewo_wor_id')
//            ->leftJoin('wash_work_technician_part as wotp', 'wotp.wotp_wor_id', '=', 'pewo.pewo_wor_id')
            ->where('pewo_shop_id', $user_info->adm_shop_id)
//            ->where('pewo_service_adm_id', $search_data['pewo_service_adm_id'])
            ->where(function ($query) use ($search_data) {//服务技师id
                if (!empty($search_data['pewo_service_adm_id'])) {
                    $query->where('pewo_service_adm_id', $search_data['pewo_service_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//订单编号
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('pewo_ord_order_number', $search_data['ord_order_number']);
                }
            })
            ->where(function ($query) use ($search_data) {//工单编号
                if (!empty($search_data['wor_number'])) {
                    $query->where('pewo_wor_number', $search_data['wor_number']);
                }
            })
            ->where(function ($query) use ($search_data) {//服务项目
                if (!empty($search_data['sepr_id'])) {
                    $query->where('pewo_sepr_id', $search_data['sepr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('pewo_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('pewo_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('pewo_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //施工结束时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['service_end_time_start']) && !empty($search_data['service_end_time_end'])) {
                    $query->whereBetween('wotp_service_end_time', [$search_data['service_end_time_start'], $search_data['service_end_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['service_end_time_start'])) {
                        $query->where('wotp_service_end_time', '>=', $search_data['service_end_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['service_end_time_end'])) {
                            $query->where('wotp_service_end_time', '<=', $search_data['service_end_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('pewo_id', 'pewo_wor_number', 'pewo_ord_order_number', 'pewo_service_adm_name', 'pewo_service_time', 'pewo_sepr_name', 'pewo_goo_name', 'pewo_goo_goods_encode', 'pewo_car_vehicle_type','pewo_car_vin', 'pewo_car_brand_series', 'pewo_score', 'pewo_rewards_punishment_price', 'pewo_performance_total_price', 'pewo_wor_id', 'pewo_create_time', 'wor_service_adm_id', 'wocl_car_num', 'pewo_performance_total_price', 'pewo_score', 'pewo_service_adm_id', 'wor_create_time', 'wor_order_id', 'wor_achieve_time', 'wocl_name' , 'wocl_phone', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address', 'wor_address_type', 'wor_address_id', 'wor_explain', 'wocl_adm_id', 'wocl_sales_adm_name')
//            ->groupBy('pewo_wor_id')
            ->orderBy('pewo_create_time', 'desc')
            ->get()->toArray();
        $data['sqls'] = DB::getQueryLog()[0];
        // dump($data);
        // die;
        $sqls = $data['sqls'];
        $excel = new CommonController();
        $amp_id = $search_data['amp_id']??0;
        return $excel->getExcelOut($amp_id,$user_info,$search_data['pri_id'], $sqls, $search_data['api_token'],'500','DetailPerformance','绩效明细-详情');
        if (!empty($find_pewo)) {
            $new_list = [];
            $find_pewo = json_decode(json_encode($find_pewo,true), true);
            foreach ($find_pewo as $key => $value) {
                $new_list[$key]['service_adm_name'] = Db::table('admin')->where('adm_id', $value['wor_service_adm_id'])->value('adm_name');
                $adm_names = Db::table('wash_performance_work as pewo')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'pewo.pewo_service_adm_id')
                    ->where('pewo_service_adm_id','!=', $value['wor_service_adm_id'])
                    ->where('pewo_wor_id', $value['pewo_wor_id'])
                    ->select('adm_name')
                    ->get()->toArray();
                if ($adm_names) {
                    $team_adm_names = '';
                    foreach ($adm_names as $key1 => $value1) {
                        if ($team_adm_names) {
                            $team_adm_names = $team_adm_names.','.$value1->adm_name;
                        } else {
                            $team_adm_names = $value1->adm_name;
                        }
                    }
                } else {
                    $team_adm_names = '无';
                }
                $sepr_data = DB::table('work_good as wogo')
                    ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'wogo.wogo_goo_id')
                    ->where('wogo_wor_id', $value['pewo_wor_id'])
                    ->where('wogo_goo_type', 2)
                    ->select('sepr_name')
                    ->get()->toArray();
                $sepr_name = '';
                if ($sepr_data) {
                    foreach ($sepr_data as $key1 => $value1) {
                        if ($sepr_name) {
                            $sepr_name = $sepr_name.','.$value1->sepr_name;
                        } else {
                            $sepr_name = $value1->sepr_name;
                        }
                    }
                }
                $goods_data = DB::table('goods as g')
                    ->leftJoin('work_good as wogo', 'wogo.wogo_goo_id', '=', 'g.goo_id')
                    ->where('wogo_wor_id', $value['pewo_wor_id'])
                    ->select('goo_name', 'wogo_new_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit', 'wogo_recycle_quantity')
                    ->get()->toArray();
                $goo_name = '';
                if ($goods_data) {
                    foreach ($goods_data as $key1 => $value1) {
                        $goo_unit = $value1->wogo_goo_unit;
                        if ($goo_name) {
                            $goo_name = $goo_name.','.$value1->goo_name.'数量：'.$value1->wogo_new_goo_amount.$goo_unit.',余料：'.$value1->wogo_recycle_quantity.$goo_unit;
                        } else {
                            $goo_name = $value1->goo_name.'数量：'.$value1->wogo_new_goo_amount.$goo_unit.',余料：'.$value1->wogo_recycle_quantity.$goo_unit;
                        }
                        // if ($goo_name) {
                        //     $goo_name = $goo_name.','.$value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                        // } else {
                        //     $goo_name = $value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                        // }
                        // if ($goo_name) {
                        //     $goo_name = $goo_name.','.$value1->goo_name;
                        // } else {
                        //     $goo_name = $value1->goo_name;
                        // }
                    }
                }
                $new_list[$key]['team_service_adm_name'] = $team_adm_names;
                $new_list[$key]['pewo_wor_number'] = $value['pewo_wor_number'];
                $new_list[$key]['pewo_ord_order_number'] = $value['pewo_ord_order_number'];
                $new_list[$key]['pewo_car_brand_series'] = $value['pewo_car_brand_series'];
                $new_list[$key]['pewo_create_time'] = $value['pewo_create_time'];
                $new_list[$key]['pewo_sepr_name'] = $sepr_name;
                $new_list[$key]['pewo_goo_name'] = $goo_name;
                $new_list[$key]['pewo_score'] = $value['pewo_score'];
                $new_list[$key]['pewo_performance_total_price'] = $value['pewo_performance_total_price']/100;
                $new_list[$key]['wor_create_time'] = $value['wor_create_time'];
                $wash_validate_car = DB::table('wash_validate_car')
                    ->where('vaca_ord_id', $value['wor_order_id'])
                    ->select('vaca_create_time')
                    ->first();
                if ($wash_validate_car) {
                    $new_list[$key]['vaca_create_time'] = $wash_validate_car->vaca_create_time;
                } else {
                    $new_list[$key]['vaca_create_time'] = '';
                }
                $new_list[$key]['wor_achieve_time'] = $value['wor_achieve_time'];
                $startTime = strtotime($value['wor_create_time']);
                $endTime = strtotime($value['wor_achieve_time']);

                // 计算时间差（秒数）
                $timeDifference = $endTime - $startTime;

                // 将秒数转换为小时、分钟和秒
                $hours = floor($timeDifference / 3600);
                $minutes = floor(($timeDifference % 3600) / 60);
                $seconds = $timeDifference % 60;
                 
                // 显示时间差
                $new_list[$key]['consuming'] =  $hours.'小时'.$minutes.'分钟'.$seconds.'秒'; // 输出：1小时20分钟
                //$new_list[$key]['wotp_service_end_time'] = $value['wotp_service_end_time'];
                $find_wash_after_sale_items = DB::table('wash_after_sale_items')
                    ->leftJoin('wash_after_sale_list', 'afsl_id', '=', 'afsi_afsl_id')
                    ->where('afsl_ord_id', $value['wor_order_id'])
                    ->where('afsi_goo_id', '!=', '')
                    ->get()->toArray();
                $afsi_goo_name = '';
                if ($find_wash_after_sale_items) {
                    foreach ($find_wash_after_sale_items as $key_af => $value_af) {
                        $afsi_goo_unit = $value_af->afsi_goo_unit;
                        if ($afsi_goo_name) {
                            $afsi_goo_name = $afsi_goo_name.','.$value_af->afsi_goo_name.'*'.$value_af->afsi_goo_quantity.$afsi_goo_unit;
                        } else {
                            $afsi_goo_name = $value_af->afsi_goo_name.'*'.$value_af->afsi_goo_quantity.$afsi_goo_unit;
                        }
                    }
                }
                $new_list[$key]['afsi_goo_name'] = $afsi_goo_name;
                //$new_list[$key]['wotp_service_end_time'] = $value['wotp_service_end_time'];
                unset($team_adm_names);
            }
            $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName, 0775, true);
                chmod($pathName, 0775);
            }

            $streamFileRand = time() . rand(10000, 99999) . '.xls';
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' . $streamFileRand;

            $where['action_name'] = '绩效表';
            $where['field_name'] = ['技师组长', '技师组员', '工单号', '订单号', '施工车辆', '核算时间', '施工项目', '施工产品', '综合得分', '绩效金额', '派单时间', '验车时间', '施工完成时间', '完成工单耗时', '售后订单商品'];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $new_list      //导出数据
            );
            return ['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
    }
}
