<?php

namespace App\Services\Business;

use Illuminate\Database\Eloquent\Model;
use App\Models\Business\WashService;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\WashServiceValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Models\Services\WarehouseLock;
use App\Http\Models\Api\DispatchBill;
use App\Http\Models\Services\ImageUpload;
use App\Http\Models\Services\Order;
use App\Models\OperationLog;
use Illuminate\Http\Request;
use App\Services\WeChatApplet\User\MemberCarService;
use App\Http\Models\Api\CashierDesk;

class WashServiceService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WashService();
        $this->mainValidator = new WashServiceValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        $list_data = DB::table('service_project as s')
            ->where('sepr_shop_id', $user_info->adm_shop_id)
            ->where('sepr_delete', 1) //是否删除1正常2删除
            ->where('sepr_state', 1) //状态1启用2停用
            ->whereIn('sepr_show_location', [2,3]) //显示位置1洗美2合作商3洗美和合作商4无
            ->select('sepr_name', 'sepr_img', 'sepr_id')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $length = strlen(config('apisystem.server_name_https'));
                if (substr($value->sepr_img, 0,4) == 'http') {
                    $list_items[$key]->sepr_img = substr($value->sepr_img, 22);
                }
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 客户端小程序-根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchClientPage($user_info, $search_data, $show_count = 10)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }
        $list_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'ord.ord_shop_id')
            // ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_client_id', $user_info->ussh_user_id)
            ->where('ord_type', 1) //买家类型：1门店零售2客户单位
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->whereIn('ord_is_split', [1, 2]) //订单拆分
            // ->where('ord_delete', 1) //是否删除：1正常订单2取消订单
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['keywords'] . '%') //订单单号
                        ->orwhere('orcl_phone', 'like', '%' . $search_data['keywords'] . '%') //客户电话
                        ->orwhere('orcl_name', 'like', '%' . $search_data['keywords'] . '%') //客户姓名
                        ->orwhere('orcl_car_num', 'like', '%' . $search_data['keywords'] . '%') //车牌号
                        ->orwhere('orcl_car_vin', 'like', '%' . $search_data['keywords'] . '%') //车架号车辆识别码
                        ->orwhere('orcl_car_vehicle_type', 'like', '%' . $search_data['keywords'] . '%'); //车型
                }
            })
            ->where(function ($query) use ($search_data) { //订单删除状态 是否删除：1正常订单2取消订单
                if (!empty($search_data['ord_delete'])) {
                    $query->where('ord_delete', $search_data['ord_delete']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单状态
                if (!empty($search_data['ord_wor_state'])) {
                    $query->where('ord_wor_state', $search_data['ord_wor_state']);
                }
            })
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_order_price', 'ord_actual_price', 'ord_type', 'ord_order_state', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'shop_store_name', 'orcl_car_vin', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_car_brand_series', 'orcl_carowner_phone', 'orcl_carowner_name')
            ->orderBy('ord_id', $orderby_type)
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $ord_id = array_column($list_items, 'ord_id'); //订单id
            $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // 查询商品、项目信息
            // $order_goods = DB::table('order_goods as orgo')
            //     ->leftjoin('wash_order_items as woi', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            //     ->whereIn('orgo_ord_id', $ord_id)
            $order_goods = DB::table('wash_order_items as woi')
                ->leftjoin('order_goods as orgo', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
                ->whereIn('orit_ord_id', $ord_id)
                ->select('orgo_id', 'orit_ord_id as orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orit_id', 'orit_sepr_id', 'orit_sepr_name', 'orit_part_state', 'orit_service_price', 'orit_service_adm_id')
                ->get()->toArray();
            $pick_up_car_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_pick_up_car_adm_id'))); //接车人id
            $service_adm_id = array_filter(array_unique(array_column($order_goods, 'orit_service_adm_id'))); //选的技师id
            $orit_sepr_id = array_filter(array_unique(array_column($order_goods, 'orit_sepr_id'))); //服务项目id
            $adm_id_merge = array_merge($ord_create_id, $service_adm_id);
            $adm_id_merge = array_merge($adm_id_merge, $pick_up_car_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();
            // 查询服务项目图片
            $find_sepr = DB::table('service_project')
                ->whereIn('sepr_id', $orit_sepr_id)
                ->pluck('sepr_img', 'sepr_id')->toArray();

            foreach ($order_goods as $key => $value) {
                // 技师名称
                $order_goods[$key]->service_adm_name = '';
                if (isset($find_adm[$value->orit_service_adm_id])) {
                    $order_goods[$key]->service_adm_name = $find_adm[$value->orit_service_adm_id];
                }
                // 服务项目图片路径
                if (isset($find_sepr[$value->orit_sepr_id]) && !empty($find_sepr[$value->orit_sepr_id])) {
                    $order_goods[$key]->goo_image = $find_sepr[$value->orit_sepr_id];
                } else {
                    $order_goods[$key]->goo_image = 'image/xmc/xx_icon.png'; //显示图片
                }
                if (empty($value->orgo_goo_name)) {
                    $order_goods[$key]->orgo_goo_name = '';
                    $order_goods[$key]->orgo_goo_quantity = '';
                }
            }

            // 查询工单完成时间
            $find_wor_data = DB::table('work_order')
                ->whereIn('wor_order_id', $ord_id)
                ->pluck('wor_achieve_time', 'wor_order_id')->toArray();
            foreach ($list_items as $key => $value) {
                // 创建人
                if ($value->ord_create_id) {
                    $list_items[$key]->adm_name = $find_adm[$value->ord_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                // 接车人
                if ($value->orcl_pick_up_car_adm_id) {
                    $list_items[$key]->pick_up_car_adm_name = $find_adm[$value->orcl_pick_up_car_adm_id];
                } else {
                    $list_items[$key]->pick_up_car_adm_name = '';
                }
                // 技师完成时间
                if (isset($find_wor_data[$value->ord_id]) && $find_wor_data[$value->ord_id] != '0000-00-00 00:00:00') {
                    $list_items[$key]->wor_achieve_time = $find_wor_data[$value->ord_id];
                } else {
                    $list_items[$key]->wor_achieve_time = '';
                }
                // 订单作品
                if ($value->ord_wor_state >= 4) {
                    $list_items[$key]->order_works = DB::table('order_works')
                        ->where('orwo_ord_id', $value->ord_id)
                        ->where('orwo_delete', 2)
                        ->select('orwo_title', 'orwo_type', 'orwo_description', 'orwo_data')
                        ->get()->toArray();
                }
            }
        } else {
            $order_goods = [];
        }

        $reli_data = DB::table('wash_reservation_list as reli')
            ->where('reli_client_id', $user_info->ussh_user_id)
            ->where('reli_client_type', 1) //买家类型：1门店零售2客户单位
            ->where('reli_state', 1) //预约单状态：1待接单2已接单3取消订单4已撤回
            ->select(DB::raw('count(*) as count, reli_state'))
            ->groupBy('reli_state')
            ->get();
        // 查询订单状态对应的订单数量
        $state_count = DB::table('order')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_client_id', $user_info->ussh_user_id)
            ->where('ord_type', 1) //买家类型：1门店零售2客户单位
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->whereIn('ord_is_split', [1,2]) //工单分类：1蓄电池2洗美店3易损件
            ->where('ord_delete', 1) //是否删除：1正常订单2取消订单
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //订单商品数据
        $data['state_count'] = $state_count;
        $data['reli_count'] = $reli_data;
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    /**
     * 客户端小程序-根据条件搜索预约单数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function reindex($user_info, $search_data, $show_count = 10)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        $list_data = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'recl.recl_reli_id', '=', 'reli.reli_id')
            ->leftJoin('wash_reservation_items as reit', 'reit.reit_reli_id', '=', 'reli.reli_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'reli.reli_shop_id')
            ->where('reli_client_id', $user_info->ussh_user_id)
            ->where('reli_client_type', 1) //买家类型：1门店零售2客户单位
            ->where('reli_state', 1) //预约单状态：1待结单2已接单3取消订单4已撤回
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('reli_number', 'like', '%' . $search_data['keywords'] . '%') //订单单号
                        ->orwhere('recl_phone', 'like', '%' . $search_data['keywords'] . '%') //客户电话
                        ->orwhere('recl_name', 'like', '%' . $search_data['keywords'] . '%') //客户姓名
                        ->orwhere('recl_car_num', 'like', '%' . $search_data['keywords'] . '%') //车牌号
                        ->orwhere('recl_car_vin', 'like', '%' . $search_data['keywords'] . '%') //车架号车辆识别码
                        ->orwhere('recl_car_brand_series', 'like', '%' . $search_data['keywords'] . '%'); //品牌车系
                }
            })
            ->where(function ($query) use ($search_data) { //预约单状态：1待结单2已接单3取消订单4已撤回
                if (!empty($search_data['reli_state'])) {
                    $query->where('reli_state', $search_data['reli_state']);
                }
            })
            ->select('reli_id', 'shop_store_name', 'reli_number', 'reli_order_number', 'reli_state', 'reli_appoint_time_slot', 'reli_appoint_time', 'reli_appoint_remark', 'reli_remark', 'reit_sepr_name', 'reli_create_time', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'reit_sepr_id', 'reli_ord_id')
            ->orderBy('reli_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $ord_id = array_column($list_items, 'reli_ord_id'); //订单id
            // $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // // 查询商品、项目信息
            // // $order_goods = DB::table('order_goods as orgo')
            // //     ->leftjoin('wash_order_items as woi', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            // //     ->whereIn('orgo_ord_id', $ord_id)
            // $order_goods = DB::table('wash_order_items as woi')
            //     ->leftjoin('order_goods as orgo', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            //     ->whereIn('orit_ord_id', $ord_id)
            //     ->select('orgo_id', 'orit_ord_id as orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orit_id', 'orit_sepr_id', 'orit_sepr_name', 'orit_part_state', 'orit_service_price', 'orit_service_adm_id')
            //     ->get()->toArray();
            // $pick_up_car_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_pick_up_car_adm_id'))); //接车人id
            // $service_adm_id = array_filter(array_unique(array_column($order_goods, 'orit_service_adm_id'))); //选的技师id
            // $adm_id_merge = array_merge($ord_create_id, $service_adm_id);
            // $adm_id_merge = array_merge($adm_id_merge, $pick_up_car_adm_id);
            // // 查询录单人信息
            // $find_adm = DB::table('admin')
            //     ->whereIn('adm_id', $adm_id_merge)
            //     ->pluck('adm_name', 'adm_id')->toArray();
            $reit_sepr_id = array_filter(array_unique(array_column($list_items, 'reit_sepr_id'))); //服务项目id
            // 查询服务项目图片
            $find_sepr = DB::table('service_project')
                ->whereIn('sepr_id', $reit_sepr_id)
                ->pluck('sepr_img', 'sepr_id')->toArray();

            foreach ($list_items as $key => $value) {
                // 服务项目图片路径
                if (isset($find_sepr[$value->reit_sepr_id]) && !empty($find_sepr[$value->reit_sepr_id])) {
                    $list_items[$key]->sepr_img = $find_sepr[$value->reit_sepr_id];
                } else {
                    $list_items[$key]->sepr_img = 'image/xmc/xx_icon.png'; //显示图片
                }
            }

            // 查询工单完成时间
            $find_wor_data = DB::table('work_order')
                ->whereIn('wor_order_id', $ord_id)
                ->pluck('wor_achieve_time', 'wor_order_id')->toArray();
            foreach ($list_items as $key => $value) {
                // 技师完成时间
                if (isset($find_wor_data[$value->reli_ord_id]) && $find_wor_data[$value->reli_ord_id] != '0000-00-00 00:00:00') {
                    $list_items[$key]->wor_achieve_time = $find_wor_data[$value->reli_ord_id];
                } else {
                    $list_items[$key]->wor_achieve_time = '';
                }
            }
        } else {
            $order_goods = [];
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }


    // 新增-添加订单,数据处理
    public static function addOrder($user_info, $request) {
        $goods_data = json_decode($request['goods_data'], true);
        $count = count($goods_data);//统计服务项目个数
        $hint = ''; //提示信息
        if ($count > 1) {
            $add_res = self::add($user_info, $request, 3);//添加总订单
            if ($add_res['code'] == 200) {
                // 总订单历史记录
                $data['wohi_primary_id'] = $add_res['data']['ord_id'];
                $data['wohi_state_name'] = '已创建';
                $data['wohi_state'] = 1;
                $data['wohi_type'] = 1;
                addHistory($data);
                unset($data);
                // 生成操作记录
                $orlo_res = orderLog($user_info, $add_res['data']['ord_id'], 0, '生成订单');
                OperationLog::addLog($user_info, $request['client_ip'], '订单列表', '生成订单', '生成订单' . $add_res['data']['ord_order_number'] . '成功');
                foreach ($goods_data as $key =>$value) {//根据服务商品拆分订单
                    unset($request['goods_data']);
                    $request['goods_data'][] = $value;
                    // 获取唯一字符串标识
                    $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
                    $request['ord_unique_string'] = $ord_unique_string;
                    $request['ord_order_number'] = $add_res['data']['ord_order_number'].'-'.($key+1);//分订单单号
                    $order_data = self::add($user_info, $request, 2);
                    unset($request['goods_data']);
                    if ($order_data['code'] != 200) {
                        return $order_data;
                    }
                    // 拆分的订单历史记录
                    $data['wohi_primary_id'] = $order_data['data']['ord_id'];
                    $data['wohi_state_name'] = '已创建';
                    $data['wohi_state'] = 1;
                    $data['wohi_type'] = 1;
                    addHistory($data);
                    unset($data);
                    $hint = ''; //提示信息
                    // add_type 新增类型1生成订单2立即派单
                    if ($request['add_type'] == 2) {
                        // 立即派单，生成工单
                        $request['ord_id'] = $order_data['data']['ord_id'];
                        $request['goods_data'] = $order_data['data']['goods_data'];
                        $work_data = WashOrderService::createWork($user_info, $request, 2);
                        if ($work_data['code'] != 200) {
                            return $work_data;
                        }
                        // 生成操作记录
                        $orlo_res = orderLog($user_info, $order_data['data']['ord_id'], $work_data['data']['wor_id'], '立即派单');
                        $hint = '立即派单';
                        $find_wor_data = DB::table('work_order')
                            ->where('wor_id', $work_data['data']['wor_id'])
                            ->select('wor_service_adm_id')
                            ->first();
                        // 添加技师消息
                        $add_data['adm_id'] = $find_wor_data->wor_service_adm_id;
                        $add_data['shop_id'] = $user_info->adm_shop_id;
                        $add_data['primary_id'] = $work_data['data']['wor_id']; //单据的主键id
                        $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
                        $add_data['message_type'] = 1;
                        // $add_data['message_type'] = $data['message_type'];
                        $add_data['title'] = '派单通知'; //操作内容
                        $add_data['content'] = '你有新的工单，请注意查看'; //操作内容
                        $add_data['read_state'] = 1; //阅读状态：1未读2已读
                        $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
                        $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
                        $addAdminMessage_res = addAdminMessage($add_data);
                        // 订单历史记录
                        $data['wohi_primary_id'] = $add_res['data']['ord_id'];
                        $data['wohi_state_name'] = '待施工';
                        $data['wohi_state'] = 2;
                        $data['wohi_type'] = 1;
                        addHistory($data);
                        unset($data);
                        // 工单的历史记录
                        $data['wohi_primary_id'] = $work_data['data']['wor_id'];
                        $data['wohi_state_name'] = '已创建';
                        $data['wohi_state'] = 1;//服务状态：1已创建
                        $data['wohi_type'] = 2;//1订单2工单
                        addHistory($data);
                        unset($data);
                        // 工单的历史记录
                        $data['wohi_primary_id'] = $work_data['data']['wor_id'];
                        $data['wohi_state_name'] = '待接单';
                        $data['wohi_state'] = 2;//服务状态：2待接单
                        $data['wohi_type'] = 2;//1订单2工单
                        addHistory($data);
                        unset($data);
                        if ($addAdminMessage_res['code'] != 200) {
                            return $addAdminMessage_res;
                        }
                    } else {
                        // 生成操作记录
                        $orlo_res = orderLog($user_info, $order_data['data']['ord_id'], 0, '生成订单');
                        $hint = '生成订单';
                    }
                    OperationLog::addLog($user_info, $request['client_ip'], '订单列表', $hint, $hint . $order_data['data']['ord_order_number'] . '成功');
                    unset($order_data);
                }
            } else {
                return $add_res;
            }
        } else {
            $add_res = self::add($user_info, $request);
            if ($add_res['code'] == 200) {
                // 生成订单历史记录
                $data['wohi_primary_id'] = $add_res['data']['ord_id'];
                $data['wohi_state_name'] = '已创建';
                $data['wohi_state'] = 1;
                $data['wohi_type'] = 1;
                addHistory($data);
                unset($data);
                // add_type 新增类型1生成订单2立即派单
                if ($request['add_type'] == 2) {
                    // 立即派单，生成工单
                    $request['ord_id'] = $add_res['data']['ord_id'];
                    $request['goods_data'] = $add_res['data']['goods_data'];
                    $work_data = WashOrderService::createWork($user_info, $request, 2);
                    if ($work_data['code'] != 200) {
                        return $work_data;
                    }
                    // 生成操作记录
                    $orlo_res = orderLog($user_info, $add_res['data']['ord_id'], $work_data['data']['wor_id'], '立即派单');
                    $hint = '立即派单';
                    $find_wor_data = DB::table('work_order')
                        ->where('wor_id', $work_data['data']['wor_id'])
                        ->select('wor_service_adm_id')
                        ->first();
                    // 添加技师消息
                    $add_data['adm_id'] = $find_wor_data->wor_service_adm_id;
                    $add_data['shop_id'] = $user_info->adm_shop_id;
                    $add_data['primary_id'] = $work_data['data']['wor_id']; //单据的主键id
                    $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
                    $add_data['message_type'] = 1;
                    // $add_data['message_type'] = $data['message_type'];
                    $add_data['title'] = '派单通知'; //操作内容
                    $add_data['content'] = '你有新的工单，请注意查看'; //操作内容
                    $add_data['read_state'] = 1; //阅读状态：1未读2已读
                    $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
                    $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
                    $addAdminMessage_res = addAdminMessage($add_data);
                    // 订单历史记录
                    $data['wohi_primary_id'] = $add_res['data']['ord_id'];
                    $data['wohi_state_name'] = '待施工';
                    $data['wohi_state'] = 2;
                    $data['wohi_type'] = 1;
                    addHistory($data);
                    unset($data);
                    // 工单的历史记录
                    $data['wohi_primary_id'] = $work_data['data']['wor_id'];
                    $data['wohi_state_name'] = '已创建';
                    $data['wohi_state'] = 1;//服务状态：1待接单
                    $data['wohi_type'] = 2;//1订单2工单
                    addHistory($data);
                    unset($data);
                    // 工单的历史记录
                    $data['wohi_primary_id'] = $work_data['data']['wor_id'];
                    $data['wohi_state_name'] = '待接单';
                    $data['wohi_state'] = 2;//服务状态：2待接单
                    $data['wohi_type'] = 2;//1订单2工单
                    addHistory($data);
                    unset($data);
                    if ($addAdminMessage_res['code'] != 200) {
                        return $addAdminMessage_res;
                    }
                } else {
                    // 生成操作记录
                    $orlo_res = orderLog($user_info, $add_res['data']['ord_id'], 0, '生成订单');
                    $hint = '生成订单';
                }
            } else {
                return $add_res;
            }
        }
        return ['code'=>200, 'msg'=>'success', 'hint'=>$hint, 'data'=>$add_res['data']];
    }

    // 新增-添加订单
    public static function add($user_info, $request, $type = 1)
    {
        if (empty($request['ord_unique_string'])) {
            return ['code'=>ErrorInc::FAILED_PARAM, 'msg'=>'生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data'=>''];
        }
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>ErrorInc::DATA_EXIST, 'msg'=>'当前订单已提交，请勿重复操作！', 'data'=>''];
        }
        if ($type == 1) {//1此订单为正常订单
            $ord_order_number = Common::numberRule($user_info, 1);
            $data['ord_is_split'] = 1;
        } elseif ($type == 2) {//2此订单为分订单
            $ord_order_number = $request['ord_order_number'];
            $data['ord_is_split'] = 2;
        } elseif ($type == 3) {//3此订单为总订单，拆分为多个订单
            $ord_order_number = Common::numberRule($user_info, 1);
            $data['ord_is_split'] = 3;
        }
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = $request['ord_client_id'];
        $data['ord_ware_id'] = $request['ware_id'] ? $request['ware_id'] : '';
        $data['ord_province'] = $request['ord_province'];//施工地址省
        $data['ord_city'] = $request['ord_city'];
        $data['ord_county'] = $request['ord_county'];
        $data['ord_address'] = $request['ord_address'];
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = $request['ord_type'];
        $data['ord_service_type'] = 1; //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_payment_way'] = 2; //结算方式1账期2现结
        // $data['ord_remark'] = isset($request['ord_remark']) ? $request['ord_remark'] : '';
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $request['ord_unique_string'];

        // 判断是否有预约单id
        if (!empty($request['reli_id'])) {
            // 有预约单id说明是从预约单过去的
            // 查看预约单是否是待结单状态
            $find_reli_data = DB::table('wash_reservation_list')
                ->where('reli_id', $request['reli_id'])
                ->where('reli_shop_id', $user_info->adm_shop_id)
                ->select('reli_number', 'reli_state', 'reli_client_id')
                ->first();
            if (empty($find_reli_data)) {
                return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'未找到当前预约单！', 'data'=>''];
            }
            if ($find_reli_data->reli_state != 1 && $type != 2) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单不是待接单状态！', 'data'=>''];
            }
            // 判断前端是否传客户单位id,前端没有传客户单位id的把预约单列表查出来的赋值到订单数据中
            if ($request['ord_client_id']) {
                $data['ord_client_id'] = $request['ord_client_id'];
            } else {
                $data['ord_client_id'] = $find_reli_data->reli_client_id; //预约列表的单位id
            }
        }
        $ord_id = WashOrder::insertGetId($data);

        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_phone', $request['orcl_phone'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            if ($request['ord_type'] == 1) { //买家类型：1会员零售
                // 零售，会员表
                $client_res = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->increment('mem_order_all');
            } else {
                $client_res = true;
            }
            $weus_id = $find_weixin_data->weus_id;
        } else {
            if ($request['ord_type'] == 2) { //买家类型：2企业客户
                // 1. 判断企业客户账号名称是否存在
                $find_buac = DB::table('business_account')
                    ->where('buac_bucl_id', $request['bucl_id'])
                    ->where('buac_name', $request['orcl_name'])
                    ->first(['buac_id']);
                if ($find_buac) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'客户名称已存在，生成订单失败'];
                }

                // 2 新增一个客户单位
                $add_buac_data['buac_name'] = $request['orcl_name'];
                $add_buac_data['buac_phone'] = $request['orcl_phone'];
                $add_buac_data['buac_bucl_id'] = $request['bucl_id'];
                $add_buac_data['buac_create_adm_id'] = $user_info->adm_id;
                $add_buac_data['buac_create_time'] = date('Y-m-d H:i:s');
                $buac_res =  DB::table('business_account')->insertGetId($add_buac_data);
            } else {
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_create_id'] = $user_info->adm_id;
                $eme['mem_create_name'] = $user_info->adm_name;
                $eme['mem_name'] = $request['orcl_name'] ? $request['orcl_name'] : '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code"=>500, 'msg'=>'error', 'data'=>'当前手机号已存在'];
                    }
                }
                $eme['mem_phone'] = $request['orcl_phone'] ? $request['orcl_phone'] : '';
                $eme['mem_source'] = $request['orcl_mem_source'] ? $request['orcl_mem_source'] : '';//来源
                $eme['mem_car_num'] = $request['orcl_car_num'] ? $request['orcl_car_num'] : '';
                $eme['mem_order_all'] = 1; //订单数
                $mem_id = DB::table('member')->insertGetId($eme);
                WashOrderService::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;
                $client_res = true;
                
                if (empty($find_weixin_data)) {
                    // 不存在就新增用户
                    $weus_data['weus_openid'] = $mem_id;
                    $weus_data['weus_phone'] = $request['orcl_phone'];
                    $weus_data['weus_nickmame'] = $request['orcl_name'];
                    $weus_data['weus_follow'] = 1;
                    $weus_data['weus_sex'] = 0;
                    $weus_data['weus_province'] = '';
                    $weus_data['weus_city'] = '';
                    $weus_data['weus_headimgurl'] = '';
                    $weus_data['weus_update_time'] = date('Y-m-d H:i:s');
                    $weus_id = DB::table('weixin_user')->insertGetId($weus_data);
                    if (!$weus_id) {
                        return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
                    }
                    unset($weus_data['weus_update_time']);
                } else {
                    // 更新微信用户信息
                    $edit_weus['weus_phone'] = $request['orcl_phone'];
                    $edit_weus['weus_nickmame'] = $request['orcl_name'];
                    if (!empty($request['weus_headimgurl'])) {
                        $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                    }
                    $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                    $edit_weus_res = DB::table('weixin_user')
                        ->where('weus_id', $find_weixin_data->weus_id)
                        ->update($edit_weus);
                    unset($edit_weus);
                    $weus_id = $find_weixin_data->weus_id;
                }

                // 查询微信用户与门店的关系是否存在绑定关系
                $find_user_shop_data = DB::table('user_shop')
                    ->where('ussh_weus_id', $weus_id)
                    ->where('ussh_shop_id', $user_info->adm_shop_id)
                    ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                    ->first();

                if (empty($find_user_shop_data)) {
                    // 用户没有与当前门店绑定，把用户与当前门店绑定
                    $ussh_data['ussh_user_id'] = $mem_id;
                    $ussh_data['ussh_weus_id'] = $weus_id;
                    $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
                    $ussh_data['ussh_user_type'] = 1;
                    $ussh_data['ussh_phone'] = $request['orcl_phone'];
                    $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                    if (!$ussh_id) {
                        return ['code'=>500, 'msg'=>'新增失败2', 'data'=>''];
                    }
                } else {
                    if (empty($find_user_shop_data->ussh_user_id)) {
                        $ussh_data['ussh_user_type'] = 1;
                        $ussh_data['ussh_phone'] = $request['orcl_phone'];
                        $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                        $ussh_id = DB::table('user_shop')
                            ->where('ussh_id', $find_user_shop_data->ussh_id)
                            ->update($ussh_data);
                    }
                }
            }
        }
        // 判断是否有预约单id
        if (!empty($request['reli_id'])) {
            $reli_edit_data['reli_ord_id'] = $ord_id;
            $reli_edit_data['reli_order_number'] = $ord_order_number;
            $reli_edit_data['reli_state'] = 2;
            $reli_edit_data['reli_update_time'] = date('Y-m-d H:i:s');
            $reli_res = DB::table('wash_reservation_list')
                ->where('reli_id', $request['reli_id'])
                ->update($reli_edit_data);
            if (!$reli_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'新增失败1'];
            }
        }

        if ($request['ord_type'] == '2') {
            $chun_adm_id = DB::table('channel_unit')
                ->where('chun_id', $request['ord_client_id'])
                ->value('chun_adm_id');
            if (empty($chun_adm_id)) {
                $chun_adm_id = 0;
            }
        } else {
            $chun_adm_id = 0;
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_adm_id' => $chun_adm_id, //业务员id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '',// 销售人员id
            'orcl_channel_unit' => isset($request['orcl_channel_unit']) ? $request['orcl_channel_unit'] : '',
            'orcl_business_name' => isset($request['orcl_business_name']) ? $request['orcl_business_name'] : '',//公司名称
            'orcl_name' => $request['orcl_name'],
            'orcl_phone' => $request['orcl_phone'],
            'orcl_carowner_name' => $request['orcl_carowner_name'],
            'orcl_carowner_phone' => $request['orcl_carowner_phone'],
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_province' => isset($request['orcl_province']) ? $request['orcl_province'] : '',
            'orcl_city' => isset($request['orcl_city']) ? $request['orcl_city'] : '',
            'orcl_county' => isset($request['orcl_county']) ? $request['orcl_county'] : '',
            'orcl_address' => isset($request['orcl_address']) ? $request['orcl_address'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_check_car_state' => isset($request['orcl_check_car_state']) ? $request['orcl_check_car_state'] : 2, //是否验车：1是2否
            'orcl_shipment_party' => isset($request['orcl_shipment_party']) ? $request['orcl_shipment_party'] : 1, //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_car_vehicle_type' => isset($request['orcl_car_vehicle_type']) ? $request['orcl_car_vehicle_type'] : '', //车型
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];
        if (!empty($request['orcl_car_num'])) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $request['ord_client_id'])
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $request['meca_car_frame'] = $request['orcl_car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        }
        // 接车时间
        if (isset($request['orcl_pick_up_car_time'])) {
            $orcl_data['orcl_pick_up_car_time'] = $request['orcl_pick_up_car_time'];
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);

        // 提交的订单商品项目数据
        if ($type == 3 || $type == 1) {
            $goods_data = json_decode($request['goods_data'], true);
        } else {
            $goods_data = $request['goods_data'];
        }
        if (!empty($goods_data)) {
            $order_items = []; //订单项目数据
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            $neaten_goods_data = []; //整理后的仓库商品库存数据

            // 新增订单商品数据
            foreach ($goods_data as $key => $value) {
                if (!isset($value['goo_waon_class'])) {
                    $value['goo_waon_class'] = 1;
                    $goods_data[$key]['goo_waon_class'] = 1;
                }
                if (!isset($value['goo_type'])) {
                    $value['goo_type'] = 1;
                    $goods_data[$key]['goo_type'] = 1;
                }
                if (!isset($value['goo_inventory'])) {
                    $value['goo_inventory'] = 1;
                    $goods_data[$key]['goo_inventory'] = 1;
                }
                if (!isset($value['wago_id'])) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->value('wago_id');
                    $value['wago_id'] = $find_wago_id;
                    $goods_data[$key]['wago_id'] = $find_wago_id;
                }
                if (empty($value['sepr_id'])) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'请完善服务信息01'];
                }
                if (!empty($value['goo_id'])) {
                    if (empty($value['goo_id'])  || $value['goo_quantity'] < 0 || !is_numeric($value['wago_id']) || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1, 3, 4, 5, 6, 7, 8]) || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2]) || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'请完善服务信息02'];
                    }
                    $orgo_data['orgo_ord_id'] = $ord_id;
                    $orgo_data['orgo_order_number'] = $ord_order_number;
                    $orgo_data['orgo_ware_id'] = $request['ware_id'];
                    $orgo_data['orgo_wago_id'] = $value['wago_id'];
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_name'] = $value['goo_name'];
                    $orgo_data['orgo_goo_type'] = $value['goo_type'];
                    $orgo_data['orgo_goo_inventory'] = $value['goo_inventory'];
                    $orgo_data['orgo_state'] = $value['goo_state'];
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                    $goods_data[$key]['orgo_id'] = $orgo_id; //立即派单使用
                    $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    $goo_unit_conversion = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_unit_conversion');
                }
                $goo_all_price += $value['service_price']; //总金额


                $order_items[$key]['orit_shop_id'] = $user_info->adm_shop_id;
                $order_items[$key]['orit_ord_id'] = $ord_id;
                $order_items[$key]['orit_orgo_id'] = isset($orgo_id) ? $orgo_id : '';
                $order_items[$key]['orit_sepr_id'] = $value['sepr_id'];
                $order_items[$key]['orit_sepr_name'] = $value['sepr_name'];
                $order_items[$key]['orit_service_price'] = $value['service_price'] * 100;
                $order_items[$key]['orit_service_adm_id'] = !empty($value['service_adm_id']) ? $value['service_adm_id'] : 0;
                if (!empty($value['ord_remark'])) {
                    $ord_edit_data['ord_remark'] = $value['ord_remark'];
                    $ord_edit_data['ord_explain'] = $value['ord_remark'];
                }
                if (!empty($value['ord_explain'])) {
                    $ord_edit_data['ord_explain'] = $value['ord_explain'];
                }
                // 添加客户消息
                $add_data['weus_id'] = $weus_id;
                $add_data['shop_id'] = $user_info->adm_shop_id;
                $add_data['primary_id'] = $ord_id; //单据的主键id
                $add_data['primary_type'] = 1; //单据类型：1订单2工单3预约单4售后单
                $add_data['read_state'] = 1; //阅读状态：1未读2已读
                $add_data['title'] = '预约成功通知';//消息标题
                $add_data['content'] = '您申请的'.$value['sepr_name'].'服务已预约成功，我们会尽快处理，请耐心等待'; //操作内容
                $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
                $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
                $addUserMessage_res = addUserMessage($add_data);
                unset($add_data);
                // 2.给相应的客户发送短信
                $phone = $request['orcl_phone'];
                $message = '【半径服务】尊敬的客户您好，您申请的'.$value['sepr_name'].'服务已预约成功，请登录(半径服务)小程序查看';
                if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                    $find_shop_data = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->first();
                    if ($find_shop_data->shop_message_num <= 0) {
                        $send_state = 2;
                        $send_res = 0;
                    } else {
                        $send_res = sendSmsCode($phone, $message);
                        if ($send_res > 0) {
                            $send_state = 1;
                            $update_shop = DB::table('shop')
                                ->where('shop_id', $user_info->adm_shop_id)
                                ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                        } else {
                            $send_state = 2;
                        }
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = $ord_id; //订单id
                    $seme_data['seme_name'] = '预约成功通知'; //模板名称
                    $seme_data['seme_phone'] = $phone; //手机号
                    $seme_data['seme_content'] = $message; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);
                }
            }
            $orit_res = DB::table('wash_order_items')->insert($order_items);

            $ord_edit_data['ord_order_price'] = $goo_all_price * 100;
            $ord_edit_data['ord_actual_price'] = $goo_all_price * 100;
            $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity;
        } else {
            $orit_res = true;
        }
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $ord_id)->update($ord_edit_data);

        // if (!empty($request['reli_id'])) {
        //     // 预约单信息
        //     $find_reli_data = DB::table('wash_reservation_list as reli')
        //         ->leftJoin('wash_reservation_client as recl', 'reli.reli_id', '=', 'recl.recl_reli_id')
        //         ->where('reli_id', $request['reli_id'])
        //         ->select('reli_number', 'reli_shop_id', 'reli_client_id')
        //         ->first();
        //     // 客户小程序-微信用户id
        //     $weus_id = DB::table('user_shop')
        //         ->where('ussh_shop_id', $find_reli_data->reli_shop_id)
        //         ->where('ussh_user_id', $find_reli_data->reli_client_id)
        //         ->value('ussh_weus_id');
        //     if ($weus_id) {
        //         // 添加客户消息
        //         $add_data['weus_id'] = $weus_id;
        //         $add_data['shop_id'] = $find_reli_data->reli_shop_id;
        //         $add_data['primary_id'] = $request['reli_id']; //单据的主键id
        //         $add_data['primary_type'] = 3; //单据类型：1订单2工单3预约单4售后单
        //         $add_data['read_state'] = 1; //阅读状态：1未读2已读
        //         $add_data['title'] = '预约成功通知'; //阅读状态：1未读2已读
        //         $add_data['content'] = '您的预约单：' . $find_reli_data->reli_number . '接单成功,接单人：' . $user_info->adm_name; //操作内容
        //         $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
        //         $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
        //         $addUserMessage_res = addUserMessage($add_data);
        //         unset($add_data);
        //     } else {
        //         $addUserMessage_res['code'] = 200;
        //     }
        //     if ($addUserMessage_res['code'] != 200) {
        //         return $addUserMessage_res;
        //     }
        // }
        if ($ord_id && $orcl_id && $ord_edit_res && $orit_res && $return_car_data['code'] == 200) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['goods_data'] = json_encode($goods_data); //商品信息
            $return_data['ord_type'] = $request['ord_type']; //买家类型1.会员零售2.客户单位3.速电派单4.第三方派单
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增失败'];
        }
    }

    // 编辑查询
    public static function editShow($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'ord_create_id', 'ord_ware_id', 'orcl_sales_adm_id', 'ord_is_split', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain', 'orcl_mem_source')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        // 获取该订单下的商品信息
        // $goods_data = DB::table('order_goods as orgo')
        //     ->leftjoin('wash_order_items as woi', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
        $goods_data = DB::table('wash_order_items as woi')
            ->leftjoin('order_goods as orgo', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orit_ord_id', $request['ord_id'])
            // ->where('orgo_ord_id', $request['ord_id'])
            // ->where('orgo_state', '!=', 2)
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orit_id', 'orit_sepr_id', 'orit_sepr_name', 'orit_service_price', 'orit_service_adm_id', 'orgo_wago_id', 'orgo_goo_unit', 'orgo_goo_unta_id', 'goo_unit_conversion')
            ->get()->toArray();
        $service_adm_id = array_column($goods_data, 'orit_service_adm_id'); //服务技师id
        // 账号id
        $pick_adm_id[] = $info->orcl_pick_up_car_adm_id;
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->orcl_sales_adm_id;
        $ware_id[] = $info->ord_ware_id;
        $adm_id = array_merge($adm_id, $service_adm_id);
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $pick_adm_name = DB::table('admin')
            ->whereIn('adm_id', $pick_adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        // 查询仓库名称
        $ware_name = DB::table('warehouse')
            ->whereIn('ware_id', $ware_id)
            ->pluck('ware_name', 'ware_id')
            ->toArray();

        // 接车人
        $info->orcl_pick_up_car_adm_name = '';
        if ($info->orcl_pick_up_car_adm_id) {
            $info->orcl_pick_up_car_adm_name = $pick_adm_name[$info->orcl_pick_up_car_adm_id]; //接车人
        }
        // 销售人
        $info->orcl_sales_adm_name = '';
        if ($info->orcl_sales_adm_id) {
            $info->orcl_sales_adm_name = $adm_name[$info->orcl_sales_adm_id]; //销售人
        }
        $info->ord_create_adm_name = '';
        if ($info->ord_create_id) {
            $info->ord_create_adm_name = $adm_name[$info->ord_create_id]; //录单人
        }
        $info->ord_ware_name = '';
        if ($info->ord_ware_id) {
            $info->ord_ware_name = $ware_name[$info->ord_ware_id]; //仓库名称
        }

        foreach ($goods_data as $key => $value) {
            $goods_data[$key]->service_adm_name = isset($adm_name[$value->orit_service_adm_id]) ? $adm_name[$value->orit_service_adm_id] : '';
        }
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 编辑
    public static function edit($user_info, $request, $order_data)
    {
        if ($request['ord_type'] == '2') {
            // 客户单位的业务员
            $chun_adm_id = DB::table('channel_unit')
                ->where('chun_id', $request['ord_client_id'])
                ->value('chun_adm_id');
            if (empty($chun_adm_id)) {
                $chun_adm_id = 0;
            }
        } else {
            $chun_adm_id = 0;
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_adm_id' => $chun_adm_id, //业务员id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '',// 销售人员id
            'orcl_channel_unit' => isset($request['orcl_channel_unit']) ? $request['orcl_channel_unit'] : '',
            'orcl_name' => $request['orcl_name'],//客户姓名
            'orcl_phone' => $request['orcl_phone'],//客户电话
            'orcl_carowner_name' => $request['orcl_carowner_name'],//车主姓名
            'orcl_carowner_phone' => $request['orcl_carowner_phone'],//车主电话
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_province' => isset($request['orcl_province']) ? $request['orcl_province'] : '',
            'orcl_city' => isset($request['orcl_city']) ? $request['orcl_city'] : '',
            'orcl_county' => isset($request['orcl_county']) ? $request['orcl_county'] : '',
            'orcl_address' => isset($request['orcl_address']) ? $request['orcl_address'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_check_car_state' => isset($request['orcl_check_car_state']) ? $request['orcl_check_car_state'] : 2, //是否验车：1是2否
            'orcl_shipment_party' => isset($request['orcl_shipment_party']) ? $request['orcl_shipment_party'] : 1, //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_car_vehicle_type' => isset($request['orcl_car_vehicle_type']) ? $request['orcl_car_vehicle_type'] : '', //车型
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        if (!empty($request['orcl_car_num'])) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $request['ord_client_id'])
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $request['meca_car_frame'] = $request['orcl_car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        if ($return_car_data['code'] != 200) {
            return $return_car_data;
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        } else {
            $orcl_data['orcl_appoint_time'] = '0000-00-00 00:00:00';
        }
        // 接车时间
        if (isset($request['orcl_pick_up_car_time'])) {
            $orcl_data['orcl_pick_up_car_time'] = $request['orcl_pick_up_car_time'];
        } else {
            $orcl_data['orcl_pick_up_car_time'] = '0000-00-00 00:00:00';
        }
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            if ($request['ord_type'] == 1) { //买家类型：1会员零售
                // 零售，会员表
                $client_res = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->increment('mem_order_all');
            } else {
                $client_res = true;
            }
        } else {
            if ($request['ord_type'] == 2) { //买家类型：2客户单位
                // 1. 判断客户单位名称是否存在
                $find_chun = DB::table('channel_unit')
                    ->where('chun_cid', $user_info->adm_cid)
                    ->where('chun_shop_id', $user_info->adm_shop_id)
                    ->where('chun_superior_shop_id', $shop_id)
                    ->where('chun_unit_name', $request['orcl_channel_unit'])
                    ->first(['chun_id']);
                if ($find_chun) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'客户单位已存在，生成订单失败'];
                }

                // 2 新增一个客户单位
                $chun_add_data['chun_cid'] = $user_info->adm_cid;
                $chun_add_data['chun_shop_id'] = $user_info->adm_shop_id;
                $chun_add_data['chun_superior_shop_id'] = $shop_id;
                $chun_add_data['chun_adm_id'] = $user_info->adm_id;
                $chun_add_data['chun_search_letter'] = '';
                $chun_add_data['chun_unit_name'] = $request['orcl_channel_unit'];
                $chun_add_data['chun_name'] = $request['orcl_name'];
                $chun_add_data['chun_phone'] = $request['orcl_phone'];
                $chun_add_data['chun_chty_id'] = 0;
                $chun_add_data['chun_state'] = 1;
                $chun_add_data['chun_payment_way'] = $request['ord_payment_way'];
                $chun_add_data['chun_province'] = $request['orcl_province'];
                $chun_add_data['chun_city'] = $request['orcl_city'];
                $chun_add_data['chun_county'] = $request['orcl_county'];
                $chun_add_data['chun_address'] = $request['orcl_address'];
                $chun_add_data['chun_img'] = '';
                $chun_res =  DB::table('channel_unit')->insertGetId($chun_add_data);

                $request['ord_client_id'] = $chun_res;
                $chin_add_data['chin_chun_id'] = $chun_res;
                $chin_data[0]['key'] = $request['orcl_name'];
                $chin_data[0]['value'] = $request['orcl_phone'];
                $chin_data[0]['default'] = 1;
                $chin_add_data['chin_data'] = json_encode($chin_data);
                $chin_add_data['chin_level'] = 'A';
                $chin_add_data['chin_prec_id'] = 0; //业务划区id
                $chin_add_data['chin_remarks'] = $request['orcl_remarks'];
                $chin_add_data['chin_main_brand'] = '';
                $chin_add_data['chin_second_brand'] = '';
                $chin_add_data['chin_longitude'] =  0; //经度
                $chin_add_data['chin_latitude'] = 0; //维度
                $chin_res =  DB::table('channel_info')->insert($chin_add_data);
                if (!$chin_res || !$chun_res) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增客户单位失败'];
                }
                $client_res = true;
            } else {
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_name'] = $request['orcl_name'] ?? '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code"=>500, 'msg'=>'error', 'data'=>'当前手机号已存在'];
                    }
                }
                $eme['mem_phone'] = $request['orcl_phone'] ?? '';
                $eme['mem_car_num'] = $request['orcl_car_num'] ?? '';
                $eme['mem_car_model'] = $request['orcl_car_vehicle_type'] ?? ''; //车型
                $eme['mem_province'] = $request['orcl_province'] ?? ''; //省
                $eme['mem_city'] = $request['orcl_city'] ?? ''; //市
                $eme['mem_county'] = $request['orcl_county'] ?? ''; //县
                $eme['mem_address'] = $request['orcl_address'] ?? ''; //详细地址
                $eme['mem_order_all'] = 1; //订单数
                $mem_id = DB::table('member')->insertGetId($eme);
                WashOrderService::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;
                $client_res = true;
                // 查询手机号是否存在
                $find_weixin_data = DB::table('weixin_user')
                    ->where('weus_phone', $request['orcl_phone'])
                    ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
                    ->first();
                if (empty($find_weixin_data)) {
                    // 不存在就新增用户
                    $weus_data['weus_phone'] = $request['orcl_phone'];
                    $weus_data['weus_nickmame'] = $request['orcl_name'];
                    $weus_data['weus_follow'] = 1;
                    $weus_data['weus_sex'] = 0;
                    $weus_data['weus_province'] = '';
                    $weus_data['weus_city'] = '';
                    $weus_data['weus_headimgurl'] = '';
                    $weus_data['weus_update_time'] = date('Y-m-d H:i:s');
                    $weus_id = DB::table('weixin_user')->insertGetId($weus_data);
                    if (!$weus_id) {
                        return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
                    }
                    unset($weus_data['weus_update_time']);
                } else {
                    // 更新微信用户信息
                    $edit_weus['weus_phone'] = $request['orcl_phone'];
                    $edit_weus['weus_nickmame'] = $request['orcl_name'];
                    if (!empty($request['weus_headimgurl'])) {
                        $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                    }
                    $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                    $edit_weus_res = DB::table('weixin_user')
                        ->where('weus_id', $find_weixin_data->weus_id)
                        ->update($edit_weus);
                    unset($edit_weus);
                    $weus_id = $find_weixin_data->weus_id;
                }

                // 查询微信用户与门店的关系是否存在绑定关系
                $find_user_shop_data = DB::table('user_shop')
                    ->where('ussh_weus_id', $weus_id)
                    ->where('ussh_shop_id', $user_info->adm_shop_id)
                    ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                    ->first();

                if (empty($find_user_shop_data)) {
                    // 用户没有与当前门店绑定，把用户与当前门店绑定
                    $ussh_data['ussh_user_id'] = $mem_id;
                    $ussh_data['ussh_weus_id'] = $weus_id;
                    $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
                    $ussh_data['ussh_user_type'] = 1;
                    $ussh_data['ussh_phone'] = $request['orcl_phone'];
                    $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                    if (!$ussh_id) {
                        return ['code'=>500, 'msg'=>'新增失败2', 'data'=>''];
                    }
                } else {
                    if (empty($find_user_shop_data->ussh_user_id)) {
                        $ussh_data['ussh_user_type'] = 1;
                        $ussh_data['ussh_phone'] = $request['orcl_phone'];
                        $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                        $ussh_id = DB::table('user_shop')
                            ->where('ussh_id', $find_user_shop_data->ussh_id)
                            ->update($ussh_data);
                    }
                }
            }
        }
        $orcl_id = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($orcl_data);

        // // 删除订单之前的商品、项目数据
        // $delete_res = DB::table('order_goods as orgo')
        //     ->leftjoin('wash_order_items as woi', 'woi.orit_ord_id', '=', 'orgo.orgo_ord_id')
        //     ->where('orgo_ord_id', $request['ord_id'])
        //     ->delete();

        // 提交的订单商品项目数据
        $goods_data = json_decode($request['goods_data'], true);
        $goo_all_price = 0; //商品总金额
        $goo_all_quantity = 0; //商品总数量

        $request_wago_id = [];
        // 判断提交的商品参数
        if (!empty($goods_data)) {
            foreach ($goods_data as $key => $value) {
                if (!empty($value['goo_id'])) {
                    if (!isset($value['goo_waon_class'])) {
                        $value['goo_waon_class'] = 1;
                        $goods_data[$key]['goo_waon_class'] = 1;
                    }
                    if (!isset($value['wago_id'])) {
                        $find_wago_id = DB::table('warehouse_goods')
                            ->where('wago_goo_id', $value['goo_id'])
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_ware_id', $request['ware_id'])
                            ->value('wago_id');
                        $value['wago_id'] = $find_wago_id;
                        $goods_data[$key]['wago_id'] = $find_wago_id;
                    }
                    if (!isset($value['wafg_id'])) {
                        $value['wafg_id'] = 0;
                        $goods_data[$key]['wafg_id'] = 0;
                    }
                    if (!isset($value['goo_inventory'])) {
                        $value['goo_inventory'] = 1;
                        $goods_data[$key]['goo_inventory'] = 1;
                    }
                    // goo_state 商品状态1正常3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    $goo_unit_conversion = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_unit_conversion');
                    if ($value['goo_state'] != 4) {
                        $request_wago_id[] = $value['wago_id'];
                        $goo_all_quantity += $value['goo_quantity'];
                        if ($value['goo_unta_id'] == 1) {
                            $goo_all_quantity += $value['goo_quantity'] * $goo_unit_conversion;
                        }
                    }
                }
            }
        }
        // 编辑订单相关数据
        $ord_edit_return = self::editOrderData($user_info, $request, $order_data, $goods_data);
        if ($ord_edit_return['code'] == 500) {
            return $ord_edit_return;
        }
        $goods_data = $ord_edit_return['return_datas'];
        return ['code'=>200, 'msg'=>'success', 'data'=>''];
    }

        /**
     * [editOrderData 编辑订单相关数据]
     * @param  [type] $user_info  [用户信息]
     * @param  [type] $request    [编辑提交数据]
     * @param  [type] $order_data [订单信息]
     * @param  [type] $goods_data [订单提交的商品数据]
     * @return [type]             [description]
     */
    public static function editOrderData(
        $user_info,
        $request,
        $order_data,
        $goods_data
    ) {
        // 2. 编辑订单商品表数据
        // 2.1 删除原来的订单商品数据
        $orgo_del_res = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->delete();
        $orit_del_res = DB::table('wash_order_items')
            ->where('orit_ord_id', $request['ord_id'])
            ->delete();
        // 订单类型不是发货单
        if ($request['ord_service_type'] != 5) {
            // 查询发货单数据
            $find_dego_data = DB::table('dispatch_bill')
                ->where('dego_order_type', 1)
                ->where('dego_wor_id', $request['ord_id'])
                ->where('dego_original_number', $order_data->ord_order_number)
                ->orderBy('dego_id', 'desc')
                ->first(['dego_id', 'dego_type', 'dego_out_ware_id', 'dego_count', 'dego_number']);
            if (!empty($find_dego_data)) {
                // 删除发货单的商品
                $find_digo_data = DB::table('dispatch_goods')
                    ->where('digo_dego_id', $find_dego_data->dego_id)
                    ->delete();
                // 删除发货单的数据
                $del_dibi_res = DB::table('dispatch_bill')
                    ->where('dego_id', $find_dego_data->dego_id)
                    ->where('dego_order_type', 1)
                    ->delete();
            }
        }
        // 订单类型不是退货单
        if ($request['ord_service_type'] != 4) {
            // 查询退货单数据
            $find_rec_id = DB::table('recede_recycle')
                ->where('rec_state', 1)
                ->where('rec_ord_id', $request['ord_id'])
                ->where('rec_ord_order_number', $order_data->ord_order_number)
                ->value('rec_id');
            if (!empty($find_rec_id)) {
                // 删除退换回收商品数据
                $del_rego_res = DB::table('recede_goods')
                    ->where('rego_rec_id', $find_rec_id)
                    ->delete();
                // 删除退换入库客户表数据
                $del_recl_data = DB::table('recede_client')
                    ->where('recl_rec_id', $find_rec_id)
                    ->delete();
                // 删除退换回收数据
                $del_rec_data = DB::table('recede_recycle')
                    ->where('rec_id', $find_rec_id)
                    ->delete();
            }
        }

        // 2.2 添加新的订单商品数据
        $goo_all_quantity = 0; //商品总数量
        $goo_all_price = 0; //商品总金额
        $goo_collection_price = 0; //商品代收总金额
        // 救援单的服务项目金额
        $orcl_rescue_service_price = isset($request['orcl_rescue_service_price']) ? $request['orcl_rescue_service_price'] : 0;
        // 救援单的代收金额
        $orcl_rescue_collection_price = isset($request['orcl_rescue_collection_price']) ? $request['orcl_rescue_collection_price'] : 0;
        $orcl_rescue_assign_price = isset($request['orcl_rescue_assign_price']) ? $request['orcl_rescue_assign_price'] : 0;
        $goo_assign_all_price = 0; //商品派单总金额

        if (!empty($goods_data)) {
            $n = 0;
            foreach ($goods_data as $key => $value) {
                $request['service_sepr_id'] = $value['sepr_id'];
                if (!empty($value['goo_id'])) {
                    if (!isset($value['goo_assign_price'])) {
                        $value['goo_assign_price'] = 0;
                    }
                    if (!is_numeric($value['wago_id']) || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1, 3, 4, 5, 6, 7, 8]) || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2])  || !is_numeric($value['goo_assign_price']) || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'商品参数类型错误'];
                    }
                    // 搜索商品id对应的商品名称、商品编号
                    $find_goods_data = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->select('goo_name', 'goo_goods_encode', 'goo_type', 'goo_ampere_hour', 'goo_price', 'goo_fid', 'goo_class')
                        ->first();
                    if ($find_goods_data->goo_class == 1) { //类型：1自营商品2系统商品
                        // 查询商品附属表
                        $goaf_another_name = DB::table('goods_affiliate')
                            ->where('goaf_goo_id', $value['goo_id'])
                            ->where('goaf_shop_id', $user_info->adm_shop_id)
                            ->value('goaf_another_name');
                        if (!empty($goaf_another_name)) {
                            $find_goods_data->goo_name = $goaf_another_name;
                        }
                    } else {
                        // 查询系统商品属性表
                        $gosa_another_name = DB::table('goods_system_affiliate')
                            ->where('gosa_goo_id', $value['goo_id'])
                            ->where('gosa_shop_id', $user_info->adm_shop_id)
                            ->value('gosa_another_name');
                        if (!empty($gosa_another_name)) {
                            $find_goods_data->goo_name = $gosa_another_name;
                        }
                    }
                    // goo_state 商品状态1.正常 2.删除3.回收的商品4.换货商品5.赠品商品6.备用电池7.临时商品8.旧货商品
                    // 换货商品金额处理
                    if ($value['goo_state'] == 1) {
                        // 订单商品
                        $goo_all_quantity += $value['goo_quantity']; //商品总数量
                        $cost_price = 0;
                        $sell_res = true;
                    }

                    // 订单商品表
                    $orgo_data['orgo_ord_id'] = $request['ord_id'];
                    $orgo_data['orgo_order_number'] = $order_data->ord_order_number;
                    $orgo_data['orgo_ware_id'] = $request['ware_id'] ? $request['ware_id'] : 0;
                    $orgo_data['orgo_wago_id'] = $value['wago_id'];
                    $orgo_data['orgo_wafr_id'] = isset($value['wafr_id']) ? $value['wafr_id'] : 0;
                    $orgo_data['orgo_wafg_id'] = isset($value['wafg_id']) ? $value['wafg_id'] : 0;
                    $orgo_data['orgo_waon_class'] = $value['goo_waon_class'];
                    $orgo_data['orgo_actual_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];

                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_goo_inventory'] = $value['goo_inventory'];
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    if (!empty($value['tem_goo_name'])) {
                        $orgo_data['orgo_tem_goo_name'] = $value['tem_goo_name'];
                    } else {
                        $orgo_data['orgo_tem_goo_name'] = '';
                    }
                    $orgo_data['orgo_goo_name'] = $find_goods_data->goo_name;
                    $orgo_data['orgo_goo_goods_encode'] = $find_goods_data->goo_goods_encode;
                    $orgo_data['orgo_goo_type'] = $find_goods_data->goo_type;
                    $orgo_data['orgo_goo_ampere_hour'] = $find_goods_data->goo_ampere_hour;
                    $orgo_data['orgo_state'] = $value['goo_state'];
                    if ($request['orcl_shipment_party'] == 4 || $request['orcl_shipment_party'] == 5) {
                        $orgo_data['orgo_assign_price'] = $value['goo_assign_price'] * 100;
                    }
                    $orgo_res = DB::table('order_goods')->insertGetId($orgo_data);
                } else {
                    $orgo_res = 0;
                }
                $goo_all_price += $value['service_price'];
                $goods_data[$key]['orgo_id'] = $orgo_res;
                $order_items[$key]['orit_shop_id'] = $user_info->adm_shop_id;
                $order_items[$key]['orit_ord_id'] = $request['ord_id'];
                $order_items[$key]['orit_orgo_id'] = $orgo_res;
                $orgo_res = true;
                $order_items[$key]['orit_sepr_id'] = $value['sepr_id'];
                $order_items[$key]['orit_sepr_name'] = $value['sepr_name'];
                $order_items[$key]['orit_service_price'] = $value['service_price'] * 100;
                $order_items[$key]['orit_service_adm_id'] = !empty($value['service_adm_id'])?$value['service_adm_id']:'';
                if (!empty($value['ord_remark'])) {
                    $ord_edit_data['ord_remark'] = $value['ord_remark'];
                    $request['ord_remark'] = $value['ord_remark'];
                    $ord_edit_data['ord_explain'] = $value['ord_remark'];
                }
            }
            $orit_res = DB::table('wash_order_items')->insert($order_items);
        } else {
            $orgo_res = true;
        }

        // 4. 更改订单表客户id、订单金额
        $ord_edit_data['ord_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0; //仓库id
        $ord_edit_data['ord_client_id'] = $request['ord_client_id']; //选择客户id
        $ord_edit_data['ord_service_type'] = $request['ord_service_type']; //订单类型：1服务单 2销售单 3换货单 4退货单 
        $ord_edit_data['ord_wor_state'] = 1; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单

        $goo_all_price = $goo_all_price + ($orcl_rescue_service_price); //合计金额=商品总金额+服务项目的订单金额
        $goo_order_price = $goo_all_price; //订单总金额
        // 4. 更改订单表客户id、订单金额
        $ord_edit_data['ord_payment_way'] = $request['ord_payment_way']; // 结算方式1.账期 2.现结 3微信 4支付宝
        $ord_edit_data['ord_order_price'] = $goo_order_price * 100; // 订单金额（单位：分）
        $ord_edit_data['ord_actual_price'] = $goo_all_price * 100; // 结算金额（单位：分）
        $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity; // 商品总数量
        $ord_edit_data['orcl_assign_price'] = $goo_assign_all_price * 100; // 结算金额（单位：分）
        $ord_edit_data['ord_type'] = $request['ord_type']; // 订单类型：1门店零售2渠道单位
        $ord_edit_data['ord_service_adm_id'] = isset($request['service_adm_id']) ? $request['service_adm_id'] : ''; //服务技师id
        $ord_edit_data['ord_service_sepr_id'] = $request['service_sepr_id']; //服务项目id
        $ord_edit_data['ord_province'] = $request['ord_province']; //施工地址省
        $ord_edit_data['ord_city'] = $request['ord_city']; //市
        $ord_edit_data['ord_county'] = $request['ord_county']; //县区
        $ord_edit_data['ord_address'] = $request['ord_address']; //详细地址
        // 服务门店为0的话 是当前门店id
        $ord_edit_data['ord_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_eidt_res = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_edit_data);

        // 添加订单备注
        if (!empty($request['ord_remark'])) {
            $wor_remark = orderRemark($user_info, $request['ord_id'], 0, $request['ord_remark'], '订单编辑');
        } else {
            $wor_remark = true;
        }
        if ($ord_eidt_res && $orgo_res && $wor_remark) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'编辑订单成功', 'return_datas'=>$goods_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑订单失败3'];
        }
    }

        /**
     * [editOrderLockStockGoods 编辑订单锁定商品库存]
     * @param  [type] $user_info  [用户信息]
     * @param  [type] $request    [编辑提交数据]
     * @param  [type] $order_data [订单信息]
     * @param  [type] $goods_data [订单提交的商品数据]
     * @return [type]             [description]
     */
    public static function editOrderLockGoodsStock(
        $user_info,
        $request,
        $order_data,
        $goods_data,
        $request_wago_id,
        $goo_all_quantity
    ) {
        // 判断编辑的订单类型是不是退货单
        if ($request['ord_service_type'] == 4) { //订单类型：4退货单
            // 判断原来的订单类型是否为退货单
            if ($order_data->ord_service_type == 4) {
                return ['code'=>200, 'msg'=>'success', 'return_data'=>[]];
            } else {
                // 如果原来的订单不是退货单，要把之前的商品锁定库存数量还回去
                // 如果是发货单，要把发货单相关数据删除
                if ($order_data->ord_service_type == 5) { //订单类型: 5发货单
                    // 原来的发货单数据删除
                    $find_dego_data = DB::table('dispatch_bill')
                        ->where('dego_order_type', 1)
                        ->where('dego_wor_id', $request['ord_id'])
                        ->where('dego_original_number', $order_data->ord_order_number)
                        ->orderBy('dego_id', 'desc')
                        ->first(['dego_id', 'dego_type', 'dego_out_ware_id', 'dego_count', 'dego_number']);
                    if (!empty($find_dego_data)) {
                        // 删除发货单的商品
                        $del_dego_res = DB::table('dispatch_goods')
                            ->where('digo_dego_id', $find_dego_data->dego_id)
                            ->delete();
                        // 删除发货单的数据
                        $del_dibi_res = DB::table('dispatch_bill')
                            ->where('dego_id', $find_dego_data->dego_id)
                            ->delete();
                        if (!$del_dego_res || !$del_dibi_res) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑订单失败1'];
                        }
                    }
                }
                // 查询原来订单商品表数据
                $find_order_goods = DB::table('order_goods')
                    ->where('orgo_ord_id', $request['ord_id'])
                    ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_actual_goo_id', 'orgo_wago_id', 'orgo_goo_id', 'orgo_state', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id')
                    ->get()->toArray();
                // 查询仓库id是否为移动仓库，移动仓库没有锁定库存
                // ware_type 类型：1固定仓2技师库3移动仓
                $ware_type = DB::table('warehouse')
                    ->where('ware_id', $order_data->ord_ware_id)
                    ->value('ware_type');
                // 取消锁定库存
                $lock_turn_normal = Order::cancelOrderChangeWafgstock(
                    $user_info,
                    $ware_type,
                    $request,
                    $find_order_goods,
                    $order_data
                );
                // 仓库商品锁定表中没有商品数据默认删除
                $wagl_id = DB::table('warehouse_goods_lock')
                    ->where('wagl_shop_id', $user_info->adm_shop_id)
                    ->where('wagl_original_id', $request['ord_id'])
                    ->where('wagl_original_number', $order_data->ord_order_number)
                    ->value('wagl_id');
                if ($wagl_id) {
                    $wagl_del = DB::table('warehouse_goods_lock')
                        ->where('wagl_shop_id', $user_info->adm_shop_id)
                        ->where('wagl_original_id', $request['ord_id'])
                        ->where('wagl_original_number', $order_data->ord_order_number)
                        ->delete();
                } else {
                    $wagl_del = true;
                }
                if ($lock_turn_normal['code'] == 500) {
                    DB::rollBack();
                    return ['code'=>500, 'msg'=>'error', 'data'=>'编辑订单失败4'];
                }
                return ['code'=>200, 'msg'=>'success', 'return_data'=>[]];
            }
        }
        // 订单类型不是退货单或发货单,锁定库存数量还回仓库
        // 查询原来订单商品表数据
        $find_order_goods = DB::table('order_goods as orgo')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_state', 'orgo_wago_id as wago_id', 'orgo_goo_id', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_inventory', 'orgo_goo_unta_id', 'orgo_goo_unit', 'goo_unit_conversion')
            ->get()->toArray();
        $find_order_goods = json_decode(json_encode($find_order_goods, true), true);
        $find_orgo_data = [];
        $find_goo_quantity = 0;
        $find_orgo_wago_id = [];

        foreach ($find_order_goods as $key => $value) {
            // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
            if (isset($find_orgo_data[$value['wago_id']][$value['orgo_goo_inventory']])) {
                if ($value['orgo_goo_unta_id'] == 1) {
                    $find_orgo_data[$value['wago_id']][$value['orgo_goo_inventory']]['goo_quantity'] += $value['goo_quantity'] * $value['goo_unit_conversion'];
                } else {
                    $find_orgo_data[$value['wago_id']][$value['orgo_goo_inventory']]['goo_quantity'] += $value['goo_quantity'];
                }
            } else {
                if ($value['orgo_goo_unta_id'] == 1) {
                    $find_orgo_data[$value['wago_id']][$value['orgo_goo_inventory']]['goo_quantity'] = $value['goo_quantity'] * $value['goo_unit_conversion'];
                } else {
                    $find_orgo_data[$value['wago_id']][$value['orgo_goo_inventory']]['goo_quantity'] = $value['goo_quantity'];
                }
            }
            $find_orgo_wago_id[] = $value['wago_id'];
            if ($value['orgo_goo_unta_id'] == 1) {
                $find_goo_quantity += $value['goo_quantity'] * $value['goo_unit_conversion'];
            } else {
                $find_goo_quantity += $value['goo_quantity'];
            }
        }
        // 判断编辑提交的仓库商品id与原来订单商品表中的仓库商品id是否一样,并且仓库id也相同的,并且商品数量也相同的
        // array_diff() 函数用于比较两个（或更多个）数组的值，并返回差集
        // 比较两个商品id数组是否有差集，没有差集的就是没有更改商品
        if (!array_diff($request_wago_id, $find_orgo_wago_id) && $request['ware_id'] == $order_data->ord_ware_id && $find_goo_quantity == $goo_all_quantity && $order_data->ord_service_type != 4 && ($find_orgo_data == $goods_data)) {
            // 两个数组互相不存在差集，那这两个数组的值是相同的
            // 商品id一样并且仓库id也一样，不用更改锁定库存
            return ['code'=>200, 'msg'=>'success', 'return_data'=>[]];
        }
        // 商品id不一样，更改锁定库存
        // 判断选择的仓库是否为技师库，技师库不需要更改商品库存数量
        $find_ware_id[] = $request['ware_id'];
        $find_ware_id[] = $order_data->ord_ware_id;
        $find_ware_id = array_unique($find_ware_id);
        // ware_type 类型：1固定仓2技师库3移动仓
        $find_ware_data = DB::table('warehouse')
            ->whereIn('ware_id', $find_ware_id)
            ->pluck('ware_type', 'ware_id')->toArray();
        $return_data = [];
        // 原来订单有商品，原来的不是技师库，原来订单商品表中的锁定库存减少，正常库存增加
        if ($find_goo_quantity && $find_ware_data[$order_data->ord_ware_id] != 2 && $order_data->ord_service_type != 4  && $order_data->orcl_shipment_party != 4) {
            // 查询订单商品信息
            $find_orgo_data = DB::table('order_goods as orgo')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->where('orgo_ord_id', $request['ord_id'])
                ->whereNotIn('orgo_state', [2, 3, 4])
                ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id', 'orgo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            $lock_turn_normal = Order::cancelOrderChangeWafgstock(
                $user_info,
                $find_ware_data[$order_data->ord_ware_id],
                $request,
                $find_orgo_data,
                $order_data
            );
            if ($lock_turn_normal['code'] == 500) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'编辑订单失败5'];
            }
        }

        // 编辑订单有商品，选择的固定仓库，编辑提交的商品id的正常库存减少，锁定库存增加
        if ($goo_all_quantity && $find_ware_data[$request['ware_id']] != 2 && $request['ord_service_type'] != 4  && $request['orcl_shipment_party'] != 4 && $request['orcl_shipment_party'] != 5) {
            // 查询固定仓库库存商品信息
            $find_warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $request['ware_id'])
                ->whereIn('wago_id', $request_wago_id)
                ->select('wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_lock_quantity', 'wago_priority_lock_quantity')
                ->get()->toArray();
            $warehouse_goods = array_column($find_warehouse_goods, null, 'wago_id');
            $goods_data = [];
            $neaten_goods_data = []; //整理后的仓库商品库存数据
            $goo_all_quantity = 0; //商品总数量
            $goo_all_price = 0; //商品总金额
            $orgo_goo_price_compare = 2; //商品金额比较:1小于成本金额2不小于成本金额
            $goods_data = json_decode($request['goods_data'], true);
            // 判断提交的商品参数
            if (empty($goods_data)) {
                // 救援单的可以不选商品
                if ($request['ord_service_type'] != 7) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'请选择服务项目'];
                }
            } else {
                foreach ($goods_data as $key => $value) {
                    if (!isset($value['goo_waon_class'])) {
                        $value['goo_waon_class'] = 1;
                        $goods_data[$key]['goo_waon_class'] = 1;
                    }
                    if (!isset($value['wago_id'])) {
                        $find_wago_id = DB::table('warehouse_goods')
                            ->where('wago_goo_id', $value['goo_id'])
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_ware_id', $request['ware_id'])
                            ->value('wago_id');
                        $value['wago_id'] = $find_wago_id;
                        $goods_data[$key]['wago_id'] = $find_wago_id;
                    }
                    if (!isset($value['goo_inventory'])) {
                        $value['goo_inventory'] = 1;
                        $goods_data[$key]['goo_inventory'] = 1;
                    }
                    if (!is_numeric($value['wago_id']) || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1, 3, 4, 5, 6, 7, 8]) || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2])  || !is_numeric($value['goo_price']) || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'商品参数类型错误'];
                    }
                    // goo_state 商品状态1正常3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    $goo_unit_conversion = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_unit_conversion');
                    if ($value['goo_state'] != 4) {
                        // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                        if (isset($neaten_goods_data[$value['wago_id']][$value['goo_inventory']])) {
                            if ($value['goo_unta_id'] == 1) {
                                $neaten_goods_data[$value['wago_id']][$value['goo_inventory']]['goo_quantity'] += $value['goo_quantity'] * $goo_unit_conversion;
                            } else {
                                $neaten_goods_data[$value['wago_id']][$value['goo_inventory']]['goo_quantity'] += $value['goo_quantity'];
                            }
                        } else {
                            $neaten_goods_data[$value['wago_id']][$value['goo_inventory']] = $value;
                            if ($value['goo_unta_id'] == 1) {
                                $neaten_goods_data[$value['wago_id']][$value['goo_inventory']]['goo_quantity'] = $value['goo_quantity'] * $goo_unit_conversion;
                            } else {
                                $neaten_goods_data[$value['wago_id']][$value['goo_inventory']]['goo_quantity'] = $value['goo_quantity'];
                            }
                        }
                        $goo_all_quantity += $value['goo_quantity'];
                        $goo_all_price += $value['goo_quantity'] * $value['goo_price'];
                    }
                    // 工作总台开单的时候，判断一下商品金额小于当前进销存的成本，生成待审核状态订单，需要审核通过
                    if (in_array($request['ord_service_type'], [1, 5, 7]) && !in_array($value['goo_state'], [5, 6, 7])) {
                        // 获取订单商品成本价
                        $orgo_goo_cost = DB::table('enters_sells_saves')
                            ->where('ense_goo_warehouse', $request['ware_id'])
                            ->where('ense_goo_waretype', $value['goo_waon_class'])
                            ->where('ense_goo_id', $value['goo_id'])
                            ->orderBy('ense_id', 'desc')
                            ->value('ense_end_price');
                        $orgo_data[$key]['orgo_goo_cost'] = $orgo_goo_cost * 100; //商品成本
                        if ($value['goo_price'] < $orgo_goo_cost) {
                            $orgo_goo_price_compare = 1;
                        }
                    }
                }
            }
        }

        /*
            锁定仓库商品库存处理
            虚拟加盟店订单商品没有库存，不需要锁定库存；
            退货单商品不需要锁定商品库存；
            运营中心派单商品不需要锁定商品库存；
            其他有商品的情况需要锁定商品库存
        */
        $wagl_data = [];
        foreach ($order_data as $key => $value) {
            $order_datas['data'][$key] = $value;
        }
        if ($request['orcl_shipment_party'] != 4 && $request['orcl_shipment_party'] != 5 && $request['ord_service_type'] != 4) {
            if (!empty($neaten_goods_data)) {
                $ware_lock_return = WarehouseLock::warehouseLockInventory(
                    $user_info,
                    $request,
                    $order_datas,
                    $neaten_goods_data
                );
                if ($ware_lock_return['code'] == 500) {
                    return $ware_lock_return;
                }
                $neaten_wago_id = []; //良品商品
                $priority_neaten_wago_id = []; //优先商品
                $wagl_key = 0;
                $wagl_lock_quantity = []; //仓库锁定表的商品锁定数量
                foreach ($neaten_goods_data as $wago_id => $wago_id_value) {
                    foreach ($wago_id_value as $goo_inventory => $goo_value) {
                        if ($goo_inventory == 1) {
                            // 良品商品锁定库存
                            $ware_id[$wago_id] = $request['ware_id'];
                            $wago_goo_id[$wago_id] = $goo_value['goo_id'];
                            $wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                            $wago_goo_inventory[$wago_id] = $goo_inventory;
                            $wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                            $neaten_wago_id[] = $wago_id;
                        } else {
                            // 优先商品锁定库存
                            $priority_ware_id[$wago_id] = $request['ware_id'];
                            $priority_wago_goo_id[$wago_id] = $goo_value['goo_id'];
                            $priority_wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                            $priority_wago_goo_inventory[$wago_id] = $goo_inventory;
                            $priority_wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                            $priority_neaten_wago_id[] = $wago_id;
                        }
                        // 仓库锁定表的商品锁定数量：良品+优先 总的锁定数量
                        if (isset($wagl_lock_quantity[$wago_id])) {
                            $wagl_lock_quantity[$wago_id] += $goo_value['goo_quantity'];
                        } else {
                            $wagl_lock_quantity[$wago_id] = $goo_value['goo_quantity'];
                        }
                    }

                    // 仓库商品锁定表
                    $wagl_data[$wagl_key]['wagl_shop_id'] = $user_info->adm_shop_id;
                    $wagl_data[$wagl_key]['wagl_ware_id'] = $request['ware_id'];
                    $wagl_data[$wagl_key]['wagl_wago_id'] = $wago_id;
                    $wagl_data[$wagl_key]['wagl_original_id'] = $order_datas['data']['ord_id'];
                    $wagl_data[$wagl_key]['wagl_original_number'] = $order_datas['data']['ord_order_number'];
                    $wagl_data[$wagl_key]['wagl_original_correlation_id'] = $order_datas['data']['ord_id']; //关联id：订单id/发货单id/调拨单id
                    $wagl_data[$wagl_key]['wagl_correlation_type'] = 1; //关联类型：1订单2发货单3调拨单
                    $wagl_data[$wagl_key]['wagl_type'] = 1; //  原始单类型：1订单2调拨单
                    $wagl_data[$wagl_key]['wagl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                    $wagl_data[$wagl_key]['wagl_lock_quantity'] = $wagl_lock_quantity[$wago_id]; //商品锁定库存数量
                    $wagl_key++;
                }
            }
        }

        // 6. 订单类型为 发货单 生成发货单  虚拟加盟店不生成发货单(需要修改)
        if ($request['ord_service_type'] == 5 && $request['orcl_shipment_party'] != 4 && $request['orcl_shipment_party'] != 5) {
            $update_dis_data['dego_type'] = 3; //作废
            $update_dis_data['dego_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $update_dis_res = DB::table('dispatch_bill')
                ->where('dego_wor_id', $order_datas['data']['ord_id'])
                ->update($update_dis_data);
            $dibi_data = DispatchBill::create(
                $user_info,   //用户信息
                $request,  //订单提交数据
                $goods_data,  //提交的商品数据
                1,  //类型：1.订单发货 2.工单发货
                $request['ware_id'],  //出库仓库id
                $order_datas['data']['ord_order_number'],  //原始单号，订单号/工单号
                $order_datas['data']['ord_id'],  //发货单关联的工单/订单id
                $order_datas['data']['shop_id'],  //所属总店id
                $order_datas['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $order_datas['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                $goo_all_quantity  //发货总数量
            );
            if ($dibi_data['code'] == 500) {
                return $dibi_data;
            }

            foreach ($wagl_data as $key => $value) {
                $wagl_data[$key]['wagl_original_correlation_id'] = $dibi_data['dego_id']; //关联id：订单id/发货单id/调拨单id
                $wagl_data[$key]['wagl_correlation_type'] = 2; //关联类型：1订单2发货单3调拨单
            }
        } else {
            $ship_res = true;
        }

        if (!empty($wagl_data)) {
            $wagl_res = DB::table('warehouse_goods_lock')->insert($wagl_data);
            if (!$wagl_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'编辑订单失败'];
            }
        }
        return ['code'=>200, 'msg'=>'success', 'return_data'=>$return_data];
    }

    /**
     * [createWork 生成工单]
     * @param  [type]  $user_info [description]
     * @param  [type]  $request   [description]
     * @param  integer $type      [类型：1生成工单调用2订单立即派单调用]
     * @return [type]             [description]
     */
    public static function createWork($user_info, $request, $type = 1)
    {
        $find_order_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'ord_wor_state', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_adm_id', 'orcl_car_vin', 'orcl_car_brand_series', 'ord_ware_id', 'ord_client_id', 'ord_create_time', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain')
            ->first();
        if ($find_order_data->ord_wor_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'已生成工单，无法重复生成'];
        }
        if ($find_order_data->ord_wor_state == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单已完成，无法派单'];
        }
        if ($find_order_data->ord_wor_state == 11) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单已取消，无法派单'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $wor_order_number = Common::numberRule($user_info, 2);

        $data['wor_cid'] = $user_info->adm_cid;
        $data['wor_superior_shop_id'] = $shop_id;
        $data['wor_shop_id'] = $user_info->adm_shop_id;
        $data['wor_create_id'] = $user_info->adm_id;
        $data['wor_number'] = $wor_order_number;
        $data['wor_order_id'] = $request['ord_id'];
        $data['wor_order_number'] = $find_order_data->ord_order_number;
        $data['wor_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        $data['wor_type'] = $find_order_data->ord_type;
        $data['wor_ware_id'] = $find_order_data->ord_ware_id;
        $data['wor_province'] = $find_order_data->ord_province;
        $data['wor_city'] = $find_order_data->ord_city;
        $data['wor_county'] = $find_order_data->ord_county;
        $data['wor_address'] = $find_order_data->ord_address;
        $data['wor_service_type'] = 1; //订单类型：1服务单2销售单3换货单
        $data['wor_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['wor_remark'] = $find_order_data->ord_remark;
        $data['wor_explain'] = $find_order_data->ord_explain;
        $data['wor_service_state'] = 1;
        $data['wor_state'] = 3;
        $data['wor_pass'] = 1; //审核：1.待审核 2.合格 3.不合格
        $data['wor_actual_price'] = $find_order_data->ord_actual_price; //工单结算金额（单位：分）
        $data['wor_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量
        $data['wor_new_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量(用料)
        if (isset($request['orcl_appoint_time']) && $request['orcl_appoint_time'] != '0000-00-00 00:00:00' && !empty($request['orcl_appoint_time'])) {
            $data['wor_appoint_time'] = $request['orcl_appoint_time']; //预约时间
        } else {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'请填写预约时间', 'data'=>'请填写预约时间'];
        }
        $data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_id = DB::table('work_order')->insertGetId($data);

        // 添加订单客户表数据
        $wocl_data = [
            'wocl_wor_id' => $wor_id,
            'wocl_client_id' => $find_order_data->orcl_client_id, //选择客户id
            'wocl_adm_id' => $find_order_data->orcl_adm_id, //业务员id
            'wocl_channel_unit' => $find_order_data->orcl_channel_unit,
            'wocl_name' => $find_order_data->orcl_name,
            'wocl_phone' => $find_order_data->orcl_phone,
            'wocl_carowner_name' => $find_order_data->orcl_carowner_name,
            'wocl_carowner_phone' => $find_order_data->orcl_carowner_phone,
            'wocl_car_num' => $find_order_data->orcl_car_num,
            'wocl_pick_up_car_time' => $find_order_data->orcl_pick_up_car_time, //接车时间
            'wocl_pick_up_car_adm_id' => $find_order_data->orcl_pick_up_car_adm_id, //接车人id
            'wocl_check_car_state' => $find_order_data->orcl_check_car_state, //是否验车：1是2否
            'wocl_appoint_remark' => $find_order_data->orcl_appoint_remark, //预约备注
            'wocl_car_vin' => $find_order_data->orcl_car_vin, //车架号车辆识别码
            'wocl_car_brand_series' => $find_order_data->orcl_car_brand_series, //品牌车系
            'wocl_update_time' => date('Y-m-d H:i:s'),
        ];
        $wocl_id = DB::table('work_client')->insertGetId($wocl_data);

        // 提交的订单商品项目数据
        $goods_data = json_decode($request['goods_data'], true);
        $work_items = []; //订单项目数据
        $goo_all_price = 0; //商品总金额
        $goo_all_quantity = 0; //商品总数量
        $create_dis = false;
        // 新增工单商品数据
        foreach ($goods_data as $key => $value) {
            if ($type == 1) {
                $orit_data['orit_service_adm_id'] = $value['service_adm_id'];
                $orit_data['orit_update_time'] = date('Y-m-d H:i:s');
                $orit_res = DB::table('wash_order_items')
                    ->where('orit_id', $value['orit_id'])
                    ->update($orit_data);
            }
            if (!isset($value['goo_waon_class'])) {
                $value['goo_waon_class'] = 1;
                $goods_data[$key]['goo_waon_class'] = 1;
            }
            if (!isset($value['goo_inventory'])) {
                $value['goo_inventory'] = 1;
                $goods_data[$key]['goo_inventory'] = 1;
            }
            if (!isset($value['wago_id'])) {
                $find_wago_id = DB::table('warehouse_goods')
                    ->where('wago_goo_id', $value['goo_id'])
                    ->where('wago_class', $value['goo_waon_class'])
                    ->where('wago_ware_id', $find_order_data->ord_ware_id)
                    ->value('wago_id');
                $value['wago_id'] = $find_wago_id;
                $goods_data[$key]['wago_id'] = $find_wago_id;
            }
            if (!isset($value['goo_quantity']) || empty($value['goo_quantity'])) {
                $value['goo_quantity'] = 0;
                $goods_data[$key]['goo_quantity'] = 0;
            }
            // 搜索商品id对应的商品名称、商品编号
            $find_goods_data = DB::table('goods')
                ->where('goo_id', $value['goo_id'])
                ->first(['goo_name', 'goo_goods_encode', 'goo_type', 'goo_class']);
            if (!empty($value['goo_id'])) {
                $create_dis = true;
                $wogo_data['wogo_wor_id'] = $wor_id;
                $wogo_data['wogo_orgo_id'] = $value['orgo_id'];
                $wogo_data['wogo_wago_id'] = $value['wago_id'];
                $wogo_data['wogo_goo_id'] = $value['goo_id'];
                $wogo_data['wogo_goo_name'] = $value['goo_name'];
                $wogo_data['wogo_goo_type'] = $find_goods_data->goo_type;
                $wogo_data['wogo_goo_goods_encode'] = $find_goods_data->goo_goods_encode;
                $wogo_data['wogo_goo_inventory'] = $value['goo_inventory'];
                $wogo_data['wogo_state'] = $value['goo_state'];
                $wogo_data['wogo_goo_guarantee'] = isset($value['goo_guarantee']) ? $value['goo_guarantee'] : '';
                $wogo_data['wogo_goo_amount'] = $value['goo_quantity'];
                if (empty($value['goo_unit']) || empty($value['goo_unta_id'])) {
                    return ['code'=>500, 'msg'=>'请选择单位', 'data'=>'请选择单位'];
                }
                $wogo_data['wogo_goo_unit'] = $value['goo_unit'];
                $wogo_data['wogo_goo_unta_id'] = $value['goo_unta_id'];
                $wogo_data['wogo_update_time'] = date('Y-m-d H:i:s');
                $wogo_id = DB::table('work_good')->insertGetId($wogo_data);
            } else {
                $wogo_id = 0;
            }
            $goo_all_price += $value['service_price']; //总金额

            $goo_all_quantity += $value['goo_quantity']; //商品总数量

            // 工单项目数据
            $work_items[$key]['woit_shop_id'] = $user_info->adm_shop_id;
            $work_items[$key]['woit_wor_id'] = $wor_id;
            $work_items[$key]['woit_wogo_id'] = $wogo_id;
            $work_items[$key]['woit_sepr_id'] = $value['sepr_id'];
            $work_items[$key]['woit_sepr_name'] = $value['sepr_name'];
            // $work_items[$key]['woit_part_state'] = $value['part_state'];
            $work_items[$key]['woit_service_price'] = $value['service_price'] * 100;
            if ($type == 2 && empty($value['service_adm_id'])) {
                return ['code'=>500, 'msg'=>'请选择技师', 'data'=>'请选择技师'];
            }
            $work_items[$key]['woit_service_adm_id'] = $value['service_adm_id'];
            $service_adm_id = $value['service_adm_id'];
            // 工单技师施工部位表
            $wotp_data[$key]['wotp_shop_id'] = $user_info->adm_shop_id;
            $wotp_data[$key]['wotp_wor_id'] = $wor_id;
            $wotp_data[$key]['wotp_service_adm_id'] = $value['service_adm_id'];
            $sepr_name = $value['sepr_name'];
            // 查询技师相关信息
            $find_adm_data = DB::table('admin as a')
                ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
                ->where('adm_id', $value['service_adm_id'])
                ->select('adm_id', 'adm_name', 'adm_phone', 'grle_id', 'grle_name', 'grpr_id', 'grpr_name')
                ->first();
            if (empty($find_adm_data)) {
                return ['code'=>500, 'msg'=>'未找到技师相关信息', 'data'=>'未找到技师相关信息'];
            }
            $wotp_data[$key]['wotp_service_adm_name'] = $find_adm_data->adm_name;
            $wotp_data[$key]['wotp_service_adm_phone'] = $find_adm_data->adm_phone;
            if ($find_adm_data->grle_id) {
                $wotp_data[$key]['wotp_grle_id'] = $find_adm_data->grle_id;
            }
            if ($find_adm_data->grle_name) {
                $wotp_data[$key]['wotp_grle_name'] = $find_adm_data->grle_name;
            }
            if ($find_adm_data->grpr_id) {
                $wotp_data[$key]['wotp_grpr_id'] = $find_adm_data->grpr_id;
            }
            if ($find_adm_data->grpr_name) {
                $wotp_data[$key]['wotp_grpr_name'] = $find_adm_data->grpr_name;
            }
        }
        $order_data['data']['shop_id'] = $shop_id;
        $request['service_shop_id'] = 0;
        $request['service_adm_id'] = $service_adm_id;
        $request['ord_type'] = 1; //买家类型：1.会员零售
        $request['ord_client_id'] = $find_order_data->ord_client_id; //客户id
        if ($create_dis) {
            $dibi_data = DispatchBill::create(
                $user_info,   //用户信息
                $request,  //订单提交数据
                $goods_data,  //提交的商品数据
                2,  //类型：1.订单发货 2.工单发货
                $find_order_data->ord_ware_id,  //出库仓库id
                $wor_order_number,  //原始单号，订单号/工单号
                $wor_id,  //发货单关联的工单/订单id
                $order_data['data']['shop_id'],  //所属总店id
                $request['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $request['ord_client_id'],  //选择的客户id,会员id/单位id
                $goo_all_quantity  //发货总数量
            );
            if ($dibi_data['code'] == 500) {
                return $dibi_data;
            }
        }
        $woit_res = DB::table('wash_work_items')->insert($work_items);
        $wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data);
        if (isset($request['orcl_appoint_time'])) {
            $edit_orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
            $edit_orcl_data['orcl_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $orcl_edit_res = DB::table('order_client')->where('orcl_ord_id', $request['ord_id'])->update($edit_orcl_data);
        }
        $edit_data['ord_wor_quantity'] = 1; //工单数量
        $edit_data['ord_wor_state'] = 2; //订单的工单状态1未派工单2服务中3售后中
        $edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $request['ord_id'])->update($edit_data);
        $edit_wor_data['wor_service_adm_id'] = $service_adm_id;
        $edit_wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $edit_wor_res = DB::table('work_order')->where('wor_id', $wor_id)->update($edit_wor_data);
        if ($wor_id && $wocl_id && $ord_edit_res && $woit_res && $wotp_res) {
            $return_data['wor_id'] = $wor_id;
            $return_data['wor_order_number'] = $wor_order_number;
            // 微信消息推送
            $wechat_msg['pushtype'] = 1; //工单推送
            $wechat_msg['adm_id'] = $service_adm_id; //推送人
            $wechat_msg['wor_number'] = $wor_order_number; //工单号
            $wechat_msg['ord_number'] = $find_order_data->ord_order_number; //订单号
            $wechat_msg['order_type'] = ordType($request['ord_service_type']); //订单类型
            $wechat_msg['user_name'] = $find_adm_data->adm_name; //姓名
            $wechat_msg['sepr_name'] = $sepr_name; //服务项目
            $wechat_msg['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
            $wechat_msg['ord_create_time'] = $find_order_data->ord_create_time; //订单创建时间

            $wechat_msg['user_phone'] = $find_adm_data->adm_phone; //手机号
            $wechat_msg['user_dress'] = $find_order_data->ord_province . $find_order_data->ord_city . $find_order_data->ord_county . $find_order_data->ord_address; //详细地址
            $wechat_msg['tittle'] = '您有新的工单，请及时处理'; //手机
            $wechat_msg['remark'] = !empty($find_order_data->ord_remark) ? $find_order_data->ord_remark : '';
            $CashierDesk = new CashierDesk;
            $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'生成工单失败'];
        }
    }

    public static function request_post_webs(
        $url,
        $data
    ){
        // $headerArray =array("Content-type:application/json;charset='utf-8'","Accept:application/json");
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,FALSE);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        // curl_setopt($curl,CURLOPT_HTTPHEADER,$headerArray);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        curl_close($curl);
        return $output;
    }

    // 验车
    public static function validateCar($user_info, $request)
    {
        $data['orvc_shop_id'] = $user_info->adm_shop_id;
        $data['orvc_adm_id'] = $user_info->adm_id;
        $data['orvc_ord_id'] = $request['ord_id'];
        $data['orvc_mileage'] = $request['orvc_mileage']; //进店里程数
        // $data['orvc_film_roll_number'] = $request['orvc_film_roll_number']; //膜卷号
        $data['orvc_car_interior'] = $request['orvc_car_interior']; //车内异常
        $data['orvc_car_exterior'] = $request['orvc_car_exterior']; //外观部分
        $data['orvc_update_time'] = date('Y-m-d H:i:s');
        $find_order_data = DB::table('wash_order_validate_car as ovc')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ovc.orvc_ord_id')
            ->where('orvc_ord_id', $request['ord_id'])
            ->select('orvc_id', 'orcl_check_car_state')
            ->first();
        if (!empty($find_order_data->orvc_id)) {
            if ($find_order_data->orvc_id) {
                if ($find_order_data->orcl_check_car_state == 3) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'客户已签字，无法编辑'];
                }
                $orvc_res = DB::table('wash_order_validate_car')->where('orvc_id', $find_order_data->orvc_id)->update($data);
            } else {
                $orvc_res = DB::table('wash_order_validate_car')->insert($data);
            }
        } else {
            $orvc_res = DB::table('wash_order_validate_car')->insert($data);
        }

        // 更改订单客户表的验车字段数据
        $ord_data['orcl_check_car_state'] = 1; //是否验车：1是2否
        $ord_data['orcl_update_time'] = date('Y-m-d H:i:s');
        $orcl_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($ord_data);
        // 更改工单客户表的验车字段数据
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->value('wor_id');
        if ($find_work) {
            // 更改订单客户表的验车字段数据
            $work_data['wocl_check_car_state'] = 1; //是否验车：1是2否
            $work_data['wocl_update_time'] = date('Y-m-d H:i:s');
            $wocl_res = DB::table('work_client')
                ->where('wocl_wor_id', $find_work)
                ->update($work_data);
        } else {
            $wocl_res = true;
        }
        if ($orvc_res && $orcl_res && $wocl_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑失败'];
        }
    }

    // 详情
    public static function info($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('shop as s', 's.shop_id', '=', 'ord.ord_shop_id')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'orcl_signature_img', 'orcl_sales_adm_id', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'ord_explain', 'orcl_mem_source')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        // 获取该订单下的商品信息
        $goods_data = DB::table('wash_order_items as woi')
            ->leftjoin('order_goods as orgo', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orit_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_quantity as orgo_goo_quantitys', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orit_id', 'orit_sepr_id', 'orit_sepr_name', 'orit_part_state', 'orit_service_price', 'orit_service_adm_id', 'orit_ord_id as orgo_ord_id', 'orgo_goo_unit', 'orgo_goo_unta_id', 'goo_unit_conversion')
            ->get()->toArray();
        $service_adm_id = array_column($goods_data, 'orit_service_adm_id'); //服务技师id
        $orit_sepr_id = array_filter(array_unique(array_column($goods_data, 'orit_sepr_id'))); //服务项目id

        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->orcl_pick_up_car_adm_id;
        $adm_id[] = $info->orcl_sales_adm_id;
        $adm_id = array_merge($adm_id, $service_adm_id);
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        // 查询账号id对应手机号
        $adm_phone = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_phone', 'adm_id')
            ->toArray();
        $info->create_name = '';
        if ($info->ord_create_id != '0') {
            $info->create_name = $adm_name[$info->ord_create_id]; //创建人
        }
        // 接车人
        $info->orcl_pick_up_car_adm_name = '';
        if ($info->orcl_pick_up_car_adm_id) {
            $info->orcl_pick_up_car_adm_name = $adm_name[$info->orcl_pick_up_car_adm_id]; //接车人
        }
        // 预约时间
        if ($info->orcl_appoint_time == '0000-00-00 00:00:00') {
            $info->orcl_appoint_time = '';
        }
        // 销售人员
        $info->orcl_sales_adm_name = '';
        if ($info->orcl_sales_adm_id) {
            $info->orcl_sales_adm_name = $adm_name[$info->orcl_sales_adm_id]; //接车人
            $info->orcl_sales_adm_phone = $adm_phone[$info->orcl_sales_adm_id]; //接车人电话
        }
        unset($info->ord_create_id);
        unset($info->orcl_pick_up_car_adm_id);
        unset($info->orcl_sales_adm_id);

        // 查询服务项目图片
        $find_sepr = DB::table('service_project')
            ->whereIn('sepr_id', $orit_sepr_id)
            ->pluck('sepr_img', 'sepr_id')->toArray();
        foreach ($goods_data as $key => $value) {
            $goods_data[$key]->service_adm_name = isset($adm_name[$value->orit_service_adm_id]) ? $adm_name[$value->orit_service_adm_id] : '';

            // 服务项目图片路径
            if (isset($find_sepr[$value->orit_sepr_id]) && !empty($find_sepr[$value->orit_sepr_id])) {
                $goods_data[$key]->goo_image = $find_sepr[$value->orit_sepr_id];
            } else {
                $goods_data[$key]->goo_image = 'image/xmc/xx_icon.png'; //显示图片
            }
            if ($value->orgo_goo_unta_id == 1) {
                $goods_data[$key]->orgo_goo_quantity = $value->orgo_goo_quantity*$value->goo_unit_conversion.'米('.$value->orgo_goo_quantity.'卷)';
            } else {
                $goods_data[$key]->orgo_goo_quantity = $value->orgo_goo_quantity.$value->orgo_goo_unit;
            }
        }
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 用户小程序-预约单详情
    public static function reinfo($user_info, $request)
    {
        $info = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'recl.recl_reli_id', '=', 'reli.reli_id')
            ->leftJoin('wash_reservation_items as reit', 'reit.reit_reli_id', '=', 'reli.reli_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'reli.reli_shop_id')
            ->where('reli_id', $request['reli_id'])
            ->select('reli_id', 'shop_store_name', 'reli_number', 'reli_order_number', 'reli_state', 'reli_appoint_time_slot', 'reli_appoint_time', 'reli_appoint_remark', 'reli_remark', 'reit_sepr_name', 'reli_create_time', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'recl_city', 'recl_county', 'recl_address', 'reit_sepr_id', 'reli_ord_id', 'reit_sepr_id', 'reit_sepr_name', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'recl_car_brand_series', 'recl_car_vin', 'recl_ower_name', 'recl_ower_phone')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前预约单不存在', 'data'=>''];
        }

        // 预约时间
        if ($info->reli_appoint_time == '0000-00-00 00:00:00') {
            $info->reli_appoint_time = '';
        }

        // 查询服务项目图片
        $info->sepr_img = DB::table('service_project')
            ->where('sepr_id', $info->reit_sepr_id)
            ->value('sepr_img');
        return ['code'=>200, 'msg'=>'success', 'data'=>$info];
    }

    // 用户小程序-详情
    public static function washInfo($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->leftJoin('shop as c', 'ord.ord_shop_id', '=', 'c.shop_id')
            ->where('ord_id', $request['ord_id'])
            // ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'orcl_signature_img', 'shop_store_name', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_carowner_phone', 'orcl_carowner_name')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods as orgo')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state')
            ->get()->toArray();
        $orit_sepr_id = array_filter(array_unique(array_column($goods_data, 'orit_sepr_id'))); //服务项目id

        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->orcl_pick_up_car_adm_id;
        $adm_id = array_merge($adm_id, $service_adm_id);
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $find_adm = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->select('adm_name', 'adm_phone', 'adm_id')
            ->get()->toArray();
        $find_adm = array_column($find_adm, null, 'adm_id');

        $info->create_name = '';
        if (!empty($info->ord_create_id)) {
            $info->create_name = $find_adm[$info->ord_create_id]->adm_name; //创建人
        }
        // 接车人
        $info->orcl_pick_up_car_adm_name = '';
        if ($info->orcl_pick_up_car_adm_id) {
            $info->orcl_pick_up_car_adm_name = $find_adm[$info->orcl_pick_up_car_adm_id]->adm_name; //接车人
        }
        unset($info->ord_create_id);
        unset($info->orcl_pick_up_car_adm_id);

        // 查询工单完成时间
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->pluck('wor_achieve_time', 'wor_order_id')->toArray();

        // 技师完成时间
        if (isset($find_wor_data[$request['ord_id']]) && $find_wor_data[$request['ord_id']] != '0000-00-00 00:00:00') {
            $info->wor_achieve_time = $find_wor_data[$request['ord_id']];
        } else {
            $info->wor_achieve_time = '';
        }
        // 预约时间
        if ($info->orcl_appoint_time == '0000-00-00 00:00:00') {
            $info->orcl_appoint_time = '';
        }
        // 接车时间
        if ($info->orcl_pick_up_car_time == '0000-00-00 00:00:00') {
            $info->orcl_pick_up_car_time = '';
        }
        // 订单作品
        if ($info->ord_wor_state >= 4) {
            $info->order_works = DB::table('order_works')
                ->where('orwo_ord_id', $request['ord_id'])
                ->where('orwo_delete', 2)
                ->select('orwo_title', 'orwo_type', 'orwo_description', 'orwo_data')
                ->get()->toArray();
        }

        foreach ($goods_data as $key => $value) {
            // 服务项目图片路径
            if ($value->orgo_goo_type == 2) {
                $goods_data[$key]->goo_image = DB::table('service_project')
                    ->where('sepr_id', $value->orgo_goo_id)
                    ->value('sepr_img');
            } else {
                $goods_data[$key]->goo_image = ''; //显示图片
            }
        }

        // 查看工单技师施工检测信息
        $technician_part = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'a.wotp_wor_id', 'b.wor_id')
            ->where('wor_order_id', $request['ord_id'])
            ->whereIn('wotp_service_adm_id', $service_adm_id)
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_part', 'wotp_service_quality', 'wotp_service_data', 'wotp_service_qualitytesting', 'wotp_rewards_punishment')
            ->get()->toArray();

        // 查询验车信息
        $validate_car_data = DB::table('wash_order_validate_car')
            ->where('orvc_ord_id', $request['ord_id'])
            ->select('orvc_mileage', 'orvc_film_roll_number', 'orvc_car_interior', 'orvc_car_exterior')
            ->first();
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['technician_part'] = $technician_part;
        $data['validate_car_data'] = $validate_car_data;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 微信用户小程序-签字图片提交
    public static function signatureSubmit($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'orcl_check_car_state')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }
        if ($info->orcl_check_car_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单尚未验车', 'data'=>''];
        }

        $data['orcl_check_car_state'] = 3; //是否验车：1是、已验车2否、未验车3客户已签字
        $data['orcl_signature_img'] = $request['img_path'];
        $data['orcl_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
        }
    }

    // 取消订单
    public static function cancel($user_info, $request)
    {
        // $find_order = WashOrder::where('ord_id', $request['ord_id'])
        $find_order = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_order_number', 'ord_state', 'ord_delete', 'ord_wor_quantity', 'ord_wor_state', 'ord_service_type', 'ord_type', 'ord_client_id', 'ord_goods_quantity', 'ord_actual_price', 'ord_service_shop_id', 'ord_create_id', 'orcl_shipment_party', 'ord_ware_id', 'ord_create_time')
            ->first();
        // $find_order = DB::table('order')->where('ord_id', $request['ord_id'])
        //     ->where('ord_shop_id', $user_info->adm_shop_id)
        //     ->select('ord_order_number', 'ord_state', 'ord_delete', 'ord_wor_quantity', 'ord_wor_state', 'ord_service_type', 'ord_create_time', 'ord_ware_id', 'orcl_shipment_party')
        //     ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单不存在！', 'data'=>''];
        }
        if ($find_order->ord_state != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已结算，无法取消！', 'data'=>''];
        }
        if ($find_order->ord_delete == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已经取消！', 'data'=>''];
        }
        if ($find_order->ord_wor_state == 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单正在售后中，无法取消！', 'data'=>''];
        }
        if ($find_order->ord_service_type == 6) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'结清单无法取消！', 'data'=>''];
        }

        // 查询出该订单下所有的工单
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_delete', 'wor_id')
            ->get();
        // 验证当前订单下工单是否已经全部取消
        foreach ($find_work as $key => $value) {
            if ($value->wor_delete == 1) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单存在未取消的工单', 'data'=>''];
            }
        }
        $now_time = date('Y-m-d H:i:s');

        $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
        $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单6审核活动7待接单8锁定9速电撤销回收10终止11取消订单
        $ord_data['ord_update_time'] = $now_time;
        $ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_data);

        // 更新订单商品表时间
        $edit_orgo_data['orgo_update_time'] = $now_time;
        if (!empty($orgo_id)) {
            $edit_orgo_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->update($edit_orgo_data);
        } else {
            $edit_orgo_res = true;
        }

        // // 取消订单
        // $order_res = Order::cancel(
        //     $user_info,
        //     $request,
        //     $find_order,
        //     1
        // );
        // $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
        // $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单6审核活动7待接单8锁定9速电撤销回收10终止11取消订单
        // $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
        // // $ord_res = WashOrder::where('ord_id', $request['ord_id'])->update($ord_data);
        // $ord_res = DB::table('order')->where('ord_id', $request['ord_id'])->update($ord_data);

        if ($ord_res) {
            $data['ord_order_number'] = $find_order->ord_order_number;
            $wohi_data['wohi_primary_id'] = $request['ord_id'];
            $wohi_data['wohi_state_name'] = '已取消';
            $wohi_data['wohi_state'] = 6;
            $wohi_data['wohi_type'] = 1;
            addHistory($wohi_data);
            unset($wohi_data);
            return ['code'=>200, 'msg'=>'取消订单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'取消订单失败', 'data'=>'取消订单失败'];
        }
    }

    // 备注查询数据
    public static function remarkSearch($user_info, $request)
    {
        $number = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->value('ord_order_number');
        $wor_id = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->value('wor_id');
        $wor_id = $wor_id ? $wor_id : 0;
        $data['ord_order_number'] = $number;
        $data['wor_id'] = $wor_id;
        return $data;
    }

    // 预约设置
    public function appointmentSet($user_info, $request)
    {
        $find_order = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_order_number', 'ord_wor_state', 'ord_delete')
            ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单不存在！', 'data'=>''];
        }
        if ($find_order->ord_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已经取消！', 'data'=>''];
        }
        if (!in_array($find_order->ord_wor_state, [1, 2, 5])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已完成或终止！', 'data'=>''];
        }

        // 查询当前订单下是否有正常服务工单
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->where('wor_delete', 1)
            ->where('wor_state', '<>', 11)
            ->first(['wor_id', 'wor_state']);
        if ($find_wor_data && $find_wor_data->wor_state > 6) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单所属工单正在施工中，无法更改预约时间！', 'data'=>''];
        }

        // 订单客户表更改预约时间、预约备注
        $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
        if (!empty($request['appoint_remark'])) {
            $orcl_edit['orcl_appoint_remark'] = $request['appoint_remark'];
        }
        $orcl_edit['orcl_update_time'] = date('Y-m-d H:i:s');
        $ord_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($orcl_edit);

        $wor_id = 0; //工单id
        if ($find_wor_data) {
            $wor_id = $find_wor_data->wor_id; //工单id

            $wor_edit['wor_appoint_time'] = $request['appoint_time'];
            $wor_edit['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_edit_res = DB::table('work_order')
                ->where('wor_id', $find_wor_data->wor_id)
                ->update($wor_edit);
            if (!empty($request['appoint_remark'])) {
                $wocl_edit['wocl_appoint_remark'] = $request['appoint_remark'];
                $wocl_edit['wocl_update_time'] = date('Y-m-d H:i:s');
                $wocl_edit_res = DB::table('work_client')
                    ->where('wocl_wor_id', $find_wor_data->wor_id)
                    ->update($wocl_edit);
            } else {
                $wocl_edit_res = true;
            }
            // 判断是否更改成功
            if ($wor_edit_res && $wocl_edit_res) {
                $wor_res = true;
            } else {
                $wor_res = false;
            }
        } else {
            $wor_res = true;
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], $wor_id, '预约设置');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (!empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemark($user_info, $request['ord_id'], $wor_id, $remark_data, '订单列表-预约设置');

        if ($ord_res && $wor_res && $orlo_res && $orre_res) {
            $data['ord_order_number'] = $find_order->ord_order_number;
            return ['code'=>200, 'msg'=>'预约设置成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约设置失败', 'data'=>''];
        }
    }

    // 生成售后单
    public function afterSale($user_info, $request)
    {
        $return_data = $this::info($user_info, $request);
        if ($return_data['code'] != 200) {
            return $return_data;
        }

        $find_order_data = $return_data['data']['order_data'];
        $goods_data = $return_data['data']['goods_data'];
        if ($find_order_data->ord_wor_state == 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单存在售后单，无法生成售后单'];
        }
        if ($find_order_data->ord_wor_state == 11) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单已取消，无法生成售后单'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取售后单编号
        $afsl_number = Common::numberRule((object)$user_info, 6);
        $afsl_data['afsl_after_number'] = $afsl_number; //售后单号
        $afsl_data['afsl_cid'] = $user_info->adm_cid;
        $afsl_data['afsl_superior_shop_id'] = $shop_id;
        $afsl_data['afsl_shop_id'] = $user_info->adm_shop_id;
        $afsl_data['afsl_ord_id'] = $find_order_data->ord_id; //订单id
        $afsl_data['afsl_order_number'] = $find_order_data->ord_order_number; //订单号
        // $afsl_data['afsl_order_price'] = $find_order_data->ord_order_number;//订单号
        $afsl_data['afsl_actual_price'] = $find_order_data->ord_actual_price; //结算金额
        $afsl_data['afsl_reservation_time'] = $find_order_data->orcl_appoint_time; //预约时间
        $afsl_data['afsl_client_type'] = $find_order_data->ord_type; //类型：1会员2客户单位
        $afsl_data['afsl_client_id'] = $find_order_data->orcl_client_id; //客户单位id，会员id
        if (!empty($request['remark'])) {
            $afsl_data['afsl_remark'] = $request['remark']; //售后备注
        }
        $afsl_data['afsl_create_id'] = $user_info->adm_id; //用户id
        $afsl_id = DB::table('wash_after_sale_list')->insertGetId($afsl_data);

        // 售后单客户信息
        $afsc_data['afsc_shop_id'] = $user_info->adm_shop_id;
        $afsc_data['afsc_afsl_id'] = $afsl_id;
        $afsc_data['afsc_client_id'] = $find_order_data->orcl_client_id;
        $afsc_data['afsc_car_brand_series'] = $find_order_data->orcl_car_brand_series;
        $afsc_data['afsc_channel_unit'] = $find_order_data->orcl_channel_unit;
        $afsc_data['afsc_name'] = $find_order_data->orcl_name;
        $afsc_data['afsc_phone'] = $find_order_data->orcl_phone;
        $afsc_data['afsc_carowner_name'] = $find_order_data->orcl_carowner_name;//车主姓名
        $afsc_data['afsc_carowner_phone'] = $find_order_data->orcl_carowner_phone;//车主电话
        $afsc_data['afsc_car_num'] = $find_order_data->orcl_car_num;
        $afsc_data['afsc_province'] = $find_order_data->orcl_province;
        $afsc_data['afsc_city'] = $find_order_data->orcl_city;
        $afsc_data['afsc_county'] = $find_order_data->orcl_county;
        $afsc_data['afsc_address'] = $find_order_data->orcl_address;
        $afsc_id = DB::table('wash_after_sale_client')->insertGetId($afsc_data);

        $afsi_data = [];
        foreach ($goods_data as $key => $value) {
            $afsi_data[$key]['afsi_afsl_id'] = $afsl_id;
            $afsi_data[$key]['afsi_shop_id'] = $user_info->adm_shop_id;
            $afsi_data[$key]['afsi_sepr_id'] = $value->orit_sepr_id;
            $afsi_data[$key]['afsi_sepr_name'] = $value->orit_sepr_name;
            $afsi_data[$key]['afsi_part_state'] = $value->orit_part_state;
            $afsi_data[$key]['afsi_service_price'] = $value->orit_service_price;
            if (!empty($value->orgo_goo_id)) {
                $afsi_data[$key]['afsi_goo_price'] = $value->orgo_goo_price;
                $afsi_data[$key]['afsi_goo_quantity'] = $value->orgo_goo_quantitys;
                $afsi_data[$key]['afsi_goo_warranty_time'] = $value->orgo_goo_guarantee;
                $afsi_data[$key]['afsi_goo_id'] = !empty($value->orgo_goo_id)?$value->orgo_goo_id:'';
                $afsi_data[$key]['afsi_goo_name'] = !empty($value->orgo_goo_name)?$value->orgo_goo_name:'';
                $afsi_data[$key]['afsi_goo_goods_encode'] = !empty($value->orgo_goo_goods_encode)?$value->orgo_goo_goods_encode:'';
                $afsi_data[$key]['afsi_goo_type'] = $value->orgo_goo_type;
                $afsi_data[$key]['afsi_goo_unit'] = $value->orgo_goo_unit;
                $afsi_data[$key]['afsi_goo_unta_id'] = $value->orgo_goo_unta_id;
            }
        }
        $afsi_id = DB::table('wash_after_sale_items')->insert($afsi_data);

        if ($afsl_id && $afsc_id && $afsi_id) {
            $return_data['afsl_id'] = $afsl_id;
            $return_data['afsl_after_number'] = $afsl_number;
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'转售后失败'];
        }
    }

    // 订单添加作品
    public function addOrderWorks($user_info, $request)
    {
        $add_data['orwo_shop_id'] = $user_info->adm_shop_id;
        $add_data['orwo_ord_id'] = $request['ord_id'];
        $add_data['orwo_title'] = $request['orwo_title'];
        $add_data['orwo_type'] = $request['orwo_type'];
        $add_data['orwo_description'] = $request['orwo_description'];
        $add_data['orwo_data'] = $request['orwo_data'];
        $add_data['orwo_adm_id'] = $user_info->adm_id;
        $add_data['orwo_create_time'] = date('Y-m-d H:i:s');
        $add_data['orwo_update_time'] = date('Y-m-d H:i:s');
        $add_data_res = DB::table('order_works')->insert($add_data);
        if ($add_data_res) {
            return ['code'=>200, 'msg'=>'添加作品成功', 'data'=>'添加作品成功'];
        } else {
            return ['code'=>500, 'msg'=>'添加作品失败', 'data'=>'添加作品失败'];
        }
    }

    // 订单作品列表
    public function OrderWorksindex($user_info, $request)
    {
        $find_data = DB::table('order_works as o')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'o.orwo_adm_id')
            ->where('orwo_ord_id', $request['ord_id'])
            ->where('orwo_delete', 2)
            ->select('orwo_title', 'orwo_id', 'orwo_type', 'orwo_description', 'orwo_adm_id', 'adm_name', 'orwo_create_time', 'orwo_data')
            ->orderBy('orwo_create_time', 'desc')
            ->get()->toArray();
        return $find_data;
    }

    // 订单作品详情
    public function OrderWorksinfo($user_info, $request)
    {
        $find_data = DB::table('order_works as o')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'o.orwo_adm_id')
            ->where('orwo_id', $request['orwo_id'])
            ->where('orwo_delete', 2)
            ->select('orwo_title', 'orwo_id', 'orwo_type', 'orwo_description', 'orwo_data', 'orwo_adm_id', 'adm_name', 'orwo_create_time')
            ->first();
        return $find_data;
    }

    // 订单作品编辑
    public function OrderWorksedit($user_info, $request)
    {
        $update_data['orwo_shop_id'] = $user_info->adm_shop_id;
        $update_data['orwo_title'] = $request['orwo_title'];
        $update_data['orwo_ord_id'] = $request['ord_id'];
        $update_data['orwo_type'] = $request['orwo_type'];
        $update_data['orwo_description'] = $request['orwo_description'];
        $update_data['orwo_data'] = $request['orwo_data'];
        $update_data['orwo_adm_id'] = $user_info->adm_id;
        $update_data['orwo_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('order_works')->where('orwo_id', $request['orwo_id'])->update($update_data);
        if ($update_data_res) {
            return ['code'=>200, 'msg'=>'编辑作品成功', 'data'=>'编辑作品成功'];
        } else {
            return ['code'=>500, 'msg'=>'编辑作品失败', 'data'=>'编辑作品失败'];
        }
    }

    // 订单作品删除
    public function OrderWorksdel($user_info, $request)
    {
        $del_data['orwo_delete'] = 1;
        $del_data['orwo_update_time'] = date('Y-m-d H:i:s');
        $del_res = DB::table('order_works')
            ->where('orwo_id', $request['orwo_id'])
            ->where('orwo_delete', 2)
            ->update($del_data);
        if ($del_res) {
            return ['code'=>200, 'msg'=>'删除作品成功', 'data'=>'删除作品成功'];
        } else {
            return ['code'=>500, 'msg'=>'删除作品失败', 'data'=>'删除作品失败'];
        }
    }

    // 订单审核修正
    public function auditOrder($user_info, $request)
    {
        // 修改订单金额及服务金额
        $update_data['ord_actual_price'] = $request['ord_actual_price']*100;
        $update_data['ord_order_price'] = $request['ord_actual_price']*100;
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_data['orit_service_price'] = $request['orit_service_price']*100;
        $update_data['orit_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order as o')
            ->leftjoin('wash_order_items as orit', 'orit.orit_ord_id', '=', 'o.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->update($update_data);
        // 查询是否有工单
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_id')
            ->first();
        if ($find_work) {
            // 修改工单金额及服务金额
            $update_work_data['wor_actual_price'] = $request['ord_actual_price']*100;
            $update_work_data['wor_update_time'] = date('Y-m-d H:i:s');

            $update_work_data['woit_service_price'] = $request['orit_service_price']*100;
            $update_work_data['woit_update_time'] = date('Y-m-d H:i:s');
            $update_wor_res = DB::table('work_order as wor')
                ->leftjoin('wash_work_items as woit', 'woit.woit_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $find_work->wor_id)
                ->update($update_work_data);
        } else {
            $update_wor_res = true;
        }
        // if (isset($request['goo_id']) && !empty($request['goo_id'])) {
        //     $update_goo_data['orgo_goo_price'] = $request['orgo_goo_price']*100;
        //     $update_orgo_res = DB::table('order_goods')
        //         ->where('orgo_ord_id', $request['ord_id'])
        //         ->where('orgo_goo_id', $request['goo_id'])
        //         ->update($update_goo_data);
        //     if ($find_work) {
        //         $update_wogo_data['wogo_goo_price'] = $request['orgo_goo_price']*100;
        //         $update_wogo_res = DB::table('work_good')
        //             ->where('wogo_wor_id', $find_work->wor_id)
        //             ->where('wogo_goo_id', $request['goo_id'])
        //             ->update($update_wogo_data);
        //     } else {
        //         $update_wogo_res = true;
        //     }
        // } else {
        //     $update_orgo_res = true;
        //     $update_wogo_res = true;
        // }
        if ($update_res && $update_wor_res) {
            return ['code'=>200, 'msg'=>'修改价格成功', 'data'=>'修改价格成功'];
        } else {
            return ['code'=>500, 'msg'=>'修改价格失败', 'data'=>'修改价格失败'];
        }
    }

    public static function getOrderHistory($user_info, $request)
    {
        $find_data = DB::table('work_order_history')
            ->where('wohi_primary_id', $request['ord_id'])
            ->where('wohi_type', 1)
            ->select('wohi_state_name', 'wohi_create_time', 'wohi_state')
            ->orderBy('wohi_state', 'asc')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_data];
    }

    // 验车结果
    public static function validateCarData($user_info, $request)
    {
        // 查询验车信息
        $validate_car_data = DB::table('wash_order_validate_car as w')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'w.orvc_ord_id')
            ->where('orvc_ord_id', $request['ord_id'])
            ->select('orvc_mileage', 'orvc_car_interior', 'orvc_car_exterior', 'orcl_signature_img')
            ->first();
        // 补充验车信息
        $chsu_data = DB::table('checkcar_supplement')
            ->where('chsu_ord_id', $request['ord_id'])
            ->select('chsu_id', 'chsu_img', 'chsu_explain', 'chsu_sign')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$validate_car_data, 'chsu_data'=>$chsu_data];
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0)
    {
        $entity = WashOrder::where('ord_id', $id)
            ->where('ord_shop_id', $shopID)
            ->select($fields)
            ->first();

        return $entity;
    }
}
