<?php
namespace App\Services\Business;

use App\Models\Business\DispatchGoods;
use App\Models\Business\Goods;
use App\Models\Business\Member;
use App\Models\Business\OrderClient;
use App\Models\Business\OrderGoods;
use App\Models\Business\OrderSettlementDetails;
use App\Models\Business\RecedeClient;
use App\Models\Business\RecedeGoods;
use App\Models\Business\RecedeRecycle;
use App\Models\Business\ReceivablePay;
use App\Models\Business\RecLog;
use App\Models\Business\Refund;
use App\Models\Business\ServiceProject;
use App\Models\Business\WarehouseGoods;
use App\Models\Business\WorkClient;
use App\Models\Business\WorkGood;
use App\Models\Business\DispatchBill as DispatchBillModel;
use App\Models\Business\WorkOrder;
use App\Models\SettleIn;
use App\Services\Business\WashOrderBasicService;
use App\Services\CommonService;
use App\Services\LoginUserService;
use App\Services\ReceivablePay\ReceivablePayService;
use App\Services\Shop\ShopService;
use Illuminate\Support\Facades\Request;
use App\Models\Business\WashOrder;
use BlueCity\Core\Service\Service;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\WashOrderValidator;
use BlueCity\Core\Inc\ErrorInc;
use App\Http\Models\Api\DispatchBill;
use App\Services\WeChatApplet\User\MemberCarService;
use App\Http\Models\Api\CashierDesk;
use App\Services\Business\WashWorkService;
use App\Services\Business\WashPayservice;
use App\Http\Enum\Business\OrderEnum;
use \Illuminate\Support\Facades\Validator;
use App\Http\Models\Api\Common as nCommon;
use App\Services\WeChatApplet\Technician\MemberService;
use App\Services\Business\NewOrderService;
use App\Services\Point\PointService;
use App\Services\Business\DeliveryService;
use App\Http\Models\Services\OrderManage\WorkOrders;

class WashOrderService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new WashOrder();
        $this->mainValidator = new WashOrderValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /*
     * @name 状态值
     * @param string ju_ordernum
     * @retrun array
     * @author Ma 2023/8/3 19:39
     *
    */
    public static function getStatsName($type=false)
    {
        $status_names = [['type'=>'0','value'=>'全部'],['type'=>'7','value'=>'待接单'],['type'=>'1','value'=>'待派单'],['type'=>'2','value'=>'服务中'],['type'=>'4','value'=>'待评价'],['type'=>'20','value'=>'已完成'],['type'=>'11','value'=>'已取消'],['type'=>'21','value'=>'挂起'],['type'=>'12','value'=>'取消待审核']];
        if($type){
            $status_names = array_column($status_names,'value','type');
        }
        return $status_names;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10, $type = 1)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }
        if (!isset($search_data['ord_service_type'])) {
            $search_data['ord_service_type'] = [1,2];
        }
        // 获取枚举数据
        $object_enum = new OrderEnum();
        $ord_source_enum = $object_enum->ord_source_enum;

        $ord_id = [];
        // 查询小程序的待付款的订单
        // $ord_id = DB::table('order as ord')
        //     ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
        //     ->where('ord_shop_id', $user_info->adm_shop_id)
        //     ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
        //     ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
        //     ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
        //     ->where('ord_source', 2)
        //     ->where('ord_state', 1)
        //     ->where('ord_wor_state', '!=', 11)//取消订单
        //     ->select('ord_id')
        //     ->get()->toArray();
        $ord_ids = array_column($ord_id, 'ord_id');
        $list_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'orcl.orcl_sales_adm_id')
            ->rightJoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->whereNotIn('ord_id', $ord_ids)
            ->where(function ($query) use ($search_data) { //订单类型搜索
                if (!empty($search_data['ord_service_type'])) {
                    $query->whereIn('ord_service_type', $search_data['ord_service_type']);
                    if ($search_data['ord_wor_state'] == 2 && isset($search_data['appoint']) && $search_data['appoint'] == 2){//服务中未预约得，不要洗车单
                        $query->whereIn('ord_service_type', array_diff($search_data['ord_service_type'],[2]));
                    }
                }

                if (!empty($search_data['ord_new_type'])) {//订单分类
                    $query->where('ord_new_type', $search_data['ord_new_type']);
                }

                if (!empty($search_data['orcl_sales_adm_id'])) {//销售人员搜索
                    $query->where('orcl_sales_adm_id', $search_data['orcl_sales_adm_id']);
                }

                if (!empty($search_data['ord_classify'])) {//订单分类：1蓄电池2洗美店3易损件
                    $query->where('ord_classify', $search_data['ord_classify']);
                }

                if (!empty($search_data['ord_type'])) {//买家类型：1会员零售2企业客户
                    $query->where('ord_type', $search_data['ord_type']);
                }
                if (!empty($search_data['ord_create_id'])) {
                    $query->where('ord_create_id', $search_data['ord_create_id']);
                }
                if (!empty($search_data['ord_state'])) {
                    $query->where('ord_state', $search_data['ord_state']);
                }
                if (!empty($search_data['ord_source'])) {
                    $query->where('ord_source', $search_data['ord_source']);
                }
            })
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('orcl_phone', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('orcl_name', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('ord_order_number', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('orcl_car_num', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('orcl_car_brand_series', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('adm_name', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%')
                        ->Orwhere('ord_other_system_number', 'like', '%' . $search_data['ord_order_number'] . '%')
                        ->Orwhere('ord_other_order_num', 'like', '%' . $search_data['ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_name'])) {
                    $query->where('orcl_name', 'like', '%' . $search_data['orcl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_phone'])) {
                    $query->where('orcl_phone', 'like', '%' . $search_data['orcl_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_carowner_name'])) {
                    $query->where('orcl_carowner_name', 'like', '%' . $search_data['orcl_carowner_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_carowner_phone'])) {
                    $query->where('orcl_carowner_phone', 'like', '%' . $search_data['orcl_carowner_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_car_num'])) {
                    $query->where('orcl_car_num', 'like', '%' . $search_data['orcl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_wor_state']) && !in_array($search_data['ord_wor_state'],[21,22])) {
                    $query->where('ord_wor_state', $search_data['ord_wor_state'])
                        ->where('ord_suspended', 2);
                } elseif (!empty($search_data['ord_wor_state']) && $search_data['ord_wor_state'] == 21) {
                    $query->whereIn('ord_wor_state', [4,20])
                        ->where('ord_suspended', 2);
                } elseif (!empty($search_data['ord_wor_state']) && $search_data['ord_wor_state'] == 22) {
                    $query->where('ord_suspended', 1);
                }
                if ($search_data['ord_wor_state'] == 2 && isset($search_data['appoint']) && $search_data['appoint'] == 2){
                    $query->where('orcl_appoint_time', '0000-00-00 00:00:00');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (isset($search_data['ord_payment_way'])) {
                    if (!empty($search_data['ord_payment_way'])) {
                        $query->where('ord_payment_way', $search_data['ord_payment_way']);
                    } elseif ($search_data['ord_payment_way'] ===0) {
                        $query->where('ord_payment_way', $search_data['ord_payment_way']);
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //预约时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['appoint_time_start']) && !empty($search_data['appoint_time_end'])) {
                    $query->whereBetween('orcl_appoint_time', [$search_data['appoint_time_start'], $search_data['appoint_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['appoint_time_start'])) {
                        $query->where('orcl_appoint_time', '>=', $search_data['appoint_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['appoint_time_end'])) {
                            $query->where('orcl_appoint_time', '<=', $search_data['appoint_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_client_id'])) {
                    $query->where('ord_client_id', $search_data['ord_client_id']);
                }
            })
            ->where(function ($query) use ($type,$search_data,$user_info) {
                if ($type == 2) {
                    if ($search_data['search_all'] != 1) {
                        $query->where('orcl_sales_adm_id', $user_info->adm_id);
                    }
                }
            })
            ->where(function ($query) use ($search_data) { //实际金额区间搜索
                // 如果选择最小钱数并且选择最大钱数
                if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                    $query->whereBetween('ord_actual_price', [$search_data['min_price'] * 100, $search_data['max_price'] * 100]);
                } else {
                    // 如果选择最小钱数
                    if (!empty($search_data['min_price'])) {
                        $query->where('ord_actual_price', '>=', $search_data['min_price'] * 100);
                    } else {
                        // 如果选择最大钱数
                        if (!empty($search_data['max_price'])) {
                            $query->where('ord_actual_price', '<=', $search_data['max_price'] * 100);
                        }
                    }
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_address_type']) && !empty($search_data['ord_address_id'])) {
                    $query->where('ord_address_type', $search_data['ord_address_type'])
                        ->where('ord_address_id', $search_data['ord_address_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orgo_goo_name'])) {
                    $query->where('orgo_goo_name', $search_data['orgo_goo_name']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orgo_goo_goods_encode'])) {
                    $query->where('orgo_goo_type', 3)
                        ->where('orgo_goo_goods_encode', $search_data['orgo_goo_goods_encode']);
                }
            })
            ->select('ord_id', 'ord_order_number', 'ord_actual_price', 'ord_type', 'ord_order_state', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'ord_create_time', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_car_brand_series', 'orcl_car_vin', 'orcl_sales_adm_id', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'orcl_business_name', 'ord_shop_id', 'ord_address_type', 'ord_address_id', 'ord_service_type', 'ord_settlement_time', 'ord_settlement_adm_id', 'ord_payment_way', 'orcl_mem_source', 'orcl_carbrse_type', 'ord_explain', 'ord_create_id', 'ord_ware_id','ord_pay_state','ord_zero_price','ord_source', 'ord_other_order_num','ord_other_system_number','orcl_province','orcl_city','orcl_county','orcl_address', 'ord_add_type', 'ord_customer_state', 'ord_client_id','ord_new_type', 'ord_suspended', 'ord_suspended_time', 'ord_openbill', 'ord_openbill_number', 'ord_openbill_image')
            ->orderByRaw("FIELD(ord_wor_state, 11)")
            ->orderBy('ord_id', $orderby_type)
            ->groupBy('ord_id')
            ->paginate($show_count);

        $list_items = $list_data->items();
        $all_status = self::getStatsName(true);
        if ($list_items) {
            $ord_source = array_column($ord_source_enum, 'state_show', 'state');
            $ord_id = array_column($list_items, 'ord_id'); //订单id
            $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // 查询商品、项目信息
            $order_goods = DB::table('order_goods as orgo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->whereIn('orgo_ord_id', $ord_id)
                ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_unit', 'orgo_goo_unta_id', 'goo_unit_conversion', 'orgo_goo_price', 'orgo_goo_amount', 'orgo_goo_return_quantity')
                ->get()->toArray();
            $orcl_sales_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_sales_adm_id'))); //销售人员id
            $service_shop_id = array_filter(array_unique(array_column($list_items, 'ord_shop_id'))); //门店id
            $ord_settlement_adm_id = array_filter(array_unique(array_column($list_items, 'ord_settlement_adm_id'))); //结算人

            $adm_id_merge = $orcl_sales_adm_id;
            $adm_id_merge = array_merge($adm_id_merge, $ord_settlement_adm_id);
            $adm_id_merge = array_merge($adm_id_merge, $ord_create_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();
            // 查询录单人信息
            $find_shop = DB::table('shop')
                ->whereIn('shop_id', $service_shop_id)
                ->pluck('shop_store_name', 'shop_id')->toArray();
            $all_return_goods = [];
            foreach ($order_goods as $key => $value) {
                $order_goods[$key]->service_adm_name = '';
                // if ($value->orgo_goo_unta_id == 1) {
                //     $order_goods[$key]->orgo_goo_quantity = $value->orgo_goo_quantity*$value->goo_unit_conversion.'米('.$value->orgo_goo_quantity.'卷)';
                // } else {
                //     $order_goods[$key]->orgo_goo_quantity = $value->orgo_goo_quantity.$value->orgo_goo_unit;
                // }
                //订单商品是否已经全部退货
                $all_order_return[$value->orgo_ord_id] = false;//默认不可以退货
                if($value->orgo_goo_type == 1){//商品类型 1商品2服务3套餐商品4会员卡5充值卡
                    $all_return_goods[$value->orgo_ord_id][$value->orgo_goo_id] = $value->orgo_goo_quantity - $value->orgo_goo_return_quantity;//订单商品数量 - 退货数量
                }
            }
            if($all_return_goods){
                foreach ($all_return_goods as $re_key => $re_value) {
                    foreach ($re_value as $r_key => $r_value){
                        if($r_value > 0){
                            $all_order_return[$re_key] = true;//还有商品，可以退货
                        }
                    }
                }
            }

            $typeName = WashOrderService::getPaymentWayName(true);//获取支付方式名称

            foreach ($list_items as $key => $value) {
                if (empty($value->ord_new_type)) {
                    $updata_type['ord_new_type'] = DB::table('order_type')
                        ->where('orty_shop_id', $user_info->adm_shop_id)
                        ->where('orty_state', 1)
                        ->value('orty_id');
                    $update_type_res = DB::table('order')
                        ->where('ord_id', $value->ord_id)
                        ->update($updata_type);
                    $list_items[$key]->ord_new_type = $updata_type['ord_new_type'];
                    $value->ord_new_type = $updata_type['ord_new_type'];
                }
                $list_items[$key]->mem_salesman_id = 0;
                $list_items[$key]->mem_sale_name = '';
                if (!empty($value->orcl_client_id) && $value->ord_type == 1) {
                    $member_sale_data = DB::table('member')
                        ->leftJoin('admin', 'adm_id', '=', 'mem_salesman_id')
                        ->where('mem_id', $value->orcl_client_id)
                        ->select('mem_salesman_id', 'adm_name as mem_sale_name')
                        ->first();
                    if (!empty($member_sale_data)) {
                        $list_items[$key]->mem_salesman_id = $member_sale_data->mem_salesman_id;
                        $list_items[$key]->mem_sale_name = $member_sale_data->mem_sale_name;
                    }
                }
                $list_items[$key]->ord_new_type_name = DB::table('order_type')
                    ->where('orty_id', $value->ord_new_type)
                    ->value('orty_name');
                // 实付金额等于 订单金额减去抹零金额，实际上应该和ord_actual_price 相等，但是还是在算一下吧；
                $list_items[$key]->pay_price=$value->ord_order_price-$value->ord_zero_price;
                // 优惠金额等于抹零金额
                $list_items[$key]->discount_price=$value->ord_zero_price;

                if ($value->ord_payment_way == 5) {
                    $list_items[$key]->myvi_name = DB::table('vip_card_record as vcre')
                        ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vcre.vcre_myvi_id')
                        ->where('vcre_ord_id', $value->ord_id)
                        ->value('myvi_name');
                } else {
                    $list_items[$key]->myvi_name = '';
                }
                // 订单来源
                if (isset($ord_source[$value->ord_source])) {
                    $list_items[$key]->ord_source_show = $ord_source[$value->ord_source];
                } else {
                    $list_items[$key]->ord_source_show = '';
                }

                // 创建人
                if ($value->ord_create_id && isset($find_adm[$value->ord_create_id])) {
                    $list_items[$key]->adm_name = $find_adm[$value->ord_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                if ($value->ord_ware_id) {
                    $list_items[$key]->ware_name = DB::table('warehouse')
                        ->where('ware_id', $value->ord_ware_id)
                        ->value('ware_name');
                } else {
                    $list_items[$key]->ware_name = '';
                }
                // 门店名称
                if ($value->ord_shop_id) {
                    $list_items[$key]->shop_store_name = $find_shop[$value->ord_shop_id];
                } else {
                    $list_items[$key]->shop_store_name = '';
                }
                // 销售人员
                if ($value->orcl_sales_adm_id  && isset($find_adm[$value->orcl_sales_adm_id])) {
                    $list_items[$key]->orcl_sales_adm_name = $find_adm[$value->orcl_sales_adm_id];
                } else {
                    $list_items[$key]->orcl_sales_adm_name = '';
                }
                // 结算人员
                if ($value->ord_settlement_adm_id && isset($find_adm[$value->ord_settlement_adm_id])) {
                    $list_items[$key]->ord_settlement_adm_name = $find_adm[$value->ord_settlement_adm_id];
                } else {
                    $list_items[$key]->ord_settlement_adm_name = '';
                }
                // 预约时间
                if ($value->orcl_appoint_time == '0000-00-00 00:00:00') {
                    $list_items[$key]->orcl_appoint_time = '';
                }
                // 施工地址
                if ($value->ord_address_type == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_address_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                        $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->ord_address = '';
                    }
                } elseif ($value->ord_address_type == 2) {
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value->ord_address_id)
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->bucl_name;
                        $list_items[$key]->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->ord_address = '';
                    }
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_shop_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    if ($find_address) {
                        $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                        $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                    } else {
                        $list_items[$key]->shop_store_name = '';
                        $list_items[$key]->ord_address = '';
                    }
                }
                //待接单隐藏手机号
                if($value->ord_wor_state == 7 && $value->ord_source == 5){
                    $list_items[$key]->orcl_carowner_phone = substr_replace($value->orcl_carowner_phone,'****',3,4);
                    $list_items[$key]->orcl_carowner_name = mb_substr($value->orcl_carowner_name,0,1,'utf-8').str_repeat("*",(strlen($value->orcl_carowner_name)/2-1));
                    $list_items[$key]->orcl_name = mb_substr($value->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($value->orcl_name)/2-1));
                }
                $status_name = $all_status[$value->ord_wor_state]??'';
                $list_items[$key]->ord_wor_state_name = $status_name;
                if ($value->ord_suspended == 1) {
                    $list_items[$key]->ord_wor_state_name = '已挂起';
                }
                // if($value->ord_wor_state == 2 && $value->orcl_appoint_time == ''){$status_name = '未预约';}
                if ($type == 1) {
                    $tuihuo = false;
                    //已结算或者已经发货
                    $wor_number = DB::table('work_order')
                        ->where('wor_order_id', $value->ord_id)
                        ->value('wor_number');
                    $dispatch_data = 1;//类型：1未出库2已出库
                    if($wor_number){
                        $dispatch_data = DB::table('dispatch_bill')
                            ->where('dego_cid', $user_info->adm_cid)
                            ->where('dego_superior_shop_id', $user_info->adm_shop_id)
                            ->where('dego_type', '<>', 3)
                            ->where('dego_original_number', $wor_number)
                            ->value('dego_type');
                    }else{
                        $dispatch_data = DB::table('dispatch_bill')
                            ->where('dego_cid', $user_info->adm_cid)
                            ->where('dego_superior_shop_id', $user_info->adm_shop_id)
                            ->where('dego_type', '<>', 3)
                            ->where('dego_original_number', $value->ord_order_number)
                            ->value('dego_type');
                    }
                    //有未处理退货不能申请
                    $return_status = true;
                    $refund_statuss = true;
                    $is_return_good = true;//默认没有申请退货，true 展示取消按钮
                    $return_good_status = DB::table('return_goods')
                        ->where('retgo_order_number', $value->ord_order_number)
                        ->where('retgo_status', 1)
                        ->orderBy('retgo_id','desc')
                        ->value('retgo_return_status');
                    if($return_good_status){
                        if(in_array($return_good_status, [0,3,4])){
                            $return_status = true;
                        }else{
                            $return_status = false;
                            $is_return_good = false;//有退货未完成，false 不展示取消按钮
                        }
                    }
                    $refund_status = DB::table('refund')
                        ->where('ref_order_number', $value->ord_order_number)
                        ->where('ref_cancel', 1)
                        ->orderBy('ref_id','desc')
                        ->value('ref_status');
                    if($refund_status){
                        if(in_array($refund_status, [2,3])){
                            $refund_statuss = true;
                        }else{
                            $refund_statuss = false;
                            $is_return_good = false;//有退款未完成，false 不展示取消按钮
                        }
                    }
                    if($dispatch_data == 2 && $return_status && $refund_statuss && isset($all_order_return[$value->ord_id]) && $all_order_return[$value->ord_id]){//已发货，退货退款都处理完成，就可以申请退款
                        $tuihuo = true;
                    }
                    if(isset($wor_number) && $value->ord_wor_state >= 20){
                        $tuihuo = false;
                    }
                    if ($value->ord_payment_way == 5) {
                        $tuihuo = false;
                    }
                    // 获取当前列表下的按钮
                    $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
                    if ($value->ord_service_type == 1) {//贴膜流程
                        foreach ($list_button as $key_b => $value_b) {
                            if ($value_b['pri_id'] == 590) {//订单详情
                                $list_items[$key]->list_button_one[] = $value_b;
                            }
                            if ($value_b['pri_id'] == 886 && $value->ord_wor_state == 12) {//审核取消
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value->ord_wor_state == 1 && $value_b['pri_id'] == 591 && $value->ord_suspended != 1) {//生成工单
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if (!empty($value->ord_client_id)) {
                                if ($value->ord_wor_state == 5 || $value->ord_wor_state == 20) {
                                    if ($value_b['pri_id'] == 668) {//订单作品
                                        $list_items[$key]->list_button_two[] = $value_b;
                                    }
                                }
                            }
                            if (!in_array($value->ord_wor_state, [4,11,12,20]) && $value_b['pri_id'] == 592 && $value->ord_source != 5 && $is_return_good && $value->ord_add_type == 1) {//取消订单
                                $list_items[$key]->list_button_two[] = $value_b;
                                $list_items[$key]->is_return_good = $is_return_good;
                            }
                            if (!in_array($value->ord_wor_state, [11,12]) && $value_b['pri_id'] == 692 && ($value->ord_state ==1 || $value->ord_state ==3)) {//结算
                                if (($value->ord_wor_state == 7 && $value->ord_source == 4) || $value->ord_source == 5) {
                                } else {
                                    $list_items[$key]->list_button_two[] = $value_b;
                                }
                            }
                            if ($value_b['pri_id'] == 727) {//查看凭证
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value->ord_wor_state == 2 || $value->ord_wor_state == 4 || $value->ord_wor_state == 20) {//售后
                                if ($value_b['pri_id'] == 593) {
                                    $list_items[$key]->list_button_two[] = $value_b;
                                }
                            }
                            $work_order = DB::table('work_order')
                                ->where('wor_order_id',$value->ord_id)
                                ->value('wor_state');
                            if (in_array($value->ord_state, [1]) && (!$work_order || $work_order<=5) && $value_b['pri_id'] == 873 && in_array($value->ord_type, [0,1])) {
                                    $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value->ord_wor_state == 1 && $value_b['pri_id'] == 589 && $value->ord_source != 5) {//编辑
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value_b['pri_id'] == 595) {//备注
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if (!in_array($value->ord_wor_state, [4,20,11]) && $value_b['pri_id'] == 879 && $value->ord_suspended != 1) {//挂起
                                $list_items[$key]->list_button_two[] = $value_b;
                            }

                            if ($value->ord_suspended == 1 && $value_b['pri_id'] == 881) {//取消挂起
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if (!in_array($value->ord_wor_state, [11]) && $value->ord_openbill == 1 && $value_b['pri_id'] == 885) {//开票
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                        }
                    } elseif ($value->ord_service_type == 2) {
                        $list_items[$key]->list_button_one = [];
                        foreach ($list_button as $key_b => $value_b) {
                            if ($value_b['pri_id'] == 727) {//查看凭证
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value_b['pri_id'] == 590) {//订单详情
                                $list_items[$key]->list_button_one[] = $value_b;
                            }
                            if ($value_b['pri_id'] == 707 && $value->ord_wor_state == 7) {//订单接单
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if (in_array($value->ord_wor_state, [7,1,2]) && $value_b['pri_id'] == 777 && !in_array($value->ord_payment_way, [10,11,12]) && $value->ord_payment_way != 5 && $value->ord_source != 5) {//换货
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value->ord_wor_state != 11 && $value->ord_wor_state != 20 && $value_b['pri_id'] == 592 && $is_return_good && $value->ord_add_type == 1) {//取消订单
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            $work_order = DB::table('work_order')
                                ->where('wor_order_id',$value->ord_id)
                                ->value('wor_state');
                            if (in_array($value->ord_state, [1]) && (!$work_order || $work_order<=5) && $value_b['pri_id'] == 873 && in_array($value->ord_type, [0,1])) {
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value->ord_wor_state != 11 && $value_b['pri_id'] == 692 && ($value->ord_state ==1 || $value->ord_state ==3)) {//结算 ord_state1未结算2已结算
                                $list_items[$key]->list_button_two[] = $value_b;
                                // if ($value->ord_wor_state == 1) {
                                // } else {
                                //     $list_items[$key]->list_button_one[] = $value_b;
                                // }
                            }
                            // if ($value->ord_wor_state != 11 && $value_b['pri_id'] == 695 && $value->ord_state ==2) {//取消结算
                            //         $list_items[$key]->list_button_two[] = $value_b;
                            //     // if ($value->ord_wor_state == 1) {
                            //     // } else {
                            //     //     $list_items[$key]->list_button_one[] = $value_b;
                            //     // }
                            // }
                            if ($value_b['pri_id'] == 595) {
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($tuihuo && $value_b['pri_id'] == 761 && $value->ord_add_type == 1) {//申请退款
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                            if ($value_b['pri_id'] == 762 && ($value->ord_add_type == 2 || $value->ord_add_type == 3) && $value->ord_customer_state == 2 && in_array($value->ord_wor_state,[4,20])) {//客户领取
                                $list_items[$key]->list_button_two[] = $value_b;
                            }
                        }
                    }
                }

                $list_items[$key]->ord_suspended_state = $value->ord_suspended == 1 ? '已挂起':'未挂起';
                
                $list_items[$key]->ord_payment_name = WashOrderService::getTypeData($value->ord_payment_way, $typeName);
                if(isset($list_items[$key]->list_button_one) && isset($list_items[$key]->list_button_two)){
                    $new_button = array_merge($list_items[$key]->list_button_one,$list_items[$key]->list_button_two);
                }
                if(isset($new_button)){
                    foreach ($new_button as $but_key => $but_value) {
                        $new_button_pri_id[$but_value['pri_id']] = $but_value['pri_id'];
                    }
                    if(isset($new_button_pri_id[761]) && isset($new_button_pri_id[592])){
                        foreach ($list_items[$key]->list_button_two as $k => $v){
                            if($v['pri_id'] == 592){
                                unset($list_items[$key]->list_button_two[$k]);
                            }
                        }
                        unset($new_button_pri_id);
                    }
                }
            }
            // 查询备注信息
            $order_reamrks = DB::table('order_remarks')
                ->whereIn('orre_ord_id', $ord_id)
                ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
                ->orderby('orre_id', 'desc')
                ->get();

            // 查找操作记录
            $order_log = DB::table('order_log')
                ->whereIn('orlo_ord_id', $ord_id)
                ->orderBy('orlo_id', 'desc')
                ->select('orlo_ord_id', 'orlo_time', 'orlo_create_adm_name', 'orlo_content')
                ->get();
        } else {
            $order_goods = [];
            $order_log = [];
            $order_reamrks = [];
        }
        // 查询订单状态对应的订单数量
        $state_count = DB::table('order')
            // ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_classify', 2)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->where(function ($query) use ($search_data) { //订单类型搜索
                if (!empty($search_data['ord_service_type'])) {
                    $query->whereIn('ord_service_type', $search_data['ord_service_type']);
                }
            })
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get();
        //查找未预约订单数量
        $no_appoint_count = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_classify', 2)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->where('orcl_appoint_time','0000-00-00 00:00:00')
            ->where('ord_wor_state',2)
            ->whereIn('ord_service_type',array_diff($search_data['ord_service_type'],[2]))
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->whereNotIn('ord_id', $ord_ids)
            ->groupBy('ord_wor_state')
            ->first();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //订单商品数据
        $data['state_count'] = $state_count;
        $data['order_log'] = $order_log;                    //操作记录
        $data['order_reamrks'] = $order_reamrks;           //订单备注
        $data['ord_source_enum'] = $ord_source_enum;           //订单来源
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        $wheres['ord_shop_id'] = $user_info->adm_shop_id;
        $wheres['ord_classify'] = 2;
        $wheres['ord_collection_bill'] = 1;
        $wheres['ord_is_split_noteq'] = 3;
        $wheres['ord_id_notin'] = $ord_ids;
        $wheres['ord_service_type_searchin'] = $search_data['ord_service_type'];
        $data['showcount'] = self::getStatusBar($wheres, $user_info);
        // if (empty($no_appoint_count)) {
        //     $data['showcount'][3]['shownum'] = 0;
        // } else {
        //     $data['showcount'][3]['shownum'] = $no_appoint_count->count;
        // }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取顶部状态栏
     * @param array $where 查询条件
     * @retrun /multitype:array
     * @author dou 2023-06-06 006 下午 3:45:04
     * |---------------------------------------------------------------------------------
     */
    public static function getStatusBar ($where, $user_info){
        $showcount = [
            ['showname' => "全部", 'shownum' => '0','ord_wor_state'=>0],
            // ['showname' => "待接单", 'shownum' => '0','ord_wor_state'=>7],
            ['showname' => "待派单", 'shownum' => '0','ord_wor_state'=>1],
            // ['showname' => "未预约", 'shownum' => '0','ord_wor_state'=>2,'appoint'=>2],
            ['showname' => "服务中", 'shownum' => '0','ord_wor_state'=>2],
            // ['showname' => "待评价", 'shownum' => '0','ord_wor_state'=>4],
            ['showname' => "已取消", 'shownum' => '0','ord_wor_state'=>11],
            ['showname' => "已完成", 'shownum' => '0','ord_wor_state'=>20],
            ['showname' => "已挂起", 'shownum' => '0','ord_wor_state'=>22],
            ['showname' => "取消待审核", 'shownum' => '0','ord_wor_state'=>12],
        ];
        foreach( $showcount as $k => $v ){
            $showcount[$k]['shownum'] = self::getStatusNum($v['ord_wor_state'],$where);
            if ($v['ord_wor_state'] == 22) {
                $showcount[$k]['shownum'] = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_suspended', 1)
                    ->count();
            }
        }
        return $showcount;
    }

    /**
     * 获取指定状态数量
     * @param string $status 状态栏参数
     * @param array $where 查询条件
     * @return /multitype:array
     * @author dou 2023-06-06 006 下午 3:45:04
     */
    public static function getStatusNum ( $status,$where){
        if($status > 0){
            $db = new WashOrder();
            $where['ord_wor_state'] = $status;
            $where['ord_suspended'] = 2;
            $num = CommonService::getMysqlData($db,$where,[],[],'count');
            $num = $num??'0';
            return $num;
        }else{
            return '--';
        }
    }

    /**
     * 客户端小程序-根据条件搜索数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function searchClientPage($user_info, $search_data, $show_count = 10)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }
        $list_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'ord.ord_shop_id')
            // ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($user_info) { //订单删除状态 是否删除：1正常订单2取消订单
                if (!empty($user_info->ussh_user_id)) {
                    $query->where('ord_client_id', $user_info->ussh_user_id);
                } else {
                    $query->where('ord_client_id', '!=', 0);
                }
            })
            ->where('ord_type', 1) //买家类型：1门店零售2客户单位
            ->where('ord_pay_state', 1) //是否支付  1 是;  2 否
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            // ->where('ord_delete', 1) //是否删除：1正常订单2取消订单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->whereIn('ord_is_split', [1, 2]) //订单拆分
            ->whereIn('ord_service_type', [1, 2, 3, 4]) //订单类型：1服务单 2洗车单3商品单4会员卡
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['keywords'] . '%') //订单单号
                    ->orwhere('orcl_phone', 'like', '%' . $search_data['keywords'] . '%') //客户电话
                    ->orwhere('orcl_name', 'like', '%' . $search_data['keywords'] . '%') //客户姓名
                    ->orwhere('orcl_car_num', 'like', '%' . $search_data['keywords'] . '%') //车牌号
                    ->orwhere('orcl_car_vin', 'like', '%' . $search_data['keywords'] . '%') //车架号车辆识别码
                    ->orwhere('ord_order_number', 'like', '%' . $search_data['keywords'] . '%'); //车型
                }
            })
            ->where(function ($query) use ($search_data) { //订单删除状态 是否删除：1正常订单2取消订单
                if (!empty($search_data['ord_delete'])) {
                    $query->where('ord_delete', $search_data['ord_delete']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单状态
                if (!empty($search_data['ord_wor_state']) && $search_data['ord_wor_state'] != 9999) {
                    $query->where('ord_wor_state', $search_data['ord_wor_state']);
                }
            })
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_order_price', 'ord_actual_price', 'ord_type', 'ord_order_state', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'shop_store_name', 'orcl_car_vin', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_car_brand_series', 'orcl_carowner_phone', 'orcl_carowner_name', 'orcl_carbrse_type','ord_source','ord_payment_way','ord_zero_price','ord_service_type', 'ord_add_type')  //列表增加 来源 和 支付方式 等字段
            ->orderBy('ord_create_time', $orderby_type)
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            // 处理一下列表数据，给列表增加 实付金额，优惠金额，和会员卡名称等字段；
            $else_ordid=[];
            foreach ($list_items as $key => $val) {
                // 实付金额等于 订单金额减去抹零金额，实际上应该和ord_actual_price 相等，但是还是在算一下吧；
                $list_items[$key]->pay_price=$val->ord_order_price-$val->ord_zero_price;
                // 优惠金额等于抹零金额
                $list_items[$key]->discount_price=$val->ord_zero_price;
                if ($val->ord_payment_way == 5) {
                    $list_items[$key]->myvi_name = DB::table('vip_card_record as vcre')
                        ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vcre.vcre_myvi_id')
                        ->where('vcre_ord_id', $val->ord_id)
                        ->value('myvi_name');
                } else {
                    $list_items[$key]->myvi_name = '';
                }
                if($val->ord_source == 2){
                    $else_ordid[]=$val->ord_id;
                }
            }

            $ord_id = array_column($list_items, 'ord_id'); //订单id
            $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // 查询商品、项目信息
            $order_goods = DB::table('order_goods as orgo')
                ->whereIn('orgo_ord_id', $ord_id)
                ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_amount', 'orgo_pogg_id')
                ->get()->toArray();

            // 将车主端添加的订单判断一下，如果商品类型存在orgo_goo_type=3 的情况，则 其他两种类型都不给页面返回； 
            $temp_goods=[];
            foreach ($order_goods as $key => $val) {
                $temp_goods[$val->orgo_ord_id][]=$val;
            }
            foreach ($temp_goods as $key => $val) {
                if(!in_array($key,$else_ordid)) continue;

                $is_orgo_type=1;
                foreach ($val as $k => $v) {
                    if($v->orgo_goo_type == 3){
                        $is_orgo_type=2;
                    }
                }
                if($is_orgo_type == 1) continue;

                foreach ($val as $k => $v) {
                    if($v->orgo_goo_type != 3){
                        unset($val[$k]);
                    }
                }
                $temp_goods[$key]=$val;
            }
            $order_goods=[];
            foreach ($temp_goods as $key => $val) {
                foreach ($val as $k => $v) {
                    $order_goods[]=$v;
                }
            }
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $ord_create_id)
                ->pluck('adm_name', 'adm_id')->toArray();

            foreach ($order_goods as $key => $value) {
                // 服务项目图片路径
                if ($value->orgo_goo_type == 2) {
                    $order_goods[$key]->goo_image = DB::table('service_project')
                        ->where('sepr_id', $value->orgo_goo_id)
                        ->value('sepr_img');
                } elseif($value->orgo_goo_type == 1){
                    $order_goods[$key]->goo_image = DB::table('goods')
                        ->where('goo_id', $value->orgo_goo_id)
                        ->value('goo_pic');
                    if (empty($order_goods[$key]->goo_image)) {
                        $order_goods[$key]->goo_image = config('apisystem.server_name_https').'/storage/image/default_goo_img.png';
                    }
                } elseif($value->orgo_goo_type == 3){
                    $pic_jsonstr = DB::table('package_items')
                        ->where('pait_id', $value->orgo_goo_id)
                        ->value('pait_pic');
                    if(!empty($pic_jsonstr)){
                        $pic_arr=json_decode($pic_jsonstr,true);
                        if(is_array($pic_arr) && isset($pic_arr[0])){
                            $order_goods[$key]->goo_image=$pic_arr[0];
                        }
                    } else {
                        $order_goods[$key]->goo_image = config("apisystem.server_name")."/image/customer/NoPic.jpg";
                    }
                } else {
                    $order_goods[$key]->goo_image = 'image/customer/vip_pic_none.png'; //显示图片
                }
                //积分商品设置了图片使用设置的
                if($value->orgo_pogg_id){
                    $pogg_pic_ret = DB::table('point_gift_goods')
                        ->where('pogg_id', $value->orgo_pogg_id)
                        ->value('pogg_pic');
                    if($pogg_pic_ret){
                        $pogg_pic = json_decode($pogg_pic_ret,true);
                        if(isset($pogg_pic[0])){
                            $order_goods[$key]->goo_image = $pogg_pic[0];
                        }
                    }
                }
                if (empty($value->orgo_goo_name)) {
                    $order_goods[$key]->orgo_goo_name = '';
                    $order_goods[$key]->orgo_goo_quantity = '';
                }
                if($order_goods[$key]->goo_image != '' && substr($order_goods[$key]->goo_image,0,4)!='http'){
                    ltrim($order_goods[$key]->goo_image,'/');
                    $order_goods[$key]->goo_image=config("apisystem.server_name")."/".$order_goods[$key]->goo_image;
                }
                if (empty($order_goods[$key]->goo_image)) {
                    $order_goods[$key]->goo_image = config("apisystem.server_name")."/image/customer/NoPic.jpg";
                }
            }

            // 查询工单完成时间
            $find_wor_data = DB::table('work_order')
                ->whereIn('wor_order_id', $ord_id)
                ->pluck('wor_achieve_time', 'wor_order_id')->toArray();
            foreach ($list_items as $key => $value) {
                // 创建人
                if ($value->ord_create_id && isset($find_adm[$value->ord_create_id])) {
                    $list_items[$key]->adm_name = $find_adm[$value->ord_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                // 技师完成时间
                if (isset($find_wor_data[$value->ord_id]) && $find_wor_data[$value->ord_id] != '0000-00-00 00:00:00') {
                    $list_items[$key]->wor_achieve_time = $find_wor_data[$value->ord_id];
                } else {
                    $list_items[$key]->wor_achieve_time = '';
                }
                // 订单作品
                if ($value->ord_wor_state >= 4) {
                    $list_items[$key]->order_works = DB::table('order_works')
                        ->where('orwo_ord_id', $value->ord_id)
                        ->where('orwo_delete', 2)
                        ->select('orwo_title', 'orwo_type', 'orwo_description', 'orwo_data')
                        ->get()->toArray();
                }
            }
        } else {
            $order_goods = [];
        }

        $reli_data = DB::table('wash_reservation_list as reli')
            ->where('reli_client_id', $user_info->ussh_user_id)
            ->where('reli_client_type', 1) //买家类型：1门店零售2客户单位
            ->where('reli_state', 1) //预约单状态：1待接单2已接单3取消订单4已撤回
            ->select(DB::raw('count(*) as count, reli_state'))
            ->groupBy('reli_state')
            ->get();
        // 查询订单状态对应的订单数量
        $state_count = DB::table('order')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_client_id', $user_info->ussh_user_id)
            ->where('ord_type', 1) //买家类型：1门店零售2客户单位
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->whereIn('ord_is_split', [1,2]) //是否拆分
            ->where('ord_delete', 1) //是否删除：1正常订单2取消订单
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //订单商品数据
        $data['state_count'] = $state_count;
        $data['reli_count'] = $reli_data;
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    /**
     * 客户端技师小程序-根据条件搜索预约单数据内容
     *
     * @param object $user_info 用户信息
     * @param array $search_data 内容
     * @param int $show_count 页容量
     * @return mixed
     */
    public function reindex($user_info, $search_data, $show_count = 10)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        $list_data = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'recl.recl_reli_id', '=', 'reli.reli_id')
            ->leftJoin('wash_reservation_items as reit', 'reit.reit_reli_id', '=', 'reli.reli_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'reli.reli_shop_id')
            ->where('reli_client_id', $user_info->ussh_user_id)
            ->where('reli_client_type', 1) //买家类型：1门店零售2客户单位
            ->where('reli_state', 1) //预约单状态：1待结单2已接单3取消订单4已撤回
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('reli_number', 'like', '%' . $search_data['keywords'] . '%') //订单单号
                    ->orwhere('recl_phone', 'like', '%' . $search_data['keywords'] . '%') //客户电话
                    ->orwhere('recl_name', 'like', '%' . $search_data['keywords'] . '%') //客户姓名
                    ->orwhere('recl_car_num', 'like', '%' . $search_data['keywords'] . '%') //车牌号
                    ->orwhere('recl_car_vin', 'like', '%' . $search_data['keywords'] . '%') //车架号车辆识别码
                    ->orwhere('recl_car_brand_series', 'like', '%' . $search_data['keywords'] . '%'); //品牌车系
                }
            })
            ->where(function ($query) use ($search_data) { //预约单状态：1待结单2已接单3取消订单4已撤回
                if (!empty($search_data['reli_state'])) {
                    $query->where('reli_state', $search_data['reli_state']);
                }
            })
            ->select('reli_id', 'shop_store_name', 'reli_number', 'reli_order_number', 'reli_state', 'reli_appoint_time_slot', 'reli_appoint_time', 'reli_appoint_remark', 'reli_remark', 'reit_sepr_name', 'reli_create_time', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'reit_sepr_id', 'reli_ord_id')
            ->orderBy('reli_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $ord_id = array_column($list_items, 'reli_ord_id'); //订单id
            // $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // // 查询商品、项目信息
            // // $order_goods = DB::table('order_goods as orgo')
            // //     ->leftjoin('wash_order_items as woi', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            // //     ->whereIn('orgo_ord_id', $ord_id)
            // $order_goods = DB::table('wash_order_items as woi')
            //     ->leftjoin('order_goods as orgo', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            //     ->whereIn('orit_ord_id', $ord_id)
            //     ->select('orgo_id', 'orit_ord_id as orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orit_id', 'orit_sepr_id', 'orit_sepr_name', 'orit_part_state', 'orit_service_price', 'orit_service_adm_id')
            //     ->get()->toArray();
            // $pick_up_car_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_pick_up_car_adm_id'))); //接车人id
            // $service_adm_id = array_filter(array_unique(array_column($order_goods, 'orit_service_adm_id'))); //选的技师id
            // $adm_id_merge = array_merge($ord_create_id, $service_adm_id);
            // $adm_id_merge = array_merge($adm_id_merge, $pick_up_car_adm_id);
            // // 查询录单人信息
            // $find_adm = DB::table('admin')
            //     ->whereIn('adm_id', $adm_id_merge)
            //     ->pluck('adm_name', 'adm_id')->toArray();
            $reit_sepr_id = array_filter(array_unique(array_column($list_items, 'reit_sepr_id'))); //服务项目id
            // 查询服务项目图片
            $find_sepr = DB::table('service_project')
                ->whereIn('sepr_id', $reit_sepr_id)
                ->pluck('sepr_img', 'sepr_id')->toArray();

            foreach ($list_items as $key => $value) {
                // 服务项目图片路径
                if (isset($find_sepr[$value->reit_sepr_id]) && !empty($find_sepr[$value->reit_sepr_id])) {
                    $list_items[$key]->sepr_img = $find_sepr[$value->reit_sepr_id];
                } else {
                    $list_items[$key]->sepr_img = 'image/xmc/xx_icon.png'; //显示图片
                }
            }

            // 查询工单完成时间
            $find_wor_data = DB::table('work_order')
                ->whereIn('wor_order_id', $ord_id)
                ->pluck('wor_achieve_time', 'wor_order_id')->toArray();
            foreach ($list_items as $key => $value) {
                // 技师完成时间
                if (isset($find_wor_data[$value->reli_ord_id]) && $find_wor_data[$value->reli_ord_id] != '0000-00-00 00:00:00') {
                    $list_items[$key]->wor_achieve_time = $find_wor_data[$value->reli_ord_id];
                } else {
                    $list_items[$key]->wor_achieve_time = '';
                }
            }
        } else {
            $order_goods = [];
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 合作商预约单
    public function busreindex($user_info, $search_data, $show_count = 10)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        $list_data = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'recl.recl_reli_id', '=', 'reli.reli_id')
            ->leftJoin('wash_reservation_items as reit', 'reit.reit_reli_id', '=', 'reli.reli_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'reli.reli_shop_id')
            ->where('reli_client_id', $user_info->buac_id)
            ->where('reli_client_type', 2) //买家类型：1门店零售2客户单位
            ->where('reli_state', 1) //预约单状态：1待接单2已接单3取消订单4已撤回
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('reli_number', 'like', '%' . $search_data['keywords'] . '%') //预约单号
                    ->orwhere('recl_phone', 'like', '%' . $search_data['keywords'] . '%') //客户电话
                    ->orwhere('recl_name', 'like', '%' . $search_data['keywords'] . '%') //客户姓名
                    ->orwhere('recl_car_num', 'like', '%' . $search_data['keywords'] . '%') //车牌号
                    ->orwhere('recl_car_vin', 'like', '%' . $search_data['keywords'] . '%') //车架号车辆识别码
                    ->orwhere('recl_car_brand_series', 'like', '%' . $search_data['keywords'] . '%'); //品牌车系
                }
            })
            ->where(function ($query) use ($search_data) { //预约单状态：1待结单2已接单3取消订单4已撤回
                if (!empty($search_data['reli_state'])) {
                    $query->where('reli_state', $search_data['reli_state']);
                }
            })
            ->select('reli_id', 'shop_store_name', 'reli_number', 'reli_order_number', 'reli_state', 'reli_appoint_time_slot', 'reli_appoint_time', 'reli_appoint_remark', 'reli_remark', 'reit_sepr_name', 'reli_create_time', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'reit_sepr_id', 'reli_ord_id', 'recl_car_brand_series', 'recl_car_vin', 'reli_explain')
            ->orderBy('reli_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $ord_id = array_column($list_items, 'reli_ord_id'); //订单id
            // $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // // 查询商品、项目信息
            // // $order_goods = DB::table('order_goods as orgo')
            // //     ->leftjoin('wash_order_items as woi', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            // //     ->whereIn('orgo_ord_id', $ord_id)
            // $order_goods = DB::table('wash_order_items as woi')
            //     ->leftjoin('order_goods as orgo', 'woi.orit_orgo_id', '=', 'orgo.orgo_id')
            //     ->whereIn('orit_ord_id', $ord_id)
            //     ->select('orgo_id', 'orit_ord_id as orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orit_id', 'orit_sepr_id', 'orit_sepr_name', 'orit_part_state', 'orit_service_price', 'orit_service_adm_id')
            //     ->get()->toArray();
            // $pick_up_car_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_pick_up_car_adm_id'))); //接车人id
            // $service_adm_id = array_filter(array_unique(array_column($order_goods, 'orit_service_adm_id'))); //选的技师id
            // $adm_id_merge = array_merge($ord_create_id, $service_adm_id);
            // $adm_id_merge = array_merge($adm_id_merge, $pick_up_car_adm_id);
            // // 查询录单人信息
            // $find_adm = DB::table('admin')
            //     ->whereIn('adm_id', $adm_id_merge)
            //     ->pluck('adm_name', 'adm_id')->toArray();
            $reit_sepr_id = array_filter(array_unique(array_column($list_items, 'reit_sepr_id'))); //服务项目id
            // 查询服务项目图片
            $find_sepr = DB::table('service_project')
                ->whereIn('sepr_id', $reit_sepr_id)
                ->pluck('sepr_img', 'sepr_id')->toArray();

            foreach ($list_items as $key => $value) {
                // 服务项目图片路径
                if (isset($find_sepr[$value->reit_sepr_id]) && !empty($find_sepr[$value->reit_sepr_id])) {
                    $list_items[$key]->sepr_img = $find_sepr[$value->reit_sepr_id];
                } else {
                    $list_items[$key]->sepr_img = 'image/xmc/xx_icon.png'; //显示图片
                }
            }

            // 查询工单完成时间
            $find_wor_data = DB::table('work_order')
                ->whereIn('wor_order_id', $ord_id)
                ->pluck('wor_achieve_time', 'wor_order_id')->toArray();
            foreach ($list_items as $key => $value) {
                // 技师完成时间
                if (isset($find_wor_data[$value->reli_ord_id]) && $find_wor_data[$value->reli_ord_id] != '0000-00-00 00:00:00') {
                    $list_items[$key]->wor_achieve_time = $find_wor_data[$value->reli_ord_id];
                } else {
                    $list_items[$key]->wor_achieve_time = '';
                }
                // 品牌车系
                if ($value->recl_car_brand_series) {
                    $car_brse = explode('-', $value->recl_car_brand_series);
                    $list_items[$key]->recl_car_brand_series = $car_brse;
                }
            }
        } else {
            $order_goods = [];
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 生成订单
    public static function add($user_info, $request)
    {
        if (empty($request['ord_unique_string'])) {
            return ['code'=>ErrorInc::FAILED_PARAM, 'msg'=>'生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data'=>''];
        }
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>ErrorInc::DATA_EXIST, 'msg'=>'当前订单已提交，请勿重复操作！', 'data'=>''];
        }

        // 如果有预约时间，则判断是否超出限制预约数量；
        if (isset($request['orcl_appoint_time'])) {

            $resenum_date=substr($request['orcl_appoint_time'],0,10);

            $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date);

            if($jud_res['code'] != 200) return $jud_res;
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);

        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = $request['ord_client_id'];
        $data['ord_ware_id'] = $request['ware_id'] ? $request['ware_id'] : '';
        if ($request['ord_address_type'] == 1) {//本店
            $ord_address = DB::table('shop')
                ->where('shop_id', $request['ord_address_id'])
                ->value('shop_store_name');
            if ($request['ord_address'] != ($ord_address.'(本店)')) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'施工门店错误', 'data'=>''];
            }
        } elseif ($request['ord_address_type'] == 2) {//合作商
            $ord_address = DB::table('business_client')
                ->where('bucl_id', $request['ord_address_id'])
                ->value('bucl_name');
            if ($request['ord_address'] != $ord_address) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'施工门店错误', 'data'=>''];
            }
        }
        $data['ord_address'] = $request['ord_address'];
        $data['ord_address_id'] = $request['ord_address_id'];
        $data['ord_address_type'] = $request['ord_address_type'];
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = $request['ord_type'];//买家类型：1门店零售2企业客户
        $data['ord_service_type'] = 1; //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_add_work_state'] = 1; //是否生成工单1是2否
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式结算方式1现金、2支付宝、3微信、4银行卡5会员卡
        $data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : ''; //服务技师
        if ($request['ord_payment_way']) {
            $data['ord_state'] = 2;//结算状态1未结算2已结算
            $data['ord_pay_state'] = 1;//是否支付1是2否
            $data['ord_settlement_time'] = date('Y-m-d H:i:s');//结算状态1未结算2已结算
            $data['ord_settlement_adm_id'] = $user_info->adm_id;//结算人
        }
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $request['ord_unique_string'];
        $data['ord_explain'] = !empty($request['ord_explain']) ? $request['ord_explain'] : '';
        // 判断是否有预约单id
        if (!empty($request['reli_id'])) {
            // 有预约单id说明是从预约单过去的
            // 查看预约单是否是待接单状态
            $find_reli_data = DB::table('wash_reservation_list')
                ->where('reli_id', $request['reli_id'])
                ->where('reli_shop_id', $user_info->adm_shop_id)
                ->select('reli_number', 'reli_state', 'reli_client_id')
                ->first();
            if (empty($find_reli_data)) {
                return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'未找到当前预约单！', 'data'=>''];
            }
            if ($find_reli_data->reli_state != 1) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前预约单不是待接单状态！', 'data'=>''];
            }
            // 判断前端是否传客户单位id,前端没有传客户单位id的把预约单列表查出来的赋值到订单数据中
            if ($request['ord_client_id']) {
                $data['ord_client_id'] = $request['ord_client_id'];
            } else {
                $data['ord_client_id'] = $find_reli_data->reli_client_id; //预约列表的单位id
            }
        }
        $ord_id = WashOrder::insertGetId($data);

        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_phone', $request['orcl_phone'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            if ($request['ord_type'] == 1) { //买家类型：1会员零售
                // 零售，会员表
                $client_res = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->increment('mem_order_all');
                if (!empty($find_weixin_data)) {
                    $weus_id = $find_weixin_data->weus_id;
                } else {
                    $weus_id = 0;
                }
            } else {
                $client_res = true;
            }
        } else {
            if ($request['ord_type'] == 2) { //买家类型：2企业客户
                // 1. 判断企业客户账号名称是否存在
                $find_buac = DB::table('business_account')
                    ->where('buac_bucl_id', $request['orcl_business_id'])
                    ->where('buac_name', $request['orcl_name'])
                    ->first(['buac_id']);
                if ($find_buac) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'客户名称已存在，生成订单失败'];
                }

                // 2 新增一个企业会员账号
                $add_buac_data['buac_shop_id'] = $user_info->adm_shop_id;
                $add_buac_data['buac_cid'] = $user_info->adm_cid;
                $add_buac_data['buac_name'] = $request['orcl_name'];
                $add_buac_data['buac_phone'] = $request['orcl_phone'];
                $add_buac_data['buac_bucl_id'] = $request['orcl_business_id'];
                $add_buac_data['buac_create_adm_id'] = $user_info->adm_id;
                $add_buac_data['buac_create_time'] = date('Y-m-d H:i:s');
                $buac_res =  DB::table('business_account')->insertGetId($add_buac_data);
            } elseif ($request['ord_type'] == 1) {
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_create_id'] = $user_info->adm_id;
                $eme['mem_create_name'] = $user_info->adm_name;
                $eme['mem_name'] = $request['orcl_name'] ? $request['orcl_name'] : '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code"=>500, 'msg'=>'当前手机号已存在', 'data'=>'当前手机号已存在'];
                    }
                }
                $eme['mem_phone'] = $request['orcl_phone'] ? $request['orcl_phone'] : '';
                $eme['mem_source'] = $request['orcl_mem_source'] ? $request['orcl_mem_source'] : '';//来源
                $eme['mem_car_num'] = $request['orcl_car_num'] ? $request['orcl_car_num'] : '';
                $eme['mem_order_all'] = 1; //订单数
                // $mem_id = DB::table('member')->insertGetId($eme);
                $mem_id = MemberService::addMember($eme);
                self::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'新增会员失败', 'data'=>'新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;
                $client_res = true;

                if (empty($find_weixin_data)) {
                    // 不存在就新增用户
                    $weus_data['weus_openid'] = $mem_id;
                    $weus_data['weus_phone'] = $request['orcl_phone'];
                    $weus_data['weus_nickmame'] = $request['orcl_name'];
                    $weus_data['weus_follow'] = 1;
                    $weus_data['weus_sex'] = 0;
                    $weus_data['weus_province'] = '';
                    $weus_data['weus_city'] = '';
                    $weus_data['weus_headimgurl'] = '';
                    $weus_data['weus_update_time'] = date('Y-m-d H:i:s');
                    $weus_id = DB::table('weixin_user')->insertGetId($weus_data);
                    if (!$weus_id) {
                        return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
                    }
                    unset($weus_data['weus_update_time']);
                } else {
                    // 更新微信用户信息
                    $edit_weus['weus_phone'] = $request['orcl_phone'];
                    $edit_weus['weus_nickmame'] = $request['orcl_name'];
                    if (!empty($request['weus_headimgurl'])) {
                        $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                    }
                    $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                    $edit_weus_res = DB::table('weixin_user')
                        ->where('weus_id', $find_weixin_data->weus_id)
                        ->update($edit_weus);
                    unset($edit_weus);
                    $weus_id = $find_weixin_data->weus_id;
                }

                // 查询微信用户与门店的关系是否存在绑定关系
                $find_user_shop_data = DB::table('user_shop')
                    ->where('ussh_weus_id', $weus_id)
                    ->where('ussh_shop_id', $user_info->adm_shop_id)
                    ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                    ->first();

                if (empty($find_user_shop_data)) {
                    // 用户没有与当前门店绑定，把用户与当前门店绑定
                    $ussh_data['ussh_user_id'] = $mem_id;
                    $ussh_data['ussh_weus_id'] = $weus_id;
                    $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
                    $ussh_data['ussh_user_type'] = 1;
                    $ussh_data['ussh_phone'] = $request['orcl_phone'];
                    $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                    if (!$ussh_id) {
                        return ['code'=>500, 'msg'=>'新增失败2', 'data'=>''];
                    }
                } else {
                    if (empty($find_user_shop_data->ussh_user_id)) {
                        $ussh_data['ussh_user_type'] = 1;
                        $ussh_data['ussh_phone'] = $request['orcl_phone'];
                        $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                        $ussh_id = DB::table('user_shop')
                            ->where('ussh_id', $find_user_shop_data->ussh_id)
                            ->update($ussh_data);
                    }
                }
            }
        }

        // 判断是否有预约单id
        if (!empty($request['reli_id'])) {
            $reli_edit_data['reli_ord_id'] = $ord_id;
            $reli_edit_data['reli_order_number'] = $ord_order_number;
            $reli_edit_data['reli_state'] = 2;
            $reli_edit_data['reli_update_time'] = date('Y-m-d H:i:s');
            $reli_res = DB::table('wash_reservation_list')
                ->where('reli_id', $request['reli_id'])
                ->update($reli_edit_data);
            if (!$reli_res) {
                return ['code'=>500, 'msg'=>'新增失败1', 'data'=>'新增失败1'];
            }
        }
        if (!empty($request['orcl_car_num'])) {
            $isCarLicense = isCarLicense($request['orcl_car_num']);// 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code'=>500, 'msg'=>'车牌照格式不正确', 'data'=>''];
            }
        }
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => $request['ord_client_id'], //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '',// 销售人员id
            'orcl_business_name' => isset($request['orcl_business_name']) ? $request['orcl_business_name'] : '',//企业名称
            'orcl_business_id' => isset($request['orcl_business_id']) ? $request['orcl_business_id'] : '',//企业id
            'orcl_name' => $request['orcl_name'] ? $request['orcl_name'] : '散户',
            'orcl_phone' => $request['orcl_phone'] ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => $request['orcl_carowner_name'] ? $request['orcl_carowner_name'] : '',
            'orcl_carowner_phone' => $request['orcl_carowner_phone'] ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        if (!empty($request['orcl_car_num']) && $request['ord_type'] == 1 && !empty($request['ord_client_id'])) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $request['ord_client_id'])
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $request['meca_car_frame'] = $request['orcl_car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        }
        // 接车时间
        if (isset($request['orcl_pick_up_car_time'])) {
            $orcl_data['orcl_pick_up_car_time'] = $request['orcl_pick_up_car_time'];
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $goods_data = json_decode($request['goods_data'], true);
        $sepr_id = '';
        if (!empty($goods_data)) {
            $goo_type = array_column($goods_data, 'goo_type');
            if (!in_array(2, $goo_type)) {
                return ['code'=>500, 'msg'=>'请选择服务', 'data'=>'请选择服务'];
            }
            $sepr_work_type = array_column($goods_data, 'sepr_work_type');
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            $sepr_name = '';
            $goo_id = '';
            $goo_name = '';
            // 新增订单商品数据
            foreach ($goods_data as $key => $value) {
                if ($value['goo_type'] == 2) {
                    if ($sepr_id) {
                        $sepr_id = $sepr_id.$value['goo_id'].',';
                        $sepr_name = $sepr_name.','.$value['goo_name'];
                    } else {
                        $sepr_id = ','.$value['goo_id'].',';
                        $sepr_name = $value['goo_name'];
                    }
                } elseif ($value['goo_type'] == 1) {
                    if ($goo_id) {
                        $goo_id = $goo_id.$value['goo_id'].',';
                    } else {
                        $goo_id = ','.$value['goo_id'].',';
                    }
                    if ($goo_name) {
                        $goo_name = $goo_name.','.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    } else {
                        $goo_name = $value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    }
                }
                if (!isset($value['goo_waon_class'])) {
                    $value['goo_waon_class'] = 1;
                    $goods_data[$key]['goo_waon_class'] = 1;
                }
                if (!isset($value['goo_type'])) {
                    $value['goo_type'] = 1;
                    $goods_data[$key]['goo_type'] = 1;
                }
                if (!isset($value['goo_inventory'])) {
                    $value['goo_inventory'] = 1;
                    $goods_data[$key]['goo_inventory'] = 1;
                }
                if (!isset($value['wago_id']) && $value['goo_type'] == 1) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->value('wago_id');
                    $value['wago_id'] = $find_wago_id;
                    $goods_data[$key]['wago_id'] = $find_wago_id;
                } elseif (!isset($value['wago_id']) && $value['goo_type'] == 2) {
                    $value['wago_id'] = 0;
                    $goods_data[$key]['wago_id'] = 0;
                }

                if (!empty($value['goo_id'])) {
                    if (empty($value['goo_id'])  || $value['goo_quantity'] < 0 || !is_numeric($value['wago_id']) || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1,2]) || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2]) || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'请完善服务信息02'];
                    }
                    $orgo_data['orgo_ord_id'] = $ord_id;
                    $orgo_data['orgo_order_number'] = $ord_order_number;
                    $orgo_data['orgo_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0;
                    $orgo_data['orgo_wago_id'] = $value['wago_id'];
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_name'] = $value['goo_name'];
                    $orgo_data['orgo_goo_type'] = $value['goo_type'];
                    if ($value['goo_type'] == 1) {
                        $goo_goods_encode = DB::table('goods')
                            ->where('goo_id', $value['goo_id'])
                            ->value('goo_goods_encode');
                        $orgo_data['orgo_goo_goods_encode'] = !empty($goo_goods_encode) ? $goo_goods_encode : '';
                    }
                    $orgo_data['orgo_goo_inventory'] = $value['goo_inventory'];
                    $orgo_data['orgo_state'] = $value['goo_state'];
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    if ($value['goo_type'] == 2) {
                        $orgo_data['orgo_goo_unit'] = '次';
                    }
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_goo_price'] = $value['goo_price']*100;
                    $orgo_data['orgo_goo_amount'] = $value['goo_quantity']*$value['goo_price']*100;
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                    $goods_data[$key]['orgo_id'] = $orgo_id; //立即派单使用
                    if ($value['goo_quantity']) {
                        $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    }
                }
                $goo_all_price += $value['goo_price']*$value['goo_quantity']; //商品总金额
            }
            $ord_edit_data['ord_order_price'] = $goo_all_price * 100;
            if ($request['ord_payment_way']) {
                $ord_edit_data['ord_actual_price'] = $goo_all_price * 100;//结算金额
            }
            if ($request['ord_payment_way'] == 5) {//会员卡支付实付金额修改为0
                $ord_edit_data['ord_actual_price'] = 0;
                $ord_edit_data['ord_zero_price'] = $goo_all_price * 100;
            }
            $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity;
            $ord_actual_price = $ord_edit_data['ord_actual_price'];
        } else {
            return ['code'=>500, 'msg'=>'请选择服务', 'data'=>'请选择服务'];
        }

        if ($request['ord_payment_way'] == 6 || $request['ord_payment_way'] == 7) {//使用余额支付
            if ($request['ord_type'] == 1) {
                $find_mem = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                    ->first();
                $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
                if ($goo_all_price >= $banlance) {//余额不足
                    if (empty($request['ord_other_payway']) && $ord_actual_price > $banlance) {
                        return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                    }
                    $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                    $ord_edit_data['ord_payment_money'] = $goo_all_price - $banlance;
                    $ord_edit_data['ord_banlance'] = $banlance;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $find_mem->mem_gift_banlance;
                    $add_rec_log['relo_mem_id'] = $request['ord_client_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = $request['remark'];
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                    $update_mem['mem_rec_banlance'] = 0;
                    $update_mem['mem_gift_banlance'] = 0;
                } elseif ($goo_all_price < $banlance) {
                    $ord_edit_data['ord_payment_money'] = 0;
                    $ord_edit_data['ord_banlance'] = $goo_all_price;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    if ($find_mem->mem_rec_banlance >= $goo_all_price) {
                        $add_rec_log['relo_rec_num'] = $goo_all_price;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $goo_all_price;
                    } else {
                        $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $goo_all_price - $find_mem->mem_rec_banlance;
                        $update_mem['mem_rec_banlance'] = 0;
                        $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($goo_all_price - $find_mem->mem_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['ord_client_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = $request['remark'];
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('member')->where('mem_id', $request['ord_client_id'])->update($update_mem);
            } elseif ($request['ord_type'] ==2) {
                
            }
        } else {
            $ord_edit_data['ord_payment_money'] = $goo_all_price;
            $ord_edit_data['ord_banlance'] = 0;
        }
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $ord_id)->update($ord_edit_data);

        if ($request['ord_type'] == 1) {
            // 添加客户消息
            $add_data['weus_id'] = $weus_id;
            $add_data['shop_id'] = $user_info->adm_shop_id;
            $add_data['primary_id'] = $ord_id; //单据的主键id
            $add_data['primary_type'] = 1; //单据类型：1订单2工单3预约单4售后单
            $add_data['read_state'] = 1; //阅读状态：1未读2已读
            $add_data['title'] = '预约成功通知';//消息标题
            $add_data['content'] = '您申请的服务已预约成功，我们会尽快处理，请耐心等待'; //操作内容'.$value['sepr_name'].'
            $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
            $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
            $addUserMessage_res = addUserMessage($add_data);
            unset($add_data);

            $send = isSend($user_info,1);
            if ($send) {
                // 2.给相应的客户发送短信
                $phone = $request['orcl_phone'];
                $message = '【半径服务】尊敬的客户您好，您申请的服务已预约成功，请登录(半径服务)小程序查看';
                if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                    $find_shop_data = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->first();
                    if ($find_shop_data->shop_message_num <= 0) {
                        $send_state = 2;
                        $send_res = 0;
                    } else {
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();
                        if ($msg_remind_log) {//已提醒过
                            if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                $update_remind['mrlo_state'] = 1;
                                $msg_remind_log = DB::table('msg_remind_log')
                                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                    ->where('mrlo_state', 2)
                                    ->update($update_remind);
                            }
                        }
                        
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();

                        if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                            $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                            // $wechat_msg['pushtype'] = 5; //短信预警
                            // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                            // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                            // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                            // $wechat_msg['remark'] = '短信不足预警';
                            // $CashierDesk = new CashierDesk;
                            // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                            $remind_phone = $adm_data->adm_phone;
                            $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                            $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                            if ($remind_send_res > 0) {
                                $send_state = 1;
                                $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                $add_remind['mrlo_state'] = 2;//未充值，
                                $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                            } else {
                                $send_state = 2;
                            }
                            // 短信模块日志
                            $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                            $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                            $seme_data['seme_wor_id'] = 0; //订单id
                            $seme_data['seme_name'] = '短信不足预警'; //模板名称
                            $seme_data['seme_phone'] = $remind_phone; //手机号
                            $seme_data['seme_content'] = $remind_content; //内容
                            $seme_data['seme_row'] = 1; //条数
                            $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                            $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                            $seme_data['seme_ip'] = $request['ip']; //ip地址
                            $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                            $seme_id = DB::table('send_message')->insert($seme_data);
                        }
                        $send_res = sendSmsCode($phone, $message);
                        if ($send_res > 0) {
                            $update_shop = DB::table('shop')
                                ->where('shop_id', $user_info->adm_shop_id)
                                ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                            $send_state = 1;
                        } else {
                            $send_state = 2;
                        }
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = $ord_id; //订单id
                    $seme_data['seme_name'] = '预约成功通知'; //模板名称
                    $seme_data['seme_phone'] = $phone; //手机号
                    $seme_data['seme_content'] = $message; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);

                    $find_member = DB::table('member')
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $phone)
                        ->first();
                    $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                    $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                    $add_log['smlo_mem_phone'] = $phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_state'] = $send_state;
                    $add_log['smlo_msg_type'] = 4;
                    $add_log['smlo_num'] = 1;
                    $add_log['smlo_content'] = $message; //内容
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                }
            }
        }
        // 添加排班计划
        $wopl_data['wopl_shop_id'] = $user_info->adm_shop_id;
        // $wopl_data['wopl_wor_id'] = $wor_id;
        $wopl_data['wopl_ord_id'] = $ord_id;
        $wopl_data['wopl_sepr_id'] = $sepr_id;
        $wopl_data['wopl_sepr_name'] = $sepr_name;
        $wopl_data['wopl_goo_id'] = $goo_id;
        $wopl_data['wopl_goo_name'] = $goo_name;
        $wopl_data['wopl_address_id'] = $request['ord_address_id'];
        $wopl_data['wopl_address'] = $request['ord_address'];
        $wopl_data['wopl_address_type'] = $request['ord_address_type'];
        if ($request['orcl_sales_adm_id']) {
            $find_adm = DB::table('admin')->where('adm_id', $request['orcl_sales_adm_id'])->value('adm_name');
        } else {
            $find_adm = '';
        }
        $wopl_data['wopl_sale_name'] = $find_adm;
        $wopl_data['wopl_sale_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '';
        $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';
        $wopl_data['wopl_time'] = isset($request['orcl_appoint_time']) ? date('H:i:s', strtotime($request['orcl_appoint_time'])) : '';
        $wopl_data['wopl_date'] = isset($request['orcl_appoint_time']) ? date('Y-m-d', strtotime($request['orcl_appoint_time'])) : '';
        // $wopl_data['wopl_service_id'] = ','.$service_adm_id.',';
        $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
        $wopl_id = DB::table('work_plan')->insertGetId($wopl_data);
        if ($ord_id && $orcl_id && $ord_edit_res && $return_car_data['code'] == 200) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['goods_data'] = json_encode($goods_data); //商品信息
            $return_data['ord_type'] = $request['ord_type']; //买家类型1.会员零售2.合作商
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 来源  1 pc  2 车主小程序   3 技师
    public static function getOrdsource($request){
        $ord_source = 1;  // 来源  1 pc  2 车主小程序   3 技师
        if(isset($request['rt'])){
            if($request['rt']=='wechat'){
                $ord_source = 3;
            }elseif($request['rt']=='wechatWash'){
                $ord_source = 2;
            }
        }
        return $ord_source;
    }

    // 购买带服务的商品套餐
    public static function addOrder($user_info, $request)
    {
        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->ussh_user_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $ord_unique_string)
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>ErrorInc::DATA_EXIST, 'msg'=>'当前订单已提交，请勿重复操作！', 'data'=>''];
        }
        $goods_data = json_decode($request['goods_data'], true);
        if (!empty($goods_data)) {
            $pait_appoint_num = DB::table('package_items')->where('pait_id',$goods_data[0]['goo_id'])->value('pait_appoint_num');
            if($pait_appoint_num>0) {
                $orcl_appoint_time = $request['orcl_appoint_time'] . ":00";
                $orcl_appoint_time1 = date('Y-m-d H:00:00', strtotime('+1 hours', strtotime($orcl_appoint_time)));
                $num = DB::table('order_client as a')
                    ->leftJoin('order as b', 'a.orcl_ord_id', '=', 'b.ord_id')
                    ->leftJoin('order_goods as c', 'a.orcl_ord_id', '=', 'c.orgo_ord_id')
                    ->where('orgo_goo_type', 3)
                    ->where('orgo_goo_id', $goods_data[0]['goo_id'])
                    ->whereBetween('orcl_appoint_time', [$orcl_appoint_time, $orcl_appoint_time1])
                    ->where('orcl_appoint_time', '<' ,$orcl_appoint_time1)
                    ->where("ord_delete", 1)
                    ->where("ord_shop_id", $user_info->adm_shop_id)
                    ->count();
                if ($num >= $pait_appoint_num){
                    return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'该时间段已经预约满', 'data'=>''];
                }
            }
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        // $data['ord_create_id'] = $user_info->adm_id;
        $request['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : '';
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1;//买家类型：1门店零售2企业客户
        $data['ord_source'] = 2;//下单来源：1 pc  2 车主小程序  3 技师
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式1现金、2支付宝、3微信、4银行卡、5会员卡
        $data['ord_wor_state'] = 7;
        $data['ord_new_type'] = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
            ->where('orty_state', 1)
            ->value('orty_id');

        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $ord_id = NewOrderService::newOrder($data);


        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_id', $request['weus_id'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        $request['orcl_carowner_name'] = $request['orcl_name'];
        $request['orcl_carowner_phone'] = $request['orcl_phone'];
        // 选择的客户id，对应的订单数量增加
        if ($user_info->ussh_user_id) {
            // 零售，会员表
            $client_res = DB::table('member')
                ->where('mem_id', $user_info->ussh_user_id)
                ->increment('mem_order_all');
            $mem_data = DB::table('member')
                ->where('mem_id', $user_info->ussh_user_id)
                ->select('mem_id', 'mem_name', 'mem_phone')
                ->first();
            if ($mem_data) {
                $request['orcl_name'] = $mem_data->mem_name;
                $request['orcl_phone'] = $mem_data->mem_phone;
            }
            $weus_id = $find_weixin_data->weus_id;
        }

        if (!empty($request['orcl_car_num'])) {
            $isCarLicense = isCarLicense($request['orcl_car_num']);// 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code'=>1000, 'msg'=>'车牌照格式不正确', 'data'=>''];
            }
        }
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => $user_info->ussh_user_id, //选择客户id
            'orcl_name' => $request['orcl_name'] ? $request['orcl_name'] : '散户',
            'orcl_phone' => $request['orcl_phone'] ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => $request['orcl_carowner_name'] ? $request['orcl_carowner_name'] : '散户',
            'orcl_carowner_phone' => $request['orcl_carowner_phone'] ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类2其他车系
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        if (!empty($request['orcl_car_num'])&& !empty($request['ord_client_id'])) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $user_info->ussh_user_id)
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);

        //如果是会员，返回会员价格
        $meml_discount = 0;
        if(isset($user_info->ussh_user_id)){
            $level = DB::table('member')
                ->where('mem_shop_id',$user_info->adm_shop_id)
                ->where('mem_id', $user_info->ussh_user_id)
                ->value('mem_level');
            if(isset($level) && $level > 0){
                $meml_discount = DB::table('member_level')
                    ->where('meml_shop_id', $user_info->adm_shop_id)
                    ->where('meml_level', $level)
                    ->value('meml_discount');
            }
        }

        $sepr_id = '';
        if (!empty($goods_data)) {
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            foreach ($goods_data as $key1 => $value1) {
                if (!isset($value1['goo_waon_class'])) {
                    $value1['goo_waon_class'] = 1;
                    $goods_data[$key1]['goo_waon_class'] = 1;
                }
                if (!isset($value1['goo_type'])) {
                    $goo_type = DB::table('goods')
                        ->where('goo_id', $value1['goo_id'])
                        ->where('goo_name', $value1['goo_name'])
                        ->value('goo_type');
                    if ($goo_type) {
                        $value1['goo_type'] = $goo_type;
                        $goods_data[$key1]['goo_type'] = $goo_type;
                    } else {
                        $value1['goo_type'] = 2;
                        $goods_data[$key1]['goo_type'] = 2;
                    }
                }
                if (!isset($value1['goo_inventory'])) {
                    $value1['goo_inventory'] = 1;
                    $goods_data[$key1]['goo_inventory'] = 1;
                }
                $goo_all_price += $value1['goo_price']*$value1['goo_quantity']; //商品总金额
                $orgo_data['orgo_ord_id'] = $ord_id;
                $orgo_data['orgo_order_number'] = $ord_order_number;
                $orgo_data['orgo_goo_id'] = $value1['goo_id'];
                $orgo_data['orgo_goo_goods_encode'] = $value1['goo_number'];
                $orgo_data['orgo_goo_name'] = $value1['goo_name'];
                $pait_name = $value1['goo_name'];
                $orgo_data['orgo_goo_type'] = 3;//套餐商品
                $orgo_data['orgo_goo_quantity'] = $value1['goo_quantity'];
                $orgo_data['orgo_goo_price'] = $value1['goo_price'] * 100;
                $orgo_data['orgo_goo_amount'] = $value1['goo_quantity']*$value1['goo_price']*100;
                $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                if($meml_discount > 0 && $data['ord_source'] != 2){
                    $orgo_data['orgo_goo_price'] =  $value1['goo_price'] * 100 * $meml_discount / 10;
                }
                $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                $pait_data = DB::table('package_items')
                    ->where('pait_id', $value1['goo_id'])
                    ->select('pait_saleable_quantity', 'pait_state')
                    ->first();
                if (!$pait_data) {
                    return ['code'=>500, 'msg'=>'没有查到该商品', 'data'=>''];
                }
                if ($pait_data->pait_state == 2 || $pait_data->pait_saleable_quantity-$value1['goo_quantity']<0) {
                    return ['code'=>500, 'msg'=>'该商品已下架', 'data'=>''];
                }
                $find_wago_price = DB::table('warehouse_goods')
                    ->where('wago_goo_id', $value1['goo_id'])
                    ->where('wago_class', $value1['goo_waon_class'])
                    ->where('wago_ware_id', $request['ware_id'])
                    ->value('wago_goo_price');
                $goods_price[$value1['goo_id']]['price'] = $find_wago_price;//商品成本价
                $goods_price[$value1['goo_id']]['quantity'] = $value1['goo_quantity'];//商品数量
            }
            $sepr_name = '';
            $goo_id = '';
            $goo_name = '';
            $new_goods_data = DB::table('package_items as p')
                ->leftJoin('correlation_goods as cogo', 'p.pait_id', '=', 'cogo.cogo_pait_id')
                ->where('pait_id', $goods_data[0]['goo_id'])
                ->select('cogo_goo_id as goo_id', 'cogo_goo_type as goo_type', 'cogo_goo_unta_id as goo_unta_id', 'cogo_goo_quantity as goo_quantity', 'cogo_goo_unit as goo_unit', 'cogo_goo_price as goo_price')
                ->get()->toArray();
            if ($new_goods_data) {
                $new_goods_data = json_decode(json_encode($new_goods_data,true),true);
            } else {
                return ['code'=>500, 'msg'=>'没有查到该商品', 'data'=>''];
            }
            // 新增订单商品数据
            foreach ($new_goods_data as $key => $value) {
                if ($value['goo_type'] == 1) {
                    $value['goo_name'] = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_name');
                } elseif ($value['goo_type'] == 2) {
                    $value['goo_name'] = DB::table('service_project')
                        ->where('sepr_id', $value['goo_id'])
                        ->value('sepr_name');
                }
                if ($value['goo_type'] == 2) {
                    if ($sepr_id) {
                        $sepr_id = $sepr_id.$value['goo_id'].',';
                        $sepr_name = $sepr_name.','.$value['goo_name'];
                    } else {
                        $sepr_id = ','.$value['goo_id'].',';
                        $sepr_name = $value['goo_name'];
                    }
                    $image_id = [];//根据服务项目确定需要上传的图片
                    $sepr_image = DB::table('sepr_img')
                        ->where('seim_sepr_id', $value['goo_id'])
                        ->select('seim_imco_id')
                        ->get()->toArray();
                    if (!empty($sepr_image)) {
                        foreach ($sepr_image as $ks => $vs) {
                            if (!in_array($vs->seim_imco_id, $image_id)) {
                                $image_id[] = $vs->seim_imco_id;
                            }
                        }
                    }
                    $find_goods = DB::table('service_project')
                        ->where('sepr_id', $value['goo_id'])
                        ->first();
                    if ($find_goods->sepr_work_type == 1) {
                        $find_imco = DB::table('image_config')
                            ->where('imco_type', 1)
                            ->get()->toArray();
                        foreach ($find_imco as $kf => $vf) {
                            $add_imdata['vaca_shop_id'] = $user_info->adm_shop_id;
                            $add_imdata['vaca_ord_id'] = $ord_id;
                            $add_imdata['vaca_type'] = 1;
                            $add_imdata['vaca_name'] = $vf->imco_name;
                            $add_imdata['vaca_data_id'] = $vf->imco_id;
                            if (in_array($vf->imco_id, $image_id)) {
                                $add_imdata['vaca_must'] = 1;
                            } else {
                                $add_imdata['vaca_must'] = 2;
                            }
                            $add_imdata['vaca_create_time'] = date('Y-m-d H:i:s');
                            $add_imdata['vaca_create_id'] = 0;
                            $im_res = DB::table('wash_validate_car')->insert($add_imdata);
                        }

                        $find_com_img = DB::table('image_config')
                            ->where('imco_type', 2)
                            ->get()->toArray();
                        foreach ($find_com_img as $kf => $vf) {
                            $add_comdata['coin_shop_id'] = $user_info->adm_shop_id;
                            $add_comdata['coin_ord_id'] = $ord_id;
                            $add_comdata['coin_type'] = 3;
                            $add_comdata['coin_name'] = $vf->imco_name;
                            $add_comdata['coin_data_id'] = $vf->imco_id;
                            $add_comdata['coin_create_time'] = date('Y-m-d H:i:s');
                            $add_comdata['coin_create_id'] = 0;
                            if (in_array($vf->imco_id, $image_id)) {
                                $add_comdata['coin_must'] = 1;
                                $co_res = DB::table('completion_info')->insert($add_comdata);
                            }
                        }
                    }
                } elseif ($value['goo_type'] == 1) {
                    if ($goo_id) {
                        $goo_id = $goo_id.$value['goo_id'].',';
                    } else {
                        $goo_id = ','.$value['goo_id'].',';
                    }
                    if ($goo_name) {
                        $goo_name = $goo_name.','.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    } else {
                        $goo_name = $value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    }
                }
                if (!isset($value['goo_waon_class'])) {
                    $value['goo_waon_class'] = 1;
                    $new_goods_data[$key]['goo_waon_class'] = 1;
                }
                if (!isset($value['goo_type'])) {
                    $value['goo_type'] = 1;
                    $new_goods_data[$key]['goo_type'] = 1;
                }
                if (!isset($value['goo_inventory'])) {
                    $value['goo_inventory'] = 1;
                    $new_goods_data[$key]['goo_inventory'] = 1;
                }
                if (!isset($value['wago_id']) && $value['goo_type'] == 1) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->value('wago_id');
                    $value['wago_id'] = $find_wago_id;
                    $new_goods_data[$key]['wago_id'] = $find_wago_id;
                } elseif (!isset($value['wago_id']) && $value['goo_type'] == 2) {
                    $value['wago_id'] = 0;
                    $new_goods_data[$key]['wago_id'] = 0;
                }

                if (!empty($value['goo_id'])) {
                    if (empty($value['goo_id'])  || $value['goo_quantity'] < 0 || !is_numeric($value['wago_id']) || !is_numeric($value['goo_id'])  || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2]) || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'请完善服务信息002', 'data'=>''];
                    }
                    $orgo_data['orgo_ord_id'] = $ord_id;
                    $orgo_data['orgo_order_number'] = $ord_order_number;
                    $orgo_data['orgo_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0;
                    $orgo_data['orgo_wago_id'] = $value['wago_id'];
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_name'] = $value['goo_name'];
                    $orgo_data['orgo_goo_type'] = $value['goo_type'];
                    if ($value['goo_type'] == 1) {
                        $goo_goods_encode = DB::table('goods')
                            ->where('goo_id', $value['goo_id'])
                            ->value('goo_goods_encode');
                        $orgo_data['orgo_goo_goods_encode'] = !empty($goo_goods_encode) ? $goo_goods_encode : '';
                    }
                    $orgo_data['orgo_goo_inventory'] = $value['goo_inventory'];
                    $orgo_data['orgo_state'] = 1;
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    if ($value['goo_type'] == 2) {
                        $orgo_data['orgo_goo_unit'] = '次';
                    }
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_goo_price'] = $value['goo_price'];
                    $orgo_data['orgo_goo_amount'] = $value['goo_quantity']*$value['goo_price'];
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    // 查询商品积分
                    if ($value['goo_type'] == 1) {// 实物商品
                        $pogo_goo_type = 2;
                    } else {
                        $pogo_goo_type = 1;
                    }
                    $orgo_goo_point = DB::table('point_goods')  
                        ->where('pogo_shop_id', $user_info->adm_shop_id)
                        ->where('pogo_goo_type', $pogo_goo_type)
                        ->where('pogo_enable', 1)
                        ->where('pogo_goo_id', $value['goo_id'])
                        ->value('pogo_goo_point');
                    $orgo_data['orgo_goo_point'] = $orgo_goo_point;
                    if($meml_discount > 0){
                        $orgo_data['orgo_goo_price'] =  $orgo_data['orgo_goo_price'] * $meml_discount / 10;
                    }
                    $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                    if ($value['goo_quantity']) {
                        $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    }
                }
            }
            $ord_edit_data['ord_service_type'] = 3;//只有商品
            foreach ($new_goods_data as $key => $value) {
                if ($value['goo_type'] == 2) {//服务项目
                    $sepr_work_type = DB::table('service_project')
                        ->where('sepr_id', $value['goo_id'])
                        ->value('sepr_work_type');
                    if ($sepr_work_type == 1) {
                        $ord_edit_data['ord_service_type'] = 1;
                        $ord_edit_data['ord_add_work_state'] = 1;
                        break;
                    } else {
                        $ord_edit_data['ord_service_type'] = 2;
                    }
                }
            }

            $ord_edit_data['ord_order_price'] = $goo_all_price * 100;
            $request['ord_type'] = 1;
            $ord_edit_data['ord_settlement_time'] = date('Y-m-d H:i:s');
            if ($request['ord_payment_way'] == 5) {
                $ord_edit_data['ord_state'] = 2;//已结算
                $ord_edit_data['ord_pay_state'] = 1;//1支付2否
                $ord_edit_data['ord_actual_price'] = 0;
                $ord_edit_data['ord_zero_price'] = $goo_all_price * 100;
            } elseif ($request['ord_payment_way'] == 0) {
                $ord_edit_data['ord_actual_price'] = 0;
                $ord_edit_data['ord_settlement_time'] = '';
                $find_mem = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->select('mem_arrears')
                    ->first();
                $update_data_mem['mem_arrears'] = $find_mem->mem_arrears + $goo_all_price * 100;
                $update_data_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_data_mem_res = DB::table('member')->where('mem_id', $request['ord_client_id'])->update($update_data_mem);
            } else {
                $ord_edit_data['ord_actual_price'] = $goo_all_price * 100;
            }
            $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity;
        } else {
            return ['code'=>500, 'msg'=>'请选择商品', 'data'=>'请选择商品'];
        }
        if ($request['ord_payment_way'] == 5) {//会员卡支付
            $pait_data = DB::table('correlation_goods as cogo')
                ->leftJoin('package_items as pait', 'pait.pait_id', '=', 'cogo.cogo_pait_id')
                ->where('cogo_pait_id', $goods_data[0]['goo_id'])
                ->where('pait_type', 2)
                ->select('cogo_goo_id', 'cogo_goo_type', 'pait_saleable_quantity', 'pait_sell_number')
                ->get()->toArray();
            $count = count($pait_data);
            if ($count != 1) {
                return ['code'=>1000, 'msg'=>'此商品不支持使用会员卡结算', 'data'=>''];
            }
            if (!isset($request['myvi_id'])) {
                return ["code"=>1000, 'msg'=>'请选择会员卡', 'data'=>'请选择会员卡'];
            }
            $find_myvi_data = DB::table('myvip')
                ->where('myvi_id', $request['myvi_id'])
                ->select('myvi_id', 'myvi_end_time', 'myvi_surplus_times', 'myvi_num')
                ->first();
            if ($find_myvi_data->myvi_end_time < date('Y-m-d H:i:s')) {
                return ["code"=>1000, 'msg'=>'会员卡已过期', 'data'=>'会员卡已过期'];
            }
            if ($find_myvi_data->myvi_surplus_times == 0) {
                return ["code"=>1000, 'msg'=>'会员卡次数已用完', 'data'=>'会员卡次数已用完'];
            }
            $update_data['myvi_surplus_times'] = $find_myvi_data->myvi_surplus_times - 1;
            if ($update_data['myvi_surplus_times'] == 0) {
                $update_data['myvi_state'] = 2;//已失效
            }
            $update_data['myvi_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('myvip')
                ->where('myvi_id', $find_myvi_data->myvi_id)
                ->update($update_data);
            $add_vip_record['vcre_myvi_id'] = $request['myvi_id'];
            $add_vip_record['vcre_user_id'] = $request['ord_client_id'];
            $add_vip_record['vcre_ord_num'] = $ord_order_number;
            $add_vip_record['vcre_ord_id'] = $ord_id;
            $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
            $add_vip_record['vcre_car_adm_name'] = $request['orcl_name'];
            $add_vip_record['vcre_car_adm_phone'] = $request['orcl_phone'];
            $add_vip_record['vcre_myvi_num'] = $find_myvi_data->myvi_num;
            $add_vip_record['vcre_log'] = 1;
            $add_vip_record['vcre_num_change'] = '-1（剩余：'.($find_myvi_data->myvi_surplus_times - 1).'次）';
            $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);
            $update_pait_data['pait_saleable_quantity'] = $pait_data[0]->pait_saleable_quantity - 1;//可售数量
            $update_pait_data['pait_sell_number'] = $pait_data[0]->pait_sell_number + 1;//已售数量
            $update_pait_data['pait_update_time'] = date('Y-m-d H:i:s');//更新时间
            $update_pait_res = DB::table('package_items')
                ->where('pait_id', $goods_data[0]['goo_id'])
                ->update($update_pait_data);

            if (isset($request['vico_id']) && $request['vico_id']) {
                $update_vico_data['vico_state'] = 2;//失效
                $update_vico_res = DB::table('vip_code')
                    ->where('vico_id', $request['vico_id'])
                    ->update($update_vico_data);
            } else {
                $update_vico_res = true;
            }
        }
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $ord_id)->update($ord_edit_data);
        ReceivablePayService::addPay($ord_id,$ord_order_number,1,$user_info->ussh_user_id,$user_info,$goods_price,$request,$ord_edit_data,'');
        $post_new_goods_data = [];
        foreach ($new_goods_data as $key => $value) {
            if ($value['goo_type'] == 1) {
                $post_new_goods_data[]['goo_id'] = $value['goo_id'];
            }
        }
        if ($request['ware_id'] && !empty($post_new_goods_data)) {
            $post_data['ware_id'] = $request['ware_id'];
            $post_data['new_goods_data'] = $post_new_goods_data;
            $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        }

        if ($ord_id && $orcl_id && $ord_edit_res && $return_car_data['code'] == 200) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_price'] = $goo_all_price * 100; //订单金额
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['ord_type'] = 1; //买家类型1.会员零售2.合作商
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id
            $ord_pay_state = DB::table('order')
                ->where('ord_id', $ord_id)
                ->value('ord_pay_state');
            $adm_data = DB::table('admin_shop_role')
                ->where('shop_id', $user_info->adm_shop_id)
                ->where('adm_shop_leave', 1)
                ->select('adm_id')
                ->first();
            if ($adm_data && $ord_pay_state == 1) {
                // 微信消息推送
                $wechat_msg['pushtype'] = 7; //订单提醒
                $wechat_msg['ord_id'] = $ord_id; //订单id
                $wechat_msg['adm_id'] = $adm_data->adm_id; //推送人
                $wechat_msg['ord_number'] = $ord_order_number; //订单号
                $wechat_msg['sepr_name'] = $pait_name; //服务项目
                $wechat_msg['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
                $wechat_msg['orcl_phone'] = $request['orcl_phone']; //客户电话
                $wechat_msg['orcl_name'] = $request['orcl_name']; //客户电话
                $wechat_msg['ord_create_time'] = date('Y-m-d H:i:s'); //订单创建时间

                $CashierDesk = new CashierDesk;
                $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
            }
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 购买纯商品套餐
    public static function addGoodsOrder($user_info, $request)
    {
        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->ussh_user_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $ord_unique_string)
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>ErrorInc::DATA_EXIST, 'msg'=>'当前订单已提交，请勿重复操作！', 'data'=>''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        // $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = $user_info->ussh_user_id;
        $request['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1;//买家类型：1门店零售2企业客户
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式1现金、2支付宝、3微信、4银行卡、5会员卡
        $data['ord_wor_state'] = 7;
        $data['ord_source'] = 2;//下单来源：1 pc  2 车主小程序  3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $ord_id = WashOrder::insertGetId($data);

        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_id', $request['weus_id'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            // 零售，会员表
            $client_res = DB::table('member')
                ->where('mem_id', $request['ord_client_id'])
                ->increment('mem_order_all');
            $weus_id = $find_weixin_data->weus_id;
        }
        $find_mem = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->select('mem_id', 'mem_name', 'mem_phone')
            ->first();
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => $user_info->ussh_user_id, //选择客户id
            'orcl_name' => $find_mem->mem_name ? $find_mem->mem_name : '散户',
            'orcl_phone' => $find_mem->mem_phone ? $find_mem->mem_phone : '',
            'orcl_carowner_name' => $find_mem->mem_name ? $find_mem->mem_name : '散户',
            'orcl_carowner_phone' => $find_mem->mem_phone ? $find_mem->mem_phone : '',
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $goods_data = json_decode($request['goods_data'], true);
        $sepr_id = '';
        if (!empty($goods_data)) {
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            foreach ($goods_data as $key1 => $value1) {
                if (!isset($value1['goo_waon_class'])) {
                    $value1['goo_waon_class'] = 1;
                    $goods_data[$key1]['goo_waon_class'] = 1;
                }
                if (!isset($value1['goo_type'])) {
                    $value1['goo_type'] = 1;
                    $goods_data[$key1]['goo_type'] = 1;
                }
                if (!isset($value1['goo_inventory'])) {
                    $value1['goo_inventory'] = 1;
                    $goods_data[$key1]['goo_inventory'] = 1;
                }
                $goo_all_price += $value1['goo_price']*$value1['goo_quantity']; //商品总金额
                $orgo_data['orgo_ord_id'] = $ord_id;
                $orgo_data['orgo_order_number'] = $ord_order_number;
                $orgo_data['orgo_goo_id'] = $value1['goo_id'];
                $orgo_data['orgo_goo_goods_encode'] = $value1['goo_number'];
                $orgo_data['orgo_goo_name'] = $value1['goo_name'];
                $orgo_data['orgo_goo_type'] = 3;//套餐商品
                $orgo_data['orgo_goo_quantity'] = $value1['goo_quantity'];
                $orgo_data['orgo_goo_price'] = $value1['goo_price']*100;
                $orgo_data['orgo_goo_amount'] = $value1['goo_quantity']*$value1['goo_price']*100;
                $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                $pait_data = DB::table('package_items')
                    ->where('pait_id', $value1['goo_id'])
                    ->select('pait_saleable_quantity', 'pait_state', 'pait_ware_id')
                    ->first();
                if (!$pait_data) {
                    return ['code'=>500, 'msg'=>'没有查到该商品', 'data'=>''];
                }
                $request['ware_id'] = $pait_data->pait_ware_id;
                if ($pait_data->pait_state == 2 || $pait_data->pait_saleable_quantity-$value1['goo_quantity']<0) {
                    return ['code'=>500, 'msg'=>'该商品已下架', 'data'=>''];
                }
            }
            $sepr_name = '';
            $goo_id = '';
            $goo_name = '';
            $new_goods_data = DB::table('package_items as p')
                ->leftJoin('correlation_goods as cogo', 'p.pait_id', '=', 'cogo.cogo_pait_id')
                ->where('pait_id', $goods_data[0]['goo_id'])
                ->select('cogo_goo_id as goo_id', 'cogo_goo_type as goo_type', 'cogo_goo_unta_id as goo_unta_id', 'cogo_goo_quantity as goo_quantity', 'cogo_goo_unit as goo_unit', 'cogo_goo_price as goo_price')
                ->get()->toArray();
            if ($new_goods_data) {
                $new_goods_data = json_decode(json_encode($new_goods_data,true),true);
            } else {
                return ['code'=>500, 'msg'=>'没有查到该商品', 'data'=>''];
            }
            // 新增订单商品数据
            foreach ($new_goods_data as $key => $value) {
                if ($value['goo_type'] == 1) {
                    $value['goo_name'] = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_name');
                } elseif ($value['goo_type'] == 2) {
                    $value['goo_name'] = DB::table('service_project')
                        ->where('sepr_id', $value['goo_id'])
                        ->value('sepr_name');
                }
                if ($value['goo_type'] == 2) {
                    if ($sepr_id) {
                        $sepr_id = $sepr_id.$value['goo_id'].',';
                        $sepr_name = $sepr_name.','.$value['goo_name'];
                    } else {
                        $sepr_id = ','.$value['goo_id'].',';
                        $sepr_name = $value['goo_name'];
                    }
                } elseif ($value['goo_type'] == 1) {
                    if ($goo_id) {
                        $goo_id = $goo_id.$value['goo_id'].',';
                    } else {
                        $goo_id = ','.$value['goo_id'].',';
                    }
                    if ($goo_name) {
                        $goo_name = $goo_name.','.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    } else {
                        $goo_name = $value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    }
                }
                if (!isset($value['goo_waon_class'])) {
                    $value['goo_waon_class'] = 1;
                    $new_goods_data[$key]['goo_waon_class'] = 1;
                }
                if (!isset($value['goo_type'])) {
                    $value['goo_type'] = 1;
                    $new_goods_data[$key]['goo_type'] = 1;
                }
                if (!isset($value['goo_inventory'])) {
                    $value['goo_inventory'] = 1;
                    $new_goods_data[$key]['goo_inventory'] = 1;
                }
                if (!isset($value['wago_id']) && $value['goo_type'] == 1) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->value('wago_id');
                    $value['wago_id'] = $find_wago_id;
                    $new_goods_data[$key]['wago_id'] = $find_wago_id;
                } elseif (!isset($value['wago_id']) && $value['goo_type'] == 2) {
                    $value['wago_id'] = 0;
                    $new_goods_data[$key]['wago_id'] = 0;
                }

                if (!empty($value['goo_id'])) {
                    if (empty($value['goo_id'])  || $value['goo_quantity'] < 0 || !is_numeric($value['wago_id']) || !is_numeric($value['goo_id'])  || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2]) || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'请完善服务信息02', 'data'=>'请完善服务信息02'];
                    }
                    $orgo_data['orgo_ord_id'] = $ord_id;
                    $orgo_data['orgo_order_number'] = $ord_order_number;
                    $orgo_data['orgo_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0;
                    $orgo_data['orgo_wago_id'] = $value['wago_id'];
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_name'] = $value['goo_name'];
                    $orgo_data['orgo_goo_type'] = $value['goo_type'];
                    if ($value['goo_type'] == 1) {
                        $goo_goods_encode = DB::table('goods')
                            ->where('goo_id', $value['goo_id'])
                            ->value('goo_goods_encode');
                        $orgo_data['orgo_goo_goods_encode'] = !empty($goo_goods_encode) ? $goo_goods_encode : '';
                    }
                    $orgo_data['orgo_goo_inventory'] = $value['goo_inventory'];
                    $orgo_data['orgo_state'] = 1;
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    if ($value['goo_type'] == 2) {
                        $orgo_data['orgo_goo_unit'] = '次';
                    }
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_goo_price'] = $value['goo_price'];
                    $orgo_data['orgo_goo_amount'] = $value['goo_quantity']*$value['goo_price'];
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
                    if ($value['goo_quantity']) {
                        $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    }
                    $goo_unit_conversion = DB::table('goods')
                        ->where('goo_id', $value['goo_id'])
                        ->value('goo_unit_conversion');
                }
            }
            $ord_edit_data['ord_service_type'] = 3;//只有商品
            $ord_edit_data['ord_order_price'] = $goo_all_price * 100;
            $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity;
        } else {
            return ['code'=>500, 'msg'=>'请选择商品', 'data'=>'请选择商品'];
        }

        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_ware_id'] = $request['ware_id'];
        // $ord_edit_data['ord_state'] = 2;
        // $ord_edit_data['ord_pay_state'] = 1;//1已付款2未付款
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $ord_id)->update($ord_edit_data);
        if ($ord_id && $orcl_id && $ord_edit_res) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_price'] = $goo_all_price * 100; //订单金额
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['ord_type'] = 1; //买家类型1.会员零售2.合作商
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    // 编辑查询
    public static function editShow($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'ord_create_id', 'ord_ware_id', 'orcl_sales_adm_id', 'ord_is_split', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain', 'orcl_mem_source', 'orcl_business_id', 'orcl_business_name', 'ord_address_type', 'ord_address_id', 'orcl_carbrse_type', 'ord_add_work_state', 'ord_other_payway', 'ord_wor_state', 'ord_new_type')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }
        $ord_Explainpic = [];
        $Explainpic = self::getExplainpic($user_info, $request['ord_id']);
        if (!empty($Explainpic['data'])) {
            $ord_Explainpic = $Explainpic['data'];
        }
        $info->ord_new_type_name = DB::table('order_type')
            ->where('orty_id', $info->ord_new_type)
            ->value('orty_name');
        $info->ord_explain_pic = $ord_Explainpic;
        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods as orgo')
            ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_wago_id', 'orgo_goo_unit', 'orgo_goo_unta_id', 'goo_unit_conversion', 'orgo_goo_price', 'orgo_goo_amount', 'goo_unit', 'goo_fid', 'goo_level')
            ->get()->toArray();
        foreach ($goods_data as $key => $value) {
            if ($value->orgo_goo_type == 2) {
                $goods_data[$key]->sepr_work_type = DB::table('service_project')
                    ->where('sepr_id', $value->orgo_goo_id)
                    ->value('sepr_work_type');
            } else {
                $goods_data[$key]->sepr_work_type = '';
            }
            if ($value->goo_level == 1 || ($value->goo_level == 2 && !empty($value->goo_fid))) {
                $goods_data[$key]->goo_change = 1;
            } else {
                $goods_data[$key]->goo_change = 2;
            }
        }
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->orcl_sales_adm_id;
        $ware_id[] = $info->ord_ware_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        // 查询仓库名称
        $ware_name = DB::table('warehouse')
            ->whereIn('ware_id', $ware_id)
            ->pluck('ware_name', 'ware_id')
            ->toArray();

        // 销售人
        $info->orcl_sales_adm_name = '';
        if ($info->orcl_sales_adm_id) {
            $info->orcl_sales_adm_name = $adm_name[$info->orcl_sales_adm_id]; //销售人
        }
        $info->ord_create_adm_name = '';
        if ($info->ord_create_id) {
            $info->ord_create_adm_name = $adm_name[$info->ord_create_id]; //录单人
        }
        $info->ord_ware_name = '';
        if ($info->ord_ware_id) {
            $info->ord_ware_name = $ware_name[$info->ord_ware_id]; //仓库名称
        }
        if (!empty($info->orcl_client_id) && $info->ord_type == 1) {
            $find_mem = DB::table('member')
                ->where('mem_id', $info->orcl_client_id)
                ->select('mem_rec_banlance', 'mem_gift_banlance')
                ->first();
            $info->mem_banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
        } elseif (!empty($info->orcl_business_id) && $info->ord_type == 2) {
            $find_mem = DB::table('business_client')
                ->where('bucl_id', $info->orcl_business_id)
                ->select('bucl_rec_banlance as mem_rec_banlance', 'bucl_gift_banlance as mem_gift_banlance')
                ->first();
            if ($find_mem) {
                $info->mem_banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
            } else {
                $info->mem_banlance = 0;
            }
        } else {
            $info->mem_banlance = 0;
        }
        $order_pic = [];
        $getorderpic = self::getorderpic($user_info, $request['ord_id']);
        if (!empty($getorderpic['data'])) {
            $order_pic = $getorderpic['data'];
        }
        $data['order_pic'] = $order_pic;
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 编辑
    public static function edit($user_info, $request, $order_data)
    {
        if (isset($request['orcl_sales_adm_id']) && !empty($request['orcl_sales_adm_id'])) {
            $orcl_sales_adm_name = DB::table('admin')
                ->where('adm_id', $request['orcl_sales_adm_id'])
                ->value('adm_name');
        } else {
            $orcl_sales_adm_name = '';
        }
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '',// 销售人员id
            'orcl_sales_adm_name' => $orcl_sales_adm_name,// 销售人员
            'orcl_business_name' => isset($request['orcl_business_name']) ? $request['orcl_business_name'] : '',//企业名称
            'orcl_business_id' => isset($request['orcl_business_id']) ? $request['orcl_business_id'] : '',//企业id
            'orcl_name' => $request['orcl_name'],//客户姓名
            'orcl_phone' => $request['orcl_phone'],//客户电话
            'orcl_carowner_name' => $request['orcl_carowner_name'],//车主姓名
            'orcl_carowner_phone' => $request['orcl_carowner_phone'],//车主电话
            'orcl_mem_source' => $request['orcl_mem_source'],//车主电话
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_shipment_party' => isset($request['orcl_shipment_party']) ? $request['orcl_shipment_party'] : 1, //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类
            'orcl_update_time' => date('Y-m-d H:i:s'),
            'orcl_province' => isset($request['orcl_province']) ? $request['orcl_province'] : '',
            'orcl_city' => isset($request['orcl_city']) ? $request['orcl_city'] : '',
            'orcl_county' => isset($request['orcl_county']) ? $request['orcl_county'] : '',
            'orcl_address' => isset($request['orcl_address']) ? $request['orcl_address'] : '',
        ];

        if (!empty($request['orcl_car_num']) && $request['ord_type'] == 1) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $request['ord_client_id'])
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $request['meca_car_frame'] = $request['orcl_car_vin'];
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        if ($return_car_data['code'] != 200) {
            return $return_car_data;
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];

            $resenum_date=date('Y-m-d', strtotime($request['orcl_appoint_time']));
            $request['ord_new_type'] = $order_data->ord_new_type;
            $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date,$order_data->orcl_appoint_time,$request);

            if($jud_res['code'] != 200) return $jud_res;

        } else {
            $orcl_data['orcl_appoint_time'] = '0000-00-00 00:00:00';
        }
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            if ($request['ord_type'] == 1) { //买家类型：1会员零售
                // 零售，会员表
                $client_res = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->increment('mem_order_all');
            } else {
                $client_res = true;
            }
        } else {
            if ($request['ord_type'] == 2) { //买家类型：2企业客户
                // 1. 判断企业客户账号名称是否存在
                $find_buac = DB::table('business_account')
                    ->where('buac_bucl_id', $request['orcl_business_id'])
                    ->where('buac_name', $request['orcl_name'])
                    ->first(['buac_id']);
                if ($find_buac) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'客户名称已存在，生成订单失败'];
                }

                // 2 新增一个企业会员账号
                $add_buac_data['buac_shop_id'] = $user_info->adm_shop_id;
                $add_buac_data['buac_cid'] = $user_info->adm_cid;
                $add_buac_data['buac_name'] = $request['orcl_name'];
                $add_buac_data['buac_phone'] = $request['orcl_phone'];
                $add_buac_data['buac_bucl_id'] = $request['orcl_business_id'];
                $add_buac_data['buac_create_adm_id'] = $user_info->adm_id;
                $add_buac_data['buac_create_time'] = date('Y-m-d H:i:s');
                $buac_res =  DB::table('business_account')->insertGetId($add_buac_data);
            } elseif (!empty($request['ord_type'])) {
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_create_id'] = $user_info->adm_id;
                $eme['mem_create_name'] = $user_info->adm_name;
                $eme['mem_name'] = $request['orcl_name'] ? $request['orcl_name'] : '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code"=>500, 'msg'=>'error', 'data'=>'当前手机号已存在'];
                    }
                }
                $eme['mem_phone'] = $request['orcl_phone'] ? $request['orcl_phone'] : '';
                $eme['mem_source'] = $request['orcl_mem_source'] ? $request['orcl_mem_source'] : '';//来源
                $eme['mem_car_num'] = $request['orcl_car_num'] ? $request['orcl_car_num'] : '';
                $eme['mem_order_all'] = 1; //订单数
                // $mem_id = DB::table('member')->insertGetId($eme);
                $mem_id = MemberService::addMember($eme);
                self::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;
                $client_res = true;

                if (empty($find_weixin_data)) {
                    // 不存在就新增用户
                    $weus_data['weus_openid'] = $mem_id;
                    $weus_data['weus_phone'] = $request['orcl_phone'];
                    $weus_data['weus_nickmame'] = $request['orcl_name'];
                    $weus_data['weus_follow'] = 1;
                    $weus_data['weus_sex'] = 0;
                    $weus_data['weus_province'] = '';
                    $weus_data['weus_city'] = '';
                    $weus_data['weus_headimgurl'] = '';
                    $weus_data['weus_update_time'] = date('Y-m-d H:i:s');
                    $weus_id = DB::table('weixin_user')->insertGetId($weus_data);
                    if (!$weus_id) {
                        return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
                    }
                    unset($weus_data['weus_update_time']);
                } else {
                    // 更新微信用户信息
                    $edit_weus['weus_phone'] = $request['orcl_phone'];
                    $edit_weus['weus_nickmame'] = $request['orcl_name'];
                    if (!empty($request['weus_headimgurl'])) {
                        $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                    }
                    $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                    $edit_weus_res = DB::table('weixin_user')
                        ->where('weus_id', $find_weixin_data->weus_id)
                        ->update($edit_weus);
                    unset($edit_weus);
                    $weus_id = $find_weixin_data->weus_id;
                }

                // 查询微信用户与门店的关系是否存在绑定关系
                $find_user_shop_data = DB::table('user_shop')
                    ->where('ussh_weus_id', $weus_id)
                    ->where('ussh_shop_id', $user_info->adm_shop_id)
                    ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                    ->first();

                if (empty($find_user_shop_data)) {
                    // 用户没有与当前门店绑定，把用户与当前门店绑定
                    $ussh_data['ussh_user_id'] = $mem_id;
                    $ussh_data['ussh_weus_id'] = $weus_id;
                    $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
                    $ussh_data['ussh_user_type'] = 1;
                    $ussh_data['ussh_phone'] = $request['orcl_phone'];
                    $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                    if (!$ussh_id) {
                        return ['code'=>500, 'msg'=>'新增失败2', 'data'=>''];
                    }
                } else {
                    if (empty($find_user_shop_data->ussh_user_id)) {
                        $ussh_data['ussh_user_type'] = 1;
                        $ussh_data['ussh_phone'] = $request['orcl_phone'];
                        $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                        $ussh_id = DB::table('user_shop')
                            ->where('ussh_id', $find_user_shop_data->ussh_id)
                            ->update($ussh_data);
                    }
                }
            }
        }
        $orcl_id = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($orcl_data);

        // 提交的订单商品项目数据
        if (!is_array($request['goods_data'])) {
            $goods_data = json_decode($request['goods_data'], true);
        } else {
            $goods_data = $request['goods_data'];
        }
        $goo_all_price = 0; //商品总金额
        $goo_all_quantity = 0; //商品总数量
        $sepr_id = '';
        $sepr_name = '';
        $goo_id = '';
        $goo_name = '';
        $request_wago_id = [];
        $is_goods = false;
        $old_ware_id = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->value('ord_ware_id');
        $old_goods_data = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->where('orgo_goo_type', 1)
            ->select('orgo_goo_id as goo_id')
            ->get();
        if (!empty($old_goods_data)) {
            $old_goods_data = json_decode(json_encode($old_goods_data, true), true);
        }
        $new_goods_data = [];
        // 判断提交的商品参数
        if (!empty($goods_data)) {
            $goo_type = array_column($goods_data, 'goo_type');
            if (in_array(1, $goo_type)) {
                $is_goods = true;
            }
            $goo_all_price = 0; //商品总金额
            $goo_all_quantity = 0; //商品总数量
            $new_goo_all_quantity = 0;
            $sepr_name = '';
            $goo_id = '';
            $goo_name = '';
            $goods_data_count = count($goods_data);

            if ($goods_data_count == 1) {
                $find_sepr = DB::table('service_project')
                    ->where('sepr_id', $goods_data[0]['goo_id'])
                    ->select('sepr_work_type')
                    ->first();
                if ($find_sepr && $find_sepr->sepr_work_type == 2 && $goods_data[0]['goo_type'] == 2 && $request['ord_add_work_state'] == 1) {
                    return ['code' => 500, 'msg' => '无可生成工单服务', 'data' => ''];
                }
                if ($find_sepr && $find_sepr->sepr_work_type == 2 && $goods_data[0]['goo_type'] == 2) {
                    $ord_edit_data['ord_service_type'] = 2;
                }
            } else {
                $have_work = false;//是否有生成工单的服务
                $sepr_num = 0;
                foreach ($goods_data as $key => $value) {
                    if (isset($value['sepr_work_type']) && $value['sepr_work_type'] == 1) {
                        $have_work = true;
                    }
                    if ($value['goo_type'] == 2) {
                        $sepr_num++;
                    }
                }
                if (!$have_work && $request['ord_add_work_state'] == 1) {
                    return ['code' => 500, 'msg' => '未添加可生成工单的服务，请添加！', 'data' => ''];
                }
            }

            foreach ($goods_data as $key => $value) {
                if ($value['goo_type'] == 2) {
                    if ($sepr_id) {
                        $sepr_id = $sepr_id.$value['goo_id'].',';
                        $sepr_name = $sepr_name.','.$value['goo_name'];
                    } else {
                        $sepr_id = ','.$value['goo_id'].',';
                        $sepr_name = $value['goo_name'];
                    }
                } elseif ($value['goo_type'] == 1) {
                    $new_goods_data[] = $value;
                    if ($goo_id) {
                        $goo_id = $goo_id.$value['goo_id'].',';
                    } else {
                        $goo_id = ','.$value['goo_id'].',';
                    }
                    if ($goo_name) {
                        $goo_name = $goo_name.','.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    } else {
                        $goo_name = $value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
                    }
                }
                if (!empty($value['goo_id'])) {
                    if (!isset($value['goo_waon_class'])) {
                        $value['goo_waon_class'] = 1;
                        $goods_data[$key]['goo_waon_class'] = 1;
                    }
                    if (!isset($value['wago_id'])) {
                        $find_wago_id = DB::table('warehouse_goods')
                            ->where('wago_goo_id', $value['goo_id'])
                            ->where('wago_class', $value['goo_waon_class'])
                            ->where('wago_ware_id', $request['ware_id'])
                            ->value('wago_id');
                        $value['wago_id'] = $find_wago_id;
                        $goods_data[$key]['wago_id'] = $find_wago_id;
                    }
                    if (!isset($value['wafg_id'])) {
                        $value['wafg_id'] = 0;
                        $goods_data[$key]['wafg_id'] = 0;
                    }
                    if (!isset($value['goo_inventory'])) {
                        $value['goo_inventory'] = 1;
                        $goods_data[$key]['goo_inventory'] = 1;
                    }
                    // goo_state 商品状态1正常3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    if ($value['goo_state'] != 4) {
                        $request_wago_id[] = $value['wago_id'];
                        $goo_all_quantity += $value['goo_quantity'];
                        // if ($value['goo_unta_id'] == 1) {
                        //     $goo_all_quantity += $value['goo_quantity'] * $goo_unit_conversion;
                        // }
                    }
                }
            }
        }

        $wopl_data['wopl_sepr_id'] = $sepr_id;
        $wopl_data['wopl_sepr_name'] = $sepr_name;
        $wopl_data['wopl_goo_id'] = $goo_id;
        $wopl_data['wopl_goo_name'] = $goo_name;
        $wopl_data['wopl_address_id'] = $request['ord_address_id'];
        $wopl_data['wopl_address'] = $request['ord_address'];
        $wopl_data['wopl_address_type'] = $request['ord_address_type'];
        if ($request['orcl_sales_adm_id']) {
            $find_adm = DB::table('admin')->where('adm_id', $request['orcl_sales_adm_id'])->value('adm_name');
        } else {
            $find_adm = '';
        }
        $wopl_data['wopl_sale_name'] = $find_adm;
        $wopl_data['wopl_sale_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '';
        $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';
        $wopl_data['wopl_time'] = date('H:i:s', strtotime($request['orcl_appoint_time']));
        $wopl_data['wopl_date'] = date('Y-m-d', strtotime($request['orcl_appoint_time']));
        // $wopl_data['wopl_service_id'] = ','.$service_adm_id.',';
        $wopl_data['wopl_update_time'] = date('Y-m-d H:i:s');
        $wopl_id = DB::table('work_plan')->where('wopl_ord_id', $request['ord_id'])->update($wopl_data);
        // 编辑订单相关数据
        $ord_edit_return = self::editOrderData($user_info, $request, $order_data, $goods_data, $is_goods);
        if (isset($request['ord_explain_pic']) && !empty($request['ord_explain_pic'])) {
            foreach ($request['ord_explain_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 2;
                $add_pic[$key]['orvp_ord_id'] = $request['ord_id'];
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }

        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pz_pic[$key]['orvp_image'] = $value;
                $add_pz_pic[$key]['orvp_type'] = 1;
                $add_pz_pic[$key]['orvp_ord_id'] = $request['ord_id'];
                $add_pz_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pz_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pz_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pz_pic_res = DB::table('order_voucher_pic')->insert($add_pz_pic);
        }
        if ($ord_edit_return['code'] == 500) {
            return $ord_edit_return;
        }
        $post_data['ware_id'] = $old_ware_id;
        $post_data['new_goods_data'] = $old_goods_data;
        $addGoodPlan = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        $post_data1['ware_id'] = $request['ware_id'];
        $post_data1['new_goods_data'] = $new_goods_data;
        $addGoodPlan = WashOrderBasicService::addGoodPlan($user_info, $post_data1);
        return ['code'=>200, 'msg'=>'success', 'data'=>''];
    }

    /**
     * [editOrderData 编辑订单相关数据]
     * @param  [type] $user_info  [用户信息]
     * @param  [type] $request    [编辑提交数据]
     * @param  [type] $order_data [订单信息]
     * @param  [type] $goods_data [订单提交的商品数据]
     * @return [type]             [description]
     */
    public static function editOrderData(
        $user_info,
        $request,
        $order_data,
        $goods_data,
        $is_goods
    ) {
        //订单历史商品数据
        $old_orgo_res = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->get()->toArray();
        if($old_orgo_res){
            foreach ($old_orgo_res as $old_key => $old_value){
                $old_goods_arr[$old_value->orgo_goo_id] = $old_value;
            }
        }
        // 2. 编辑订单商品表数据
        // 2.1 删除原来的订单商品数据
        $orgo_del_res = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->delete();
        // 订单类型不是发货单
        if ($request['ord_service_type'] != 5) {
            // 查询发货单数据
            $find_dego_data = DB::table('dispatch_bill')
                ->where('dego_order_type', 1)
                ->where('dego_wor_id', $request['ord_id'])
                ->where('dego_original_number', $order_data->ord_order_number)
                ->orderBy('dego_id', 'desc')
                ->first(['dego_id', 'dego_type', 'dego_out_ware_id', 'dego_count', 'dego_number']);
            if (!empty($find_dego_data)) {
                // 删除发货单的商品
                $find_digo_data = DB::table('dispatch_goods')
                    ->where('digo_dego_id', $find_dego_data->dego_id)
                    ->delete();
                // 删除发货单的数据
                $del_dibi_res = DB::table('dispatch_bill')
                    ->where('dego_id', $find_dego_data->dego_id)
                    ->where('dego_order_type', 1)
                    ->delete();
            }
        }
        // 订单类型不是退货单
        if ($request['ord_service_type'] != 4) {
            // 查询退货单数据
            $find_rec_id = DB::table('recede_recycle')
                ->where('rec_state', 1)
                ->where('rec_ord_id', $request['ord_id'])
                ->where('rec_ord_order_number', $order_data->ord_order_number)
                ->value('rec_id');
            if (!empty($find_rec_id)) {
                // 删除退换回收商品数据
                $del_rego_res = DB::table('recede_goods')
                    ->where('rego_rec_id', $find_rec_id)
                    ->delete();
                // 删除退换入库客户表数据
                $del_recl_data = DB::table('recede_client')
                    ->where('recl_rec_id', $find_rec_id)
                    ->delete();
                // 删除退换回收数据
                $del_rec_data = DB::table('recede_recycle')
                    ->where('rec_id', $find_rec_id)
                    ->delete();
            }
        }
        $ord_edit_data['ord_service_type'] = $request['ord_service_type']; //订单类型：1服务单 2洗车单3商品单
        // 2.2 添加新的订单商品数据
        $goo_all_quantity = 0; //商品总数量
        $goo_all_price = 0; //商品总金额
        $new_goo_all_quantity = 0;
        if (!empty($goods_data)) {
            $goods_data_count = count($goods_data);

            if ($goods_data_count == 1) {
                $find_sepr = DB::table('service_project')
                    ->where('sepr_id', $goods_data[0]['goo_id'])
                    ->select('sepr_work_type')
                    ->first();
                if ($find_sepr && $find_sepr->sepr_work_type == 2 && $goods_data[0]['goo_type'] == 2 && $request['ord_add_work_state'] == 1) {
                    return ['code' => 500, 'msg' => '无可生成工单服务', 'data' => ''];
                }
                if ($find_sepr && $find_sepr->sepr_work_type == 2 && $goods_data[0]['goo_type'] == 2) {
                    $ord_edit_data['ord_service_type'] = 2;
                }
            }
            $n = 0;
            foreach ($goods_data as $key => $value) {
                if (!empty($value['goo_id'])) {
                    if (!is_numeric($value['wago_id']) || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1, 3, 4, 5, 6, 7, 8]) || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2])  || !is_numeric($value['goo_quantity'])) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'商品参数类型错误'];
                    }
                    // goo_state 商品状态1.正常
                    if ($value['goo_state'] == 1 && $value['goo_type'] == 1) {
                        // 订单商品
                        $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    }

                    // 订单商品表
                    $orgo_data['orgo_ord_id'] = $request['ord_id'];
                    $orgo_data['orgo_order_number'] = $order_data->ord_order_number;
                    $orgo_data['orgo_ware_id'] = $request['ware_id'] ? $request['ware_id'] : 0;
                    $orgo_data['orgo_wago_id'] = $value['wago_id'];
                    $orgo_data['orgo_waon_class'] = $value['goo_waon_class'];
                    $orgo_data['orgo_actual_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_id'] = $value['goo_id'];
                    $orgo_data['orgo_goo_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_can_assign_quantity'] = $value['goo_quantity'];
                    $orgo_data['orgo_goo_inventory'] = $value['goo_inventory'];
                    $orgo_data['orgo_goo_goods_encode'] = !empty($value['goo_goods_encode']) ? $value['goo_goods_encode'] : '';
                    $orgo_data['orgo_goo_unit'] = $value['goo_unit'];
                    $orgo_data['orgo_goo_unta_id'] = $value['goo_unta_id'];
                    $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                    $orgo_data['orgo_goo_name'] = $value['goo_name'];
                    $orgo_data['orgo_goo_type'] = $value['goo_type'];
                    $orgo_data['orgo_state'] = $value['goo_state'];
                    $orgo_data['orgo_goo_price'] = $value['goo_price']*100;
                    $orgo_data['orgo_sale_performance'] = 0;
                    if (isset($request['orcl_sales_adm_id']) && $request['orcl_sales_adm_id']) {
                        $get_performance_type = DB::table('goods_performance_type')
                            ->where('gpt_sale_adm_id', $request['orcl_sales_adm_id'])
                            ->where('gpt_state', 1)
                            ->first();
                        if ($get_performance_type) {
                            if ($get_performance_type->gpt_type == 1) {
                                $gppe_performance = DB::table('goods_performance')
                                    ->where('gppe_shop_id', $user_info->adm_shop_id)
                                    ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                                    ->where('gppe_type', $orgo_data['orgo_goo_type'])
                                    ->where('gppe_goo_id', $value['goo_id'])
                                    ->value('gppe_performance');
                                $orgo_data['orgo_sale_performance'] = $gppe_performance;
                            }
                        }
                    }

                    $orgo_data['orgo_goo_amount'] = $value['goo_quantity']*$value['goo_price']*100;
                    $orgo_res = DB::table('order_goods')->insertGetId($orgo_data);
                    if($value['goo_type'] == 1){
                        if(isset($value['wago_id']) && $value['wago_id'] > 0){
                            $find_wago_price = DB::table('warehouse_goods')
                                ->where('wago_goo_id', $value['goo_id'])
                                ->where('wago_class', $orgo_data['orgo_waon_class'])
                                ->where('wago_ware_id', $orgo_data['orgo_ware_id'])
                                ->where('wago_id', $value['wago_id'])
                                ->value('wago_goo_price');
                            if($find_wago_price){
                                $goods_price[$value['wago_id']]['price'] = $find_wago_price;//商品成本价
                                $goods_price[$value['wago_id']]['quantity'] = $value['goo_quantity'];//商品数量
                            }
                        }else{
                            if(isset($old_goods_arr[$value['goo_id']])){
                                $find_wago_price = DB::table('warehouse_goods')
                                    ->where('wago_goo_id', $value['goo_id'])
                                    ->where('wago_class', $old_goods_arr[$value['goo_id']]->orgo_waon_class)
                                    ->where('wago_ware_id', $old_goods_arr[$value['goo_id']]->orgo_ware_id)
                                    ->where('wago_id', $old_goods_arr[$value['goo_id']]->orgo_wago_id)
                                    ->value('wago_goo_price');
                                if($find_wago_price){
                                    $goods_price[$value['wago_id']]['price'] = $find_wago_price;//商品成本价
                                    $goods_price[$value['wago_id']]['quantity'] = $value['goo_quantity'];//商品数量
                                }
                            }
                        }
                    }

                } else {
                    $orgo_res = 0;
                }
                if ($value['goo_type'] != 3) {
                    $goo_all_price += $value['goo_price']*$value['goo_quantity'];
                }
                if ($value['goo_type'] == 1) {//实物类
                    $value['orgo_id'] = $orgo_res;
                    $new_goods_data[] = $value;
                }
                if ($value['goo_quantity']) {
                    $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    if ($value['goo_type'] == 1) {
                        $new_goo_all_quantity += $value['goo_quantity']; //商品总数量
                    }
                }
                $goods_data[$key]['orgo_id'] = $orgo_res;
            }
        } else {
            $orgo_res = true;
        }
        $ord_edit_data['ord_wor_state'] = 1; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单
        // 不生成工单流程
        if ($request['ord_add_work_state'] == 2) {
            // 买家类型：1门店零售2客户单位(企业客户)3速电派单4第三方派单5运营中心给门店派单
            // 判断是否为散户，ord_type为空值，是散户
            if (empty($request['ord_type'])) {
                // 散户开单流程
                $order_datas['data']['ord_order_number'] = $order_data->ord_order_number;
                $order_datas['data']['ord_id'] = $request['ord_id'];
                $order_datas['data']['shop_id'] = $user_info->adm_shop_id;
                $order_datas['data']['ord_type'] = 0;
                $order_datas['data']['ord_client_id'] = $request['ord_client_id'];
                if ($request['ware_id'] && $is_goods) {//选择仓库并且选择产品
                    $ord_edit_data['ord_wor_state'] = 2;//服务中
                    $request['service_shop_id'] = $user_info->adm_shop_id;
                    $dibi_data = DispatchBill::create(
                        $user_info,   //用户信息
                        $request,  //订单提交数据
                        $new_goods_data,  //提交的商品数据
                        1,  //类型：1.订单发货 2.工单发货
                        $request['ware_id'],  //出库仓库id
                        $order_datas['data']['ord_order_number'],  //原始单号，订单号/工单号
                        $order_datas['data']['ord_id'],  //发货单关联的工单/订单id
                        $order_datas['data']['shop_id'],  //所属总店id
                        $order_datas['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $order_datas['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                        $new_goo_all_quantity  //发货总数量
                    );
                    if ($dibi_data['code'] == 500) {
                        return $dibi_data;
                    }
                } else {
                    $ord_edit_data['ord_wor_state'] = 20;//已完成
                }
            } else {
                // 不是散户，未选择产品或未选择仓库，生成订单，订单状态为待评价状态
                // 不是散户，选择产品并且选择仓库，生成订单，订单状态是服务中，生成发货单
                $order_datas['data']['ord_order_number'] = $order_data->ord_order_number;
                $order_datas['data']['ord_id'] = $request['ord_id'];
                $order_datas['data']['shop_id'] = $user_info->adm_shop_id;
                $order_datas['data']['ord_type'] = $request['ord_type'];
                $order_datas['data']['ord_client_id'] = $request['ord_client_id'];
                if ($request['ware_id'] && $is_goods) {//选择仓库并且选择产品
                    $ord_edit_data['ord_wor_state'] = 2;//服务中
                    $request['service_shop_id'] = $user_info->adm_shop_id;
                    $dibi_data = DispatchBill::create(
                        $user_info,   //用户信息
                        $request,  //订单提交数据
                        $new_goods_data,  //提交的商品数据
                        1,  //类型：1.订单发货 2.工单发货
                        $request['ware_id'],  //出库仓库id
                        $order_datas['data']['ord_order_number'],  //原始单号，订单号/工单号
                        $order_datas['data']['ord_id'],  //发货单关联的工单/订单id
                        $order_datas['data']['shop_id'],  //所属总店id
                        $order_datas['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $order_datas['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                        $new_goo_all_quantity  //发货总数量
                    );
                    if ($dibi_data['code'] == 500) {
                        return $dibi_data;
                    }
                } else {
                    $ord_edit_data['ord_wor_state'] = 4;//待评价
                    if (empty($request['orcl_phone'])) {
                        $ord_edit_data['ord_wor_state'] = 20;//已完成
                    }

                }
            }
        }

        // 4. 更改订单表客户id、订单金额
        $ord_edit_data['ord_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0; //仓库id
        $ord_edit_data['ord_client_id'] = $request['ord_client_id']; //选择客户id

        $ord_edit_data['ord_add_work_state'] = isset($request['ord_add_work_state']) ? $request['ord_add_work_state'] : ''; //生成工单状态：1是2否
        $goo_order_price = $goo_all_price; //订单总金额
        $ord_actual_price = $goo_all_price*100; //订单总金额
        // 4. 更改订单表客户id、订单金额
        if (isset($request['ord_payment_way'])) {
            $ord_edit_data['ord_payment_way'] = $request['ord_payment_way'];; // 结算方式1.账期 2.现结 3微信 4支付宝
            if ($request['ord_payment_way']) {
                $ord_edit_data['ord_state'] = 2; // 结算状态1未结算2已结算
                $ord_edit_data['ord_pay_state'] = 1; // 是否付款1是2否
                $ord_edit_data['ord_settlement_time'] = date('Y-m-d H:i:s'); // 结算状态1未结算2已结算
                $ord_edit_data['ord_settlement_time'] = date('Y-m-d H:i:s'); // 结算时间
                $ord_edit_data['ord_settlement_adm_id'] = $user_info->adm_id; // 结算人
                $ord_edit_data['ord_actual_price'] = $goo_order_price * 100; // 结算金额（单位：分）
                
            }
        } else {
            $ord_edit_data['ord_actual_price'] = 0;
        }
        $ord_edit_data['ord_order_price'] = $goo_order_price * 100; // 订单金额（单位：分）
        // $ord_edit_data['ord_actual_price'] = $goo_all_price * 100; // 结算金额（单位：分）
        $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity; // 商品总数量
        $ord_edit_data['ord_type'] = $request['ord_type']; // 订单类型：1门店零售2渠道单位
        $ord_edit_data['ord_address'] = $request['ord_address']; //施工地址
        $ord_edit_data['ord_address_type'] = $request['ord_address_type']; //施工地址类型
        if ($request['ord_address_type'] == 1) {
            $ord_address = DB::table('shop')
                ->where('shop_id', $request['ord_address_id'])
                ->value('shop_store_name');
            if ($request['ord_address'] != ($ord_address.'(本店)')) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'施工门店错误', 'data'=>''];
            }
        } elseif ($request['ord_address_type'] == 2) {
            $ord_address = DB::table('business_client')
                ->where('bucl_id', $request['ord_address_id'])
                ->value('bucl_name');
            if ($request['ord_address'] != $ord_address) {
                return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'施工门店错误', 'data'=>''];
            }
        }
        $ord_edit_data['ord_address_id'] = $request['ord_address_id']; //施工地址id
        $ord_edit_data['ord_explain'] = $request['ord_explain']; //施工地址id
        // 服务门店为0的话 是当前门店id
        $ord_edit_data['ord_service_shop_id'] = $user_info->adm_shop_id; //服务门店id

        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');

        if ($request['ord_payment_way'] && empty($order_data->ord_payment_way)) {
            if ($request['ord_payment_way'] == 6) {//使用余额支付
                $find_mem = DB::table('member')
                    ->where('mem_id', $request['mem_id'])
                    ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                    ->first();
                $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
                if ($ord_actual_price >= $banlance) {//余额不足
                    $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                    $ord_edit_data['ord_payment_money'] = $ord_actual_price - $banlance;
                    $ord_edit_data['ord_banlance'] = $banlance;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $find_mem->mem_gift_banlance;
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = $request['ord_remark'];
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                    $update_mem['mem_rec_banlance'] = 0;
                    $update_mem['mem_gift_banlance'] = 0;
                } elseif ($ord_actual_price < $banlance) {
                    $ord_edit_data['ord_payment_money'] = 0;
                    $ord_edit_data['ord_banlance'] = $ord_actual_price;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    if ($find_mem->mem_rec_banlance >= $ord_actual_price) {
                        $add_rec_log['relo_rec_num'] = $ord_actual_price;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $ord_actual_price;
                    } else {
                        $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $ord_actual_price - $find_mem->mem_rec_banlance;
                        $update_mem['mem_rec_banlance'] = 0;
                        $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($ord_actual_price - $find_mem->mem_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '编辑订单结算';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('member')->where('mem_id', $request['mem_id'])->update($update_mem);
            } else {
                $ord_edit_data['ord_payment_money'] = $goo_all_price*100;
                $ord_edit_data['ord_banlance'] = 0;
            }
            //添加支付明细
            if(!in_array($request['ord_payment_way'], [0,8])) {
                OrderSettlementDetails::addOrderSettlementDetails($request['ord_id'], $request['ord_type'], $request, $user_info, $ord_edit_data['ord_payment_money'], $ord_edit_data['ord_banlance']);
            }
        }

        if (isset($request['orcl_sales_adm_id']) && $request['orcl_sales_adm_id']) {
            $get_performance_type = DB::table('goods_performance_type')
                ->where('gpt_sale_adm_id', $request['orcl_sales_adm_id'])
                ->where('gpt_state', 1)
                ->first();
            if ($get_performance_type) {
                if ($get_performance_type->gpt_type == 2) {
                    $get_performance = DB::table('goods_performance')
                        ->where('gppe_type', 3)
                        ->where('gppe_performance', '>', 0)
                        ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                        ->first();
                    if ($get_performance) {
                        $ord_edit_data['ord_saleman_type'] = $get_performance->gppe_goo_id;
                        if ($get_performance->gppe_goo_id == 1) {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        } else {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        }
                    }
                } else {
                    $ord_edit_data['ord_saleman_type'] = 0;
                    $ord_edit_data['ord_saleman_performance'] = 0;
                }
            } else {
                $ord_edit_data['ord_saleman_type'] = 0;
                $ord_edit_data['ord_saleman_performance'] = 0;
            }
        }
        $ord_eidt_res = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_edit_data);
        //修改订单的应收应付
        $receivable_pay_res = DB::table('receivable_pay')
            ->where('recpay_original_id', $request['ord_id'])
            ->first();
        if($receivable_pay_res){
            //支付方式为1.现金2.支付宝 3微信 4银行卡  的实收金额
            /*if (in_array($request['ord_payment_way'],[1,2,3,4])) {
                $recpay_actual_price = $goo_order_price; //实收金额
            }else{
                $recpay_actual_price = 0;//实收金额
            }*/
            $recpay_actual_price = 0;//实收金额
            $recpay_arrears_price = $goo_order_price - $recpay_actual_price;//欠收金额 = 应收金额 - 实收金额
            if(in_array($request['ord_payment_way'],[5,6])){
                if(isset($ord_edit_data['ord_payment_money'])){
                    $recpay_actual_price = $ord_edit_data['ord_payment_money'] / 100 ;//实收金额
                }else{
                    $recpay_actual_price = 0;//实收金额
                }
                $recpay_arrears_price = 0;//欠收金额
            }else if($request['ord_payment_way'] > 0){
                if(isset($ord_edit_data['ord_payment_money'])){
                    $recpay_actual_price = $ord_edit_data['ord_payment_money'] / 100;//实收金额
                }else{
                    $recpay_actual_price = $goo_order_price ;//实收金额
                }
                $recpay_arrears_price = 0;//欠收金额
            }
            //$recpay_arrears_price = $goo_order_price - $recpay_actual_price;//欠收金额 = 应收金额 - 实收金额
            $recpay_cost_price = 0;//成本价
            if(isset($goods_price)){
                foreach ($goods_price as $g_k => $g_v){
                    $recpay_cost_price += $g_v['price'] * $g_v['quantity'];
                }
            }
            $profit = $recpay_actual_price - $recpay_cost_price;
            if($profit > 0){
                $minus = 1;
            }else{
                $minus = 2;
                $profit = abs($profit);
            }
            $rece_params = [
                'recpay_original_id'=>$request['ord_id'],
                'recpay_receivable_price'=>$goo_order_price,//应收金额
                'recpay_arrears_price'=>$recpay_arrears_price,//欠收金额
                'recpay_actual_price'=>$recpay_actual_price,//实收金额
                'recpay_cost_price'=>$recpay_cost_price,//成本价
                'recpay_order_state'=>1,//订单状态：1正常2退款3取消
                'recpay_plus_minus'=>$minus,//盈利正负：1正值2负值
                'recpay_profit'=>$profit,//盈利金额
            ];
            ReceivablePayService::edit($rece_params);
        }
        // 添加订单备注
        if (!empty($request['ord_remark'])) {
            $wor_remark = orderRemark($user_info, $request['ord_id'], 0, $request['ord_remark'], '订单编辑');
        } else {
            $wor_remark = true;
        }
        if ($ord_eidt_res && $orgo_res && $wor_remark) {
            return ['code'=>200, 'msg'=>'编辑订单成功', 'data'=>'编辑订单成功', 'return_datas'=>$goods_data];
        } else {
            return ['code'=>500, 'msg'=>'编辑订单失败3', 'data'=>'编辑订单失败3'];
        }
    }

    /**
     * [createWork 生成工单]
     * @param  [type]  $user_info [description]
     * @param  [type]  $request   [description]
     * @param  integer $type      [类型：1生成工单调用2订单立即派单调用]
     * @return [type]             [description]
     */
    public static function createWork($user_info, $request, $type = 1)
    {
        $find_order_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'ord_wor_state', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_adm_id', 'orcl_car_vin', 'orcl_car_brand_series', 'ord_ware_id', 'ord_client_id', 'ord_create_time', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain', 'ord_address_type', 'ord_address_id', 'orcl_business_name', 'orcl_business_id', 'orcl_sales_adm_id', 'ord_service_type', 'orcl_carbrse_type', 'ord_source', 'ord_other_system_number', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address','ord_wor_quantity', 'orcl_join_wor_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'orcl_sales_adm_name', 'ord_new_type')
            ->first();
        if (empty($find_order_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'订单不存在', 'data'=>'订单不存在'];
        }
        if ($find_order_data->ord_wor_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'已生成工单，无法重复生成', 'data'=>'已生成工单，无法重复生成'];
        }
        if ($find_order_data->ord_wor_state == 4) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已完成，无法派单', 'data'=>'当前订单已完成，无法派单'];
        }
        if ($find_order_data->ord_wor_state == 11) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已取消，无法派单', 'data'=>'当前订单已取消，无法派单'];
        }
        if ($find_order_data->ord_wor_state == 1) {
            if (empty($request['service_adm_data'])) {
                return ['code'=>500, 'msg'=>'请选择技师', 'data'=>''];
            }
            if (empty($request['ord_address_id'])) {
                return ['code'=>500, 'msg'=>'请选择施工门店', 'data'=>''];
            }
        }
        $edit_order_data['ord_wor_quantity'] = $find_order_data->ord_wor_quantity + 1;
        $order_edit_res = DB::table('order')->where('ord_id', $request['ord_id'])->update($edit_order_data);
        // 如果有预约时间，则判断是否超出限制预约数量；
        // if (isset($request['orcl_appoint_time'])) {
        //     $resenum_date = substr($request['orcl_appoint_time'],0,10);
        //     $jud_res = WashWorkService::judgmentShopReser($user_info,$resenum_date,$find_order_data->orcl_appoint_time,$request);
        //     if($jud_res['code'] != 200) return $jud_res;
        // }
        // 填写预约时间，修改预约时间
        // if (isset($request['orcl_appoint_time']) && !empty($request['orcl_appoint_time'])) {
        //     $edit_orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
        //     $edit_orcl_data['orcl_update_time'] = date('Y-m-d H:i:s'); //更新时间
        //     $orcl_edit_res = DB::table('order_client')->where('orcl_ord_id', $request['ord_id'])->update($edit_orcl_data);
        //     $edit_order_data['ord_wor_quantity'] = $find_order_data->ord_wor_quantity + 1;
        //     $orcl_edit_res = DB::table('order')->where('ord_id', $request['ord_id'])->update($edit_order_data);
        //     $param['daytime'] = $request['orcl_appoint_time']; //速电-预约时间
        //     //如果是智配贴装订单
        //     if ($find_order_data->ord_source == 5) {
        //         $param['serial_number'] = $find_order_data->ord_other_system_number;
        //         $param['time'] = date('Y-m-d H:i:s');
        //         $param['daytime'] = $request['orcl_appoint_time'];
        //         $param['ip'] = Request::getClientIp();
        //         $param['token'] = config('apiconnect.ZPTZ_TOKEN');
        //         $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/addDayTime';
        //         $param_return = doPost($param, $url, 2);
        //         $param_return = json_decode($param_return, true);
        //         $log_res = orderLog($user_info, $request['ord_id'], 0, '领取订单');
        //         $param['daytime'] = $request['orcl_appoint_time']; //速电-预约时间

        //         // 预约备注内容
        //         $remark_data = '预约时间：' . $request['orcl_appoint_time'];
        //         if (!empty($request['appoint_remark'])) {
        //             $remark_data .= ' ' . $request['appoint_remark'];
        //         }
        //         $remark_res = orderRemark($user_info, $request['ord_id'], 0, $remark_data, '订单列表-接单预约');

        //         if ($orcl_edit_res && $remark_res) {
        //             $appoint_res = true;
        //         } else {
        //             $appoint_res = false;
        //         }
        //     }
        // }
        // 添加施工门店
        $edit_data['ord_new_type'] = isset($request['ord_new_type']) ? $request['ord_new_type'] : $find_order_data->ord_new_type; //施工说明
        $edit_data['ord_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : $find_order_data->ord_explain; //施工说明
        $edit_data['ord_address'] = isset($request['ord_address']) ? $request['ord_address'] : $find_order_data->ord_address; //施工门店
        $edit_data['ord_address_id'] = isset($request['ord_address_id']) ? $request['ord_address_id'] : $find_order_data->ord_address_id; //施工门店id
        $edit_data['ord_address_type'] = isset($request['ord_address_type']) ? $request['ord_address_type'] : $find_order_data->ord_address_type; //施工门店类型
        $edit_data['ord_wor_state'] = 1; //订单的工单状态1未派工单2服务中3售后中
        $edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $request['ord_id'])->update($edit_data);
        // 上游订单领取订单 
        // 1.选择技师到待验车状态
        // 2.不选择技师就是待派订单 ord_wor_state = 1
        // 3.本店自己生成的订单领取的时候不添加技师就不改变状态
        if (!isset($request['service_adm_data']) || empty($request['service_adm_data'])) {
            // if (config('apisystem.SYNC_STATE') && $find_order_data->ord_wor_state == 7 && $find_order_data->ord_source == 5) {
            //     // 总店接单，同步速电
            //     sdOrderLog($find_order_data, 0, $find_order_data->orcl_join_wor_id, '接受订单');
            //     $url = config('apisystem.sd_server_name') . '/index.php/api/supplychain/SupplyMz/sync_receipt_status';
                
            //     $param['serial_number'] = $find_order_data->ord_other_system_number; //第三方工单号
            //     $param['type'] = 1;
            //     $param['ip'] = $request['ip'];
            //     $param['time'] = date('Y-m-d H:i:s'); //收货时间
            //     $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
            //     $doPost_res = nCommon::doPost($param, $url, 2);
            //     $doPost_res = json_decode($doPost_res);
            //     if ($doPost_res->code != 200) {
            //         DB::rollBack();
            //         return ['code'=>500, 'msg'=>'同步失败', 'data'=>'失败', 'zptzmsg'=>$doPost_res->msg];
            //     }
            // }
        }
        $service_adm_data = $request['service_adm_data'];
        if (!is_array($service_adm_data)) {
            $service_adm_data = json_decode($service_adm_data, true);
        }
        
        $service_adm_id = '';
        
        $find_work_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->where('wor_delete', 1)
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->value('wor_id');
        if (!empty($find_work_data)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已生成工单，请勿重复生成！', 'data'=>'当前订单已生成工单，请勿重复生成！'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //商品数据
        $request['goods_data'] = DB::table('order_goods')
            ->leftJoin('goods', 'goo_id', '=', 'orgo_goo_id')
            ->where('orgo_ord_id', $request['ord_id'])
            ->where('orgo_goo_type', '!=', 3)
            ->select('orgo_id', 'orgo_goo_id as goo_id', 'orgo_goo_name as goo_name', 'orgo_state as goo_state', 'orgo_goo_price as goo_price', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'orgo_goo_type as goo_type', 'orgo_goo_goods_encode as goo_goods_encode', 'orgo_wago_id as wago_id', 'orgo_goo_amount', 'goo_unit_conversion')
            ->get()->toArray();
        $goods_data = json_decode(json_encode($request['goods_data'], true), true);
        $sepr_check_car = 2;//1需要验车2不用验车
        foreach ($goods_data as $key => $value) {
            $sepr_check_car = DB::table('service_project')
                ->where('sepr_id', $value['goo_id'])
                ->value('sepr_check_car');
            if ($sepr_check_car == 1) {
                $sepr_check_car = 1;
                break;
            }
        }
        if ($find_order_data->ord_source == 5) {
            $sepr_check_car = 1;
        }
        $new_sepr_id=',';
        $new_goo_id = ',';
        $new_sepr_name='';
        $new_goo_name='';
        // 新增订单商品数据
        foreach ($goods_data as $key => $value) {
            if ($value['goo_type'] == 2) {
                $new_sepr_id .= $value['goo_id'].',';
                $new_sepr_name .= ','.$value['goo_name'];

            } elseif ($value['goo_type'] == 1) {
                $new_goo_id .= $value['goo_id'].',';

                $new_goo_name .= ','.$value['goo_name'].'*'.$value['goo_quantity'].$value['goo_unit'];
            }
        }
        $new_sepr_name=trim($new_sepr_name,',');
        $new_goo_name =trim($new_goo_name,',');

        $new_goo_id  = $new_goo_id  == "," ? "" : $new_goo_id;
        $new_sepr_id = $new_sepr_id == "," ? "" : $new_sepr_id;
        if (empty($service_adm_data)) {//没有技师修改排班计划
            // $find_wopl = DB::table('work_plan')
            //     ->where('wopl_ord_id', $request['ord_id'])
            //     ->value('wopl_id');
            // if (empty($find_wopl)) {
            //     // 添加排班计划
            //     $wopl_data['wopl_shop_id'] = $user_info->adm_shop_id;
            //     $wopl_data['wopl_wor_id'] = 0;
            //     $wopl_data['wopl_ord_id'] = $request['ord_id'];
            //     $wopl_data['wopl_sepr_id'] = $new_sepr_id;
            //     $wopl_data['wopl_sepr_name'] = $new_sepr_name;
            //     $wopl_data['wopl_goo_id'] = $new_goo_id;
            //     $wopl_data['wopl_goo_name'] = $new_goo_name;
            //     $wopl_data['wopl_address_id'] = isset($request['ord_address_id']) ? $request['ord_address_id'] : $find_order_data->ord_address_id; //施工门店id
            //     $wopl_data['wopl_address'] = isset($request['ord_address']) ? $request['ord_address'] : $find_order_data->ord_address; //施工门店地址
            //     $wopl_data['wopl_address_type'] = isset($request['ord_address_type']) ? $request['ord_address_type'] : $find_order_data->ord_address_type; //施工门店类型
            //     if ($find_order_data->orcl_sales_adm_id) {
            //         $find_adm = DB::table('admin')->where('adm_id', $find_order_data->orcl_sales_adm_id)->value('adm_name');
            //     } else {
            //         $find_adm = '';
            //     }
            //     $wopl_data['wopl_sale_name'] = $find_adm;
            //     $wopl_data['wopl_sale_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : $find_order_data->orcl_sales_adm_id;
            //     $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';
            //     $wopl_data['wopl_ord_new_type'] = isset($request['ord_new_type']) ? $request['ord_new_type'] : '';
            //     $wopl_data['wopl_time'] = isset($request['orcl_appoint_time']) ? date('H:i:s', strtotime($request['orcl_appoint_time'])) : '';
            //     $wopl_data['wopl_date'] = isset($request['orcl_appoint_time']) ? date('Y-m-d', strtotime($request['orcl_appoint_time'])) : '';
            //     $wopl_data['wopl_service_id'] = '';
            //     $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
            //     $wopl_id = DB::table('work_plan')->insertGetId($wopl_data);
            // } else {
            //     // 添加排班计划
            //     $wopl_data['wopl_wor_id'] = 0;
            //     $wopl_data['wopl_ord_new_type'] = isset($request['ord_new_type']) ? $request['ord_new_type'] : '';
            //     $wopl_data['wopl_address_type'] = $request['ord_address_type'];
            //     $wopl_data['wopl_address_id'] = $request['ord_address_id'];
            //     $wopl_data['wopl_address'] = $request['ord_address'];
            //     $wopl_data['wopl_explain'] = $request['ord_explain'];
            //     $wopl_data['wopl_time'] = date('H:i:s', strtotime($request['orcl_appoint_time']));
            //     $wopl_data['wopl_date'] = date('Y-m-d', strtotime($request['orcl_appoint_time']));
            //     $wopl_data['wopl_service_id'] = '';
            //     $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
            //     $wopl_id = DB::table('work_plan')->where('wopl_ord_id', $request['ord_id'])->update($wopl_data);
            // }
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>'请选择技师'];
        }

        $wor_order_number = Common::numberRule($user_info, 2);

        $data['wor_cid'] = $user_info->adm_cid;
        $data['wor_superior_shop_id'] = $shop_id;
        $data['wor_shop_id'] = $user_info->adm_shop_id;
        $data['wor_create_id'] = $user_info->adm_id;
        $data['wor_number'] = $wor_order_number;
        $data['wor_order_id'] = $request['ord_id'];
        $data['wor_order_number'] = $find_order_data->ord_order_number;
        $data['wor_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        $data['wor_type'] = $find_order_data->ord_type;
        $data['wor_ware_id'] = $find_order_data->ord_ware_id;
        $data['wor_address'] = isset($request['ord_address']) ? $request['ord_address']:$find_order_data->ord_address;
        $data['wor_address_type'] = isset($request['ord_address_type']) ? $request['ord_address_type']:$find_order_data->ord_address_type;
        $data['wor_address_id'] = isset($request['ord_address_id']) ? $request['ord_address_id']:$find_order_data->ord_address_id;
        $data['wor_service_type'] = $find_order_data->ord_service_type; //订单类型：1服务单2销售单3换货单
        $data['wor_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['wor_remark'] = $find_order_data->ord_remark;
        $data['wor_explain'] = isset($request['ord_explain']) ? $request['ord_explain']:$find_order_data->ord_explain;
        $data['wor_state'] = 3;
        if ($sepr_check_car == 1) {//服务项目需要验车
            $data['wor_service_state'] = 3; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
            $data['wor_state'] = 5; //3待接单/已派单 5.已接单/待验车 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核
            $wocl_check_car_state = 2;
        } else {
            $data['wor_service_state'] = 5; //服务状态：1待接单2已接单3预约4施工中5抵达6完成待审核
            $data['wor_state'] = 7; //3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.施工中 7.施工中 8.待审核/完成待审核
            $wocl_check_car_state = 5;//验车状态
        }
        $data['wor_pass'] = 1; //审核：1.待审核 2.合格 3.不合格
        $data['wor_actual_price'] = $find_order_data->ord_actual_price; //工单结算金额（单位：分）
        $data['wor_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量
        $data['wor_new_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量(用料)
        if ($find_order_data->ord_source == 5) {
            $data['wor_work_type'] = 2;//工单类型：1门店工单2智配工单
        }
        if (isset($request['orcl_appoint_time']) && $request['orcl_appoint_time'] != '0000-00-00 00:00:00' && !empty($request['orcl_appoint_time'])) {
            $data['wor_appoint_time'] = $request['orcl_appoint_time']; //预约时间
        }
        // // 判断预约时间是否超出限制； 客户表里的预约时间不用传因为一开始就没判断过客户表的预约时间
        // $resenum_date=substr($request['orcl_appoint_time'],0,10);
        // $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date);
        // if($jud_res['code'] != 200) return $jud_res;

        $data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_id = DB::table('work_order')->insertGetId($data);

        $update_cominfo = DB::table('completion_info')
            ->where('coin_ord_id', $request['ord_id'])
            ->update(['coin_wor_id'=>$wor_id, 'coin_adm_id'=>$service_adm_data[0]['adm_id']]);
        // 添加工单客户表数据
        $wocl_data = [
            'wocl_wor_id' => $wor_id,
            'wocl_client_id' => $find_order_data->orcl_client_id ? $find_order_data->orcl_client_id : 0, //选择客户id
            'wocl_adm_id' => $find_order_data->orcl_sales_adm_id ? $find_order_data->orcl_sales_adm_id : 0, //业务员id
            'wocl_sales_adm_name' => $find_order_data->orcl_sales_adm_name ? $find_order_data->orcl_sales_adm_name : 0, //业务员id
            'wocl_name' => $find_order_data->orcl_name ? $find_order_data->orcl_name : '',
            'wocl_bus_name' => $find_order_data->orcl_business_name ? $find_order_data->orcl_business_name : '',
            'wocl_bus_id' => $find_order_data->orcl_business_id ? $find_order_data->orcl_business_id : 0,
            'wocl_phone' => $find_order_data->orcl_phone ? $find_order_data->orcl_phone : '',
            'wocl_carowner_name' => $find_order_data->orcl_carowner_name ? $find_order_data->orcl_carowner_name : '',
            'wocl_carowner_phone' => $find_order_data->orcl_carowner_phone ? $find_order_data->orcl_carowner_phone : '',
            'wocl_car_num' => $find_order_data->orcl_car_num ? $find_order_data->orcl_car_num : '',
            'wocl_appoint_remark' => $find_order_data->orcl_appoint_remark ? $find_order_data->orcl_appoint_remark : '', //预约备注
            'wocl_car_vin' => $find_order_data->orcl_car_vin ? $find_order_data->orcl_car_vin : '', //车架号车辆识别码
            'wocl_car_brand_series' => $find_order_data->orcl_car_brand_series ? $find_order_data->orcl_car_brand_series : '', //品牌车系
            'wocl_carbrse_type' => $find_order_data->orcl_carbrse_type ? $find_order_data->orcl_carbrse_type : 1, //品牌车系
            'wocl_check_car_state' => $wocl_check_car_state, //是否验车：0此工单不需要验车1是、已验车2否、未验车3客户已签字4补充签字
            'wocl_update_time' => date('Y-m-d H:i:s'),
            'wocl_province' => $find_order_data->orcl_province ? $find_order_data->orcl_province : '',
            'wocl_city' => $find_order_data->orcl_city ? $find_order_data->orcl_city : '',
            'wocl_county' => $find_order_data->orcl_county ? $find_order_data->orcl_county : '',
            'wocl_address' => $find_order_data->orcl_address ? $find_order_data->orcl_address : '',
        ];
        $wocl_id = DB::table('work_client')->insertGetId($wocl_data);


        $goo_all_price = 0; //商品总金额
        $goo_all_quantity = 0; //商品总数量
        $goo_all_quantitys = 0;
        $create_dis = false;
        $sepr_id = '';
        $sepr_name = '';
        $goo_id = '';
        $goo_name = '';

        $new_goods_data = [];

        // 新增工单商品数据
        foreach ($goods_data as $key => $value) {
            if (!isset($value['goo_waon_class'])) {
                $value['goo_waon_class'] = 1;
                $goods_data[$key]['goo_waon_class'] = 1;
            }
            if (!isset($value['goo_inventory'])) {
                $value['goo_inventory'] = 1;
                $goods_data[$key]['goo_inventory'] = 1;
            }

            if ($value['goo_type'] == 2) {
                if ($sepr_id) {
                    $sepr_id = $sepr_id.$value['goo_id'].',';
                } else {
                    $sepr_id = ','.$value['goo_id'].',';
                }
                if ($sepr_name) {
                    $sepr_name = $sepr_name.','.$value['goo_name'];
                } else {
                    $sepr_name = $value['goo_name'];
                }
                $value['wago_id'] = 0;
                $goods_data[$key]['wago_id'] = 0;
            } else {
                $find_wago_id = DB::table('warehouse_goods')
                    ->where('wago_goo_id', $value['goo_id'])
                    ->where('wago_class', $value['goo_waon_class'])
                    ->where('wago_ware_id', $find_order_data->ord_ware_id)
                    ->value('wago_id');
                $value['wago_id'] = !empty($find_wago_id) ? $find_wago_id : 0;
                $goods_data[$key]['wago_id'] = !empty($find_wago_id) ? $find_wago_id : 0;
                $new_goods_data[] = $value;
            }
            // 搜索商品id对应的商品名称、商品编号
            $find_goods_data = DB::table('goods')
                ->where('goo_id', $value['goo_id'])
                ->first(['goo_name', 'goo_goods_encode', 'goo_type', 'goo_class']);
            if (!empty($value['goo_id'])) {
                if ($value['goo_type'] != 2) {
                    $create_dis = true;
                }
                $wogo_data['wogo_wor_id'] = $wor_id;
                $wogo_data['wogo_orgo_id'] = $value['orgo_id'];
                $wogo_data['wogo_wago_id'] = ($value['goo_type']==1) ? $value['wago_id'] : 0;
                $wogo_data['wogo_goo_id'] = $value['goo_id'];
                $wogo_data['wogo_goo_name'] = $value['goo_name'];
                $wogo_data['wogo_goo_type'] = $value['goo_type'];
                $wogo_data['wogo_goo_inventory'] = $value['goo_inventory'];
                $wogo_data['wogo_state'] = $value['goo_state'];
                $wogo_data['wogo_goo_amount'] = $value['goo_quantity'];
                if ($value['goo_type'] == 1) {
                    if (empty($value['goo_unit']) || empty($value['goo_unta_id'])) {
                        return ['code'=>500, 'msg'=>'请选择单位', 'data'=>'请选择单位'];
                    }
                }
                $wogo_data['wogo_goo_unit'] = $value['goo_unit'];
                $wogo_data['wogo_goo_price'] = $value['goo_price'];
                $wogo_data['wogo_goo_sum'] = $value['goo_price']*$value['goo_quantity'];
                $wogo_data['wogo_goo_unta_id'] = $value['goo_unta_id'];
                $wogo_data['wogo_goo_goods_encode'] = $value['goo_goods_encode'];
                $wogo_data['wogo_update_time'] = date('Y-m-d H:i:s');
                $wogo_id = DB::table('work_good')->insertGetId($wogo_data);
            } else {
                $wogo_id = 0;
            }
            $goo_all_price += $value['goo_price']*$value['goo_quantity']; //总金额

            $goo_all_quantity += $value['goo_quantity']; //商品总数量
            if ($value['goo_type'] == 1) {
                $goo_all_quantitys += $value['goo_quantity']; //商品总数量
            }
        }


        $sevice_list1 = '';
        $sevice_list2 = [];
        //$service_adm_data = json_decode($service_adm_data,true);
        foreach ($service_adm_data as $key1 => $value1) {
            // 工单技师施工部位表
            $wotp_data['wotp_shop_id'] = $user_info->adm_shop_id;
            $wotp_data['wotp_wor_id'] = $wor_id;
            $wotp_data['wotp_service_adm_id'] = $value1['adm_id'];
            // 查询技师相关信息
            $find_adm_data = DB::table('admin as a')
                ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
                ->where('adm_id', $value1['adm_id'])
                ->select('adm_id', 'adm_name', 'adm_phone', 'grle_id', 'grle_name', 'grpr_id', 'grpr_name')
                ->first();
            if (empty($find_adm_data)) {
                return ['code'=>500, 'msg'=>'未找到技师相关信息', 'data'=>'未找到技师相关信息'];
            }

            // if($value1['adm_id'] == $request['service_adm_id']){
            //     $sevice_list1 = $find_adm_data->adm_name."(组长)";
            // }else{
            // }
            $sevice_list2[] = $find_adm_data->adm_name;
            $wotp_data['wotp_service_adm_name'] = $find_adm_data->adm_name;
            $wotp_data['wotp_service_adm_phone'] = $find_adm_data->adm_phone;
            if ($find_adm_data->grle_id) {
                $wotp_data['wotp_grle_id'] = $find_adm_data->grle_id;
            }
            if ($find_adm_data->grle_name) {
                $wotp_data['wotp_grle_name'] = $find_adm_data->grle_name;
            }
            if ($find_adm_data->grpr_id) {
                $wotp_data['wotp_grpr_id'] = $find_adm_data->grpr_id;
            }
            if ($find_adm_data->grpr_name) {
                $wotp_data['wotp_grpr_name'] = $find_adm_data->grpr_name;
            }
            $wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data);
            $wotp_data1= $wotp_data;
            $wotp_data2= $wotp_data;
            $wotp_data1['wotp_work_type'] = 2;
            $wotp_data2['wotp_work_type'] = 3;
            $wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data1);
            $wotp_res = DB::table('wash_work_technician_part')->insert($wotp_data2);
            unset($wotp_data);
            unset($wotp_data1);
            unset($wotp_data2);
            if (!empty($service_adm_id)) {
                $service_adm_id = $service_adm_id.','.$value1['adm_id'];
            } else {
                $service_adm_id = $value1['adm_id'];
            }
        }
        $order_data['data']['shop_id'] = $shop_id;
        $request['ord_client_id'] = $find_order_data->ord_client_id; //客户id
        $request['ord_type'] = $find_order_data->ord_type;
        $request['service_shop_id'] = $user_info->adm_shop_id;
        // if ($create_dis && !empty($find_order_data->ord_ware_id)) {
        //     $dibi_data = DispatchBill::create(
        //         $user_info,   //用户信息
        //         $request,  //订单提交数据
        //         $new_goods_data,  //提交的商品数据
        //         2,  //类型：1.订单发货 2.工单发货
        //         $find_order_data->ord_ware_id,  //出库仓库id
        //         $wor_order_number,  //原始单号，订单号/工单号
        //         $wor_id,  //发货单关联的工单/订单id
        //         $order_data['data']['shop_id'],  //所属总店id
        //         $request['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        //         $request['ord_client_id'],  //选择的客户id,会员id/单位id
        //         $goo_all_quantitys  //发货总数量
        //     );
        //     if ($dibi_data['code'] == 500) {
        //         return $dibi_data;
        //     }
        // }
        $edit_data['ord_wor_state'] = 2; //订单的工单状态1未派工单2服务中3售后中
        $edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $request['ord_id'])->update($edit_data);

        $edit_wor_data['wor_service_adm_id'] = $service_adm_data[0]['adm_id'];
        $edit_wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $edit_wor_res = DB::table('work_order')->where('wor_id', $wor_id)->update($edit_wor_data);

        // if (!empty($request['service_adm_data'])) {//企业版有排班计划
        //     $find_wopl = DB::table('work_plan')
        //         ->where('wopl_ord_id', $request['ord_id'])
        //         ->value('wopl_id');
        //     if (empty($find_wopl)) {
        //         // 添加排班计划
        //         $wopl_data['wopl_shop_id'] = $user_info->adm_shop_id;
        //         $wopl_data['wopl_wor_id'] = $wor_id;
        //         $wopl_data['wopl_ord_id'] = $request['ord_id'];
        //         $wopl_data['wopl_sepr_id'] = $sepr_id;
        //         $wopl_data['wopl_sepr_name'] = $sepr_name;
        //         $wopl_data['wopl_goo_id'] = $goo_id;
        //         $wopl_data['wopl_goo_name'] = $goo_name;
        //         $wopl_data['wopl_address_id'] = isset($request['ord_address_id']) ? $request['ord_address_id'] : $find_order_data->ord_address_id; //施工门店id
        //         $wopl_data['wopl_address'] = isset($request['ord_address']) ? $request['ord_address'] : $find_order_data->ord_address; //施工门店地址
        //         $wopl_data['wopl_address_type'] = isset($request['ord_address_type']) ? $request['ord_address_type'] : $find_order_data->ord_address_type; //施工门店类型
        //         if ($find_order_data->orcl_sales_adm_id) {
        //             $find_adm = DB::table('admin')->where('adm_id', $find_order_data->orcl_sales_adm_id)->value('adm_name');
        //         } else {
        //             $find_adm = '';
        //         }
        //         $wopl_data['wopl_sale_name'] = $find_adm;
        //         $wopl_data['wopl_sale_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : $find_order_data->orcl_sales_adm_id;
        //         $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';
        //         $wopl_data['wopl_time'] = isset($request['orcl_appoint_time']) ? date('H:i:s', strtotime($request['orcl_appoint_time'])) : '';
        //         $wopl_data['wopl_date'] = isset($request['orcl_appoint_time']) ? date('Y-m-d', strtotime($request['orcl_appoint_time'])) : '';
        //         $wopl_data['wopl_service_id'] = $service_adm_id;
        //         $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
        //         $wopl_id = DB::table('work_plan')->insertGetId($wopl_data);
        //     } else {
        //         // 添加排班计划
        //         $wopl_data['wopl_wor_id'] = $wor_id;
        //         $wopl_data['wopl_address_type'] = $request['ord_address_type'];
        //         $wopl_data['wopl_address_id'] = $request['ord_address_id'];
        //         $wopl_data['wopl_address'] = $request['ord_address'];
        //         $wopl_data['wopl_explain'] = $request['ord_explain'];
        //         $wopl_data['wopl_time'] = date('H:i:s', strtotime($request['orcl_appoint_time']));
        //         $wopl_data['wopl_date'] = date('Y-m-d', strtotime($request['orcl_appoint_time']));
        //         $wopl_data['wopl_service_id'] = $service_adm_id;
        //         $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
        //         $wopl_id = DB::table('work_plan')->where('wopl_ord_id', $request['ord_id'])->update($wopl_data);
        //     }
        // }

        if ($wor_id && $wocl_id && $ord_edit_res && $wotp_res) {
            $return_data['wor_id'] = $wor_id;
            $return_data['wor_order_number'] = $wor_order_number;
            $sevice_list = $sevice_list1;
            if($sevice_list2){
                $sevice_list .= ",".implode(',', $sevice_list2);
            }
            foreach ($service_adm_data as $key => $value) {
                // 查询技师相关信息
                $find_adm_data = DB::table('admin as a')
                    ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                    ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
                    ->where('adm_id', $value['adm_id'])
                    ->select('adm_id', 'adm_name', 'adm_phone', 'grle_id', 'grle_name', 'grpr_id', 'grpr_name')
                    ->first();
                // 微信消息推送
                $wechat_msg['pushtype'] = 1; //工单推送
                $wechat_msg['adm_id'] = $value['adm_id']; //推送人
                $wechat_msg['wor_number'] = $wor_order_number; //工单号
                $wechat_msg['ord_number'] = $find_order_data->ord_order_number; //订单号
                $wechat_msg['order_type'] = ordType($request['ord_service_type']); //订单类型
                $wechat_msg['user_name'] = $find_adm_data->adm_name; //姓名
                $wechat_msg['sepr_name'] = $sepr_name; //服务项目
                // $wechat_msg['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
                $wechat_msg['ord_create_time'] = $find_order_data->ord_create_time; //订单创建时间

                $wechat_msg['user_phone'] = $find_adm_data->adm_phone; //手机号
                $wechat_msg['user_dress'] = $find_order_data->ord_province . $find_order_data->ord_city . $find_order_data->ord_county . $find_order_data->ord_address; //详细地址
                $wechat_msg['shop_name'] = ShopService::screenShopName($request['ord_address'], $request['ord_address_type'], "(本店)"); //门店名称
                $wechat_msg['sevice_list'] = $sevice_list; //技师列表
                $wechat_msg['tittle'] = '您有新的工单，请及时处理'; //手机
                $wechat_msg['remark'] = !empty($find_order_data->ord_remark) ? $find_order_data->ord_remark : '';
                $CashierDesk = new CashierDesk;
                $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
            }

            //如果是智配贴装订单
            // if ($find_order_data->ord_source == 5) {
            //     if ($find_order_data->ord_wor_state == 7 && isset($request['service_adm_data']) && !empty($request['service_adm_data'])) {
            //         // 总店接单，同步速电
            //         sdOrderLog($find_order_data, 0, $find_order_data->orcl_join_wor_id, '接受订单');
            //         $url = config('apisystem.sd_server_name') . '/index.php/api/supplychain/SupplyMz/sync_receipt_status';
            //         $param['serial_number'] = $find_order_data->ord_other_system_number; //第三方工单号
            //         $param['type'] = 1;
            //         $param['ip'] = $request['ip'];
            //         $param['time'] = date('Y-m-d H:i:s'); //收货时间
            //         $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
            //         $doPost_res = nCommon::doPost($param, $url, 2);
            //         $doPost_res = json_decode($doPost_res);
            //         if ($doPost_res->code != 200) {
            //             return ['code'=>500, 'msg'=>'同步智配失败：'.$doPost_res->msg, 'data'=>'失败'];
            //         }
            //     }
            // }
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'生成工单失败', 'data'=>'生成工单失败'];
        }
    }

    public static function request_post_webs(
        $url,
        $data
    ){
        // $headerArray =array("Content-type:application/json;charset='utf-8'","Accept:application/json");
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,FALSE);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        // curl_setopt($curl,CURLOPT_HTTPHEADER,$headerArray);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        curl_close($curl);
        return $output;
    }

    // 验车
    public static function validateCar($user_info, $request)
    {
        $data['orvc_shop_id'] = $user_info->adm_shop_id;
        $data['orvc_adm_id'] = $user_info->adm_id;
        $data['orvc_ord_id'] = $request['ord_id'];
        $data['orvc_mileage'] = $request['orvc_mileage']; //进店里程数
        // $data['orvc_film_roll_number'] = $request['orvc_film_roll_number']; //膜卷号
        $data['orvc_car_interior'] = $request['orvc_car_interior']; //车内异常
        $data['orvc_car_exterior'] = $request['orvc_car_exterior']; //外观部分
        $data['orvc_update_time'] = date('Y-m-d H:i:s');
        $find_order_data = DB::table('wash_order_validate_car as ovc')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ovc.orvc_ord_id')
            ->where('orvc_ord_id', $request['ord_id'])
            ->select('orvc_id', 'orcl_check_car_state')
            ->first();
        if (!empty($find_order_data->orvc_id)) {
            if ($find_order_data->orvc_id) {
                if ($find_order_data->orcl_check_car_state == 3) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'客户已签字，无法编辑'];
                }
                $orvc_res = DB::table('wash_order_validate_car')->where('orvc_id', $find_order_data->orvc_id)->update($data);
            } else {
                $orvc_res = DB::table('wash_order_validate_car')->insert($data);
            }
        } else {
            $orvc_res = DB::table('wash_order_validate_car')->insert($data);
        }

        // 更改订单客户表的验车字段数据
        $ord_data['orcl_check_car_state'] = 1; //是否验车：1是2否
        $ord_data['orcl_update_time'] = date('Y-m-d H:i:s');
        $orcl_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($ord_data);
        // 更改工单客户表的验车字段数据
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->value('wor_id');
        if ($find_work) {
            // 更改订单客户表的验车字段数据
            $work_data['wocl_check_car_state'] = 1; //是否验车：1是2否
            $work_data['wocl_update_time'] = date('Y-m-d H:i:s');
            $wocl_res = DB::table('work_client')
                ->where('wocl_wor_id', $find_work)
                ->update($work_data);
        } else {
            $wocl_res = true;
        }
        if ($orvc_res && $orcl_res && $wocl_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑失败'];
        }
    }

    // 详情
    public static function info($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('shop as s', 's.shop_id', '=', 'ord.ord_shop_id')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->leftJoin('warehouse as w', 'w.ware_id', '=', 'ord.ord_ware_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_mem_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'orcl_signature_img', 'orcl_sales_adm_id', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'ord_explain', 'orcl_mem_source', 'ord_address_id', 'ord_address_type', 'orcl_business_name', 'orcl_business_id', 'shop_store_name', 'ord_service_type', 'ord_settlement_time', 'orcl_carbrse_type', 'ord_shop_id', 'ord_cancel_reason', 'ord_service_adm_id', 'ord_ware_id', 'ware_name','ord_zero_price','ord_pay_state', 'ord_source', 'ord_other_system_number', 'orcl_cus_msg', 'ord_other_payway', 'ord_payment_money', 'ord_banlance','orcl_province','orcl_city','orcl_county','orcl_address', 'ord_points','ord_add_type', 'ord_new_type', 'ord_openbill', 'ord_openbill_number', 'ord_openbill_image')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在1', 'data'=>''];
        }
        $info->ord_new_type_name = DB::table('order_type')
            ->where('orty_id', $info->ord_new_type)
            ->value('orty_name');
        // 实付金额等于 订单金额减去抹零金额，实际上应该和ord_actual_price 相等，但是还是在算一下吧；
        $info->pay_price = $info->ord_order_price-$info->ord_zero_price;
        // 优惠金额等于抹零金额
        $info->discount_price = $info->ord_zero_price;
        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods as orgo')
            ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_quantity as orgo_goo_quantitys', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_ord_id', 'orgo_goo_unit', 'orgo_goo_unta_id', 'goo_unit_conversion', 'orgo_goo_amount','orgo_goo_return_quantity')
            ->get()->toArray();
        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->orcl_sales_adm_id;
        $adm_id[] = $info->ord_service_adm_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        // 查询账号id对应手机号
        $adm_phone = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_phone', 'adm_id')
            ->toArray();
        $info->create_name = '';
        if ($info->ord_create_id != '0' && isset($adm_name[$info->ord_create_id])) {
            $info->create_name = $adm_name[$info->ord_create_id]; //创建人
        }
        if ($info->ord_service_adm_id != '0' && isset($adm_name[$info->ord_service_adm_id])) {
            $info->ord_service_adm_name = $adm_name[$info->ord_service_adm_id]; //技师
        } else {
            $info->ord_service_adm_name = '';
        }
        if ($info->ord_payment_way == 5) {
            $info->myvi_name = DB::table('vip_card_record as vcre')
                ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vcre.vcre_myvi_id')
                ->where('vcre_ord_id', $info->ord_id)
                ->value('myvi_name');
        } else {
            $info->myvi_name = '';
        }
        if($info->ord_wor_state == 7 && $info->ord_source == 5){
            $info->orcl_carowner_phone = substr_replace($info->orcl_carowner_phone,'****',3,4);
            $info->orcl_carowner_name = mb_substr($info->orcl_carowner_name,0,1,'utf-8').str_repeat("*",(strlen($info->orcl_carowner_name)/2-1));
            $info->orcl_name = mb_substr($info->orcl_name,0,1,'utf-8').str_repeat("*",(strlen($info->orcl_name)/2-1));
            $info->orcl_phone = substr_replace($info->orcl_phone,'****',3,4);
        }
        $all_status = self::getStatsName(true);
        $status_name = $all_status[$info->ord_wor_state]??'';
        if($info->ord_wor_state == 2 && $info->orcl_appoint_time == '0000-00-00 00:00:00'){$status_name = '未预约';}
        $info->ord_wor_state_name = $status_name;
        $order = new OrderEnum();
        // 获取枚举数据
        $object_enum = new OrderEnum();
        $ord_source_enum = $object_enum->keyValueEnum($object_enum->ord_source_enum);
        $info->ord_source_show = $ord_source_enum[$info->ord_source];

        // 施工地址
        if ($info->ord_address_type == 1) {//门店
            $find_address = DB::table('shop')
                ->where('shop_id', $info->ord_address_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            if ($find_address) {
                $info->shop_store_name = $find_address->shop_store_name;
                $info->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
            }
        } elseif ($info->ord_address_type == 2) {
            $find_address = DB::table('business_client')
                ->where('bucl_id', $info->ord_address_id)
                ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                ->first();
            if ($find_address) {
                $info->shop_store_name = $find_address->bucl_name;
                $info->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
            }
        } else {
            $find_address = DB::table('shop')
                ->where('shop_id', $info->ord_shop_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            if ($find_address) {
                $info->shop_store_name = $find_address->shop_store_name;
                $info->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
            }
        }

        // 预约时间
        if ($info->orcl_appoint_time == '0000-00-00 00:00:00') {
            $info->orcl_appoint_time = '';
        }
        // 销售人员
        $info->orcl_sales_adm_name = '';
        if ($info->orcl_sales_adm_id && isset($adm_name[$info->orcl_sales_adm_id])) {
            $info->orcl_sales_adm_name = $adm_name[$info->orcl_sales_adm_id]; //接车人
            $info->orcl_sales_adm_phone = $adm_phone[$info->orcl_sales_adm_id]; //接车人电话
        }
        unset($info->ord_create_id);
//        unset($info->orcl_sales_adm_id);
        $find_sepr_data = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->where('orgo_goo_type', 2)
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name')
            ->get()->toArray();
        $sepr_id = array_column($find_sepr_data, 'orgo_goo_id');
        // 查询服务项目图片
        $find_sepr = DB::table('service_project')
            ->whereIn('sepr_id', $sepr_id)
            ->pluck('sepr_img', 'sepr_id')->toArray();
        foreach ($goods_data as $key => $value) {
            if ($value->orgo_goo_type == 2) {
                // 服务项目图片路径
                if (isset($find_sepr[$value->orgo_goo_id]) && !empty($find_sepr[$value->orgo_goo_id])) {
                    $goods_data[$key]->goo_image = $find_sepr[$value->orgo_goo_id];
                } else {
                    $goods_data[$key]->goo_image = 'image/xmc/xx_icon.png'; //显示图片
                }
                if (!empty($goods_data[$key]->goo_image)) {
                    $goods_data[$key]->goo_image = addHttpurl($goods_data[$key]->goo_image);
                }
            }
            $goods_data[$key]->orgo_goo_quantity = $value->orgo_goo_quantity.'个';
        }
        if ($info->ord_wor_state != 11) {
            $info->ord_remark = '';
        }
        if (!empty($info->orcl_signature_img)) {
            $info->orcl_signature_img = addHttpurl($info->orcl_signature_img);
        }
        if ($info->ord_source == 5) {
            $info->orcl_mem_source = '智配贴装';
        }
        $find_admin = DB::table('admin')
            ->leftjoin('role', 'adm_role', '=', 'rol_id')
            ->where('adm_id', $user_info->adm_id)
            ->select('rol_privilege_multiple')
            ->first();
        $order_pic = [];
        $getorderpic = self::getorderpic($user_info, $request['ord_id']);
        if (!empty($getorderpic['data'])) {
            $order_pic = $getorderpic['data'];
        }
        $ord_Explainpic = [];
        $Explainpic = self::getExplainpic($user_info, $request['ord_id']);
        if (!empty($Explainpic['data'])) {
            $ord_Explainpic = $Explainpic['data'];
        }
        $info->ord_explain_pic = $ord_Explainpic;
        $typeName = self::getPaymentWayName(true);//获取支付方式名称
        $info->ord_payment_name = self::getTypeData($info->ord_payment_way, $typeName);
        if (!empty($info->ord_other_payway)) {
            $info->ord_other_paywayname = self::getTypeData($info->ord_other_payway, $typeName);
        } else {
            $info->ord_other_paywayname = '';
        }
//        if ($info->ord_payment_way == 9) {
        $find_order_detail = DB::table('order_settlement_details')
            ->leftJoin('admin', 'orsd_create_id', '=', 'adm_id')
            ->where('orsd_ord_id', $request['ord_id'])
            ->where('orsd_payment_way','!=', 0)
            ->select('orsd_payment_way', 'orsd_pay_money', 'orsd_payment_way_name', 'orsd_create_time', 'orsd_mem_id', 'adm_name')
            ->get()->toArray();
//        } else {
//            $find_order_detail = [];
//        }
        // 智配贴装的备注
        $zptz_remarks = DB::table('zptz_remarks')
            ->where('orre_shop_id', $user_info->adm_shop_id)
            ->where('orre_ord_id', $request['ord_id'])
            ->select('orre_module', 'orre_content')
            ->orderby('orre_id', 'desc')
            ->get()->toArray();
        $info->outstanding_amount = $info->ord_order_price - $info->ord_actual_price - $info->ord_banlance-$info->ord_zero_price;//欠收金额
        $info->settled_amount  = $info->ord_actual_price + $info->ord_banlance;//欠收金额
        $data['ord_payment_name'] = $typeName;
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['zptz_remarks'] = $zptz_remarks;
        $data['order_pic'] = $order_pic;
        $data['find_order_detail'] = $find_order_detail;
        $dispatch_delivery['dego_id'] = DB::table('dispatch_bill')
            ->where('dego_original_number', $info->ord_order_number)
            ->where('dego_type','<>', 3)
            ->value('dego_id');
        $wor_number = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->value('wor_number');
        if($wor_number){
            $dispatch_delivery['dego_id'] = DB::table('dispatch_bill')
                ->where('dego_original_number', $wor_number)
                ->where('dego_type','<>', 3)
                ->value('dego_id');
        }
        $find_order_cancel = DB::table('cancel_order_data')
            ->where('ord_id', $request['ord_id'])
            ->orderBy('id', 'desc')
            ->get();
        $data['find_order_cancel'] = $find_order_cancel?$find_order_cancel:[];
        $data['delivedry'] = DeliveryService::deliveryList($user_info,$dispatch_delivery)['data'];//快递信息
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**|---------------------------------------------------------------------------------
     * @name 获取结算方式名称
     * @param string $type 请求类型
     * @retrun /multitype:array
     * @author li 2023-07-18 031 上午 11:31:42
     * |---------------------------------------------------------------------------------
     */
    public static function getPaymentWayName($type=false){
        $user_info = LoginUserService::getUser();
        // 结算方式1.现金2.支付宝 3微信 4银行卡5会员卡
        $data = [['type'=>0,'name'=>'暂不结算'],['type'=>1,'name'=>'现金'],['type'=>2,'name'=>'支付宝'],['type'=>3,'name'=>'微信'],['type'=>4,'name'=>'银行卡'],['type'=>8,'name'=>'账期'],['type'=>9,'name'=>'部分结款']];
        if($type){
            $data = array_column($data, 'name','type');
        }
        return $data;
    }

    /**|---------------------------------------------------------------------------------
     * @name 列表页
     * @param string $type 服务类型数据
     * @param string $typeName 服务类型数据
     * @retrun /multitype:array
     * @author dou 2023-05-31 031 上午 11:47:59
     * |---------------------------------------------------------------------------------
     */
    public static function getTypeData ( $type , $typeName ){
        $typeData = trim($type);
        $typeData = explode(',', $typeData);
        $return = [];

        foreach($typeData as $k => $v){
            $return[] = $typeName[$v]??'未定义';
        }
        $return = implode(',', $return);
        return $return;
    }

    // 用户小程序-预约单详情
    public static function reinfo($user_info, $request)
    {
        // 查询账号信息
        $find_admin = DB::table('admin as adm')
            ->leftjoin('role', 'role.rol_id', '=', 'adm.adm_role')
            ->where('adm_id', $user_info->adm_id)
            ->select('rol_privilege_multiple')
            ->first();
        $pri = $find_admin->rol_privilege_multiple;
        $pri_data = json_decode($pri, true);
        $applet = $pri_data['applet'];
        $info = DB::table('wash_reservation_list as reli')
            ->leftJoin('wash_reservation_client as recl', 'recl.recl_reli_id', '=', 'reli.reli_id')
            ->leftJoin('wash_reservation_items as reit', 'reit.reit_reli_id', '=', 'reli.reli_id')
            ->leftJoin('shop as c', 'c.shop_id', '=', 'reli.reli_shop_id')
            ->where('reli_id', $request['reli_id'])
            ->select('reli_id', 'shop_store_name', 'reli_number', 'reli_order_number', 'reli_state', 'reli_appoint_time_slot', 'reli_appoint_time', 'reli_appoint_remark', 'reli_remark', 'reit_sepr_name', 'reli_create_time', 'recl_name', 'recl_phone', 'recl_car_num', 'recl_province', 'recl_city', 'recl_county', 'recl_address', 'reit_sepr_id', 'reli_ord_id', 'reit_sepr_id', 'reit_sepr_name', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'recl_car_brand_series', 'recl_car_vin', 'recl_ower_name', 'recl_ower_phone', 'reli_explain')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前预约单不存在', 'data'=>''];
        }

        // 预约时间
        if ($info->reli_appoint_time == '0000-00-00 00:00:00') {
            $info->reli_appoint_time = '';
        }

        // 查询服务项目图片
        $info->sepr_img = DB::table('service_project')
            ->where('sepr_id', $info->reit_sepr_id)
            ->value('sepr_img');
        return ['code'=>200, 'msg'=>'success', 'data'=>$info];
    }

    // 合作商订单详情
    public static function BusOrderinfo($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->leftJoin('shop as c', 'ord.ord_shop_id', '=', 'c.shop_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_vehicle_type', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'orcl_signature_img', 'shop_store_name', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_carowner_phone', 'orcl_carowner_name', 'orcl_carbrse_type')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_amount')
            ->get()->toArray();

        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $find_adm = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->select('adm_name', 'adm_phone', 'adm_id')
            ->get()->toArray();
        $find_adm = array_column($find_adm, null, 'adm_id');

        $info->create_name = '';
        if (!empty($info->ord_create_id)) {
            $info->create_name = $find_adm[$info->ord_create_id]->adm_name; //创建人
        }
        unset($info->ord_create_id);

        // 查询工单完成时间
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->pluck('wor_achieve_time', 'wor_order_id')->toArray();

        // 技师完成时间
        if (isset($find_wor_data[$request['ord_id']]) && $find_wor_data[$request['ord_id']] != '0000-00-00 00:00:00') {
            $info->wor_achieve_time = $find_wor_data[$request['ord_id']];
        } else {
            $info->wor_achieve_time = '';
        }
        // 预约时间
        if ($info->orcl_appoint_time == '0000-00-00 00:00:00') {
            $info->orcl_appoint_time = '';
        }
        // 订单作品
        if ($info->ord_wor_state >= 4) {
            $info->order_works = DB::table('order_works')
                ->where('orwo_ord_id', $request['ord_id'])
                ->where('orwo_delete', 2)
                ->select('orwo_title', 'orwo_type', 'orwo_description', 'orwo_data')
                ->get()->toArray();
        }

        foreach ($goods_data as $key => $value) {
            // 服务项目图片路径
            if ($value->orgo_goo_type == 2) {
                $goods_data[$key]->goo_image = DB::table('service_project')
                    ->where('sepr_id', $value->orgo_goo_id)
                    ->value('sepr_img');
            } else {
                $goods_data[$key]->goo_image = ''; //显示图片
            }
        }

        // 查看工单技师施工检测信息
        $technician_part = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'a.wotp_wor_id', 'b.wor_id')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_part', 'wotp_service_quality', 'wotp_service_data', 'wotp_service_qualitytesting', 'wotp_rewards_punishment')
            ->get()->toArray();

        // 查询验车信息
        $validate_car_data = DB::table('wash_order_validate_car')
            ->where('orvc_ord_id', $request['ord_id'])
            ->select('orvc_mileage', 'orvc_film_roll_number', 'orvc_car_interior', 'orvc_car_exterior')
            ->first();
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['technician_part'] = $technician_part;
        $data['validate_car_data'] = $validate_car_data;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 用户小程序-详情
    public static function washInfo($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->leftJoin('shop as c', 'ord.ord_shop_id', '=', 'c.shop_id')
            ->where('ord_id', $request['ord_id'])
            // ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_car_brand_series', 'orcl_signature_img', 'shop_store_name', 'shop_province', 'shop_city', 'shop_county', 'shop_address', 'orcl_carowner_phone', 'orcl_carowner_name', 'ord_address_type', 'ord_address_id', 'ord_shop_id', 'orcl_carbrse_type','ord_source','ord_zero_price','ord_service_type','ord_settlement_time', 'ord_points', 'ord_add_type')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }

        if ($info->ord_payment_way == 9) {
            $find_order_detail = DB::table('order_settlement_details')
                ->leftJoin('admin', 'orsd_create_id', '=', 'adm_id')
                ->where('orsd_ord_id', $request['ord_id'])
                ->where('orsd_payment_way','!=', 0)
                ->select('orsd_payment_way', 'orsd_pay_money', 'orsd_payment_way_name', 'orsd_create_time', 'orsd_mem_id', 'adm_name')
                ->get()->toArray();
        } else {
            $find_order_detail = [];
        }
        $info->find_order_detail = $find_order_detail;

        // 实付金额等于 订单金额减去抹零金额，实际上应该和ord_actual_price 相等，但是还是在算一下吧；
        $info->pay_price=$info->ord_order_price-$info->ord_zero_price;
        // 优惠金额等于抹零金额
        $info->discount_price=$info->ord_zero_price;
        if ($info->ord_payment_way == 5) {
            $info->myvi_name = DB::table('vip_card_record as vcre')
                ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vcre.vcre_myvi_id')
                ->where('vcre_ord_id', $info->ord_id)
                ->value('myvi_name');
        } else {
            $info->myvi_name = '';
        }

        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_amount', 'orgo_pogg_id')
            ->get()->toArray();

        $is_orgo_type=1;
        foreach ($goods_data as $k => $v) {
            if($v->orgo_goo_type == 3){
                $is_orgo_type=2;
            }
        }

        if($is_orgo_type == 2){
            foreach ($goods_data as $key => $val) {
                if($val->orgo_goo_type != 3){
                    unset($goods_data[$key]);
                }
            }
            sort($goods_data);
        }
        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $find_adm = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->select('adm_name', 'adm_phone', 'adm_id')
            ->get()->toArray();
        $find_adm = array_column($find_adm, null, 'adm_id');

        $info->create_name = '';
        if (!empty($info->ord_create_id)) {
            $info->create_name = $find_adm[$info->ord_create_id]->adm_name; //创建人
        }
        // 施工地址
        if ($info->ord_address_type == 1) {//门店
            $find_address = DB::table('shop')
                ->where('shop_id', $info->ord_address_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            $info->shop_store_name = $find_address->shop_store_name;
            $info->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
        } elseif ($info->ord_address_type == 2) {
            $find_address = DB::table('business_client')
                ->where('bucl_id', $info->ord_address_id)
                ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                ->first();
            $info->shop_store_name = $find_address->bucl_name;
            $info->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
        } else {
            $find_address = DB::table('shop')
                ->where('shop_id', $info->ord_shop_id)
                ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                ->first();
            $info->shop_store_name = $find_address->shop_store_name;
            $info->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
        }
        unset($info->ord_create_id);
        unset($info->orcl_pick_up_car_adm_id);

        // 查询工单完成时间
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->pluck('wor_achieve_time', 'wor_order_id')->toArray();

        // 技师完成时间
        if (isset($find_wor_data[$request['ord_id']]) && $find_wor_data[$request['ord_id']] != '0000-00-00 00:00:00') {
            $info->wor_achieve_time = $find_wor_data[$request['ord_id']];
        } else {
            $info->wor_achieve_time = '';
        }
        // 预约时间
        if ($info->orcl_appoint_time == '0000-00-00 00:00:00') {
            $info->orcl_appoint_time = '';
        }
        // 接车时间
        if ($info->orcl_pick_up_car_time == '0000-00-00 00:00:00') {
            $info->orcl_pick_up_car_time = '';
        }
        // 订单作品
        if ($info->ord_wor_state >= 4) {
            $info->order_works = DB::table('order_works')
                ->where('orwo_ord_id', $request['ord_id'])
                ->where('orwo_delete', 2)
                ->select('orwo_title', 'orwo_type', 'orwo_description', 'orwo_data')
                ->get()->toArray();
        }

        foreach ($goods_data as $key => $value) {
            // 服务项目图片路径
            if ($value->orgo_goo_type == 2) {
                $goods_data[$key]->goo_image = DB::table('service_project')
                    ->where('sepr_id', $value->orgo_goo_id)
                    ->value('sepr_img');
            } elseif($value->orgo_goo_type == 1){
                $goods_data[$key]->goo_image = DB::table('goods')
                    ->where('goo_id', $value->orgo_goo_id)
                    ->value('goo_pic');
                if (empty($goods_data[$key]->goo_image)) {
                    $goods_data[$key]->goo_image = config('apisystem.server_name_https').'/storage/image/default_goo_img.png';
                }
            } elseif($value->orgo_goo_type == 3){
                $pic_jsonstr = DB::table('package_items')
                    ->where('pait_id', $value->orgo_goo_id)
                    ->value('pait_pic');
                if(!empty($pic_jsonstr)){
                    $pic_arr=json_decode($pic_jsonstr,true);
                    if(is_array($pic_arr) && isset($pic_arr[0])){
                        $goods_data[$key]->goo_image=$pic_arr[0];
                    }
                }
            } elseif($value->orgo_goo_type == 4){//会员卡
                if (empty($goods_data[$key]->goo_image)) {
                    $goods_data[$key]->goo_image = config('apisystem.server_name_https').'/image/customerImg/vip_pic_none.png';
                }
            } else {
                $goods_data[$key]->goo_image = ''; //显示图片
            }
            //积分商品设置了图片使用设置的
            if($value->orgo_pogg_id){
                $pogg_pic_ret = DB::table('point_gift_goods')
                    ->where('pogg_id', $value->orgo_pogg_id)
                    ->value('pogg_pic');
                if($pogg_pic_ret){
                    $pogg_pic = json_decode($pogg_pic_ret,true);
                    if(isset($pogg_pic[0])){
                        $goods_data[$key]->goo_image = $pogg_pic[0];
                    }
                }
            }
            if (empty($goods_data[$key]->goo_image)) {
                $goods_data[$key]->goo_image=config("apisystem.server_name").'/image/customer/NoPic.jpg';
            }
            if($goods_data[$key]->goo_image != '' && substr($goods_data[$key]->goo_image,0,4)!='http'){
                ltrim($goods_data[$key]->goo_image,'/');
                $goods_data[$key]->goo_image=config("apisystem.server_name")."/".$goods_data[$key]->goo_image;
            }
        }

        $typeName = self::getPaymentWayName(true);//获取支付方式名称
        $info->ord_payment_name = self::getTypeData($info->ord_payment_way, $typeName);
        $work_order_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_list_pic', 'wor_id')
            ->first();
        if ($work_order_data && $work_order_data->wor_list_pic == 1) {
            $work_pic = DB::table('completion_info')
                ->where('coin_wor_id', $work_order_data->wor_id)
                ->whereIn('coin_type', [2,3])
                ->get()->toArray();
        } else {
            $work_pic = [];
        }
        // 查看工单技师施工检测信息
        $technician_part = DB::table('wash_work_technician_part as a')
            ->leftJoin('work_order as b', 'a.wotp_wor_id', 'b.wor_id')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wotp_id', 'wotp_service_adm_id', 'wotp_grle_id', 'wotp_grle_name', 'wotp_grpr_id', 'wotp_grpr_name', 'wotp_service_adm_name', 'wotp_service_adm_phone', 'wotp_service_part', 'wotp_service_quality', 'wotp_service_data', 'wotp_service_qualitytesting', 'wotp_rewards_punishment')
            ->get()->toArray();
        $validate_car_data = self::validateCarData($user_info,$request);
        $data['order_data'] = $info;
        $data['goods_data'] = $goods_data;
        $data['work_pic'] = $work_pic;
        $data['technician_part'] = $technician_part;
        $data['validate_car_data'] = $validate_car_data['data'];
        // $data['checkcar_supplement'] = $checkcar_supplement;

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 微信用户小程序-签字图片提交
    public static function signatureSubmit($user_info, $request)
    {
        $info = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_order_number', 'orcl_check_car_state', 'orcl_signature_img')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'当前订单不存在', 'data'=>''];
        }
        if ($info->orcl_check_car_state == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单尚未验车', 'data'=>''];
        }
        if (empty($info->orcl_signature_img)) {
            if (substr($request['img_path'], 0, 4) == 'http') {
                $data['orcl_signature_img'] = addHttpurl($request['img_path']);
            } else {
                $data['orcl_signature_img'] = $request['img_path'];
            }
        }
        $data['orcl_check_car_state'] = 3; //是否验车：1是、已验车2否、未验车3客户已签字4补充验车
        $data['orcl_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($data);
        if ($info->orcl_check_car_state == 4) {
            $update_data['chsu_sign'] = $request['img_path'];
            $update_data['chsu_update_time'] = date('Y-m-d H:i:s');
            $checkcar_supplement_res = DB::table('checkcar_supplement')
                ->where('chsu_ord_id', $request['ord_id'])
                ->where('chsu_sign', '')
                ->update($update_data);
        } else {
            $checkcar_supplement_res = true;
        }
        if ($res && $checkcar_supplement_res) {
            return ['code'=>200, 'msg'=>'签字成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'签字失败', 'data'=>'签字失败'];
        }
    }

    // 取消订单-半径服务
    public static function cancel($user_info, $request)
    {
        // $find_order = WashOrder::where('ord_id', $request['ord_id'])
        $find_order = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_order_number', 'ord_state', 'ord_delete', 'ord_wor_quantity', 'ord_wor_state', 'ord_service_type', 'ord_type', 'ord_client_id', 'ord_goods_quantity', 'ord_actual_price', 'ord_service_shop_id', 'ord_create_id', 'orcl_shipment_party', 'ord_ware_id', 'ord_create_time', 'ord_source', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_payment_way', 'ord_order_price', 'orcl_phone', 'orcl_name', 'ord_other_payway')
            ->first();
        // $find_order = DB::table('order')->where('ord_id', $request['ord_id'])
        //     ->where('ord_shop_id', $user_info->adm_shop_id)
        //     ->select('ord_order_number', 'ord_state', 'ord_delete', 'ord_wor_quantity', 'ord_wor_state', 'ord_service_type', 'ord_create_time', 'ord_ware_id', 'orcl_shipment_party')
        //     ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单不存在！', 'data'=>''];
        }
        // if ($find_order->ord_state != 1) {
        //     return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已结算，无法取消！', 'data'=>''];
        // }
        if ($find_order->ord_delete == 2) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已经取消！', 'data'=>''];
        }

        // 查询出该订单下所有的工单
        // $find_work = DB::table('work_order')
        //     ->where('wor_order_id', $request['ord_id'])
        //     ->select('wor_delete', 'wor_id')
        //     ->get();
        // // 验证当前订单下工单是否已经全部取消
        // foreach ($find_work as $key => $value) {
        //     if ($value->wor_delete == 1) {
        //         return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单存在未取消的工单', 'data'=>''];
        //     }
        // }
        $all_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_delete', 'wor_id')
            ->get();
        $work_order = new WorkOrders();
        foreach ($all_work as $key => $value) {
            $find_work1 = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $value->wor_id)
                ->where('wor_shop_id', $user_info->adm_shop_id)
                ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_goo_amount', 'wor_type', 'wor_actual_price', 'wor_ware_id', 'wor_remark', 'wor_pass', 'wor_service_type', 'wor_type', 'wocl_client_id', 'wocl_sd_virtual_type', 'wocl_wor_type', 'wor_order_number', 'wor_delete')
                ->first();
            if ($value->wor_delete == 1) {
                $request['wor_id'] = $value->wor_id;
                $return_data = $work_order->deletes($user_info, $request, $find_work1);
                if ($return_data['code'] != 200) {
                    return $return_data;
                }
            }
            $wotp_res = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $request['wor_id'])
                ->delete();
        }
        $now_time = date('Y-m-d H:i:s');

        $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
        $ord_data['ord_suspended'] = 2; //结算方式
        $ord_data['ord_payment_way'] = 0; //结算方式
        $ord_data['ord_actual_price'] = 0; //结算金额
        $ord_data['ord_zero_price'] = 0; //优惠金额
        $ord_data['ord_settlement_time'] = ''; //结算时间
        $ord_data['ord_state'] = 1; //结算状态1未结算2已结算
        $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中4已完成7待接单11取消订单
        $ord_data['ord_update_time'] = $now_time;
        $ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_data);

        //计算会员消费总金额
        if($find_order->ord_type == 1 && $find_order->ord_client_id > 0){
            $a = WashOrderService::consume_money($find_order->ord_client_id);
        }

        if ($find_order->ord_source == 2) {
            $goods_id = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->where('orgo_goo_type', 3)
                ->value('orgo_goo_id');
            $find_pait = DB::table('package_items')
                ->where('pait_id', $goods_id)
                ->select('pait_sell_number', 'pait_id', 'pait_saleable_quantity')
                ->first();
            if ($find_pait) {
                $update_data['pait_saleable_quantity'] = $find_pait->pait_saleable_quantity + 1;
                $update_data['pait_sell_number'] = $find_pait->pait_sell_number - 1;
                $update_data['pait_update_time'] = date('Y-m-d H:i:s');
                $update_res = DB::table('package_items')->where('pait_id', $goods_id)->update($update_data);
            } else {
                return ['code'=>500, 'msg'=>'取消订单失败', 'data'=>'取消订单失败'];
            }
        } else {
            $update_res = true;
        }

        // 删除应收应付
        $request['recpay_order_state'] = 3;//取消应收应付
        $request['recpay_original_id'] = $request['ord_id'];
        $request['recpay_original_number'] = $find_order->ord_order_number;
        $result1 = ReceivablePayService::edit($request);  
        if ($find_order->ord_payment_way == 5) {
            $find_vcre_data = DB::table('vip_card_record as vcre')
                ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vcre.vcre_myvi_id')
                ->where('vcre_ord_id', $request['ord_id'])
                ->select('vcre_myvi_id', 'myvi_surplus_times', 'myvi_id', 'vcre_id', 'myvi_adm_id', 'myvi_num', 'myvi_state')
                ->first();
            if ($find_vcre_data) {
                // CommonService::startmysql();
                $vipca_record_datail = DB::table('vipca_record_datail')
                    ->leftJoin('myvip_detail', 'myvid_id', '=', 'vcrd_myvid_id')
                    ->where('vcrd_vcre_id', $find_vcre_data->vcre_id)
                    // ->select('vcrd_myvid_id', 'vcrd_num', 'myvid_surplus_times','myvid_mvid')
                    ->get()->toArray();
                // $sql = CommonService::showmysql();
                $myvi_surplus_times = 0;
                foreach ($vipca_record_datail as $key => $value) {
                    $myvi_surplus_times += $value->vcrd_num;
                    $update_myvip_detail_data['myvid_surplus_times'] = $value->myvid_surplus_times + $value->vcrd_num;
                    $update_myvip_detail_data['myvid_update_time'] = date('Y-m-d H:i:s');
                    $update_myvi_res = DB::table('myvip_detail')
                        ->where('myvid_id', $value->vcrd_myvid_id)
                        ->update($update_myvip_detail_data);
                }
                $update_myvi_data['myvi_surplus_times'] = $find_vcre_data->myvi_surplus_times + $myvi_surplus_times;
                $update_myvi_data['myvi_update_time'] = date('Y-m-d H:i:s');
                if ($find_vcre_data->myvi_state == 2) {
                    $update_myvi_data['myvi_state'] = 1;
                }
                $update_myvi_res = DB::table('myvip')
                    ->where('myvi_id', $find_vcre_data->myvi_id)
                    ->update($update_myvi_data);
                $update_vcre_data['vcre_delete'] = 1;
                $update_vcre_res = DB::table('vip_card_record')
                    ->where('vcre_id', $find_vcre_data->vcre_id)
                    ->update($update_vcre_data);
                $add_vip_record['vcre_myvi_id'] = $find_vcre_data->myvi_id;
                $add_vip_record['vcre_user_id'] = $find_vcre_data->myvi_adm_id;
                $add_vip_record['vcre_ord_num'] = $find_order->ord_order_number;
                $add_vip_record['vcre_ord_id'] = $request['ord_id'];
                $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
                $add_vip_record['vcre_car_adm_name'] = $find_order->orcl_carowner_name;
                $add_vip_record['vcre_car_adm_phone'] = $find_order->orcl_carowner_phone;
                $add_vip_record['vcre_myvi_num'] = $find_vcre_data->myvi_num;
                $add_vip_record['vcre_log'] = 2;//1结算2取消结算
                $add_vip_record['vcre_num_change'] = '+'.$myvi_surplus_times.'/余'.($find_vcre_data->myvi_surplus_times + $myvi_surplus_times).'';
                $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);
                foreach ($vipca_record_datail as $key => $value) {
                    $add_vcrd_data['vcrd_vcre_id'] = $add_vire_res;
                    $add_vcrd_data['vcrd_myvid_id'] = $value->vcrd_myvid_id;
                    $add_vcrd_data['vcrd_num'] = $value->vcrd_num;
                    $add_vcrd_data['vcrd_description'] = '+'.$value->vcrd_num.'/余'.($value->myvid_surplus_times+$value->vcrd_num);
                    $add_vcrd_data['vcrd_create_time'] = date('Y-m-d H:i:s');
                    $add_vcrd_data['vcrd_create_id'] = $user_info->adm_id;
                    $add_vcre_res = DB::table('vipca_record_datail')->insertGetId($add_vcrd_data);
                }
                // vipca_record_datail
            } else {
                $update_myvi_res = true;
                $update_vcre_res = true;
            }
        }
        // if ($find_order->ord_service_type == 2) {//洗车的订单需要还回洗车次数
        //     $find_vcre_data = DB::table('vip_card_record as vcre')
        //         ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vcre.vcre_myvi_id')
        //         ->where('vcre_ord_id', $request['ord_id'])
        //         ->select('vcre_myvi_id', 'myvi_surplus_times', 'myvi_id', 'vcre_id', 'myvi_adm_id', 'myvi_num')
        //         ->first();
        //     if ($find_vcre_data) {
        //         $update_myvi_data['myvi_surplus_times'] = $find_vcre_data->myvi_surplus_times + 1;
        //         $update_myvi_data['myvi_update_time'] = date('Y-m-d H:i:s');
        //         $update_myvi_res = DB::table('myvip')
        //             ->where('myvi_id', $find_vcre_data->myvi_id)
        //             ->update($update_myvi_data);
        //         $update_vcre_data['vcre_delete'] = 1;
        //         $update_vcre_res = DB::table('vip_card_record')
        //             ->where('vcre_id', $find_vcre_data->vcre_id)
        //             ->update($update_vcre_data);
        //         $add_vip_record['vcre_myvi_id'] = $find_vcre_data->myvi_id;
        //         $add_vip_record['vcre_user_id'] = $find_vcre_data->myvi_adm_id;
        //         $add_vip_record['vcre_ord_num'] = $find_order->ord_order_number;
        //         $add_vip_record['vcre_ord_id'] = $request['ord_id'];
        //         $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
        //         $add_vip_record['vcre_car_adm_name'] = $find_order->orcl_carowner_name;
        //         $add_vip_record['vcre_car_adm_phone'] = $find_order->orcl_carowner_phone;
        //         $add_vip_record['vcre_myvi_num'] = $find_vcre_data->myvi_num;
        //         $add_vip_record['vcre_log'] = 2;//1结算2取消结算
        //         $add_vip_record['vcre_num_change'] = '+1（剩余：'.($find_vcre_data->myvi_surplus_times + 1).'次）';
        //         $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);
        //         vipca_record_datail
        //     } else {
        //         $update_myvi_res = true;
        //         $update_vcre_res = true;
        //     }
        // }
        // 更新订单商品表时间
        $edit_orgo_data['orgo_update_time'] = $now_time;
        if (!empty($orgo_id)) {
            $edit_orgo_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->update($edit_orgo_data);
        } else {
            $edit_orgo_res = true;
        }
        // 微信退款
        $weixin_record = DB::table('weixin_record')
            ->where('out_trade_no', $find_order->ord_order_number)
            ->where('were_pay_type', 1)
            ->select('out_trade_no', 'were_sp_appid', 'were_sp_mchid', 'were_pay_total_money', 'were_pay_type', 'were_sub_appid', 'were_sub_mchid', 'were_pay_state', 'were_transaction_id', 'were_sub_ledger')
            ->first();
        if ($weixin_record) {
            $sub_mchid = $weixin_record->were_sub_mchid;
            $out_refund_no = 'TK'.time().rand(10000,99999);
            $transaction_id = $weixin_record->were_transaction_id;
            $out_trade_no = $weixin_record->out_trade_no;
            $refund_fee = $weixin_record->were_pay_total_money;
            $total_fee = $weixin_record->were_pay_total_money;
            $notify_url = config('apisystem.server_name_https').'/index.php/api/u1/Pay/refoundnotifyPay';
            $reason = $request['remark'];
            $sign = 'xcx';
            $refund_res = WashPayservice::applyRefund($sub_mchid, $out_refund_no, $transaction_id, $out_trade_no, $refund_fee, $total_fee, $notify_url, $reason, $sign);
            $refund_data = json_decode($refund_res, true);
            if (isset($refund_data['refund_id']) && !empty($refund_data['refund_id'])) {
                $add_weixin_data['were_shop_id'] = $user_info->adm_shop_id;
                $add_weixin_data['out_trade_no'] = $user_info->adm_shop_id;
                $add_weixin_data['were_sp_appid'] = $user_info->adm_shop_id;
                $add_weixin_data['were_sp_mchid'] = $user_info->adm_shop_id;
                $add_weixin_data['were_pay_total_money'] = $user_info->adm_shop_id;
                $add_weixin_data['were_pay_type'] = 2;
                $add_weixin_data['were_create_time'] = date('Y-m-d H:i:s');
                $refund_data_res = true;
            } else {
                $refund_data_res = false;
            }
        }
        // // 取消订单
        // $order_res = Order::cancel(
        //     $user_info,
        //     $request,
        //     $find_order,
        //     1
        // );
        // $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
        // $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单6审核活动7待接单8锁定9速电撤销回收10终止11取消订单
        // $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
        // // $ord_res = WashOrder::where('ord_id', $request['ord_id'])->update($ord_data);
        // $ord_res = DB::table('order')->where('ord_id', $request['ord_id'])->update($ord_data);
        if ($find_order->ord_payment_way == 6 || $find_order->ord_payment_way == 7 || ($find_order->ord_payment_way == 5 & ($find_order->ord_other_payway == 6 || $find_order->ord_other_payway == 7))) {
            //使用余额支付退回余额
            $find_rec_log = DB::table('rec_log')
                ->where('relo_ord_id', $request['ord_id'])
                ->select('relo_rec_num', 'relo_gift_num', 'relo_mem_id', 'relo_type')
                ->get()->toArray();
            $relo_rec_num = 0;
            $relo_gift_num = 0;
            $relo_mem_id = 0;
            foreach ($find_rec_log as $key => $value) {
                if ($value->relo_type == 2) {
                    $relo_rec_num += $value->relo_rec_num;
                    $relo_gift_num += $value->relo_gift_num;
                }
                if ($value->relo_type == 4) {
                    $relo_rec_num -= $value->relo_rec_num;
                    $relo_gift_num -= $value->relo_gift_num;
                }
                $relo_mem_id = $value->relo_mem_id;
            }
            if ($find_rec_log) {
                if ($find_order->ord_type == 1) {
                    $find_mem = DB::table('member')
                        ->where('mem_id', $relo_mem_id)
                        ->select('mem_rec_banlance', 'mem_gift_banlance')
                        ->first();

                    $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance + $relo_rec_num;
                    $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance + $relo_gift_num;
                    $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
                    $update_mem_res = DB::table('member')
                        ->where('mem_id', $relo_mem_id)
                        ->update($update_mem);
                    // 消费记录
                    $add_rec_log['relo_type'] = 4;//取消订单退款
                    $add_rec_log['relo_rec_num'] = $relo_rec_num;
                    $add_rec_log['relo_gift_num'] = $relo_gift_num;
                    $add_rec_log['relo_mem_id'] = $relo_mem_id;
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '取消订单';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                } elseif ($find_order->ord_type == 2) {
                    $find_mem = DB::table('business_client')
                        ->where('bucl_id', $relo_mem_id)
                        ->select('bucl_rec_banlance', 'bucl_gift_banlance')
                        ->first();
                    $update_mem['bucl_rec_banlance'] = $find_mem->bucl_rec_banlance + $relo_rec_num;
                    $update_mem['bucl_gift_banlance'] = $find_mem->bucl_gift_banlance + $relo_gift_num;
                    $update_mem['bucl_update_time'] = date('Y-m-d H:i:s');
                    $update_mem_res = DB::table('business_client')
                        ->where('bucl_id', $relo_mem_id)
                        ->update($update_mem);
                    // 消费记录
                    $add_rec_log['relo_type'] = 4;//取消订单退款
                    $add_rec_log['relo_rec_num'] = $relo_rec_num;
                    $add_rec_log['relo_gift_num'] = $relo_gift_num;
                    $add_rec_log['relo_mem_id'] = $relo_mem_id;
                    $add_rec_log['relo_mem_type'] = 2;
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '取消订单';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
            }
        }
        if ($find_order->ord_state != 2 && $find_order->ord_type == 1) {//减少会员欠款金额
            $arrears = $find_order->ord_order_price - $find_order->ord_actual_price;
            $find_mem = DB::table('member')
                ->where('mem_id', $find_order->ord_client_id)
                ->select('mem_arrears')
                ->first();
            $new_update_mem['mem_arrears'] = $find_mem->mem_arrears - $arrears;
            $new_update_mem['mem_update_time'] = date('Y-m-d H:i:s');
            $update_mem_res = DB::table('member')
                ->where('mem_id', $find_order->ord_client_id)
                ->update($new_update_mem);
        }
        $red_pores = WashOrderBasicService::reducePoint($user_info,$find_order->ord_client_id,$request['ord_id']);
        $find_dis = DB::table('dispatch_bill')
            ->where('dego_order_type',1)
            ->where('dego_original_number', $find_order->ord_order_number)
            ->first();
        if ($find_dis) {
            $update_dis = DB::table('dispatch_bill')
                ->where('dego_order_type',1)
                ->where('dego_original_number', $find_order->ord_order_number)
                ->update(['dego_type'=>3]);
        }
        $find_work_dis = DB::table('dispatch_bill')
            ->leftJoin('work_order', 'wor_id', '=', 'dego_wor_id')
            ->where('dego_order_type', 2)
            ->where('wor_order_number', $find_order->ord_order_number)
            ->first();
        if ($find_work_dis) {
            $update_work_dis = DB::table('dispatch_bill')
                ->leftJoin('work_order', 'wor_id', '=', 'dego_wor_id')
                ->where('dego_order_type', 2)
                ->where('wor_order_number', $find_order->ord_order_number)
                ->update(['dego_type'=>3]);
        }
        $order_goods = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->where('orgo_goo_type', 1)
            ->get();
        if ($order_goods && $find_order->ord_ware_id) {
            $new_goods_data = [];
            foreach ($order_goods as $key => $value) {
                $new_goods_data[$key]['goo_id'] = $value->orgo_goo_id;
            }
            if (!empty($new_goods_data)) {
                $post_data['ware_id'] = $find_order->ord_ware_id;
                $post_data['new_goods_data'] = $new_goods_data;
                $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
            }
        }
        if ($ord_res && $update_res) {
            $data['ord_order_number'] = $find_order->ord_order_number;
            $data['orcl_name'] = $find_order->orcl_name;
            $data['orcl_phone'] = $find_order->orcl_phone;
            $wohi_data['wohi_primary_id'] = $request['ord_id'];
            $wohi_data['wohi_state_name'] = '已取消';
            $wohi_data['wohi_state'] = 6;
            $wohi_data['wohi_type'] = 1;
            addHistory($wohi_data);
            unset($wohi_data);
            return ['code'=>200, 'msg'=>'取消订单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'取消订单失败', 'data'=>'取消订单失败'];
        }
    }

    // 备注查询数据
    public static function remarkSearch($user_info, $request)
    {
        $number = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->value('ord_order_number');
        $wor_id = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->value('wor_id');
        $wor_id = $wor_id ? $wor_id : 0;
        $data['ord_order_number'] = $number;
        $data['wor_id'] = $wor_id;
        return $data;
    }

    // 预约设置
    public function appointmentSet($user_info, $request)
    {
        $find_order = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_order_number', 'ord_wor_state', 'ord_delete','orcl_appoint_time')
            ->first();
        if (empty($find_order)) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单不存在！', 'data'=>''];
        }
        if ($find_order->ord_delete != 1) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已经取消！', 'data'=>''];
        }
        if (!in_array($find_order->ord_wor_state, [1, 2, 5, 7])) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单已完成或终止！', 'data'=>''];
        }

        // 查询当前订单下是否有正常服务工单
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->where('wor_delete', 1)
            ->where('wor_state', '<>', 11)
            ->first(['wor_id', 'wor_state']);
        if ($find_wor_data && $find_wor_data->wor_state > 7) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'当前订单所属工单正在施工中，无法更改预约时间！', 'data'=>''];
        }

        $resenum_date=date('Y-m-d', strtotime($request['appoint_time']));

        $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date,$find_order->orcl_appoint_time,$request);

        if($jud_res['code'] != 200) return $jud_res;
        // 订单客户表更改预约时间、预约备注
        $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
        if (!empty($request['appoint_remark'])) {
            $orcl_edit['orcl_appoint_remark'] = $request['appoint_remark'];
        }
        $orcl_edit['orcl_update_time'] = date('Y-m-d H:i:s');
        $ord_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($orcl_edit);
        $new_ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update(['ord_new_type'=>$request['ord_new_type'],'ord_update_time'=>date('Y-m-d H:i:s')]);
        $plan_edit['wopl_ord_new_type'] = $request['ord_new_type'];
        $plan_edit['wopl_date'] = date('Y-m-d', strtotime($request['appoint_time']));
        $plan_edit['wopl_time'] = date('H:i:s', strtotime($request['appoint_time']));
        $plan_edit['wopl_update_time'] = date('Y-m-d H:i:s');
        $plan_res = DB::table('work_plan')
            ->where('wopl_ord_id', $request['ord_id'])
            ->update($plan_edit);
        $wor_id = 0; //工单id
        if ($find_wor_data) {
            $wor_id = $find_wor_data->wor_id; //工单id

            $wor_edit['wor_appoint_time'] = $request['appoint_time'];
            $wor_edit['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_edit_res = DB::table('work_order')
                ->where('wor_id', $find_wor_data->wor_id)
                ->update($wor_edit);
            if (!empty($request['appoint_remark'])) {
                $wocl_edit['wocl_appoint_remark'] = $request['appoint_remark'];
                $wocl_edit['wocl_update_time'] = date('Y-m-d H:i:s');
                $wocl_edit_res = DB::table('work_client')
                    ->where('wocl_wor_id', $find_wor_data->wor_id)
                    ->update($wocl_edit);
            } else {
                $wocl_edit_res = true;
            }
            // 判断是否更改成功
            if ($wor_edit_res && $wocl_edit_res) {
                $wor_res = true;
            } else {
                $wor_res = false;
            }
        } else {
            $wor_res = true;
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], $wor_id, '预约设置');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (!empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemark($user_info, $request['ord_id'], $wor_id, $remark_data, '订单列表-预约设置');

        if ($ord_res && $wor_res && $orlo_res && $orre_res) {
            $data['ord_order_number'] = $find_order->ord_order_number;
            return ['code'=>200, 'msg'=>'预约设置成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约设置失败', 'data'=>''];
        }
    }

    // 生成售后单
    public function afterSale($user_info, $request)
    {
        $return_data = $this::info($user_info, $request);
        if ($return_data['code'] != 200) {
            return $return_data;
        }

        $find_order_data = $return_data['data']['order_data'];
        $goods_data = $return_data['data']['goods_data'];
        if ($find_order_data->ord_wor_state == 3) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单存在售后单，无法生成售后单'];
        }
        if ($find_order_data->ord_wor_state == 11) {
            return ['code'=>ErrorInc::REQUEST_INAPTNESS, 'msg'=>'error', 'data'=>'当前订单已取消，无法生成售后单'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取售后单编号
        $afsl_number = Common::numberRule((object)$user_info, 6);
        $afsl_data['afsl_after_number'] = $afsl_number; //售后单号
        $afsl_data['afsl_cid'] = $user_info->adm_cid;
        $afsl_data['afsl_superior_shop_id'] = $shop_id;
        $afsl_data['afsl_shop_id'] = $user_info->adm_shop_id;
        $afsl_data['afsl_ord_id'] = $find_order_data->ord_id; //订单id
        $afsl_data['afsl_order_number'] = $find_order_data->ord_order_number; //订单号
        // $afsl_data['afsl_order_price'] = $find_order_data->ord_order_number;//订单号
        $afsl_data['afsl_actual_price'] = $find_order_data->ord_order_price; //订单金额
        $afsl_data['afsl_reservation_time'] = $find_order_data->orcl_appoint_time; //预约时间
        $afsl_data['afsl_client_type'] = $find_order_data->ord_type; //类型：1会员2客户单位
        $afsl_data['afsl_client_id'] = $find_order_data->orcl_client_id; //客户单位id，会员id
        $afsl_data['afsl_address_type'] = $find_order_data->ord_address_type; //地址类型
        $afsl_data['afsl_address_id'] = $find_order_data->ord_address_id; //地址id
        $afsl_data['afsl_address'] = $find_order_data->ord_address; //地址
        $afsl_data['afsl_business_name'] = $find_order_data->orcl_business_name; //企业名称
        $afsl_data['afsl_business_id'] = $find_order_data->orcl_business_id; //企业id
        if (!empty($request['remark'])) {
            $afsl_data['afsl_remark'] = $request['remark']; //售后备注
        }
        if (!empty($request['afsl_pic'])) {
            $afsl_data['afsl_pic'] = json_encode($request['afsl_pic'],true); //图片
        }
        $afsl_data['afsl_lab_id'] = $request['lab_id']; //标签
        $afsl_data['afsl_lab_name'] = $request['lab_name']; //标签名称
        $afsl_data['afsl_parts'] = json_encode($request['afsl_parts'], true) ; //施工部位

        $afsl_data['afsl_create_id'] = $user_info->adm_id; //用户id
        $afsl_id = DB::table('wash_after_sale_list')->insertGetId($afsl_data);

        // 售后单客户信息
        $afsc_data['afsc_shop_id'] = $user_info->adm_shop_id;
        $afsc_data['afsc_afsl_id'] = $afsl_id;
        $afsc_data['afsc_client_id'] = $find_order_data->orcl_client_id;
        $afsc_data['afsc_car_brand_series'] = $find_order_data->orcl_car_brand_series;
        $afsc_data['afsc_car_vin'] = $find_order_data->orcl_car_vin;
        // $afsc_data['afsc_channel_unit'] = $find_order_data->orcl_channel_unit;
        $afsc_data['afsc_name'] = $find_order_data->orcl_name;
        $afsc_data['afsc_phone'] = $find_order_data->orcl_phone;
        $afsc_data['afsc_carowner_name'] = $find_order_data->orcl_carowner_name;//车主姓名
        $afsc_data['afsc_carowner_phone'] = $find_order_data->orcl_carowner_phone;//车主电话
        $afsc_data['afsc_car_num'] = $find_order_data->orcl_car_num;
        // $afsc_data['afsc_province'] = $find_order_data->orcl_province;
        $afsc_id = DB::table('wash_after_sale_client')->insertGetId($afsc_data);

        $afsi_data = [];
        foreach ($goods_data as $key => $value) {
            $afsi_data[$key]['afsi_afsl_id'] = $afsl_id;
            $afsi_data[$key]['afsi_shop_id'] = $user_info->adm_shop_id;
            if (!empty($value->orgo_goo_id)) {
                $afsi_data[$key]['afsi_goo_price'] = $value->orgo_goo_price;
                $afsi_data[$key]['afsi_goo_quantity'] = $value->orgo_goo_quantitys;
                $afsi_data[$key]['afsi_goo_warranty_time'] = $value->orgo_goo_guarantee;
                $afsi_data[$key]['afsi_goo_id'] = !empty($value->orgo_goo_id)?$value->orgo_goo_id:'';
                $afsi_data[$key]['afsi_goo_name'] = !empty($value->orgo_goo_name)?$value->orgo_goo_name:'';
                $afsi_data[$key]['afsi_goo_goods_encode'] = !empty($value->orgo_goo_goods_encode)?$value->orgo_goo_goods_encode:'';
                $afsi_data[$key]['afsi_goo_type'] = $value->orgo_goo_type;
                $afsi_data[$key]['afsi_goo_unit'] = $value->orgo_goo_unit;
                $afsi_data[$key]['afsi_goo_unta_id'] = $value->orgo_goo_unta_id;
            }
        }
        $afsi_id = DB::table('wash_after_sale_items')->insert($afsi_data);

        
        if ($afsl_id && $afsc_id && $afsi_id) {
            $return_data['afsl_id'] = $afsl_id;
            $return_data['afsl_after_number'] = $afsl_number;
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'转售后失败', 'data'=>''];
        }
    }

    // 订单添加作品
    public function addOrderWorks($user_info, $request)
    {
        $add_data['orwo_shop_id'] = $user_info->adm_shop_id;
        $add_data['orwo_ord_id'] = $request['ord_id'];
        $add_data['orwo_title'] = $request['orwo_title'];
        $add_data['orwo_type'] = $request['orwo_type'];
        $add_data['orwo_description'] = $request['orwo_description'];
        $add_data['orwo_cover'] = $request['orwo_cover'];//封面图片
        $add_data['orwo_data'] = $request['orwo_data'];
        $add_data['orwo_adm_id'] = $user_info->adm_id;
        $add_data['orwo_create_time'] = date('Y-m-d H:i:s');
        $add_data['orwo_update_time'] = date('Y-m-d H:i:s');
        $add_data_res = DB::table('order_works')->insert($add_data);
        if ($add_data_res) {
            return ['code'=>200, 'msg'=>'添加作品成功', 'data'=>'添加作品成功'];
        } else {
            return ['code'=>500, 'msg'=>'添加作品失败', 'data'=>'添加作品失败'];
        }
    }

    // 订单作品列表
    public function OrderWorksindex($user_info, $request)
    {
        $find_data = DB::table('order_works as o')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'o.orwo_adm_id')
            ->where('orwo_ord_id', $request['ord_id'])
            ->where('orwo_delete', 2)
            ->select('orwo_title', 'orwo_id', 'orwo_type', 'orwo_description', 'orwo_adm_id', 'adm_name', 'orwo_create_time', 'orwo_data', 'orwo_cover')
            ->orderBy('orwo_create_time', 'desc')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $find_data[$key]->orwo_cover = addHttpurl($value->orwo_cover);
            $new_orwo_data = [];
            if (!empty($value->orwo_data)) {
                $orwo_data = json_decode($value->orwo_data);
                foreach ($orwo_data as $k => $v) {
                    $new_orwo_data[] = addHttpurl($v);
                }
            }
            $new_orwo_data = json_encode($new_orwo_data, true);
            $find_data[$key]->orwo_data = addHttpurl($new_orwo_data);
        }
        return $find_data;
    }

    // 订单作品详情
    public function OrderWorksinfo($user_info,$request)
    {
        $find_data = DB::table('order_works as o')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'o.orwo_adm_id')
            ->where('orwo_id', $request['orwo_id'])
            ->where('orwo_delete', 2)
            ->select('orwo_title', 'orwo_id', 'orwo_type', 'orwo_description', 'orwo_data', 'orwo_adm_id', 'adm_name', 'orwo_create_time', 'orwo_cover')
            ->first();

        if ($find_data) {
            $orwo_data = json_decode($find_data->orwo_data, true);
            if (!empty($orwo_data)) {
                foreach ($orwo_data as $key1 => $value1) {
                    $f4 = substr($value1, 0, 4);
                    if ($f4 != 'http') {
                        $orwo_data[$key1] = config('apisystem.server_name').'/'.$value1;
                    }
                }
                $find_data->orwo_data = json_encode($orwo_data, true);
            }
        }
        return $find_data;
    }

    // 订单作品编辑
    public function OrderWorksedit($user_info, $request)
    {
        $update_data['orwo_shop_id'] = $user_info->adm_shop_id;
        $update_data['orwo_title'] = $request['orwo_title'];
        $update_data['orwo_ord_id'] = $request['ord_id'];
        $update_data['orwo_type'] = $request['orwo_type'];
        $update_data['orwo_description'] = $request['orwo_description'];
        $update_data['orwo_cover'] = $request['orwo_cover'];//作品封面
        $update_data['orwo_data'] = $request['orwo_data'];
        $update_data['orwo_adm_id'] = $user_info->adm_id;
        $update_data['orwo_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('order_works')->where('orwo_id', $request['orwo_id'])->update($update_data);
        if ($update_data_res) {
            return ['code'=>200, 'msg'=>'编辑作品成功', 'data'=>'编辑作品成功'];
        } else {
            return ['code'=>500, 'msg'=>'编辑作品失败', 'data'=>'编辑作品失败'];
        }
    }

    // 订单作品删除
    public function OrderWorksdel($user_info, $request)
    {
        $del_data['orwo_delete'] = 1;
        $del_data['orwo_update_time'] = date('Y-m-d H:i:s');
        $del_res = DB::table('order_works')
            ->where('orwo_id', $request['orwo_id'])
            ->where('orwo_delete', 2)
            ->update($del_data);
        if ($del_res) {
            return ['code'=>200, 'msg'=>'删除作品成功', 'data'=>'删除作品成功'];
        } else {
            return ['code'=>500, 'msg'=>'删除作品失败', 'data'=>'删除作品失败'];
        }
    }

    // 订单审核修正
    public function auditOrder($user_info, $request)
    {
        if ($request['goods_data']) {
            $goods_data = json_decode($request['goods_data'], true);
            foreach ($goods_data as $key => $value) {
                $update_orgo_data['orgo_goo_price'] =  $value['orgo_goo_price'] * 100;
                $update_orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                $update_orgo_res = DB::table('order_goods')
                    ->where('orgo_id', $value['orgo_id'])
                    ->update($update_orgo_data);
                if (!$update_orgo_res) {
                    return ['code'=>500, 'msg'=>'修改价格失败', 'data'=>'修改价格失败'];
                }
            }
        } else {
            return ['code'=>500, 'msg'=>'请选择商品', 'data'=>'请选择商品'];
        }
        // 修改订单金额及服务金额
        // $update_data['ord_actual_price'] = $request['ord_actual_price']*100;
        $update_data['ord_order_price'] = $request['ord_actual_price']*100;
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($update_data);
        // 查询是否有工单
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_id')
            ->first();
        if ($find_work) {
            // 修改工单金额及服务金额
            $update_work_data['wor_actual_price'] = $request['ord_actual_price']*100;
            $update_work_data['wor_update_time'] = date('Y-m-d H:i:s');
            $update_wor_res = DB::table('work_order')
                ->where('wor_id', $find_work->wor_id)
                ->update($update_work_data);
            foreach ($goods_data as $key => $value) {
                $update_wogo_data['wogo_goo_price'] = $value['orgo_goo_price'] * 100;
                $update_wogo_data['wogo_update_time'] = date('Y-m-d H:i:s');
                $update_wogo_res = DB::table('work_good')
                    ->where('wogo_orgo_id', $value['orgo_id'])
                    ->update($update_wogo_data);
                if (!$update_wogo_res) {
                    return ['code'=>500, 'msg'=>'修改价格失败', 'data'=>'修改价格失败'];
                }
            }
        } else {
            $update_wor_res = true;
            $update_wogo_res = true;
        }
        // if (isset($request['goo_id']) && !empty($request['goo_id'])) {
        //     $update_goo_data['orgo_goo_price'] = $request['orgo_goo_price']*100;
        //     $update_orgo_res = DB::table('order_goods')
        //         ->where('orgo_ord_id', $request['ord_id'])
        //         ->where('orgo_goo_id', $request['goo_id'])
        //         ->update($update_goo_data);
        //     if ($find_work) {
        //         $update_wogo_data['wogo_goo_price'] = $request['orgo_goo_price']*100;
        //         $update_wogo_res = DB::table('work_good')
        //             ->where('wogo_wor_id', $find_work->wor_id)
        //             ->where('wogo_goo_id', $request['goo_id'])
        //             ->update($update_wogo_data);
        //     } else {
        //         $update_wogo_res = true;
        //     }
        // } else {
        //     $update_orgo_res = true;
        //     $update_wogo_res = true;
        // }
        if ($update_res && $update_wor_res) {
            return ['code'=>200, 'msg'=>'修改价格成功', 'data'=>'修改价格成功'];
        } else {
            return ['code'=>500, 'msg'=>'修改价格失败', 'data'=>'修改价格失败'];
        }
    }

    public static function getOrderHistory($user_info, $request)
    {
        $find_data = DB::table('work_order_history')
            ->where('wohi_primary_id', $request['ord_id'])
            ->where('wohi_type', 1)
            ->select('wohi_state_name', 'wohi_create_time', 'wohi_state')
            ->orderBy('wohi_state', 'asc')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$find_data];
    }

    // 验车结果
    public static function validateCarData($user_info, $request)
    {
        $ord_shop_id = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->value('ord_shop_id');
        // 查询当前订单验车数据
        $find_orvc_data = DB::table('wash_validate_car as orvc')
            // ->where('vaca_shop_id', $user_info->adm_shop_id)
            ->where('vaca_ord_id', $request['ord_id'])
            ->select('vaca_id', 'vaca_data', 'vaca_name', 'vaca_first_data', 'vaca_data_id', 'vaca_first_data_id', 'vaca_type', 'vaca_must', 'vaca_part', 'vaca_part_type')
            ->get()->toArray();
        $orcl_data = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->select('orcl_mileage', 'orcl_signature_img')
            ->first();
        $find_goods_img = [];
        $fast_postion = [];
        $fast_img = [];
        $explain = '';//补充说明
        // 整车
        $fast_postion[0]['one'] = '整车';
        $fast_postion[0]['one_id'] = 0;
        $all_car[0] = ['id' => 0, 'vacm_type' => 0, 'title'=>'整车'];
        $all_car_num = 0;
        foreach ($all_car as $key => $value) {
            foreach ($find_orvc_data as $key1 => $value1) {
                if ($value1->vaca_part_type == 0 && $value['title'] == $value1->vaca_data) {
                    $all_car[$key]['vaca_select'] = 1;
                    $all_car[$key]['vaca_id'] = $value1->vaca_id;
                    $all_car_num++;
                }
            }
        }
        $fast_postion[0]['one_num'] = $all_car_num;
        $fast_postion[0]['two'] = $all_car;

        $car_in = DB::table('wash_validate_car_manage')
            ->where('vacm_shop_id', $ord_shop_id)
            ->where('vacm_state', 1)
            ->where('vacm_type', 1)
            ->where('vacm_delete', 1) //是否删除：1正常2已删除
            ->select('vacm_id as id', 'vacm_unusual_name as title', 'vacm_type', 'vacm_remark')
            ->get()->toArray();
        $fast_postion[1]['one'] = '车内部分';
        $car_in_num = 0;
        $fast_postion[1]['one_id'] = 1;
        foreach ($car_in as $key => $value) {
            foreach ($find_orvc_data as $key1 => $value1) {
                if ($value1->vaca_part_type == 1 && $value->title == $value1->vaca_data) {
                    $car_in[$key]->vaca_select = 1;
                    $car_in[$key]->vaca_id = $value1->vaca_id;
                    $car_in_num++;
                }
            }
        }
        $fast_postion[1]['one_num'] = $car_in_num;
        $fast_postion[1]['two'] = $car_in;
        $car_out = DB::table('wash_validate_car_manage')
            ->where('vacm_shop_id', $ord_shop_id)
            ->where('vacm_state', 1)
            ->where('vacm_type', 2)
            ->where('vacm_delete', 1) //是否删除：1正常2已删除
            ->select('vacm_id as id', 'vacm_unusual_name as title', 'vacm_type', 'vacm_remark')
            ->get()->toArray();
        $car_out_num = 0;
        foreach ($car_out as $key => $value) {
            foreach ($find_orvc_data as $key1 => $value1) {
                if ($value1->vaca_part_type == 2 && $value->title == $value1->vaca_data) {
                    $car_out[$key]->vaca_select = 1;
                    $car_out[$key]->vaca_id = $value1->vaca_id;
                    $car_out_num++;
                }
            }
        }
        $fast_postion[2]['one'] = '外观部分';
        $fast_postion[2]['one_num'] = $car_out_num;
        $fast_postion[2]['one_id'] = 2;
        $fast_postion[2]['two'] = $car_out;
        $type = DB::table('auto_parts')
            ->where('enabled', 1)
            ->select('type', 'type_id')
            ->groupBy('type')
            ->get()->toArray();
        $new_data = [];
        $new_data_one = [];
        foreach ($type as $key1 => $value1) {
            $new_data[$key1]['type'] = $value1->type;
            $new_data[$key1]['type_id'] = $value1->type_id;
            $new_data[$key1]['type_num'] = 0;
            $new_data[$key1]['data'] = DB::table('auto_parts')
                ->where('enabled', 1)
                ->where('type', $value1->type)
                ->select('title', 'id', 'type')
                ->get()->toArray();
            $new_data_one[$key1]['type'] = $value1->type;
            $new_data_one[$key1]['type_id'] = $value1->type_id;
            $new_data_one[$key1]['type_num'] = 0;
            $new_data_one[$key1]['data'] = DB::table('auto_parts')
                ->where('enabled', 1)
                ->where('type', $value1->type)
                ->select('title', 'id', 'type')
                ->get()->toArray();
        }
        $car_lacquer = $new_data;
        $car_dismounting = $new_data_one;

        // 查询当前订单验车漆面部分数据
        $car_lacquer_data = DB::table('wash_validate_car as orvc')
            ->where('vaca_shop_id', $ord_shop_id)
            ->where('vaca_ord_id', $request['ord_id'])
            ->where('vaca_type', 2)
            ->where('vaca_part_type', 3)
            ->select('vaca_id', 'vaca_data', 'vaca_name', 'vaca_first_data', 'vaca_data_id', 'vaca_first_data_id', 'vaca_type', 'vaca_must')
            ->get()->toArray();
        $one_num = 0;
        foreach ($car_lacquer as $key_l => $value_l) {
            foreach ($car_lacquer_data as $key1 => $value1) {
                if ($value_l['type'] == $value1->vaca_first_data) {
                    foreach ($car_lacquer[$key_l]['data'] as $key2 => $value2) {
                        if ($value2->title == $value1->vaca_data) {
                            $car_lacquer[$key_l]['data'][$key2]->vaca_select = 1;
                            $car_lacquer[$key_l]['data'][$key2]->vaca_id = $value1->vaca_id;
                            $car_lacquer[$key_l]['type_num']++;
                            $one_num++;
                        }
                    }
                }
            }
        }
        $fast_postion[3]['one'] = '漆面部分';
        $fast_postion[3]['one_id'] = 3;
        $fast_postion[3]['one_num'] = $one_num;
        $fast_postion[3]['two'] = $car_lacquer;
        // 查询当前订单验车数据
        $car_dismounting_data = DB::table('wash_validate_car as orvc')
            ->where('vaca_shop_id', $ord_shop_id)
            ->where('vaca_ord_id', $request['ord_id'])
            ->where('vaca_type', 2)
            ->where('vaca_part_type', 4)
            ->select('vaca_id', 'vaca_data', 'vaca_name', 'vaca_first_data', 'vaca_data_id', 'vaca_first_data_id', 'vaca_type', 'vaca_must')
            ->get()->toArray();
        $one_num = 0;

        foreach ($car_dismounting as $key => $value) {
            foreach ($car_dismounting_data as $key1 => $value1) {
                if ($value['type'] == $value1->vaca_first_data) {
                    foreach ($car_dismounting[$key]['data'] as $key2 => $value2) {
                        if ($value2->id == $value1->vaca_data_id) {
                            $car_dismounting[$key]['data'][$key2]->vaca_select = 1;
                            $car_dismounting[$key]['data'][$key2]->vaca_id = $value1->vaca_id;
                            $car_dismounting[$key]['type_num']++;
                            $one_num++;
                        }
                    }
                }
            }
        }

        $fast_postion[4]['one'] = '拆卸部分';
        $fast_postion[4]['one_id'] = 4;
        $fast_postion[4]['one_num'] = $one_num;
        $fast_postion[4]['two'] = $car_dismounting;
        $i = 0;
        $j = 0;
        $k = 0;
        foreach ($find_orvc_data as $key => $value) {
            if ($value->vaca_type == 1) {//检验商品图片
                $find_goods_img[$i]['vaca_id'] = $value->vaca_id;
                $find_goods_img[$i]['vaca_name'] = $value->vaca_name;
                $find_goods_img[$i]['vaca_data'] = $value->vaca_data;
                $find_goods_img[$i]['vaca_must'] = $value->vaca_must;
                $find_goods_img[$i]['vaca_type'] = $value->vaca_type;
                $find_goods_img[$i]['vaca_data_id'] = $value->vaca_data_id;
                $i++;
            }

            if ($value->vaca_type == 3) {//快捷图片
                $fast_img[$j]['vaca_id'] = $value->vaca_id;
                $fast_img[$j]['vaca_data'] = $value->vaca_data;
                $j++;
            }
        }
        $chsu_data = DB::table('checkcar_supplement')
            ->where('chsu_ord_id', $request['ord_id'])
            ->select('chsu_id', 'chsu_img', 'chsu_explain', 'chsu_sign')
            ->get()->toArray();
        $return_data['find_goods_img'] = $find_goods_img;
        $return_data['fast_postion'] = $fast_postion;
        $return_data['fast_img'] = $fast_img;
        $return_data['chsu_data'] = $chsu_data;
        $return_data['orcl_mileage'] = $orcl_data->orcl_mileage;
        $return_data['orcl_signature_img'] = $orcl_data->orcl_signature_img;
        return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
    }

    // 获取字段数据
    public static function getFieldsById($id, $fields = '*', $shopID = 0)
    {
        $entity = WashOrder::where('ord_id', $id)
            ->where('ord_shop_id', $shopID)
            ->select($fields)
            ->first();

        return $entity;
    }

    // 合作商预约下单新增
    public static function addReservation($user_info, $request)
    {
        $reli_data['reli_cid'] = $user_info->adm_cid;
        $reli_data['reli_superior_shop_id'] = $user_info->adm_shop_id;
        $reli_data['reli_shop_id'] = $user_info->adm_shop_id;

        $reli_number = Common::numberRule((object)$user_info, 5);
        $reli_data['reli_number'] = $reli_number;//预约单号
        $reli_data['reli_client_type'] = 2;//类型：1会员2企业用户
        $reli_data['reli_client_id'] = $request['buac_id'];//客户单位id，企业会员id
        $find_bucl = DB::table('business_account as buac')
            ->leftjoin('business_client as bucl', 'bucl.bucl_id', '=', 'buac.buac_bucl_id')
            ->where('buac_id', $request['buac_id'])
            ->select('bucl_id', 'bucl_name')
            ->first();
        $reli_data['reli_bus_id'] = $find_bucl->bucl_id;//合作商id
        $reli_data['reli_bus_name'] = $find_bucl->bucl_name;//合作商名称
        $reli_data['reli_address_type'] = 2;//合作商
        $reli_data['reli_address_id'] = $find_bucl->bucl_id;//合作商id
        $reli_data['reli_address'] = $find_bucl->bucl_name;//合作商id
        $reli_data['reli_appoint_time'] = $request['appoint_time'];
        $reli_data['reli_appoint_time_slot'] = $request['appoint_time'];//预约时间段
        if (!empty($request['appoint_remark'])) {
            $reli_data['reli_appoint_remark'] = $request['appoint_remark'];//预约备注
        }
        $reli_data['reli_create_id'] = $request['buac_id'];//合作商 账号id
        $reli_data['reli_explain'] = !empty($request['reli_explain']) ? $request['reli_explain'] : '';//施工说明
        $reli_id = DB::table('wash_reservation_list')->insertGetId($reli_data);

        // 预约单客户信息
        $recl_data['recl_shop_id'] = $request['shop_id'];
        $recl_data['recl_reli_id'] = $reli_id;
        $recl_data['recl_client_id'] = $request['buac_id'];//合作商 账号id
        $recl_data['recl_name'] = $user_info->adm_name;//会员姓名
        $recl_data['recl_ower_name'] = !empty($request['name']) ? $request['name'] : '';//车主姓名
        if (!empty($request['phone'])) {
            $isMatched = preg_match('#^13[\d]{9}$|^14[5,7]{1}\d{8}$|^15[^4]{1}\d{8}$|^16[\d]{1}\d{8}$|^17[0,6,7,8]{1}\d{8}$|^18[\d]{9}$|^19[\d]{9}$#', $request['phone']);
            if (!$isMatched) {
                return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'手机号格式不正确', 'data'=>''];
            }
        }
        $recl_data['recl_phone'] = $user_info->adm_phone;//会员联系电话
        $recl_data['recl_ower_phone'] = !empty($request['phone']) ? $request['phone'] : '';//联系电话
        if (!empty($request['car_num'])) {
            $isCarLicense = isCarLicense($request['car_num']);// 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'车牌照格式不正确', 'data'=>''];
            }
            $recl_data['recl_car_num'] = $request['car_num'];//车牌号
        }
        if (!empty($request['car_vin'])) {
            $recl_data['recl_car_vin'] = $request['car_vin'];//车架号车辆识别码
        } else {
            $recl_data['recl_car_vin'] = '';
        }
        $recl_data['recl_car_brand_series'] = $request['car_brand_series'];//品牌车系
        if (!empty($request['province'])) {//省
            $recl_data['recl_province'] = $request['province'];
        }
        if (!empty($request['city'])) {//市
            $recl_data['recl_city'] = $request['city'];
        }
        if (!empty($request['county'])) {//县
            $recl_data['recl_county'] = $request['county'];
        }
        if (!empty($request['address'])) {//地址
            $recl_data['recl_address'] = $request['address'];
        }
        $recl_id = DB::table('wash_reservation_client')->insertGetId($recl_data);

        // 预约单项目商品信息
        $reit_data['reit_shop_id'] = $request['shop_id'];
        $reit_data['reit_reli_id'] = $reli_id;//预约单id
        // 查询选择项目信息
        $find_sepr = DB::table('service_project')
            ->where('sepr_id', $request['sepr_id'])
            ->select('sepr_id', 'sepr_name', 'sepr_order_money')
            ->first();
        $reit_data['reit_sepr_id'] = $request['sepr_id'];
        $reit_data['reit_sepr_name'] = $find_sepr->sepr_name;
        $reit_data['reit_sepr_price'] = $find_sepr->sepr_order_money;
        $reit_res = DB::table('wash_reservation_items')->insert($reit_data);

        if ($reli_id && $recl_id && $reit_res) {
            $data['reli_number'] = $reli_number;
            return ['code'=>200, 'msg'=>'预约下单成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'预约下单失败', 'data'=>''];
        }
    }

    // 合作商订单
    public function BusOrder($user_info, $search_data, $show_count = 10)
    {
        $orderby_type = 'desc'; //排序类型，默认倒序查询
        // 当查询待接单状态订单时，按正序查询
        if (!empty($search_data['ord_wor_state']) && $search_data['ord_wor_state'] == 7) {
            $orderby_type = 'asc'; //默认排序类型
        }
        $list_data = DB::table('order as ord')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftJoin('shop as s', 's.shop_id', '=', 'ord.ord_shop_id')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('ord_type', 2) //买家类型：1门店零售2企业客户
            ->where('ord_client_id', $search_data['buac_id']) //买家类型：1门店零售2企业客户
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->where(function ($query) use ($search_data) { //关键字搜索
                if (!empty($search_data['keywords'])) {
                    $query->where('orcl_phone', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('orcl_name', 'like', '%' . $search_data['keywords'] . '%')
                        ->orwhere('orcl_car_num', 'like', '%' . $search_data['keywords'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单状态
                if (!empty($search_data['ord_wor_state'])) {
                    $query->where('ord_wor_state', $search_data['ord_wor_state']);
                }
            })
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_type', 'ord_order_state', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'ord_create_time', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'ord_remark', 'ord_order_price', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'orcl_car_brand_series', 'orcl_pick_up_car_time', 'orcl_pick_up_car_adm_id', 'orcl_check_car_state', 'orcl_car_vin', 'orcl_sales_adm_id', 'ord_is_split', 'ord_province', 'ord_city', 'ord_county', 'ord_address', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_explain', 'shop_store_name', 'ord_address_id', 'ord_address_type', 'orcl_carbrse_type')
            ->orderBy('ord_id', $orderby_type)
            ->paginate($show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            $ord_id = array_column($list_items, 'ord_id'); //订单id
            $ord_create_id = array_unique(array_column($list_items, 'ord_create_id')); //录单人id

            // 查询商品、项目信息
            $order_goods = DB::table('order_goods as orgo')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->whereIn('orgo_ord_id', $ord_id)
                ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_guarantee', 'orgo_goo_type', 'orgo_state', 'orgo_goo_unit', 'orgo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            $orcl_sales_adm_id = array_filter(array_unique(array_column($list_items, 'orcl_sales_adm_id'))); //销售人员id
            $adm_id_merge = array_merge($ord_create_id, $orcl_sales_adm_id);
            // 查询录单人信息
            $find_adm = DB::table('admin')
                ->whereIn('adm_id', $adm_id_merge)
                ->pluck('adm_name', 'adm_id')->toArray();

            foreach ($order_goods as $key => $value) {
                // 服务项目图片路径
                if ($value->orgo_goo_type == 2) {
                    $order_goods[$key]->goo_image = DB::table('service_project')
                        ->where('sepr_id', $value->orgo_goo_id)
                        ->value('sepr_img');
                } else {
                    $order_goods[$key]->goo_image = 'image/xmc/xx_icon.png'; //显示图片
                }
                $order_goods[$key]->orgo_goo_quantity = $value->orgo_goo_quantity.$value->orgo_goo_unit;
            }
            foreach ($list_items as $key => $value) {
                // 创建人
                if ($value->ord_create_id) {
                    $list_items[$key]->adm_name = $find_adm[$value->ord_create_id];
                } else {
                    $list_items[$key]->adm_name = '';
                }
                // 销售人员
                if ($value->orcl_sales_adm_id) {
                    $list_items[$key]->orcl_sales_adm_name = $find_adm[$value->orcl_sales_adm_id];
                } else {
                    $list_items[$key]->orcl_sales_adm_name = '';
                }
                // 预约时间
                if ($value->orcl_appoint_time == '0000-00-00 00:00:00') {
                    $list_items[$key]->orcl_appoint_time = '';
                }
                if ($value->orcl_car_brand_series) {
                    $car_brse = explode("-", $value->orcl_car_brand_series);
                    if (!empty($car_brse)) {
                        $list_items[$key]->orcl_car_brand_series = $car_brse;
                    }
                }
                // 施工地址
                if ($value->ord_address_type == 1) {//门店
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_address_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                    $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                } elseif ($value->ord_address_type == 2) {
                    $find_address = DB::table('business_client')
                        ->where('bucl_id', $value->ord_address_id)
                        ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->bucl_name;
                    $list_items[$key]->ord_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                } else {
                    $find_address = DB::table('shop')
                        ->where('shop_id', $value->ord_shop_id)
                        ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                        ->first();
                    $list_items[$key]->shop_store_name = $find_address->shop_store_name;
                    $list_items[$key]->ord_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                }
            }
            // 查询备注信息
            $order_reamrks = DB::table('order_remarks')
                ->whereIn('orre_ord_id', $ord_id)
                ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
                ->orderby('orre_id', 'desc')
                ->get();

            // 查找操作记录
            $order_log = DB::table('order_log')
                ->whereIn('orlo_ord_id', $ord_id)
                ->orderBy('orlo_id', 'desc')
                ->select('orlo_ord_id', 'orlo_time', 'orlo_create_adm_name', 'orlo_content')
                ->get();
        } else {
            $order_goods = [];
            $order_log = [];
            $order_reamrks = [];
        }
        $reli_data = DB::table('wash_reservation_list as reli')
            ->where('reli_client_id', $user_info->buac_id)
            ->where('reli_client_type', 2) //买家类型：1门店零售2客户单位
            ->where('reli_state', 1) //预约单状态：1待接单2已接单3取消订单4已撤回
            ->select(DB::raw('count(*) as count, reli_state'))
            ->groupBy('reli_state')
            ->get();
        // 查询订单状态对应的订单数量
        $state_count = DB::table('order')
            ->where('ord_type', 2) //买家类型：1门店零售2企业客户
            ->where('ord_client_id', $search_data['buac_id']) //买家类型：1门店零售2企业客户
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_classify', 2)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['order_goods'] = $order_goods;                //订单商品数据
        $data['state_count'] = $reli_data;
        $data['reli_count'] = $state_count;
        $data['order_log'] = $order_log;                    //操作记录
        $data['order_reamrks'] = $order_reamrks;           //订单备注
        $data['now_time'] = date('Y-m-d H:i:s');           //当前时间
        return $data;
    }

    // 新增会员
    public static function addMember($user_info, $request)
    {
        // 1. 判断手机号是否存在
        $find_mem = DB::table('member')
            ->where('mem_cid', $user_info->adm_cid)
            ->where('mem_superior_shop_id', $user_info->adm_shop_id)
            ->where('mem_phone', $request['mem_phone'])
            ->first(['mem_id']);
        if ($find_mem) {
            return ["code"=>500, 'msg'=>'当前手机号已存在', 'data'=>'当前手机号已存在'];
        }
        if ($request['mem_car_num']) {
            // 判断车牌号是否存在
            $find_meca = DB::table('member_car')
                ->where('meca_cid', $user_info->adm_cid)
                ->where('meca_superior_shop_id', $user_info->adm_shop_id)
                ->where('meca_car_num', $request['mem_car_num'])
                ->first(['meca_id']);
            if ($find_meca) {
                return ["code"=>500, 'msg'=>'当前车牌号已存在', 'data'=>'当前车牌号已存在'];
            }
        }
        $mem_fid = 0;
        if ($request['mem_fphone']) {
            $mem_fid = DB::table('member')
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->where('mem_phone', $request['mem_fphone'])
                ->value('mem_id');
            if (!$mem_fid) {
                return ['code' => 500, 'msg' => '未查询到该邀请人', 'data' => ''];
            }
        }
        // 2 新增一个会员信息
        $mem_add_data['mem_cid'] = $user_info->adm_cid;
        $mem_add_data['mem_shop_id'] = $user_info->adm_shop_id;
        $mem_add_data['mem_superior_shop_id'] = $user_info->adm_shop_id;
        $mem_add_data['mem_name'] = $request['mem_name'];
        $mem_add_data['mem_sex'] = $request['mem_sex'];
        $mem_add_data['mem_fid'] = $mem_fid;
        $mem_add_data['mem_create_name'] = $user_info->adm_name;
        $mem_add_data['mem_create_id'] = $user_info->adm_id;
        $mem_add_data['mem_phone'] = $request['mem_phone'];
        $mem_add_data['mem_car_num'] = str_replace(' ', '', $request['mem_car_num']);
        $mem_add_data['mem_car_series'] = $request['mem_car_series'] ? $request['mem_car_series'] : '';
        $mem_add_data['mem_source'] = $request['mem_source'] ? $request['mem_source'] : '';
        $mem_add_data['mem_car_color'] = $request['mem_car_color'] ? $request['mem_car_color'] : '';
        // $mem_id =  DB::table('member')->insertGetId($mem_add_data);
        $mem_id = MemberService::addMember($mem_add_data);
        if ($mem_fid) {
            $add_data_bind['bilo_shop_id'] = $user_info->adm_shop_id;
            $add_data_bind['bilo_Inviter_id'] = $mem_fid;
            $add_data_bind['bilo_Invitee_id'] = $mem_id;
            $add_data_bind['bilo_state'] = 1;
            $add_data_bind['bilo_create_time'] = date('Y-m-d H:i:s');
            $add_data_bind['bilo_update_time'] = date('Y-m-d H:i:s');
            $add_res = DB::table('bind_log')->insertGetId($add_data_bind);
        }
        // $mem_id =  DB::table('member')->insertGetId($mem_add_data);
        self::addFestival($mem_id,$user_info);//新增节日提醒
        // 3.新增一个车辆信息
        if ($request['mem_car_num']) {
            $meca_add_data['meca_cid'] = $user_info->adm_cid;
            $meca_add_data['meca_shop_id'] = $user_info->adm_shop_id;
            $meca_add_data['meca_superior_shop_id'] = $user_info->adm_shop_id;
            $meca_add_data['meca_create_adm_id'] = $user_info->adm_id;
            $meca_add_data['meca_mem_id'] = $mem_id;
            $meca_add_data['meca_car_num'] = $request['mem_car_num'];
            $meca_add_data['meca_car_series'] = $request['mem_car_series'] ? $request['mem_car_series'] : '';
            $meca_res =  DB::table('member_car')->insert($meca_add_data);
        } else {
            $meca_res = true;
        }

        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_phone', $request['mem_phone'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        if (empty($find_weixin_data)) {
            // 不存在就新增用户
            $data['weus_phone'] = $request['mem_phone'];
            $data['weus_openid'] = $mem_id;
            $data['weus_nickmame'] = $request['mem_name'];
            $data['weus_follow'] = 1;
            $data['weus_sex'] = 0;
            $data['weus_headimgurl'] = '';
            $data['weus_update_time'] = date('Y-m-d H:i:s');
            $weus_id = DB::table('weixin_user')->insertGetId($data);
            if (!$weus_id) {
                return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
            }
            unset($data['weus_update_time']);
        } else {
            // 更新微信用户信息
            $edit_weus['weus_phone'] = $request['mem_phone'];
            $edit_weus['weus_nickmame'] = $request['mem_name'];
            if (!empty($request['weus_headimgurl'])) {
                $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
            }
            $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
            $edit_weus_res = DB::table('weixin_user')
                ->where('weus_id', $find_weixin_data->weus_id)
                ->update($edit_weus);
            unset($edit_weus);
            $weus_id = $find_weixin_data->weus_id;
        }

        // 查询微信用户与门店的关系是否存在绑定关系
        $find_user_shop_data = DB::table('user_shop')
            ->where('ussh_weus_id', $weus_id)
            ->where('ussh_shop_id', $user_info->adm_shop_id)
            ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
            ->first();

        if (empty($find_user_shop_data)) {
            // // 用户没有与当前门店绑定，把用户与当前门店绑定
            // $ussh_data['ussh_user_id'] = $mem_id;
            // $ussh_data['ussh_weus_id'] = $weus_id;
            // $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
            // $ussh_data['ussh_user_type'] = 1;
            // $ussh_data['ussh_phone'] = $request['mem_phone'];
            // $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
            // $ussh_data['ussh_register_time'] = date('Y-m-d H:i:s');
            // $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
            // if (!$ussh_id) {
            //     return ['code'=>500, 'msg'=>'新增失败2', 'data'=>''];
            // }
        } else {
            if (empty($find_user_shop_data->ussh_user_id)) {
                $ussh_data['ussh_user_type'] = 1;
                $ussh_data['ussh_phone'] = $request['mem_phone'];
                $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                $ussh_id = DB::table('user_shop')
                    ->where('ussh_id', $find_user_shop_data->ussh_id)
                    ->update($ussh_data);
            }
        }
        if ($mem_id && $meca_res) {
            $return_data['mem_id'] = $mem_id;
            $list_data = DB::table('member as m')
                ->leftJoin('user_shop as ussh', 'ussh.ussh_user_id', '=', 'm.mem_id')
                ->leftJoin('weixin_user as wx', 'ussh.ussh_weus_id', '=', 'wx.weus_id')
                ->leftJoin('member_car as mc', 'mc.meca_mem_id', '=', 'm.mem_id')
                ->where('mem_id', $mem_id)
                ->select('mem_id', 'mem_name', 'mem_phone', 'mem_province', 'mem_city', 'mem_county', 'mem_address', 'mem_bership', 'mem_car_series', 'mem_source', 'weus_headimgurl', 'mem_sex', 'mem_car_color', 'mem_rec_banlance', 'mem_gift_banlance', 'meca_car_num', 'mem_level','mem_initial')
                ->groupBy('mem_id')
                ->first();
            $list_data->ord_type = 1;
            $return_data['mem_data'] = $list_data;
            return ["code"=>200, 'msg'=>'新增会员成功', 'data'=>'新增会员成功', 'return_data'=>$return_data];
        } else {
            return ["code"=>500, 'msg'=>'新增会员失败1', 'data'=>'新增会员失败1'];
        }
    }

    // 新增企业会员
    public static function addBusinessAcc($user_info, $request)
    {
        // 1. 判断企业客户账号名称是否存在
        $find_buac = DB::table('business_account')
            ->where('buac_bucl_id', $request['buac_bucl_id'])
            ->where('buac_name', $request['buac_name'])
            ->first(['buac_id']);
        if ($find_buac) {
            return ['code'=>500, 'msg'=>'success', 'data'=>'客户名称已存在，新增失败'];
        }
        $password = md5($request['buac_password'] . 'faster123456');
        // 2 新增一个企业会员账号
        $add_buac_data['buac_shop_id'] = $user_info->adm_shop_id;
        $add_buac_data['buac_cid'] = $user_info->adm_cid;
        $add_buac_data['buac_name'] = $request['buac_name'];
        $add_buac_data['buac_phone'] = $request['buac_phone'];
        $add_buac_data['buac_sex'] = $request['buac_sex'];
        $add_buac_data['buac_password'] = $password;
        $add_buac_data['buac_bucl_id'] = $request['buac_bucl_id'];
        $add_buac_data['buac_create_adm_id'] = $user_info->adm_id;
        $add_buac_data['buac_create_time'] = date('Y-m-d H:i:s');
        $buac_res =  DB::table('business_account')->insertGetId($add_buac_data);
        if ($buac_res) {
            $return_data['buac_id'] = $buac_res;
            $list_data = DB::table('business_client as bucl')
                ->leftjoin('business_account as buac', 'buac.buac_bucl_id', '=', 'bucl_id')
                ->where('buac_id', $buac_res)
                ->select('buac_id', 'buac_name', 'buac_phone', 'bucl_name', 'bucl_id', 'bucl_rec_banlance', 'bucl_gift_banlance')
                ->first();
            $list_data->ord_type = 2;
            $return_data['buac_data'] = $list_data;
            return ["code"=>200, 'msg'=>'success', 'data'=>'新增会员成功', 'return_data'=>$return_data];
        } else {
            return ["code"=>500, 'msg'=>'error', 'data'=>'新增会员失败1'];
        }
    }

    // 新增-添加洗车订单
    public static function addWashCarOrder($user_info, $request, $type = 1)
    {
        // 如果有预约时间，则判断是否超出限制预约数量；
        if (isset($request['orcl_appoint_time'])) {

            $resenum_date=substr($request['orcl_appoint_time'],0,10);

            $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date,'',$request);

            if($jud_res['code'] != 200) return $jud_res;
        }
        $goods_data = json_decode($request['goods_data'],true);
        $vip_data = DB::table('myvip_detail')
            ->where('myvid_mvid', $request['myvi_id'])
            ->get()->toArray();
        $ord_goods_quantity = 0;//总数量
        $ord_add_work_state = 2;//是否生成工单1是2否
        $is_goods = false;//是否有产品
        $only_goods = false;//是否只有产品
        // 使用会员卡结算
        $sepr_work_type = array_column($goods_data, 'sepr_work_type');
        $goo_type = array_column($goods_data, 'goo_type');
        if (in_array(2, $goo_type)) {
            $is_goods = true;
        }
        if (!in_array(1, $goo_type)) {
            $only_goods = true;
        }
        $sepr_work_type = array_column($goods_data, 'sepr_work_type');
        if (in_array(1, $sepr_work_type)) {//是否生成工单
            $ord_add_work_state = 1;
        }
        foreach ($goods_data as $key => $value) {
            $ord_goods_quantity += $value['goo_quantity'];
            $goods_data[$key]['use_vip_num'] = 0;
            $goods_data[$key]['use_vip_price'] = 0;
            foreach ($vip_data as $k => $v) {
                if ($value['goo_type'] == $v->myvid_type && $value['goo_id'] == $v->myvid_data_id && isset($value['use_num'])) {
                    $goods_data[$key]['myvid_surplus_times'] = $v->myvid_surplus_times;
                    if ($value['goo_quantity'] <= $v->myvid_surplus_times) {
                        $goods_data[$key]['use_vip_num'] = $value['goo_quantity'];
                    } else {
                        $goods_data[$key]['use_vip_num'] = $v->myvid_surplus_times;
                    }
                    $goods_data[$key]['use_vip_price'] = $value['goo_price'];
                    $goods_data[$key]['myvid_id'] = $v->myvid_id;
                    if ($v->myvid_surplus_times< $value['use_num']) {
                        return ["code"=>500, 'msg'=>'会员卡剩余次数不足', 'data'=>'会员卡剩余次数不足'];
                    }
                }
            }
            if ($value['goo_type'] == 2) {
                $image_id = [];//根据服务项目确定需要上传的图片
                $sepr_image = DB::table('sepr_img')
                    ->where('seim_sepr_id', $value['goo_id'])
                    ->select('seim_imco_id')
                    ->get()->toArray();
                if (!empty($sepr_image)) {
                    foreach ($sepr_image as $ks => $vs) {
                        if (!in_array($vs->seim_imco_id, $image_id)) {
                            $image_id[] = $vs->seim_imco_id;
                        }
                    }
                }
            }
            if ($request['ware_id']) {
                if (!isset($value['goo_waon_class'])) {
                    $value['goo_waon_class'] = 1;
                    $goods_data[$key]['goo_waon_class'] = 1;
                }
                if (!isset($value['wago_id']) && $value['goo_type'] == 1) {
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->value('wago_id');
                    $value['wago_id'] = $find_wago_id;
                    $goods_data[$key]['wago_id'] = $find_wago_id;
                } elseif (!isset($value['wago_id']) && $value['goo_type'] == 2) {
                    $value['wago_id'] = 0;
                    $goods_data[$key]['wago_id'] = 0;
                }
                if(isset($value['wago_id']) && $value['goo_type'] == 1){
                    $find_wago_price = DB::table('warehouse_goods')
                        ->where('wago_goo_id', $value['goo_id'])
                        ->where('wago_class', $value['goo_waon_class'])
                        ->where('wago_ware_id', $request['ware_id'])
                        ->where('wago_id', $value['wago_id'])
                        ->value('wago_goo_price');
                    $goods_price[$value['wago_id']]['price'] = $find_wago_price;//商品成本价
                    $goods_price[$value['wago_id']]['quantity'] = $value['goo_quantity'];//商品数量
                }
            }
        }
        $order_amount = 0;//实际需支付的现金金额
        $ord_use_vip_price = 0;//用会员卡支付的金额
        $use_vip_allnum = 0;
        foreach ($goods_data as $key => $value) {
            $ord_use_vip_price += $value['use_vip_price']*$value['use_vip_num'];
            $order_amount+=($value['goo_price']*($value['goo_quantity'] - $value['use_vip_num']));
            $use_vip_allnum+=$value['use_vip_num'];
        }
        $ord_order_price = $ord_use_vip_price + $order_amount;
        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        $ord_order_number = Common::numberRule($user_info, 1);
        $data['ord_is_split'] = 1;
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = $request['ord_client_id'];
        $data['ord_order_price'] = $ord_order_price*100;
        $data['ord_service_adm_id'] = isset($request['service_adm_id']) ? $request['service_adm_id'] : '';//施工技师
        $data['ord_address'] = Db::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_store_name');
        $data['ord_address_id'] = $user_info->adm_shop_id;
        $data['ord_address_type'] = 1;
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = isset($request['ord_type']) ? $request['ord_type'] : 1;//买家类型：1门店零售2企业客户3散户
        $data['ord_service_type'] = 1; //订单类型：1服务单 2洗车单3商品单4会员卡
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式
        $data['ord_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : ''; //施工说明
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $data['ord_wor_state'] = 1;
        $data['ord_goods_quantity'] = 1;
        // $data['ord_ware_id'] = $request['ware_id'];
        if (in_array($request['ord_payment_way'], [1,2,3,4,6,7])) {//1现金
            $data['ord_state'] = 2;//结算状态1未结算2已结算
            $data['ord_pay_state'] = 1;//是否支付1是2否
            if (in_array($request['ord_payment_way'], [1,2,3,4])) {
                $data['ord_actual_price'] = $ord_order_price*100;
            }
            $data['ord_settlement_time'] = date('Y-m-d H:i:s');//结算时间
        } elseif ($request['ord_payment_way'] == 0 || $request['ord_payment_way'] == 8) {//暂不结算和账期
            $data['ord_actual_price'] = 0;
            $data['ord_state'] = 1;//结算状态1未结算2已结算
        } elseif ($request['ord_payment_way'] == 9) {//部分结算
            $data['ord_state'] = 3;//结算状态1未结算2已结算3部分
            $data['ord_pay_state'] = 1;//是否支付1是2否
            $data['ord_actual_price'] = $request['ord_actual_amout']*100;
            $data['ord_settlement_time'] = date('Y-m-d H:i:s');//结算时间
        } elseif ($request['ord_payment_way'] == 5) {//会员卡
            $data['ord_state'] = 2;//结算状态1未结算2已结算3部分
            $data['ord_pay_state'] = 1;//是否支付1是2否
            $data['ord_actual_price'] = 0;
            if ($order_amount > 0) {
                if (in_array($request['ord_other_payway'], [1,2,3,4])) {//使用会员卡外的其他结算方式
                    $data['ord_actual_price'] = $order_amount*100;
                } elseif ($request['ord_other_payway'] == 8 || $request['ord_other_payway'] == 0) {
                    $data['ord_actual_price'] = 0;
                    $data['ord_state'] = 3;
                } elseif ($request['ord_other_payway'] == 9) {
                    $data['ord_actual_price'] = $request['ord_actual_price'];
                    $data['ord_state'] = 3;
                }
            }
            $data['ord_zero_price'] = $ord_use_vip_price*100;//优惠金额
            $data['ord_settlement_time'] = date('Y-m-d H:i:s');//结算时间
        }
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $ord_id = DB::table('order')->insertGetId($data);
        //计算会员消费总金额
        if($request['ord_type'] == 1 && !empty($request['ord_client_id'])){
            WashOrderService::consume_money($request['ord_client_id']);
        }
        if ($request['ord_payment_way'] == 5) {//5会员卡
            if (!isset($request['myvi_id'])) {
                return ["code"=>500, 'msg'=>'请选择会员卡', 'data'=>'请选择会员卡'];
            }
            $find_myvi_data = DB::table('myvip')
                ->where('myvi_id', $request['myvi_id'])
                ->select('myvi_id', 'myvi_end_time', 'myvi_surplus_times', 'myvi_num', 'myvi_name')
                ->first();
            if ($find_myvi_data->myvi_end_time < date('Y-m-d H:i:s')) {
                return ["code"=>500, 'msg'=>'会员卡已过期', 'data'=>'会员卡已过期'];
            }
            if ($find_myvi_data->myvi_surplus_times == 0) {
                return ["code"=>500, 'msg'=>'会员卡次数已用完', 'data'=>'会员卡次数已用完'];
            }
            $update_data['myvi_surplus_times'] = $find_myvi_data->myvi_surplus_times - $use_vip_allnum;
            if ($update_data['myvi_surplus_times'] == 0) {
                $update_data['myvi_state'] = 2;//已失效
            }
            $update_data['myvi_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('myvip')
                ->where('myvi_id', $find_myvi_data->myvi_id)
                ->update($update_data);
            $add_vip_record['vcre_myvi_id'] = $request['myvi_id'];
            $add_vip_record['vcre_user_id'] = $request['ord_client_id'];
            $add_vip_record['vcre_ord_num'] = $ord_order_number;
            $add_vip_record['vcre_ord_id'] = $ord_id;
            $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
            $add_vip_record['vcre_car_adm_name'] = $request['orcl_name'];
            $add_vip_record['vcre_car_adm_phone'] = $request['orcl_phone'];
            $add_vip_record['vcre_myvi_num'] = $find_myvi_data->myvi_num;
            $add_vip_record['vcre_log'] = 1;//操作1结算2取消结算
            // $add_vip_record['vcre_num_change'] = '-1（剩余：'.($find_myvi_data->myvi_surplus_times - 1).'次）';
            $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);
            $use_vip_data = [];
            //使用会员卡结算
            $vip_data = DB::table('myvip_detail')
                ->where('myvid_mvid', $request['myvi_id'])
                ->get()->toArray();
            // 使用会员卡结算
            foreach ($goods_data as $key => $value) {
                foreach ($vip_data as $k => $v) {
                    if ($value['goo_type'] == $v->myvid_type && $value['goo_id'] == $v->myvid_data_id) {
                        $myvid_surplus_times = DB::table('myvip_detail')
                            ->where('myvid_id',$v->myvid_id)
                            ->value('myvid_surplus_times');
                        $use_vip_data['myvid_surplus_times'] = $myvid_surplus_times - $value['use_vip_num'];
                        // $use_vip_data['myvid_surplus_times'] = $v->myvid_surplus_times - $value['use_vip_num'];
                        $update_vip_data = DB::table('myvip_detail')
                            ->where('myvid_id',$v->myvid_id)
                            ->update($use_vip_data);
                        $add_vcrd_data['vcrd_vcre_id'] = $add_vire_res;
                        $add_vcrd_data['vcrd_myvid_id'] = $v->myvid_id;
                        $add_vcrd_data['vcrd_num'] = $value['use_vip_num'];
                        $add_vcrd_data['vcrd_description'] = '-'.$value['use_vip_num'].'/余'.$use_vip_data['myvid_surplus_times'];
                        $add_vcrd_data['vcrd_create_time'] = date('Y-m-d H:i:s');
                        $add_vcrd_data['vcrd_create_id'] = $user_info->adm_id;
                        $add_vcre_res = DB::table('vipca_record_datail')->insertGetId($add_vcrd_data);
                    }
                }
            }
            if (isset($request['vico_id']) && $request['vico_id']) {
                $update_vico_data['vico_state'] = 2;//失效
                $update_vico_res = DB::table('vip_code')
                    ->where('vico_id', $request['vico_id'])
                    ->update($update_vico_data);
            } else {
                $update_vico_res = true;
            }
            // [['type'=>1,'name'=>'开单短信'],['type'=>2,'name'=>'使用会员卡'],['type'=>3,'name'=>'工单变更'],['type'=>4,'name'=>'验车']]
            $send = isSend($user_info, 2);
            if ($send) {
                // 2.给相应的客户发送短信
                $phone = $request['orcl_phone'];
                $message = '【半径服务】您的'.$find_myvi_data->myvi_name.'消费1次，剩余'.($find_myvi_data->myvi_surplus_times - $use_vip_allnum).'次';
                if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                    $find_shop_data = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->first();
                    if ($find_shop_data->shop_message_num <= 0) {
                        $send_state = 2;
                        $send_res = 0;
                    } else {
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();
                        if ($msg_remind_log) {//已提醒过
                            if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                $update_remind['mrlo_state'] = 1;
                                $msg_remind_log = DB::table('msg_remind_log')
                                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                    ->where('mrlo_state', 2)
                                    ->update($update_remind);
                            }
                        }
                        
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();

                        if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                            $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                            // $wechat_msg['pushtype'] = 5; //短信预警
                            // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                            // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                            // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                            // $wechat_msg['remark'] = '短信不足预警';
                            // $CashierDesk = new CashierDesk;
                            // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                            $remind_phone = $adm_data->adm_phone;
                            $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                            $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                            if ($remind_send_res > 0) {
                                $send_state = 1;
                                $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                $add_remind['mrlo_state'] = 2;//未充值，
                                $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                            } else {
                                $send_state = 2;
                            }
                            // 短信模块日志
                            $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                            $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                            $seme_data['seme_wor_id'] = 0; //订单id
                            $seme_data['seme_name'] = '短信不足预警'; //模板名称
                            $seme_data['seme_phone'] = $remind_phone; //手机号
                            $seme_data['seme_content'] = $remind_content; //内容
                            $seme_data['seme_row'] = 1; //条数
                            $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                            $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                            $seme_data['seme_ip'] = $request['ip']; //ip地址
                            $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                            $seme_id = DB::table('send_message')->insert($seme_data);
                        }
                        $send_res = sendSmsCode($phone, $message);
                        if ($send_res > 0) {
                            $send_state = 1;
                            $update_shop = DB::table('shop')
                                ->where('shop_id', $user_info->adm_shop_id)
                                ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                        } else {
                            $send_state = 2;
                        }
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = $ord_id; //订单id
                    $seme_data['seme_name'] = '会员卡消费通知'; //模板名称
                    $seme_data['seme_phone'] = $phone; //手机号
                    $seme_data['seme_content'] = $message; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);
                    $find_member = DB::table('member')
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $phone)
                        ->first();
                    $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                    $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                    $add_log['smlo_mem_phone'] = $phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_state'] = $send_state;
                    $add_log['smlo_msg_type'] = 4;
                    $add_log['smlo_num'] = 1;
                    $add_log['smlo_content'] = $message; //内容
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                }
            }
        }
        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_phone', $request['orcl_phone'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            // if ($request['ord_type'] == 1) { //买家类型：1会员零售
            //     // 零售，会员表
            //     $client_res = DB::table('member')
            //         ->where('mem_id', $request['ord_client_id'])
            //         ->increment('mem_order_all');
            //     $weus_id = $find_weixin_data->weus_id;
            // } else {
            //     $client_res = true;
            // }
        } else {
            if ($data['ord_type'] == 2) { //买家类型：2企业客户
                // 1. 判断企业客户账号名称是否存在
                $find_buac = DB::table('business_account')
                    ->where('buac_bucl_id', $request['orcl_business_id'])
                    ->where('buac_name', $request['orcl_name'])
                    ->first(['buac_id']);
                if ($find_buac) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'客户名称已存在，生成订单失败'];
                }

                // 2 新增一个企业会员账号
                $add_buac_data['buac_shop_id'] = $user_info->adm_shop_id;
                $add_buac_data['buac_cid'] = $user_info->adm_cid;
                $add_buac_data['buac_name'] = $request['orcl_name'];
                $add_buac_data['buac_phone'] = $request['orcl_phone'];
                $add_buac_data['buac_bucl_id'] = $request['orcl_business_id'];
                $add_buac_data['buac_create_adm_id'] = $user_info->adm_id;
                $add_buac_data['buac_create_time'] = date('Y-m-d H:i:s');
                $buac_res =  DB::table('business_account')->insertGetId($add_buac_data);
            } elseif ($data['ord_type'] == 1) {//买家类型：1零售会员
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_create_id'] = $user_info->adm_id;
                $eme['mem_create_name'] = $user_info->adm_name;
                $eme['mem_name'] = $request['orcl_name'] ? $request['orcl_name'] : '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code"=>500, 'msg'=>'error', 'data'=>'当前手机号已存在'];
                    }
                }
                $eme['mem_phone'] = $request['orcl_phone'] ? $request['orcl_phone'] : '';
                $eme['mem_source'] = $request['orcl_mem_source'] ? $request['orcl_mem_source'] : '';//来源
                $eme['mem_car_num'] = $request['orcl_car_num'] ? $request['orcl_car_num'] : '';
                $eme['mem_order_all'] = 1; //订单数
                $mem_id = MemberService::addMember($eme);
                // $mem_id = DB::table('member')->insertGetId($eme);
                self::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;
                $client_res = true;

                if (empty($find_weixin_data)) {
                    // 不存在就新增用户
                    $weus_data['weus_openid'] = $mem_id;
                    $weus_data['weus_phone'] = $request['orcl_phone'];
                    $weus_data['weus_nickmame'] = $request['orcl_name'];
                    $weus_data['weus_follow'] = 1;
                    $weus_data['weus_sex'] = 0;
                    $weus_data['weus_province'] = '';
                    $weus_data['weus_city'] = '';
                    $weus_data['weus_headimgurl'] = '';
                    $weus_data['weus_update_time'] = date('Y-m-d H:i:s');
                    $weus_id = DB::table('weixin_user')->insertGetId($weus_data);
                    if (!$weus_id) {
                        return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
                    }
                    unset($weus_data['weus_update_time']);
                } else {
                    // 更新微信用户信息
                    $edit_weus['weus_phone'] = $request['orcl_phone'];
                    $edit_weus['weus_nickmame'] = $request['orcl_name'];
                    if (!empty($request['weus_headimgurl'])) {
                        $edit_weus['weus_headimgurl'] = $request['weus_headimgurl'];
                    }
                    $edit_weus['weus_update_time'] = date('Y-m-d H:i:s');
                    $edit_weus_res = DB::table('weixin_user')
                        ->where('weus_id', $find_weixin_data->weus_id)
                        ->update($edit_weus);
                    unset($edit_weus);
                    $weus_id = $find_weixin_data->weus_id;
                }

                // 查询微信用户与门店的关系是否存在绑定关系
                $find_user_shop_data = DB::table('user_shop')
                    ->where('ussh_weus_id', $weus_id)
                    ->where('ussh_shop_id', $user_info->adm_shop_id)
                    ->select('ussh_id', 'ussh_user_id', 'ussh_user_type', 'ussh_phone')
                    ->first();

                if (empty($find_user_shop_data)) {
                    // 用户没有与当前门店绑定，把用户与当前门店绑定
                    $ussh_data['ussh_user_id'] = $mem_id;
                    $ussh_data['ussh_weus_id'] = $weus_id;
                    $ussh_data['ussh_shop_id'] = $user_info->adm_shop_id;
                    $ussh_data['ussh_user_type'] = 1;
                    $ussh_data['ussh_phone'] = $request['orcl_phone'];
                    $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                    $ussh_id = DB::table('user_shop')->insertGetId($ussh_data);
                    if (!$ussh_id) {
                        return ['code'=>500, 'msg'=>'新增失败2', 'data'=>''];
                    }
                } else {
                    if (empty($find_user_shop_data->ussh_user_id)) {
                        $ussh_data['ussh_user_type'] = 1;
                        $ussh_data['ussh_phone'] = $request['orcl_phone'];
                        $ussh_data['ussh_create_time'] = date('Y-m-d H:i:s');
                        $ussh_id = DB::table('user_shop')
                            ->where('ussh_id', $find_user_shop_data->ussh_id)
                            ->update($ussh_data);
                    }
                }
            }
        }
        if (!empty($request['orcl_car_num'])) {
            $isCarLicense = isCarLicense($request['orcl_car_num']);// 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code'=>500, 'msg'=>'车牌照格式不正确', 'data'=>''];
            }
        }

        if ($request['ord_type'] == 3) {
            $request['orcl_name'] = '散户';
            $request['orcl_phone'] = '';
            $ord_edit_data['ord_wor_state'] = 20;
        }
        $mem_address = [];
        if($data['ord_type'] == 1 && !empty($data['ord_client_id'])){
            $mem_address = DB::table('member')
                ->where('mem_id', $request['ord_client_id'])
                ->select('mem_province', 'mem_city', 'mem_county','mem_address')
                ->first();
        }else if($data['ord_type'] == 2 && isset($request['orcl_business_id']) && !empty($request['orcl_business_id'])){
            $mem_address = DB::table('business_client')
                ->where('bucl_id', $request['orcl_business_id'])
                ->select('bucl_province as mem_province','bucl_city as mem_city','bucl_county as mem_county','bucl_address as mem_address')
                ->first();
        }
        if(!empty($mem_address)){
            $mem_province = isset($request['orcl_province']) ? $request['orcl_province'] : $mem_address->mem_province;
            $mem_city = isset($request['orcl_city']) ? $request['orcl_city'] : $mem_address->mem_city;
            $mem_county = isset($request['orcl_county']) ? $request['orcl_county'] : $mem_address->mem_county;
            $orcl_address = isset($request['orcl_address']) ? $request['orcl_address'] : $mem_address->mem_address;
        }else{
            $mem_province = isset($request['orcl_province'])??'';
            $mem_city = isset($request['orcl_city'])??'';
            $mem_county = isset($request['orcl_county'])??'';
            $orcl_address = isset($request['orcl_address'])??'';
        }
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_name' => $request['orcl_name'],
            'orcl_carowner_name' => $request['orcl_name'],
            'orcl_phone' => $request['orcl_phone'],
            'orcl_sales_adm_id'=>isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '',
            'orcl_carowner_phone' => $request['orcl_phone'],
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',//车牌号
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '',
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '',
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1,
            'orcl_province' => $mem_province,
            'orcl_city' => $mem_city,
            'orcl_county' => $mem_county,
            'orcl_address' => $orcl_address,
            'orcl_shipment_party' => isset($request['orcl_shipment_party']) ? $request['orcl_shipment_party'] : 1, //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_update_time' => date('Y-m-d H:i:s'),
            'orcl_appoint_time' => empty($request['orcl_appoint_time']) ? '0000-00-00 00:00:00':$request['orcl_appoint_time'],
        ];
        if (isset($request['orcl_sales_adm_id']) && $request['orcl_sales_adm_id']) {
            $get_performance_type = DB::table('goods_performance_type')
                ->where('gpt_sale_adm_id', $request['orcl_sales_adm_id'])
                ->where('gpt_state', 1)
                ->first();
            if ($get_performance_type) {
                if ($get_performance_type->gpt_type == 2) {
                    $get_performance = DB::table('goods_performance')
                        ->where('gppe_type', 3)
                        ->where('gppe_performance', '>', 0)
                        ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                        ->first();
                    if ($get_performance) {
                        $ord_edit_data['ord_saleman_type'] = $get_performance->gppe_goo_id;
                        if ($get_performance->gppe_goo_id == 1) {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        } else {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        }
                    }
                }
            }
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $ord_actual_price = $order_amount*100;
        if ($request['ord_payment_way'] == 6 ||$request['ord_payment_way'] == 7) {//使用余额支付
            if ($request['ord_payment_way'] == 6) {
                $request['mem_id'] = $request['ord_client_id'];
            }
            $find_mem = DB::table('member')
                ->where('mem_id', $request['mem_id'])
                ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                ->first();
            $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
            if (($request['ord_payment_way'] == 6 ||$request['ord_payment_way'] == 7) && $banlance == 0) {
                return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
            }
            if ($ord_actual_price >= $banlance) {//余额不足
                if (empty($request['ord_other_payway'])) {
                    return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                }
                $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                $ord_edit_data['ord_payment_money'] = $ord_actual_price - $banlance;
                $ord_edit_data['ord_banlance'] = $banlance;
                // 消费记录
                $add_rec_log['relo_type'] = 2;
                $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                $add_rec_log['relo_gift_num'] = $find_mem->mem_gift_banlance;
                $add_rec_log['relo_mem_id'] = $request['mem_id'];
                $add_rec_log['relo_ord_id'] = $ord_id;
                $add_rec_log['relo_remark'] = '订单消费';
                $add_rec_log['relo_create_id'] = $user_info->adm_id;
                $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                $update_mem['mem_rec_banlance'] = 0;
                $update_mem['mem_gift_banlance'] = 0;
            } elseif ($ord_actual_price < $banlance) {
                $ord_edit_data['ord_payment_money'] = 0;
                $ord_edit_data['ord_banlance'] = $ord_actual_price;
                // 消费记录
                $add_rec_log['relo_type'] = 2;
                if ($find_mem->mem_rec_banlance >= $ord_actual_price) {
                    $add_rec_log['relo_rec_num'] = $ord_actual_price;
                    $add_rec_log['relo_gift_num'] = 0;
                    $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $ord_actual_price;
                } else {
                    $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $ord_actual_price - $find_mem->mem_rec_banlance;
                    $update_mem['mem_rec_banlance'] = 0;
                    $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($ord_actual_price - $find_mem->mem_rec_banlance);
                }
                $add_rec_log['relo_mem_id'] = $request['mem_id'];
                $add_rec_log['relo_ord_id'] = $ord_id;
                $add_rec_log['relo_remark'] = '订单消费';
                $add_rec_log['relo_create_id'] = $user_info->adm_id;
                $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
            }
            $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
            $update_mem_res = DB::table('member')->where('mem_id', $request['mem_id'])->update($update_mem);
            $request['ord_actual_amout'] = 0;//洗车单使用余额支付，实际付款金额为0
            $outstanding_amount = 0;
        } elseif ($request['ord_payment_way'] == 9) {//部分结款
            $ord_edit_data['ord_payment_money'] = $request['ord_actual_amout']*100;
            $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
            $ord_edit_data['ord_banlance'] = 0;
            $outstanding_amount = $ord_actual_price - $request['ord_actual_amout']*100;
        } elseif ($request['ord_payment_way'] == 5) {//会员卡
            $ord_edit_data['ord_payment_money'] = $ord_use_vip_price*100;
            $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
            $ord_edit_data['ord_banlance'] = 0;

            if ($request['ord_other_payway'] == 6 || $request['ord_other_payway'] ==7) {//余额 他人代付
                if ($request['ord_other_payway'] == 6) {
                    $request['mem_id'] = $request['ord_client_id'];
                }
                $find_mem = DB::table('member')
                    ->where('mem_id', $request['mem_id'])
                    ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                    ->first();
                $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;

                if (($request['ord_other_payway'] == 6 ||$request['ord_other_payway'] == 7) && $banlance == 0) {
                    return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
                }
                if ($ord_actual_price >= $banlance) {//余额不足
                    return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                } elseif ($ord_actual_price < $banlance) {
                    $ord_edit_data['ord_banlance'] = $ord_actual_price;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    if ($find_mem->mem_rec_banlance >= $ord_actual_price) {
                        $add_rec_log['relo_rec_num'] = $ord_actual_price;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $ord_actual_price;
                    } else {
                        $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $ord_actual_price - $find_mem->mem_rec_banlance;
                        $update_mem['mem_rec_banlance'] = 0;
                        $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($ord_actual_price - $find_mem->mem_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $ord_id;
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('member')->where('mem_id', $request['mem_id'])->update($update_mem);
                $request['ord_actual_amout'] = 0;//洗车单使用余额支付，实际付款金额为0
                $outstanding_amount = 0;
            }
            //添加支付明细
            if(!in_array($request['ord_other_payway'], [0,8]) && $ord_actual_price != 0) {
                OrderSettlementDetails::addOrderSettlementDetails($ord_id, $data['ord_type'], $request, $user_info, $order_amount*100, $ord_edit_data['ord_banlance'],$request['ord_other_payway']);
                $outstanding_amount = 0;
            } else {
                $outstanding_amount = $ord_actual_price;
            }
        } elseif (in_array($request['ord_payment_way'], [1,2,3,4])) {
            $ord_edit_data['ord_payment_money'] = $ord_actual_price;
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = $ord_actual_price;
            $outstanding_amount = 0;
        } elseif (in_array($request['ord_payment_way'], [0,8])) {
            $ord_edit_data['ord_payment_money'] = 0;
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = 0;
            $outstanding_amount = $ord_actual_price;
        }
        if ($data['ord_type'] == 1) {//会员
            $find_mem = DB::table('member')
                ->where('mem_id', $request['ord_client_id'])
                ->select('mem_arrears')
                ->first();
            $update_data_mem['mem_arrears'] = $find_mem->mem_arrears + $outstanding_amount;
            $update_data_mem['mem_update_time'] = date('Y-m-d H:i:s');
            $update_data_mem_res = DB::table('member')->where('mem_id', $request['ord_client_id'])->update($update_data_mem);
        } elseif ($data['ord_type'] == 2) {
            $find_mem = DB::table('business_account')
                ->leftJoin('business_client', 'bucl_id', '=', 'buac_bucl_id')
                ->where('buac_id', $request['ord_client_id'])
                ->select('buac_arrears', 'buac_bucl_id', 'bucl_arrears')
                ->first();
            $update_data_mem['buac_arrears'] = $find_mem->buac_arrears + $outstanding_amount;
            $update_data_mem['buac_update_time'] = date('Y-m-d H:i:s');
            $update_data_mem_res = DB::table('business_account')->where('buac_id', $request['ord_client_id'])->update($update_data_mem);
            
            $update_bucl['bucl_arrears'] = $find_mem->bucl_arrears + $outstanding_amount;
            $update_bucl['bucl_update_time'] = date('Y-m-d H:i:s');
            $update_bucl_res = DB::table('business_client')->where('bucl_id', $find_mem->buac_bucl_id)->update($update_bucl);
        }
        if ($ord_add_work_state == 1) {//生成工单
            $find_imco = DB::table('image_config')
                ->where('imco_type', 1)
                ->get()->toArray();
            foreach ($find_imco as $kf => $vf) {
                $add_imdata['vaca_shop_id'] = $user_info->adm_shop_id;
                $add_imdata['vaca_ord_id'] = $ord_id;
                $add_imdata['vaca_type'] = 1;
                $add_imdata['vaca_name'] = $vf->imco_name;
                $add_imdata['vaca_data_id'] = $vf->imco_id;
                if (in_array($vf->imco_id, $image_id)) {
                    $add_imdata['vaca_must'] = 1;
                } else {
                    $add_imdata['vaca_must'] = 2;
                }
                $add_imdata['vaca_create_time'] = date('Y-m-d H:i:s');
                $add_imdata['vaca_create_id'] = $user_info->adm_id;
                $im_res = DB::table('wash_validate_car')->insert($add_imdata);
            }

            $find_com_img = DB::table('image_config')
                ->where('imco_type', 2)
                ->get()->toArray();
            foreach ($find_com_img as $kf => $vf) {
                $add_comdata['coin_shop_id'] = $user_info->adm_shop_id;
                $add_comdata['coin_ord_id'] = $ord_id;
                $add_comdata['coin_type'] = 3;
                $add_comdata['coin_name'] = $vf->imco_name;
                $add_comdata['coin_data_id'] = $vf->imco_id;
                $add_comdata['coin_create_time'] = date('Y-m-d H:i:s');
                $add_comdata['coin_create_id'] = $user_info->adm_id;
                if (in_array($vf->imco_id, $image_id)) {
                    $add_comdata['coin_must'] = 1;
                    $co_res = DB::table('completion_info')->insert($add_comdata);
                }
            }
        }
        // 不生成工单流程
        if ($ord_add_work_state == 2) {
            // 买家类型：1门店零售2客户单位3速电派单4第三方派单5运营中心给门店派单
            // 判断是否为散户，ord_type为空值，是散户
            if (empty($request['ord_type'])) {
                // 散户开单流程
                $order_data['data']['ord_order_number'] = $ord_order_number;
                $order_data['data']['ord_id'] = $ord_id;
                $order_data['data']['shop_id'] = $user_info->adm_shop_id;
                $order_data['data']['ord_type'] = 0;
                $order_data['data']['ord_client_id'] = 0;
                if ($request['ware_id'] && $is_goods) {//选择仓库并且选择产品
                    $ord_edit_data['ord_wor_state'] = 2;//服务中
                    $request['service_shop_id'] = $user_info->adm_shop_id;
                    $dibi_data = DispatchBill::create(
                        $user_info,   //用户信息
                        $request,  //订单提交数据
                        $new_goods_data,  //提交的商品数据
                        1,  //类型：1.订单发货 2.工单发货
                        $request['ware_id'],  //出库仓库id
                        $order_data['data']['ord_order_number'],  //原始单号，订单号/工单号
                        $order_data['data']['ord_id'],  //发货单关联的工单/订单id
                        $order_data['data']['shop_id'],  //所属总店id
                        $order_data['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $order_data['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                        $new_goo_all_quantity  //发货总数量
                    );
                    if ($dibi_data['code'] == 500) {
                        return $dibi_data;
                    }
                } else {
                    $ord_edit_data['ord_wor_state'] = 20;//已完成
                }
            } else {
                // 不是散户，未选择产品或未选择仓库，生成订单，订单状态为待评价状态
                // 不是散户，选择产品并且选择仓库，生成订单，订单状态是服务中，生成发货单
                $order_data['data']['ord_order_number'] = $ord_order_number;
                $order_data['data']['ord_id'] = $ord_id;
                $order_data['data']['shop_id'] = $user_info->adm_shop_id;
                $order_data['data']['ord_type'] = $request['ord_type'];
                $order_data['data']['ord_client_id'] = 0;
                if ($request['ware_id'] && $is_goods) {//选择仓库并且选择产品
                    $ord_edit_data['ord_wor_state'] = 2;//服务中
                    $request['service_shop_id'] = $user_info->adm_shop_id;
                    $dibi_data = DispatchBill::create(
                        $user_info,   //用户信息
                        $request,  //订单提交数据
                        $new_goods_data,  //提交的商品数据
                        1,  //类型：1.订单发货 2.工单发货
                        $request['ware_id'],  //出库仓库id
                        $order_data['data']['ord_order_number'],  //原始单号，订单号/工单号
                        $order_data['data']['ord_id'],  //发货单关联的工单/订单id
                        $order_data['data']['shop_id'],  //所属总店id
                        $order_data['data']['ord_type'],  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $order_data['data']['ord_client_id'],  //选择的客户id,会员id/单位id
                        $new_goo_all_quantity  //发货总数量
                    );
                    if ($dibi_data['code'] == 500) {
                        return $dibi_data;
                    }
                } else {
                    $ord_edit_data['ord_wor_state'] = 4;//待评价
                    if (empty($request['orcl_phone'])) {
                        $ord_edit_data['ord_wor_state'] = 20;//已完成
                    }
                    
                }
            }
            $ord_edit_data['ord_service_type'] = 2;//洗车-不生成工单的订单
        }

        //添加支付明细
        if(!in_array($request['ord_payment_way'], [0,8])) {
            OrderSettlementDetails::addOrderSettlementDetails($ord_id, $data['ord_type'], $request, $user_info, $ord_edit_data['ord_payment_money'], $ord_edit_data['ord_banlance']);
        }

//        $order_settlement_details['orsd_ord_id'] = $ord_id;
//        if ($request['ord_payment_way'] == 9) {
//            $order_settlement_details['orsd_payment_way'] = $request['ord_other_payway'];
//        } else {
//            $order_settlement_details['orsd_payment_way'] = $request['ord_payment_way'];
//        }
//        $order_settlement_details['orsd_pay_money'] = $request['ord_actual_amout']*100;
//        $order_settlement_details['orsd_create_id'] = $user_info->adm_id;
//        $order_settlement_details['orsd_create_time'] = date('Y-m-d H:i:s');
//        $typeName = self::getPaymentWayName(true);//获取支付方式名称
//        $ord_payment_name = self::getTypeData($request['ord_other_payway'], $typeName);
//        $order_settlement_details['orsd_payment_way_name'] = $ord_payment_name;
//        $sede_res = DB::table('order_settlement_details')->insertGetId($order_settlement_details);
        foreach ($goods_data as $key => $value) {
            $orgo_data[$key]['orgo_ord_id'] = $ord_id;
            $orgo_data[$key]['orgo_order_number'] = $ord_order_number;
            $orgo_data[$key]['orgo_goo_id'] = $value['goo_id'];
            $orgo_data[$key]['orgo_goo_name'] = $value['goo_name'];
            $orgo_data[$key]['orgo_goo_type'] = $value['goo_type'];
            $orgo_data[$key]['orgo_goo_price'] = $value['goo_price']*100;
            $orgo_data[$key]['orgo_goo_amount'] = $value['goo_price']*100*$value['goo_quantity'];
            $orgo_data[$key]['orgo_goo_use_vip_num'] = $value['use_vip_num'];
            $orgo_data[$key]['orgo_state'] = 1;
            $orgo_data[$key]['orgo_goo_quantity'] = $value['goo_quantity'];
            $orgo_data[$key]['orgo_goo_inventory'] = 1;
            $orgo_data[$key]['orgo_goo_unit'] = $value['goo_unit'];
            $orgo_data[$key]['orgo_goo_unta_id'] = $value['goo_unta_id'];
            $orgo_goo_point = 0;
            if (!empty($request['orcl_sales_adm_id'])) {
                $gppe_performance = DB::table('goods_performance')
                    ->where('gppe_shop_id', $user_info->adm_shop_id)
                    ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                    ->where('gppe_type', $orgo_data[$key]['orgo_goo_type'])
                    ->where('gppe_goo_id', $value['goo_id'])
                    ->value('gppe_performance');
                $orgo_data[$key]['orgo_sale_performance'] = $gppe_performance??0;
            } else {
                $orgo_data[$key]['orgo_sale_performance'] = 0;
            }
            $orgo_goo_point = DB::table('point_goods')  
                ->where('pogo_shop_id', $user_info->adm_shop_id)
                ->where('pogo_goo_type', $value['goo_type'])
                ->where('pogo_goo_id', $value['goo_id'])
                ->value('pogo_goo_point');
            $orgo_data[$key]['orgo_goo_point'] = $orgo_goo_point;
        }
        $orgo_id = DB::table('order_goods')->insert($orgo_data);
        //计算会员消费总金额
        if($request['ord_type'] == 1 && !empty($request['ord_client_id'])){
            WashOrderService::consume_money($request['ord_client_id']);
        }
        //20230724  添加订单应收应付
        $recpay_receivable_price = $ord_order_price * 100;//应收金额
        $recpay_actual_price = $order_amount*100;//默认实收金额为0
        $recpay_arrears_price = $recpay_receivable_price - $recpay_actual_price;//欠收金额 = 应收金额 - 实收金额
        //支付方式为1.现金2.支付宝 3微信 4银行卡  的实收金额
        if(in_array($request['ord_payment_way'],[6,7])){
            $recpay_actual_price = 0;//实收金额
            $recpay_arrears_price = 0;//欠收金额
        } elseif ($request['ord_payment_way'] == 5) {//会员卡
            $recpay_actual_price = $order_amount*100;//实收金额
            $recpay_arrears_price = 0;//欠收金额
        } else if($request['ord_payment_way'] > 0){
            $recpay_actual_price = $recpay_receivable_price ;//实收金额
            $recpay_arrears_price = 0;//欠收金额
        }
        $recpay_cost_price = 0;//成本价
        $profit = $recpay_actual_price - $recpay_cost_price;
        if($profit > 0){
            $minus = 1;
        }else{
            $minus = 2;
            $profit = abs($profit);
        }
        $rece_params = [
            'recpay_type'=>1,//类型：1销售订单2充值卡
            'recpay_original_id'=>$ord_id,//订单id
            'recpay_original_number'=>$ord_order_number,//订单号
            'recpay_client_type'=>isset($request['ord_type']) ? $request['ord_type'] : 1,
            'recpay_client_id'=>$request['ord_client_id'],//客户id
            'recpay_client_name'=>$request['orcl_name'],
            'recpay_receivable_price'=>$ord_order_price*100,//应收金额
            'recpay_arrears_price'=>$recpay_arrears_price,//欠收金额
            'recpay_actual_price'=>$recpay_actual_price,//实收金额
            'recpay_cost_price'=>$recpay_cost_price,//成本价
            /*'recpay_receivable_pay'=>0,//应付金额
            'recpay_actual_pay'=>0,//实付金额*/
            'recpay_state'=>1,//状态：1未确认2已确认
            'recpay_order_state'=>1,//订单状态：1正常2退款3取消
            'recpay_plus_minus'=>$minus,//盈利正负：1正值2负值
            'recpay_profit'=>$profit,//盈利金额
            'recpay_orcl_id'=>$orcl_id,//订单客户id
            'recpay_source'=>static::getOrdsource($request),//下单来源：1pc端2车主端(车主小程序)3技师端4合作商5智配贴装
        ];
        $ord_data = DB::table('order')
            ->where('ord_id', $ord_id)
            ->select('ord_state', 'ord_wor_state', 'ord_type', 'ord_client_id')
            ->first();
        if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1) {//已结算 待评价或已完成 个人会员 添加积分
            $add_point = WashOrderBasicService::addPoint($user_info,$ord_data->ord_client_id,$ord_id);
        }
        // 施工说明图片
        if (isset($request['ord_explain_pic']) && !empty($request['ord_explain_pic'])) {
            foreach ($request['ord_explain_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 2;
                $add_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }
        // 订单凭证图片
        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pz_pic[$key]['orvp_image'] = $value;
                $add_pz_pic[$key]['orvp_type'] = 1;
                $add_pz_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pz_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pz_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pz_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pz_pic_res = DB::table('order_voucher_pic')->insert($add_pz_pic);
        }
        $ord_edit_data['ord_add_work_state'] = $ord_add_work_state;
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_data['ord_client_id'] = $request['ord_client_id'];
        $ord_edit_res = NewOrderService::editOrder($ord_id,$ord_edit_data);
        ReceivablePayService::add($rece_params);
        if ($ord_id && $orcl_id && $ord_edit_res && $orgo_id) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['ord_type'] = $request['ord_type']; //买家类型1.会员零售2.企业客户3散户
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }
    

    // 扫码会员二维码
    public static function scan($user_info, $request)
    {
        $find_vico = DB::table('vip_code as vico')
            ->leftJoin('myvip as m', 'm.myvi_id', '=', 'vico.vico_myvi_id')
            ->leftJoin('service_project as s', 's.sepr_id', '=', 'm.myvi_sepr_id')
            ->leftJoin('member as mem', 'mem.mem_id', '=', 'm.myvi_adm_id')
            ->where('vico_id', $request['vico_id'])
            ->select('vico_end_time', 'myvi_surplus_times', 'mem_name', 'mem_phone', 'mem_car_num', 'mem_source', 'mem_car_series', 'myvi_name', 'myvi_end_time', 'vico_state', 'mem_id', 'myvi_id', 'myvi_shop_id')
            ->first();
        if (empty($find_vico)) {
            return ["code"=>500, 'msg'=>'未查询到二维码信息', 'data'=>'未查询到二维码信息'];
        }
        if (strtotime($find_vico->vico_end_time) < time()) {
            return ["code"=>500, 'msg'=>'二维码已过期', 'data'=>'二维码已过期'];
        }
        if ($find_vico->myvi_shop_id != $user_info->adm_shop_id) {
            return ["code"=>500, 'msg'=>'不是本店会员卡', 'data'=>'不是本店会员卡'];
        }
        if ($find_vico->vico_state == 2) {
            return ["code"=>500, 'msg'=>'二维码已失效', 'data'=>'二维码已失效'];
        }
        if (strtotime($find_vico->myvi_end_time) < time()) {
            return ["code"=>500, 'msg'=>'会员卡已过期', 'data'=>'会员卡已过期'];
        }
        if ($find_vico->myvi_surplus_times == 0) {
            return ["code"=>500, 'msg'=>'会员卡已无可用次数', 'data'=>'会员卡已无可用次数'];
        }
        $detail = DB::table('myvip_detail')
            ->where('myvid_mvid', $find_vico->myvi_id)
            ->where('myvid_surplus_times','>',0)
            ->get()->toArray();
        foreach ($detail as $key => $value) {
            if ($value->myvid_type == 2) {//服务
                $detail[$key]->goo_unta_id = 0;
                $detail[$key]->goo_unit = '次';
                $detail[$key]->sepr_work_type = DB::table('service_project')
                    ->where('sepr_id', $value->myvid_data_id)
                    ->value('sepr_work_type');
            } else {
                $unit = DB::table('goods')
                    ->where('goo_id', $value->myvid_data_id)
                    ->select('goo_unit', 'goo_unta_id')
                    ->first();
                $detail[$key]->goo_unit = !empty($unit) ? $unit->goo_unit:'';
                $detail[$key]->goo_unta_id = !empty($unit) ? $unit->goo_unta_id:'';
                $detail[$key]->sepr_work_type = 2;
            }
            $detail[$key]->use_num = 1;
        }
        $find_vico->detail = $detail;
        return ["code"=>200, 'msg'=>'扫码成功', 'data'=>$find_vico];
    }

    // 查询会员卡
    public static function getmyVip($user_info, $request)
    {
        if (isset($request['mem_phone'])) {
            $request['user_id'] = DB::table('member')
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->where('mem_phone', $request['mem_phone'])
                ->value('mem_id');
        }
        if (empty($user_info->ussh_user_id) && !isset($request['user_id'])) {
            return ["code"=>4000, 'msg'=>'未查询到该会员卡!', 'data'=>'未查询到该会员卡!'];
        }
        $pait_data = [];
        $service_project = [];
        $goods_id = [];
        if (isset($request['pait_id'])) {
            $pait_data = DB::table('correlation_goods as cogo')
                ->leftJoin('package_items as pait', 'pait.pait_id', '=', 'cogo.cogo_pait_id')
                ->where('cogo_pait_id', $request['pait_id'])
                ->select('cogo_goo_id', 'cogo_goo_type', 'cogo_goo_quantity')
                ->get()->toArray();
            $goods_data = [];
            // cogo_goo_type商品类型1商品2服务项目
            foreach ($pait_data as $key => $value) {
                $goods_data[$key]['goo_num'] = $value->cogo_goo_quantity;
                $goods_data[$key]['goo_type'] = $value->cogo_goo_type;
                $goods_data[$key]['goo_id'] = $value->cogo_goo_id;
                if ($value->cogo_goo_type == 1) {
                    $goods_id[] = $value->cogo_goo_id;
                }
                if ($value->cogo_goo_type == 2) {
                    $service_project[] = $value->cogo_goo_id;
                }
            }
        } elseif (isset($request['pait_id']) && !isset($request['user_id'])) {
            return ["code"=>4000, 'msg'=>'未查询到该会员卡', 'data'=>'未查询到该会员卡'];
        }
        if (!isset($request['pait_id'])) {
            $goods_data = $request['goods_data'];
            foreach ($goods_data as $key => $value) {
                if ($value['goo_type'] == 2) {//服务
                    $service_project[] = $value['goo_id'];
                }
                if ($value['goo_type'] == 1) {//商品
                    $goods_id[] = $value['goo_id'];
                }
            }
        }
        $find_myvi_data = DB::table('myvip as myvi')
            ->leftJoin('member as mem', 'mem.mem_id', '=', 'myvi.myvi_adm_id')
            ->leftJoin('myvip_detail as md', 'md.myvid_mvid', '=', 'myvi.myvi_id')
            ->where(function ($query) use ($user_info) { //会员卡持有人
                if (!empty($user_info->ussh_user_id)) {
                    $query->where('myvi_adm_id', $user_info->ussh_user_id);
                }
            })
            ->where(function ($query) use ($request) { //会员卡持有人
                if (!empty($request['user_id'])) {
                    $query->where('myvi_adm_id', $request['user_id']);
                }
            })
            ->where(function ($query) use ($request) { //会员卡持有人
                if (!empty($request['myvi_name'])) {
                    $query->where('myvi_name', 'like','%'.$request['myvi_name'].'%');
                }
            })
            ->where(function ($query) use ($service_project,$goods_id) { //会员卡持有人
                if (!empty($service_project) && !empty($goods_id)) {
                    $query->where('myvid_type', 2)
                        ->whereIn('myvid_data_id',$service_project)
                        ->orwhere('myvid_type', 1)
                        ->whereIN('myvid_data_id',$goods_id);
                } elseif (!empty($service_project) && empty($goods_id)) {
                    $query->where('myvid_type', 2)
                        ->whereIn('myvid_data_id',$service_project);
                } elseif (empty($service_project) && !empty($goods_id)) {
                    $query->where('myvid_type', 1)
                        ->whereIn('myvid_data_id',$goods_id);
                }
            })
            ->where('myvid_surplus_times', '>',0)
            ->where('myvi_state', 1)
            ->where('myvi_end_time', '>', date('Y-m-d H:i:s'))
            ->select('myvi_id', 'myvi_surplus_times', 'myvi_name', 'myvi_end_time', 'myvi_long_term', 'mem_name', 'mem_phone', 'md.*')
            ->groupBy('myvi_id')
            ->get()->toArray();
        $myvi_id = array_unique(array_column($find_myvi_data,'myvi_id'));
        $i=0;
        foreach ($find_myvi_data as $key => $value) {
            $detail = DB::table('myvip as myvi')
                ->leftJoin('member as mem', 'mem.mem_id', '=', 'myvi.myvi_adm_id')
                ->leftJoin('myvip_detail as md', 'md.myvid_mvid', '=', 'myvi.myvi_id')
                ->where('myvi_id',$value->myvi_id)
                ->where('myvid_surplus_times','>',0)
                ->select('md.*')
                ->get()->toArray();
            if (!empty($detail)) {
                foreach ($detail as $k => $v) {
                    if ($v->myvid_type == 1) {
                        $goo_unit = DB::table('goods')
                            ->where('goo_id', $v->myvid_data_id)
                            ->value('goo_unit');
                    } else {
                        $goo_unit = '';
                    }
                    if ($goo_unit) {
                        $detail[$k]->myvid_data_name = $v->myvid_data_name.'('.$goo_unit.')';
                    }
                }
            }
            if (isset($request['type']) && $request['type'] == 2) {
                foreach ($goods_data as $k1 => $v1) {
                    $use_vip = false;
                    if (isset($v1['num'])) {
                        $v1['goo_num'] = $v1['num'];
                    }
                    foreach ($detail as $k => $v) {
                        if ($v->myvid_type == $v1['goo_type'] && $v->myvid_data_id == $v1['goo_id'] && $v1['goo_num'] <= $v->myvid_surplus_times) {
                            $use_vip = true;
                        }
                    }
                    if (!$use_vip) {
                        break;
                    } 
                }
            } else {
                $use_vip = true;
            }
            if ($use_vip) {
                $new_data[$i]['myvi_id'] = $value->myvi_id;
                $new_data[$i]['myvi_name'] = $value->myvi_name;
                $new_data[$i]['myvi_end_time'] = $value->myvi_end_time;
                $new_data[$i]['myvi_long_term'] = $value->myvi_long_term;
                $new_data[$i]['mem_name'] = $value->mem_name;
                $new_data[$i]['mem_phone'] = $value->mem_phone;
                $new_data[$i]['detail'] = $detail;
                $i++;
            }
        }
        if (empty($new_data)) {
            return ["code"=>4000, 'msg'=>'未查询到可用会员卡', 'data'=>'未查询到可用会员卡'];
        }
        return ["code"=>200, 'msg'=>'获取成功', 'data'=>$new_data];
    }

    // 领取洗车订单
    public static function receiveOrder($user_info, $request)
    {
        $find_order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_service_type', 'ord_wor_state', 'ord_id')
            ->first();
        if (empty($find_order_data)) {
            return ["code"=>500, 'msg'=>'订单不存在', 'data'=>'订单不存在'];
        }
        if ($find_order_data->ord_service_type != 2) {//订单类型：1服务单 2洗车单3商品单
            return ["code"=>500, 'msg'=>'订单类型不是洗车单', 'data'=>'订单类型不是洗车单'];
        }
        if ($find_order_data->ord_wor_state != 1) {//订单类型：1服务单 2洗车单3商品单
            return ["code"=>500, 'msg'=>'订单不是待领取状态', 'data'=>'订单不是待领取状态'];
        }
        $update_data['ord_wor_state'] = 4;
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($update_data);
        if ($update_res) {
            return ["code"=>200, 'msg'=>'领取成功', 'data'=>'领取成功'];
        } else {
            return ["code"=>500, 'msg'=>'领取失败', 'data'=>'领取失败'];
        }
    }

    // 订单结算
    public function oldsettlement($user_info, $request)
    {
        $find_order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_state')
            ->first();
        if (empty($find_order_data)) {
            return ["code"=>500, 'msg'=>'订单不存在', 'data'=>'订单不存在'];
        }
        if ($find_order_data->ord_state == 2) {
            return ["code"=>500, 'msg'=>'订单已结算', 'data'=>'订单已结算'];
        }
        // 修改订单金额及服务金额
        $update_data['ord_actual_price'] = $request['ord_actual_price']*100;
        // $update_data['ord_order_price'] = $request['ord_actual_price']*100;
        $update_data['ord_payment_way'] = $request['ord_payment_way'];//1现金、2支付宝、3微信、4银行卡
        $update_data['ord_settlement_adm_id'] = $user_info->adm_id;//结算人
        $update_data['ord_settlement_time'] = date('Y-m-d H:i:s');//结算时间
        $update_data['ord_state'] = 2;//结算状态1未结算2已结算
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($update_data);
        // 查询是否有工单
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_id')
            ->first();
        if ($find_work) {
            // 修改工单金额及服务金额
            $update_work_data['wor_actual_price'] = $request['ord_actual_price']*100;
            $update_work_data['wor_update_time'] = date('Y-m-d H:i:s');

            $update_wor_res = DB::table('work_order as wor')
                ->where('wor_id', $find_work->wor_id)
                ->update($update_work_data);
        } else {
            $update_wor_res = true;
        }

        if ($update_res && $update_wor_res) {
            return ['code'=>200, 'msg'=>'结算成功', 'data'=>'结算成功'];
        } else {
            return ['code'=>500, 'msg'=>'结算失败', 'data'=>'结算失败'];
        }
    }

    // 订单结算
    public static function settlement($user_info, $request)
    {
        $find_order_data = DB::table('order as o')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_state', 'ord_service_type', 'ord_client_id', 'orcl_name', 'orcl_phone', 'ord_order_number', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_actual_price', 'ord_type', 'ord_payment_way', 'ord_order_price', 'ord_mem_price','ord_banlance', 'orcl_business_id')
            ->first();
        if (empty($find_order_data)) {
            return ["code"=>500, 'msg'=>'订单不存在', 'data'=>'订单不存在'];
        }
        if ($find_order_data->ord_state == 2) {
            return ["code"=>500, 'msg'=>'订单已结算', 'data'=>'订单已结算'];
        }
        if ($find_order_data->ord_actual_price != 0) {
            if ($request['ord_payment_way'] == 5) {
                return ["code"=>500, 'msg'=>'已经部分结算，不可以使用会员卡', 'data'=>''];
            }
        }
        if (!isset($request['mem_id']) || empty($request['mem_id'])) {
            $request['mem_id'] = $find_order_data->ord_client_id;
        }
        $all_price = 0;
        if ($request['goods_data']) {//计算商品总金额
            $goods_data = json_decode($request['goods_data'], true);
            foreach ($goods_data as $key => $value) {
                $update_orgo_data['orgo_goo_price'] =  $value['orgo_goo_price'] * 100;
                $update_orgo_data['orgo_goo_amount'] =  $value['orgo_goo_quantity']*$value['orgo_goo_price'] * 100;
                $update_orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                $update_orgo_res = DB::table('order_goods')
                    ->where('orgo_id', $value['orgo_id'])
                    ->where('orgo_ord_id', $request['ord_id'])
                    ->update($update_orgo_data);
                if (!$update_orgo_res) {
                    return ['code'=>500, 'msg'=>'修改价格失败', 'data'=>'修改价格失败'];
                }
                if(isset($value['orgo_goo_return_quantity'])){
                    $all_price += ($value['orgo_goo_quantity'] - $value['orgo_goo_return_quantity'] )*$value['orgo_goo_price'] * 100;
                }else{
                    $all_price += $value['orgo_goo_quantity']*$value['orgo_goo_price'] * 100;
                }
            }
        } else {
            return ['code'=>500, 'msg'=>'请选择商品', 'data'=>'请选择商品'];
        }

        if ($request['ord_payment_way'] == 5) {//会员卡支付
            if (!isset($request['myvi_id'])) {
                return ["code"=>500, 'msg'=>'请选择会员卡', 'data'=>'请选择会员卡'];
            }
            $vip_data = DB::table('myvip_detail')
                ->where('myvid_mvid', $request['myvi_id'])
                ->where('myvid_surplus_times', '>', 0)
                ->get()->toArray();

            foreach ($goods_data as $key => $value) {
                foreach ($vip_data as $k => $v) {
                    if ($value['orgo_goo_type'] == $v->myvid_type && $value['orgo_goo_id'] == $v->myvid_data_id) {
                        $goods_data[$key]['myvid_surplus_times'] = $v->myvid_surplus_times;
                        if ($value['orgo_goo_quantity'] <= $v->myvid_surplus_times) {
                            $goods_data[$key]['use_vip_num'] = $value['orgo_goo_quantity'];
                        } else {
                            $goods_data[$key]['use_vip_num'] = $v->myvid_surplus_times;
                        }
                        $goods_data[$key]['use_vip_price'] = $value['orgo_goo_price'];
                        $goods_data[$key]['myvid_id'] = $v->myvid_id;
                    }
                }
            }
            $order_amount = 0;//实际需支付的现金金额
            $ord_use_vip_price = 0;//用会员卡支付的金额
            $use_vip_allnum = 0;
            foreach ($goods_data as $key => $value) {
                if (!isset($value['use_vip_num'])) {
                    $goods_data[$key]['use_vip_num'] = 0;
                    $value['use_vip_num'] = 0;
                }
                $ord_use_vip_price += $value['use_vip_price']*$value['use_vip_num'];
                $order_amount+=($value['orgo_goo_price']*($value['orgo_goo_quantity'] - $value['use_vip_num']));
                $use_vip_allnum+=$value['use_vip_num'];
            }
            $find_myvi_data = DB::table('myvip as myvi')
                ->leftJoin('member as m', 'm.mem_id', '=', 'myvi.myvi_adm_id')
                ->where('myvi_id', $request['myvi_id'])
                ->select('myvi_id', 'myvi_end_time', 'myvi_surplus_times', 'myvi_num', 'myvi_adm_id', 'mem_phone', 'mem_name', 'myvi_name')
                ->first();
            if ($find_myvi_data->myvi_end_time < date('Y-m-d H:i:s')) {
                return ["code"=>500, 'msg'=>'会员卡已过期', 'data'=>'会员卡已过期'];
            }
            if ($find_myvi_data->myvi_surplus_times == 0) {
                return ["code"=>500, 'msg'=>'会员卡次数已用完', 'data'=>'会员卡次数已用完'];
            }
            $update_myvi_data['myvi_surplus_times'] = $find_myvi_data->myvi_surplus_times - $use_vip_allnum;
            if (($find_myvi_data->myvi_surplus_times - $use_vip_allnum) == 0) {
                $update_myvi_data['myvi_state'] = 2;//已失效
            }
            $update_myvi_data['myvi_update_time'] = date('Y-m-d H:i:s');
            $update_res = DB::table('myvip')
                ->where('myvi_id', $find_myvi_data->myvi_id)
                ->update($update_myvi_data);
            $add_vip_record['vcre_myvi_id'] = $request['myvi_id'];
            $add_vip_record['vcre_user_id'] = $find_myvi_data->myvi_adm_id;
            $add_vip_record['vcre_ord_num'] = $find_order_data->ord_order_number;
            $add_vip_record['vcre_ord_id'] = $request['ord_id'];
            $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
            $add_vip_record['vcre_car_adm_name'] = $find_order_data->orcl_carowner_name;
            $add_vip_record['vcre_car_adm_phone'] = $find_order_data->orcl_carowner_phone;
            $add_vip_record['vcre_myvi_num'] = $find_myvi_data->myvi_num;
            $add_vip_record['vcre_log'] = 1;
            $add_vip_record['vcre_num_change'] = '-'.$use_vip_allnum.'（剩余：'.($find_myvi_data->myvi_surplus_times - $use_vip_allnum).'次）';
            $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);

            foreach ($goods_data as $key => $value) {
                foreach ($vip_data as $k => $v) {
                    if ($value['orgo_goo_type'] == $v->myvid_type && $value['orgo_goo_id'] == $v->myvid_data_id) {
                        $myvid_surplus_times = DB::table('myvip_detail')
                            ->where('myvid_id',$v->myvid_id)
                            ->value('myvid_surplus_times');
                        $use_vip_data['myvid_surplus_times'] = $myvid_surplus_times - $value['use_vip_num'];
                        $update_vip_data = DB::table('myvip_detail')
                            ->where('myvid_id',$v->myvid_id)
                            ->update($use_vip_data);
                        $add_vcrd_data['vcrd_vcre_id'] = $add_vire_res;
                        $add_vcrd_data['vcrd_myvid_id'] = $v->myvid_id;
                        $add_vcrd_data['vcrd_num'] = $value['use_vip_num'];
                        $add_vcrd_data['vcrd_description'] = '-'.$value['use_vip_num'].'/余：'.$use_vip_data['myvid_surplus_times'];
                        $add_vcrd_data['vcrd_create_time'] = date('Y-m-d H:i:s');
                        $add_vcrd_data['vcrd_create_id'] = $user_info->adm_id;
                        $add_vcre_res = DB::table('vipca_record_datail')->insertGetId($add_vcrd_data);
                    }
                }
            }
            if ($order_amount > 0) {
                return ["code"=>500, 'msg'=>'暂时不支持会员卡结算', 'data'=>'暂时不支持会员卡结算'];
            }
            if (isset($request['vico_id']) && $request['vico_id']) {
                $update_vico_data['vico_state'] = 2;//失效
                $update_vico_res = DB::table('vip_code')
                    ->where('vico_id', $request['vico_id'])
                    ->update($update_vico_data);
            } else {
                $update_vico_res = true;
            }

            $send = isSend($user_info, 2);
            if ($send) {
                // 2.给相应的客户发送短信
                $phone = $find_myvi_data->mem_phone;
                $message = '【半径服务】您的'.$find_myvi_data->myvi_name.'消费'.$use_vip_allnum.'次，剩余'.($find_myvi_data->myvi_surplus_times - $use_vip_allnum).'次';
                if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                    $find_shop_data = DB::table('shop')
                        ->where('shop_id', $user_info->adm_shop_id)
                        ->first();
                    if ($find_shop_data->shop_message_num <= 0) {
                        $send_state = 2;
                        $send_res = 0;
                    } else {
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();
                        if ($msg_remind_log) {//已提醒过
                            if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                $update_remind['mrlo_state'] = 1;
                                $msg_remind_log = DB::table('msg_remind_log')
                                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                    ->where('mrlo_state', 2)
                                    ->update($update_remind);
                            }
                        }
                        
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->first();

                        if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                            $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                            // $wechat_msg['pushtype'] = 5; //短信预警
                            // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                            // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                            // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                            // $wechat_msg['remark'] = '短信不足预警';
                            // $CashierDesk = new CashierDesk;
                            // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                            $remind_phone = $adm_data->adm_phone;
                            $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                            $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                            if ($remind_send_res > 0) {
                                $send_state = 1;
                                $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                $add_remind['mrlo_state'] = 2;//未充值，
                                $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                            } else {
                                $send_state = 2;
                            }
                            // 短信模块日志
                            $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                            $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                            $seme_data['seme_wor_id'] = 0; //订单id
                            $seme_data['seme_name'] = '短信不足预警'; //模板名称
                            $seme_data['seme_phone'] = $remind_phone; //手机号
                            $seme_data['seme_content'] = $remind_content; //内容
                            $seme_data['seme_row'] = 1; //条数
                            $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                            $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                            $seme_data['seme_ip'] = $request['ip']; //ip地址
                            $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                            $seme_id = DB::table('send_message')->insert($seme_data);
                        }
                        $send_res = sendSmsCode($phone, $message);
                        if ($send_res > 0) {
                            $send_state = 1;
                            $update_shop = DB::table('shop')
                                ->where('shop_id', $user_info->adm_shop_id)
                                ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                        } else {
                            $send_state = 2;
                        }
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = $request['ord_id']; //订单id
                    $seme_data['seme_name'] = '会员卡消费通知'; //模板名称
                    $seme_data['seme_phone'] = $phone; //手机号
                    $seme_data['seme_content'] = $message; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);
                    $find_member = DB::table('member')
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $phone)
                        ->first();
                    $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                    $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                    $add_log['smlo_mem_phone'] = $phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_state'] = $send_state;
                    $add_log['smlo_msg_type'] = 4;
                    $add_log['smlo_num'] = 1;
                    $add_log['smlo_content'] = $message; //内容
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                }
            }
        }
        $ord_edit_data['ord_order_price'] = $all_price;//订单金额
        $mem_price = WashOrderBasicService::mem_price(['ord_type'=>$find_order_data->ord_type,'ord_client_id'=>$find_order_data->ord_client_id],$user_info);
        if($mem_price['code'] == 200){
            $mem_points_multiple = $mem_price['data']['meml_points_multiple'];
        }
        $need_pay = $all_price - $find_order_data->ord_actual_price - $find_order_data->ord_banlance;//欠款金额
        if ($find_order_data->ord_payment_way != 9) {
            $ord_edit_data['ord_payment_way'] = $request['ord_payment_way'];//1现金、2支付宝、3微信、4银行卡
        }
        if ($request['ord_payment_way'] == 6 || $request['ord_payment_way'] == 7) {//6余额支付7他人代付
            if ($find_order_data->ord_type == 1 || $find_order_data->ord_type == 0) {
                $find_mem = DB::table('member')
                    ->where('mem_id', $request['mem_id'])
                    ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                    ->first();
                $banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
                if ($request['ord_payment_way'] == 7 && $banlance == 0) {
                    return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
                }
                $ord_payment_money = 0;
                if ($need_pay > $banlance) {//余额相等 或 余额不足
                    if (empty($request['ord_other_payway'])) {
                        return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                    }
                    $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                    $ord_edit_data['ord_payment_money'] = $need_pay - $banlance + $find_order_data->ord_actual_price;
                    $ord_edit_data['ord_banlance'] = $banlance;
                    $ord_payment_money = $banlance;
                    $ord_edit_data['ord_actual_price'] = $need_pay - $banlance + $find_order_data->ord_actual_price;//实收金额
                    $thistime_price = $need_pay - $banlance;
                    // 添加其他支付方式支付明细
                    $orsd_pay_money = $need_pay - $banlance;
                    OrderSettlementDetails::addOrderSettlementDetails($request['ord_id'], $find_order_data->ord_type, $request, $user_info, $orsd_pay_money, '', $request['ord_other_payway']);
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $find_mem->mem_gift_banlance;
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                    $update_mem['mem_rec_banlance'] = 0;
                    $update_mem['mem_gift_banlance'] = 0;
                } elseif ($need_pay <= $banlance) {
                    $ord_edit_data['ord_payment_money'] = $find_order_data->ord_actual_price;
                    $ord_edit_data['ord_actual_price'] = $find_order_data->ord_actual_price;//实收金额
                    $ord_edit_data['ord_banlance'] = $need_pay + $find_order_data->ord_banlance;
                    $ord_payment_money = $need_pay;
                    $thistime_price = 0;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    if ($find_mem->mem_rec_banlance >= $need_pay) {
                        $add_rec_log['relo_rec_num'] = $need_pay;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['mem_rec_banlance'] = $find_mem->mem_rec_banlance - $need_pay;
                    } else {
                        $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $need_pay - $find_mem->mem_rec_banlance;
                        $update_mem['mem_rec_banlance'] = 0;
                        $update_mem['mem_gift_banlance'] = $find_mem->mem_gift_banlance - ($need_pay - $find_mem->mem_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['mem_id'];
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                // 添加余额支付明细
                OrderSettlementDetails::addOrderSettlementDetails($request['ord_id'], $find_order_data->ord_type, $request, $user_info, $ord_payment_money, '',$request['ord_payment_way']);
                // 修改会员余额
                $update_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('member')->where('mem_id', $request['mem_id'])->update($update_mem);
                $outstanding_amount = 0;
                $request['ord_actual_amout'] = $thistime_price/100;
            } elseif ($find_order_data->ord_type == 2) {//企业客户
                $request['bucl_id'] = $find_order_data->orcl_business_id;
                $business_client = DB::table('business_client')
                    ->where('bucl_id', $request['bucl_id'])
                    ->select('bucl_id', 'bucl_rec_banlance', 'bucl_gift_banlance')
                    ->first();
                $banlance = $business_client->bucl_rec_banlance + $business_client->bucl_gift_banlance;
                if ($request['ord_payment_way'] == 6 && $banlance == 0) {
                    return ['code' => 500, 'msg' => '余额为0，请选择其他支付方式', 'data' => ''];
                }
                if ($need_pay >= $banlance) {//余额不足
                    if (empty($request['ord_other_payway']) && $need_pay > $banlance) {
                        return ['code' => 500, 'msg' => '余额不足，请添加其他支付方式', 'data' => ''];
                    }
                    $ord_edit_data['ord_actual_price'] = $need_pay - $banlance;
                    $ord_edit_data['ord_other_payway'] = $request['ord_other_payway'];
                    $ord_edit_data['ord_payment_money'] = $need_pay - $banlance;
                    $ord_edit_data['ord_banlance'] = $banlance + $find_order_data->ord_banlance;
                    $thistime_price = $need_pay - $banlance;//本次实付金额
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_mem_type'] = 2;
                    $add_rec_log['relo_rec_num'] = $business_client->bucl_rec_banlance;
                    $add_rec_log['relo_gift_num'] = $business_client->bucl_gift_banlance;
                    $add_rec_log['relo_mem_id'] = $request['bucl_id'];
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                    $update_mem['bucl_rec_banlance'] = 0;
                    $update_mem['bucl_gift_banlance'] = 0;
                } elseif ($need_pay < $banlance) {
                    $ord_edit_data['ord_payment_money'] = 0;
                    $ord_edit_data['ord_banlance'] = $need_pay + $find_order_data->ord_banlance;
                    $ord_edit_data['ord_actual_price'] = 0;
                    $thistime_price = 0;
                    // 消费记录
                    $add_rec_log['relo_type'] = 2;
                    $add_rec_log['relo_mem_type'] = 2;
                    if ($business_client->bucl_rec_banlance >= $need_pay) {
                        $add_rec_log['relo_rec_num'] = $need_pay;
                        $add_rec_log['relo_gift_num'] = 0;
                        $update_mem['bucl_rec_banlance'] = $business_client->bucl_rec_banlance - $need_pay;
                    } else {
                        $add_rec_log['relo_rec_num'] = $business_client->bucl_rec_banlance;
                        $add_rec_log['relo_gift_num'] = $need_pay - $business_client->bucl_rec_banlance;
                        $update_mem['bucl_rec_banlance'] = 0;
                        $update_mem['bucl_gift_banlance'] = $business_client->bucl_gift_banlance - ($need_pay - $business_client->bucl_rec_banlance);
                    }
                    $add_rec_log['relo_mem_id'] = $request['bucl_id'];
                    $add_rec_log['relo_ord_id'] = $request['ord_id'];
                    $add_rec_log['relo_remark'] = '订单消费';
                    $add_rec_log['relo_create_id'] = $user_info->adm_id;
                    $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
                    $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
                }
                $update_mem['bucl_update_time'] = date('Y-m-d H:i:s');
                $update_mem_res = DB::table('business_client')->where('bucl_id', $request['bucl_id'])->update($update_mem);
                $request['ord_actual_amout'] = $thistime_price;
                $outstanding_amount = 0;
            }
        } elseif ($request['ord_payment_way'] == 9) {//部分结款
            $ord_edit_data['ord_actual_price'] = $request['ord_actual_amout']*100 + $find_order_data->ord_actual_price;//实收金额

            $outstanding_amount = $all_price - $request['ord_actual_amout']*100 - $find_order_data->ord_actual_price;//欠款金额

            $ord_edit_data['ord_payment_money'] = $request['ord_actual_amout']*100 + $find_order_data->ord_actual_price;
        } elseif($request['ord_payment_way'] == 8 || $request['ord_payment_way'] == 0) {
            $ord_edit_data['ord_payment_money'] = 0;
            $ord_edit_data['ord_actual_price'] = 0;//实收金额
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = 0;
            $outstanding_amount = $all_price;
        } elseif($request['ord_payment_way'] == 5) {
            $ord_edit_data['ord_payment_money'] = $order_amount*100;//实收金额
            $ord_edit_data['ord_actual_price'] = $order_amount*100;//实收金额
            $ord_edit_data['ord_banlance'] = 0;
            $ord_edit_data['ord_zero_price'] = $ord_use_vip_price*100;
            $request['ord_actual_amout'] = $order_amount*100;//实收金额
            $outstanding_amount = 0;
        } else {
            $ord_edit_data['ord_payment_money'] = $all_price;
            $ord_edit_data['ord_actual_price'] = $all_price;//实收金额
            $ord_edit_data['ord_banlance'] = 0;
            $request['ord_actual_amout'] = ($all_price - $find_order_data->ord_actual_price)/100;
            $outstanding_amount = 0;
        }
        if ($request['ord_payment_way'] != 6 && $request['ord_payment_way'] != 7) {
            // 添加支付明细
            if ($request['ord_payment_way'] == 9) {
                $orsd_payment_way = $request['ord_other_payway'];
            } else {
                $orsd_payment_way = $request['ord_payment_way'];
            }
            $orsd_pay_money = $request['ord_actual_amout']*100;
            if ($request['ord_payment_way'] == 5) {
                $orsd_pay_money = $ord_use_vip_price*100;
            }
            OrderSettlementDetails::addOrderSettlementDetails($request['ord_id'], $find_order_data->ord_type, $request, $user_info, $orsd_pay_money, '' , $orsd_payment_way);
        }

        if ($find_order_data->ord_type == 1 || $find_order_data->ord_type == 0) {//个人会员欠款
            $find_mem = DB::table('member')
                ->where('mem_id', $find_order_data->ord_client_id)
                ->select('mem_arrears')
                ->first();
            $new_ord_banlance = 0;
            if ($request['ord_payment_way'] == 6 || $request['ord_payment_way'] == 7) {
                $new_ord_banlance = $ord_edit_data['ord_banlance'];
            }
            if ($find_order_data->ord_type == 1) {
                $update_data_mem['mem_arrears'] = ($find_mem->mem_arrears - $find_order_data->ord_order_price) + $all_price - $request['ord_actual_amout']*100 - $new_ord_banlance;
                if ($request['ord_payment_way'] == 5) {
                    $update_data_mem['mem_arrears'] = $find_mem->mem_arrears - $find_order_data->ord_order_price;
                }
               
                $update_data_mem['mem_update_time'] = date('Y-m-d H:i:s');
                $update_data_mem_res = DB::table('member')->where('mem_id', $find_order_data->ord_client_id)->update($update_data_mem);
            }
        } elseif ($find_order_data->ord_type == 2) {//企业会员欠款
            $find_mem = DB::table('business_account')
                ->leftJoin('business_client', 'bucl_id', '=', 'buac_bucl_id')
                ->where('buac_id', $find_order_data->ord_client_id)
                ->select('buac_arrears', 'buac_bucl_id', 'bucl_arrears')
                ->first();
            $update_data_mem['buac_arrears'] = $find_mem->buac_arrears - $request['ord_actual_amout']*100;
            $update_data_mem['buac_update_time'] = date('Y-m-d H:i:s');
            $update_data_mem_res = DB::table('business_account')->where('buac_id', $find_order_data->ord_client_id)->update($update_data_mem);

            $update_bucl['bucl_arrears'] = $find_mem->bucl_arrears - $request['ord_actual_amout']*100;
            $update_bucl['bucl_update_time'] = date('Y-m-d H:i:s');
            $update_bucl_res = DB::table('business_client')->where('bucl_id', $find_mem->buac_bucl_id)->update($update_bucl);
        }
        if ($ord_edit_data['ord_actual_price'] > $ord_edit_data['ord_order_price']) {
            return ['code'=>500, 'msg'=>'超出结算金额', 'data'=>'超出结算金额'];
        }
        if ($outstanding_amount == 0) {
            $ord_edit_data['ord_state'] = 2;//结算状态1未结算2已结算
        } elseif ($outstanding_amount == $all_price) {
            $ord_edit_data['ord_state'] = 1;//结算状态1未结算2已结算3部分结算
        } else {
            $ord_edit_data['ord_state'] = 3;//结算状态1未结算2已结算3部分结算
        }
        $find_orcl_data = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->select('orcl_sales_adm_id')
            ->first();
        if ($find_orcl_data->orcl_sales_adm_id) {
            $get_performance_type = DB::table('goods_performance_type')
                ->where('gpt_sale_adm_id', $find_orcl_data->orcl_sales_adm_id)
                ->where('gpt_state', 1)
                ->first();
            if ($get_performance_type) {
                if ($get_performance_type->gpt_type == 2) {
                    $get_performance = DB::table('goods_performance')
                        ->where('gppe_type', 3)
                        ->where('gppe_performance', '>', 0)
                        ->where('gppe_sale_id', $find_orcl_data->orcl_sales_adm_id)
                        ->first();
                    if ($get_performance) {
                        if ($get_performance->gppe_goo_id == 2) {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        }
                    }
                }
            }
        }
        $ord_edit_data['ord_settlement_adm_id'] = $user_info->adm_id;//结算人
        $ord_edit_data['ord_settlement_time'] = date('Y-m-d H:i:s');//结算时间
        $ord_edit_data['ord_pay_state'] = 1;//是否支付1是2否3部分
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_edit_data);
        // 查询是否有工单
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_id')
            ->first();
        if ($find_work) {
            // 修改工单金额
            $update_work_data['wor_actual_price'] = $ord_edit_data['ord_actual_price']*100;
            $update_work_data['wor_update_time'] = date('Y-m-d H:i:s');
            $update_wor_res = DB::table('work_order as wor')
                ->where('wor_id', $find_work->wor_id)
                ->update($update_work_data);
            if ($request['goods_data']) {
                $goods_data = json_decode($request['goods_data'], true);
                foreach ($goods_data as $key => $value) {
                    $update_wogo_data['wogo_goo_price'] =  $value['orgo_goo_price'] * 100;
                    $update_wogo_data['wogo_goo_sum'] =  $value['orgo_goo_quantity'] * $value['orgo_goo_price'] * 100;
                    $update_wogo_data['wogo_update_time'] = date('Y-m-d H:i:s');
                    $update_wogo_res = DB::table('work_good')
                        ->where('wogo_orgo_id', $value['orgo_id'])
                        ->update($update_wogo_data);
                    if (!$update_wogo_res) {
                        return ['code'=>500, 'msg'=>'修改价格失败', 'data'=>'修改价格失败'];
                    }
                }
            } else {
                return ['code'=>500, 'msg'=>'请选择商品', 'data'=>'请选择商品'];
            }
        } else {
            $update_wor_res = true;
        }
        //计算会员消费总金额
        if($find_order_data->ord_type == 1 && !empty($find_order_data->ord_client_id)){
            WashOrderService::consume_money($find_order_data->ord_client_id);
        }
        //20230724  修改订单应收应付  //1现金、2支付宝、3微信、4银行卡
        $rece_params['recpay_original_id'] = $request['ord_id'];//订单id
        $rece_params['recpay_receivable_price'] = $all_price/100;//应收金额
        $rece_params['recpay_actual_price'] = $ord_edit_data['ord_actual_price']/100;//实收金额
        $rece_params['recpay_arrears_price'] = $outstanding_amount/100;//欠收金额
        $recpay = DB::table('receivable_pay')->where('recpay_original_id', $request['ord_id'])->first();
        if($recpay){
            $profit = $rece_params['recpay_actual_price'] - $recpay->recpay_cost_price / 100 - $recpay->recpay_receivable_pay / 100 ;
            if($profit > 0){
                $minus = 1;
            }else{
                $minus = 2;
                $profit = abs($profit);
            }
            $rece_params['recpay_plus_minus'] = $minus;//盈利正负：1正值2负值
            $rece_params['recpay_profit'] = $profit;//盈利金额
            ReceivablePayService::edit($rece_params);
        }

        // 订单凭证图片
        if (isset($request['ord_voucher_pic']) && !empty($request['ord_voucher_pic'])) {
            $add_pz_pic['orvp_image'] = $request['ord_voucher_pic'];
            $add_pz_pic['orvp_type'] = 1;
            $add_pz_pic['orvp_ord_id'] = $request['ord_id'];
            $add_pz_pic['orvp_create_time'] = date('Y-m-d H:i:s');
            $add_pz_pic['orvp_create_id'] = $user_info->adm_id;
            $add_pz_pic['orvp_create_name'] = $user_info->adm_name;
            $add_pz_pic_res = DB::table('order_voucher_pic')->insert($add_pz_pic);
        }
        $ord_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_state', 'ord_wor_state', 'ord_type')
            ->first();
        if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1) {//已结算 待评价或已完成 个人会员 添加积分
            $add_point = WashOrderBasicService::addPoint($user_info,$find_order_data->ord_client_id,$request['ord_id']);
        }
        // 修改已售数量
        $pait_data = DB::table('order as o')
            ->leftjoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'o.ord_id')
            ->leftjoin('package_items as pait', 'pait.pait_id', '=', 'orgo.orgo_goo_id')
            ->where('ord_id', $request['ord_id'])
            ->where('orgo_goo_type', 3)
            ->select('pait_id', 'pait_sell_number', 'pait_saleable_quantity', 'ord_type')
            ->first();
        if ($pait_data) {
            $update_pait_data['pait_sell_number'] = $pait_data->pait_sell_number + 1;
            $update_pait_data['pait_saleable_quantity'] = $pait_data->pait_saleable_quantity - 1;
            if ($pait_data->pait_saleable_quantity - 1 == 0) {
                $update_pait_data['pait_state'] = 2;//1上架2下架
            }
            $update_pait_data['pait_update_time'] = date('Y-m-d H:i:s');
            $update_pait = DB::table('package_items')
                ->where('pait_id', $pait_data->pait_id)
                ->update($update_pait_data);
        } else {
            $update_pait = true;
        }
        if ($update_res && $update_wor_res) {
            return ['code'=>200, 'msg'=>'结算成功', 'data'=>'结算成功'];
        } else {
            return ['code'=>500, 'msg'=>'结算失败', 'data'=>'结算失败'];
        }
    }

    // 取消订单结算
    public static function cancelSettlement($user_info, $request)
    {
        $find_order_data = DB::table('order as o')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_id', 'ord_state', 'ord_service_type', 'ord_client_id', 'orcl_name', 'orcl_phone', 'ord_order_number', 'orcl_carowner_name', 'orcl_carowner_phone', 'ord_payment_way')
            ->first();
        if (empty($find_order_data)) {
            return ["code"=>500, 'msg'=>'订单不存在', 'data'=>'订单不存在'];
        }
        if ($find_order_data->ord_state == 1) {
            return ["code"=>500, 'msg'=>'订单未结算', 'data'=>'订单未结算'];
        }
        if ($find_order_data->ord_service_type == 2) {
            if ($find_order_data->ord_payment_way == 5) {
                $myvi_id = DB::table('vip_card_record')
                    ->where('vcre_ord_id', $find_order_data->ord_id)
                    ->orderBy('vcre_id', 'desc')
                    ->value('vcre_myvi_id');
                $find_myvi_data = DB::table('myvip as myvi')
                    ->leftJoin('member as m', 'm.mem_id', '=', 'myvi.myvi_adm_id')
                    ->where('myvi_id', $myvi_id)
                    ->select('myvi_id', 'myvi_end_time', 'myvi_surplus_times', 'myvi_num', 'myvi_adm_id', 'mem_phone', 'mem_name', 'myvi_name', 'myvi_sepr_name')
                    ->first();
                if ($find_myvi_data->myvi_end_time < date('Y-m-d H:i:s')) {
                    return ["code"=>500, 'msg'=>'error', 'data'=>'会员卡已过期'];
                }

                $update_myvi_data['myvi_surplus_times'] = $find_myvi_data->myvi_surplus_times + 1;
                if (($find_myvi_data->myvi_surplus_times) == 0) {
                    $update_myvi_data['myvi_state'] = 1;//1未使用完
                }
                $update_myvi_data['myvi_update_time'] = date('Y-m-d H:i:s');
                $update_res = DB::table('myvip')
                    ->where('myvi_id', $find_myvi_data->myvi_id)
                    ->update($update_myvi_data);
                $add_vip_record['vcre_myvi_id'] = $find_myvi_data->myvi_id;
                $add_vip_record['vcre_user_id'] = $find_myvi_data->myvi_adm_id;
                $add_vip_record['vcre_ord_num'] = $find_order_data->ord_order_number;
                $add_vip_record['vcre_ord_id'] = $request['ord_id'];
                $add_vip_record['vcre_create_time'] = date('Y-m-d H:i:s');
                $add_vip_record['vcre_car_adm_name'] = $find_order_data->orcl_carowner_name;
                $add_vip_record['vcre_car_adm_phone'] = $find_order_data->orcl_carowner_phone;
                $add_vip_record['vcre_myvi_num'] = $find_myvi_data->myvi_num;
                $add_vip_record['vcre_log'] = 2;//1结算2取消结算
                $add_vip_record['vcre_num_change'] = '+1（剩余：'.($find_myvi_data->myvi_surplus_times + 1).'次）';
                $add_vire_res = DB::table('vip_card_record')->insertGetId($add_vip_record);
                    
                $send = isSend($user_info, 2);
                if ($send) {
                    // 2.给相应的客户发送短信
                    $phone = $find_myvi_data->mem_phone;
                    $message = '【半径服务】您预定的'.$find_myvi_data->myvi_sepr_name.'服务已取消，'.$find_myvi_data->myvi_name.'退回1次，剩余'.($find_myvi_data->myvi_surplus_times + 1).'次';
                    if (preg_match("/^1[3456789]\d{9}$/", $phone)) {
                        $find_shop_data = DB::table('shop')
                            ->where('shop_id', $user_info->adm_shop_id)
                            ->first();
                        if ($find_shop_data->shop_message_num <= 0) {
                            $send_state = 2;
                            $send_res = 0;
                        } else {
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->first();
                            if ($msg_remind_log) {//已提醒过
                                if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                                    $update_remind['mrlo_state'] = 1;
                                    $msg_remind_log = DB::table('msg_remind_log')
                                        ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                        ->where('mrlo_state', 2)
                                        ->update($update_remind);
                                }
                            }
                            
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $user_info->adm_shop_id)
                                ->where('mrlo_state', 2)
                                ->first();

                            if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                                $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                                // $wechat_msg['pushtype'] = 5; //短信预警
                                // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                                // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                                // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                                // $wechat_msg['remark'] = '短信不足预警';
                                // $CashierDesk = new CashierDesk;
                                // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                                $remind_phone = $adm_data->adm_phone;
                                $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                                $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                                if ($remind_send_res > 0) {
                                    $send_state = 1;
                                    $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                                    $add_remind['mrlo_state'] = 2;//未充值，
                                    $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                                    $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                                    $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                                    $add_remind['mrlo_create_id'] = $user_info->adm_id;
                                    $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                                } else {
                                    $send_state = 2;
                                }
                                // 短信模块日志
                                $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                                $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                                $seme_data['seme_wor_id'] = 0; //订单id
                                $seme_data['seme_name'] = '短信不足预警'; //模板名称
                                $seme_data['seme_phone'] = $remind_phone; //手机号
                                $seme_data['seme_content'] = $remind_content; //内容
                                $seme_data['seme_row'] = 1; //条数
                                $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                                $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                                $seme_data['seme_ip'] = $request['ip']; //ip地址
                                $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                                $seme_id = DB::table('send_message')->insert($seme_data);
                            }
                            $send_res = sendSmsCode($phone, $message);
                            if ($send_res > 0) {
                                $send_state = 1;
                                $update_shop = DB::table('shop')
                                    ->where('shop_id', $user_info->adm_shop_id)
                                    ->update(['shop_message_num'=>$find_shop_data->shop_message_num - 1]);
                            } else {
                                $send_state = 2;
                            }
                        }
                        // 短信模块日志
                        $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                        $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                        $seme_data['seme_wor_id'] = $request['ord_id']; //订单id
                        $seme_data['seme_name'] = '取消结算通知'; //模板名称
                        $seme_data['seme_phone'] = $phone; //手机号
                        $seme_data['seme_content'] = $message; //内容
                        $seme_data['seme_row'] = 1; //条数
                        $seme_data['seme_status_code'] = $send_res; //短信状态码
                        $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                        $seme_data['seme_ip'] = $request['ip']; //ip地址
                        $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                        $seme_id = DB::table('send_message')->insert($seme_data);
                        $find_member = DB::table('member')
                            ->where('mem_shop_id', $user_info->adm_shop_id)
                            ->where('mem_phone', $phone)
                            ->first();
                        $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                        $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                        $add_log['smlo_mem_id'] = $find_member->mem_id;
                        $add_log['smlo_mem_name'] = $find_member->mem_name;
                        $add_log['smlo_mem_phone'] = $phone;
                        $add_log['smlo_type'] = 2;
                        $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                        $add_log['smlo_state'] = $send_state;
                        $add_log['smlo_msg_type'] = 4;
                        $add_log['smlo_num'] = 1;
                        $add_log['smlo_content'] = $message; //内容
                        $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                    }
                }
            }
        } else {
            // 修改订单实收金额及服务金额
            $update_data['ord_actual_price'] = 0;
        }
        $update_data['ord_actual_price'] = 0;
        $update_data['ord_payment_way'] = 0;//1现金、2支付宝、3微信、4银行卡
        $update_data['ord_settlement_adm_id'] = 0;//结算人
        $update_data['ord_settlement_time'] = '';//结算时间
        $update_data['ord_state'] = 1;//结算状态1未结算2已结算
        $update_data['ord_pay_state'] = 2;//是否付款1是2否
        $update_data['ord_cancel_reason'] = $request['ord_cancel_reason'];//取消结算原因
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($update_data);
        // 查询是否有工单
        $find_work = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->select('wor_id')
            ->first();
        if ($find_work) {
            // 修改工单金额
            $update_work_data['wor_actual_price'] = 0;
            $update_work_data['wor_update_time'] = date('Y-m-d H:i:s');
            $update_wor_res = DB::table('work_order as wor')
                ->where('wor_id', $find_work->wor_id)
                ->update($update_work_data);
        } else {
            $update_wor_res = true;
        }

        if ($update_res && $update_wor_res) {
            return ['code'=>200, 'msg'=>'取消结算成功', 'data'=>'取消结算成功'];
        } else {
            return ['code'=>500, 'msg'=>'取消结算失败', 'data'=>'取消结算失败'];
        }
    }

    // 数据统计
    public static function orderCount($user_info, $search_data)
    {
        if (empty($search_data['create_time_start'])) {
            $search_data['create_time_start'] = date('Y-m-d');
        }
        if (empty($search_data['create_time_start'])) {
            $search_data['create_time_end'] = date('Y-m-d');
        }
        $list_data = DB::table('order')
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_classify', 2) //工单分类：1蓄电池2洗美店3易损件
            ->where('ord_is_split', '<>', 3) //订单是否拆分，1是2否
            ->where('ord_delete', 1) //订单删除1正常2删除
            ->where('ord_wor_state', '!=', 11) //订单删除1正常2删除
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('ord_id', 'ord_order_price', 'ord_actual_price', 'ord_create_time', 'ord_banlance', 'ord_service_type')
            ->get()->toArray();
        $new_data = [];
        $new_date = [];
        $i = 0;
        foreach ($list_data as $key => $value) {
            if (in_array(date('Y-m-d', strtotime($value->ord_create_time)), $new_date)) {
                foreach ($new_data as $key1 => $value1) {
                    if (date('Y-m-d', strtotime($value->ord_create_time)) == $value1['date']) {
                        $new_data[$key1]['count'] = $value1['count'] + 1;
                        $new_data[$key1]['ord_order_price'] += $value->ord_order_price;

                        if ($value->ord_banlance) {
                            $new_data[$key1]['ord_actual_price'] += ($value->ord_actual_price - $value->ord_banlance);
                            $new_data[$key1]['ord_banlance'] += $value->ord_banlance;
                        } else {
                            $new_data[$key1]['ord_actual_price'] += $value->ord_actual_price;
                            $new_data[$key1]['ord_banlance'] += 0;
                        }
                    }
                }
            } else {
                $new_date[] = date('Y-m-d', strtotime($value->ord_create_time));
                $new_data[$i]['date'] = date('Y-m-d', strtotime($value->ord_create_time));
                $new_data[$i]['count'] = 1;
                if ($value->ord_service_type == 6) {//退款
                    $new_data[$i]['ord_order_price'] = -$value->ord_order_price;
                    $new_data[$i]['ord_actual_price'] = -$value->ord_actual_price;
                } else {
                    if ($value->ord_banlance) {
                        $new_data[$i]['ord_actual_price'] = ($value->ord_actual_price - $value->ord_banlance);
                        $new_data[$i]['ord_banlance'] = $value->ord_banlance;
                    } else {
                        $new_data[$i]['ord_actual_price'] = $value->ord_actual_price;
                        $new_data[$i]['ord_banlance'] = 0;
                    }
                    $new_data[$i]['ord_order_price'] = $value->ord_order_price;
                }
                $i++;
            }
        }

        $count = 0;
        $ord_order_price = 0;
        $ord_actual_price = 0;
        $ord_banlance = 0;
        if (!empty($new_data)) {
            foreach ($new_data as $key => $value) {
                $count += $value['count'];
                $ord_order_price += $value['ord_order_price'];
                $ord_actual_price += $value['ord_actual_price'];
                $ord_banlance += $value['ord_banlance'];
            }
        }
        $count_data['count'] = $count;
        $count_data['ord_order_price'] = $ord_order_price;
        $count_data['ord_actual_price'] = $ord_actual_price;
        $count_data['ord_banlance'] = $ord_banlance;
        $data['list'] = $new_data;
        $data['count_data'] = $count_data;
        if ($new_data) {
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        } else {
            return ['code'=>4000, 'msg'=>'暂无数据', 'data'=>'暂无数据'];
        }
    }

    // 接单
    public static function receive($user_info, $request)
    {
        $find_order_data = DB::table('order as o')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_order_number','ord_wor_state', 'ord_type', 'ord_client_id', 'ord_shop_id', 'ord_service_type','orcl_appoint_time', 'ord_source', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_mem_source', 'ord_other_system_number', 'ord_add_type', 'ord_state')
            ->first();
        if(empty($find_order_data) || $find_order_data->ord_wor_state != 7){
            return ['code'=>500, 'msg'=>'订单状态错误', 'data'=>'订单状态错误'];
        }
        if ($find_order_data->ord_add_type == 2 || $find_order_data->ord_add_type == 3) {
            if(($find_order_data->ord_service_type == 1) && empty($request['orcl_appoint_time'])){
                    return ['code'=>500, 'msg'=>'请选择预约时间', 'data'=>''];
            }
        }
        if(($find_order_data->ord_service_type == 1 || $find_order_data->ord_service_type == 2) && !empty($request['orcl_appoint_time'])){
            if(date("Y-m-d",strtotime($request['orcl_appoint_time'])) != substr($request['orcl_appoint_time'],0,10)){
                return ['code'=>500, 'msg'=>'预约时间格式错误', 'data'=>'预约时间格式错误'];
            }
        }
        $request['service_shop_id'] = 0;
        $request['ord_create_id'] = $user_info->adm_id;
        $edit_data['orcl_sales_adm_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '';//销售人
        $edit_data['ord_address'] = $request['ord_address'];//施工门店
        $edit_data['ord_address_id'] = $request['ord_address_id'];//门店id
        $edit_data['ord_new_type'] = $request['ord_new_type'];//订单类型
        $edit_data['ord_address_type'] = $request['ord_address_type'];//门店类型
        $edit_data['ord_wor_state'] = 1;//1未派工单2服务中
        if ($find_order_data->ord_service_type == 1) {//生成工单时生成发货单
            $edit_data['orcl_appoint_time'] = isset($request['orcl_appoint_time']) ? $request['orcl_appoint_time'] : '';//预约时间
            $edit_data['ord_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';//施工说明
        }
        if ($find_order_data->ord_service_type ==  2) {//不生成工单
            $edit_data['orcl_appoint_time'] = isset($request['orcl_appoint_time']) ? $request['orcl_appoint_time'] : '';//预约时间
            $edit_data['ord_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';//施工说明
            $edit_data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : '';//施工技师
            $goods_data = DB::table('order_goods as orgo')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->where('orgo_ord_id', $request['ord_id'])
                ->where('orgo_goo_type', 1)//1正常商品2服务3套餐
                ->select('goo_id', 'orgo_id', 'orgo_goo_price as goo_price', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_type as goo_type', 'goo_state', 'orgo_wago_id as wago_id', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'orgo_goo_amount')
                ->get()->toArray();
            $goods_data = json_decode(json_encode($goods_data, true), true);
            if ($goods_data && $request['ware_id']) {
                foreach ($goods_data as $key => $value) {
                    if (empty($value['wago_id'])) {
                        $goods_data[$key]['wago_id'] = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $request['ware_id'])
                            ->where('wago_goo_id', $value['goo_id'])
                            ->where('wago_class', 1)
                            ->value('wago_id');
                    }
                }

                $dibi_data = DispatchBill::create(
                    $user_info,   //用户信息
                    $request,  //订单提交数据
                    $goods_data,  //提交的商品数据
                    1,  //类型：1.订单发货 2.工单发货
                    $request['ware_id'],  //出库仓库id
                    $find_order_data->ord_order_number,  //原始单号，订单号/工单号
                    $request['ord_id'],  //发货单关联的工单/订单id
                    $find_order_data->ord_shop_id,  //所属总店id
                    $find_order_data->ord_type,  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_order_data->ord_client_id,  //选择的客户id,会员id/单位id
                    0  //发货总数量
                );
                if ($dibi_data['code'] == 500) {
                    return $dibi_data;
                }
                $post_data['ware_id'] = $request['ware_id'];
                $post_data['new_goods_data'] = $goods_data;
                $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
                $edit_data['ord_wor_state'] = 2;//1未派工单2服务中4已完成、待评价
            } else {
                $dibi_data = true;
                $edit_data['ord_wor_state'] = 4;//1未派工单2服务中4已完成、待评价
            }
        }
        if ($find_order_data->ord_service_type ==  3) {//商品
            $edit_data['ord_wor_state'] = 2;//1未派工单2服务中4已完成、待评价
            $goods_data = DB::table('order_goods as orgo')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                ->where('orgo_ord_id', $request['ord_id'])
                ->where('orgo_goo_type', 1)
                ->select('goo_id', 'orgo_id', 'orgo_goo_price as goo_price', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_type as goo_type', 'goo_state', 'orgo_wago_id as wago_id', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'orgo_goo_amount')
                ->get()->toArray();
            $goods_data = json_decode(json_encode($goods_data, true), true);
            if ($goods_data && $request['ware_id']) {
                foreach ($goods_data as $key => $value) {
                    if (empty($value['wago_id'])) {
                        $goods_data[$key]['wago_id'] = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $request['ware_id'])
                            ->where('wago_goo_id', $value['goo_id'])
                            ->where('wago_class', 1)
                            ->value('wago_id');
                    }
                }
                $dibi_data = DispatchBill::create(
                    $user_info,   //用户信息
                    $request,  //订单提交数据
                    $goods_data,  //提交的商品数据
                    1,  //类型：1.订单发货 2.工单发货
                    $request['ware_id'],  //出库仓库id
                    $find_order_data->ord_order_number,  //原始单号，订单号/工单号
                    $request['ord_id'],  //发货单关联的工单/订单id
                    $find_order_data->ord_shop_id,  //所属总店id
                    $find_order_data->ord_type,  //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_order_data->ord_client_id,  //选择的客户id,会员id/单位id
                    0  //发货总数量
                );
                if ($dibi_data['code'] == 500) {
                    return $dibi_data;
                }
                $post_data['ware_id'] = $request['ware_id'];
                $post_data['new_goods_data'] = $goods_data;
                $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
                $edit_data['ord_wor_state'] = 2;//1未派工单2服务中4已完成、待评价
            } else {
                $dibi_data = true;
                $edit_data['ord_wor_state'] = 4;//1未派工单2服务中4已完成、待评价
            }
            if ($dibi_data['code'] == 500) {
                return $dibi_data;
            }
        }

        // 添加或编辑排班计划
        if($find_order_data->ord_service_type == 1 || $find_order_data->ord_service_type == 2){
            $wopl_id=DB::table('work_plan')
                ->where('wopl_ord_id',$request['ord_id'])
                ->value('wopl_id');
            $resenum_date=substr($request['orcl_appoint_time'],0,10);//接单可能修改预约时间

            if($wopl_id){
                $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date,$find_order_data->orcl_appoint_time,$request);
                if($jud_res['code'] != 200){
                    $jud_res['code']=500;
                    $jud_res['data']=$jud_res['msg'];
                    return $jud_res;
                }

                // 添加排班计划
                $wopl_data['wopl_address_type'] = $request['ord_address_type'];//门店类型
                $wopl_data['wopl_ord_new_type'] = $request['ord_new_type'];
                $wopl_data['wopl_address_id'] = $request['ord_address_id'];//门店id
                $wopl_data['wopl_address'] = $request['ord_address'];//施工门店
                $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';;//施工说明
                $wopl_data['wopl_time'] = date('H:i:s', strtotime($request['orcl_appoint_time']));//预约时间
                $wopl_data['wopl_date'] = date('Y-m-d', strtotime($request['orcl_appoint_time']));//预约时间
                $wopl_id = DB::table('work_plan')->where('wopl_ord_id', $request['ord_id'])->update($wopl_data);
            } else {
                $jud_res=WashWorkService::judgmentShopReser($user_info,$resenum_date,'',$request);
                if($jud_res['code'] != 200){
                    $jud_res['code']=500;
                    $jud_res['data']=$jud_res['msg'];
                    return $jud_res;
                }
                //  添加排班计划
                $wopl_data['wopl_shop_id'] = $user_info->adm_shop_id;
                $wopl_data['wopl_ord_id'] = $request['ord_id'];
                $wopl_data['wopl_ord_new_type'] = $request['ord_new_type'];
                $goods_data = DB::table('order_goods as orgo')
                    ->leftJoin('goods as g', 'g.goo_id', '=', 'orgo.orgo_goo_id')
                    ->where('orgo_ord_id', $request['ord_id'])
                    ->whereIn('orgo_goo_type',[1,2])
                    ->select('goo_id', 'orgo_goo_quantity as goo_quantity', 'orgo_goo_type as goo_type', 'orgo_goo_unit as goo_unit', 'orgo_goo_unta_id as goo_unta_id', 'orgo_goo_name as goo_name', 'goo_unit_conversion')
                    ->get()->toArray();
                $sepr_id=',';
                $goo_id = ',';
                $sepr_name='';
                $goo_name='';
                // 新增订单商品数据
                foreach ($goods_data as $key => $value) {
                    if ($value->goo_type == 2) {
                        $sepr_id .= $value->goo_id.',';
                        $sepr_name .= ','.$value->goo_name;

                    } elseif ($value->goo_type == 1) {
                        $goo_id .= $value->goo_id.',';
                        $goo_name .= ','.$value->goo_name.'*'.$value->goo_quantity.$value->goo_unit;
                    }
                }
                $sepr_name=trim($sepr_name,',');
                $goo_name =trim($goo_name,',');

                $goo_id  = ($goo_id  == ",") ? "" : $goo_id;
                $sepr_id = ($sepr_id == ",") ? "" : $sepr_id;

                $wopl_data['wopl_sepr_name'] = $sepr_name;
                $wopl_data['wopl_sepr_id'] = $sepr_id;
                $wopl_data['wopl_goo_id'] = $goo_id;
                $wopl_data['wopl_goo_name'] = $goo_name;
                $wopl_data['wopl_address_id'] = $request['ord_address_id'];
                $wopl_data['wopl_address'] = $request['ord_address'];
                $wopl_data['wopl_address_type'] = $request['ord_address_type'];
                if ($edit_data['orcl_sales_adm_id']) {
                    $find_adm = DB::table('admin')->where('adm_id', $request['orcl_sales_adm_id'])->value('adm_name');
                } else {
                    $find_adm = '';
                }
                $wopl_data['wopl_sale_name'] = $find_adm;
                $wopl_data['wopl_sale_id'] = isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '';
                $wopl_data['wopl_explain'] = isset($request['ord_explain']) ? $request['ord_explain'] : '';
                $wopl_data['wopl_time'] = isset($request['orcl_appoint_time']) ? date('H:i:s', strtotime($request['orcl_appoint_time'])) : '';
                $wopl_data['wopl_date'] = isset($request['orcl_appoint_time']) ? date('Y-m-d', strtotime($request['orcl_appoint_time'])) : '';
                $wopl_data['wopl_create_time'] = date('Y-m-d H:i:s');
                DB::table('work_plan')->insert($wopl_data);
            }
        }

        // 贴装系统订单逻辑处理
        if ($find_order_data->ord_source == 5) {
            // 判断客户手机号是否存在，不存在新增
            $find_mem = DB::table('member')
                ->where('mem_cid', $user_info->adm_cid)
                ->where('mem_shop_id', $user_info->adm_shop_id)
                ->where('mem_phone', $find_order_data->orcl_phone)
                ->first(['mem_id']);
            if ($find_mem) {
                $edit_data['orcl_client_id'] = $find_mem->mem_id;
                $edit_data['ord_client_id'] = $find_mem->mem_id;
                $ord_client_id = $find_order_data->ord_client_id;
            } else {
                // 新增会员
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_create_id'] = $user_info->adm_id;
                $eme['mem_create_name'] = $user_info->adm_name;
                $eme['mem_name'] = $find_order_data->orcl_name;
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                $eme['mem_phone'] = $find_order_data->orcl_phone;
                $eme['mem_source'] = $find_order_data->orcl_mem_source;
                $eme['mem_car_num'] = $find_order_data->orcl_car_num;
                $eme['mem_order_all'] = 1; //订单数
                $mem_id = MemberService::addMember($eme);
                 // DB::table('member')->insertGetId($eme);
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'新增会员失败', 'data'=>'新增会员失败'];
                }
                $edit_data['orcl_client_id'] = $mem_id;
                $edit_data['ord_client_id'] = $mem_id;
                $ord_client_id = $mem_id;
            }
            // 门店接单，同步贴装
            $url = config('apiconnect.ZPTZ_URL') . '/index.php/api/supplychain/SupplyMz/sync_receipt_status';
            $param['serial_number'] = $find_order_data->ord_other_system_number; //第三方工单号
            $param['type'] = 1;
            $param['ip'] = Request::getClientIp();
            $param['time'] = date('Y-m-d H:i:s'); //收货时间
            $param['token'] = md5(md5($param['time'] . config('apiconnect.ZPTZ_TOKEN'))); //token
            $param_return = doPost($param, $url, 2);
            $param_return = json_decode($param_return, true);
            if ($param_return['code'] != 200) {
                return ['code'=>500, 'msg'=>'接单失败0', 'data'=>'失败'];
            }
        } else {
            $ord_client_id = $find_order_data->ord_client_id;
        }

        //个人会员下服务单更新会员下单时间
        if($find_order_data->ord_type == 1){
            WashOrderBasicService::updateOrderCount($ord_client_id);
            WashOrderService::consume_money($ord_client_id);
        }

        //修改订单信息
        $update_res = DB::table('order as o')
            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_id', $request['ord_id'])
            ->update($edit_data);

        $ord_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_state', 'ord_wor_state', 'ord_type', 'ord_client_id')
            ->first();
        if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1) {//已结算 待评价或已完成 个人会员 添加积分
            $add_point = WashOrderBasicService::addPoint($user_info,$ord_data->ord_client_id,$request['ord_id']);
        }

        // 计算销售人绩效
        if (!empty($request['orcl_sales_adm_id'])) {
            $find_goods_performance_type = DB::table('goods_performance_type')
                ->where('gpt_shop_id', $user_info->adm_shop_id)
                ->where('gpt_sale_adm_id', $request['orcl_sales_adm_id'])
                ->where('gpt_state', 1)
                ->first();
            if ($find_goods_performance_type) {
                if ($find_goods_performance_type->gpt_type == 1) {
                    $get_orgo_data = DB::table('order_goods')
                        ->where('orgo_ord_id', $request['ord_id'])
                        ->whereIn('orgo_goo_type', [1,2])
                        ->select('orgo_goo_id', 'orgo_goo_type', 'orgo_id')
                        ->get();
                    if ($get_orgo_data) {
                        foreach ($get_orgo_data as $kkk => $vvv) {
                            $gppe_performance = DB::table('goods_performance')
                                ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                                ->where('gppe_type', $vvv->orgo_goo_type)
                                ->where('gppe_goo_id', $vvv->orgo_goo_id)
                                ->value('gppe_performance');

                            $update_orgo = DB::table('order_goods')
                                ->where('orgo_id', $vvv->orgo_id)
                                ->update(['orgo_sale_performance'=> $gppe_performance]);
                        }
                    }
                }

                if ($find_goods_performance_type->gpt_type == 2) {
                    $get_performance = DB::table('goods_performance')
                        ->where('gppe_type', 3)
                        ->where('gppe_performance', '>', 0)
                        ->where('gppe_sale_id', $request['orcl_sales_adm_id'])
                        ->first();
                    if ($get_performance) {
                        $ord_edit_data['ord_saleman_type'] = $get_performance->gppe_goo_id;
                        if ($get_performance->gppe_goo_id == 1) {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        } else {
                            $ord_edit_data['ord_saleman_performance'] = $get_performance->gppe_performance;
                        }
                        $new_update_res = DB::table('order as o')
                            ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'o.ord_id')
                            ->where('ord_id', $request['ord_id'])
                            ->update($ord_edit_data);
                    }
                }
            }
        }

        //如果需要生成工单，并且选择了技师，可以直接生成工单
        if($edit_data['ord_wor_state'] == 1 && isset($request['service_adm_id']) && isset($request['service_adm_data']) && !empty($request['service_adm_id']) && !empty($request['service_adm_data'])){
            // 判断门店版本
            if ($user_info->shop_versions == 1) {
                // 基础版流程
                $order_data = self::createWork($user_info, $request);
            } else {
                // 其他版本流程
                // 生成工单
                $request['ord_service_type'] = 1;
                $order_data = self::createWork($user_info, $request);
            }
            if ($order_data['code'] != 200) {
                return $order_data;
            }
            $find_wor_data = DB::table('work_order')
                ->where('wor_id', $order_data['data']['wor_id'])
                ->select('wor_service_adm_id')
                ->first();
            // 添加技师消息
            $add_data['adm_id'] = $find_wor_data->wor_service_adm_id;
            $add_data['shop_id'] = $user_info->adm_shop_id;
            $add_data['primary_id'] = $order_data['data']['wor_id']; //单据的主键id
            $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
            $add_data['message_type'] = 1;
            $add_data['primary_wor_state'] = 3; //状态1订单待派单2工单待派单3待接单
            // $add_data['message_type'] = $data['message_type'];
            $add_data['title'] = '派单通知'; //
            $add_data['content'] = '您有新的工单，请及时处理'; //操作内容
            $add_data['read_state'] = 1; //阅读状态：1未读2已读
            $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
            $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
            $addAdminMessage_res = addAdminMessage($add_data);
            // 订单历史记录
            $data['wohi_primary_id'] = $request['ord_id'];
            $data['wohi_state_name'] = '待施工';
            $data['wohi_state'] = 2;
            $data['wohi_type'] = 1;//1订单2工单
            addHistory($data);
            unset($data);
            // 工单的历史记录
            $data['wohi_primary_id'] = $order_data['data']['wor_id'];
            $data['wohi_state_name'] = '已创建';
            $data['wohi_state'] = 1;//服务状态：1已创建
            $data['wohi_type'] = 2;//1订单2工单
            addHistory($data);
            unset($data);
            // 工单的历史记录
            $data['wohi_primary_id'] = $order_data['data']['wor_id'];
            $data['wohi_state_name'] = '待接单';
            $data['wohi_state'] = 2;//服务状态：2待接单
            $data['wohi_type'] = 2;//1订单2工单
            addHistory($data);
            unset($data);
            if ($addAdminMessage_res['code'] != 200) {
                return $addAdminMessage_res;
            }
            // 生成操作记录
            $orlo_res = orderLog($user_info, $request['ord_id'], $order_data['data']['wor_id'], '生成工单');
            if ($orlo_res && $update_res) {
                //OperationLog::addLog($user_info, $request->getClientIp(), '订单列表', '生成工单', '生成工单' . $order_data['data']['wor_order_number'] . '成功');
                return ['code'=>200, 'msg'=>'接单、生成工单成功', 'data'=>'接单、生成工单成功'];
            } else {
                return ['code'=>500, 'msg'=>'生成工单失败1', 'data'=>'生成工单失败'];
            }
        }else{
            if ($update_res) {
                return ['code'=>200, 'msg'=>'接单成功', 'data'=>'接单成功'];
            } else {
                return ['code'=>500, 'msg'=>'接单失败1', 'data'=>'接单失败'];
            }
        }
    }



    // 查询订单信息-开单使用
    public static function getOrder($user_info, $request)
    {
        $find_order_data = DB::table('order')
            ->leftJoin('order_client', 'orcl_ord_id', '=', 'ord_id')
            ->leftJoin('shop', 'shop_id', '=', 'ord_shop_id')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_client_id', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_car_brand_series', 'orcl_carowner_name', 'orcl_carowner_phone', 'orcl_sales_adm_id', 'ord_type', 'orcl_mem_source', 'ord_address_type', 'ord_address_id', 'ord_address', 'orcl_business_id', 'orcl_business_name')
            ->first();
        if (empty($find_order_data)) {
            return ["code"=>4000, 'msg'=>'未查询到订单信息', 'data'=>'未查询到订单信息'];
        }
        $find_order_data->orcl_sales_adm_name = DB::table('admin')
            ->where('adm_id', $find_order_data->orcl_sales_adm_id)
            ->value('adm_name');
        return ["code"=>200, 'msg'=>'获取成功', 'data'=>$find_order_data];
    }

    // 订单凭证图片
    public static function getorderpic($user_info, $ord_id)
    {
        $data = DB::table('order_voucher_pic')
            ->where('orvp_type', 1)
            ->where('orvp_ord_id', $ord_id)
            ->select('orvp_image', 'orvp_type', 'orvp_id')
            ->get()->toArray();

        if (empty($data)) {
            return ['code'=>200, 'msg'=>'录单人未上传相关凭证！', 'data'=>''];
        }

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    // 订单凭证图片
    public static function getExplainpic($user_info, $ord_id)
    {
        $data = DB::table('order_voucher_pic')
            ->where('orvp_type', 2)
            ->where('orvp_ord_id', $ord_id)
            ->select('orvp_image', 'orvp_type', 'orvp_id')
            ->get()->toArray();

        if (empty($data)) {
            return ['code'=>200, 'msg'=>'暂无数据', 'data'=>''];
        }

        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * 上传订单凭证
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-13
     * @param  [type]           $user_info [description]
     * @param  [type]           $request    [description]
     * @return [type]                      [description]
     */
    public static function uploadOrdPic($user_info, $request) {
        $pic_data = $request['pic_data'];
        foreach ($pic_data as $key => $value) {
            $add_data[$key]['orvp_type'] = 1;
            $add_data[$key]['orvp_ord_id'] = $request['ord_id'];
            $add_data[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
            $add_data[$key]['orvp_create_id'] = $user_info->adm_id;
            $add_data[$key]['orvp_image'] = $value;
            $add_data[$key]['orvp_create_name'] = $user_info->adm_name;
        }
        $add_res = DB::table('order_voucher_pic')->insert($add_data);
        if ($add_res) {
            return ['code'=>200, 'msg'=>'上传成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'上传失败', 'data'=>''];
        }
    }

    /**
     * 充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function recharge($user_info, $request) {
        $request['ord_unique_string'] = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        if (empty($request['ord_unique_string'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data' => ''];
        }

        $request['ord_address_type'] = 1;
        $request['ord_address_id'] = $user_info->adm_shop_id;
        if (empty($request['mem_id'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请选择会员', 'data' => ''];
        }
        if (empty($request['mem_rec_banlance'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请输入充值金额', 'data' => ''];
        }
        if (empty($request['ord_payment_way'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请选择支付方式', 'data' => ''];
        }
        $find_mem = DB::table('member')
            ->where('mem_id', $request['mem_id'])
            ->first();
        $request['orcl_name'] = $find_mem->mem_name;
        $request['orcl_phone'] = $find_mem->mem_phone;
        $request['orcl_carowner_name'] = $find_mem->mem_name;
        $request['orcl_carowner_phone'] = $find_mem->mem_phone;
        $request['orcl_mem_source'] = $find_mem->mem_source;
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code' => ErrorInc::DATA_EXIST, 'msg' => '当前订单已提交，请勿重复操作！', 'data' => ''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);

        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = isset($request['mem_id']) ? $request['mem_id'] : 0;
        $data['ord_ware_id'] = 0;
        // $data['ord_address'] = $request['ord_address'];
        // $data['ord_address_id'] = $request['ord_address_id'];
        // $data['ord_address_type'] = $request['ord_address_type'];
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1; //买家类型：0散户1门店零售2企业客户
        $data['ord_service_type'] = 5; //订单类型：1服务单 2洗车单3商品单4会员卡5充值
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式结算方式1现金、2支付宝、3微信、4银行卡5会员卡
        $data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : ''; //服务技师
        if ($request['ord_payment_way']) {
            $data['ord_state'] = 2; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
            $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        }
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_order_price'] = $request['mem_rec_banlance']*100;
        $data['ord_actual_price'] = $request['mem_rec_banlance']*100;
        $data['ord_unique_string'] = $request['ord_unique_string'];
        $data['ord_explain'] = '';
        $data['ord_wor_state'] = 20;
        $ord_id = WashOrder::insertGetId($data);
        //计算会员消费总金额
        if($data['ord_client_id'] > 0 ){
            WashOrderService::consume_money($data['ord_client_id']);
        }

        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 1;
                $add_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }
        if (!empty($request['orcl_phone'])) {
            // 查询手机号是否存在
            $find_weixin_data = DB::table('weixin_user')
                ->where('weus_phone', $request['orcl_phone'])
                ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
                ->first();
            if ($find_weixin_data) {
                $weus_id = $find_weixin_data->weus_id;
            } else {
                $weus_id = 0;
            }
        } else {
            $weus_id = 0;
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['mem_id']) ? $request['mem_id'] : 0, //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '', // 销售人员id
            'orcl_business_name' => isset($request['orcl_business_name']) ? $request['orcl_business_name'] : '', //企业名称
            'orcl_business_id' => isset($request['orcl_business_id']) ? $request['orcl_business_id'] : '', //企业id
            'orcl_name' => isset($request['orcl_name']) ? $request['orcl_name'] : '散户',
            'orcl_phone' => isset($request['orcl_phone']) ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => isset($request['orcl_carowner_name']) ? $request['orcl_carowner_name'] : '散户',
            'orcl_carowner_phone' => isset($request['orcl_carowner_phone']) ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $ord_edit_data['ord_goods_quantity'] = 1;
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = DB::table('order')->where('ord_id', $ord_id)->update($ord_edit_data);

        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_goo_id'] = 0;
        if (!empty($request['mem_gift_banlance'])) {
            $orgo_data['orgo_goo_name'] = '充值'.$request['mem_rec_banlance'].'元 赠送'.$request['mem_gift_banlance'].'元';
        } else {
            $orgo_data['orgo_goo_name'] = '充值'.$request['mem_rec_banlance'].'元';
        }
        $orgo_data['orgo_goo_type'] = 5;
        $orgo_data['orgo_goo_price'] = $request['mem_rec_banlance']*100;
        $orgo_data['orgo_goo_amount'] = $request['mem_rec_banlance']*100;
        $orgo_data['orgo_state'] = 1;
        $orgo_data['orgo_goo_quantity'] = 1;
        $orgo_data['orgo_goo_inventory'] = 1;
        $orgo_data['orgo_goo_unit'] = '次';
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);

        $receivable_pay['recpay_cid'] = $user_info->adm_cid;
        $receivable_pay['recpay_shop_id'] = $user_info->adm_shop_id;
        $receivable_pay['recpay_shop_superior_id'] = $user_info->adm_shop_id;
        $receivable_pay['recpay_type'] = 2;
        $receivable_pay['recpay_original_id'] = $ord_id;
        $receivable_pay['recpay_original_number'] = $ord_order_number;
        $receivable_pay['recpay_client_type'] = 1;
        $receivable_pay['recpay_client_id'] = $request['mem_id'];
        $receivable_pay['recpay_client_name'] = $find_mem->mem_name;
        $receivable_pay['recpay_receivable_price'] = $request['mem_rec_banlance'] * 100;//应收金额
        $receivable_pay['recpay_arrears_price'] = 0;//欠收金额
        $receivable_pay['recpay_actual_price'] = $request['mem_rec_banlance'] * 100;//实收金额
        $receivable_pay['recpay_cost_price'] = 0;//成本价
        $receivable_pay['recpay_receivable_pay'] = 0;//应付金额
        $receivable_pay['recpay_actual_pay'] = 0;
        $receivable_pay['recpay_plus_minus'] = 1;
        $receivable_pay['recpay_profit'] = $request['mem_rec_banlance'] * 100;//盈利金额
        $receivable_pay['recpay_state'] = 1;//状态：1未确认2已确认
        $receivable_pay['recpay_order_state'] = 1;//订单状态：1正常2退款3取消
        $receivable_pay['recpay_remark'] = !empty($request['remark']) ? $request['remark'] : '';
        $receivable_pay['recpay_create_time'] = date('Y-m-d H:i:s');
        $receivable_pay['recpay_update_time'] = date('Y-m-d H:i:s');
        $receivable_pay_res = DB::table('receivable_pay')->insert($receivable_pay);
        $update_data['mem_rec_banlance'] = $find_mem->mem_rec_banlance + $request['mem_rec_banlance'] * 100;
        $update_data['mem_gift_banlance'] = $find_mem->mem_gift_banlance + $request['mem_gift_banlance'] * 100;
        $update_data['mem_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('member')
            ->where('mem_id', $request['mem_id'])
            ->update($update_data);
        $add_rec_log['relo_type'] = 1;
        $add_rec_log['relo_rec_num'] = $request['mem_rec_banlance'] * 100;
        $add_rec_log['relo_gift_num'] = $request['mem_gift_banlance'] * 100;
        $add_rec_log['relo_ord_id'] = $ord_id;
        $add_rec_log['relo_mem_id'] = $request['mem_id'];
        $add_rec_log['relo_remark'] = $request['remark'];
        $add_rec_log['relo_create_id'] = $user_info->adm_id;
        $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
        $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
        if ($request['remark']) {
            $orre_res = orderRemark($user_info, $ord_id, 0, $request['remark'], '充值');
        }
        $banlance = $update_data['mem_rec_banlance'] + $update_data['mem_gift_banlance'];
        if ($ord_id && $orcl_id && $orgo_id && $update_data_res && $relo_id) {
            $log_data['order_number'] = $ord_order_number;
            return ['code'=>200, 'msg'=>'充值成功', 'data'=>$banlance ,'log_data'=>$log_data];
        } else {
            return ['code'=>500, 'msg'=>'充值失败', 'data'=>''];
        }
    }

    /**
     * 提现
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function refund($user_info, $request) {
        $request['ord_unique_string'] = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        if (empty($request['ord_unique_string'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data' => ''];
        }

        $request['ord_address_type'] = 1;
        $request['ord_address_id'] = $user_info->adm_shop_id;
        if (empty($request['mem_id'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请选择会员', 'data' => ''];
        }
        $find_mem = DB::table('member')
            ->where('mem_id', $request['mem_id'])
            ->first();
        $request['orcl_name'] = $find_mem->mem_name;
        $request['orcl_phone'] = $find_mem->mem_phone;
        $request['orcl_carowner_name'] = $find_mem->mem_name;
        $request['orcl_carowner_phone'] = $find_mem->mem_phone;
        $request['orcl_mem_source'] = $find_mem->mem_source;
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code' => ErrorInc::DATA_EXIST, 'msg' => '当前订单已提交，请勿重复操作！', 'data' => ''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);

        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = isset($request['mem_id']) ? $request['mem_id'] : 0;
        $data['ord_ware_id'] = $request['ware_id'] ? $request['ware_id'] : '';
        // $data['ord_address'] = $request['ord_address'];
        // $data['ord_address_id'] = $request['ord_address_id'];
        // $data['ord_address_type'] = $request['ord_address_type'];
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1; //买家类型：0散户1门店零售2企业客户
        $data['ord_service_type'] = 6; //订单类型：1服务单 2洗车单3商品单4会员卡5充值6提现
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式结算方式1现金、2支付宝、3微信、4银行卡5会员卡
        $data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : ''; //服务技师
        $data['ord_state'] = 2; //结算状态1未结算2已结算
        $data['ord_pay_state'] = 1; //是否支付1是2否
        $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
        $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_order_price'] = -$find_mem->mem_rec_banlance;
        $data['ord_actual_price'] = -$find_mem->mem_rec_banlance;
        $data['ord_unique_string'] = $request['ord_unique_string'];
        $data['ord_explain'] = '';
        $data['ord_wor_state'] = 20;
        $ord_id = WashOrder::insertGetId($data);
        //计算会员消费总金额
        if($data['ord_type'] == 1 && $data['ord_client_id'] > 0){
            WashOrderService::consume_money($data['ord_client_id']);
        }

        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 1;
                $add_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }
        if (!empty($request['orcl_phone'])) {
            // 查询手机号是否存在
            $find_weixin_data = DB::table('weixin_user')
                ->where('weus_phone', $request['orcl_phone'])
                ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
                ->first();
            if ($find_weixin_data) {
                $weus_id = $find_weixin_data->weus_id;
            } else {
                $weus_id = 0;
            }
        } else {
            $weus_id = 0;
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['mem_id']) ? $request['mem_id'] : 0, //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '', // 销售人员id
            'orcl_business_name' => isset($request['orcl_business_name']) ? $request['orcl_business_name'] : '', //企业名称
            'orcl_business_id' => isset($request['orcl_business_id']) ? $request['orcl_business_id'] : '', //企业id
            'orcl_name' => isset($request['orcl_name']) ? $request['orcl_name'] : '散户',
            'orcl_phone' => isset($request['orcl_phone']) ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => isset($request['orcl_carowner_name']) ? $request['orcl_carowner_name'] : '散户',
            'orcl_carowner_phone' => isset($request['orcl_carowner_phone']) ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $ord_edit_data['ord_goods_quantity'] = 1;
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = DB::table('order')->where('ord_id', $ord_id)->update($ord_edit_data);

        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_goo_id'] = $request['sepr_id'];
        $orgo_data['orgo_goo_name'] = '提现'.($find_mem->mem_rec_banlance/100).'元';
        $orgo_data['orgo_goo_type'] = 6;
        $orgo_data['orgo_goo_price'] = -$find_mem->mem_rec_banlance;
        $orgo_data['orgo_goo_amount'] = -$find_mem->mem_rec_banlance;
        $orgo_data['orgo_state'] = 1;
        $orgo_data['orgo_goo_quantity'] = 1;
        $orgo_data['orgo_goo_inventory'] = 1;
        $orgo_data['orgo_goo_unit'] = '次';
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);

        $update_data['mem_rec_banlance'] = 0;
        $update_data['mem_gift_banlance'] = 0;
        $update_data['mem_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('member')
            ->where('mem_id', $request['mem_id'])
            ->update($update_data);
        $add_rec_log['relo_type'] = 3;
        $add_rec_log['relo_rec_num'] = $find_mem->mem_rec_banlance;
        $add_rec_log['relo_gift_num'] = $find_mem->mem_gift_banlance;
        $add_rec_log['relo_mem_id'] = $request['mem_id'];
        $add_rec_log['relo_ord_id'] = $ord_id;
        $add_rec_log['relo_remark'] = $request['remark'];
        $add_rec_log['relo_create_id'] = $user_info->adm_id;
        $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
        $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
        if ($update_data_res && $relo_id) {
            $data['recpay_original_id'] = $ord_id;
            $data['recpay_original_number'] = $ord_order_number;
            return ['code'=>200, 'msg'=>'提现成功', 'data'=>$ord_id];
        } else {
            return ['code'=>500, 'msg'=>'提现失败', 'data'=>''];
        }
    }

    /**
     * 充值/消费记录
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function reclog($user_info, $request, $show_count=10) {
        if (empty($show_count)) {
            $show_count = 10;
        }
        $list_data = DB::table('rec_log')
            ->leftJoin('admin', 'relo_create_id', '=', 'adm_id')
            ->leftJoin('order', 'ord_id', '=', 'relo_ord_id')
            ->where('relo_mem_id', $request['mem_id'])
            ->where(function ($query) use ($request) {
                if (!empty($request['relo_type'])) {
                    $query->where('relo_type', $request['relo_type']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['relo_mem_type'])) {
                    $query->where('relo_mem_type', $request['relo_mem_type']);
                } else {
                    $query->where('relo_mem_type', 1);
                }
            })
            ->where(function ($query) use ($request) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($request['create_time_start']) && !empty($request['create_time_end'])) {
                    $query->whereBetween('relo_create_time', [$request['create_time_start'], $request['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($request['create_time_start'])) {
                        $query->where('relo_create_time', '>=', $request['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($request['create_time_end'])) {
                            $query->where('relo_create_time', '<=', $request['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('rec_log.*', 'ord_order_number', 'adm_name')
            ->orderBy('relo_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                if ($value->relo_type == 1) {
                    $list_items[$key]->relo_name = '充值';
                    $list_items[$key]->relo_rec_num = '+'.$value->relo_rec_num;
                    $list_items[$key]->relo_gift_num = '+'.$value->relo_gift_num;
                }
                if ($value->relo_type == 2) {
                    $list_items[$key]->relo_name = '消费';
                    $list_items[$key]->relo_rec_num = -$value->relo_rec_num;
                    $list_items[$key]->relo_gift_num = -$value->relo_gift_num;
                }
                if ($value->relo_type == 3) {
                    $list_items[$key]->relo_name = '提现';
                    $list_items[$key]->relo_rec_num = -$value->relo_rec_num;
                    $list_items[$key]->relo_gift_num = -$value->relo_gift_num;
                }
                if ($value->relo_type == 4) {
                    $list_items[$key]->relo_name = '退款';
                    $list_items[$key]->relo_rec_num = '+'.$value->relo_rec_num;
                    $list_items[$key]->relo_gift_num = '+'.$value->relo_gift_num;
                }
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        if ($request['relo_mem_type'] == 1) {
            $find_mem = DB::table('member')
                ->where('mem_id', $request['mem_id'])
                ->select('mem_id', 'mem_rec_banlance', 'mem_gift_banlance')
                ->first();
        } else {
            $find_mem = DB::table('business_client')
                ->where('bucl_id', $request['mem_id'])
                ->select('bucl_id as mem_id', 'bucl_rec_banlance as mem_rec_banlance', 'bucl_gift_banlance as mem_gift_banlance')
                ->first();
        }
        $time = date('Y-m-d');
        $data['user_data'] = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;                        //返回数据
        $data['time'] = $time;                        //返回数据
        return $data;
    }

    /**
     * 获取余额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getBanlance($user_info, $request) {
        $find_mem = DB::table('member')
            ->where('mem_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['keywords'])) {
                    $query->where('mem_phone', $request['keywords'])
                        ->orwhere('mem_car_num', $request['keywords']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['mem_id'])) {
                    $query->where('mem_id', $request['mem_id']);
                }
            })
            ->select('mem_rec_banlance', 'mem_gift_banlance', 'mem_phone', 'mem_name', 'mem_car_num', 'mem_id')
            ->first();
        if ($find_mem) {
            $find_mem->mem_banlance = $find_mem->mem_rec_banlance + $find_mem->mem_gift_banlance;
        }
        return $find_mem;
    }

    /*
     * @name 新增技师
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/8/21 9:20
     *
    */
    public static function addPerson($input){
        //验证
        $message = [
            'adm_name.required'=> '姓名不能为空',
            'adm_phone.required'=> '电话不能为空',
            'adm_phone.unique'=> '电话已存在',
            'adm_phone.regex'=> '电话号码不正确',
            'adm_password.required'=> '密码不能为空',
        ];
        $rules = [
            'adm_name' =>'required',
            'adm_phone' =>'required',
            'adm_phone' =>['regex:/^[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}$/'],
            'adm_phone' =>'unique:admin',
            'adm_password' =>'required',
        ];
        $Validator = Validator::make($input,$rules,$message);
        if($Validator->fails()){
            return response()->json(['data'=>'','code'=>1003, 'msg'=>$Validator->errors()->first()]);exit;
        }
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $user_info = CommonService::dataToArray($user_info);
        $adm_phone = DB::table('admin')
            ->where('adm_phone', trim($input['adm_phone']))
            ->first();
        if ($adm_phone) {
            return response()->json(['code'=>500, 'msg'=>'手机号已存在', 'data'=>'']);
        }
        //添加
        if($input['adm_password']){
            $password = md5(trim($input['adm_password']). 'faster123456');
        }else{
            $password = md5(substr(trim($input['adm_phone']),0,6) . 'faster123456');
        }
        $applet_role = DB::table('privileges_technician_applet')
            ->whereRaw("FIND_IN_SET('5', pri_default)")
            ->get()->toArray();
        $app_role = '';
        if($applet_role){
            foreach ($applet_role as $app_r_key => $app_r_value){
                $app_role_arr[] = $app_r_value->pri_id;
            }
            $app_role = implode(',',$app_role_arr);
        }
        $rol_id = DB::table('role')->where('rol_shop_id',$user_info['adm_shop_id'])->where('rol_type',3)->value('rol_id');
        if(empty($rol_id)){
            $js_role_add_data = [
                'rol_cid'=>$user_info['adm_cid'],
                'rol_shop_id'=>$user_info['adm_shop_id'],
                'rol_type'=>3,
                'rol_name'=>'技师管理',
                'rol_privilege_multiple'=> '{"pc":"","applet":"'.$app_role.'"}',//9,10,11,12,13,14,15,16,17,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55
                'rol_privilege'=>config('apisystem.franchisee_shop'),
                'rol_creator_id'=>$user_info['adm_id']??''
            ];
            // 新增角色
            $rol_id =  DB::table('role')->insertGetId($js_role_add_data);
        }
        $admin_add_data['adm_cid'] = $user_info['adm_cid']; //所属企业/品牌方id
        $admin_add_data['adm_shop_id'] = $user_info['adm_shop_id']; //门店id
        $admin_add_data['adm_superior_shop_id'] = $user_info['adm_shop_id']; //总店id
        $admin_add_data['adm_leave'] = 3; //级别1店长2普通员工3技师4业务员5技师和业务员
        $admin_add_data['adm_phone'] = trim($input['adm_phone']); //手机号
        //  $admin_add_data['adm_account'] = $input['adm_account']??$input['adm_name']; //用户名（登录账号）
        $admin_add_data['adm_account'] = 'os'.date('Ymd').substr(implode(NULL,array_map('ord',str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
        $admin_add_data['adm_password'] = $password; //登录密码
        $admin_add_data['adm_name'] = $input['adm_name']; //姓名名称
        $admin_add_data['adm_role'] = $rol_id; //角色id
        $admin_add_data['adm_creator_id'] = $user_info['adm_id']; //操作人id
        $admin_add_data['adm_role_applet'] = 0; //小程序角色id
        // 新增账号
        //return response()->json(['code'=> 500,'msg'=>'操作失败','data'=>$admin_add_data]);
        $adm_res =  DB::table('admin')->insertGetid($admin_add_data);
        if($adm_res) {
            /*if (config('apisystem.SYNC_STATE')) {
                $url = config('apisystem.sd_server_name') . '/index.php/api/supplychain/SupplyMz/creatInstallPerson';
                $param['install_name'] = $input['adm_name'];
                $param['install_phone'] = $input['adm_phone'];
                $param['admin_id'] = SettleIn::where('phone',$input['phone'])->value('sd_admin_id');
                $param['install_password1'] = $input['adm_password'];
                $param['install_password'] = $password;
                $doPost_res = \App\Http\Models\Api\Common::doPost($param, $url, 2);
                $doPost_res = json_decode($doPost_res,true);
                if ($doPost_res['code'] != 200) {
                    DB::rollback();
                    return response()->json(['code'=>500, 'msg'=>'同步失败', 'data'=>$doPost_res]);
                }
            }*/
            DB::commit();
            return response()->json(['code'=> 200,'msg'=>'操作成功','data'=>$adm_res]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'操作失败','data'=>'']);
        }
    }

    /*
     * @name 新增会员关联节日提醒
     * @retrun array
     * @author Ma 2023/9/6 18:08
     *
    */
    public static function addFestival($mem_id,$user_info = ''){
        $me_data = DB::table('member')
            ->where('mem_id', $mem_id)
            ->first();
        if($me_data){
            //查找会员是否有设置
            $me_count = DB::table('member_festival')
                ->where('mefe_mem_id', $mem_id)
                ->count();
            if($me_count == 0){
                //查找会员店铺设置了提醒的节日
                $find_data = DB::table('festival_remind')
                    ->where('fest_shop_id', $me_data->mem_shop_id)
                    ->where('fest_start', 1)//自动开始
                    ->where('fest_status', 1)//状态正常
                    ->get()->toArray();
                if($find_data){
                    $res = DB::table('member_festival')
                        ->where('mefe_id', $mem_id)
                        ->count();
                    if($res == 0){
                        foreach ($find_data as $key => $value){
                            $add_data['mefe_cid'] = $me_data->mem_cid;
                            $add_data['mefe_shop_id'] = $me_data->mem_shop_id;
                            $add_data['mefe_superior_shop_id'] = $me_data->mem_superior_shop_id;
                            $add_data['mefe_mem_id'] = $mem_id;//客户id
                            $add_data['mefe_create_time'] = date('Y-m-d H:i:s');
                            $add_data['mefe_create_name'] = $user_info->adm_name ?? '';
                            $add_data['mefe_create_id'] = $user_info->adm_id ?? 0;
                            $add_data['mefe_fest_id'] = $value->fest_id;//节日id
                            $add_data['mefe_fest_type'] = $value->fest_type;
                            $data =  DB::table('member_festival')->insertGetId($add_data);
                        }
                    }
                }
            }

        }
    }

    /*
     * @name 计算会员累计消费
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/6 19:22
     *
    */
    public static function consume_money($mem_id){
        $count = 0;
        $data = DB::table('order')
            ->where('ord_client_id', $mem_id)
            ->where('ord_wor_state', '<>',11)
            ->select(DB::raw('SUM(ord_actual_price) as count'))
            ->first();
        if($data){
            $count = $data->count;
        }
        if($mem_id && $count){
            $data = DB::table('member')
                ->where('mem_id', $mem_id)->update(['mem_consume_money'=>$count]);//更新累计消费
        }
        $order = DB::table('order')
            ->where('ord_client_id', $mem_id)
            ->where('ord_wor_state', '<>',11)
            ->where('ord_actual_price', '>=',0)
            ->select('ord_id')
            ->count();
        if($mem_id && $order){
            $data = DB::table('member')
                ->where('mem_id', $mem_id)->update(['mem_order_all'=>$order]);//更新订单量
        }
        $mem_data = DB::table('member')
            ->where('mem_id', $mem_id)
            ->first();
        if($mem_data){
            if($mem_data->mem_first_time == '0000-00-00 00:00:00'){
                $update['mem_first_time'] = date('Y-m-d H:i:s');//首次下单时间
            }
            $update['mem_last_time'] = date('Y-m-d H:i:s');//最后下单时间
            $ret = DB::table('member')->where('mem_id', $mem_id)->update($update);
        }
        return $count;
    }

    /**
     * 换货
     *
     * @param $request
     * @return array
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function exchangeGoods($request)
    {
        try {
            $orderId = $request['order_id'];
            $exGoodsInfo = json_decode($request['ex_goods_info'], true);
            $type = !empty($request['type'])? $request['type']: 1;//1付款 2退款
            $typeId = !empty($request['type_id'])? $request['type_id']: 0;//退款方式3现金5余额
            $ordOrderPrice = $request['ord_order_price']*100;//订单金额
            $money = $request['money']*100;//退款和付款金额
            $orderNumber = $request['ord_order_number'];//订单编号
            $ordPaymentMoney = 0;//支付金额
            $ordBanlance = 0;//余额
            if(($type == 1 && in_array($typeId, [6,7])) || ($type == 2 && $typeId == 5)){
                $ordBanlance = $money;//余额
            }
            if(($type == 1 && in_array($typeId, [1,2,3,4])) || ($type == 2 && $typeId == 3)){
                $ordPaymentMoney = $money;//支付金额
            }
            $orcl_sales_adm_id = DB::table('order_client')
                ->where('orcl_ord_id', $orderId)
                ->value('orcl_sales_adm_id');

            //获取用户信息
            $user_info = LoginUserService::getUser();

            $orderInfo = WashOrder::getDataByOrdId($orderId);
            if(!in_array($orderInfo->ord_payment_way, [0,1,2,3,4,5,6,7,8,9]) && $money != 0) {
                return ['code' => 500, 'msg' => '赠品不可退款', 'data' => []];
            }
            $newOrdPaymentMoney = $orderInfo->ord_payment_money + $ordPaymentMoney;//新的支付金额
            $newOrdBanlance = $orderInfo->ord_banlance + $ordBanlance;//新的余额
            if($newOrdBanlance < 0){
                $newOrdPaymentMoney = $newOrdPaymentMoney + $newOrdBanlance;
                $newOrdBanlance = 0;
            }
            $newOrdActualPrice = $newOrdPaymentMoney;//新的结算金额

            DB::beginTransaction();

            //更新订单表
            $updateOrderData = [
                'ord_order_price' => $ordOrderPrice,
                'ord_actual_price' => $newOrdActualPrice,
                'ord_update_time' => date("Y-m-d H:i:s", time()),
                'ord_payment_money' => $newOrdPaymentMoney,
                'ord_banlance' => $newOrdBanlance,
            ];
            $newOrdtate = 1;
            if ($newOrdPaymentMoney + $newOrdBanlance >= $ordOrderPrice) {
                $newOrdtate = 2;//已结算
                $updateOrderData['ord_settlement_time'] = date("Y-m-d H:i:s", time());
                $updateOrderData['ord_settlement_adm_id'] = $user_info->adm_id;
            } elseif ($newOrdPaymentMoney + $newOrdBanlance == 0) {
                $newOrdtate = 1;//未结算
            } elseif ($newOrdPaymentMoney + $newOrdBanlance < $ordOrderPrice) {
                $newOrdtate = 3;//部分结算
                $updateOrderData['ord_settlement_time'] = date("Y-m-d H:i:s", time());
                $updateOrderData['ord_settlement_adm_id'] = $user_info->adm_id;
            }

            if ($type == 1) {
                //付款
                $updateOrderData['ord_state'] = $newOrdtate;
                if ($orderInfo->ord_payment_way == 0) {
                    $updateOrderData['ord_payment_way'] = $typeId;
                }
                if ($orderInfo->ord_other_payway == 0) {
                    $updateOrderData['ord_other_payway'] = $typeId;
                }
            }
            $updateFasterOrderRes = WashOrder::updateByOrdId($orderId, $updateOrderData);
            if (!$updateFasterOrderRes) {
                return ['code' => 500, 'msg' => '更新订单表错误', 'data' => []];
                DB::rollback();
            }

            //更新订单商品表
            $newGoodIds = [];//商品
            $newServiceIds = [];//服务
            $exchangeNum = 0;//换货商品数量
            $orgoIds = [];//原订单商品id
            foreach ($exGoodsInfo as $val) {
                if($val['new_goods_info']['new_goo_type'] == 2) {
                    $newServiceIds[] = $val['new_goods_info']['new_goo_id'];
                }elseif ($val['new_goods_info']['new_goo_type'] == 1) {
                    $newGoodIds[] = $val['new_goods_info']['new_goo_id'];
                }
                $orgoIds[] = $val['orgo_id'];
                $exchangeNum += $val['new_goods_info']['new_goo_quantity'];
            }
            $recycleOrderGoodsInfos = OrderGoods::getDataByOrgoIds($orgoIds);
            //组装商品对应信息
            if(!empty($newGoodIds)) {
                $orderGoods = Goods::getDataByGoodIds($newGoodIds);
                $orgoIDGoodsRelation = [];
                foreach ($orderGoods as $orderGood) {
                    $orgoIDGoodsRelation[$orderGood->goo_id] = $orderGood;
                }
            }
            //组装服务对应信息
            if(!empty($newServiceIds)) {
                $orderServices = ServiceProject::getDataBySeprIds($newServiceIds);
                $orgoIDServiceRelation = [];
                foreach ($orderServices as $orderService) {
                    $orgoIDServiceRelation[$orderService->sepr_id] = $orderService;
                }
            }

            foreach ($exGoodsInfo as $key => $val) {
                $orgoId = $val['orgo_id'];
                $newGooId = $val['new_goods_info']['new_goo_id'];
                $newGooQuantity = $val['new_goods_info']['new_goo_quantity'];
                $newWagoId = $val['new_goods_info']['new_wago_id'];
                $newWareId = $val['new_goods_info']['new_ware_id'];
                $newGooPrice = !empty($val['new_goods_info']['new_goo_price'])? $val['new_goods_info']['new_goo_price']: 0;
                $newGooType = $val['new_goods_info']['new_goo_type'];
                $updateOrderGoodsData = [
                    'orgo_wago_id' => $newWagoId,
                    'orgo_goo_id' => $newGooId,
                    'orgo_actual_goo_id' => $newGooId,
                    'orgo_goo_quantity' => $newGooQuantity,
                    'orgo_can_assign_quantity' => $newGooQuantity,
                    'orgo_goo_exchange' => 2,
                    'orgo_goo_amount' => $newGooQuantity * $newGooPrice * 100,
                    'orgo_update_time' => date("Y-m-d H:i:s", time()),
                    'orgo_goo_price' => $newGooPrice * 100,
                ];

                if($newGooType == 1) {
                    //商品
                    $updateOrderGoodsData['orgo_ware_id'] = $newWareId;
                    $updateOrderGoodsData['orgo_goo_name'] = $orgoIDGoodsRelation[$newGooId]->goo_name;
                    $updateOrderGoodsData['orgo_goo_unta_id'] = $orgoIDGoodsRelation[$newGooId]->goo_unta_id;
                    $updateOrderGoodsData['orgo_goo_unit'] = $orgoIDGoodsRelation[$newGooId]->goo_type == 2 ? '次' : $orgoIDGoodsRelation[$newGooId]->goo_unit;
                    $updateOrderGoodsData['orgo_goo_guarantee'] = $orgoIDGoodsRelation[$newGooId]->goo_guarantee;
                    $updateOrderGoodsData['orgo_goo_ampere_hour'] = $orgoIDGoodsRelation[$newGooId]->goo_ampere_hour;
                    $updateOrderGoodsData['orgo_goo_goods_encode'] = $orgoIDGoodsRelation[$newGooId]->goo_goods_encode;
                }
                if($newGooType == 2) {
                    //服务
                    $updateOrderGoodsData['orgo_goo_name'] = $orgoIDServiceRelation[$newGooId]->sepr_name;
                }
                //原商品
                $orgo_goo_id = DB::table('order_goods')
                    ->where('orgo_id', $orgoId)
                    ->value('orgo_goo_id');

                if (!empty($orcl_sales_adm_id)) {
                    $updateOrderGoodsData['orgo_sale_performance'] = DB::table('goods_performance')
                        ->where('gppe_type', $newGooType)
                        ->where('gppe_goo_id', $newGooId)
                        ->where('gppe_sale_id', $orcl_sales_adm_id)
                        ->value('gppe_performance');
                }
                $updateOrderGoodsRes = OrderGoods::updateByorgoId($orgoId, $updateOrderGoodsData);

                //修改采购计划
                $old_goods_data[$key]['goo_id'] = $orgo_goo_id;
                $new_goods_data[$key]['goo_id'] = $newGooId;

                if (!$updateOrderGoodsRes) {
                    return ['code' => 500, 'msg' => '更新订单商品表错误', 'data' => []];
                    DB::rollback();
                }

                //判断是否有服务工单
                $workGoodInfo = WorkGood::getDataByOrgoId($orgoId);
                if (!empty($workGoodInfo)) {
                    //更新服务工单商品表
                    $updateWorkGoodsData = [
                        'wogo_ware_id' => $newWareId,
                        'wogo_actual_goo_id' => $newGooId,
                        'wogo_wago_id' => $newWagoId,
                        'wogo_goo_id' => $newGooId,
                        'wogo_state' => 4,
                        'wogo_goo_exchange' => 2,
                        'wogo_remark' => '换货',
                        'wogo_goo_price' => $newGooPrice*100,
                        'wogo_goo_amount' => $newGooQuantity,
                        'wogo_update_time' => date("Y-m-d H:i:s", time()),
                    ];
                    if($newGooType == 1) {
                        //商品
                        $updateWorkGoodsData['wogo_goo_name'] = $orgoIDGoodsRelation[$newGooId]->goo_name;
                        $updateWorkGoodsData['wogo_goo_goods_encode'] = $orgoIDGoodsRelation[$newGooId]->goo_goods_encode;
                        $updateWorkGoodsData['wogo_goo_unta_id'] = $orgoIDGoodsRelation[$newGooId]->goo_unta_id;
                        $updateWorkGoodsData['wogo_goo_guarantee'] = $orgoIDGoodsRelation[$newGooId]->goo_guarantee;
                        $updateWorkGoodsData['wogo_goo_unit'] = $orgoIDGoodsRelation[$newGooId]->goo_type == 2 ? '次' : $orgoIDGoodsRelation[$newGooId]->goo_unit;
                    }
                    if($newGooType == 2) {
                        //服务
                        $updateWorkGoodsData['wogo_goo_name'] = $orgoIDServiceRelation[$newGooId]->sepr_name;
                        $updateWorkGoodsData['wogo_goo_unit'] = '次';
                    }

                    $updateWorkGoodsRes = WorkGood::updateDataByworId($workGoodInfo->wogo_id, $updateWorkGoodsData);
                    if (!$updateWorkGoodsRes) {
                        return ['code' => 500, 'msg' => '更新服务工单商品表错误', 'data' => []];
                        DB::rollback();
                    }
                }
            }

            //更新订单应收应付表
            $recpayCostPrice = 0;//订单的所有商品的成本价
            $ordreGoodsArr = OrderGoods::getDataByorgoId($orderId);
            foreach ($ordreGoodsArr as $v) {
                if($v->orgo_goo_type == 1) {
                    //商品
                    $warehouseGood = WarehouseGoods::getDataByWareIdGoodId($v->orgo_ware_id, $v->orgo_goo_id);
                    if(!empty($warehouseGood)) {
                        $recpayCostPrice += $warehouseGood->wago_goo_price * $v->orgo_goo_quantity * 100;
                    }
                }
            }
            $profit = $newOrdPaymentMoney - $recpayCostPrice;
            $updateReceivablePayData = [
                'recpay_receivable_price' => $ordOrderPrice,
                'recpay_arrears_price' => $ordOrderPrice - $newOrdPaymentMoney - $newOrdBanlance,
                'recpay_actual_price' => $newOrdPaymentMoney,
                'recpay_cost_price' => $recpayCostPrice,
                'recpay_profit' => $profit,
                'recpay_plus_minus' => $profit> 0? 1: 2,
                'recpay_update_time' => date("Y-m-d H:i:s", time()),
            ];
            $updateReceivablePayRes = ReceivablePay::updateByOrderId($orderId, $updateReceivablePayData);
            if (!$updateReceivablePayRes) {
                return ['code' => 500, 'msg' => '更新订单应收应付表错误', 'data' => []];
                DB::rollback();
            }

            //添加订单结算详情表
            if ($type == 1 && $ordPaymentMoney > 0) {
                //付款
                if ($orderInfo->ord_type == 1 || $orderInfo->ord_type == 0) {
                    $insertOrderSettlementDetailsData['orsd_mem_type'] = 1;
                } else {
                    $insertOrderSettlementDetailsData['orsd_mem_type'] = 2;
                }
                $insertOrderSettlementDetailsRes = OrderSettlementDetails::addOrderSettlementDetails($orderInfo->ord_id, $insertOrderSettlementDetailsData['orsd_mem_type'], $request, $user_info, $ordPaymentMoney, '',$typeId);
                if (!$insertOrderSettlementDetailsRes) {
                    return ['code' => 500, 'msg' => '添加订单结算详情表错误', 'data' => []];
                    DB::rollback();
                }
            }

            //退款方式为实时和财务生成退款单
            if ($type == 2 && $typeId == 3) {
                $insertRefundData = [
                    'ref_cid' => $orderInfo->ord_cid,
                    'ref_superior_shop_id' => $orderInfo->ord_superior_shop_id,
                    'ref_shop_id' => $orderInfo->ord_shop_id,
                    'ref_retgo_id' => 0,
                    'ref_retgo_number' => "",
                    'ref_number' => 'TK' . time() . rand(10000000, 99999999),//退款单号
                    'ref_order_number' => $orderInfo->ord_order_number,
                    'ref_reason' => '换货',
                    'ref_status' => $typeId == 3 ? 2 : 1,
                    'ref_refund_status' => $typeId == 3 ? 2 : 1,
                    'ref_refund_method' => $typeId == 3 ? '实时' : '财务',
                    'ref_amount' => $money,
                    'ref_create_time' => date("Y-m-d H:i:s", time()),
                    'ref_create_name' => $user_info->adm_name,
                    'ref_create_id' => $user_info->adm_id,
                    'ref_update_time' => date("Y-m-d H:i:s", time()),
                ];
                $insertRefundRes = Refund::insert($insertRefundData);
                if (!$insertRefundRes) {
                    return ['code' => 500, 'msg' => '添加退款表错误', 'data' => []];
                    DB::rollback();
                }
                if ($orderInfo->ord_type == 1 || $orderInfo->ord_type == 0) {
                    $insertOrderSettlementDetailsData['orsd_mem_type'] = 1;
                } else {
                    $insertOrderSettlementDetailsData['orsd_mem_type'] = 2;
                }
                $insertOrderSettlementDetailsRes = OrderSettlementDetails::addOrderSettlementDetails($orderInfo->ord_id, $insertOrderSettlementDetailsData['orsd_mem_type'], $request, $user_info, $ordPaymentMoney, '',1);
                if (!$insertOrderSettlementDetailsRes) {
                    return ['code' => 500, 'msg' => '添加订单结算详情表错误', 'data' => []];
                    DB::rollback();
                }
            }

            //付款方式为余额和他人代付 更新余额和添加余额消费记录
            if ($type == 1 && ($typeId == 6 || $typeId == 7)) {//type1付款 2退款
                if ($orderInfo->ord_type == 1 || $orderInfo->ord_type == 0) {//个人会员
                    //更新成员表充值金额和赠送金额
                    $memberInfo = Member::getDataByMemId($orderInfo->ord_client_id);
                    $memRecBanlance = $memberInfo->mem_rec_banlance;//充值金额
                    $memGiftBanlance = $memberInfo->mem_gift_banlance;//赠送金额
                    if (($memRecBanlance + $memGiftBanlance) < $money) {
                        return ['code' => 500, 'msg' => '余额不够', 'data' => []];
                        DB::rollback();
                    }

                    if ($memRecBanlance >= $money) {
                        $reloRecNum = $money;//日志充值金额
                        $reloGiftNum = 0;//日志赠送金额
                        $NewMemRecBanlance = $memRecBanlance - $money;//新的充值金额
                        $NewMemGiftBanlance = $memGiftBanlance;//新的赠送金额
                    } else {
                        $reloRecNum = $memRecBanlance;//日志充值金额
                        $reloGiftNum = $money - $memRecBanlance;//日志赠送金额
                        $NewMemRecBanlance = 0;//新的充值金额
                        $NewMemGiftBanlance = $memGiftBanlance - ($money - $memRecBanlance);//新的赠送金额
                    }

                    $updateMemberData = [
                        'mem_rec_banlance' => $NewMemRecBanlance,
                        'mem_gift_banlance' => $NewMemGiftBanlance,
                        'mem_update_time' => date("Y-m-d H:i:s", time()),
                    ];
                    $updateMemberRes = Member::updateByMemId($orderInfo->ord_client_id, $updateMemberData);
                    if (!$updateMemberRes) {
                        return ['code' => 500, 'msg' => '付款更新成员表错误', 'data' => []];
                        DB::rollback();
                    }

                    //插入余额充值以及消费日志
                    $insertRecLogData = [
                        'relo_type' => 2,
                        'relo_rec_num' => $reloRecNum,
                        'relo_gift_num' => $reloGiftNum,
                        'relo_ord_id' => $orderInfo->ord_id,
                        'relo_create_id' => $user_info->adm_id,
                        'relo_remark' => '换货',
                        'relo_create_time' => date("Y-m-d H:i:s", time()),
                        'relo_mem_id' => $orderInfo->ord_client_id,
                    ];
                    $insertRecLogRes = RecLog::insert($insertRecLogData);
                    if (!$insertRecLogRes) {
                        return ['code' => 500, 'msg' => '付款新增余额充值以及消费日志表错误', 'data' => []];
                        DB::rollback();
                    }
                } else {
                    //更新成员表充值金额和赠送金额
                    $ord_client = DB::table('order_client')
                        ->where('orcl_ord_id', $orderInfo->ord_id)
                        ->first();
                    $memberInfo = DB::table('business_client')
                        ->where('bucl_id', $ord_client->orcl_business_id)
                        ->first();
                    $memRecBanlance = $memberInfo->bucl_rec_banlance;//充值金额
                    $memGiftBanlance = $memberInfo->bucl_gift_banlance;//赠送金额
                    if (($memRecBanlance + $memGiftBanlance) < $money) {
                        return ['code' => 500, 'msg' => '余额不够', 'data' => []];
                        DB::rollback();
                    }

                    if ($memRecBanlance >= $money) {
                        $reloRecNum = $money;//日志充值金额
                        $reloGiftNum = 0;//日志赠送金额
                        $NewMemRecBanlance = $memRecBanlance - $money;//新的充值金额
                        $NewMemGiftBanlance = $memGiftBanlance;//新的赠送金额
                    } else {
                        $reloRecNum = $memRecBanlance;//日志充值金额
                        $reloGiftNum = $money - $memRecBanlance;//日志赠送金额
                        $NewMemRecBanlance = 0;//新的充值金额
                        $NewMemGiftBanlance = $memGiftBanlance - ($money - $memRecBanlance);//新的赠送金额
                    }

                    $updateMemberData = [
                        'bucl_rec_banlance' => $NewMemRecBanlance,
                        'bucl_gift_banlance' => $NewMemGiftBanlance,
                        'bucl_update_time' => date("Y-m-d H:i:s", time()),
                    ];
                    $updateMemberRes = DB::table('business_client')
                        ->where('bucl_id', $ord_client->orcl_business_id)
                        ->update($updateMemberData);
                    if (!$updateMemberRes) {
                        return ['code' => 500, 'msg' => '付款更新成员表错误', 'data' => []];
                        DB::rollback();
                    }

                    //插入余额充值以及消费日志
                    $insertRecLogData = [
                        'relo_type' => 2,
                        'relo_mem_type' => 2,
                        'relo_rec_num' => $reloRecNum,
                        'relo_gift_num' => $reloGiftNum,
                        'relo_ord_id' => $orderInfo->ord_id,
                        'relo_create_id' => $user_info->adm_id,
                        'relo_remark' => '换货',
                        'relo_create_time' => date("Y-m-d H:i:s", time()),
                        'relo_mem_id' => $ord_client->orcl_business_id,
                    ];
                    $insertRecLogRes = RecLog::insert($insertRecLogData);
                    if (!$insertRecLogRes) {
                        return ['code' => 500, 'msg' => '付款新增余额充值以及消费日志表错误', 'data' => []];
                        DB::rollback();
                    }
                }
            }

            //退款方式为余额 更新余额和添加余额消费记录
            if ($type == 2 && $typeId == 5) {
                if($orderInfo->ord_banlance >= abs($money)){
                    $return_num = abs($money);
                }else{
                    $return_num = $orderInfo->ord_banlance;
                    $addBanlance = abs($money) - $orderInfo->ord_banlance;
                    if ($orderInfo->ord_type == 1) {
                        //充值余额
                        $data = [
                            'mem_gift_banlance' => 0,
                            'mem_id' => $orderInfo->ord_client_id,
                            'mem_rec_banlance' => $addBanlance/100,
                            'ord_payment_way' => 1,
                            'ord_pic' => [],
                            'remark' => '换货退余额',
                        ];
                        $result1 = self::recharge($user_info, $data);
                        if($result1["code"] != 200) {
                            return ['code' => 500, 'msg' => '充值余额错误', 'data' => []];
                            DB::rollback();
                        }
                    } elseif ($orderInfo->ord_type == 2) {
                        //更新成员表充值金额和赠送金额
                        $ord_client = DB::table('order_client')
                            ->where('orcl_ord_id', $orderInfo->ord_id)
                            ->first();
                        //充值余额
                        $data = [
                            'mem_gift_banlance' => 0,
                            'mem_id' => $ord_client->orcl_business_id,
                            'bcac_id' => $orderInfo->ord_client_id,
                            'mem_rec_banlance' => $addBanlance/100,
                            'ord_payment_way' => 1,
                            'ord_pic' => [],
                            'remark' => '换货退余额',
                        ];
                        $result1 = self::busRecharge($user_info, $data);
                        if($result1["code"] != 200) {
                            return ['code' => 500, 'msg' => '充值余额错误', 'data' => []];
                            DB::rollback();
                        }
                    }
                }

                $result = RecLogService::getReturnMoenyRout($orderInfo->ord_id, $return_num);
                if ($orderInfo->ord_type == 1) {
                    $memberId = $result['relo_mem_id'] == 0 ? $orderInfo->ord_client_id : $result['relo_mem_id'];
                    $memberInfo = Member::getDataByMemId($memberId);
                    $updateMemberData = [
                        'mem_rec_banlance' => $memberInfo->mem_rec_banlance + $result['relo_rec_num'],
                        'mem_gift_banlance' => $memberInfo->mem_gift_banlance + $result['relo_gift_num'],
                        'mem_update_time' => date("Y-m-d H:i:s", time()),
                    ];
                    $updateMemberRes = Member::updateByMemId($memberId, $updateMemberData);
                } else {
                    $ord_client = DB::table('order_client')
                            ->where('orcl_ord_id', $orderInfo->ord_id)
                            ->first();
                    $memberId = $result['relo_mem_id'] == 0 ? $ord_client->orcl_business_id : $result['relo_mem_id'];
                    $memberInfo = DB::table('business_client')
                        ->where('bucl_id', $memberId)
                        ->first();
                    $updateMemberData = [
                        'bucl_rec_banlance' => $memberInfo->bucl_rec_banlance + $result['relo_rec_num'],
                        'bucl_gift_banlance' => $memberInfo->bucl_gift_banlance + $result['relo_gift_num'],
                        'bucl_update_time' => date("Y-m-d H:i:s", time()),
                    ];
                    $updateMemberRes = DB::table('business_client')
                        ->where('bucl_id', $memberId)
                        ->update($updateMemberData);
                }

                if ($orderInfo->ord_type == 1 || $orderInfo->ord_type == 0) {
                    $insertOrderSettlementDetailsData['orsd_mem_type'] = 1;
                } else {
                    $insertOrderSettlementDetailsData['orsd_mem_type'] = 2;
                }
                $insertOrderSettlementDetailsRes = OrderSettlementDetails::addOrderSettlementDetails($orderInfo->ord_id, $insertOrderSettlementDetailsData['orsd_mem_type'], $request, $user_info, $ordBanlance, '',6);
                if (!$insertOrderSettlementDetailsRes) {
                    return ['code' => 500, 'msg' => '添加订单结算详情表错误', 'data' => []];
                    DB::rollback();
                }
                //插入余额充值以及消费日志
                if($result['relo_rec_num'] !=0 || $result['relo_gift_num'] != 0) {
                    $insertRecLogData = [
                        'relo_type' => 4,
                        'relo_mem_type' => $orderInfo->ord_type,
                        'relo_rec_num' => $result['relo_rec_num'],
                        'relo_gift_num' => $result['relo_gift_num'],
                        'relo_ord_id' => $orderInfo->ord_id,
                        'relo_create_id' => $user_info->adm_id,
                        'relo_create_time' => date("Y-m-d H:i:s", time()),
                        'relo_remark' => '换货',
                        'relo_mem_id' => $memberId,
                    ];
                    $insertRecLogRes = RecLog::insert($insertRecLogData);
                    if (!$insertRecLogRes) {
                        return ['code' => 500, 'msg' => '退款新增余额充值以及消费日志表错误', 'data' => []];
                        DB::rollback();
                    }
                }
            }

            $workOrderInfo = WorkOrder::getDataByWorOrderNumber($orderNumber);
            $degoWorId = $workOrderInfo->wor_id??$orderId;//工单号不存在用订单号
            $degoOriginalNumber = $workOrderInfo->wor_number??$orderNumber;//工单号不存在用订单号
            $dispatchBill = DispatchBillModel::getDataByOrderId($degoWorId);
            //未发货 原发货单作废
            if(!empty($dispatchBill) && $dispatchBill->dego_type == 1) {
                $updateDispatchBillData = [
                    'dego_type' => 3,
                    'dego_update_time' => date("Y-m-d H:i:s", time()),
                ];
                $updateDispatchBillRes = DispatchBillModel::updateByDegoId($dispatchBill->dego_id, $updateDispatchBillData);
                if (!$updateDispatchBillRes) {
                    return ['code' => 500, 'msg' => '更新发货单表错误', 'data' => []];
                    DB::rollback();
                }

            }

            //已发货 新加入库单
            if(!empty($dispatchBill) && $dispatchBill->dego_type == 2){
                //新增退换回收单表
                $insertRecedeRecycleData = [
                    'rec_cid' => $user_info->adm_cid,
                    'rec_superior_shop_id' => $user_info->shop_superior_id ?$user_info->shop_superior_id: $user_info->adm_shop_id,
                    'rec_shop_id' => $user_info->adm_shop_id,
                    'rec_date' => date('Y-m-d'),
                    'rec_number' => 'TH' . rand(100, 999) . date('mdHis') . rand(100000, 999999),
                    'rec_ord_id' => $workOrderInfo->wor_id??$orderInfo->ord_id,
                    'rec_ord_order_number' => $workOrderInfo->wor_number??$orderInfo->ord_order_number,
                    'rec_source_type' => 2,
                    'rec_price' => $recpayCostPrice,
                    'rec_amount' => $exchangeNum,
                    'rec_type' => $workOrderInfo->wor_type??$orderInfo->ord_type,
                    'rec_ware_id' => $workOrderInfo->wor_ware_id??$orderInfo->ord_ware_id,
                    'rec_create_adm_id' => $user_info->adm_id,
                    'rec_remark' => '换货',
                    'rec_create_time' => date("Y-m-d H:i:s", time()),
                    'rec_update_time' => date("Y-m-d H:i:s", time()),
                ];
                $recedeRecycleId = RecedeRecycle::insert($insertRecedeRecycleData);
                if (!$recedeRecycleId) {
                    return ['code' => 500, 'msg' => '换货新增退换回收单表错误', 'data' => []];
                    DB::rollback();
                }

                //新增退换回收商品表
                foreach($recycleOrderGoodsInfos as $orderGoodsInfo) {
                    $insertRecedeGoodsData = [
                        'rego_rec_id' => $recedeRecycleId,
                        'rego_ware_id' => $orderGoodsInfo->orgo_ware_id,
                        'rego_orgo_id' => $orderGoodsInfo->orgo_id,
                        'rego_waon_class' => 1,
                        'rego_wago_id' => $orderGoodsInfo->orgo_wago_id,
                        'rego_wafr_id' => $orderGoodsInfo->orgo_wafr_id,
                        'rego_wafg_id' => $orderGoodsInfo->orgo_wafg_id,
                        'rego_goo_id' => $orderGoodsInfo->orgo_goo_id,
                        'rego_goo_name' => $orderGoodsInfo->orgo_goo_name,
                        'rego_goo_goods_encode' => $orderGoodsInfo->orgo_goo_goods_encode,
                        'rego_goo_price' => $orderGoodsInfo->orgo_goo_price,
                        'rego_sell_number' => $orderGoodsInfo->orgo_goo_quantity,
                        'rego_recycle_number' => $orderGoodsInfo->orgo_goo_quantity,
                        'rego_goo_inventory'=> $orderGoodsInfo->orgo_goo_inventory,
                        'rego_create_time'=> date("Y-m-d H:i:s", time()),
                        'rego_update_time'=> date("Y-m-d H:i:s", time()),
                        'rego_goo_unit'=> $orderGoodsInfo->orgo_goo_unit,
                        'rego_goo_unta_id'=> $orderGoodsInfo->orgo_goo_unta_id,
                    ];
                    $insertRecedeGoodsRes = RecedeGoods::insert($insertRecedeGoodsData);
                    if (!$insertRecedeGoodsRes) {
                        return ['code' => 500, 'msg' => '新增退换回收商品表错误', 'data' => []];
                        DB::rollback();
                    }
                }


                //新增退换回收客户表
                if(!empty($workOrderInfo)) {
                    $workclient = WorkClient::getDataByWoclWorId($workOrderInfo->wor_id);
                    $reclClientId = $workclient->wocl_client_id;
                    $reclChannelUnit = $workclient->wocl_bus_name;
                    $reclName = $workclient->wocl_name;
                    $reclPhone = $workclient->wocl_phone;
                }else{
                    $orderclient = OrderClient::getDataByOrderId($orderInfo->ord_id);
                    $reclClientId = $orderclient->orcl_client_id;
                    $reclChannelUnit = $orderclient->orcl_business_name;
                    $reclName = $orderclient->orcl_name;
                    $reclPhone = $orderclient->orcl_phone;
                }

                $insertRecedeClientData = [
                   'recl_rec_id' => $recedeRecycleId,
                   'recl_client_id' => $reclClientId,
                   'recl_name' => $reclName,
                   'recl_phone' => $reclPhone,
                   'recl_create_time' => date("Y-m-d H:i:s", time()),
                   'recl_update_time' => date("Y-m-d H:i:s", time()),
                ];

                $type = $workOrderInfo->wor_type??$orderInfo->ord_type;
                if ($type == 2) {
                    $insertRecedeClientData['recl_channel_unit'] = $reclChannelUnit; //合作商
                }

                $insertRecedeClientRes = RecedeClient::insert($insertRecedeClientData);
                if (!$insertRecedeClientRes) {
                    return ['code' => 500, 'msg' => '换货新增退换回收客户表错误', 'data' => []];
                    DB::rollback();
                }
            }

            if(!empty($dispatchBill) ) {
                //新增发货单
                $insertDispatchBillData = [
                    'dego_cid' => $orderInfo->ord_cid,
                    'dego_superior_shop_id' => $orderInfo->ord_superior_shop_id,
                    'dego_shop_id' => $orderInfo->ord_shop_id,
                    'dego_service_shop_id' => $orderInfo->ord_shop_id,
                    'dego_number' => 'FH'.time().rand(100,999),
                    'dego_order_type' => $dispatchBill->dego_order_type,
                    'dego_original_number' => $degoOriginalNumber,
                    'dego_wor_id' => $degoWorId,
                    'dego_client_type' => $orderInfo->ord_type,
                    'dego_client_id' => $orderInfo->ord_client_id,
                    'dego_out_ware_id' => $orderInfo->ord_ware_id,
                    'dego_service_adm_id' => $orderInfo->ord_service_adm_id,
                    'dego_create_adm_id' => $user_info->adm_id,
                    'dego_remark' => '换货',
                    'dego_create_time' => date("Y-m-d H:i:s", time()),
                    'dego_update_time' => date("Y-m-d H:i:s", time()),
                    'dego_pic' => "",
                ];
                $insertDispatchBillId = DispatchBillModel::insert($insertDispatchBillData);
                if (!$insertDispatchBillId) {
                    return ['code' => 500, 'msg' => '新增发货单表错误', 'data' => []];
                    DB::rollback();
                }

                //新增发货商品表
                foreach ($ordreGoodsArr as $val) {
                    if($val->orgo_goo_type == 1) {
                        //商品
                        $insertDispatchGoodsData = [
                            'digo_dego_id' => $insertDispatchBillId,
                            'digo_orgo_id' => $val->orgo_id,
                            'digo_wago_id' => $val->orgo_wago_id,
                            'digo_goo_id' => $val->orgo_goo_id,
                            'digo_tem_goo_name' => $val->orgo_tem_goo_name,
                            'digo_goo_material_pic' => "",
                            'digo_goo_price' => $val->orgo_goo_price,
                            'digo_goo_quantity' =>  $val->orgo_goo_quantity,
                            'digo_goo_inventory' => 1,
                            'digo_state' => 4,
                            'digo_update_time' => date("Y-m-d H:i:s", time()),
                            'digo_goo_name' => $val->orgo_goo_name,
                            'digo_goo_goods_encode' => $val->orgo_goo_goods_encode,
                            'digo_goo_unta_id' => $val->orgo_goo_unta_id,
                            'digo_goo_unit' => $val->orgo_goo_type == 2 ? '次' : $val->orgo_goo_unit,
                        ];
                        $insertDispatchGoodsRes = DispatchGoods::insert($insertDispatchGoodsData);
                        if (!$insertDispatchGoodsRes) {
                            return ['code' => 500, 'msg' => '新增发货商品表错误', 'data' => []];
                            DB::rollback();
                        }
                    }
                }
            }
            //新商品
            $post_data['ware_id'] = $orderInfo->ord_ware_id;
            $post_data['new_goods_data'] = $new_goods_data;
            $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);

            $post_data['ware_id'] = $orderInfo->ord_ware_id;
            $post_data['new_goods_data'] = $old_goods_data;
            $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
            DB::commit();
            return ['code' => 200, 'msg' => '成功', 'data' => []];
        } catch (\Exception $e) {
            echo $e->getMessage();
            DB::rollback();
            return ['code' => 500, 'msg' => '失败', 'data' => []];
        }
    }

    // 购买积分商品
    public static function addPointOrder($user_info, $request)
    {
        $point_gift_goods = DB::table('point_gift_goods')
            ->where('pogg_id', $request['pogg_id'])
            ->first();
        if ($point_gift_goods->pogg_state == 2) {
            return ['code'=>500, 'msg'=>'此商品已下架', 'data'=>''];
        }
        if ($point_gift_goods->pogg_limited_time == 1 && time()>strtotime($point_gift_goods->pogg_end_time.'23:59:59')) {
            return ['code'=>500, 'msg'=>'此商品已过兑换时间', 'data'=>''];
        }
        if ($point_gift_goods->pogg_goo_limitation == 1 && $point_gift_goods->pogg_goo_num<=0) {
            return ['code'=>500, 'msg'=>'此商品已售罄', 'data'=>''];
        }
        $point_goods_log = DB::table('point_goods_log')
            ->where('pglo_shop_id', $user_info->adm_shop_id)
            ->where('pglo_mem_id', $user_info->ussh_user_id)
            ->where('pglo_pogg_id', $request['pogg_id'])
            ->count();
        $today_num = DB::table('point_goods_log')
            ->where('pglo_shop_id', $user_info->adm_shop_id)
            ->where('pglo_mem_id', $user_info->ussh_user_id)
            ->where('pglo_pogg_id', $request['pogg_id'])
            ->where('pglo_time', date('Y-m-d'))
            ->count();
        if ($point_goods_log >= $point_gift_goods->pogg_exchange_person) {
            return ['code'=>500, 'msg'=>'已达到兑换上限', 'data'=>''];
        }
        if ($today_num >= $point_gift_goods->pogg_exchange_day) {
            return ['code'=>500, 'msg'=>'今日已达到兑换上限', 'data'=>''];
        }
        $mem_data = DB::table('member')
            ->where('mem_id', $user_info->ussh_user_id)
            ->select('mem_id', 'mem_name', 'mem_phone', 'mem_points')
            ->first();
        $goods_data = DB::table('point_gift_goods')
            ->where('pogg_id', $request['pogg_id'])
            ->first();
        $goods_data = json_decode(json_encode($goods_data,true),true);
        if ($goods_data['pogg_goo_point'] > $mem_data->mem_points) {
            return ['code'=>500, 'msg'=>'积分不足！', 'data'=>''];
        }
        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->ussh_user_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $ord_unique_string)
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>ErrorInc::DATA_EXIST, 'msg'=>'当前订单已提交，请勿重复操作！', 'data'=>''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);
        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        // $data['ord_create_id'] = $user_info->adm_id;
        $request['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_client_id'] = $user_info->ussh_user_id;
        $data['ord_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : '';
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1;//买家类型：1门店零售2企业客户
        $data['ord_source'] = 2;//下单来源：1 pc  2 车主小程序  3 技师
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = 3; //结算方式1现金、2支付宝、3微信、4银行卡、5会员卡
        $data['ord_wor_state'] = 7;
        $data['ord_add_type'] = 3;//1正常2签到礼品3积分商品
        $data['ord_state'] = 1;//1未结算
        $data['ord_pay_state'] = 2;//1未支付
        $find_shop = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first();
        $data['ord_address'] = $find_shop->shop_store_name.'(本店)';//1未支付
        $data['ord_address_id'] = $user_info->adm_shop_id;//1未支付
        $data['ord_address_type'] = 1;//1本店2其他门店

        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_unique_string'] = $ord_unique_string;
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $ord_id = NewOrderService::newOrder($data);


        // 查询手机号是否存在
        $find_weixin_data = DB::table('weixin_user')
            ->where('weus_id', $request['weus_id'])
            ->select('weus_id', 'weus_phone', 'weus_nickmame', 'weus_headimgurl')
            ->first();
        // 选择的客户id，对应的订单数量增加
        if ($user_info->ussh_user_id) {
            // 零售，会员表
            $client_res = DB::table('member')
                ->where('mem_id', $user_info->ussh_user_id)
                ->increment('mem_order_all');
            
            if ($mem_data) {
                $request['orcl_name'] = $mem_data->mem_name;
                $request['orcl_phone'] = $mem_data->mem_phone;
            }
            $weus_id = $find_weixin_data->weus_id;
        }
        $request['orcl_carowner_name'] = $request['orcl_name'];
        $request['orcl_carowner_phone'] = $request['orcl_phone'];

        if (!empty($request['orcl_car_num'])) {
            $isCarLicense = isCarLicense($request['orcl_car_num']);// 正则判断车牌号格式
            if (!$isCarLicense) {
                return ['code'=>1000, 'msg'=>'车牌照格式不正确', 'data'=>''];
            }
        }
        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => $user_info->ussh_user_id, //选择客户id
            'orcl_name' => $request['orcl_name'] ? $request['orcl_name'] : '散户',
            'orcl_phone' => $request['orcl_phone'] ? $request['orcl_phone'] : '',
            'orcl_carowner_name' => $request['orcl_carowner_name'] ? $request['orcl_carowner_name'] : '散户',
            'orcl_carowner_phone' => $request['orcl_carowner_phone'] ? $request['orcl_carowner_phone'] : '',
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类2其他车系
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];

        if (!empty($request['orcl_car_num'])&& !empty($request['ord_client_id'])) {
            $request['shop_id'] = $user_info->adm_shop_id;
            $request['weus_id'] = DB::table('user_shop')
                ->where('ussh_user_id', $user_info->ussh_user_id)
                ->where('ussh_shop_id', $user_info->adm_shop_id)
                ->value('ussh_weus_id');
            $request['meca_car_num'] = $request['orcl_car_num'];
            $request['meca_car_brand_series'] = isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : ''; //品牌车系
            $exist = MemberCarService::nameExists($request['meca_car_num'], $request['shop_id'], $request['weus_id']);
            if (!$exist) {
                $return_car_data = MemberCarService::add($request);
            } else {
                $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
            }
        } else {
            $return_car_data = ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        }
        // 预约时间
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        
        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_ware_id'] = isset($request['ware_id']) ? $request['ware_id'] : 0;
        $orgo_data['orgo_wago_id'] = 0;
        $orgo_data['orgo_goo_id'] = $goods_data['pogg_goo_id'];
        $orgo_data['orgo_pogg_id'] = $goods_data['pogg_id'];
        $orgo_data['orgo_goo_inventory'] = 1;
        $orgo_data['orgo_state'] = 1;
        $orgo_data['orgo_goo_price'] = $goods_data['pogg_goo_money'];
        $orgo_data['orgo_goo_amount'] = $goods_data['pogg_goo_money'];
        $orgo_data['orgo_goo_quantity'] = 1;
        $orgo_data['orgo_can_assign_quantity'] = 1;

        if ($goods_data['pogg_goo_type'] == 2) {//商品
            $orgo_data['orgo_goo_type'] = 1;//商品
            if ($goods_data['pogg_goo_id']) {
                $find_goods = DB::table('goods')
                    ->where('goo_id', $goods_data['pogg_goo_id'])
                    ->first();
                $orgo_data['orgo_goo_name'] = $find_goods->goo_name;
                $orgo_data['orgo_goo_goods_encode'] = $find_goods->goo_goods_encode;
                $orgo_data['orgo_goo_unit'] = $find_goods->goo_unit;
                $orgo_data['orgo_goo_unta_id'] = $find_goods->goo_unta_id;
            } else {
                $orgo_data['orgo_goo_name'] = $goods_data['pogg_goo_name'];
                $orgo_data['orgo_goo_unit'] = '个';
                $orgo_data['orgo_goo_unta_id'] = 3;
            }
            $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
            $ord_edit_data['ord_service_type'] = 2;//不生成工单
        }
        if ($goods_data['pogg_goo_type'] == 1) {//服务
            $image_id = [];//根据服务项目确定需要上传的图片
            $sepr_image = DB::table('sepr_img')
                ->where('seim_sepr_id', $goods_data['pogg_goo_id'])
                ->select('seim_imco_id')
                ->get()->toArray();
            if (!empty($sepr_image)) {
                foreach ($sepr_image as $ks => $vs) {
                    if (!in_array($vs->seim_imco_id, $image_id)) {
                        $image_id[] = $vs->seim_imco_id;
                    }
                }
            }
            $orgo_data['orgo_goo_type'] = 2;
            $find_goods = DB::table('service_project')
                ->where('sepr_id', $goods_data['pogg_goo_id'])
                ->first();
            $orgo_data['orgo_goo_name'] = $find_goods->sepr_name;
            $orgo_data['orgo_goo_unit'] = '次';
            $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
            if ($find_goods->sepr_work_type == 1) {
                $ord_edit_data['ord_service_type'] = 1;
                $ord_edit_data['ord_add_work_state'] = 1;
            } else {
                $ord_edit_data['ord_service_type'] = 2;
            }
            if ($find_goods->sepr_work_type == 1) {
                $find_imco = DB::table('image_config')
                    ->where('imco_type', 1)
                    ->get()->toArray();
                foreach ($find_imco as $kf => $vf) {
                    $add_imdata['vaca_shop_id'] = $user_info->adm_shop_id;
                    $add_imdata['vaca_ord_id'] = $ord_id;
                    $add_imdata['vaca_type'] = 1;
                    $add_imdata['vaca_name'] = $vf->imco_name;
                    $add_imdata['vaca_data_id'] = $vf->imco_id;
                    if (in_array($vf->imco_id, $image_id)) {
                        $add_imdata['vaca_must'] = 1;
                    } else {
                        $add_imdata['vaca_must'] = 2;
                    }
                    $add_imdata['vaca_create_time'] = date('Y-m-d H:i:s');
                    $add_imdata['vaca_create_id'] = 0;
                    $im_res = DB::table('wash_validate_car')->insert($add_imdata);
                }

                $find_com_img = DB::table('image_config')
                    ->where('imco_type', 2)
                    ->get()->toArray();
                foreach ($find_com_img as $kf => $vf) {
                    $add_comdata['coin_shop_id'] = $user_info->adm_shop_id;
                    $add_comdata['coin_ord_id'] = $ord_id;
                    $add_comdata['coin_type'] = 3;
                    $add_comdata['coin_name'] = $vf->imco_name;
                    $add_comdata['coin_data_id'] = $vf->imco_id;
                    $add_comdata['coin_create_time'] = date('Y-m-d H:i:s');
                    $add_comdata['coin_create_id'] = 0;
                    if (in_array($vf->imco_id, $image_id)) {
                        $add_comdata['coin_must'] = 1;
                        $co_res = DB::table('completion_info')->insert($add_comdata);
                    }
                }
            }
        }
        if ($goods_data['pogg_goo_type'] == 3) {//会员卡
            $orgo_data['orgo_goo_type'] = 4;
            $find_goods = DB::table('vip_card')
                ->where('vica_id', $goods_data['pogg_goo_id'])
                ->first();
            $orgo_data['orgo_goo_name'] = $find_goods->vica_name;
            $orgo_data['orgo_goo_unit'] = '张';
            $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
            $ord_edit_data['ord_service_type'] = 4;//订单类型：1服务单 2洗车单3商品单4会员卡5充值6提现
        }
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);
        $ord_edit_data['ord_points'] = $goods_data['pogg_goo_point'];
        if (empty($goods_data['pogg_goo_money'])) {//纯积分支付
            $ord_edit_data['ord_state'] = 2;//已结算
            $ord_edit_data['ord_payment_way'] = 11;//11积分兑换
            $ord_edit_data['ord_pay_state'] = 1;//1支付2否
            $ord_edit_data['ord_order_price'] = 0;
            $ord_edit_data['ord_actual_price'] = 0;
            $ord_edit_data['ord_settlement_time'] = date('Y-m-d H:i:s');
            if ($goods_data['pogg_goo_type'] == 3) {//会员卡
                $data_vip['myvi_create_adm_id'] = 0;
                $myvi_num = 'HYK'.time().rand(10000,99999);
                $data_vip['myvi_num'] = $myvi_num;//会员卡编号
                $data_vip['myvi_shop_id'] = $user_info->adm_shop_id;
                $data_vip['myvi_adm_id'] = $user_info->ussh_user_id; //选择客户id
                $data_vip['myvi_surplus_times'] = $find_goods->vica_num; //剩余次数
                $data_vip['myvi_all_times'] = $find_goods->vica_num; //总次数
                $data_vip['myvi_long_term'] = $find_goods->vica_long_term; //是否长期1是2否
                $data_vip['myvi_carnum'] = !empty($request['myvi_carnum']) ? $request['myvi_carnum']:''; //绑定车_vip牌
                $data_vip['myvi_sepr_id'] = $find_goods->vica_sepr_id; //服务项目id
                $data_vip['myvi_sepr_name'] = $find_goods->vica_sepr_name; //服务项目名称
                $data_vip['myvi_name'] = $find_goods->vica_name; //会员卡名称
                $data_vip['myvi_explain'] = $find_goods->vica_instructions; //会员卡使用说明
                $data_vip['myvi_vica_id'] = $goods_data['pogg_goo_id']; //会员卡id
                $data_vip['myvi_create_time'] = date('Y-m-d H:i:s');
                if ($find_goods->vica_long_term == 2) {//是否长期1是2否
                    $data_vip['myvi_effective_date'] = $find_goods->vica_effective_date; //有效天数
                    $data_vip['myvi_end_time'] = date('Y-m-d', strtotime(date('Y-m-d').'23:59:59') + ($find_goods->vica_effective_date)*60*60*24).' 23:59:59';
                } else {
                    $data_vip['myvi_end_time'] = date('Y-m-d', time() + 99999*60*60*24);
                }
                $myvi_id = DB::table('myvip')->insertGetId($data_vip);
                $find_detail = DB::table('vip_card_detail')
                    ->where('vicad_vcid', $find_goods->vica_id)
                    ->get()->toArray();
                foreach ($find_detail as $key => $value) {
                    $add_detail['myvid_mvid'] = $myvi_id;
                    $add_detail['myvid_surplus_times'] = $value->vicad_num;
                    $add_detail['myvid_all_times'] = $value->vicad_num;
                    $add_detail['myvid_data_id'] = $value->vicad_data_id;
                    $add_detail['myvid_data_name'] = $value->vicad_data_name;
                    $add_detail['myvid_type'] = $value->vicad_type;
                    $add_detail['myvid_goo_price'] = $value->vicad_goo_price;
                    $add_detail_res = DB::table('myvip_detail')->insert($add_detail);
                    if (!$add_detail_res) {
                        return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
                    }
                }
                $ord_edit_data['ord_wor_state'] = 20;
                $ord_edit_data['ord_customer_state'] = 1;//1已领取
            }
            if ($goods_data['pogg_goo_limitation'] == 1) {
                if ($goods_data['pogg_goo_num'] - 1 == 0) {
                    $update_pogg['pogg_state'] = 2;//1上架2下架
                }
                $update_pogg['pogg_goo_num'] = $goods_data['pogg_goo_num'] - 1;
                $update_pait = DB::table('point_gift_goods')
                    ->where('pogg_id', $request['pogg_id'])
                    ->update($update_pogg);
            } else {
                $update_pait = true;
            }
            // 扣除积分+扣除积分记录+兑换记录
            $add_point['pode_shop_id'] = $user_info->adm_shop_id;
            $add_point['pode_mem_id'] = $user_info->ussh_user_id;
            $add_point['pode_type'] = 3;
            $add_point['pode_name'] = '兑换'.$orgo_data['orgo_goo_name'].'('.$orgo_data['orgo_goo_unit'].')';
            $add_point['pode_points'] = -$goods_data['pogg_goo_point'];
            $add_point['pode_year_month'] = date('Y-m');
            $add_point['pode_create_time'] = date('Y-m-d H:i:s');
            $add_point['pode_create_id'] = 0;
            $add_point['pode_soure'] = 2;
            $add_point['pode_add_type'] = 15;//兑换商品
            $add_point['pode_ord_id'] = $ord_id;
            $add_point['pode_state'] = 1;
            $add_shord_point_res = PointService::addPointDetail($add_point);
            $add_goo_log['pglo_shop_id'] = $user_info->adm_shop_id;
            $add_goo_log['pglo_mem_id'] = $user_info->ussh_user_id;
            $add_goo_log['pglo_ord_id'] = $ord_id;
            $add_goo_log['pglo_pogg_id'] = $request['pogg_id'];
            $add_goo_log['pglo_time'] = date('Y-m-d');
            $add_goo_log['pglo_create_time'] = date('Y-m-d H:i:s');
            $add_goo_log_res = DB::table('point_goods_log')->insertGetId($add_goo_log);
        }
        $ord_edit_data['ord_order_price'] = $orgo_data['orgo_goo_price'];
        $ord_edit_data['ord_zero_price'] = 0;
        $ord_edit_data['ord_goods_quantity'] = 1;
       
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = WashOrder::where('ord_id', $ord_id)->update($ord_edit_data);
        if ($ord_id && $orcl_id && $ord_edit_res && $return_car_data['code'] == 200) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_price'] = $orgo_data['orgo_goo_price']; //订单金额
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['ord_type'] = 1; //买家类型1.会员零售2.合作商
            $return_data['ord_client_id'] = $user_info->ussh_user_id; //选择的客户id,会员id
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>'新增失败'];
        }
    }

    /**
     * 换货获取退款方式
     *
     * @return string[]
     *
     * @author huangyongqi
     *
     * @since 2023-10-25
     */
    public static function getRefundWay() {
        return [
            [
                'type' => 3,
                'name' => '现金',
            ],
//            [
//                'type' => 4,
//                'name' => '财务',
//            ],
            [
                'type' => 5,
                'name' => '余额',
            ],
//            [
//                'type' => 6,
//                'name' => '代付余额',
//            ]
        ];
    }

    /**
     * 换货获取付款方式
     *
     * @return string[]
     *
     * @author huangyongqi
     *
     * @since 2023-10-25
     */
    public static function getPayWay() {
        return [
            ['type'=>0,'name'=>'暂不结算'],
            ['type'=>1,'name'=>'现金'],
            ['type'=>2,'name'=>'支付宝'],
            ['type'=>3,'name'=>'微信'],
            ['type'=>4,'name'=>'银行卡'],
            ['type'=>6,'name'=>'余额'],
            ['type'=>7,'name'=>'他人代付'],
            ['type'=>9,'name'=>'部分结款'],
        ];
    }

    /**
     * 根据商品查询仓库
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function searchWarehouse($user_info, $request) {
        $list_data = DB::table('warehouse_goods')
            ->leftJoin('warehouse', 'ware_id', '=', 'wago_ware_id')
            ->where('wago_goo_id', $request['goo_id'])
            ->where('wago_stock_number', '>', 0)
            ->select('wago_id', 'wago_stock_number', 'ware_name', 'ware_id', 'wago_goo_id')
            ->get();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * 修改客户领取状态
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-23
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function recOrder($user_info, $request) {
        $find_order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->first();
        if ($find_order_data->ord_add_type == 3) {//积分兑换的商品
            if ($find_order_data->ord_state == 2 && ($find_order_data->ord_wor_state == 4 || $find_order_data->ord_wor_state == 20) && $find_order_data->ord_type == 1 && $find_order_data->ord_actual_price && empty($find_order_data->ord_ware_id)) {//已结算 待评价或已完成 个人会员 添加积分
                $add_point = WashOrderBasicService::addPoint($user_info,$find_order_data->ord_client_id,$find_order_data->ord_id);
            }
        }
        $list_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update(['ord_customer_state'=>1]);
        return ['code'=>200, 'msg'=>'领取成功', 'data'=>$list_data];
    }

    /**
     * @name 退货退款，全部退完需要取消订单
     * @param string $user_info  用户信息
     * * @param array 订单id
     * @retrun array
     * @author Ma 2023/10/11 11:03
     *
    */
    public static function cancelOrder($user_info,$request){
        $cancel = true;
        if (substr($request['ord_order_number'],0,1) == 'D') {

        } elseif (substr($request['ord_order_number'],0,1) == 'G') {
            $request['ord_order_number'] = DB::table('work_order')
                ->where('wor_number', $request['ord_order_number'])
                ->value('wor_order_number');
        } else {
            return ['code'=>500, 'msg'=>'参数错误', 'data'=>''];
        }
        //查询订单所有产品
        $order_data = DB::table('order_goods')->where('orgo_order_number',$request['ord_order_number'])
            ->get()->toArray();
        if($order_data){
           foreach ($order_data as $key => $value){
               if($value->orgo_goo_quantity > $value->orgo_goo_return_quantity){
                   $cancel = false;//还有商品，不能取消订单
                   break;
               }
           }
        }
        
        if($cancel){
            $order = DB::table('order')->where('ord_order_number',$request['ord_order_number'])
                ->first();
            if($order->ord_actual_price > 0){
                $cancel = false;//还有金额，不能取消订单
            }
            if($cancel){
                // 取消订单
                $return_data = WashOrderService::cancel($user_info, $request);
                if ($return_data['code'] != 200) {
                    return ['code'=>500, 'msg'=>'取消失败', 'data'=>''];
                }
                //取消应收应付
                $find_rece = DB::table('receivable_pay')
                    ->where('recpay_original_id', $request['ord_id'])
                    ->first();
                if($find_rece){
                    $update_qrres = DB::table('receivable_pay')
                        ->where('recpay_original_id', $request['ord_id'])
                        ->update(['recpay_order_state'=>3]);
                }
                return ['code'=>200, 'msg'=>'取消成功', 'data'=>''];
            }
        }
        return ['code'=>200, 'msg'=>'不取消', 'data'=>''];
    }

    /**
     * 企业会员充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-07-20
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function busRecharge($user_info, $request) {
        $request['ord_unique_string'] = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        if (empty($request['ord_unique_string'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data' => ''];
        }

        $request['ord_address_type'] = 1;
        $request['ord_address_id'] = $user_info->adm_shop_id;
        if (empty($request['mem_id'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请选择会员', 'data' => ''];
        }
        if (empty($request['mem_rec_banlance'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请输入充值金额', 'data' => ''];
        }
        if (empty($request['ord_payment_way'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请选择支付方式', 'data' => ''];
        }
        $request['bucl_id'] = $request['mem_id'];
        $request['buac_id'] = $request['bcac_id'];
        $request['bucl_rec_banlance'] = $request['mem_rec_banlance'];
        $request['bucl_gift_banlance'] = $request['mem_gift_banlance'];
        $business_client = DB::table('business_client')
            ->where('bucl_id', $request['bucl_id'])
            ->first();
        if (empty($business_client)) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '企业会员不存在', 'data' => ''];
        }
        if (empty($request['buac_id'])) {
            $business_account = DB::table('business_account')
                ->where('buac_bucl_id', $business_client->bucl_id)
                ->where('buac_phone', $business_client->bucl_user_phone)
                ->first();
        } else {
            $business_account = DB::table('business_account')
                ->where('buac_id', $request['buac_id'])
                ->first();
        }
        if (empty($business_account)) {
            $password = md5('123456' . 'faster123456');
            $new_data['buac_cid'] = $user_info->adm_cid;
            $new_data['buac_shop_id'] = $user_info->adm_shop_id;
            $new_data['buac_create_adm_id'] = $user_info->adm_id;
            $new_data['buac_bucl_id'] = $business_client->bucl_id; //企业客户id
            $new_data['buac_name'] = $business_client->bucl_user_name; //企业客户名称
            $new_data['buac_phone'] = $business_client->bucl_user_phone; //联系人电话
            $new_data['buac_password'] = $password; //密码
            $new_data['buac_create_time'] = date('Y-m-d H:i:s');
            $buac_id = DB::table('business_account')->insertGetId($new_data);
            $business_account = DB::table('business_account')
                ->where('buac_id', $buac_id)
                ->first();
        }
        $request['buac_id'] = $business_account->buac_id;
        $request['orcl_name'] = $business_account->buac_name;
        $request['orcl_phone'] = $business_account->buac_phone;
        $request['orcl_carowner_name'] = $business_account->buac_name;
        $request['orcl_carowner_phone'] = $business_account->buac_phone;
        $request['orcl_mem_source'] = 0;
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code' => ErrorInc::DATA_EXIST, 'msg' => '当前订单已提交，请勿重复操作！', 'data' => ''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);

        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = isset($request['buac_id']) ? $request['buac_id'] : 0;
        $data['ord_ware_id'] = 0;
        // $data['ord_address'] = $request['ord_address'];
        // $data['ord_address_id'] = $request['ord_address_id'];
        // $data['ord_address_type'] = $request['ord_address_type'];
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 2; //买家类型：0散户1门店零售2企业客户
        $data['ord_service_type'] = 5; //订单类型：1服务单 2洗车单3商品单4会员卡5充值
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式结算方式1现金、2支付宝、3微信、4银行卡5会员卡
        $data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : ''; //服务技师
        if ($request['ord_payment_way']) {
            $data['ord_state'] = 2; //结算状态1未结算2已结算
            $data['ord_pay_state'] = 1; //是否支付1是2否
            $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
            $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        }
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_order_price'] = $request['bucl_rec_banlance']*100;
        $data['ord_actual_price'] = $request['bucl_rec_banlance']*100;
        $data['ord_unique_string'] = $request['ord_unique_string'];
        $data['ord_explain'] = '';
        $data['ord_wor_state'] = 20;
        $ord_id = WashOrder::insertGetId($data);
        
        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 1;
                $add_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => $business_account->buac_id, //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '', // 销售人员id
            'orcl_business_name' => $business_client->bucl_name, //企业名称
            'orcl_business_id' => $business_client->bucl_id, //企业id
            'orcl_name' => $business_account->buac_name,
            'orcl_phone' => $business_account->buac_phone,
            'orcl_carowner_name' => $business_account->buac_name,
            'orcl_carowner_phone' => $business_account->buac_phone,
            'orcl_car_num' => '',
            'orcl_pick_up_car_adm_id' => 0, //接车人id
            'orcl_car_vin' => '', //车架号 车辆识别码
            'orcl_car_brand_series' => '', //品牌车系
            'orcl_carbrse_type' => 1, //品牌车系分类
            'orcl_mem_source' => '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $ord_edit_data['ord_goods_quantity'] = 1;
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = DB::table('order')->where('ord_id', $ord_id)->update($ord_edit_data);

        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_goo_id'] = 0;
        if (!empty($request['bucl_gift_banlance'])) {
            $orgo_data['orgo_goo_name'] = '充值'.$request['bucl_rec_banlance'].'元 赠送'.$request['bucl_gift_banlance'].'元';
        } else {
            $orgo_data['orgo_goo_name'] = '充值'.$request['bucl_rec_banlance'].'元';
        }
        $orgo_data['orgo_goo_type'] = 5;
        $orgo_data['orgo_goo_price'] = $request['bucl_rec_banlance']*100;
        $orgo_data['orgo_goo_amount'] = $request['bucl_rec_banlance']*100;
        $orgo_data['orgo_state'] = 1;
        $orgo_data['orgo_goo_quantity'] = 1;
        $orgo_data['orgo_goo_inventory'] = 1;
        $orgo_data['orgo_goo_unit'] = '次';
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);

        $receivable_pay['recpay_cid'] = $user_info->adm_cid;
        $receivable_pay['recpay_shop_id'] = $user_info->adm_shop_id;
        $receivable_pay['recpay_shop_superior_id'] = $user_info->adm_shop_id;
        $receivable_pay['recpay_type'] = 2;
        $receivable_pay['recpay_original_id'] = $ord_id;
        $receivable_pay['recpay_original_number'] = $ord_order_number;
        $receivable_pay['recpay_client_type'] = 1;
        $receivable_pay['recpay_client_id'] = $business_client->bucl_id;
        $receivable_pay['recpay_client_name'] = $business_client->bucl_name;
        $receivable_pay['recpay_receivable_price'] = $request['bucl_rec_banlance'] * 100;//应收金额
        $receivable_pay['recpay_arrears_price'] = 0;//欠收金额
        $receivable_pay['recpay_actual_price'] = $request['bucl_rec_banlance'] * 100;//实收金额
        $receivable_pay['recpay_cost_price'] = 0;//成本价
        $receivable_pay['recpay_receivable_pay'] = 0;//应付金额
        $receivable_pay['recpay_actual_pay'] = 0;
        $receivable_pay['recpay_plus_minus'] = 1;
        $receivable_pay['recpay_profit'] = $request['bucl_rec_banlance'] * 100;//盈利金额
        $receivable_pay['recpay_state'] = 1;//状态：1未确认2已确认
        $receivable_pay['recpay_order_state'] = 1;//订单状态：1正常2退款3取消
        $receivable_pay['recpay_remark'] = !empty($request['remark']) ? $request['remark'] : '';
        $receivable_pay['recpay_create_time'] = date('Y-m-d H:i:s');
        $receivable_pay['recpay_update_time'] = date('Y-m-d H:i:s');
        $receivable_pay_res = DB::table('receivable_pay')->insert($receivable_pay);
        $update_data['bucl_rec_banlance'] = $business_client->bucl_rec_banlance + $request['bucl_rec_banlance'] * 100;
        $update_data['bucl_gift_banlance'] = $business_client->bucl_gift_banlance + $request['bucl_gift_banlance'] * 100;
        $update_data['bucl_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('business_client')
            ->where('bucl_id', $request['bucl_id'])
            ->update($update_data);
        $add_rec_log['relo_type'] = 1;
        $add_rec_log['relo_rec_num'] = $request['bucl_rec_banlance'] * 100;
        $add_rec_log['relo_gift_num'] = $request['bucl_gift_banlance'] * 100;
        $add_rec_log['relo_ord_id'] = $ord_id;
        $add_rec_log['relo_mem_id'] = $request['bucl_id'];
        $add_rec_log['relo_mem_type'] = 2;
        $add_rec_log['relo_remark'] = $request['remark'];
        $add_rec_log['relo_create_id'] = $user_info->adm_id;
        $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
        $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
        if ($request['remark']) {
            $orre_res = orderRemark($user_info, $ord_id, 0, $request['remark'], '充值');
        }
        $banlance = $update_data['bucl_rec_banlance'] + $update_data['bucl_gift_banlance'];
        if ($ord_id && $orcl_id && $orgo_id && $update_data_res && $relo_id) {
            $log_data['order_number'] = $ord_order_number;
            return ['code'=>200, 'msg'=>'充值成功', 'data'=>$banlance ,'log_data'=>$log_data];
        } else {
            return ['code'=>500, 'msg'=>'充值失败', 'data'=>''];
        }
    }

    /**
     * 企业客户退款提现
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-05
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function busRefund($user_info, $request) {
        $request['ord_unique_string'] = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
        if (empty($request['ord_unique_string'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '生成订单验证密钥未提交，请刷新页面或重新登录系统！', 'data' => ''];
        }

        $request['ord_address_type'] = 1;
        $request['ord_address_id'] = $user_info->adm_shop_id;
        if (empty($request['mem_id'])) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '请选择会员', 'data' => ''];
        }
        $request['bucl_id'] = $request['mem_id'];
        $business_client = DB::table('business_client')
            ->where('bucl_id', $request['mem_id'])
            ->first();
        if (empty($business_client)) {
            return ['code' => ErrorInc::FAILED_PARAM, 'msg' => '企业会员不存在', 'data' => ''];
        }
        if (empty($request['buac_id'])) {
            $business_account = DB::table('business_account')
                ->where('buac_bucl_id', $business_client->bucl_id)
                ->where('buac_phone', $business_client->bucl_user_phone)
                ->first();
        } else {
            $business_account = DB::table('business_account')
                ->where('buac_id', $request['buac_id'])
                ->first();
        }
        $request['mem_id'] = $business_account->buac_id;
        $request['orcl_name'] = $business_account->buac_name;
        $request['orcl_phone'] = $business_account->buac_phone;
        $request['orcl_carowner_name'] = $business_account->buac_name;
        $request['orcl_carowner_phone'] = $business_account->buac_phone;
        $request['orcl_mem_source'] = 0;
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code' => ErrorInc::DATA_EXIST, 'msg' => '当前订单已提交，请勿重复操作！', 'data' => ''];
        }
        // 订单单号
        $ord_order_number = Common::numberRule($user_info, 1);

        $data['ord_cid'] = $user_info->adm_cid;
        $data['ord_superior_shop_id'] = $user_info->adm_shop_id;
        $data['ord_shop_id'] = $user_info->adm_shop_id;
        $data['ord_create_id'] = $user_info->adm_id;
        $data['ord_client_id'] = isset($request['mem_id']) ? $request['mem_id'] : 0;
        $data['ord_ware_id'] = '';
        $data['ord_order_number'] = $ord_order_number;
        $data['ord_type'] = 1; //买家类型：0散户1门店零售2企业客户
        $data['ord_service_type'] = 6; //订单类型：1服务单 2洗车单3商品单4会员卡5充值6提现
        $data['ord_classify'] = 2; //订单分类：1蓄电池2洗美店3易损件
        $data['ord_is_split'] = 1; //订单拆分1正常单服务订单2多服务分订单3多服务总订单
        $data['ord_payment_way'] = $request['ord_payment_way']; //结算方式结算方式1现金、2支付宝、3微信、4银行卡5会员卡
        $data['ord_service_adm_id'] = isset($request['ord_service_adm_id']) ? $request['ord_service_adm_id'] : ''; //服务技师
        $data['ord_state'] = 2; //结算状态1未结算2已结算
        $data['ord_pay_state'] = 1; //是否支付1是2否
        $data['ord_settlement_time'] = date('Y-m-d H:i:s'); //结算状态1未结算2已结算
        $data['ord_settlement_adm_id'] = $user_info->adm_id; //结算人
        $data['ord_source'] = static::getOrdsource($request);  // 来源  1 pc  2 车主小程序   3 技师
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_order_price'] = -$business_client->bucl_rec_banlance;
        $data['ord_actual_price'] = -$business_client->bucl_rec_banlance;
        $data['ord_unique_string'] = $request['ord_unique_string'];
        $data['ord_explain'] = '';
        $data['ord_wor_state'] = 20;
        $ord_id = WashOrder::insertGetId($data);

        if (isset($request['ord_pic']) && !empty($request['ord_pic'])) {
            foreach ($request['ord_pic'] as $key => $value) {
                $add_pic[$key]['orvp_image'] = $value;
                $add_pic[$key]['orvp_type'] = 1;
                $add_pic[$key]['orvp_ord_id'] = $ord_id;
                $add_pic[$key]['orvp_create_time'] = date('Y-m-d H:i:s');
                $add_pic[$key]['orvp_create_id'] = $user_info->adm_id;
                $add_pic[$key]['orvp_create_name'] = $user_info->adm_name;
            }
            $add_pic_res = DB::table('order_voucher_pic')->insert($add_pic);
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['mem_id']) ? $request['mem_id'] : 0, //选择客户id
            'orcl_sales_adm_id' => isset($request['orcl_sales_adm_id']) ? $request['orcl_sales_adm_id'] : '', // 销售人员id
            'orcl_business_name' => $business_client->bucl_name, //企业名称
            'orcl_business_id' => $business_client->bucl_id, //企业id
            'orcl_name' => $business_account->buac_name,
            'orcl_phone' => $business_account->buac_phone,
            'orcl_carowner_name' => $business_account->buac_name,
            'orcl_carowner_phone' => $business_account->buac_phone,
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_pick_up_car_adm_id' => isset($request['orcl_pick_up_car_adm_id']) ? $request['orcl_pick_up_car_adm_id'] : 0, //接车人id
            'orcl_car_vin' => isset($request['orcl_car_vin']) ? $request['orcl_car_vin'] : '', //车架号 车辆识别码
            'orcl_car_brand_series' => isset($request['orcl_car_brand_series']) ? $request['orcl_car_brand_series'] : '', //品牌车系
            'orcl_carbrse_type' => isset($request['orcl_carbrse_type']) ? $request['orcl_carbrse_type'] : 1, //品牌车系分类
            'orcl_mem_source' => isset($request['orcl_mem_source']) ? $request['orcl_mem_source'] : '', //客户来源
            'orcl_update_time' => date('Y-m-d H:i:s'),
        ];
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);
        $ord_edit_data['ord_goods_quantity'] = 1;
        $ord_edit_data['ord_orcl_id'] = $orcl_id;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_edit_res = DB::table('order')->where('ord_id', $ord_id)->update($ord_edit_data);

        $orgo_data['orgo_ord_id'] = $ord_id;
        $orgo_data['orgo_order_number'] = $ord_order_number;
        $orgo_data['orgo_goo_id'] = 0;
        $orgo_data['orgo_goo_name'] = '提现'.($business_client->bucl_rec_banlance/100).'元';
        $orgo_data['orgo_goo_type'] = 6;
        $orgo_data['orgo_goo_price'] = -$business_client->bucl_rec_banlance;
        $orgo_data['orgo_goo_amount'] = -$business_client->bucl_rec_banlance;
        $orgo_data['orgo_state'] = 1;
        $orgo_data['orgo_goo_quantity'] = 1;
        $orgo_data['orgo_goo_inventory'] = 1;
        $orgo_data['orgo_goo_unit'] = '次';
        $orgo_id = DB::table('order_goods')->insertGetId($orgo_data);

        $update_data['bucl_rec_banlance'] = 0;
        $update_data['bucl_gift_banlance'] = 0;
        $update_data['bucl_update_time'] = date('Y-m-d H:i:s');
        $update_data_res = DB::table('business_client')
            ->where('bucl_id', $request['bucl_id'])
            ->update($update_data);
        $add_rec_log['relo_type'] = 3;
        $add_rec_log['relo_mem_type'] = 2;
        $add_rec_log['relo_rec_num'] = $business_client->bucl_rec_banlance;
        $add_rec_log['relo_gift_num'] = $business_client->bucl_gift_banlance;
        $add_rec_log['relo_mem_id'] = $request['bucl_id'];
        $add_rec_log['relo_ord_id'] = $ord_id;
        $add_rec_log['relo_remark'] = $request['remark'];
        $add_rec_log['relo_create_id'] = $user_info->adm_id;
        $add_rec_log['relo_create_time'] = date('Y-m-d H:i:s');
        $relo_id = DB::table('rec_log')->insertGetId($add_rec_log);
        if ($update_data_res && $relo_id) {
            $data['recpay_original_id'] = $ord_id;
            $data['recpay_original_number'] = $ord_order_number;
            $data['bucl_name'] = $business_client->bucl_name;
            return ['code'=>200, 'msg'=>'提现成功', 'data'=>$data];
        } else {
            return ['code'=>500, 'msg'=>'提现失败', 'data'=>''];
        }
    }

    /**
     * 获取企业会员余额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-01-05
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function busBanlance($user_info, $request) {
        $business_client = DB::table('business_client')
            ->where('bucl_shop_id', $user_info->adm_shop_id)
            ->where(function ($query) use ($request) {
                if (!empty($request['keywords'])) {
                    $query->where('bucl_user_phone', $request['keywords']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['mem_id'])) {
                    $query->where('bucl_id', $request['mem_id']);
                }
            })
            ->select('bucl_rec_banlance as mem_rec_banlance', 'bucl_gift_banlance as mem_gift_banlance', 'bucl_user_phone', 'bucl_name', 'bucl_id')
            ->first();
        if ($business_client) {
            $business_client->mem_banlance = $business_client->mem_rec_banlance + $business_client->mem_gift_banlance;
        }
        return $business_client;
    }

    /**
     * 订单类型列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-29
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function orderType($user_info,$request) {
        $list_datas = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
//            ->where(function ($query) use ($request) {
//                if (!empty($request['orty_state'])) {
//                    $query->where('orty_state', $request['orty_state']);
//                }
//            })
            ->get()->toArray();
        $list_datas = CommonService::dataToArray($list_datas);
        if (!empty($request['orty_state'])) {
            $where[] = array('orty_state'=>$request['orty_state']);
            $list_data = CommonService::arrayFilterFieldValue($list_datas, $where);
            foreach ($list_data as $key => $value) {
                $new_data[] = $value;
            }
            $list_data = $new_data;
        }else{
            $list_data = $list_datas;
        }
        if (empty($list_datas)) {
            $add_data['orty_shop_id'] = $user_info->adm_shop_id;
            $add_data['orty_name'] = '服务单';
            $add_data['orty_default'] = 1;
            $add_data['orty_create_id'] = $user_info->adm_id;
            $add_data['orty_create_name'] = $user_info->adm_name;
            $add_data['orty_create_time'] = date('Y-m-d H:i:s');
            $res = DB::table('order_type')->insert($add_data);
            $list_data = DB::table('order_type')
                ->where('orty_shop_id', $user_info->adm_shop_id)
                ->get()->toArray();
            $list_data = CommonService::dataToArray($list_data);
        }
//        else{
//            if (empty($list_data)) {
//                if (!isset($request['orty_state']) && !empty($request['orty_state'])) {
//                    $add_data['orty_shop_id'] = $user_info->adm_shop_id;
//                    $add_data['orty_name'] = '服务单';
//                    $add_data['orty_create_id'] = $user_info->adm_id;
//                    $add_data['orty_create_name'] = $user_info->adm_name;
//                    $add_data['orty_create_time'] = date('Y-m-d H:i:s');
//                    $res = DB::table('order_type')->insert($add_data);
//                }
//                $list_data = DB::table('order_type')
//                    ->where('orty_shop_id', $user_info->adm_shop_id)
//                    ->get()->toArray();
//            }
//
//        }
        foreach ($list_data as $key => $value) {
            $new_data = DB::table('shop_reservenum')
                ->where('resenum_shop_id', $user_info->adm_shop_id)
                ->where('resenum_date', $request['wopl_date'])
                ->where('resenum_new_type', $value['orty_id'])
                ->value('resenum_num');
            $list_data[$key]['resenum_num'] = $new_data ? $new_data : 0;
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * 订单类型-新增
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-29
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function addOrderType($user_info,$request) {
        $list_data = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
            ->where('orty_name', $request['orty_name'])
            ->first();
        if (empty($list_data)) {
            $add_data['orty_shop_id'] = $user_info->adm_shop_id;
            $add_data['orty_name'] = $request['orty_name'];
            $add_data['orty_create_id'] = $user_info->adm_id;
            $find_order_type = DB::table('order_type')
                ->where('orty_shop_id', $user_info->adm_shop_id)
                ->where('orty_state', 1)
                ->count();
            if ($find_order_type >= 5) {
                return ['code'=>500, 'msg'=>'同时启用的分类不能大于5个，请停用其他分类', 'data'=>''];
            }
            $add_data['orty_create_name'] = $user_info->adm_name;
            $add_data['orty_create_time'] = date('Y-m-d H:i:s');
            $res = DB::table('order_type')->insert($add_data);
            
            return ['code'=>200, 'msg'=>'添加成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'此类型已存在，请勿重复添加！', 'data'=>''];
        }
    }

    /**
     * 订单类型编辑
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-29
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function editOrderType($user_info,$request) {
        $list_data = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
            ->where('orty_name', $request['orty_name'])
            ->where('orty_id', '!=', $request['orty_id'])
            ->first();
        if (empty($list_data)) {
            $update_data['orty_name'] = $request['orty_name'];
            $update_data['orty_update_name'] = $user_info->adm_name;
            $update_data['orty_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('order_type')->where('orty_id', $request['orty_id'])->update($update_data);
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'此类型已存在，请勿重复！', 'data'=>''];
        }
    }

    /**
     * 订单类型开启
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-29
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function startOrderType($user_info,$request) {
        $find_order_type = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
            ->where('orty_state', 1)
            ->count();
        if ($find_order_type >= 5) {
            return ['code'=>500, 'msg'=>'同时启用的分类不能大于5个', 'data'=>''];
        }
        $update_data['orty_state'] = 1;
        $update_data['orty_update_name'] = $user_info->adm_name;
        $update_data['orty_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('order_type')->where('orty_id', $request['orty_id'])->update($update_data);
        return ['code'=>200, 'msg'=>'启用成功', 'data'=>''];
    }

    /**
     * 订单类型关闭
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-29
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function stopOrderType($user_info,$request) {
        $find_stop = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
            ->where('orty_id', '<>', $request['orty_id'])
            ->where('orty_state', 1)
            ->exists();
        if (!$find_stop) {
            return ['code'=>500, 'msg'=>'停用后将无可用类型，不可停用', 'data'=>''];
        }
        $update_data['orty_state'] = 2;
        $update_data['orty_update_name'] = $user_info->adm_name;
        $update_data['orty_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('order_type')->where('orty_id', $request['orty_id'])->update($update_data);
        return ['code'=>200, 'msg'=>'停用成功', 'data'=>''];
    }

    /**
     * 订单类型设置默认
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2025-02-19
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function setUpDefault($user_info,$request) {
        $order_type = DB::table('order_type')->where('orty_id', $request['orty_id'])->value('orty_default');
        $orty_default = DB::table('order_type')
            ->where('orty_shop_id', $user_info->adm_shop_id)
            ->update(['orty_default'=>2]);
        if($order_type==2) {
            $update_data['orty_default'] = 1;
            $update_data['orty_update_name'] = $user_info->adm_name;
            $update_data['orty_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('order_type')->where('orty_id', $request['orty_id'])->update($update_data);
        }
        return ['code'=>200, 'msg'=>'设置默认成功', 'data'=>''];
    }


    /**
     * 获取会员及会员卡
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-09-25
     * @param  [type]           $user_info [description]
     * @param  [type]           $request   [description]
     * @return [type]                      [description]
     */
    public static function getMemberAndMyVip($user_info,$request) {
        $find_mem = [];
        if (!empty($request['mem_phone'])) {
            $find_mem = DB::table('member')
                ->where(function ($query) use ($request) {
                    if (!empty($request['mem_phone'])) {
                        $query->where('mem_phone', $request['mem_phone']);
                    }
                })
                // ->select('mem_id', 'mem_phone', 'mem_name', 'mem_address', 'mem_province', 'mem_city', 'mem_county', 'mem_car_series')
                ->first();
        }

        if (!empty($request['meca_car_num'])) {
            $find_mem = DB::table('member_car')
                ->leftJoin('member', 'mem_id', '=', 'meca_mem_id')
                ->where(function ($query) use ($request) {
                    if (!empty($request['meca_car_num'])) {
                        $query->where('meca_car_num', $request['meca_car_num']);
                    }
                })
                ->select('mem_id', 'mem_phone', 'mem_name', 'mem_car_num')
                ->first();
        }
        $find_myvip = [];
        if (!empty($find_mem)) {
            $find_mem->ord_type = 1;
            $find_myvip = DB::table('myvip')
                ->where('myvi_state', 1)
                ->where('myvi_adm_id', $find_mem->mem_id)
                ->get();
            if ($find_myvip) {
                foreach ($find_myvip as $key => $value) {
                    $find_myvip_detail = DB::table('myvip_detail')
                        ->where('myvid_mvid', $value->myvi_id)
                        ->where('myvid_surplus_times','>', 0)
                        ->get()->toArray();
                    foreach ($find_myvip_detail as $kk => $vv) {
                        if ($vv->myvid_type == 1) {
                            $goo_unit = DB::table('goods')
                                ->where('goo_id', $vv->myvid_data_id)
                                ->select('goo_unit', 'goo_unta_id')
                                ->first();
                            $find_myvip_detail[$kk]->goo_unit = $goo_unit ? $goo_unit->goo_unit : '';
                            $find_myvip_detail[$kk]->goo_unta_id = $goo_unit ? $goo_unit->goo_unta_id : '';
                        } else {
                            $find_myvip_detail[$kk]->goo_unit = '次';
                            $find_myvip_detail[$kk]->goo_unta_id = '';
                        }
                        $find_myvip_detail[$kk]->use_num = 1;
                    }
                    $find_myvip[$key]->myvip_detail = $find_myvip_detail;
                }
            }
        }
        $data['member'] = $find_mem;
        $data['myvip'] = $find_myvip;
        return ['code'=>200,'msg'=>'success', 'data'=> $data];
    }

    /**
     * 订单挂起
     */
    public static function suspended($user_info,$request) {
        $data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_state', 'ord_wor_state', 'ord_id')
            ->first();
        $data = CommonService::dataToArray($data);
        if ($data) {
            if (in_array($data['ord_wor_state'], [4,20])) {
                return ['code'=>500,'msg'=>'订单已完成状态，不可挂起', 'data'=> $data];
            }
            $update_data['ord_suspended'] = 1;
            $update_data['ord_suspended_time'] = date('Y-m-d H:i:s', strtotime('+2 day'));
            $update_res = DB::table('order')->where('ord_id', $request['ord_id'])->update($update_data);
            if ($update_res) {
                return ['code'=>200,'msg'=>'挂起成功', 'data'=> $data];
            } else {
                return ['code'=>500,'msg'=>'挂起失败', 'data'=> ''];
            }
        } else {
            return ['code'=>500,'msg'=>'查询订单失败', 'data'=> ''];
        }
    }

    /**
     * 订单挂起-恢复
     */
    public static function cancelSuspended($user_info,$request) {
        $data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_state', 'ord_wor_state', 'ord_id', 'ord_suspended')
            ->first();
        $data = CommonService::dataToArray($data);
        if ($data) {
            if ($data['ord_suspended'] == 2) {
                return ['code'=>500,'msg'=>'订单已恢复', 'data'=> $data];
            }
            $update_data['ord_suspended'] = 2;
            // $update_data['ord_suspended_time'] = date('Y-m-d H:i:s', strtotime('+2 day'));
            $update_res = DB::table('order')->where('ord_id', $request['ord_id'])->update($update_data);
            if ($update_res) {
                return ['code'=>200,'msg'=>'恢复成功', 'data'=> $data];
            } else {
                return ['code'=>500,'msg'=>'恢复失败', 'data'=> ''];
            }
        } else {
            return ['code'=>500,'msg'=>'查询订单失败', 'data'=> ''];
        }
    }

    /**
     * 基础设置-需要审核的订单金额
     */
    public static function basicSet($user_info,$request) {
        if($request['type'] == 1) {
            $data = DB::table('basic_settings')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        } else {
            $data = DB::table('basic_settings')
                ->where('shop_id', $user_info->adm_shop_id)
                ->first();
            if ($data) {
                $data = DB::table('basic_settings')
                    ->where('shop_id', $user_info->adm_shop_id)
                    ->update(['order_amount'=>$request['order_amount']*100]);
            } else {
                if (!isset($request['order_amount'])) {
                    return ['code'=>500, 'msg'=>'参数错误', 'data'=>''];
                }
                $add_data['shop_id'] = $user_info->adm_shop_id;
                $add_data['order_amount'] = $request['order_amount']*100;
                $data = DB::table('basic_settings')->insertGetId($add_data);
            }
            return ['code'=>200, 'msg'=>'success', 'data'=>$data];
        }
    }

    /**
     * 开票
     */
    public static function openBill($user_info,$request) {
        $find_order = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_openbill')
            ->first();
        if ($find_order && $find_order->ord_openbill == 2) {
            return ['code'=>500,'msg'=>'订单已开票', 'data'=> ''];
        }

        if (empty($request['ord_openbill_number']) && empty($request['ord_openbill_image'])) {
            return ['code'=>500,'msg'=>'请上传发票号或凭证', 'data'=> ''];
        }
        $update_data['ord_openbill'] = 2;
        if (!empty($request['ord_openbill_number'])) {
            $update_data['ord_openbill_number'] = $request['ord_openbill_number'];
        }

        if (!empty($request['ord_openbill_image'])) {
            $update_data['ord_openbill_image'] = $request['ord_openbill_image'];
        }
        $update_data['ord_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($update_data);
        if ($update_res) {
            return ['code'=>200, 'msg'=>'开票成功', 'data'=>[]];
        } else {
            return ['code'=>500, 'msg'=>'开票失败', 'data'=>[]];
        }
    }

    /**
     * 取消订单审核
     */
    public static function auditCancel($user_info, $request) {
        $now_time = date('Y-m-d H:i:s');

        if ($request['pass'] == 1) {
            // 审核通过
            // 验证当前订单下工单是否已经全部取消
            $all_work = DB::table('work_order')
                ->where('wor_order_id', $request['ord_id'])
                ->select('wor_delete', 'wor_id')
                ->get();
            $work_order = new WorkOrders();
            foreach ($all_work as $key => $value) {
                $find_work1 = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wor_id', $value->wor_id)
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->select('wor_number', 'wor_state', 'wor_order_id', 'wor_goo_amount', 'wor_type', 'wor_actual_price', 'wor_ware_id', 'wor_remark', 'wor_pass', 'wor_service_type', 'wor_type', 'wocl_client_id', 'wocl_sd_virtual_type', 'wocl_wor_type', 'wor_order_number', 'wor_delete')
                    ->first();
                if ($value->wor_delete == 1) {
                    $request['wor_id'] = $value->wor_id;
                    $return_data = $work_order->deletes($user_info, $request, $find_work1);
                    if ($return_data['code'] != 200) {
                        return $return_data;
                    }
                }
            }
            $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
            $ord_data['ord_payment_way'] = 0; //结算方式
            $ord_data['ord_actual_price'] = 0; //结算金额
            $ord_data['ord_zero_price'] = 0; //优惠金额
            $ord_data['ord_settlement_time'] = ''; //结算时间
            $ord_data['ord_state'] = 1; //结算状态1未结算2已结算
            $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中4已完成7待接单11取消订单
            $ord_data['ord_update_time'] = $now_time;
            $ord_res = DB::table('order')
                ->where('ord_id', $request['ord_id'])
                ->update($ord_data);
            DB::table('cancel_order_data')
                ->where('ord_id', $request['ord_id'])
                ->where('state', 1)
                ->update(['state'=>2]);
        } else {
            $wor_data['wor_state'] = 5; //11取消待审核
            $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_res = DB::table('work_order')
                ->where('wor_order_id', $request['ord_id'])
                ->update($wor_data);
            $ord_data['ord_wor_state'] = 2; //订单的工单状态1未派工单2服务中4已完成7待接单11取消订单
            $ord_data['ord_update_time'] = $now_time;
            $ord_res = DB::table('order')
                ->where('ord_id', $request['ord_id'])
                ->update($ord_data);
            DB::table('cancel_order_data')
                ->where('ord_id', $request['ord_id'])
                ->where('state', 1)
                ->update(['state'=>3,'reject_remark'=>$request['remark']]);
        }

        return ['code'=>200, 'msg'=>'审核成功','data'=>''];
    }
}
