<?php

namespace App\Services\BasicManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\BasicManagement\ProductionManage;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\BasicManagement\ProductionManageValidator;
use BlueCity\Core\Inc\ErrorInc;

// 基础管理-作品管理
class ProductionManageService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new ProductionManage();
        $this->mainValidator = new ProductionManageValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        // 作品管理表
        $list_data = DB::table('wash_production_manage')
            // ->where('prma_cid', $user_info->adm_cid)
            ->where('prma_shop_id', $user_info->adm_shop_id)
            ->where('prma_type', $search_data['type'])
            ->where('prma_delete', 1) //是否删除：1正常2已删除
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['name'])) {
                    $query->where('prma_name', 'like', '%' . $search_data['name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //状态1启用2停用
                if (!empty($search_data['state'])) {
                    $query->where('prma_state', $search_data['state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['classify_prma_id'])) { //所属分类id
                    $query->where('prma_parent_id', $search_data['classify_prma_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['remark'])) {
                    $query->where('prma_remark', 'like', '%' . $search_data['remark'] . '%');
                }
            })
            ->select('prma_id', 'prma_name', 'prma_parent_id', 'prma_type', 'prma_state', 'prma_remark', 'prma_image', 'prma_sequence')
            ->orderBy('prma_sequence', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $parent_data = [];
        if ($list_items) {
            $prma_parent_id = array_filter(array_unique(array_column($list_items, 'prma_parent_id'))); //作品分类id
            if ($prma_parent_id) {
                // 查询上级作品分类数据
                $parent_data = DB::table('wash_production_manage')
                    ->where('prma_shop_id', $user_info->adm_shop_id)
                    ->whereIn('prma_id', $prma_parent_id)
                    ->select('prma_id', 'prma_name')
                    ->get()->toArray();
            }
            foreach ($list_items as $key => $value) {
                $list_items[$key]->prma_image = addHttpurl($value->prma_image);
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['parent_data'] = $parent_data;                        //上级数据
        return $data;
    }

    /**
     * 检查是不是存在同名内容
     * @param $name 待检测名称
     * @param $type 类型：1作品分类2作品模块3视频4图文
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function nameExists($user_info, $request, $id = 0)
    {
        if ($id == 0) {
            return ProductionManage::where('prma_cid', $user_info->adm_cid)
                ->where('prma_shop_id', $user_info->adm_shop_id)
                ->where('prma_type', $request['type'])
                ->where('prma_name', $request['name'])
                ->where('prma_delete', 1) //是否删除：1正常2已删除
                ->exists();
        } else {
            return ProductionManage::where('prma_cid', $user_info->adm_cid)
                ->where('prma_shop_id', $user_info->adm_shop_id)
                ->where('prma_type', $request['type'])
                ->where('prma_name', $request['name'])
                ->where('prma_delete', 1) //是否删除：1正常2已删除
                ->where('prma_id', '<>', $id)
                ->exists();
        }
    }

    // 新增
    public static function add($user_info, $request)
    {
        $data['prma_cid'] = $user_info->adm_cid;
        $data['prma_superior_shop_id'] = $user_info->adm_shop_id;
        $data['prma_shop_id'] = $user_info->adm_shop_id;
        $data['prma_name'] = $request['name']; //分类名，模块名
        $data['prma_type'] = $request['type']; //类型：1作品分类2作品模块
        // if (!empty($request['classify_prma_id'])) { //所属分类id
        //     $data['prma_parent_id'] = $request['classify_prma_id'];
        // }
        if (!empty($request['remark'])) { //备注
            $data['prma_remark'] = $request['remark'];
        }
        if (!empty($request['prma_image'])) { //图片路径
            $data['prma_image'] = $request['prma_image'];
        }
        if (!empty($request['prma_sequence'])) { //序号
            $data['prma_sequence'] = $request['prma_sequence'];
        }
        $data['prma_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_production_manage')->insert($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    // 编辑
    public static function edit($user_info, $request)
    {
        $data['prma_cid'] = $user_info->adm_cid;
        $data['prma_superior_shop_id'] = $user_info->adm_shop_id;
        $data['prma_shop_id'] = $user_info->adm_shop_id;
        $data['prma_name'] = $request['name']; //分类名，模块名
        $data['prma_type'] = $request['type']; //类型：1作品分类2作品模块
        // if (!empty($request['classify_prma_id'])) { //所属分类id
        //     $data['prma_parent_id'] = $request['classify_prma_id'];
        // }
        if (!empty($request['remark'])) { //备注
            $data['prma_remark'] = $request['remark'];
        } else {
            $data['prma_remark'] = '';
        }
        if (!empty($request['prma_image'])) { //图片路径
            $data['prma_image'] = $request['prma_image'];
        }
        if (!empty($request['prma_sequence'])) { //序号
            $data['prma_sequence'] = $request['prma_sequence'];
        }
        $data['prma_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_production_manage')
            ->where('prma_shop_id', $user_info->adm_shop_id)
            ->where('prma_type', $request['type'])
            ->where('prma_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>''];
        }
    }

    /**
     * [getFieldsByIdAll 根据id查询数据]
     * @param  [object] $user_info [用户信息]
     * @param  [array] $ids       [数组，id]
     * @param  array $fields    [数组，查询字段]
     * @return [type]            [description]
     */
    public static function getFieldsByIdAll($user_info, $request, $fields = '*')
    {
        $entity = ProductionManage::whereIn('prma_id', $request['id'])
            ->where('prma_shop_id', $user_info->adm_shop_id)
            ->where('prma_type', $request['type'])
            ->where('prma_delete', 1)
            ->select($fields)
            ->get()->toArray();
        return $entity;
    }

    // 启用
    public static function start($user_info, $request)
    {
        $data['prma_state'] = 1; //状态1启用2停用
        $data['prma_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_production_manage')
            ->where('prma_shop_id', $user_info->adm_shop_id)
            ->where('prma_type', $request['type'])
            ->whereIn('prma_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'启用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'启用失败', 'data'=>''];
        }
    }

    // 停用
    public static function stop($user_info, $request)
    {
        $data['prma_state'] = 2; //状态1启用2停用
        $data['prma_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_production_manage')
            ->where('prma_shop_id', $user_info->adm_shop_id)
            ->where('prma_type', $request['type'])
            ->whereIn('prma_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'停用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'停用失败', 'data'=>''];
        }
    }

    // 删除
    public static function remove($user_info, $request)
    {
        $data['prma_delete'] = 2; //是否删除：1正常2已删除
        $data['prma_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_production_manage')
            ->where('prma_shop_id', $user_info->adm_shop_id)
            ->where('prma_type', $request['type'])
            ->whereIn('prma_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'删除失败', 'data'=>''];
        }
    }
}
