<?php

namespace App\Services\BasicManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\BasicManagement\GradeProfessional;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\BasicManagement\GradeProfessionalValidator;
use BlueCity\Core\Inc\ErrorInc;

class GradeProfessionalService extends Model
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new GradeProfessional();
        $this->mainValidator = new GradeProfessionalValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        // 作品管理表
        $list_data = DB::table('wash_grade_professional')
            ->where('grpr_shop_id', $user_info->adm_shop_id)
            ->where('grpr_delete', 1) //是否删除：1正常2已删除
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['name'])) {
                    $query->where('grpr_name', 'like', '%' . $search_data['name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //状态1启用2停用
                if (!empty($search_data['state'])) {
                    $query->where('grpr_state', $search_data['state']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['remark'])) {
                    $query->where('grpr_remark', 'like', '%' . $search_data['remark'] . '%');
                }
            })
            ->select('grpr_id', 'grpr_name', 'grpr_state', 'grpr_remark', 'grpr_create_time')
            ->orderBy('grpr_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    /**
     * 检查是不是存在同名内容
     * @param $name 待检测名称
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function nameExists($user_info, $request, $id = 0)
    {
        if ($id == 0) {
            return GradeProfessional::where('grpr_shop_id', $user_info->adm_shop_id)
                // ->where('grpr_cid', $user_info->adm_cid)
                ->where('grpr_name', $request['name'])
                ->where('grpr_delete', 1) //是否删除：1正常2已删除
                ->exists();
        } else {
            return GradeProfessional::where('grpr_shop_id', $user_info->adm_shop_id)
                // ->where('grpr_cid', $user_info->adm_cid)
                ->where('grpr_name', $request['name'])
                ->where('grpr_delete', 1) //是否删除：1正常2已删除
                ->where('grpr_id', '<>', $id)
                ->exists();
        }
    }

    // 新增
    public static function add($user_info, $request)
    {
        $data['grpr_cid'] = $user_info->adm_cid;
        $data['grpr_superior_shop_id'] = $user_info->adm_shop_id;
        $data['grpr_shop_id'] = $user_info->adm_shop_id;
        $data['grpr_name'] = $request['name']; //职称名称
        if (!empty($request['remark'])) { //备注
            $data['grpr_remark'] = $request['remark'];
        }
        $data['grpr_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_professional')->insert($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    // 编辑
    public static function edit($user_info, $request)
    {
        $data['grpr_cid'] = $user_info->adm_cid;
        $data['grpr_superior_shop_id'] = $user_info->adm_shop_id;
        $data['grpr_shop_id'] = $user_info->adm_shop_id;
        $data['grpr_name'] = $request['name']; //职称名称
        if (!empty($request['remark'])) { //备注
            $data['grpr_remark'] = $request['remark'];
        } else {
            $data['grpr_remark'] = '';
        }
        $data['grpr_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_professional')
            ->where('grpr_shop_id', $user_info->adm_shop_id)
            ->where('grpr_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>''];
        }
    }

    /**
     * [getFieldsByIdAll 根据id查询数据]
     * @param  [object] $user_info [用户信息]
     * @param  [array] $ids       [数组，id]
     * @param  array $fields    [数组，查询字段]
     * @return [type]            [description]
     */
    public static function getFieldsByIdAll($user_info, $request, $fields = '*')
    {
        $entity = GradeProfessional::whereIn('grpr_id', $request['id'])
            ->where('grpr_shop_id', $user_info->adm_shop_id)
            ->where('grpr_delete', 1)
            ->select($fields)
            ->get()->toArray();
        return $entity;
    }

    // 启用
    public static function start($user_info, $request)
    {
        $data['grpr_state'] = 1; //状态1启用2停用
        $data['grpr_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_professional')
            ->where('grpr_shop_id', $user_info->adm_shop_id)
            ->whereIn('grpr_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'启用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'启用失败', 'data'=>''];
        }
    }

    // 停用
    public static function stop($user_info, $request)
    {
        $data['grpr_state'] = 2; //状态1启用2停用
        $data['grpr_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_professional')
            ->where('grpr_shop_id', $user_info->adm_shop_id)
            ->whereIn('grpr_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'停用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'停用失败', 'data'=>''];
        }
    }

    // 删除
    public static function remove($user_info, $request)
    {
        $data['grpr_delete'] = 2; //是否删除：1正常2已删除
        $data['grpr_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_professional')
            ->where('grpr_shop_id', $user_info->adm_shop_id)
            ->whereIn('grpr_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'删除失败', 'data'=>''];
        }
    }
}
