<?php

namespace App\Services\BasicManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\BasicManagement\GradeLevel;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\BasicManagement\GradeLevelValidator;
use BlueCity\Core\Inc\ErrorInc;

class GradeLevelService extends Model
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new GradeLevel();
        $this->mainValidator = new GradeLevelValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10)
    {
        // 级别表
        $list_data = DB::table('wash_grade_level')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->where('grle_delete', 1) //是否删除：1正常2已删除
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['name'])) {
                    $query->where('grle_name', 'like', '%' . $search_data['name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//状态1启用2停用
                if (!empty($search_data['state'])) {
                    $query->where('grle_state', $search_data['state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['grpr_id'])) {//所属职称id
                    $query->where('grle_grpr_id', $search_data['grpr_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //备注
                if (!empty($search_data['remark'])) {
                    $query->where('grle_remark', 'like', '%' . $search_data['remark'] . '%');
                }
            })
            ->select('grle_id', 'grle_grpr_id', 'grle_name', 'grle_state', 'grle_remark', 'grle_create_time')
            ->orderBy('grle_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $parent_data = [];
        if ($list_items) {
            $grle_parent_id = array_filter(array_unique(array_column($list_items, 'grle_grpr_id'))); //职级id
            if ($grle_parent_id) {
                // 查询上级数据
                $parent_data = DB::table('wash_grade_professional')
                    ->where('grpr_shop_id', $user_info->adm_shop_id)
                    ->whereIn('grpr_id', $grle_parent_id)
                    ->select('grpr_id', 'grpr_name')
                    ->get()->toArray();
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['parent_data'] = $parent_data;                        //上级数据
        return $data;
    }

    // 详情
    public static function info($user_info, $request)
    {
        $find_data = DB::table('wash_grade_level')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->where('grle_type', $request['type'])
            ->where('grle_id', $request['id'])
            ->where('grle_delete', 1) //是否删除：1正常2已删除
            ->select('grle_id', 'grle_classify_prma_id', 'grle_module_prma_id', 'grle_name', 'grle_type', 'grle_state', 'grle_content', 'grle_path', 'grle_remark')
            ->first();
        if (empty($find_data)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'未查到数据', 'data'=>''];
        }

        $grle_classify_prma_id = array_filter(array_unique(array_column($find_data, 'grle_classify_prma_id'))); //作品分类id
        $grle_module_prma_id = array_filter(array_unique(array_column($find_data, 'grle_module_prma_id'))); //作品模块
        $grle_parent_id = array_unique(array_merge($grle_classify_prma_id, $grle_module_prma_id));
        $parent_data = [];
        if ($grle_parent_id) {
            // 查询上级作品分类数据
            $parent_data = DB::table('wash_production_manage')
                ->where('grle_shop_id', $user_info->adm_shop_id)
                ->whereIn('grle_id', $grle_parent_id)
                ->select('grle_id', 'grle_name')
                ->get()->toArray();
        }
        $data['data'] = $find_data;
        $data['parent_data'] = $parent_data;
        return ['code'=>500, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * 检查是不是存在同名内容
     * @param $name 待检测名称
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function nameExists($user_info, $request, $id = 0) {
        if ($id == 0) {
            return GradeLevel::where('grle_shop_id', $user_info->adm_shop_id)
                // ->where('grle_cid', $user_info->adm_cid)
                ->where('grle_grpr_id', $request['grpr_id'])
                ->where('grle_name', $request['name'])
                ->where('grle_delete', 1) //是否删除：1正常2已删除
                ->exists();
        } else {
            return GradeLevel::where('grle_shop_id', $user_info->adm_shop_id)
                // ->where('grle_cid', $user_info->adm_cid)
                ->where('grle_grpr_id', $request['grpr_id'])
                ->where('grle_name', $request['name'])
                ->where('grle_delete', 1) //是否删除：1正常2已删除
                ->where('grle_id', '<>', $id)
                ->exists();
        }
    }

    // 新增
    public static function add($user_info, $request)
    {
        $data['grle_cid'] = $user_info->adm_cid;
        $data['grle_superior_shop_id'] = $user_info->adm_shop_id;
        $data['grle_shop_id'] = $user_info->adm_shop_id;
        $data['grle_name'] = $request['name'];//级别
        if (!empty($request['grpr_id'])) {//所属职称id
            $data['grle_grpr_id'] = $request['grpr_id'];
        }
        if (!empty($request['remark'])) {//备注
            $data['grle_remark'] = $request['remark'];
        } else {
            $data['grle_remark'] = '';
        }
        $data['grle_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_level')->insert($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'新增成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'新增失败', 'data'=>''];
        }
    }

    // 编辑
    public static function edit($user_info, $request)
    {
        $data['grle_cid'] = $user_info->adm_cid;
        $data['grle_superior_shop_id'] = $user_info->adm_shop_id;
        $data['grle_shop_id'] = $user_info->adm_shop_id;
        $data['grle_name'] = $request['name'];//级别
        if (!empty($request['grpr_id'])) {//所属职称id
            $data['grle_grpr_id'] = $request['grpr_id'];
        }
        if (!empty($request['remark'])) {//备注
            $data['grle_remark'] = $request['remark'];
        } else {
            $data['grle_remark'] = '';
        }
        $data['grle_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_level')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->where('grle_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'编辑成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'编辑失败', 'data'=>''];
        }
    }
    
    /**
     * [getFieldsByIdAll 根据id查询数据]
     * @param  [object] $user_info [用户信息]
     * @param  [array] $ids       [数组，id]
     * @param  array $fields    [数组，查询字段]
     * @return [type]            [description]
     */
    public static function getFieldsByIdAll($user_info, $request, $fields = '*') {
    	$entity = GradeLevel::whereIn('grle_id', $request['id'])
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->where('grle_delete', 1)
            ->select($fields)
            ->get()->toArray();
        return $entity;
    }

    // 获取级别
    public static function getGradeLevel($user_info, $search_data, $show_count = 10) 
    {
        // 级别表
        $list_data = DB::table('wash_grade_level as a')
            ->leftJoin('wash_grade_professional as b', 'a.grle_grpr_id', '=', 'b.grpr_id')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->where('grle_delete', 1) //是否删除：1正常2已删除
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['name'])) {
                    $query->where('grle_name', 'like', '%' . $search_data['name'] . '%')
                    ->Orwhere('grpr_name', 'like', '%' . $search_data['name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {//状态1启用2停用
                if (!empty($search_data['state'])) {
                    $query->where('grle_state', $search_data['state']);
                }
            })
            ->select('grle_id', 'grle_name', 'grpr_name')
            ->orderBy('grle_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 启用
    public static function start($user_info, $request)
    {
        $data['grle_state'] = 1;//状态1启用2停用
        $data['grle_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_level')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->whereIn('grle_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'启用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'启用失败', 'data'=>''];
        }
    }

    // 停用
    public static function stop($user_info, $request)
    {
        $data['grle_state'] = 2;//状态1启用2停用
        $data['grle_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_level')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->whereIn('grle_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'停用成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'停用失败', 'data'=>''];
        }
    }

    // 删除
    public static function remove($user_info, $request)
    {
        $data['grle_delete'] = 2;//是否删除：1正常2已删除
        $data['grle_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('wash_grade_level')
            ->where('grle_shop_id', $user_info->adm_shop_id)
            ->whereIn('grle_id', $request['id'])
            ->update($data);
        if ($res) {
            return ['code'=>200, 'msg'=>'删除成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'删除失败', 'data'=>''];
        }
    }
}
