<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 工单列表验证器
class WashWorkValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 签名验证器
    public function signatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 审核查看验证器
    public function checkShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
    
    // 审核验证器
    public function checkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'pass.required' => '参数类型错误',
            'pass.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'pass' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 预约设置验证器，技师小程序预约设置使用
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'appoint_time.required' => '请选择时间',
            'appoint_time.date' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-首页
    public function homeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '请输入技师id',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-首页
    public function planAppointTimeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '请输入技师id',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-首页派单
    public function dispatchListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-验车验证器
    public function validateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'orvc_mileage.required_if' => '请输入进店里程数',
            'orvc_mileage.integer' => '参数错误',
            'orvc_mileage.min' => '参数错误',
            'orvc_film_roll_number.required_if' => '请输入膜卷号',
            'orvc_film_roll_number.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'wor_id' => 'required|integer|min:1',
            'orvc_mileage' => 'required_if:type,2|integer|min:0',
            // 'orvc_film_roll_number' => 'required_if:type,2|max:80',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-施工完成提交
    public function accomplishValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'wocl_service_quality.required' => '参数错误',
            // 'wotp_service_performance.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'wocl_service_quality' => 'required|',
            // 'wotp_service_performance' => 'required|',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-施工提交
    public function submitConstructionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'woch_part_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'woch_part_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-质检
    public function qualityTestingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'type.required' => '请输入工单id',
            'type.integer' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-接单提交
    public function receiveSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'receive_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'receive_data' => 'required|',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 工单-重新派单
    public function assignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'adm_id.required' => '请选择技师',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 获取绩效基础金额
    public function getMeritPayValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'choose_type.required' => '请输入工单id',
            'choose_type.integer' => '参数类型错误',
            'choose_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'choose_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 绩效管理-获取车型验证器
    public function getMeritPayCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pema_type.required' => '参数类型错误',
            'pema_type.in' => '参数类型错误',
            'pema_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pema_name' => 'sometimes|nullable|max:20',//查询名称
            'pema_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 验证绩效金额
    public function checkMeritPay($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'choose_type.required' => '请输入工单id',
            'choose_type.integer' => '参数类型错误',
            'choose_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'choose_type' => [
                'required',
                Rule::in(['2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
