<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class QualityTestingValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 质量奖惩管理-列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'qurp_type.required' => '参数类型错误',
            'qurp_type.array' => '参数类型错误',
            'qurp_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',//权限id
            'qurp_name' => 'sometimes|nullable|max:20',//查询名称
            'qurp_type' => 'required|array',//查询类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'qurp_type.required' => '参数类型错误',
            'qurp_type.in' => '参数类型错误',
            'qurp_standard_type.required' => '参数类型错误',
            'qurp_standard_type.in' => '参数类型错误',
            'qurp_name.required' => '请输入异常名称',
            'qurp_name.max' => '参数类型错误',
            'qurp_remark.max' => '参数类型错误',
            'qurp_standard.required' => '请输入标准金额',
            'qurp_standard.numeric' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'qurp_remark' => 'sometimes|nullable|max:255',//备注
            'qurp_name' => 'required|max:20',//名称
            'qurp_standard' => 'required|numeric',//标准金额(单位分)/分数
            'qurp_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'qurp_standard_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑展示数据
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'qurp_id.required' => '参数类型错误',
            'qurp_id.integer' => '参数类型错误',
            'qurp_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'qurp_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'qurp_type.required' => '参数类型错误',
            'qurp_type.in' => '参数类型错误',
            'qurp_standard_type.required' => '参数类型错误',
            'qurp_standard_type.in' => '参数类型错误',
            'qurp_id.required' => '参数类型错误',
            'qurp_id.integer' => '参数类型错误',
            'qurp_id.min' => '参数类型错误',
            'qurp_name.required' => '请输入异常名称',
            'qurp_name.max' => '参数类型错误',
            'qurp_remark.max' => '参数类型错误',
            'qurp_standard.required' => '请输入标准金额',
            'qurp_standard.numeric' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'qurp_id' => 'required|integer|min:1',
            'qurp_remark' => 'sometimes|nullable|max:255',//备注
            'qurp_name' => 'required|max:20',//名称
            'qurp_standard' => 'required|numeric',//标准金额(单位分)/分数
            'qurp_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'qurp_standard_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 启用
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'qurp_id.required' => '参数类型错误',
            'qurp_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'qurp_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
