<?php

namespace App\Http\Requests\Validators\WeChatApplet\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class UserAddressValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            // 'type.required' => '参数类型错误',
            // 'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            // 'type' => [
            //     'required',
            //     Rule::in(['1', '2']),
            // ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 搜索记录验证器
    public function searchRecordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'province.required' => '请输入省',
            'city.required' => '请输入市',
            'county.required' => '请输入县',
            'address.max' => '请输入地址',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'province' => 'sometimes|max:50',
            'city' => 'sometimes|max:50',
            'county' => 'sometimes|max:50',
            'address' => 'sometimes|null|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
